/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.thoughtworks.xstream.io.xml.XppReader;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OfflineViewParseUtil {
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String MODULE = "module";

    private OfflineViewParseUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<OfflineProblemDescriptor>> parse(String problems) {
        TObjectIntHashMap fqName2IdxMap = new TObjectIntHashMap();
        THashMap package2Result = new THashMap();
        try (XppReader reader = new XppReader((Reader)new StringReader(problems));){
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                OfflineProblemDescriptor descriptor2 = new OfflineProblemDescriptor();
                boolean added = false;
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("entry_point".equals(reader.getNodeName())) {
                        descriptor2.setType(reader.getAttribute("TYPE"));
                        String fqName = reader.getAttribute("FQNAME");
                        descriptor2.setFQName(fqName);
                        if (!fqName2IdxMap.containsKey((Object)fqName)) {
                            fqName2IdxMap.put((Object)fqName, 0);
                        }
                        int idx = fqName2IdxMap.get((Object)fqName);
                        descriptor2.setProblemIndex(idx);
                        fqName2IdxMap.put((Object)fqName, idx + 1);
                    }
                    if (DESCRIPTION.equals(reader.getNodeName())) {
                        descriptor2.setDescription(reader.getValue());
                    }
                    if (LINE.equals(reader.getNodeName())) {
                        descriptor2.setLine(Integer.parseInt(reader.getValue()));
                    }
                    if (MODULE.equals(reader.getNodeName())) {
                        descriptor2.setModule(reader.getValue());
                    }
                    if (HINTS.equals(reader.getNodeName())) {
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            ArrayList<String> hints = descriptor2.getHints();
                            if (hints == null) {
                                hints = new ArrayList<String>();
                                descriptor2.setHints(hints);
                            }
                            hints.add(reader.getAttribute("value"));
                            reader.moveUp();
                        }
                    }
                    if (PACKAGE.equals(reader.getNodeName())) {
                        OfflineViewParseUtil.appendDescriptor((Map<String, Set<OfflineProblemDescriptor>>)package2Result, reader.getValue(), descriptor2);
                        added = true;
                    }
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (PACKAGE.equals(reader.getNodeName())) {
                            OfflineViewParseUtil.appendDescriptor((Map<String, Set<OfflineProblemDescriptor>>)package2Result, reader.getValue(), descriptor2);
                            added = true;
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                }
                if (!added) {
                    OfflineViewParseUtil.appendDescriptor((Map<String, Set<OfflineProblemDescriptor>>)package2Result, "", descriptor2);
                }
                reader.moveUp();
            }
        }
        return package2Result;
    }

    private static void appendDescriptor(Map<String, Set<OfflineProblemDescriptor>> package2Result, String packageName, OfflineProblemDescriptor descriptor2) {
        THashSet descriptors = package2Result.get(packageName);
        if (descriptors == null) {
            descriptors = new THashSet();
            package2Result.put(packageName, (Set<OfflineProblemDescriptor>)descriptors);
        }
        descriptors.add((OfflineProblemDescriptor)descriptor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String parseProfileName(String descriptors) {
        try (XppReader reader = new XppReader((Reader)new StringReader(descriptors));){
            String string = reader.getAttribute("profile");
            return string;
        }
    }
}

