/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorRegistryImpl
extends ExecutorRegistry
implements Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(ExecutorRegistryImpl.class);
    @NonNls
    public static final String RUNNERS_GROUP = "RunnerActions";
    @NonNls
    public static final String RUN_CONTEXT_GROUP = "RunContextGroupInner";
    private List<Executor> myExecutors = new ArrayList<Executor>();
    private ActionManager myActionManager;
    private final Map<String, Executor> myId2Executor = new THashMap();
    private final Set<String> myContextActionIdSet = new THashSet();
    private final Map<String, AnAction> myId2Action = new THashMap();
    private final Map<String, AnAction> myContextActionId2Action = new THashMap();
    private final Set<Trinity<Project, String, String>> myInProgress = Collections.synchronizedSet(new THashSet());

    public ExecutorRegistryImpl(ActionManager actionManager) {
        this.myActionManager = actionManager;
    }

    synchronized void initExecutor(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(0);
        }
        if (this.myId2Executor.get(executor.getId()) != null) {
            LOG.error("Executor with id: \"" + executor.getId() + "\" was already registered!");
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        this.myExecutors.add(executor);
        this.myId2Executor.put(executor.getId(), executor);
        this.myContextActionIdSet.add(executor.getContextActionId());
        this.registerAction(executor.getId(), new ExecutorAction(executor), RUNNERS_GROUP, this.myId2Action);
        this.registerAction(executor.getContextActionId(), (AnAction)new RunContextAction(executor), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void registerAction(@NotNull String actionId, @NotNull AnAction anAction, @NotNull String groupId, @NotNull Map<String, AnAction> map2) {
        AnAction action;
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(1);
        }
        if (anAction == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(2);
        }
        if (groupId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(3);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(4);
        }
        if ((action = this.myActionManager.getAction(actionId)) == null) {
            this.myActionManager.registerAction(actionId, anAction);
            map2.put(actionId, anAction);
            action = anAction;
        }
        ((DefaultActionGroup)this.myActionManager.getAction(groupId)).add(action);
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(5);
        }
        this.myExecutors.remove(executor);
        this.myId2Executor.remove(executor.getId());
        this.myContextActionIdSet.remove(executor.getContextActionId());
        this.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myId2Action);
        this.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void unregisterAction(@NotNull String actionId, @NotNull String groupId, @NotNull Map<String, AnAction> map2) {
        DefaultActionGroup group;
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(6);
        }
        if (groupId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(7);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(8);
        }
        if ((group = (DefaultActionGroup)this.myActionManager.getAction(groupId)) != null) {
            group.remove(this.myActionManager.getAction(actionId));
            AnAction action = map2.get(actionId);
            if (action != null) {
                this.myActionManager.unregisterAction(actionId);
                map2.remove(actionId);
            }
        }
    }

    @NotNull
    public synchronized Executor[] getRegisteredExecutors() {
        Executor[] executorArray = this.myExecutors.toArray(new Executor[this.myExecutors.size()]);
        if (executorArray == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(9);
        }
        return executorArray;
    }

    public Executor getExecutorById(String executorId) {
        return this.myId2Executor.get(executorId);
    }

    public void initComponent() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStartScheduled(@NotNull String executorId, @NotNull ExecutionEnvironment environment) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExecutorRegistryImpl.this.myInProgress.add(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment environment) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(3);
                }
                ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment environment, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (handler2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStartScheduled";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processNotStarted";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(Project project) {
                Set set2 = ExecutorRegistryImpl.this.myInProgress;
                synchronized (set2) {
                    Iterator it = ExecutorRegistryImpl.this.myInProgress.iterator();
                    while (it.hasNext()) {
                        if (project != ((Trinity)it.next()).first) continue;
                        it.remove();
                    }
                }
            }
        });
        for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
            this.initExecutor(executor);
        }
    }

    @NotNull
    private static Trinity<Project, String, String> createExecutionId(String executorId, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(10);
        }
        Trinity trinity = Trinity.create((Object)environment.getProject(), (Object)executorId, (Object)environment.getRunner().getRunnerId());
        if (trinity == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(11);
        }
        return trinity;
    }

    public boolean isStarting(Project project, String executorId, String runnerId) {
        return this.myInProgress.contains(Trinity.create((Object)project, (Object)executorId, (Object)runnerId));
    }

    public boolean isStarting(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(12);
        }
        return this.isStarting(environment.getProject(), environment.getExecutor().getId(), environment.getRunner().getRunnerId());
    }

    public synchronized void dispose() {
        if (!this.myExecutors.isEmpty()) {
            for (Executor executor : new ArrayList<Executor>(this.myExecutors)) {
                this.deinitExecutor(executor);
            }
        }
        this.myExecutors = null;
        this.myActionManager = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutorRegistryImpl";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredExecutors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExecutor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deinitExecutor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExecutorAction
    extends AnAction
    implements DumbAware {
        private final Executor myExecutor;

        private ExecutorAction(Executor executor) {
            if (executor == null) {
                ExecutorAction.$$$reportNull$$$0(0);
            }
            super(executor.getStartActionText(), executor.getDescription(), executor.getIcon());
            this.myExecutor = executor;
        }

        public void update(AnActionEvent e) {
            String text;
            Presentation presentation = e.getPresentation();
            Project project = e.getProject();
            if (project == null || !project.isInitialized() || project.isDisposed()) {
                presentation.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettings selectedConfiguration = this.getSelectedConfiguration(project);
            boolean enabled = false;
            if (selectedConfiguration != null) {
                if (DumbService.isDumb((Project)project) && !selectedConfiguration.getType().isDumbAware()) {
                    presentation.setEnabled(false);
                    return;
                }
                presentation.setIcon(this.getInformativeIcon(project, selectedConfiguration));
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)selectedConfiguration.getConfiguration());
                ExecutionTarget target2 = ExecutionTargetManager.getActiveTarget((Project)project);
                boolean bl = enabled = ExecutionTargetManager.canRun((RunnerAndConfigurationSettings)selectedConfiguration, (ExecutionTarget)target2) && runner != null && !ExecutorRegistryImpl.this.isStarting(project, this.myExecutor.getId(), runner.getRunnerId());
                if (enabled) {
                    presentation.setDescription(this.myExecutor.getDescription());
                }
                text = this.myExecutor.getStartActionText(selectedConfiguration.getName());
            } else {
                text = this.getTemplatePresentation().getTextWithMnemonic();
            }
            presentation.setEnabled(enabled);
            presentation.setText(text);
        }

        private Icon getInformativeIcon(Project project, RunnerAndConfigurationSettings selectedConfiguration) {
            RunnerIconProvider provider;
            Icon icon;
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            RunConfiguration configuration = selectedConfiguration.getConfiguration();
            if (configuration instanceof RunnerIconProvider && (icon = (provider = (RunnerIconProvider)configuration).getExecutorIcon(configuration, this.myExecutor)) != null) {
                return icon;
            }
            List runningDescriptors2 = executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)s -> s != null && s.getConfiguration() == selectedConfiguration.getConfiguration()));
            if (!(runningDescriptors2 = ContainerUtil.filter(runningDescriptors2, descriptor2 -> {
                RunContentDescriptor contentDescriptor = executionManager.getContentManager().findContentDescriptor(this.myExecutor, descriptor2.getProcessHandler());
                return contentDescriptor != null && executionManager.getExecutors(contentDescriptor).contains(this.myExecutor);
            })).isEmpty() && DefaultRunExecutor.EXECUTOR_ID.equals(this.myExecutor.getId()) && selectedConfiguration.isSingleton()) {
                return AllIcons.Actions.Restart;
            }
            if (runningDescriptors2.isEmpty()) {
                return this.myExecutor.getIcon();
            }
            if (runningDescriptors2.size() == 1) {
                return ExecutionUtil.getLiveIndicator((Icon)this.myExecutor.getIcon());
            }
            return IconUtil.addText((Icon)this.myExecutor.getIcon(), (String)String.valueOf(runningDescriptors2.size()));
        }

        @Nullable
        private RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull Project project) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(1);
            }
            return RunManager.getInstance((Project)project).getSelectedConfiguration();
        }

        public void actionPerformed(AnActionEvent e) {
            ExecutionEnvironmentBuilder builder;
            Project project = e.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            RunnerAndConfigurationSettings configuration = this.getSelectedConfiguration(project);
            ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder = configuration == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)this.myExecutor, (RunnerAndConfigurationSettings)configuration);
            if (builder == null) {
                return;
            }
            ExecutionManager.getInstance((Project)project).restartRunProfile(builder.activeTarget().dataContext(e.getDataContext()).build());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

