/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Element;

abstract class BaseRCSettingsConfigurable
extends SettingsEditorConfigurable<RunnerAndConfigurationSettings> {
    BaseRCSettingsConfigurable(SettingsEditor<RunnerAndConfigurationSettings> editor, RunnerAndConfigurationSettings settings) {
        super(editor, (Object)settings);
    }

    public boolean isModified() {
        try {
            RunnerAndConfigurationSettings original = (RunnerAndConfigurationSettings)this.getSettings();
            RunnerAndConfigurationSettings snapshot = (RunnerAndConfigurationSettings)this.getEditor().getSnapshot();
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(original.getConfiguration().getProject());
            if (!original.isTemplate() && !runManager.hasSettings(original)) {
                return true;
            }
            if (!super.isModified()) {
                return false;
            }
            if (this.isSnapshotSpecificallyModified(runManager, original, snapshot) || !runManager.getBeforeRunTasks(original.getConfiguration()).equals(runManager.getBeforeRunTasks(snapshot.getConfiguration()))) {
                return true;
            }
            if (original instanceof JDOMExternalizable && snapshot instanceof JDOMExternalizable) {
                boolean result2;
                this.applySnapshotToComparison(original, snapshot);
                Element originalElement = new Element("config");
                Element snapshotElement = new Element("config");
                ((JDOMExternalizable)original).writeExternal(originalElement);
                ((JDOMExternalizable)snapshot).writeExternal(snapshotElement);
                this.patchElementsIfNeed(originalElement, snapshotElement);
                boolean bl = result2 = !JDOMUtil.areElementsEqual((Element)originalElement, (Element)snapshotElement, (boolean)true);
                if (!result2) {
                    super.setModified(false);
                }
                return result2;
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        return super.isModified();
    }

    void applySnapshotToComparison(RunnerAndConfigurationSettings original, RunnerAndConfigurationSettings snapshot) {
    }

    boolean isSnapshotSpecificallyModified(RunManagerImpl runManager, RunnerAndConfigurationSettings original, RunnerAndConfigurationSettings snapshot) {
        return false;
    }

    void patchElementsIfNeed(Element originalElement, Element snapshotElement) {
    }
}

