/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindUsagesHandler {
    @NotNull
    public static final FindUsagesHandler NULL_HANDLER = new NullFindUsagesHandler();
    @NotNull
    private final PsiElement myPsiElement;

    protected FindUsagesHandler(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            FindUsagesHandler.$$$reportNull$$$0(0);
        }
        this.myPsiElement = psiElement;
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        DataContext ctx = DataManager.getInstance().getDataContext();
        CommonFindUsagesDialog commonFindUsagesDialog = new CommonFindUsagesDialog(this.myPsiElement, this.getProject(), this.getFindUsagesOptions(ctx), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        if (commonFindUsagesDialog == null) {
            FindUsagesHandler.$$$reportNull$$$0(1);
        }
        return commonFindUsagesDialog;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            FindUsagesHandler.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myPsiElement.getProject();
        if (project == null) {
            FindUsagesHandler.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myPsiElement};
        if (psiElementArray == null) {
            FindUsagesHandler.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        if (PsiElement.EMPTY_ARRAY == null) {
            FindUsagesHandler.$$$reportNull$$$0(5);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    protected String getHelpId() {
        return FindUsagesManager.getHelpID(this.myPsiElement);
    }

    @NotNull
    public static FindUsagesOptions createFindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            FindUsagesHandler.$$$reportNull$$$0(6);
        }
        FindUsagesOptions findUsagesOptions = new FindUsagesOptions(project, dataContext);
        findUsagesOptions.isUsages = true;
        findUsagesOptions.isSearchForTextOccurrences = true;
        FindUsagesOptions findUsagesOptions2 = findUsagesOptions;
        if (findUsagesOptions2 == null) {
            FindUsagesHandler.$$$reportNull$$$0(7);
        }
        return findUsagesOptions2;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        FindUsagesOptions findUsagesOptions = this.getFindUsagesOptions(null);
        if (findUsagesOptions == null) {
            FindUsagesHandler.$$$reportNull$$$0(8);
        }
        return findUsagesOptions;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        FindUsagesOptions options = FindUsagesHandler.createFindUsagesOptions(this.getProject(), dataContext);
        options.isSearchForTextOccurrences &= this.isSearchForTextOccurrencesAvailable(this.getPsiElement(), false);
        FindUsagesOptions findUsagesOptions = options;
        if (findUsagesOptions == null) {
            FindUsagesHandler.$$$reportNull$$$0(9);
        }
        return findUsagesOptions;
    }

    public boolean processElementUsages(@NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor2, @NotNull FindUsagesOptions options) {
        boolean success;
        boolean searchText;
        if (element == null) {
            FindUsagesHandler.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            FindUsagesHandler.$$$reportNull$$$0(11);
        }
        if (options == null) {
            FindUsagesHandler.$$$reportNull$$$0(12);
        }
        ReadActionProcessor<PsiReference> refProcessor = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                TextRange rangeInElement = ref.getRangeInElement();
                return processor2.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
            }
        };
        SearchScope scope = options.searchScope;
        boolean bl = searchText = options.isSearchForTextOccurrences && scope instanceof GlobalSearchScope;
        if (options.isUsages && !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, scope, false, options.fastTrack)).forEach((Processor)refProcessor))) {
            return false;
        }
        if (searchText) {
            if (options.fastTrack != null) {
                options.fastTrack.searchCustom(consumer -> {
                    if (element == null) {
                        FindUsagesHandler.$$$reportNull$$$0(23);
                    }
                    if (processor2 == null) {
                        FindUsagesHandler.$$$reportNull$$$0(24);
                    }
                    return this.processUsagesInText(element, processor2, (GlobalSearchScope)scope);
                });
            } else {
                return this.processUsagesInText(element, processor2, (GlobalSearchScope)scope);
            }
        }
        return true;
    }

    public boolean processUsagesInText(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor2, @NotNull GlobalSearchScope searchScope) {
        Collection stringToSearch;
        if (element == null) {
            FindUsagesHandler.$$$reportNull$$$0(13);
        }
        if (processor2 == null) {
            FindUsagesHandler.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            FindUsagesHandler.$$$reportNull$$$0(15);
        }
        if ((stringToSearch = (Collection)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            if (element == null) {
                FindUsagesHandler.$$$reportNull$$$0(22);
            }
            return this.getStringsToSearch(element);
        }))) == null) {
            return true;
        }
        return FindUsagesHelper.processUsagesInText(element, stringToSearch, searchScope, processor2);
    }

    @Nullable
    protected Collection<String> getStringsToSearch(@NotNull PsiElement element) {
        if (element == null) {
            FindUsagesHandler.$$$reportNull$$$0(16);
        }
        if (element instanceof PsiNamedElement) {
            return ContainerUtil.createMaybeSingletonList((Object)((PsiNamedElement)element).getName());
        }
        return Collections.singleton(element.getText());
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            FindUsagesHandler.$$$reportNull$$$0(17);
        }
        return this.isSearchForTextOccurencesAvailable(psiElement, isSingleFile);
    }

    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            FindUsagesHandler.$$$reportNull$$$0(18);
        }
        return false;
    }

    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target2, @NotNull SearchScope searchScope) {
        if (target2 == null) {
            FindUsagesHandler.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            FindUsagesHandler.$$$reportNull$$$0(20);
        }
        Collection collection = ReferencesSearch.search((PsiElement)target2, (SearchScope)searchScope, (boolean)false).findAll();
        if (collection == null) {
            FindUsagesHandler.$$$reportNull$$$0(21);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindUsagesOptions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesOptions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStringsToSearch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurrencesAvailable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurencesAvailable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findReferencesToHighlight";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUsagesInText$1";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullFindUsagesHandler
    extends FindUsagesHandler {
        private NullFindUsagesHandler() {
            super(PsiUtilCore.NULL_PSI_ELEMENT);
        }

        @Override
        @NotNull
        public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public PsiElement[] getPrimaryElements() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public PsiElement[] getSecondaryElements() {
            throw new IncorrectOperationException();
        }

        @Override
        @Nullable
        protected String getHelpId() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public FindUsagesOptions getFindUsagesOptions() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor2, @NotNull FindUsagesOptions options) {
            if (element == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(1);
            }
            if (options == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(2);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public boolean processUsagesInText(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor2, @NotNull GlobalSearchScope searchScope) {
            if (element == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(3);
            }
            if (processor2 == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(4);
            }
            if (searchScope == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(5);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @Nullable
        protected Collection<String> getStringsToSearch(@NotNull PsiElement element) {
            if (element == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(6);
            }
            throw new IncorrectOperationException();
        }

        @Override
        protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
            if (psiElement == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(7);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target2, @NotNull SearchScope searchScope) {
            if (target2 == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(8);
            }
            if (searchScope == null) {
                NullFindUsagesHandler.$$$reportNull$$$0(9);
            }
            throw new IncorrectOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/findUsages/FindUsagesHandler$NullFindUsagesHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElementUsages";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processUsagesInText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStringsToSearch";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchForTextOccurrencesAvailable";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findReferencesToHighlight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

