/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstallPluginAction;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.ide.plugins.UninstallPluginAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBGradientPaint;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class PluginHeaderPanel {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private final PluginManagerMain myManager;
    private IdeaPluginDescriptor myPlugin;
    private JBLabel myCategory;
    private JBLabel myName;
    private JBLabel myDownloads;
    private RatesPanel myRating;
    private JBLabel myUpdated;
    private JButton myInstallButton;
    private JBLabel myVersion;
    private JPanel myRoot;
    private JPanel myButtonPanel;
    private JPanel myDownloadsPanel;
    private JPanel myVersionInfoPanel;
    private ACTION_ID myActionId = ACTION_ID.INSTALL;

    public PluginHeaderPanel(@Nullable PluginManagerMain manager) {
        this.myManager = manager;
        this.$$$setupUI$$$();
        Font font = this.myName.getFont();
        this.myName.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() + 2));
        JBColor greyed = new JBColor((Color)Gray._130, (Color)Gray._200);
        this.myCategory.setForeground((Color)greyed);
        this.myDownloads.setForeground((Color)greyed);
        this.myUpdated.setForeground((Color)greyed);
        this.myVersion.setForeground((Color)greyed);
        Font smallFont = new Font(font.getFontName(), font.getStyle(), font.getSize() - 1);
        this.myCategory.setFont(smallFont);
        this.myVersion.setFont(smallFont);
        this.myVersion.setCopyable(true);
        this.myDownloads.setFont(smallFont);
        this.myUpdated.setFont(smallFont);
        this.myRoot.setVisible(false);
    }

    public void setPlugin(IdeaPluginDescriptor plugin) {
        this.myPlugin = plugin;
        this.myRoot.setVisible(true);
        this.myRoot.setBackground(UIUtil.getTextFieldBackground());
        this.myCategory.setVisible(true);
        this.myDownloadsPanel.setVisible(true);
        this.myButtonPanel.setVisible(true);
        this.myUpdated.setVisible(true);
        this.myName.setFont(UIUtil.getLabelFont().deriveFont(4.0f + (float)UIUtil.getLabelFont().getSize()));
        this.myName.setText("<html><body>" + plugin.getName() + "</body></html>");
        this.myCategory.setText(plugin.getCategory() == null ? "UNKNOWN" : plugin.getCategory().toUpperCase());
        boolean hasNewerVersion = ourState.hasNewerVersion(plugin.getPluginId());
        if (plugin instanceof PluginNode) {
            PluginNode node = (PluginNode)plugin;
            this.myRating.setRate(node.getRating());
            this.myDownloads.setText(node.getDownloads() + " downloads");
            this.myVersion.setText("v" + node.getVersion());
            this.myUpdated.setText("Updated " + DateFormatUtil.formatDate((long)node.getDate()));
            switch (node.getStatus()) {
                case 1: {
                    this.myActionId = hasNewerVersion ? ACTION_ID.UPDATE : ACTION_ID.UNINSTALL;
                    break;
                }
                case 5: {
                    this.myActionId = ACTION_ID.RESTART;
                    break;
                }
                default: {
                    this.myActionId = ACTION_ID.INSTALL;
                }
            }
            if (node.getRepositoryName() != null) {
                this.myCategory.setVisible(false);
                this.myDownloadsPanel.setVisible(false);
                this.myUpdated.setVisible(false);
            }
            IdeaPluginDescriptor installed = PluginManager.getPlugin(plugin.getPluginId());
            if (PluginManagerColumnInfo.isDownloaded(node) || installed != null && ourState.wasUpdated(installed.getPluginId()) || installed instanceof IdeaPluginDescriptorImpl && !plugin.isBundled() && ((IdeaPluginDescriptorImpl)installed).isDeleted()) {
                this.myActionId = ACTION_ID.RESTART;
            }
        } else {
            this.myActionId = null;
            this.myVersionInfoPanel.remove((Component)this.myUpdated);
            this.myCategory.setVisible(false);
            this.myDownloadsPanel.setVisible(false);
            String version = plugin.getVersion();
            if (ourState.wasUpdated(plugin.getPluginId())) {
                this.myVersion.setText("New version will be available after restart");
            } else {
                this.myVersion.setText("Version: " + (version == null ? "N/A" : version));
            }
            this.myUpdated.setVisible(false);
            if (ourState.wasUpdated(plugin.getPluginId()) || ourState.wasInstalled(plugin.getPluginId())) {
                this.myActionId = ACTION_ID.RESTART;
            } else if (!plugin.isBundled() || hasNewerVersion) {
                this.myActionId = ((IdeaPluginDescriptorImpl)plugin).isDeleted() ? ACTION_ID.RESTART : (hasNewerVersion ? ACTION_ID.UPDATE : ACTION_ID.UNINSTALL);
            }
            if (this.myActionId == ACTION_ID.RESTART && this.myManager != null && !this.myManager.isRequireShutdown()) {
                this.myActionId = null;
            }
        }
        UIUtil.setEnabled((Component)this.myButtonPanel, (boolean)true, (boolean)true);
        if (this.myManager == null || this.myActionId == null || this.myManager.getInstalled() != this.myManager.getAvailable() && this.myActionId == ACTION_ID.UNINSTALL) {
            this.myActionId = ACTION_ID.INSTALL;
            this.myButtonPanel.setVisible(false);
        } else if (InstallPluginAction.isInstalling(plugin)) {
            UIUtil.setEnabled((Component)this.myButtonPanel, (boolean)false, (boolean)true);
        }
        this.myRoot.revalidate();
        ((JComponent)this.myInstallButton.getParent()).revalidate();
        this.myInstallButton.revalidate();
        ((JComponent)this.myVersion.getParent()).revalidate();
        this.myVersion.revalidate();
    }

    private void createUIComponents() {
        this.myInstallButton = new JButton(){
            private final int TOP_BOTTOM_BORDER = JBUI.scale((int)2);
            private final int LEFT_RIGHT_BORDER = JBUI.scale((int)8);
            private final int H_GAP = JBUI.scale((int)4);
            private final int ICON_SIZE = this.getIcon().getIconWidth();
            {
                this.setOpaque(false);
                this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public Dimension getPreferredSize() {
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                int textWidth = metrics.stringWidth(this.getText());
                int width = this.LEFT_RIGHT_BORDER + this.ICON_SIZE + this.H_GAP + textWidth + this.LEFT_RIGHT_BORDER;
                int height = this.TOP_BOTTOM_BORDER + Math.max(this.ICON_SIZE, metrics.getHeight()) + this.TOP_BOTTOM_BORDER;
                return new Dimension(width, height);
            }

            @Override
            public void paint(Graphics g2) {
                Graphics2D g = (Graphics2D)g2;
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                int w = g.getClipBounds().width;
                int h = g.getClipBounds().height;
                int borderArc = JBUI.scale((int)7);
                int border = JBUI.scale((int)1);
                int buttonArc = borderArc - border;
                g.setPaint(this.getBackgroundBorderPaint());
                g.fillRoundRect(0, 0, w, h, borderArc, borderArc);
                g.setPaint(this.getBackgroundPaint());
                g.fillRoundRect(border, border, w - 2 * border, h - 2 * border, buttonArc, buttonArc);
                g.setColor(this.getButtonForeground());
                g.drawString(this.getText(), this.LEFT_RIGHT_BORDER + this.ICON_SIZE + this.H_GAP, this.getBaseline(w, h));
                this.getIcon().paintIcon(this, g, this.LEFT_RIGHT_BORDER, (this.getHeight() - this.getIcon().getIconHeight()) / 2);
                config.restore();
            }

            private Color getButtonForeground() {
                switch (PluginHeaderPanel.this.myActionId) {
                    case UPDATE: {
                        return new JBColor((Color)Gray._240, (Color)Gray._210);
                    }
                    case INSTALL: {
                        return new JBColor((Color)Gray._240, (Color)Gray._210);
                    }
                    case RESTART: 
                    case UNINSTALL: {
                        return new JBColor((Color)Gray._0, (Color)Gray._210);
                    }
                }
                return new JBColor((Color)Gray._80, (Color)Gray._60);
            }

            private Paint getBackgroundPaint() {
                switch (PluginHeaderPanel.this.myActionId) {
                    case UPDATE: {
                        return new JBGradientPaint((JComponent)this, (Color)new JBColor(6463201, 6463201), (Color)new JBColor(3824565, 3824565));
                    }
                    case INSTALL: {
                        return new JBGradientPaint((JComponent)this, (Color)new JBColor(6343785, 5346647), (Color)new JBColor(3302697, 2639407));
                    }
                    case RESTART: 
                    case UNINSTALL: {
                        return UIUtil.isUnderDarcula() ? new JBGradientPaint((JComponent)this, UIManager.getColor("Button.darcula.color1"), UIManager.getColor("Button.darcula.color2")) : Gray._240;
                    }
                }
                return Gray._238;
            }

            private Paint getBackgroundBorderPaint() {
                switch (PluginHeaderPanel.this.myActionId) {
                    case UPDATE: {
                        return new JBColor(new Color(10925261), (Color)Gray._85);
                    }
                    case INSTALL: {
                        return new JBColor(new Color(201, 223, 201), (Color)Gray._70);
                    }
                    case RESTART: 
                    case UNINSTALL: {
                        return new JBColor((Color)Gray._220, Gray._100.withAlpha(180));
                    }
                }
                return Gray._208;
            }

            @Override
            public String getText() {
                switch (PluginHeaderPanel.this.myActionId) {
                    case UPDATE: {
                        return "Update";
                    }
                    case INSTALL: {
                        return "Install";
                    }
                    case UNINSTALL: {
                        return "Uninstall";
                    }
                    case RESTART: {
                        return "Restart " + ApplicationNamesInfo.getInstance().getFullProductName();
                    }
                }
                return super.getText();
            }

            @Override
            public Icon getIcon() {
                switch (PluginHeaderPanel.this.myActionId) {
                    case UPDATE: {
                        return AllIcons.General.DownloadPlugin;
                    }
                    case INSTALL: {
                        return AllIcons.General.DownloadPlugin;
                    }
                    case UNINSTALL: {
                        return AllIcons.Actions.Delete;
                    }
                    case RESTART: {
                        return AllIcons.Actions.Restart;
                    }
                }
                return super.getIcon();
            }
        };
        this.myInstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (PluginHeaderPanel.this.myActionId) {
                    case UPDATE: 
                    case INSTALL: {
                        Runnable setPlugin = () -> PluginHeaderPanel.this.setPlugin(PluginHeaderPanel.this.myPlugin);
                        new InstallPluginAction(PluginHeaderPanel.this.myManager.getAvailable(), PluginHeaderPanel.this.myManager.getInstalled()).install(setPlugin, setPlugin, true);
                        break;
                    }
                    case UNINSTALL: {
                        UninstallPluginAction.uninstall(PluginHeaderPanel.this.myManager.getInstalled(), true, PluginHeaderPanel.this.myPlugin);
                        break;
                    }
                    case RESTART: {
                        DialogWrapper dialog2;
                        if (PluginHeaderPanel.this.myManager != null) {
                            PluginHeaderPanel.this.myManager.apply();
                        }
                        if ((dialog2 = DialogWrapper.findInstance((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) != null && dialog2.isModal()) {
                            dialog2.close(0);
                        }
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                            DialogWrapper settings = DialogWrapper.findInstance((Component)IdeFocusManager.findInstance().getFocusOwner());
                            if (settings instanceof SettingsDialog) {
                                ((SettingsDialog)settings).doOKAction();
                            }
                            ApplicationManager.getApplication().restart();
                        }, ModalityState.current());
                    }
                }
                PluginHeaderPanel.this.setPlugin(PluginHeaderPanel.this.myPlugin);
            }
        });
    }

    public JBLabel getCategory() {
        return this.myCategory;
    }

    public JBLabel getName() {
        return this.myName;
    }

    public JBLabel getDownloads() {
        return this.myDownloads;
    }

    public RatesPanel getRating() {
        return this.myRating;
    }

    public JBLabel getUpdated() {
        return this.myUpdated;
    }

    public JButton getInstallButton() {
        return this.myInstallButton;
    }

    public JPanel getPanel() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JBLabel jBLabel3;
        RatesPanel ratesPanel;
        JPanel jPanel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel4;
        this.createUIComponents();
        this.myRoot = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setOpaque(true);
        this.myCategory = jBLabel5 = new JBLabel();
        jBLabel5.setText("CATEGORY");
        jPanel4.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myName = jBLabel4 = new JBLabel();
        jBLabel4.setText("Name name name");
        jPanel4.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myDownloadsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel4.add((Component)jPanel3, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRating = ratesPanel = new RatesPanel();
        jPanel3.add((Component)ratesPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myDownloads = jBLabel3 = new JBLabel();
        jBLabel3.setText("777 downloads");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        jPanel4.add((Component)jPanel2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUpdated = jBLabel2 = new JBLabel();
        jBLabel2.setText("Updated: 11/12/13");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersion = jBLabel = new JBLabel();
        jBLabel.setText("v 1.2.3");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel5.setOpaque(false);
        jPanel4.add((Component)jPanel5, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myButtonPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JButton jButton = this.myInstallButton;
        jButton.setText("Install");
        jPanel.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    static enum ACTION_ID {
        UPDATE,
        INSTALL,
        UNINSTALL,
        RESTART;

    }
}

