/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUrl {
    protected final String url;
    protected final String moduleName;
    private final String myType;

    protected AbstractUrl(String url, @Nullable String moduleName, @NotNull @NonNls String type) {
        if (type == null) {
            AbstractUrl.$$$reportNull$$$0(0);
        }
        this.myType = type;
        this.url = StringUtil.notNullize((String)url);
        this.moduleName = moduleName;
    }

    public void write(Element element) {
        element.setAttribute("url", this.url);
        if (this.moduleName != null) {
            element.setAttribute("module", this.moduleName);
        }
        element.setAttribute("type", this.myType);
    }

    @Nullable
    public abstract Object[] createPath(Project var1);

    @Nullable(value="return null if cannot recognize the element")
    public AbstractUrl createUrl(String type, String moduleName, String url) {
        if (type.equals(this.myType)) {
            return this.createUrl(moduleName, url);
        }
        return null;
    }

    protected abstract AbstractUrl createUrl(String var1, String var2);

    public abstract AbstractUrl createUrlByElement(Object var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUrl that = (AbstractUrl)o;
        if (this.moduleName != null ? !this.moduleName.equals(that.moduleName) : that.moduleName != null) {
            return false;
        }
        return this.myType.equals(that.myType) && this.url.equals(that.url);
    }

    public int hashCode() {
        int result2 = this.url.hashCode();
        result2 = 29 * result2 + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result2 = 29 * result2 + this.myType.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/projectView/impl/AbstractUrl", "<init>"));
    }
}

