/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalLong;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectNode
extends ProjectViewNode<Project> {
    protected AbstractProjectNode(Project project, Project value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    protected Collection<AbstractTreeNode> modulesAndGroups(Collection<ModuleDescription> modules) {
        LinkedHashSet<String> topLevelGroups = new LinkedHashSet<String>();
        LinkedHashSet<ModuleDescription> nonGroupedModules = new LinkedHashSet<ModuleDescription>(modules);
        List commonGroupsPath = null;
        for (ModuleDescription moduleDescription : modules) {
            List path = ModuleGrouper.instanceFor((Project)this.myProject).getGroupPath(moduleDescription);
            if (path.isEmpty()) continue;
            String topLevelGroupName = (String)path.get(0);
            topLevelGroups.add(topLevelGroupName);
            nonGroupedModules.remove(moduleDescription);
            if (commonGroupsPath == null) {
                commonGroupsPath = path;
                continue;
            }
            int commonPartLen = Math.min(commonGroupsPath.size(), path.size());
            OptionalLong firstDifference = StreamEx.zip(commonGroupsPath.subList(0, commonPartLen), path.subList(0, commonPartLen), String::equals).indexOf((Object)false);
            if (!firstDifference.isPresent()) continue;
            commonGroupsPath = commonGroupsPath.subList(0, (int)firstDifference.getAsLong());
        }
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        try {
            if (modules.size() > 1) {
                if (commonGroupsPath != null && !commonGroupsPath.isEmpty()) {
                    result2.add(this.createModuleGroupNode(new ModuleGroup(commonGroupsPath)));
                } else {
                    for (String groupPath : topLevelGroups) {
                        result2.add(this.createModuleGroupNode(new ModuleGroup(Collections.singletonList(groupPath))));
                    }
                }
                for (ModuleDescription moduleDescription : nonGroupedModules) {
                    ContainerUtil.addIfNotNull(result2, (Object)this.createModuleNode(moduleDescription));
                }
            } else {
                ContainerUtil.addIfNotNull(result2, (Object)this.createModuleNode((ModuleDescription)ContainerUtil.getFirstItem(modules)));
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return new ArrayList<AbstractTreeNode>();
        }
        return result2;
    }

    protected abstract AbstractTreeNode createModuleGroup(Module var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    @Nullable
    private AbstractTreeNode createModuleNode(ModuleDescription moduleDescription) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (moduleDescription instanceof LoadedModuleDescription) {
            return this.createModuleGroup(((LoadedModuleDescription)moduleDescription).getModule());
        }
        if (moduleDescription instanceof UnloadedModuleDescription) {
            return this.createUnloadedModuleNode((UnloadedModuleDescription)moduleDescription);
        }
        return null;
    }

    protected AbstractTreeNode createUnloadedModuleNode(UnloadedModuleDescription moduleDescription) {
        return null;
    }

    protected abstract AbstractTreeNode createModuleGroupNode(ModuleGroup var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    public void update(PresentationData presentation) {
        presentation.setIcon(PlatformIcons.PROJECT_ICON);
        presentation.setPresentableText(this.getProject().getName());
    }

    public String getTestPresentation() {
        return "Project";
    }

    public boolean contains(@NotNull VirtualFile vFile) {
        ProjectFileIndex index;
        if (vFile == null) {
            AbstractProjectNode.$$$reportNull$$$0(0);
        }
        return (index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex()).getContentRootForFile(vFile, false) != null || index.isInLibraryClasses(vFile) || index.isInLibrarySource(vFile) || Comparing.equal((Object)vFile.getParent(), (Object)this.myProject.getBaseDir()) || ScratchProjectViewPane.isScratchesMergedIntoProjectTab() && RootType.forFile((VirtualFile)vFile) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/projectView/impl/nodes/AbstractProjectNode", "contains"));
    }
}

