/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.Nullable;

public class ShowNonRetinaImagesActions
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        class ImageInfo {
            boolean retina;
            boolean normal;
            boolean dark;
            boolean retina_dark;

            ImageInfo() {
            }
        }
        HashMap<String, ImageInfo> info = new HashMap<String, ImageInfo>();
        Collection<VirtualFile> images = FilenameIndex.getAllFilesByExt(project, "png", GlobalSearchScope.projectScope((Project)project));
        for (VirtualFile image : images) {
            String path = image.getPath();
            String key = ShowNonRetinaImagesActions.toKey(path);
            ImageInfo imageInfo = (ImageInfo)info.get(key);
            if (imageInfo == null) {
                imageInfo = new ImageInfo();
                info.put(key, imageInfo);
            }
            if (path.endsWith("@2x_dark.png")) {
                imageInfo.retina_dark = true;
                continue;
            }
            if (path.endsWith("_dark.png")) {
                imageInfo.dark = true;
                continue;
            }
            if (path.endsWith("@2x.png")) {
                imageInfo.retina = true;
                continue;
            }
            imageInfo.normal = true;
        }
        final ArrayList<String> retinaMissed = new ArrayList<String>();
        for (String key : info.keySet()) {
            if (((ImageInfo)info.get((Object)key)).retina || !((ImageInfo)info.get((Object)key)).normal) continue;
            retinaMissed.add(key);
        }
        Collections.sort(retinaMissed, String.CASE_INSENSITIVE_ORDER);
        new DialogWrapper(project){
            {
                super(arg0);
                this.init();
            }

            @Nullable
            protected JComponent createCenterPanel() {
                return new JBScrollPane((Component)new JTextArea(StringUtil.join((Collection)retinaMissed, (String)"\n")));
            }
        }.show();
    }

    private static String toKey(String path) {
        if (path.endsWith("@2x_dark.png")) {
            return path.substring(0, path.lastIndexOf("@2x_dark.png")) + ".png";
        }
        if (path.endsWith("_dark.png")) {
            return path.substring(0, path.lastIndexOf("_dark.png")) + ".png";
        }
        if (path.endsWith("@2x.png")) {
            return path.substring(0, path.lastIndexOf("@2x.png")) + ".png";
        }
        return path;
    }
}

