/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDropHandler
implements EditorDropHandler {
    private final Editor myEditor;

    public FileDropHandler(Editor editor) {
        this.myEditor = editor;
    }

    @Override
    public boolean canHandleDrop(DataFlavor[] transferFlavors) {
        return transferFlavors != null && FileCopyPasteUtil.isFileListFlavorAvailable(transferFlavors);
    }

    @Override
    public void handleDrop(@NotNull Transferable t, @Nullable Project project, EditorWindow editorWindow) {
        List<File> fileList;
        if (t == null) {
            FileDropHandler.$$$reportNull$$$0(0);
        }
        if (project != null && (fileList = FileCopyPasteUtil.getFileList(t)) != null) {
            boolean dropResult = ContainerUtil.process((Object[])Extensions.getExtensions(CustomFileDropHandler.CUSTOM_DROP_HANDLER_EP, (AreaInstance)project), handler2 -> {
                if (t == null) {
                    FileDropHandler.$$$reportNull$$$0(1);
                }
                return !handler2.canHandle(t, this.myEditor) || !handler2.handleDrop(t, this.myEditor, project);
            });
            if (!dropResult) {
                return;
            }
            this.openFiles(project, fileList, editorWindow);
        }
    }

    private void openFiles(Project project, List<File> fileList, EditorWindow editorWindow) {
        if (editorWindow == null && this.myEditor != null) {
            editorWindow = this.findEditorWindow(project);
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File file2 : fileList) {
            VirtualFile vFile = fileSystem.refreshAndFindFileByIoFile(file2);
            FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)project);
            if (vFile == null) continue;
            NonProjectFileWritingAccessProvider.allowWriting(vFile);
            if (editorWindow != null) {
                fileEditorManager.openFileWithProviders(vFile, true, editorWindow);
                continue;
            }
            new OpenFileDescriptor(project, vFile).navigate(true);
        }
    }

    @Nullable
    private EditorWindow findEditorWindow(Project project) {
        Document document = this.myEditor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            EditorWindow[] windows;
            FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)project);
            for (EditorWindow window : windows = fileEditorManager.getWindows()) {
                EditorWithProviderComposite composite = window.findFileComposite(file2);
                if (composite == null) continue;
                for (FileEditor editor : composite.getEditors()) {
                    if (!(editor instanceof TextEditor) || ((TextEditor)editor).getEditor() != this.myEditor) continue;
                    return window;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "t";
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/FileDropHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDrop";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$handleDrop$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

