/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;
    private final ChangeListManagerImpl myManager;

    public ChangelistConflictAccessProvider(Project project, ChangeListManagerImpl manager) {
        this.myProject = project;
        this.myManager = manager;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        ChangelistConflictTracker.Options options = this.myManager.getConflictTracker().getOptions();
        if (!options.TRACKING_ENABLED || !options.SHOW_DIALOG) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                ChangelistConflictAccessProvider.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            if (file2 == null || this.myManager.getConflictTracker().isWritingAllowed(file2)) continue;
            denied.add(file2);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog2;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> changes = new ArrayList<Change>();
            for (VirtualFile file2 : denied) {
                changeLists.add(this.myManager.getChangeList(file2));
                changes.add(this.myManager.getChange(file2));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog2 = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog2.show();
            } while (dialog2.isOK() && !dialog2.getResolution().resolveConflict(this.myProject, changes, null));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog2.isOK()) {
                options.LAST_RESOLUTION = dialog2.getResolution();
                List<VirtualFile> list3 = Collections.emptyList();
                if (list3 == null) {
                    ChangelistConflictAccessProvider.$$$reportNull$$$0(1);
                }
                return list3;
            }
        }
        ArrayList<VirtualFile> arrayList = denied;
        if (arrayList == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWriting";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPotentiallyWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

