/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Comparator;

public class VirtualFileHierarchicalComparator
implements Comparator<VirtualFile> {
    private static final VirtualFileHierarchicalComparator ourInstance = new VirtualFileHierarchicalComparator();

    public static VirtualFileHierarchicalComparator getInstance() {
        return ourInstance;
    }

    @Override
    public int compare(VirtualFile vf1, VirtualFile vf2) {
        boolean isDir1 = vf1.isDirectory();
        boolean isDir2 = vf2.isDirectory();
        if (!isDir1 && !isDir2) {
            return 0;
        }
        if (isDir1 && !isDir2) {
            return -1;
        }
        if (!isDir1 && isDir2) {
            return 1;
        }
        int diff = vf1.getPath().length() - vf2.getPath().length();
        return diff == 0 ? 0 : (diff < 0 ? -1 : 1);
    }
}

