/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggregatedDictionary
implements EditableDictionary {
    @NonNls
    private static final String DICTIONARY_NAME = "common";
    private final EditableDictionary cachedDictionary;
    private final ProjectDictionary projectDictionary;

    @Override
    @NotNull
    public String getName() {
        if (DICTIONARY_NAME == null) {
            AggregatedDictionary.$$$reportNull$$$0(0);
        }
        return DICTIONARY_NAME;
    }

    public AggregatedDictionary(@NotNull ProjectDictionary projectDictionary, @NotNull EditableDictionary cachedDictionary) {
        if (projectDictionary == null) {
            AggregatedDictionary.$$$reportNull$$$0(1);
        }
        if (cachedDictionary == null) {
            AggregatedDictionary.$$$reportNull$$$0(2);
        }
        this.projectDictionary = projectDictionary;
        this.cachedDictionary = cachedDictionary;
        this.cachedDictionary.addToDictionary(projectDictionary.getWords());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @NonNls
    public String toString() {
        return "AggregatedDictionary{cachedDictionary=" + this.cachedDictionary + ", projectDictionary=" + this.projectDictionary + '}';
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            AggregatedDictionary.$$$reportNull$$$0(3);
        }
        return this.cachedDictionary.contains(word);
    }

    @Override
    public void addToDictionary(String word) {
        this.getProjectDictionary().addToDictionary(word);
        this.getCachedDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getProjectDictionary().removeFromDictionary(word);
        this.getCachedDictionary().removeFromDictionary(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        Set<String> oldWords = this.getProjectDictionary().getWords();
        this.getProjectDictionary().replaceAll(words);
        this.getCachedDictionary().addToDictionary(words);
        for (String word : oldWords) {
            if (words != null && words.contains(word)) continue;
            this.getCachedDictionary().removeFromDictionary(word);
        }
    }

    @Override
    public void clear() {
        this.getProjectDictionary().clear();
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            AggregatedDictionary.$$$reportNull$$$0(4);
        }
        this.cachedDictionary.traverse(consumer);
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        Set<String> set2 = this.cachedDictionary.getWords();
        if (set2 == null) {
            AggregatedDictionary.$$$reportNull$$$0(5);
        }
        return set2;
    }

    @Override
    public int size() {
        return this.cachedDictionary.size();
    }

    @Override
    @NotNull
    public Set<String> getEditableWords() {
        Set<String> set2 = this.getProjectDictionary().getEditableWords();
        if (set2 == null) {
            AggregatedDictionary.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getProjectDictionary().addToDictionary(words);
        this.getCachedDictionary().addToDictionary(words);
    }

    public EditableDictionary getCachedDictionary() {
        return this.cachedDictionary;
    }

    public ProjectDictionary getProjectDictionary() {
        return this.projectDictionary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/dictionary/AggregatedDictionary";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedDictionary";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/dictionary/AggregatedDictionary";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableWords";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

