/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskProjectConfiguration;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TaskManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TaskManagerImpl
extends TaskManager
implements ProjectComponent,
PersistentStateComponent<Config>,
ChangeListDecorator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.impl.TaskManagerImpl");
    private static final DecimalFormat LOCAL_TASK_ID_FORMAT = new DecimalFormat("LOCAL-00000");
    public static final Comparator<Task> TASK_UPDATE_COMPARATOR = (o1, o2) -> {
        int i = Comparing.compare((Comparable)o2.getUpdated(), (Comparable)o1.getUpdated());
        return i == 0 ? Comparing.compare((Comparable)o2.getCreated(), (Comparable)o1.getCreated()) : i;
    };
    private static final Convertor<Task, String> KEY_CONVERTOR = o -> o.getId();
    private final Project myProject;
    private final WorkingContextManager myContextManager;
    private final Map<String, Task> myIssueCache = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, LocalTask> myTasks = Collections.synchronizedMap(new LinkedHashMap<String, LocalTask>(){

        @Override
        public LocalTask put(String key, LocalTask task2) {
            LocalTask result2 = super.put(key, task2);
            if (this.size() > ((TaskManagerImpl)TaskManagerImpl.this).myConfig.taskHistoryLength) {
                ArrayList list2 = new ArrayList(this.entrySet());
                Collections.sort(list2, (o1, o2) -> TASK_UPDATE_COMPARATOR.compare((Task)o2.getValue(), (Task)o1.getValue()));
                for (Map.Entry oldest : list2) {
                    if (((LocalTask)oldest.getValue()).isDefault()) continue;
                    this.remove(oldest.getKey());
                    break;
                }
            }
            return result2;
        }
    });
    @NotNull
    private LocalTask myActiveTask = TaskManagerImpl.createDefaultTask();
    private Timer myCacheRefreshTimer;
    private volatile boolean myUpdating;
    private final Config myConfig = new Config();
    private final ChangeListAdapter myChangeListListener;
    private final ChangeListManager myChangeListManager;
    private final List<TaskRepository> myRepositories = new ArrayList<TaskRepository>();
    private final EventDispatcher<TaskListener> myDispatcher = EventDispatcher.create(TaskListener.class);
    private Set<TaskRepository> myBadRepositories = ContainerUtil.newConcurrentSet();

    public TaskManagerImpl(Project project, WorkingContextManager contextManager, ChangeListManager changeListManager) {
        this.myProject = project;
        this.myContextManager = contextManager;
        this.myChangeListManager = changeListManager;
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListRemoved(ChangeList list2) {
                LocalTask task2 = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)list2);
                if (task2 != null) {
                    for (ChangeListInfo info : task2.getChangeLists()) {
                        if (!Comparing.equal((String)info.id, (String)((LocalChangeList)list2).getId())) continue;
                        info.id = "";
                    }
                }
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                LocalTask associatedTask = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)newDefaultList);
                if (associatedTask != null && !TaskManagerImpl.this.getActiveTask().equals((Object)associatedTask)) {
                    ApplicationManager.getApplication().invokeLater(() -> TaskManagerImpl.this.activateTask((Task)associatedTask, true), TaskManagerImpl.this.myProject.getDisposed());
                }
            }
        };
    }

    public TaskRepository[] getAllRepositories() {
        return this.myRepositories.toArray(new TaskRepository[this.myRepositories.size()]);
    }

    public <T extends TaskRepository> void setRepositories(List<T> repositories) {
        HashSet<TaskRepository> set2 = new HashSet<TaskRepository>(this.myRepositories);
        set2.removeAll(repositories);
        this.myBadRepositories.removeAll(set2);
        this.myIssueCache.clear();
        this.myRepositories.clear();
        this.myRepositories.addAll(repositories);
        block0: for (TaskRepository repository : repositories) {
            if (!repository.isShared() || repository.getUrl() == null) continue;
            List<TaskProjectConfiguration.SharedServer> servers = this.getProjectConfiguration().servers;
            TaskRepositoryType type = repository.getRepositoryType();
            for (TaskProjectConfiguration.SharedServer server : servers) {
                if (!repository.getUrl().equals(server.url) || !type.getName().equals(server.type)) continue;
                continue block0;
            }
            TaskProjectConfiguration.SharedServer server = new TaskProjectConfiguration.SharedServer();
            server.type = type.getName();
            server.url = repository.getUrl();
            servers.add(server);
        }
    }

    public void removeTask(LocalTask task2) {
        if (task2.isDefault()) {
            return;
        }
        if (this.myActiveTask.equals((Object)task2)) {
            this.activateTask((Task)this.myTasks.get("Default"), true);
        }
        this.myTasks.remove(task2.getId());
        ((TaskListener)this.myDispatcher.getMulticaster()).taskRemoved(task2);
        this.myContextManager.removeContext((Task)task2);
    }

    public void addTaskListener(TaskListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addTaskListener(@NotNull TaskListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            TaskManagerImpl.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeTaskListener(TaskListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public LocalTask getActiveTask() {
        LocalTask localTask = this.myActiveTask;
        if (localTask == null) {
            TaskManagerImpl.$$$reportNull$$$0(2);
        }
        return localTask;
    }

    @Nullable
    public LocalTask findTask(String id) {
        return this.myTasks.get(id);
    }

    @NotNull
    public List<Task> getIssues(@Nullable String query) {
        List<Task> list2 = this.getIssues(query, true);
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public List<Task> getIssues(@Nullable String query, boolean forceRequest) {
        return this.getIssues(query, 0, 50, true, (ProgressIndicator)new EmptyProgressIndicator(), forceRequest);
    }

    public List<Task> getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator indicator, boolean forceRequest) {
        List<Task> tasks;
        if (indicator == null) {
            TaskManagerImpl.$$$reportNull$$$0(4);
        }
        if ((tasks = this.getIssuesFromRepositories(query, offset, limit, withClosed, forceRequest, indicator)) == null) {
            return this.getCachedIssues(withClosed);
        }
        this.myIssueCache.putAll(ContainerUtil.newMapFromValues(tasks.iterator(), KEY_CONVERTOR));
        return ContainerUtil.filter(tasks, task2 -> withClosed || !task2.isClosed());
    }

    public List<Task> getCachedIssues() {
        return this.getCachedIssues(true);
    }

    public List<Task> getCachedIssues(boolean withClosed) {
        return ContainerUtil.filter(this.myIssueCache.values(), task2 -> withClosed || !task2.isClosed());
    }

    private void updateIssue(@NotNull String id) {
        if (id == null) {
            TaskManagerImpl.$$$reportNull$$$0(5);
        }
        for (TaskRepository repository : this.getAllRepositories()) {
            if (repository.extractId(id) == null) continue;
            try {
                LOG.info("Searching for task '" + id + "' in " + repository);
                Task issue = repository.findTask(id);
                if (issue == null) continue;
                LocalTask localTask = this.findTask(id);
                if (localTask != null) {
                    localTask.updateFromIssue(issue);
                    return;
                }
                return;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public List<LocalTask> getLocalTasks() {
        return this.getLocalTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalTask> getLocalTasks(boolean withClosed) {
        Map<String, LocalTask> map2 = this.myTasks;
        synchronized (map2) {
            return ContainerUtil.filter(this.myTasks.values(), task2 -> withClosed || !this.isLocallyClosed((LocalTask)task2));
        }
    }

    public LocalTask addTask(Task issue) {
        LocalTaskImpl task2 = issue instanceof LocalTaskImpl ? (LocalTaskImpl)issue : new LocalTaskImpl(issue);
        this.addTask(task2);
        return task2;
    }

    public LocalTaskImpl createLocalTask(@NotNull String summary) {
        if (summary == null) {
            TaskManagerImpl.$$$reportNull$$$0(6);
        }
        return TaskManagerImpl.createTask(LOCAL_TASK_ID_FORMAT.format(this.myConfig.localTasksCounter++), summary);
    }

    private static LocalTaskImpl createTask(@NotNull String id, @NotNull String summary) {
        if (id == null) {
            TaskManagerImpl.$$$reportNull$$$0(7);
        }
        if (summary == null) {
            TaskManagerImpl.$$$reportNull$$$0(8);
        }
        LocalTaskImpl task2 = new LocalTaskImpl(id, summary);
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        return task2;
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext) {
        LocalTask activeTask;
        if (origin == null) {
            TaskManagerImpl.$$$reportNull$$$0(9);
        }
        if (origin.equals((Object)(activeTask = this.getActiveTask()))) {
            return activeTask;
        }
        this.saveActiveTask();
        if (clearContext) {
            this.myContextManager.clearContext();
        }
        this.myContextManager.restoreContext(origin);
        LocalTask task2 = this.doActivate(origin, true);
        return this.restoreVcsContext(task2);
    }

    private LocalTask restoreVcsContext(LocalTask task2) {
        if (!this.isVcsEnabled()) {
            return task2;
        }
        List changeLists = task2.getChangeLists();
        if (!changeLists.isEmpty()) {
            ChangeListInfo info = (ChangeListInfo)changeLists.get(0);
            LocalChangeList changeList = this.myChangeListManager.getChangeList(info.id);
            if (changeList == null) {
                changeList = this.myChangeListManager.addChangeList(info.name, info.comment);
                info.id = changeList.getId();
            }
            this.myChangeListManager.setDefaultChangeList(changeList);
        }
        this.unshelveChanges(task2);
        List branches = task2.getBranches(false);
        MultiMap multiMap = new MultiMap();
        for (BranchInfo branch : branches) {
            multiMap.putValue((Object)branch.repository, (Object)branch);
        }
        block1: for (String repo : multiMap.keySet()) {
            Collection infos = multiMap.get((Object)repo);
            if (infos.size() <= 1) continue;
            List<BranchInfo> existing = this.getAllBranches(repo);
            Iterator iterator = infos.iterator();
            while (iterator.hasNext()) {
                BranchInfo info = (BranchInfo)iterator.next();
                if (existing.contains(info)) continue;
                iterator.remove();
                if (infos.size() != 1) continue;
                continue block1;
            }
        }
        VcsTaskHandler.TaskInfo info = TaskManagerImpl.fromBranches(new ArrayList<BranchInfo>(multiMap.values()));
        this.switchBranch(info);
        return task2;
    }

    public void shelveChanges(LocalTask task2, @NotNull String shelfName) {
        Collection changes;
        if (shelfName == null) {
            TaskManagerImpl.$$$reportNull$$$0(10);
        }
        if ((changes = ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getChanges()).isEmpty()) {
            return;
        }
        try {
            ShelveChangesManager.getInstance(this.myProject).shelveChanges(changes, shelfName, true);
            task2.setShelfName(shelfName);
        }
        catch (Exception e) {
            LOG.warn("Can't shelve changes", (Throwable)e);
        }
    }

    private void unshelveChanges(LocalTask task2) {
        String name = task2.getShelfName();
        if (name != null) {
            ShelveChangesManager manager = ShelveChangesManager.getInstance(this.myProject);
            for (ShelvedChangeList list2 : manager.getShelvedChangeLists()) {
                if (!name.equals(list2.DESCRIPTION)) continue;
                manager.unshelveChangeList(list2, list2.getChanges(this.myProject), list2.getBinaryFiles(), this.myChangeListManager.getDefaultChangeList(), true);
                return;
            }
        }
    }

    private List<BranchInfo> getAllBranches(String repo) {
        VcsTaskHandler[] handlers;
        ArrayList<BranchInfo> infos = new ArrayList<BranchInfo>();
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] tasks;
            for (VcsTaskHandler.TaskInfo info : tasks = handler2.getAllExistingTasks()) {
                infos.addAll(ContainerUtil.filter((Collection)BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)info, (boolean)false), info1 -> Comparing.equal((String)info1.repository, (String)repo)));
            }
        }
        return infos;
    }

    private void switchBranch(VcsTaskHandler.TaskInfo info) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            handler2.switchToTask(info, null);
        }
    }

    private static VcsTaskHandler.TaskInfo fromBranches(List<BranchInfo> branches) {
        if (branches.isEmpty()) {
            return new VcsTaskHandler.TaskInfo(null, Collections.emptyList());
        }
        MultiMap map2 = new MultiMap();
        for (BranchInfo branch : branches) {
            map2.putValue((Object)branch.name, (Object)branch.repository);
        }
        Map.Entry next = (Map.Entry)map2.entrySet().iterator().next();
        return new VcsTaskHandler.TaskInfo((String)next.getKey(), (Collection)next.getValue());
    }

    public void createBranch(LocalTask task2, LocalTask previousActive, String name, @Nullable VcsTaskHandler.TaskInfo branchFrom) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] info = handler2.getCurrentTasks();
            if (previousActive != null && previousActive.getBranches(false).isEmpty()) {
                TaskManagerImpl.addBranches(previousActive, info, false);
            }
            TaskManagerImpl.addBranches(task2, info, true);
            if (info.length == 0 && branchFrom != null) {
                TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{branchFrom}, true);
            }
            TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{handler2.startNewTask(name)}, false);
        }
    }

    public void mergeBranch(LocalTask task2) {
        VcsTaskHandler[] handlers;
        VcsTaskHandler.TaskInfo original = TaskManagerImpl.fromBranches(task2.getBranches(true));
        VcsTaskHandler.TaskInfo feature = TaskManagerImpl.fromBranches(task2.getBranches(false));
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            handler2.closeTask(feature, original);
        }
    }

    public static void addBranches(LocalTask task2, VcsTaskHandler.TaskInfo[] info, boolean original) {
        for (VcsTaskHandler.TaskInfo taskInfo : info) {
            List branchInfos = BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)taskInfo, (boolean)original);
            for (BranchInfo branchInfo : branchInfos) {
                task2.addBranch(branchInfo);
            }
        }
    }

    private void saveActiveTask() {
        this.myContextManager.saveContext((Task)this.myActiveTask);
        this.myActiveTask.setUpdated(new Date());
        String shelfName = this.myActiveTask.getShelfName();
        if (shelfName != null) {
            this.shelveChanges(this.myActiveTask, shelfName);
        }
    }

    private LocalTask doActivate(Task origin, boolean explicitly) {
        LocalTask oldActiveTask;
        LocalTaskImpl task2;
        LocalTaskImpl localTaskImpl = task2 = origin instanceof LocalTaskImpl ? (LocalTaskImpl)origin : new LocalTaskImpl(origin);
        if (explicitly) {
            task2.setUpdated(new Date());
        }
        this.myActiveTask.setActive(false);
        task2.setActive(true);
        this.addTask(task2);
        if (task2.isIssue()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)new Task.Backgroundable(this.myProject, "Updating " + task2.getPresentableId()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    TaskManagerImpl.this.updateIssue(task2.getId());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$3", "run"));
                }
            }));
        }
        boolean isChanged = !task2.equals(oldActiveTask = this.myActiveTask);
        this.myActiveTask = task2;
        if (isChanged) {
            ((TaskListener)this.myDispatcher.getMulticaster()).taskDeactivated(oldActiveTask);
            ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated((LocalTask)task2);
        }
        return task2;
    }

    private void addTask(LocalTaskImpl task2) {
        this.myTasks.put(task2.getId(), task2);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskAdded((LocalTask)task2);
    }

    public boolean testConnection(final TaskRepository repository) {
        TestConnectionTask task2 = new TestConnectionTask("Test connection"){

            /*
             * Unable to fully structure code
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                indicator.setText("Connecting to " + repository.getUrl() + "...");
                indicator.setFraction(0.0);
                indicator.setIndeterminate(true);
                try {
                    this.myConnection = repository.createCancellableConnection();
                    if (this.myConnection != null) {
                        future = ApplicationManager.getApplication().executeOnPooledThread((Callable)this.myConnection);
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            try {
                                this.myException = (Exception)future.get(100L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (TimeoutException ignore) {
                                try {
                                    indicator.checkCanceled();
                                    continue;
                                }
                                catch (ProcessCanceledException e) {
                                    this.myException = e;
                                    this.myConnection.cancel();
                                    return;
                                }
                            }
                            ** while (true)
                            catch (Exception e) {
                                this.myException = e;
                                return;
                            }
                            break;
                        }
                    }
                    try {
                        repository.testConnection();
                    }
                    catch (Exception e) {
                        TaskManagerImpl.access$200().info((Throwable)e);
                        this.myException = e;
                    }
                }
                catch (Exception e) {
                    this.myException = e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$4", "run"));
            }
        };
        ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)task2);
        Exception e = task2.myException;
        if (e == null) {
            this.myBadRepositories.remove(repository);
            Messages.showMessageDialog((Project)this.myProject, (String)"Connection is successful", (String)"Connection", (Icon)Messages.getInformationIcon());
        } else if (!(e instanceof ProcessCanceledException)) {
            String message = e.getMessage();
            if (e instanceof UnknownHostException) {
                message = "Unknown host: " + message;
            }
            if (message == null) {
                LOG.error((Throwable)e);
                message = "Unknown error";
            }
            Messages.showErrorDialog((Project)this.myProject, (String)StringUtil.capitalize((String)message), (String)"Error");
        }
        return e == null;
    }

    @NotNull
    public Config getState() {
        this.myConfig.tasks = ContainerUtil.map(this.myTasks.values(), task2 -> new LocalTaskImpl((Task)task2));
        this.myConfig.servers = XmlSerializer.serialize((Object)this.getAllRepositories());
        Config config = this.myConfig;
        if (config == null) {
            TaskManagerImpl.$$$reportNull$$$0(11);
        }
        return config;
    }

    public void loadState(Config config) {
        XmlSerializerUtil.copyBean((Object)config, (Object)this.myConfig);
        this.myRepositories.clear();
        Element element = config.servers;
        ArrayList<TaskRepository> repositories = TaskManagerImpl.loadRepositories(element);
        this.myRepositories.addAll(repositories);
        this.myTasks.clear();
        for (LocalTaskImpl task2 : config.tasks) {
            String url;
            if (task2.getRepository() == null && (url = task2.getIssueUrl()) != null) {
                for (TaskRepository repository : repositories) {
                    if (repository.getUrl() == null || !url.startsWith(repository.getUrl())) continue;
                    task2.setRepository(repository);
                }
            }
            this.addTask(task2);
        }
    }

    public static ArrayList<TaskRepository> loadRepositories(Element element) {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
            for (Object o : element.getChildren()) {
                if (!((Element)o).getName().equals(repositoryType.getName())) continue;
                try {
                    TaskRepository repository = (TaskRepository)XmlSerializer.deserialize((Element)((Element)o), (Class)repositoryType.getRepositoryClass());
                    repository.setRepositoryType(repositoryType);
                    repositories.add(repository);
                }
                catch (XmlSerializationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return repositories;
    }

    public void projectOpened() {
        TaskProjectConfiguration projectConfiguration = this.getProjectConfiguration();
        block0: for (TaskProjectConfiguration.SharedServer server : projectConfiguration.servers) {
            if (server.type == null || server.url == null) continue;
            for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
                if (!repositoryType.getName().equals(server.type)) continue;
                for (TaskRepository repository : this.myRepositories) {
                    if (!repositoryType.equals(repository.getRepositoryType()) || !server.url.equals(repository.getUrl())) continue;
                    continue block0;
                }
                TaskRepository repository = repositoryType.createRepository();
                repository.setUrl(server.url);
                repository.setShared(true);
                this.myRepositories.add(repository);
            }
        }
        this.myContextManager.pack(200, 50);
        LocalTask defaultTask = this.findTask("Default");
        LocalChangeList defaultList = this.myChangeListManager.findChangeList(LocalChangeList.DEFAULT_NAME);
        if (defaultList != null && defaultTask != null) {
            ChangeListInfo listInfo = new ChangeListInfo(defaultList);
            if (!defaultTask.getChangeLists().contains(listInfo)) {
                defaultTask.addChangelist(listInfo);
            }
        }
        for (LocalTask localTask : this.getLocalTasks()) {
            Iterator iterator = localTask.getChangeLists().iterator();
            while (iterator.hasNext()) {
                ChangeListInfo changeListInfo = (ChangeListInfo)iterator.next();
                if (this.myChangeListManager.getChangeList(changeListInfo.id) != null) continue;
                iterator.remove();
            }
        }
        this.myChangeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    private TaskProjectConfiguration getProjectConfiguration() {
        return (TaskProjectConfiguration)ServiceManager.getService((Project)this.myProject, TaskProjectConfiguration.class);
    }

    @NotNull
    public String getComponentName() {
        if ("Task Manager" == null) {
            TaskManagerImpl.$$$reportNull$$$0(12);
        }
        return "Task Manager";
    }

    public void initComponent() {
        LocalTask defaultTask;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCacheRefreshTimer = UIUtil.createNamedTimer((String)"TaskManager refresh", (int)(this.myConfig.updateInterval * 60 * 1000), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateEnabled && !TaskManagerImpl.this.myUpdating) {
                        LOG.debug("Updating issues cache (every " + ((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateInterval + " min)");
                        TaskManagerImpl.this.updateIssues(null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/impl/TaskManagerImpl$5", "actionPerformed"));
                }
            });
            this.myCacheRefreshTimer.setInitialDelay(0);
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(() -> this.myCacheRefreshTimer.start());
        }
        if ((defaultTask = this.findTask("Default")) == null) {
            defaultTask = TaskManagerImpl.createDefaultTask();
            this.addTask((Task)defaultTask);
        }
        LocalTask activeTask = null;
        List<LocalTask> tasks = this.getLocalTasks();
        Collections.sort(tasks, TASK_UPDATE_COMPARATOR);
        for (LocalTask task2 : tasks) {
            if (activeTask == null) {
                if (!task2.isActive()) continue;
                activeTask = task2;
                continue;
            }
            task2.setActive(false);
        }
        if (activeTask == null) {
            activeTask = defaultTask;
        }
        this.myActiveTask = activeTask;
        this.doActivate((Task)this.myActiveTask, false);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated(this.myActiveTask);
    }

    private static LocalTaskImpl createDefaultTask() {
        LocalTaskImpl task2 = new LocalTaskImpl("Default", "Default task");
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        return task2;
    }

    public void disposeComponent() {
        if (this.myCacheRefreshTimer != null) {
            this.myCacheRefreshTimer.stop();
        }
        this.myChangeListManager.removeChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    public void updateIssues(@Nullable Runnable onComplete) {
        TaskRepository first = (TaskRepository)ContainerUtil.find((Object[])this.getAllRepositories(), repository -> repository.isConfigured());
        if (first == null) {
            this.myIssueCache.clear();
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        this.myUpdating = true;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doUpdate(onComplete);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.doUpdate(onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(@Nullable Runnable onComplete) {
        try {
            List<Task> issues = this.getIssuesFromRepositories(null, 0, this.myConfig.updateIssuesCount, false, false, (ProgressIndicator)new EmptyProgressIndicator());
            if (issues == null) {
                return;
            }
            Map<String, Task> map2 = this.myIssueCache;
            synchronized (map2) {
                this.myIssueCache.clear();
                for (Task task2 : issues) {
                    this.myIssueCache.put(task2.getId(), task2);
                }
            }
            map2 = this.myTasks;
            synchronized (map2) {
                for (Map.Entry entry : this.myTasks.entrySet()) {
                    Task issue = this.myIssueCache.get(entry.getKey());
                    if (issue == null) continue;
                    ((LocalTask)entry.getValue()).updateFromIssue(issue);
                }
            }
        }
        finally {
            if (onComplete != null) {
                onComplete.run();
            }
            this.myUpdating = false;
        }
    }

    @Nullable
    private List<Task> getIssuesFromRepositories(@Nullable String request, int offset, int limit, boolean withClosed, boolean forceRequest, @NotNull ProgressIndicator cancelled) {
        if (cancelled == null) {
            TaskManagerImpl.$$$reportNull$$$0(13);
        }
        ArrayList issues = null;
        for (TaskRepository repository : this.getAllRepositories()) {
            if (!repository.isConfigured() || !forceRequest && this.myBadRepositories.contains(repository)) continue;
            try {
                long start = System.currentTimeMillis();
                Object[] tasks = repository.getIssues(request, offset, limit, withClosed, cancelled);
                long timeSpent = System.currentTimeMillis() - start;
                LOG.debug(String.format("Total %s ms to download %d issues from '%s' (pattern '%s')", timeSpent, tasks.length, repository.getUrl(), request));
                this.myBadRepositories.remove(repository);
                if (issues == null) {
                    issues = new ArrayList(tasks.length);
                }
                if (!repository.isSupported(16) && request != null) {
                    List<Task> filteredTasks = TaskUtil.filterTasks(request, ContainerUtil.list((Object[])tasks));
                    ContainerUtil.addAll(issues, filteredTasks);
                    continue;
                }
                ContainerUtil.addAll(issues, (Object[])tasks);
            }
            catch (ProcessCanceledException start) {
            }
            catch (Exception e) {
                String reason = "";
                if (e.getClass() == Exception.class || e instanceof RequestFailedException) {
                    reason = e.getMessage();
                }
                if (e instanceof SocketTimeoutException || e instanceof HttpRequests.HttpStatusException) {
                    LOG.warn("Can't connect to " + repository + ": " + e.getMessage());
                } else {
                    LOG.warn("Cannot connect to " + repository, (Throwable)e);
                }
                this.myBadRepositories.add(repository);
                if (!forceRequest) continue;
                throw new RequestFailedException(repository, reason);
            }
        }
        return issues;
    }

    public boolean isVcsEnabled() {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length > 0;
    }

    public AbstractVcs getActiveVcs() {
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss();
        if (vcss.length == 0) {
            return null;
        }
        for (AbstractVcs vcs : vcss) {
            if (vcs.getType() != VcsType.distributed) continue;
            return vcs;
        }
        return vcss[0];
    }

    public boolean isLocallyClosed(@NotNull LocalTask localTask) {
        if (localTask == null) {
            TaskManagerImpl.$$$reportNull$$$0(14);
        }
        if (this.isVcsEnabled()) {
            List lists = localTask.getChangeLists();
            if (lists.isEmpty()) {
                return true;
            }
            for (ChangeListInfo list2 : lists) {
                if (!StringUtil.isEmpty((String)list2.id)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public LocalTask getAssociatedTask(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(15);
        }
        for (LocalTask task2 : this.getLocalTasks()) {
            for (ChangeListInfo changeListInfo : new ArrayList(task2.getChangeLists())) {
                if (!changeListInfo.id.equals(list2.getId())) continue;
                return task2;
            }
        }
        return null;
    }

    public void trackContext(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            TaskManagerImpl.$$$reportNull$$$0(16);
        }
        ChangeListInfo changeListInfo = new ChangeListInfo(changeList);
        String changeListName = changeList.getName();
        LocalTaskImpl task2 = this.createLocalTask(changeListName);
        task2.addChangelist(changeListInfo);
        this.addTask(task2);
        if (changeList.isDefault()) {
            this.activateTask((Task)task2, false);
        }
    }

    public void decorateChangeList(@NotNull LocalChangeList changeList, @NotNull ColoredTreeCellRenderer cellRenderer, boolean selected, boolean expanded, boolean hasFocus) {
        LocalTask task2;
        if (changeList == null) {
            TaskManagerImpl.$$$reportNull$$$0(17);
        }
        if (cellRenderer == null) {
            TaskManagerImpl.$$$reportNull$$$0(18);
        }
        if ((task2 = this.getAssociatedTask(changeList)) != null && task2.isIssue()) {
            cellRenderer.setIcon(task2.getIcon());
        }
    }

    public void createChangeList(@NotNull LocalTask task2, String name) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(19);
        }
        String comment = TaskUtil.getChangeListComment((Task)task2);
        this.createChangeList(task2, name, comment);
    }

    private void createChangeList(LocalTask task2, String name, @Nullable String comment) {
        LocalChangeList changeList = this.myChangeListManager.findChangeList(name);
        if (changeList == null) {
            changeList = this.myChangeListManager.addChangeList(name, comment);
        } else {
            LocalTask associatedTask = this.getAssociatedTask(changeList);
            if (associatedTask != null) {
                associatedTask.removeChangelist(new ChangeListInfo(changeList));
            }
            this.myChangeListManager.editComment(name, comment);
        }
        task2.addChangelist(new ChangeListInfo(changeList));
        this.myChangeListManager.setDefaultChangeList(changeList);
    }

    public String getChangelistName(Task task2) {
        String name = task2.isIssue() && this.myConfig.changelistNameFormat != null ? TaskUtil.formatTask(task2, this.myConfig.changelistNameFormat, false) : task2.getSummary();
        return StringUtil.shortenTextWithEllipsis((String)name, (int)100, (int)0);
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(20);
        }
        String name = this.constructDefaultBranchName(task2);
        if (task2.isIssue()) {
            String string = name.replace(' ', '-');
            if (string == null) {
                TaskManagerImpl.$$$reportNull$$$0(21);
            }
            return string;
        }
        List words = StringUtil.getWordsIn((String)name);
        String[] strings = ArrayUtil.toStringArray((Collection)words);
        String string = StringUtil.join((String[])strings, (int)0, (int)Math.min(2, strings.length), (String)"-");
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String constructDefaultBranchName(@NotNull Task task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(23);
        }
        String string = task2.isIssue() ? TaskUtil.formatTask(task2, this.myConfig.branchNameFormat, false) : task2.getSummary();
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    public ChangeListAdapter getChangeListListener() {
        return this.myChangeListListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelfName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTask";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestBranchName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDefaultBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTaskListener";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateIssue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLocalTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "activateTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shelveChanges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIssuesFromRepositories";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyClosed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedTask";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trackContext";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "decorateChangeList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createChangeList";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "suggestBranchName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "constructDefaultBranchName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class TestConnectionTask
    extends Task.Modal {
        protected Exception myException;
        @Nullable
        protected TaskRepository.CancellableConnection myConnection;

        public TestConnectionTask(String title) {
            super(TaskManagerImpl.this.myProject, title, true);
        }

        public void onCancel() {
            if (this.myConnection != null) {
                this.myConnection.cancel();
            }
        }
    }

    public static class Config {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="task")
        public List<LocalTaskImpl> tasks = new ArrayList<LocalTaskImpl>();
        public int localTasksCounter = 1;
        public int taskHistoryLength = 50;
        public boolean updateEnabled = true;
        public int updateInterval = 20;
        public int updateIssuesCount = 100;
        public boolean clearContext = true;
        public boolean createChangelist = true;
        public boolean createBranch = true;
        public boolean useBranch = false;
        public boolean shelveChanges = false;
        public boolean commitChanges = true;
        public boolean mergeBranch = true;
        public boolean saveContextOnCommit = true;
        public boolean trackContextForNewChangelist = false;
        public String changelistNameFormat = "{id} {summary}";
        public String branchNameFormat = "{id}";
        public boolean searchClosedTasks = false;
        @Tag(value="servers")
        public Element servers = new Element("servers");
    }
}

