/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaObject {
    @NonNls
    public static final String DEFINITIONS = "definitions";
    @NonNls
    public static final String PROPERTIES = "properties";
    @NotNull
    private final JsonObject myJsonObject;
    private Map<String, JsonSchemaObject> myDefinitionsMap;
    private Map<String, JsonSchemaObject> myProperties;
    private PatternProperties myPatternProperties;
    private PropertyNamePattern myPattern;
    private String myId;
    private String mySchema;
    private String myDescription;
    private String myTitle;
    private JsonSchemaType myType;
    private Object myDefault;
    private String myRef;
    private String myFormat;
    private List<JsonSchemaType> myTypeVariants;
    private Number myMultipleOf;
    private Number myMaximum;
    private boolean myExclusiveMaximum;
    private Number myMinimum;
    private boolean myExclusiveMinimum;
    private Integer myMaxLength;
    private Integer myMinLength;
    private Boolean myAdditionalPropertiesAllowed;
    private JsonSchemaObject myAdditionalPropertiesSchema;
    private Boolean myAdditionalItemsAllowed;
    private JsonSchemaObject myAdditionalItemsSchema;
    private JsonSchemaObject myItemsSchema;
    private List<JsonSchemaObject> myItemsSchemaList;
    private Integer myMaxItems;
    private Integer myMinItems;
    private Boolean myUniqueItems;
    private Integer myMaxProperties;
    private Integer myMinProperties;
    private List<String> myRequired;
    private Map<String, List<String>> myPropertyDependencies;
    private Map<String, JsonSchemaObject> mySchemaDependencies;
    private List<Object> myEnum;
    private List<JsonSchemaObject> myAllOf;
    private List<JsonSchemaObject> myAnyOf;
    private List<JsonSchemaObject> myOneOf;
    private JsonSchemaObject myNot;
    private boolean myShouldValidateAgainstJSType;

    public JsonSchemaObject(@NotNull JsonObject object) {
        if (object == null) {
            JsonSchemaObject.$$$reportNull$$$0(0);
        }
        this.myJsonObject = object;
        this.myProperties = new HashMap<String, JsonSchemaObject>();
    }

    public void mergeValues(JsonSchemaObject other) {
        this.myProperties.putAll(other.myProperties);
        this.myDefinitionsMap = JsonSchemaObject.copyMap(this.myDefinitionsMap, other.myDefinitionsMap);
        Map<String, JsonSchemaObject> map2 = JsonSchemaObject.copyMap(this.myPatternProperties == null ? null : this.myPatternProperties.mySchemasMap, other.myPatternProperties == null ? null : other.myPatternProperties.mySchemasMap);
        PatternProperties patternProperties = this.myPatternProperties = map2 == null ? null : new PatternProperties(map2);
        if (!StringUtil.isEmptyOrSpaces((String)other.myTitle)) {
            this.myTitle = other.myTitle;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myDescription)) {
            this.myDescription = other.myDescription;
        }
        if (other.myType != null) {
            this.myType = other.myType;
        }
        if (other.myDefault != null) {
            this.myDefault = other.myDefault;
        }
        if (other.myRef != null) {
            this.myRef = other.myRef;
        }
        if (other.myFormat != null) {
            this.myFormat = other.myFormat;
        }
        this.myTypeVariants = JsonSchemaObject.copyList(this.myTypeVariants, other.myTypeVariants);
        if (other.myMultipleOf != null) {
            this.myMultipleOf = other.myMultipleOf;
        }
        if (other.myMaximum != null) {
            this.myMaximum = other.myMaximum;
        }
        if (other.myExclusiveMaximum) {
            this.myExclusiveMaximum = other.myExclusiveMaximum;
        }
        if (other.myMinimum != null) {
            this.myMinimum = other.myMinimum;
        }
        if (other.myExclusiveMinimum) {
            this.myExclusiveMinimum = other.myExclusiveMinimum;
        }
        if (other.myMaxLength != null) {
            this.myMaxLength = other.myMaxLength;
        }
        if (other.myMinLength != null) {
            this.myMinLength = other.myMinLength;
        }
        if (other.myPattern != null) {
            this.myPattern = other.myPattern;
        }
        if (other.myAdditionalPropertiesAllowed != null) {
            this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
        }
        if (other.myAdditionalPropertiesSchema != null) {
            this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        }
        if (other.myAdditionalItemsAllowed != null) {
            this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        }
        if (other.myAdditionalItemsSchema != null) {
            this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        }
        if (other.myItemsSchema != null) {
            this.myItemsSchema = other.myItemsSchema;
        }
        this.myItemsSchemaList = JsonSchemaObject.copyList(this.myItemsSchemaList, other.myItemsSchemaList);
        if (other.myMaxItems != null) {
            this.myMaxItems = other.myMaxItems;
        }
        if (other.myMinItems != null) {
            this.myMinItems = other.myMinItems;
        }
        if (other.myUniqueItems != null) {
            this.myUniqueItems = other.myUniqueItems;
        }
        if (other.myMaxProperties != null) {
            this.myMaxProperties = other.myMaxProperties;
        }
        if (other.myMinProperties != null) {
            this.myMinProperties = other.myMinProperties;
        }
        this.myRequired = JsonSchemaObject.copyList(this.myRequired, other.myRequired);
        this.myPropertyDependencies = JsonSchemaObject.copyMap(this.myPropertyDependencies, other.myPropertyDependencies);
        this.mySchemaDependencies = JsonSchemaObject.copyMap(this.mySchemaDependencies, other.mySchemaDependencies);
        if (other.myEnum != null) {
            this.myEnum = other.myEnum;
        }
        this.myAllOf = JsonSchemaObject.copyList(this.myAllOf, other.myAllOf);
        this.myAnyOf = JsonSchemaObject.copyList(this.myAnyOf, other.myAnyOf);
        this.myOneOf = JsonSchemaObject.copyList(this.myOneOf, other.myOneOf);
        if (other.myNot != null) {
            this.myNot = other.myNot;
        }
        this.myShouldValidateAgainstJSType |= other.myShouldValidateAgainstJSType;
    }

    public void shouldValidateAgainstJSType() {
        this.myShouldValidateAgainstJSType = true;
    }

    public boolean isShouldValidateAgainstJSType() {
        return this.myShouldValidateAgainstJSType;
    }

    private static <T> List<T> copyList(List<T> target2, List<T> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = new ArrayList<T>();
        }
        target2.addAll(source);
        return target2;
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> target2, Map<K, V> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = new HashMap();
        }
        target2.putAll(source);
        return target2;
    }

    @NotNull
    public VirtualFile getSchemaFile() {
        VirtualFile virtualFile = this.myJsonObject.getContainingFile().getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            JsonSchemaObject.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @NotNull
    public JsonObject getJsonObject() {
        JsonObject jsonObject = this.myJsonObject;
        if (jsonObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(2);
        }
        return jsonObject;
    }

    public Map<String, JsonSchemaObject> getDefinitionsMap() {
        return this.myDefinitionsMap;
    }

    public void setDefinitionsMap(@NotNull Map<String, JsonSchemaObject> definitionsMap) {
        if (definitionsMap == null) {
            JsonSchemaObject.$$$reportNull$$$0(3);
        }
        this.myDefinitionsMap = definitionsMap;
    }

    public Map<String, JsonSchemaObject> getProperties() {
        return this.myProperties;
    }

    public void setProperties(Map<String, JsonSchemaObject> properties) {
        this.myProperties = properties;
    }

    public void setPatternProperties(Map<String, JsonSchemaObject> patternProperties) {
        this.myPatternProperties = new PatternProperties(patternProperties);
    }

    @Nullable
    public JsonSchemaType getType() {
        return this.myType;
    }

    public void setType(JsonSchemaType type) {
        this.myType = type;
    }

    public Number getMultipleOf() {
        return this.myMultipleOf;
    }

    public void setMultipleOf(Number multipleOf) {
        this.myMultipleOf = multipleOf;
    }

    public Number getMaximum() {
        return this.myMaximum;
    }

    public void setMaximum(Number maximum) {
        this.myMaximum = maximum;
    }

    public boolean isExclusiveMaximum() {
        return this.myExclusiveMaximum;
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.myExclusiveMaximum = exclusiveMaximum;
    }

    public Number getMinimum() {
        return this.myMinimum;
    }

    public void setMinimum(Number minimum) {
        this.myMinimum = minimum;
    }

    public boolean isExclusiveMinimum() {
        return this.myExclusiveMinimum;
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.myExclusiveMinimum = exclusiveMinimum;
    }

    public Integer getMaxLength() {
        return this.myMaxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.myMaxLength = maxLength;
    }

    public Integer getMinLength() {
        return this.myMinLength;
    }

    public void setMinLength(Integer minLength) {
        this.myMinLength = minLength;
    }

    public String getPattern() {
        return this.myPattern == null ? null : this.myPattern.getPattern();
    }

    public void setPattern(String pattern) {
        this.myPattern = pattern == null ? null : new PropertyNamePattern(pattern);
    }

    public Boolean getAdditionalPropertiesAllowed() {
        return this.myAdditionalPropertiesAllowed == null || this.myAdditionalPropertiesAllowed != false;
    }

    public void setAdditionalPropertiesAllowed(Boolean additionalPropertiesAllowed) {
        this.myAdditionalPropertiesAllowed = additionalPropertiesAllowed;
    }

    public JsonSchemaObject getAdditionalPropertiesSchema() {
        return this.myAdditionalPropertiesSchema;
    }

    public void setAdditionalPropertiesSchema(JsonSchemaObject additionalPropertiesSchema) {
        this.myAdditionalPropertiesSchema = additionalPropertiesSchema;
    }

    public Boolean getAdditionalItemsAllowed() {
        return this.myAdditionalItemsAllowed == null || this.myAdditionalItemsAllowed != false;
    }

    public void setAdditionalItemsAllowed(Boolean additionalItemsAllowed) {
        this.myAdditionalItemsAllowed = additionalItemsAllowed;
    }

    public JsonSchemaObject getAdditionalItemsSchema() {
        return this.myAdditionalItemsSchema;
    }

    public void setAdditionalItemsSchema(JsonSchemaObject additionalItemsSchema) {
        this.myAdditionalItemsSchema = additionalItemsSchema;
    }

    public JsonSchemaObject getItemsSchema() {
        return this.myItemsSchema;
    }

    public void setItemsSchema(JsonSchemaObject itemsSchema) {
        this.myItemsSchema = itemsSchema;
    }

    public List<JsonSchemaObject> getItemsSchemaList() {
        return this.myItemsSchemaList;
    }

    public void setItemsSchemaList(List<JsonSchemaObject> itemsSchemaList) {
        this.myItemsSchemaList = itemsSchemaList;
    }

    public Integer getMaxItems() {
        return this.myMaxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.myMaxItems = maxItems;
    }

    public Integer getMinItems() {
        return this.myMinItems;
    }

    public void setMinItems(Integer minItems) {
        this.myMinItems = minItems;
    }

    public boolean isUniqueItems() {
        return Boolean.TRUE.equals(this.myUniqueItems);
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.myUniqueItems = uniqueItems;
    }

    public Integer getMaxProperties() {
        return this.myMaxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        this.myMaxProperties = maxProperties;
    }

    public Integer getMinProperties() {
        return this.myMinProperties;
    }

    public void setMinProperties(Integer minProperties) {
        this.myMinProperties = minProperties;
    }

    public List<String> getRequired() {
        return this.myRequired;
    }

    public void setRequired(List<String> required) {
        this.myRequired = required;
    }

    public Map<String, List<String>> getPropertyDependencies() {
        return this.myPropertyDependencies;
    }

    public void setPropertyDependencies(Map<String, List<String>> propertyDependencies) {
        this.myPropertyDependencies = propertyDependencies;
    }

    public Map<String, JsonSchemaObject> getSchemaDependencies() {
        return this.mySchemaDependencies;
    }

    public void setSchemaDependencies(Map<String, JsonSchemaObject> schemaDependencies) {
        this.mySchemaDependencies = schemaDependencies;
    }

    public List<Object> getEnum() {
        return this.myEnum;
    }

    public void setEnum(List<Object> anEnum) {
        this.myEnum = anEnum;
    }

    public List<JsonSchemaObject> getAllOf() {
        return this.myAllOf;
    }

    public void setAllOf(List<JsonSchemaObject> allOf) {
        this.myAllOf = allOf;
    }

    public List<JsonSchemaObject> getAnyOf() {
        return this.myAnyOf;
    }

    public void setAnyOf(List<JsonSchemaObject> anyOf) {
        this.myAnyOf = anyOf;
    }

    public List<JsonSchemaObject> getOneOf() {
        return this.myOneOf;
    }

    public void setOneOf(List<JsonSchemaObject> oneOf) {
        this.myOneOf = oneOf;
    }

    public JsonSchemaObject getNot() {
        return this.myNot;
    }

    public void setNot(JsonSchemaObject not) {
        this.myNot = not;
    }

    public List<JsonSchemaType> getTypeVariants() {
        return this.myTypeVariants;
    }

    public void setTypeVariants(List<JsonSchemaType> typeVariants) {
        this.myTypeVariants = typeVariants;
    }

    public String getRef() {
        return this.myRef;
    }

    public void setRef(String ref) {
        this.myRef = ref;
    }

    public Object getDefault() {
        if (JsonSchemaType._integer.equals((Object)this.myType)) {
            return this.myDefault instanceof Number ? Integer.valueOf(((Number)this.myDefault).intValue()) : this.myDefault;
        }
        return this.myDefault;
    }

    public void setDefault(Object aDefault) {
        this.myDefault = aDefault;
    }

    public String getFormat() {
        return this.myFormat;
    }

    public void setFormat(String format) {
        this.myFormat = format;
    }

    public String getId() {
        return this.myId;
    }

    public void setId(String id) {
        this.myId = id;
    }

    public String getSchema() {
        return this.mySchema;
    }

    public void setSchema(String schema) {
        this.mySchema = schema;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    @Nullable
    public JsonSchemaObject getMatchingPatternPropertySchema(@NotNull String name) {
        if (name == null) {
            JsonSchemaObject.$$$reportNull$$$0(4);
        }
        if (this.myPatternProperties == null) {
            return null;
        }
        return this.myPatternProperties.getPatternPropertySchema(name);
    }

    public boolean checkByPattern(@NotNull String value) {
        if (value == null) {
            JsonSchemaObject.$$$reportNull$$$0(5);
        }
        return this.myPattern != null && this.myPattern.checkByPattern(value);
    }

    public String getPatternError() {
        return this.myPattern == null ? null : this.myPattern.getPatternError();
    }

    public Map<JsonObject, String> getInvalidPatternProperties() {
        if (this.myPatternProperties != null) {
            Map<String, String> patterns = this.myPatternProperties.getInvalidPatterns();
            if (patterns == null) {
                return null;
            }
            return patterns.entrySet().stream().map(entry -> {
                JsonSchemaObject object = this.myPatternProperties.getSchemaForPattern((String)entry.getKey());
                assert (object != null);
                return Pair.create((Object)object.getJsonObject(), entry.getValue());
            }).collect(Collectors.toMap(o -> (JsonObject)o.getFirst(), o -> (String)o.getSecond()));
        }
        return null;
    }

    @Nullable
    public JsonSchemaObject findRelativeDefinition(@NotNull String ref) {
        if (ref == null) {
            JsonSchemaObject.$$$reportNull$$$0(6);
        }
        if ("#".equals(ref) || StringUtil.isEmpty((String)ref)) {
            return this;
        }
        if (!ref.startsWith("#/")) {
            return null;
        }
        ref = ref.substring(2);
        List parts = StringUtil.split((String)ref, (String)"/");
        JsonSchemaObject current = this;
        for (int i = 0; i < parts.size(); ++i) {
            if (current == null) {
                return null;
            }
            String part = (String)parts.get(i);
            if (DEFINITIONS.equals(part)) {
                if (i == parts.size() - 1) {
                    return null;
                }
                current = current.getDefinitionsMap().get(parts.get(++i));
                continue;
            }
            if (PROPERTIES.equals(part)) {
                if (i == parts.size() - 1) {
                    return null;
                }
                current = current.getProperties().get(parts.get(++i));
                continue;
            }
            current = current.getDefinitionsMap().get(part);
        }
        return current;
    }

    @Nullable
    public String getDocumentation(boolean preferShort) {
        if (preferShort) {
            return StringUtil.isEmptyOrSpaces((String)this.myTitle) ? this.myDescription : this.myTitle;
        }
        return StringUtil.isEmptyOrSpaces((String)this.myDescription) ? this.myTitle : this.myDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaObject object = (JsonSchemaObject)o;
        return this.myJsonObject.equals(object.myJsonObject);
    }

    public int hashCode() {
        return this.myJsonObject.hashCode();
    }

    @NotNull
    private static String adaptSchemaPattern(String pattern) {
        pattern = pattern.startsWith("^") || pattern.startsWith("*") || pattern.startsWith(".") ? pattern : ".*" + pattern;
        pattern = pattern.endsWith("+") || pattern.endsWith("*") || pattern.endsWith("$") ? pattern : pattern + ".*";
        String string = pattern = pattern.replace("\\\\", "\\");
        if (string == null) {
            JsonSchemaObject.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static Pair<Pattern, String> compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(8);
        }
        try {
            return Pair.create((Object)Pattern.compile(JsonSchemaObject.adaptSchemaPattern(pattern)), null);
        }
        catch (PatternSyntaxException e) {
            return Pair.create(null, (Object)e.getMessage());
        }
    }

    public static boolean matchPattern(@NotNull Pattern pattern, @NotNull String s) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(9);
        }
        if (s == null) {
            JsonSchemaObject.$$$reportNull$$$0(10);
        }
        try {
            return pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)s, (long)300L)).matches();
        }
        catch (ProcessCanceledException e) {
            return false;
        }
        catch (Exception e) {
            Logger.getInstance(JsonSchemaObject.class).info((Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionsMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptSchemaPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDefinitionsMap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingPatternPropertySchema";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkByPattern";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compilePattern";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatternProperties {
        private final Map<String, JsonSchemaObject> mySchemasMap;
        private final Map<String, Pattern> myCachedPatterns;
        private final Map<String, String> myCachedPatternProperties;
        private final Map<String, String> myInvalidPatterns;

        public PatternProperties(@NotNull Map<String, JsonSchemaObject> schemasMap) {
            if (schemasMap == null) {
                PatternProperties.$$$reportNull$$$0(0);
            }
            this.mySchemasMap = new HashMap<String, JsonSchemaObject>();
            schemasMap.keySet().forEach(key -> {
                if (schemasMap == null) {
                    PatternProperties.$$$reportNull$$$0(4);
                }
                this.mySchemasMap.put(StringUtil.unescapeBackSlashes((String)key), (JsonSchemaObject)schemasMap.get(key));
            });
            this.myCachedPatterns = new HashMap<String, Pattern>();
            this.myCachedPatternProperties = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
            this.myInvalidPatterns = new HashMap<String, String>();
            this.mySchemasMap.keySet().forEach(key -> {
                Pair pair = JsonSchemaObject.compilePattern(key);
                if (pair.getSecond() != null) {
                    this.myInvalidPatterns.put((String)key, (String)pair.getSecond());
                } else {
                    assert (pair.getFirst() != null);
                    this.myCachedPatterns.put((String)key, (Pattern)pair.getFirst());
                }
            });
        }

        @Nullable
        public JsonSchemaObject getPatternPropertySchema(@NotNull String name) {
            String value;
            if (name == null) {
                PatternProperties.$$$reportNull$$$0(1);
            }
            if ((value = this.myCachedPatternProperties.get(name)) != null) {
                assert (this.mySchemasMap.containsKey(value));
                return this.mySchemasMap.get(value);
            }
            value = this.myCachedPatterns.keySet().stream().filter(key -> {
                if (name == null) {
                    PatternProperties.$$$reportNull$$$0(3);
                }
                return JsonSchemaObject.matchPattern(this.myCachedPatterns.get(key), name);
            }).findFirst().orElse(null);
            if (value != null) {
                this.myCachedPatternProperties.put(name, value);
                assert (this.mySchemasMap.containsKey(value));
                return this.mySchemasMap.get(value);
            }
            return null;
        }

        public Map<String, String> getInvalidPatterns() {
            return this.myInvalidPatterns;
        }

        public JsonSchemaObject getSchemaForPattern(@NotNull String key) {
            if (key == null) {
                PatternProperties.$$$reportNull$$$0(2);
            }
            return this.mySchemasMap.get(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemasMap";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternProperties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPatternPropertySchema";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSchemaForPattern";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getPatternPropertySchema$2";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyNamePattern {
        @NotNull
        private final String myPattern;
        @Nullable
        private final Pattern myCompiledPattern;
        @Nullable
        private final String myPatternError;
        @NotNull
        private final Map<String, Boolean> myValuePatternCache;

        public PropertyNamePattern(@NotNull String pattern) {
            if (pattern == null) {
                PropertyNamePattern.$$$reportNull$$$0(0);
            }
            this.myPattern = StringUtil.unescapeBackSlashes((String)pattern);
            Pair pair = JsonSchemaObject.compilePattern(pattern);
            this.myPatternError = (String)pair.getSecond();
            this.myCompiledPattern = (Pattern)pair.getFirst();
            this.myValuePatternCache = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        }

        @Nullable
        public String getPatternError() {
            return this.myPatternError;
        }

        boolean checkByPattern(@NotNull String name) {
            if (name == null) {
                PropertyNamePattern.$$$reportNull$$$0(1);
            }
            if (this.myPatternError != null) {
                return true;
            }
            if (Boolean.TRUE.equals(this.myValuePatternCache.get(name))) {
                return true;
            }
            assert (this.myCompiledPattern != null);
            boolean matches = JsonSchemaObject.matchPattern(this.myCompiledPattern, name);
            this.myValuePatternCache.put(name, matches);
            return matches;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                PropertyNamePattern.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "checkByPattern";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

