/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeSignatureQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameArgumentQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentListInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.incorrect.call.arguments", new Object[0]);
        if (string == null) {
            PyArgumentListInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyArgumentListInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyArgumentListInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    public static void inspectPyArgumentList(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull TypeEvalContext context, int implicitOffset) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(6);
        }
        if (node.getParent() instanceof PyClass) {
            return;
        }
        PyCallExpression call = node.getCallExpression();
        if (call == null) {
            return;
        }
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
        List<PyCallExpression.PyArgumentsMapping> mappings = call.multiMapArguments(resolveContext, implicitOffset);
        for (PyCallExpression.PyArgumentsMapping mapping : mappings) {
            PyFunction function;
            PyCallable callable;
            PyCallExpression.PyMarkedCallee callee = mapping.getMarkedCallee();
            if (callee == null || !((callable = callee.getElement()) instanceof PyFunction) || !PyKnownDecoratorUtil.hasUnknownOrChangingSignatureDecorator(function = (PyFunction)callable, context) && !PyArgumentListInspection.decoratedClassInitCall(call.getCallee(), function, context)) continue;
            return;
        }
        PyArgumentListInspection.highlightUnexpectedArguments(node, holder, mappings, context);
        PyArgumentListInspection.highlightUnfilledParameters(node, holder, mappings, context);
        PyArgumentListInspection.highlightStarArgumentTypeMismatch(node, holder, context);
    }

    public static void inspectPyArgumentList(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(9);
        }
        PyArgumentListInspection.inspectPyArgumentList(node, holder, context, 0);
    }

    private static boolean decoratedClassInitCall(@Nullable PyExpression callee, @NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyArgumentListInspection.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(11);
        }
        if (callee instanceof PyReferenceExpression && PyUtil.isInit(function)) {
            PsiPolyVariantReference classReference = ((PyReferenceExpression)callee).getReference();
            return Arrays.stream(classReference.multiResolve(false)).map(ResolveResult::getElement).anyMatch(element -> {
                if (context == null) {
                    PyArgumentListInspection.$$$reportNull$$$0(35);
                }
                return element instanceof PyClass && PyKnownDecoratorUtil.hasUnknownOrChangingReturnTypeDecorator((PyClass)element, context);
            });
        }
        return false;
    }

    private static void highlightStarArgumentTypeMismatch(PyArgumentList node, ProblemsHolder holder, TypeEvalContext context) {
        for (PyExpression arg : node.getArguments()) {
            PyType inside_type;
            PyExpression content;
            if (!(arg instanceof PyStarArgument) || (content = PyUtil.peelArgument((PyExpression)PsiTreeUtil.findChildOfType((PsiElement)arg, PyExpression.class))) == null || (inside_type = context.getType(content)) == null || PyTypeChecker.isUnknown(inside_type, context)) continue;
            if (((PyStarArgument)arg).isKeyword()) {
                if (PyABCUtil.isSubtype(inside_type, "Mapping", context)) continue;
                holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.expected.dict.got.$0", inside_type.getName()), new LocalQuickFix[0]);
                continue;
            }
            if (PyABCUtil.isSubtype(inside_type, "Iterable", context)) continue;
            holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.expected.iter.got.$0", inside_type.getName()), new LocalQuickFix[0]);
        }
    }

    private static Set<String> getDuplicateKeywordArguments(@NotNull PyArgumentList node) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(12);
        }
        HashSet<String> keywordArgumentNames = new HashSet<String>();
        HashSet<String> results = new HashSet<String>();
        for (PyExpression argument : node.getArguments()) {
            if (!(argument instanceof PyKeywordArgument)) continue;
            String keyword = ((PyKeywordArgument)argument).getKeyword();
            if (keywordArgumentNames.contains(keyword)) {
                results.add(keyword);
            }
            keywordArgumentNames.add(keyword);
        }
        return results;
    }

    private static void highlightUnexpectedArguments(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(14);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(16);
        }
        if (mappings.isEmpty() || mappings.stream().anyMatch(mapping -> mapping.getUnmappedArguments().isEmpty())) {
            return;
        }
        if (mappings.size() == 1) {
            PyCallExpression.PyMarkedCallee markedCallee;
            Set<String> duplicateKeywords = PyArgumentListInspection.getDuplicateKeywordArguments(node);
            PyCallExpression.PyArgumentsMapping mapping2 = mappings.get(0);
            if (!mapping2.getUnmappedArguments().isEmpty() && mapping2.getUnmappedParameters().isEmpty() && (markedCallee = mapping2.getMarkedCallee()) != null) {
                PyCallable callable = markedCallee.getElement();
                Project project = node.getProject();
                if (callable instanceof PyFunction && !PyChangeSignatureHandler.isNotUnderSourceRoot(project, callable.getContainingFile())) {
                    holder.registerProblem((PsiElement)node, PyBundle.message("INSP.unexpected.arg(s)", new Object[0]), new LocalQuickFix[]{PyChangeSignatureQuickFix.forMismatchedCall(mapping2)});
                }
            }
            for (PyExpression argument : mapping2.getUnmappedArguments()) {
                ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
                if (argument instanceof PyKeywordArgument) {
                    if (duplicateKeywords.contains(((PyKeywordArgument)argument).getKeyword())) continue;
                    quickFixes.add(new PyRenameArgumentQuickFix());
                }
                holder.registerProblem((PsiElement)argument, PyBundle.message("INSP.unexpected.arg", new Object[0]), quickFixes.toArray(new LocalQuickFix[quickFixes.size() - 1]));
            }
        } else {
            holder.registerProblem((PsiElement)node, PyArgumentListInspection.addPossibleCalleesRepresentationAndWrapInHtml(PyBundle.message("INSP.unexpected.arg(s)", new Object[0]), mappings, context), new LocalQuickFix[0]);
        }
    }

    private static void highlightUnfilledParameters(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(18);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(20);
        }
        if (mappings.isEmpty() || mappings.stream().anyMatch(mapping -> mapping.getUnmappedParameters().isEmpty())) {
            return;
        }
        Optional.ofNullable(node.getNode()).map(astNode -> astNode.findChildByType((IElementType)PyTokenTypes.RPAR)).map(ASTNode::getPsi).ifPresent(psi -> {
            if (mappings == null) {
                PyArgumentListInspection.$$$reportNull$$$0(31);
            }
            if (holder == null) {
                PyArgumentListInspection.$$$reportNull$$$0(32);
            }
            if (context == null) {
                PyArgumentListInspection.$$$reportNull$$$0(33);
            }
            if (mappings.size() != 1 || ContainerUtil.exists(((PyCallExpression.PyArgumentsMapping)mappings.get(0)).getUnmappedParameters(), parameter -> parameter.getName() == null)) {
                holder.registerProblem(psi, PyArgumentListInspection.addPossibleCalleesRepresentationAndWrapInHtml(PyBundle.message("INSP.parameter(s).unfilled", new Object[0]), mappings, context), new LocalQuickFix[0]);
            } else {
                ((StreamEx)StreamEx.of(((PyCallExpression.PyArgumentsMapping)mappings.get(0)).getUnmappedParameters()).map(PyCallableParameter::getName).filter(Objects::nonNull)).forEach(name -> {
                    if (holder == null) {
                        PyArgumentListInspection.$$$reportNull$$$0(34);
                    }
                    holder.registerProblem(psi, PyBundle.message("INSP.parameter.$0.unfilled", name), new LocalQuickFix[0]);
                });
            }
        });
    }

    @NotNull
    private static String addPossibleCalleesRepresentationAndWrapInHtml(@NotNull String prefix, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context) {
        if (prefix == null) {
            PyArgumentListInspection.$$$reportNull$$$0(21);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(23);
        }
        String possibleCalleesRepresentation = XmlStringUtil.escapeString((String)PyArgumentListInspection.calculatePossibleCalleesRepresentation(mappings, context));
        String string = XmlStringUtil.wrapInHtml((CharSequence)(prefix + "<br>" + PyBundle.message("INSP.possible.callees", new Object[0]) + ":<br>" + possibleCalleesRepresentation));
        if (string == null) {
            PyArgumentListInspection.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String calculatePossibleCalleesRepresentation(@NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context) {
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(26);
        }
        String string = (String)StreamEx.of(mappings).map(PyCallExpression.PyArgumentsMapping::getMarkedCallee).nonNull().map(markedCallee -> {
            if (context == null) {
                PyArgumentListInspection.$$$reportNull$$$0(30);
            }
            return PyArgumentListInspection.calculatePossibleCalleeRepresentation(markedCallee, context);
        }).nonNull().collect(Collectors.joining("<br>"));
        if (string == null) {
            PyArgumentListInspection.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    private static String calculatePossibleCalleeRepresentation(@NotNull PyCallExpression.PyMarkedCallee markedCallee, @NotNull TypeEvalContext context) {
        if (markedCallee == null) {
            PyArgumentListInspection.$$$reportNull$$$0(28);
        }
        if (context == null) {
            PyArgumentListInspection.$$$reportNull$$$0(29);
        }
        String name = markedCallee.getElement() != null ? markedCallee.getElement().getName() : "";
        List<PyCallableParameter> callableParameters = markedCallee.getCallableType().getParameters(context);
        if (callableParameters == null) {
            return null;
        }
        String parameters = ParamHelper.getPresentableText(callableParameters, true, context);
        String callableNameAndParameters = name + parameters;
        return Optional.ofNullable(PyUtil.as(markedCallee.getElement(), PyFunction.class)).map(PyPossibleClassMember::getContainingClass).map(NavigationItem::getName).map(className -> "__init__".equals(name) ? className + parameters : className + "." + callableNameAndParameters).orElse(callableNameAndParameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 14: 
            case 18: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markedCallee";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleCalleesRepresentationAndWrapInHtml";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleCalleesRepresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inspectPyArgumentList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "decoratedClassInitCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateKeywordArguments";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnexpectedArguments";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnfilledParameters";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleCalleesRepresentationAndWrapInHtml";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleesRepresentation";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleeRepresentation";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculatePossibleCalleesRepresentation$7";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$highlightUnfilledParameters$6";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$decoratedClassInitCall$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session2);
        }

        @Override
        @NotNull
        protected ProblemsHolder getHolder() {
            ProblemsHolder problemsHolder = super.getHolder();
            if (problemsHolder == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return problemsHolder;
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            PyArgumentListInspection.inspectPyArgumentList(node, this.getHolder(), this.myTypeEvalContext);
        }

        @Override
        public void visitPyDecoratorList(PyDecoratorList node) {
            PyDecorator[] decorators;
            for (PyDecorator deco : decorators = node.getDecorators()) {
                PyCallExpression.PyMarkedCallee markedCallee;
                if (deco.hasArgumentList() || (markedCallee = (PyCallExpression.PyMarkedCallee)ContainerUtil.getFirstItem(deco.multiResolveCallee(this.getResolveContext()))) == null || markedCallee.isImplicitlyResolved()) continue;
                PyCallable callable = markedCallee.getElement();
                if (callable == null) {
                    return;
                }
                int firstParamOffset = markedCallee.getImplicitOffset();
                List<PyCallableParameter> params = markedCallee.getCallableType().getParameters(this.myTypeEvalContext);
                if (params == null) {
                    return;
                }
                PyCallableParameter allegedFirstParam = (PyCallableParameter)ContainerUtil.getOrElse(params, (int)(firstParamOffset - 1), null);
                if (allegedFirstParam == null || allegedFirstParam.isKeywordContainer()) {
                    this.registerProblem((PsiElement)deco, PyBundle.message("INSP.func.$0.lacks.first.arg", callable.getName()));
                    continue;
                }
                for (int i = firstParamOffset; i < params.size(); ++i) {
                    PyCallableParameter parameter = params.get(i);
                    if (parameter.getParameter() instanceof PySingleStarParameter || parameter.isKeywordContainer() || parameter.isPositionalContainer() || parameter.hasDefaultValue()) continue;
                    String parameterName = parameter.getName();
                    this.registerProblem((PsiElement)deco, PyBundle.message("INSP.parameter.$0.unfilled", parameterName == null ? "(...)" : parameterName));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

