/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PyTargetExpressionStubImpl;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyTargetExpressionElementType
extends PyStubElementType<PyTargetExpressionStub, PyTargetExpression> {
    private CustomTargetExpressionStubType[] myCustomStubTypes;

    public PyTargetExpressionElementType() {
        super("TARGET_EXPRESSION");
    }

    public PyTargetExpressionElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    private CustomTargetExpressionStubType[] getCustomStubTypes() {
        if (this.myCustomStubTypes == null) {
            this.myCustomStubTypes = (CustomTargetExpressionStubType[])Extensions.getExtensions(CustomTargetExpressionStubType.EP_NAME);
        }
        return this.myCustomStubTypes;
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(1);
        }
        PyTargetExpressionImpl pyTargetExpressionImpl = new PyTargetExpressionImpl(node);
        if (pyTargetExpressionImpl == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(2);
        }
        return pyTargetExpressionImpl;
    }

    public PyTargetExpression createPsi(@NotNull PyTargetExpressionStub stub) {
        if (stub == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(3);
        }
        return new PyTargetExpressionImpl(stub);
    }

    @NotNull
    public PyTargetExpressionStub createStub(@NotNull PyTargetExpression psi, StubElement parentStub) {
        if (psi == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(4);
        }
        String name = psi.getName();
        PyExpression assignedValue = psi.findAssignedValue();
        String docString = DocStringUtil.getDocStringValue(psi);
        String typeComment = psi.getTypeCommentAnnotation();
        String annotation = psi.getAnnotationValue();
        for (CustomTargetExpressionStubType customStubType : this.getCustomStubTypes()) {
            Object customStub = customStubType.createStub(psi);
            if (customStub == null) continue;
            PyTargetExpressionStubImpl pyTargetExpressionStubImpl = new PyTargetExpressionStubImpl(name, docString, typeComment, annotation, (CustomTargetExpressionStub)customStub, parentStub);
            if (pyTargetExpressionStubImpl == null) {
                PyTargetExpressionElementType.$$$reportNull$$$0(5);
            }
            return pyTargetExpressionStubImpl;
        }
        PyTargetExpressionStub.InitializerType initializerType = PyTargetExpressionStub.InitializerType.Other;
        QualifiedName initializer = null;
        if (assignedValue instanceof PyReferenceExpression) {
            initializerType = PyTargetExpressionStub.InitializerType.ReferenceExpression;
            initializer = ((PyReferenceExpression)assignedValue).asQualifiedName();
        } else if (assignedValue instanceof PyCallExpression) {
            initializerType = PyTargetExpressionStub.InitializerType.CallExpression;
            PyExpression callee = ((PyCallExpression)assignedValue).getCallee();
            if (callee instanceof PyReferenceExpression) {
                initializer = ((PyReferenceExpression)callee).asQualifiedName();
            }
        }
        PyTargetExpressionStubImpl pyTargetExpressionStubImpl = new PyTargetExpressionStubImpl(name, docString, initializerType, initializer, psi.isQualified(), typeComment, annotation, parentStub);
        if (pyTargetExpressionStubImpl == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(6);
        }
        return pyTargetExpressionStubImpl;
    }

    public void serialize(@NotNull PyTargetExpressionStub stub, @NotNull StubOutputStream stream) throws IOException {
        if (stub == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(7);
        }
        if (stream == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(8);
        }
        stream.writeName(stub.getName());
        String docString = stub.getDocString();
        stream.writeUTFFast(docString != null ? docString : "");
        stream.writeVarInt(stub.getInitializerType().getIndex());
        stream.writeName(stub.getTypeComment());
        stream.writeName(stub.getAnnotation());
        CustomTargetExpressionStub customStub = stub.getCustomStub(CustomTargetExpressionStub.class);
        if (customStub != null) {
            stream.writeName(customStub.getTypeClass().getCanonicalName());
            customStub.serialize(stream);
        } else {
            QualifiedName.serialize((QualifiedName)stub.getInitializer(), (StubOutputStream)stream);
            stream.writeBoolean(stub.isQualified());
        }
    }

    @NotNull
    public PyTargetExpressionStub deserialize(@NotNull StubInputStream stream, StubElement parentStub) throws IOException {
        String annotation;
        if (stream == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(9);
        }
        String name = StringRef.toString((StringRef)stream.readName());
        String docString = stream.readUTFFast();
        if (docString.isEmpty()) {
            docString = null;
        }
        PyTargetExpressionStub.InitializerType initializerType = PyTargetExpressionStub.InitializerType.fromIndex(stream.readVarInt());
        StringRef typeCommentRef = stream.readName();
        String typeComment = typeCommentRef == null ? null : typeCommentRef.getString();
        StringRef annotationRef = stream.readName();
        String string = annotation = annotationRef == null ? null : annotationRef.getString();
        if (initializerType == PyTargetExpressionStub.InitializerType.Custom) {
            String typeName = stream.readName().getString();
            for (CustomTargetExpressionStubType type : this.getCustomStubTypes()) {
                if (!type.getClass().getCanonicalName().equals(typeName)) continue;
                Object stub = type.deserializeStub(stream);
                PyTargetExpressionStubImpl pyTargetExpressionStubImpl = new PyTargetExpressionStubImpl(name, docString, typeComment, annotation, (CustomTargetExpressionStub)stub, parentStub);
                if (pyTargetExpressionStubImpl == null) {
                    PyTargetExpressionElementType.$$$reportNull$$$0(10);
                }
                return pyTargetExpressionStubImpl;
            }
            throw new IOException("Unknown custom stub type " + typeName);
        }
        QualifiedName initializer = QualifiedName.deserialize((StubInputStream)stream);
        boolean isQualified = stream.readBoolean();
        PyTargetExpressionStubImpl pyTargetExpressionStubImpl = new PyTargetExpressionStubImpl(name, docString, initializerType, initializer, isQualified, typeComment, annotation, parentStub);
        if (pyTargetExpressionStubImpl == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(11);
        }
        return pyTargetExpressionStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        if (PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), PyComprehensionElement.class, (boolean)true, (Class[])new Class[]{PyDocStringOwner.class}) != null) {
            return false;
        }
        ASTNode functionNode = TreeUtil.findParent(node, PyElementTypes.FUNCTION_DECLARATION);
        ASTNode qualifierNode = node.findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getReferenceExpressionTokens());
        if (functionNode != null && qualifierNode != null) {
            PsiElement function = functionNode.getPsi();
            if (function instanceof PyFunction && "__new__".equals(((PyFunction)function).getName())) {
                return true;
            }
            ASTNode parameterList = functionNode.findChildByType(PyElementTypes.PARAMETER_LIST);
            assert (parameterList != null);
            ASTNode[] children2 = parameterList.getChildren(PyElementTypes.FORMAL_PARAMETER_SET);
            if (children2.length > 0 && children2[0].getText().equals(qualifierNode.getText())) {
                return true;
            }
        }
        return functionNode == null && qualifierNode == null;
    }

    @Override
    public void indexStub(@NotNull PyTargetExpressionStub stub, @NotNull IndexSink sink) {
        String name;
        if (stub == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(13);
        }
        if ((name = stub.getName()) != null && PyUtil.getInitialUnderscores(name) == 0 && stub.getParentStub() instanceof PyFileStub) {
            sink.occurrence(PyVariableNameIndex.KEY, (Object)name);
        }
        for (CustomTargetExpressionStubType stubType : this.getCustomStubTypes()) {
            stubType.indexStub(stub, sink);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

