/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PyCustomMemberUtils;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyResolveResultRater;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyOverridingAncestorsClassMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingClassMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassTypeImpl
extends UserDataHolderBase
implements PyClassType {
    @NotNull
    protected final PyClass myClass;
    protected final boolean myIsDefinition;
    private static ThreadLocal<Set<Pair<PyClass, String>>> ourResolveMemberStack = new ThreadLocal<Set<Pair<PyClass, String>>>(){

        @Override
        protected Set<Pair<PyClass, String>> initialValue() {
            return new HashSet<Pair<PyClass, String>>();
        }
    };
    private static Key<Set<PyClassType>> CTX_VISITED = Key.create((String)"PyClassType.Visited");
    public static Key<Boolean> CTX_SUPPRESS_PARENTHESES = Key.create((String)"PyFunction.SuppressParentheses");

    public PyClassTypeImpl(@NotNull PyClass source, boolean isDefinition) {
        if (source == null) {
            PyClassTypeImpl.$$$reportNull$$$0(0);
        }
        PyClass originalElement = CompletionUtil.getOriginalElement(source);
        this.myClass = originalElement != null ? originalElement : source;
        this.myIsDefinition = isDefinition;
    }

    public <T> PyClassTypeImpl withUserData(Key<T> key, T value) {
        this.putUserData(key, value);
        return this;
    }

    @Override
    @NotNull
    public PyClass getPyClass() {
        PyClass pyClass = this.myClass;
        if (pyClass == null) {
            PyClassTypeImpl.$$$reportNull$$$0(1);
        }
        return pyClass;
    }

    @Override
    public boolean isDefinition() {
        return this.myIsDefinition;
    }

    @Override
    @NotNull
    public PyClassType toInstance() {
        PyClassTypeImpl pyClassTypeImpl = this.myIsDefinition ? this.withUserDataCopy(new PyClassTypeImpl(this.myClass, false)) : this;
        if (pyClassTypeImpl == null) {
            PyClassTypeImpl.$$$reportNull$$$0(2);
        }
        return pyClassTypeImpl;
    }

    @Override
    @NotNull
    public PyClassLikeType toClass() {
        PyClassTypeImpl pyClassTypeImpl = this.myIsDefinition ? this : new PyClassTypeImpl(this.myClass, true);
        if (pyClassTypeImpl == null) {
            PyClassTypeImpl.$$$reportNull$$$0(3);
        }
        return pyClassTypeImpl;
    }

    @NotNull
    final <T extends PyClassTypeImpl> T withUserDataCopy(@NotNull T newInstance) {
        if (newInstance == null) {
            PyClassTypeImpl.$$$reportNull$$$0(4);
        }
        newInstance.setUserMap(this.getUserMap());
        T t = newInstance;
        if (t == null) {
            PyClassTypeImpl.$$$reportNull$$$0(5);
        }
        return t;
    }

    @Override
    @Nullable
    public String getClassQName() {
        return this.myClass.getQualifiedName();
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(6);
        }
        List<PyClassLikeType> list2 = this.myClass.getSuperClassTypes(context);
        if (list2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(8);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(9);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(10);
        }
        return this.resolveMember(name, location, direction, resolveContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        Pair key;
        Set<Pair<PyClass, String>> resolving;
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(11);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(12);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(13);
        }
        if ((resolving = ourResolveMemberStack.get()).contains(key = Pair.create((Object)this.myClass, (Object)name))) {
            return Collections.emptyList();
        }
        resolving.add((Pair<PyClass, String>)key);
        try {
            List<? extends RatedResolveResult> list2 = this.doResolveMember(name, location, direction, resolveContext, inherited);
            return list2;
        }
        finally {
            resolving.remove(key);
        }
    }

    @Nullable
    private List<? extends RatedResolveResult> doResolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        List<? extends RatedResolveResult> typeMembers;
        PyType first_arg_type;
        PyExpression first_arg;
        Ref<ResolveResultList> resultRef;
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(14);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(15);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(16);
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        PsiElement classMember = PyClassTypeImpl.resolveByOverridingMembersProviders(this, name, (PsiElement)location, resolveContext);
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (resolveContext.allowProperties() && (resultRef = this.findProperty(name, direction, true, resolveContext.getTypeEvalContext())) != null) {
            return (List)resultRef.get();
        }
        if ("super".equals(this.getClassQName()) && this.isBuiltin() && location instanceof PyCallExpression && (first_arg = ((PyCallExpression)location).getArgument(0, PyExpression.class)) != null && (first_arg_type = context.getType(first_arg)) instanceof PyClassType) {
            PyClass derived_class = ((PyClassType)first_arg_type).getPyClass();
            Iterator<PyClass> base_it = derived_class.getAncestorClasses(context).iterator();
            if (base_it.hasNext()) {
                return new PyClassTypeImpl(base_it.next(), true).resolveMember(name, location, direction, resolveContext);
            }
            return null;
        }
        List<? extends RatedResolveResult> classMembers = PyClassTypeImpl.resolveInner(this.myClass, this.myIsDefinition, name, location, context);
        if ("__class__".equals(name)) {
            return this.resolveDunderClass(context, classMembers);
        }
        if (!classMembers.isEmpty()) {
            return classMembers;
        }
        if ("__doc__".equals(name)) {
            return Optional.ofNullable(PyBuiltinCache.getInstance((PsiElement)this.myClass).getObjectType()).map(type -> {
                if (name == null) {
                    PyClassTypeImpl.$$$reportNull$$$0(68);
                }
                if (direction == null) {
                    PyClassTypeImpl.$$$reportNull$$$0(69);
                }
                if (resolveContext == null) {
                    PyClassTypeImpl.$$$reportNull$$$0(70);
                }
                return type.resolveMember(name, location, direction, resolveContext);
            }).orElse(Collections.emptyList());
        }
        classMember = PyClassTypeImpl.resolveByOverridingAncestorsMembersProviders(this, name, location, resolveContext);
        if (classMember != null) {
            ResolveResultList list2 = new ResolveResultList();
            int rate = 0;
            for (PyResolveResultRater rater : (PyResolveResultRater[])Extensions.getExtensions(PyResolveResultRater.EP_NAME)) {
                rate += rater.getMemberRate(classMember, this, context);
            }
            list2.poke(classMember, rate);
            return list2;
        }
        if (inherited) {
            for (PyClassLikeType type2 : this.myClass.getAncestorTypes(context)) {
                List<? extends RatedResolveResult> results;
                if (type2 instanceof PyClassType) {
                    List<? extends RatedResolveResult> superMembers;
                    if (!this.myIsDefinition) {
                        type2 = (PyClassLikeType)type2.toInstance();
                    }
                    if (!(superMembers = PyClassTypeImpl.resolveInner(((PyClassType)type2).getPyClass(), this.myIsDefinition, name, location, context)).isEmpty()) {
                        return superMembers;
                    }
                }
                if (type2 == null || (results = type2.resolveMember(name, location, direction, resolveContext, false)) == null || results.isEmpty()) continue;
                return results;
            }
        }
        if (inherited && !"__init__".equals(name) && !"__new__".equals(name) && (typeMembers = this.resolveMetaClassMember(name, location, direction, resolveContext)) != null) {
            return typeMembers;
        }
        if (inherited) {
            classMember = PyClassTypeImpl.resolveByMembersProviders(this, name, (PsiElement)location, resolveContext);
        }
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (inherited) {
            for (PyClassLikeType type2 : this.myClass.getAncestorTypes(context)) {
                PyClass pyClass;
                PsiElement superMember;
                if (!(type2 instanceof PyClassType) || (superMember = PyClassTypeImpl.resolveByMembersProviders(new PyClassTypeImpl(pyClass = ((PyClassType)type2).getPyClass(), this.isDefinition()), name, (PsiElement)location, resolveContext)) == null) continue;
                return ResolveResultList.to(superMember);
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveMetaClassMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        List typeInstanceAttributesWithSpecifiedName;
        List<PyTargetExpression> typeInstanceAttributes;
        TypeEvalContext context;
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(17);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(18);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(19);
        }
        if (!this.myClass.isNewStyleClass(context = resolveContext.getTypeEvalContext())) {
            return null;
        }
        PyClassLikeType typeType = this.getMetaClassType(context, true);
        if (typeType == null) {
            return null;
        }
        if (this.isDefinition()) {
            List<? extends RatedResolveResult> typeMembers = typeType.resolveMember(name, location, direction, resolveContext);
            if (!ContainerUtil.isEmpty(typeMembers)) {
                return typeMembers;
            }
            List<? extends RatedResolveResult> typeInstanceMembers = ((PyClassLikeType)typeType.toInstance()).resolveMember(name, location, direction, resolveContext);
            if (!ContainerUtil.isEmpty(typeInstanceMembers)) {
                return typeInstanceMembers;
            }
        } else if (typeType instanceof PyClassType && !ContainerUtil.isEmpty(typeInstanceAttributes = ((PyClassType)typeType).getPyClass().getInstanceAttributes()) && !(typeInstanceAttributesWithSpecifiedName = typeInstanceAttributes.stream().filter(member -> {
            if (name == null) {
                PyClassTypeImpl.$$$reportNull$$$0(67);
            }
            return name.equals(member.getName());
        }).map(member -> new RatedResolveResult(PyReferenceImpl.getRate(member, context), (PsiElement)member)).collect(Collectors.toList())).isEmpty()) {
            return typeInstanceAttributesWithSpecifiedName;
        }
        return null;
    }

    private Ref<ResolveResultList> findProperty(String name, AccessDirection direction, boolean inherited, @Nullable TypeEvalContext context) {
        Maybe<PyCallable> accessor;
        Ref resultRef = null;
        Property property = this.myClass.findProperty(name, inherited, context);
        if (property != null && (accessor = property.getByDirection(direction)).isDefined()) {
            PyTargetExpression site;
            PyCallable accessor_code = accessor.value();
            ResolveResultList ret = new ResolveResultList();
            if (accessor_code != null) {
                ret.poke((PsiElement)accessor_code, 0);
            }
            if ((site = property.getDefinitionSite()) != null) {
                ret.poke(site, -1000);
            }
            resultRef = ret.size() > 0 ? Ref.create((Object)ret) : Ref.create();
        }
        return resultRef;
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveDunderClass(@NotNull TypeEvalContext context, @NotNull List<? extends RatedResolveResult> classMembers) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(20);
        }
        if (classMembers == null) {
            PyClassTypeImpl.$$$reportNull$$$0(21);
        }
        boolean newStyleClass = this.myClass.isNewStyleClass(context);
        if (!this.myIsDefinition) {
            if (newStyleClass && !classMembers.isEmpty()) {
                return classMembers;
            }
            return ResolveResultList.to(this.myClass.getAncestorClasses(context).stream().filter(cls -> !PyUtil.isObjectClass(cls)).map(cls -> {
                if (context == null) {
                    PyClassTypeImpl.$$$reportNull$$$0(66);
                }
                return cls.findClassAttribute("__class__", true, context);
            }).filter(target2 -> target2 != null).findFirst().orElse((PsiElement)this.myClass));
        }
        if (LanguageLevel.forElement((PsiElement)this.myClass).isOlderThan(LanguageLevel.PYTHON30) && !newStyleClass) {
            return classMembers;
        }
        return Optional.ofNullable(PyBuiltinCache.getInstance((PsiElement)this.myClass).getTypeType()).map(typeType -> ResolveResultList.to((PsiElement)typeType.getPyClass())).orElse(null);
    }

    @Override
    @Nullable
    public PyClassLikeType getMetaClassType(@NotNull TypeEvalContext context, boolean inherited) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(22);
        }
        if (!inherited) {
            return PyUtil.as(this.myClass.getMetaClassType(context), PyClassLikeType.class);
        }
        List<PyClassLikeType> metaClassTypes = this.getAllExplicitMetaClassTypes(context);
        PyClassLikeType mostDerivedMeta = PyClassTypeImpl.getMostDerivedClassType(metaClassTypes, context);
        return mostDerivedMeta != null ? mostDerivedMeta : PyBuiltinCache.getInstance((PsiElement)this.myClass).getObjectType("type");
    }

    @Nullable
    private static PyClassLikeType getMostDerivedClassType(@NotNull List<PyClassLikeType> classTypes, @NotNull TypeEvalContext context) {
        if (classTypes == null) {
            PyClassTypeImpl.$$$reportNull$$$0(23);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(24);
        }
        if (classTypes.isEmpty()) {
            return null;
        }
        try {
            String abcMeta = "abc.ABCMeta";
            return classTypes.stream().filter(t -> !"abc.ABCMeta".equals(t.getClassQName())).max((t1, t2) -> {
                if (context == null) {
                    PyClassTypeImpl.$$$reportNull$$$0(65);
                }
                if (Objects.equals(t1, t2)) {
                    return 0;
                }
                if (t2 == null || t1 != null && Sets.newHashSet(t1.getAncestorTypes(context)).contains(t2)) {
                    return 1;
                }
                if (t1 == null || Sets.newHashSet(t2.getAncestorTypes(context)).contains(t1)) {
                    return -1;
                }
                throw new NotDerivedClassTypeException();
            }).orElse(null);
        }
        catch (NotDerivedClassTypeException ignored) {
            return null;
        }
    }

    private List<PyClassLikeType> getAllExplicitMetaClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(25);
        }
        ArrayList results = Lists.newArrayList();
        PyClassLikeType ownMeta = this.getMetaClassType(context, false);
        if (ownMeta != null) {
            results.add(ownMeta);
        }
        for (PyClassLikeType ancestor : this.myClass.getAncestorTypes(context)) {
            PyClassLikeType ancestorMeta;
            if (ancestor == null || (ancestorMeta = ancestor.getMetaClassType(context, false)) == null) continue;
            results.add(ancestorMeta);
        }
        return results;
    }

    @Override
    public boolean isCallable() {
        if (this.isDefinition()) {
            return true;
        }
        if (PyClassTypeImpl.isMethodType(this)) {
            return true;
        }
        PyClass cls = this.getPyClass();
        return PyABCUtil.isSubclass(cls, "Callable", null);
    }

    private static boolean isMethodType(@NotNull PyClassType type) {
        PyBuiltinCache builtinCache;
        if (type == null) {
            PyClassTypeImpl.$$$reportNull$$$0(26);
        }
        return type.equals((builtinCache = PyBuiltinCache.getInstance((PsiElement)type.getPyClass())).getClassMethodType()) || type.equals(builtinCache.getStaticMethodType());
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(27);
        }
        return this.getPossibleCallType(context, null);
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(28);
        }
        if (callSite == null) {
            PyClassTypeImpl.$$$reportNull$$$0(29);
        }
        return this.getPossibleCallType(context, callSite);
    }

    @Nullable
    private PyType getPossibleCallType(@NotNull TypeEvalContext context, @Nullable PyCallSiteExpression callSite) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(30);
        }
        if (!this.isDefinition()) {
            return PyUtil.getReturnTypeOfMember(this, "__call__", callSite, context);
        }
        return this.withUserDataCopy(new PyClassTypeImpl(this.getPyClass(), false));
    }

    @Override
    @NotNull
    public final List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(31);
        }
        List list2 = this.myClass.getAncestorTypes(context);
        if (list2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyClassType aClass, String name, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(33);
        }
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            PsiElement resolveResult = provider.resolveMember(aClass, name, location, resolveContext);
            if (resolveResult == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(PyClassType aClass, String name, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(34);
        }
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingClassMembersProvider) || (resolveResult = provider.resolveMember(aClass, name, location, resolveContext)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingAncestorsMembersProviders(PyClassType type, String name, @Nullable PyExpression location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(35);
        }
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingAncestorsClassMembersProvider) || (resolveResult = provider.resolveMember(type, name, (PsiElement)location, resolveContext)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @NotNull
    private static List<? extends RatedResolveResult> resolveInner(@NotNull PyClass cls, boolean isDefinition, @NotNull String name, @Nullable PyExpression location, @NotNull TypeEvalContext context) {
        Collection<PsiElement> result2;
        if (cls == null) {
            PyClassTypeImpl.$$$reportNull$$$0(36);
        }
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(37);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(38);
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(name);
        if (!isDefinition && !cls.processInstanceLevelDeclarations(processor2, (PsiElement)location)) {
            result2 = processor2.getElements();
        } else {
            cls.processClassLevelDeclarations(processor2);
            result2 = processor2.getElements();
        }
        List list2 = ContainerUtil.map(result2, element -> {
            if (context == null) {
                PyClassTypeImpl.$$$reportNull$$$0(64);
            }
            return new RatedResolveResult(PyReferenceImpl.getRate(element, context), (PsiElement)element);
        });
        if (list2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(39);
        }
        return list2;
    }

    @Override
    public Object[] getCompletionVariants(String prefix, PsiElement location, ProcessingContext context) {
        PyClass instanceClass;
        HashSet<PyClassTypeImpl> visited = (HashSet<PyClassTypeImpl>)context.get(CTX_VISITED);
        if (visited == null) {
            visited = new HashSet<PyClassTypeImpl>();
            context.put(CTX_VISITED, visited);
        }
        if (visited.contains(this)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        visited.add(this);
        HashSet<String> namesAlready = (HashSet<String>)context.get(CTX_NAMES);
        if (namesAlready == null) {
            namesAlready = new HashSet<String>();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        boolean suppressParentheses = context.get(CTX_SUPPRESS_PARENTHESES) != null;
        this.addOwnClassMembers(location, namesAlready, suppressParentheses, ret, prefix);
        PsiFile origin = location != null ? CompletionUtil.getOriginalOrSelf(location).getContainingFile() : null;
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(this.myClass.getProject(), origin);
        this.addInheritedMembers(prefix, location, namesAlready, context, ret, typeEvalContext);
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            for (PyCustomMember member : provider.getMembers(this, location, typeEvalContext)) {
                String name = member.getName();
                if (namesAlready.contains(name)) continue;
                ret.add(PyCustomMemberUtils.toLookUpElement(member, this.getName()));
            }
        }
        if (!this.myClass.isNewStyleClass(typeEvalContext) && (instanceClass = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)"types.InstanceType"), PyResolveImportUtil.fromFoothold((PsiElement)this.myClass)), PyClass.class)) != null) {
            PyClassTypeImpl instanceType = new PyClassTypeImpl(instanceClass, false);
            ret.addAll(Arrays.asList(instanceType.getCompletionVariants(prefix, location, context)));
        }
        Collections.addAll(ret, this.getMetaClassCompletionVariants(prefix, location, context, typeEvalContext));
        return ret.toArray();
    }

    @NotNull
    private Object[] getMetaClassCompletionVariants(@Nullable String prefix, @Nullable PsiElement location, @NotNull ProcessingContext processingContext, @NotNull TypeEvalContext typeEvalContext) {
        if (processingContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(40);
        }
        if (typeEvalContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(41);
        }
        if (!this.myClass.isNewStyleClass(typeEvalContext)) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                PyClassTypeImpl.$$$reportNull$$$0(42);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PyClassLikeType typeType = this.getMetaClassType(typeEvalContext, true);
        if (typeType == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                PyClassTypeImpl.$$$reportNull$$$0(43);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (this.isDefinition()) {
            Object[] objectArray = typeType.getCompletionVariants(prefix, location, processingContext);
            if (objectArray == null) {
                PyClassTypeImpl.$$$reportNull$$$0(44);
            }
            return objectArray;
        }
        if (typeType instanceof PyClassType) {
            List<PyTargetExpression> typeInstanceAttributes = ((PyClassType)typeType).getPyClass().getInstanceAttributes();
            Object[] objectArray = ContainerUtil.map2Array(typeInstanceAttributes, LookupElementBuilder::create);
            if (objectArray == null) {
                PyClassTypeImpl.$$$reportNull$$$0(45);
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            PyClassTypeImpl.$$$reportNull$$$0(46);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void visitMembers(@NotNull Processor<PsiElement> processor2, boolean inherited, @NotNull TypeEvalContext context) {
        if (processor2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(47);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(48);
        }
        this.myClass.visitMethods(new MyProcessorWrapper<PyFunction>(processor2), false, context);
        this.myClass.visitClassAttributes(new MyProcessorWrapper<PyTargetExpression>(processor2), false, context);
        for (PyTargetExpression expression : this.myClass.getInstanceAttributes()) {
            processor2.process((Object)expression);
        }
        if (!inherited) {
            return;
        }
        for (PyClassLikeType type : this.getAncestorTypes(context)) {
            if (type == null) continue;
            type.visitMembers(processor2, false, context);
        }
        this.visitMetaClassMembers(processor2, context);
    }

    private void visitMetaClassMembers(@NotNull Processor<PsiElement> processor2, @NotNull TypeEvalContext context) {
        if (processor2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(49);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(50);
        }
        if (!this.myClass.isNewStyleClass(context)) {
            return;
        }
        PyClassLikeType typeType = this.getMetaClassType(context, true);
        if (typeType == null) {
            return;
        }
        if (this.isDefinition()) {
            typeType.visitMembers(processor2, true, context);
        } else if (typeType instanceof PyClassType) {
            ((PyClassType)typeType).getPyClass().getInstanceAttributes().forEach(arg_0 -> processor2.process(arg_0));
        }
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(51);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (PyFunction function : this.myClass.getMethods()) {
            result2.add(function.getName());
        }
        for (PyTargetExpression expression : this.myClass.getClassAttributes()) {
            result2.add(expression.getName());
        }
        for (PyTargetExpression expression : this.myClass.getInstanceAttributes()) {
            result2.add(expression.getName());
        }
        result2.addAll((Collection)ObjectUtils.notNull(this.myClass.getSlots(context), Collections.emptyList()));
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            for (PyCustomMember member : provider.getMembers(this, null, context)) {
                result2.add(member.getName());
            }
        }
        if (inherited) {
            for (PyClassLikeType type : this.getAncestorTypes(context)) {
                if (type == null) continue;
                PyClassLikeType ancestorType = this.isDefinition() ? type : (PyClassLikeType)type.toInstance();
                result2.addAll(ancestorType.getMemberNames(false, context));
            }
            result2.addAll(this.getMetaClassMemberNames(context));
        }
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            PyClassTypeImpl.$$$reportNull$$$0(52);
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<String> getMetaClassMemberNames(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(53);
        }
        if (!this.myClass.isNewStyleClass(context)) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                PyClassTypeImpl.$$$reportNull$$$0(54);
            }
            return set2;
        }
        PyClassLikeType typeType = this.getMetaClassType(context, true);
        if (typeType == null) {
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                PyClassTypeImpl.$$$reportNull$$$0(55);
            }
            return set3;
        }
        if (this.isDefinition()) {
            Set<String> set4 = typeType.getMemberNames(true, context);
            if (set4 == null) {
                PyClassTypeImpl.$$$reportNull$$$0(56);
            }
            return set4;
        }
        if (typeType instanceof PyClassType) {
            List<PyTargetExpression> typeInstanceAttributes = ((PyClassType)typeType).getPyClass().getInstanceAttributes();
            Set set5 = ContainerUtil.map2SetNotNull(typeInstanceAttributes, NavigationItem::getName);
            if (set5 == null) {
                PyClassTypeImpl.$$$reportNull$$$0(57);
            }
            return set5;
        }
        Set<String> set6 = Collections.emptySet();
        if (set6 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(58);
        }
        return set6;
    }

    private void addOwnClassMembers(PsiElement expressionHook, Set<String> namesAlready, boolean suppressParentheses, List<Object> ret, @Nullable String prefix) {
        List<String> slots;
        PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)expressionHook, PyClass.class);
        if (containingClass != null) {
            containingClass = CompletionUtil.getOriginalElement(containingClass);
        }
        boolean withinOurClass = containingClass == this.getPyClass() || PyClassTypeImpl.isInSuperCall(expressionHook);
        CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor(expressionHook, new FilterNotInstance(this.myClass), null, false, suppressParentheses);
        this.myClass.processClassLevelDeclarations(processor2);
        TypeEvalContext context = expressionHook != null ? TypeEvalContext.codeCompletion(this.myClass.getProject(), this.myClass.getContainingFile()) : null;
        List<String> list2 = slots = this.myClass.isNewStyleClass(context) ? this.myClass.getSlots(context) : null;
        if (slots != null) {
            processor2.setAllowedNames(slots);
        }
        this.myClass.processInstanceLevelDeclarations(processor2, expressionHook);
        for (LookupElement le : processor2.getResultList()) {
            String name = le.getLookupString();
            if (namesAlready.contains(name) || !withinOurClass && PyClassTypeImpl.isClassPrivate(name) || !withinOurClass && PyClassTypeImpl.isClassProtected(name) && prefix == null) continue;
            namesAlready.add(name);
            ret.add(le);
        }
        if (slots != null) {
            for (String name : slots) {
                if (namesAlready.contains(name)) continue;
                ret.add(LookupElementBuilder.create((String)name));
            }
        }
    }

    private static boolean isInSuperCall(PsiElement hook) {
        if (hook instanceof PyReferenceExpression) {
            PyExpression qualifier = ((PyReferenceExpression)hook).getQualifier();
            return qualifier instanceof PyCallExpression && ((PyCallExpression)qualifier).isCalleeText("super");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void addInheritedMembers(String name, PsiElement expressionHook, Set<String> namesAlready, ProcessingContext context, List<Object> ret, @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(59);
        }
        for (PyType pyType : this.myClass.getSuperClassTypes(typeEvalContext)) {
            void var8_8;
            Object[] ancestry;
            if (!(pyType instanceof PyClassLikeType)) continue;
            PyClassLikeType classLikeType = (PyClassLikeType)pyType;
            if (classLikeType.isDefinition() && !this.myIsDefinition) {
                Object t = classLikeType.toInstance();
            }
            for (Object ob : ancestry = var8_8.getCompletionVariants(name, expressionHook, context)) {
                String inheritedName = ob.toString();
                if (namesAlready.contains(inheritedName) || PyClassTypeImpl.isClassPrivate(inheritedName)) continue;
                ret.add(ob);
                namesAlready.add(inheritedName);
            }
            ContainerUtil.addAll(ret, (Object[])ancestry);
        }
    }

    private static boolean isClassPrivate(String lookup_string) {
        return lookup_string.startsWith("__") && !lookup_string.endsWith("__");
    }

    private static boolean isClassProtected(@NotNull String lookupString) {
        if (lookupString == null) {
            PyClassTypeImpl.$$$reportNull$$$0(60);
        }
        return lookupString.startsWith("_") && !lookupString.startsWith("__");
    }

    @Override
    @Nullable
    public String getName() {
        return this.getPyClass().getName();
    }

    @Override
    public boolean isBuiltin() {
        return PyBuiltinCache.getInstance((PsiElement)this.myClass).isBuiltin((PsiElement)this.myClass);
    }

    @Override
    public void assertValid(String message) {
        if (!this.myClass.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myClass, this.myClass.getClass().toString() + ": " + message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyClassTypeImpl classType = (PyClassTypeImpl)o;
        if (this.myIsDefinition != classType.myIsDefinition) {
            return false;
        }
        return this.myClass.equals(classType.myClass);
    }

    public int hashCode() {
        int result2 = this.myClass.hashCode();
        result2 = 31 * result2 + (this.myIsDefinition ? 1 : 0);
        return result2;
    }

    public static boolean is(@NotNull String qName, PyType type) {
        if (qName == null) {
            PyClassTypeImpl.$$$reportNull$$$0(61);
        }
        if (type instanceof PyClassType) {
            return qName.equals(((PyClassType)type).getClassQName());
        }
        return false;
    }

    public String toString() {
        return (this.isValid() ? "" : "[INVALID] ") + "PyClassType: " + this.getClassQName();
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid();
    }

    @Nullable
    public static PyClassTypeImpl createTypeByQName(@NotNull PsiElement anchor, @NotNull String classQualifiedName, boolean isDefinition) {
        PyClass pyClass;
        if (anchor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(62);
        }
        if (classQualifiedName == null) {
            PyClassTypeImpl.$$$reportNull$$$0(63);
        }
        if ((pyClass = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(classQualifiedName, anchor)) == null) {
            return null;
        }
        return new PyClassTypeImpl(pyClass, isDefinition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 32: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 32: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 32: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyClassTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInstance";
                break;
            }
            case 6: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 38: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 37: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 33: 
            case 34: 
            case 35: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembers";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classTypes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 41: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyClassTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPyClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withUserDataCopy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassTypes";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypes";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaClassCompletionVariants";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaClassMemberNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 32: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withUserDataCopy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doResolveMember";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveMetaClassMember";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveDunderClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMostDerivedClassType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllExplicitMetaClassTypes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isMethodType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleCallType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveByMembersProviders";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingMembersProviders";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingAncestorsMembersProviders";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassCompletionVariants";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitMembers";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitMetaClassMembers";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassMemberNames";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addInheritedMembers";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isClassProtected";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByQName";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveInner$9";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMostDerivedClassType$8";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveDunderClass$4";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveMetaClassMember$1";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doResolveMember$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 32: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilterNotInstance
    implements Condition<PsiElement> {
        Object instance;

        public FilterNotInstance(Object instance) {
            this.instance = instance;
        }

        public boolean value(PsiElement target2) {
            return this.instance != target2;
        }
    }

    private static final class MyProcessorWrapper<T extends PsiElement>
    implements Processor<T> {
        private final Processor<PsiElement> myProcessor;

        private MyProcessorWrapper(@NotNull Processor<PsiElement> processor2) {
            if (processor2 == null) {
                MyProcessorWrapper.$$$reportNull$$$0(0);
            }
            this.myProcessor = processor2;
        }

        public boolean process(T t) {
            this.myProcessor.process(t);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/types/PyClassTypeImpl$MyProcessorWrapper", "<init>"));
        }
    }

    private static final class NotDerivedClassTypeException
    extends RuntimeException {
        private NotDerivedClassTypeException() {
        }
    }
}

