/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.RemoteProcessControl;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PyRemoteTracebackFilter;
import com.jetbrains.python.run.PythonCommandLineEnvironmentProvider;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonCommandLineState
extends CommandLineState {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.run.PythonCommandLineState");
    public static final String GROUP_EXE_OPTIONS = "Exe Options";
    public static final String GROUP_DEBUGGER = "Debugger";
    public static final String GROUP_PROFILER = "Profiler";
    public static final String GROUP_COVERAGE = "Coverage";
    public static final String GROUP_SCRIPT = "Script";
    private final AbstractPythonRunConfiguration myConfig;
    private Boolean myMultiprocessDebug = null;
    private boolean myRunWithPty = PtyCommandLine.isEnabled();

    public boolean isRunWithPty() {
        return this.myRunWithPty;
    }

    public boolean isDebug() {
        return "PyDebugRunner".equals(this.getEnvironment().getRunner().getRunnerId());
    }

    public static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)e);
        }
        return serverSocket;
    }

    public PythonCommandLineState(AbstractPythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(env);
        this.myConfig = runConfiguration;
    }

    @Nullable
    public PythonSdkFlavor getSdkFlavor() {
        return PythonSdkFlavor.getFlavor(this.myConfig.getInterpreterPath());
    }

    @Nullable
    public Sdk getSdk() {
        return this.myConfig.getSdk();
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            PythonCommandLineState.$$$reportNull$$$0(0);
        }
        if (runner == null) {
            PythonCommandLineState.$$$reportNull$$$0(1);
        }
        ExecutionResult executionResult = this.execute(executor, (CommandLinePatcher[])null);
        if (executionResult == null) {
            PythonCommandLineState.$$$reportNull$$$0(2);
        }
        return executionResult;
    }

    public ExecutionResult execute(Executor executor, CommandLinePatcher ... patchers) throws ExecutionException {
        return this.execute(executor, this.getDefaultPythonProcessStarter(), patchers);
    }

    public ExecutionResult execute(Executor executor, PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler2 = this.startProcess(processStarter, patchers);
        ConsoleView console = this.createAndAttachConsole(this.myConfig.getProject(), processHandler2, executor);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler2, this.createActions(console, processHandler2));
    }

    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler2, Executor executor) throws ExecutionException {
        ConsoleView consoleView = this.createConsoleBuilder(project).getConsole();
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler2));
        this.addTracebackFilter(project, consoleView, processHandler2);
        consoleView.attachToProcess(processHandler2);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(3);
        }
        return consoleView2;
    }

    protected void addTracebackFilter(Project project, ConsoleView consoleView, ProcessHandler processHandler2) {
        if (PySdkUtil.isRemote(this.myConfig.getSdk())) {
            assert (processHandler2 instanceof RemoteProcessControl);
            consoleView.addMessageFilter((Filter)new PyRemoteTracebackFilter(project, this.myConfig.getWorkingDirectory(), (RemoteProcessControl)processHandler2));
        } else {
            consoleView.addMessageFilter((Filter)new PythonTracebackFilter(project, this.myConfig.getWorkingDirectorySafe()));
        }
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler2));
    }

    private TextConsoleBuilder createConsoleBuilder(Project project) {
        if (this.isDebug()) {
            return new PyDebugConsoleBuilder(project, PythonSdkType.findSdkByPath(this.myConfig.getInterpreterPath()));
        }
        return TextConsoleBuilderFactory.getInstance().createBuilder(project);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler2 = this.startProcess(this.getDefaultPythonProcessStarter(), new CommandLinePatcher[0]);
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(4);
        }
        return processHandler2;
    }

    @Deprecated
    @NotNull
    protected ProcessHandler startProcess(CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler2 = this.startProcess(this.getDefaultPythonProcessStarter(), patchers);
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(5);
        }
        return processHandler2;
    }

    @NotNull
    protected ProcessHandler startProcess(PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        GeneralCommandLine commandLine = this.generateCommandLine(patchers);
        PythonRunConfigurationExtensionsManager.getInstance().patchCommandLine((RunConfigurationBase)this.myConfig, this.getRunnerSettings(), commandLine, this.getEnvironment().getRunner().getRunnerId());
        ProcessHandler processHandler2 = processStarter.start(this.myConfig, commandLine);
        PythonRunConfigurationExtensionsManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfig, processHandler2, this.getRunnerSettings());
        ProcessHandler processHandler3 = processHandler2;
        if (processHandler3 == null) {
            PythonCommandLineState.$$$reportNull$$$0(6);
        }
        return processHandler3;
    }

    @NotNull
    protected final PythonProcessStarter getDefaultPythonProcessStarter() {
        PythonProcessStarter pythonProcessStarter = (config, commandLine) -> {
            ProcessHandler processHandler2;
            Sdk sdk = PythonSdkType.findSdkByPath(this.myConfig.getInterpreterPath());
            if (PySdkUtil.isRemote(sdk)) {
                PyRemotePathMapper pathMapper = this.createRemotePathMapper();
                processHandler2 = this.createRemoteProcessStarter().startRemoteProcess(sdk, commandLine, this.myConfig.getProject(), pathMapper);
            } else {
                EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((GeneralCommandLine)commandLine);
                processHandler2 = this.doCreateProcess(commandLine);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler2);
            }
            return processHandler2;
        };
        if (pythonProcessStarter == null) {
            PythonCommandLineState.$$$reportNull$$$0(7);
        }
        return pythonProcessStarter;
    }

    @Nullable
    private PyRemotePathMapper createRemotePathMapper() {
        if (this.myConfig.getMappingSettings() == null) {
            return null;
        }
        return PyRemotePathMapper.fromSettings(this.myConfig.getMappingSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    protected PyRemoteProcessStarter createRemoteProcessStarter() {
        return new PyRemoteProcessStarter();
    }

    public GeneralCommandLine generateCommandLine(CommandLinePatcher[] patchers) {
        GeneralCommandLine commandLine = this.generateCommandLine();
        if (patchers != null) {
            for (CommandLinePatcher patcher : patchers) {
                if (patcher == null) continue;
                patcher.patchCommandLine(commandLine);
            }
        }
        return commandLine;
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcess(commandLine);
    }

    public GeneralCommandLine generateCommandLine() {
        GeneralCommandLine commandLine = PythonCommandLineState.createPythonCommandLine(this.myConfig.getProject(), this.myConfig, this.isDebug(), this.myRunWithPty);
        this.buildCommandLineParameters(commandLine);
        this.customizeEnvironmentVars(commandLine.getEnvironment(), this.myConfig.isPassParentEnvs());
        return commandLine;
    }

    @NotNull
    public static GeneralCommandLine createPythonCommandLine(Project project, PythonRunParams config, boolean isDebug, boolean runWithPty) {
        GeneralCommandLine commandLine = PythonCommandLineState.generalCommandLine(runWithPty);
        commandLine.withCharset(EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
        PythonCommandLineState.createStandardGroups(commandLine);
        PythonCommandLineState.initEnvironment(project, commandLine, config, isDebug);
        PythonCommandLineState.setRunnerPath(project, commandLine, config);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    private static GeneralCommandLine generalCommandLine(boolean runWithPty) {
        return runWithPty ? new PtyCommandLine() : new GeneralCommandLine();
    }

    public static void createStandardGroups(GeneralCommandLine commandLine) {
        ParametersList params = commandLine.getParametersList();
        params.addParamsGroup(GROUP_EXE_OPTIONS);
        params.addParamsGroup(GROUP_DEBUGGER);
        params.addParamsGroup(GROUP_PROFILER);
        params.addParamsGroup(GROUP_COVERAGE);
        params.addParamsGroup(GROUP_SCRIPT);
    }

    protected static void initEnvironment(Project project, GeneralCommandLine commandLine, PythonRunParams runParams, boolean isDebug) {
        HashMap env = Maps.newHashMap();
        PythonCommandLineState.setupEncodingEnvs(env, commandLine.getCharset());
        if (runParams.getEnvs() != null) {
            env.putAll(runParams.getEnvs());
        }
        PythonCommandLineState.addCommonEnvironmentVariables(PythonCommandLineState.getInterpreterPath(project, runParams), env);
        PythonCommandLineState.setupVirtualEnvVariables(runParams, env, runParams.getSdkHome());
        commandLine.getEnvironment().clear();
        commandLine.getEnvironment().putAll(env);
        commandLine.withParentEnvironmentType(runParams.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        PythonCommandLineState.buildPythonPath(project, commandLine, runParams, isDebug);
        for (PythonCommandLineEnvironmentProvider envProvider : (PythonCommandLineEnvironmentProvider[])Extensions.getExtensions(PythonCommandLineEnvironmentProvider.EP_NAME)) {
            envProvider.extendEnvironment(project, commandLine, runParams);
        }
    }

    private static void setupVirtualEnvVariables(PythonRunParams myConfig, Map<String, String> env, String sdkHome) {
        Sdk sdk = PythonSdkType.findSdkByPath(sdkHome);
        if (Registry.is((String)"python.activate.virtualenv.on.run") && sdk != null && (PythonSdkType.isVirtualEnv(sdkHome) || PythonSdkType.isCondaVirtualEnv(sdk))) {
            Map<String, String> environment = (Map<String, String>)sdk.getUserData(PythonSdkType.ENVIRONMENT_KEY);
            if (environment == null) {
                environment = PythonSdkType.activateVirtualEnv(sdkHome);
                sdk.putUserData(PythonSdkType.ENVIRONMENT_KEY, environment);
            }
            env.putAll(environment);
            for (Map.Entry<String, String> e : myConfig.getEnvs().entrySet()) {
                if (!environment.containsKey(e.getKey())) continue;
                if ("PATH".equals(e.getKey())) {
                    env.put(e.getKey(), PythonEnvUtil.appendToPathEnvVar(env.get("PATH"), e.getValue()));
                    continue;
                }
                env.put(e.getKey(), e.getValue());
            }
        }
    }

    protected static void addCommonEnvironmentVariables(@Nullable String homePath, Map<String, String> env) {
        PythonEnvUtil.setPythonUnbuffered(env);
        if (homePath != null) {
            PythonEnvUtil.resetHomePathChanges(homePath, env);
        }
        env.put("PYCHARM_HOSTED", "1");
    }

    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
    }

    private static void setupEncodingEnvs(Map<String, String> envs, Charset charset) {
        PythonSdkFlavor.setupEncodingEnvs(envs, charset);
    }

    private static void buildPythonPath(Project project, GeneralCommandLine commandLine, PythonRunParams config, boolean isDebug) {
        Sdk pythonSdk = PythonSdkType.findSdkByPath(config.getSdkHome());
        if (pythonSdk != null) {
            ArrayList pathList = Lists.newArrayList();
            pathList.addAll(PythonCommandLineState.getAddedPaths(pythonSdk));
            pathList.addAll(PythonCommandLineState.collectPythonPath(project, config, isDebug));
            PythonCommandLineState.initPythonPath(commandLine, config.isPassParentEnvs(), pathList, config.getSdkHome());
        }
    }

    public static void initPythonPath(GeneralCommandLine commandLine, boolean passParentEnvs, List<String> pathList, String interpreterPath) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(interpreterPath);
        if (flavor != null) {
            flavor.initPythonPath(commandLine, pathList);
        } else {
            PythonSdkFlavor.initPythonPath(commandLine.getEnvironment(), passParentEnvs, pathList);
        }
    }

    public static List<String> getAddedPaths(Sdk pythonSdk) {
        ArrayList<String> pathList = new ArrayList<String>();
        SdkAdditionalData sdkAdditionalData = pythonSdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            Set<VirtualFile> addedPaths = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
            for (VirtualFile file2 : addedPaths) {
                PythonCommandLineState.addToPythonPath(file2, pathList);
            }
        }
        return pathList;
    }

    private static void addToPythonPath(VirtualFile file2, Collection<String> pathList) {
        if (file2.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (realFile != null) {
                PythonCommandLineState.addIfNeeded(realFile, pathList);
            }
        } else {
            PythonCommandLineState.addIfNeeded(file2, pathList);
        }
    }

    private static void addIfNeeded(@NotNull VirtualFile file2, @NotNull Collection<String> pathList) {
        if (file2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(9);
        }
        if (pathList == null) {
            PythonCommandLineState.$$$reportNull$$$0(10);
        }
        PythonCommandLineState.addIfNeeded(pathList, file2.getPath());
    }

    protected static void addIfNeeded(Collection<String> pathList, String path) {
        String filePath;
        HashSet vals = Sets.newHashSet(pathList);
        if (!vals.contains(filePath = FileUtil.toSystemDependentName((String)path))) {
            pathList.add(filePath);
        }
    }

    @VisibleForTesting
    public static Collection<String> collectPythonPath(Project project, PythonRunParams config, boolean isDebug) {
        Module module2 = PythonCommandLineState.getModule(project, config);
        LinkedHashSet pythonPath = Sets.newLinkedHashSet(PythonCommandLineState.collectPythonPath(module2, config.shouldAddContentRoots(), config.shouldAddSourceRoots()));
        if (isDebug && PythonSdkFlavor.getFlavor(config.getSdkHome()) instanceof JythonSdkFlavor) {
            pythonPath.add(PythonHelpersLocator.getHelperPath("pycharm"));
            pythonPath.add(PythonHelpersLocator.getHelperPath("pydev"));
        }
        return pythonPath;
    }

    @Nullable
    private static Module getModule(Project project, PythonRunParams config) {
        String name = config.getModuleName();
        return StringUtil.isEmpty((String)name) ? null : ModuleManager.getInstance((Project)project).findModuleByName(name);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module2) {
        Collection<String> collection = PythonCommandLineState.collectPythonPath(module2, true, true);
        if (collection == null) {
            PythonCommandLineState.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module2, boolean addContentRoots, boolean addSourceRoots) {
        LinkedHashSet pythonPathList = Sets.newLinkedHashSet();
        if (module2 != null) {
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module2, dependencies);
            if (addContentRoots) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module2).getContentRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getContentRoots());
                }
            }
            if (addSourceRoots) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module2).getSourceRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getSourceRoots());
                }
            }
            PythonCommandLineState.addLibrariesFromModule(module2, pythonPathList);
            PythonCommandLineState.addRootsFromModule(module2, pythonPathList);
            for (Module dependency : dependencies) {
                PythonCommandLineState.addLibrariesFromModule(dependency, pythonPathList);
                PythonCommandLineState.addRootsFromModule(dependency, pythonPathList);
            }
        }
        LinkedHashSet linkedHashSet = pythonPathList;
        if (linkedHashSet == null) {
            PythonCommandLineState.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    private static void addLibrariesFromModule(Module module2, Collection<String> list2) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
            String name;
            if (!(entry instanceof LibraryOrderEntry) || (name = ((LibraryOrderEntry)entry).getLibraryName()) != null && name.endsWith(" interpreter library")) continue;
            for (VirtualFile root : ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)) {
                PersistentLibraryKind<?> kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    PythonCommandLineState.addToPythonPath(root, list2);
                    continue;
                }
                if (!(library instanceof LibraryImpl) || (kind = ((LibraryImpl)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                PythonCommandLineState.addToPythonPath(root, list2);
            }
        }
    }

    private static void addRootsFromModule(Module module2, Collection<String> pythonPathList) {
        Facet[] facets;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module2);
        if (extension != null) {
            VirtualFile pathForTests;
            VirtualFile path = extension.getCompilerOutputPath();
            if (path != null) {
                pythonPathList.add(path.getPath());
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                pythonPathList.add(pathForTests.getPath());
            }
        }
        for (Facet facet : facets = FacetManager.getInstance((Module)module2).getAllFacets()) {
            List<String> more_paths;
            if (!(facet instanceof PythonPathContributingFacet) || (more_paths = ((PythonPathContributingFacet)facet).getAdditionalPythonPath()) == null) continue;
            pythonPathList.addAll(more_paths);
        }
    }

    private static void addRoots(Collection<String> pythonPathList, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            PythonCommandLineState.addToPythonPath(root, pythonPathList);
        }
    }

    protected static void setRunnerPath(Project project, GeneralCommandLine commandLine, PythonRunParams config) {
        String interpreterPath = PythonCommandLineState.getInterpreterPath(project, config);
        if (StringUtil.isNotEmpty((String)interpreterPath)) {
            commandLine.setExePath(FileUtil.toSystemDependentName((String)interpreterPath));
        }
    }

    @Nullable
    public static String getInterpreterPath(Project project, PythonRunParams config) {
        Module module2;
        Sdk sdk;
        String sdkHome = config.getSdkHome();
        if ((config.isUseModuleSdk() || StringUtil.isEmpty((String)sdkHome)) && (sdk = PythonSdkType.findPythonSdk(module2 = PythonCommandLineState.getModule(project, config))) != null) {
            sdkHome = sdk.getHomePath();
        }
        return sdkHome;
    }

    protected String getInterpreterPath() throws ExecutionException {
        String interpreterPath = this.myConfig.getInterpreterPath();
        if (interpreterPath == null) {
            throw new ExecutionException("Cannot find Python interpreter for this run configuration");
        }
        return interpreterPath;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
    }

    public boolean isMultiprocessDebug() {
        if (this.myMultiprocessDebug != null) {
            return this.myMultiprocessDebug;
        }
        return PyDebuggerOptionsProvider.getInstance(this.myConfig.getProject()).isAttachToSubprocess();
    }

    public void setMultiprocessDebug(boolean multiprocessDebug) {
        this.myMultiprocessDebug = multiprocessDebug;
    }

    public void setRunWithPty(boolean runWithPty) {
        this.myRunWithPty = runWithPty;
    }

    @NotNull
    protected UrlFilter createUrlFilter(ProcessHandler handler2) {
        UrlFilter urlFilter = new UrlFilter();
        if (urlFilter == null) {
            PythonCommandLineState.$$$reportNull$$$0(13);
        }
        return urlFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPythonProcessStarter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPythonCommandLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPythonPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PythonProcessStarter {
        @NotNull
        public ProcessHandler start(@NotNull AbstractPythonRunConfiguration var1, @NotNull GeneralCommandLine var2) throws ExecutionException;
    }
}

