/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg;

import java.nio.BufferOverflowException;
import java.util.Arrays;

public class GrowableDataBuffer<T> {
    static final int MIN_BUF_GROW = 1024;
    static final int MIN_REF_GROW = 32;
    byte[] buf;
    T[] refs;
    int pos;
    int mark;
    int savepos;
    int refpos;
    int refmark;
    int refsavepos;

    public GrowableDataBuffer(int n) {
        this.buf = new byte[n];
    }

    public int position() {
        return this.pos;
    }

    public void save() {
        this.savepos = this.pos;
        this.refsavepos = this.refpos;
    }

    public void restore() {
        this.pos = this.savepos;
        this.refpos = this.refsavepos;
    }

    public boolean isEmpty() {
        return this.pos >= this.mark && this.refpos >= this.refmark;
    }

    public void switchToRead() {
        this.mark = this.pos;
        this.refmark = this.refpos;
        this.pos = 0;
        this.refpos = 0;
    }

    public void resetForWrite() {
        this.mark = 0;
        this.pos = 0;
        if (this.refpos > 0 || this.refmark > 0) {
            Arrays.fill(this.refs, 0, Math.max(this.refpos, this.refmark), null);
            this.refmark = 0;
            this.refpos = 0;
        }
    }

    public void ensureWriteCapacity(int n) {
        if (this.pos + n > this.buf.length) {
            if (n < 1024) {
                n = 1024;
            }
            this.buf = Arrays.copyOf(this.buf, this.pos + n);
        }
    }

    public void ensureReadCapacity(int n) {
        if (this.pos + n > this.mark) {
            throw new BufferOverflowException();
        }
    }

    public void putBoolean(boolean bl) {
        this.putByte(bl ? (byte)1 : 0);
    }

    public void putByte(byte by) {
        this.ensureWriteCapacity(1);
        this.buf[this.pos++] = by;
    }

    public void putChar(char c) {
        this.ensureWriteCapacity(2);
        this.buf[this.pos++] = (byte)(c >> 8);
        this.buf[this.pos++] = (byte)c;
    }

    public void putShort(short s) {
        this.ensureWriteCapacity(2);
        this.buf[this.pos++] = (byte)(s >> 8);
        this.buf[this.pos++] = (byte)s;
    }

    public void putInt(int n) {
        this.ensureWriteCapacity(4);
        this.buf[this.pos++] = (byte)(n >> 24);
        this.buf[this.pos++] = (byte)(n >> 16);
        this.buf[this.pos++] = (byte)(n >> 8);
        this.buf[this.pos++] = (byte)n;
    }

    public void putLong(long l) {
        this.ensureWriteCapacity(8);
        this.buf[this.pos++] = (byte)(l >> 56);
        this.buf[this.pos++] = (byte)(l >> 48);
        this.buf[this.pos++] = (byte)(l >> 40);
        this.buf[this.pos++] = (byte)(l >> 32);
        this.buf[this.pos++] = (byte)(l >> 24);
        this.buf[this.pos++] = (byte)(l >> 16);
        this.buf[this.pos++] = (byte)(l >> 8);
        this.buf[this.pos++] = (byte)l;
    }

    public void putFloat(float f) {
        this.putInt(Float.floatToIntBits(f));
    }

    public void putDouble(double d) {
        this.putLong(Double.doubleToLongBits(d));
    }

    public void putObject(T t) {
        if (this.refs == null) {
            this.refs = new Object[32];
        } else if (this.refpos >= this.refs.length) {
            this.refs = Arrays.copyOf(this.refs, this.refpos + 32);
        }
        this.refs[this.refpos++] = t;
    }

    public boolean getBoolean() {
        this.ensureReadCapacity(1);
        return this.buf[this.pos++] != 0;
    }

    public byte getByte() {
        this.ensureReadCapacity(1);
        return this.buf[this.pos++];
    }

    public int getUByte() {
        this.ensureReadCapacity(1);
        return this.buf[this.pos++] & 0xFF;
    }

    public char getChar() {
        this.ensureReadCapacity(2);
        int n = this.buf[this.pos++];
        n = n << 8 | this.buf[this.pos++] & 0xFF;
        return (char)n;
    }

    public short getShort() {
        this.ensureReadCapacity(2);
        int n = this.buf[this.pos++];
        n = n << 8 | this.buf[this.pos++] & 0xFF;
        return (short)n;
    }

    public int getInt() {
        this.ensureReadCapacity(4);
        int n = this.buf[this.pos++];
        n = n << 8 | this.buf[this.pos++] & 0xFF;
        n = n << 8 | this.buf[this.pos++] & 0xFF;
        n = n << 8 | this.buf[this.pos++] & 0xFF;
        return n;
    }

    public long getLong() {
        this.ensureReadCapacity(8);
        long l = this.buf[this.pos++];
        l = l << 8 | (long)(this.buf[this.pos++] & 0xFF);
        l = l << 8 | (long)(this.buf[this.pos++] & 0xFF);
        l = l << 8 | (long)(this.buf[this.pos++] & 0xFF);
        l = l << 8 | (long)(this.buf[this.pos++] & 0xFF);
        l = l << 8 | (long)(this.buf[this.pos++] & 0xFF);
        l = l << 8 | (long)(this.buf[this.pos++] & 0xFF);
        l = l << 8 | (long)(this.buf[this.pos++] & 0xFF);
        return l;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public T getObject() {
        if (this.refs == null || this.refpos >= this.refs.length) {
            throw new BufferOverflowException();
        }
        return this.refs[this.refpos++];
    }
}

