/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.tk.quantum.AbstractPainter;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public class ViewPainter
extends AbstractPainter {
    private WindowStage windowStage;
    private Window window;
    protected View view;
    protected PrismPen pen;
    protected int penWidth = -1;
    protected int penHeight = -1;
    protected int viewWidth;
    protected int viewHeight;
    protected boolean valid;

    protected ViewPainter(GlassScene glassScene, PrismPen prismPen) {
        super(glassScene);
        this.pen = prismPen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean validateStageGraphics() {
        this.valid = super.validateStageGraphics();
        if (!this.valid) {
            return false;
        }
        ViewPainter viewPainter = this;
        synchronized (viewPainter) {
            ViewScene viewScene = (ViewScene)this.scene;
            this.view = viewScene.getPlatformView();
            if (this.view == null) {
                return false;
            }
            if (this.view.isClosed()) {
                return false;
            }
            this.viewWidth = this.view.getWidth();
            this.viewHeight = this.view.getHeight();
            if (this.viewWidth <= 0 || this.viewHeight <= 0) {
                return false;
            }
            this.setPaintBounds(this.viewWidth, this.viewHeight);
        }
        this.windowStage = (WindowStage)this.scene.glassStage;
        this.window = this.windowStage.platformWindow;
        if (this.window == null) {
            return false;
        }
        if (this.factory == null) {
            try {
                this.view.lock();
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
                this.view.unlock(this.factory != null);
            }
            catch (Throwable throwable) {
                this.view.unlock(this.factory != null);
                throw throwable;
            }
            return this.factory != null && this.factory.isDeviceReady();
        }
        return this.window.isVisible() && !this.window.isMinimized() && this.factory.isDeviceReady();
    }

    @Override
    protected void doPaint(Graphics graphics) {
        Paint paint;
        if (PrismSettings.showDirtyRegions) {
            graphics.setClipRect(null);
        }
        this.scene.clearEntireSceneDirty();
        graphics.setDepthBuffer(this.pen.getDepthBuffer());
        Color color = this.pen.getClearColor();
        if (color != null) {
            graphics.clear(color);
        }
        if ((paint = this.pen.getCurrentPaint()) != null) {
            if (paint.getType() != Paint.Type.COLOR) {
                graphics.getRenderTarget().setOpaque(paint.isOpaque());
            }
            graphics.setPaint(paint);
            graphics.fillQuad(0.0f, 0.0f, this.width, this.height);
        }
        graphics.setCamera((PrismCameraImpl)this.pen.getCamera());
        this.root.render(graphics);
    }

    @Override
    protected CameraImpl getCamera() {
        if (this.pen != null) {
            return this.pen.getCamera();
        }
        return null;
    }
}

