/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.EndpointSelectionType;
import IceInternal.Buffer;
import IceInternal.HttpParser;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;

public final class HTTPNetworkProxy
implements NetworkProxy {
    private String _host;
    private int _port;
    private InetSocketAddress _address;
    private int _protocolSupport;

    public HTTPNetworkProxy(String host, int port) {
        this._host = host;
        this._port = port;
        this._protocolSupport = 2;
    }

    private HTTPNetworkProxy(InetSocketAddress address, int protocolSupport) {
        this._address = address;
        this._protocolSupport = protocolSupport;
    }

    @Override
    public void beginWrite(InetSocketAddress endpoint, Buffer buf) {
        String addr = Network.addrToString(endpoint);
        StringBuilder str = new StringBuilder();
        str.append("CONNECT ");
        str.append(addr);
        str.append(" HTTP/1.1\r\nHost: ");
        str.append(addr);
        str.append("\r\n\r\n");
        byte[] b = str.toString().getBytes(StandardCharsets.US_ASCII);
        buf.resize(b.length, false);
        buf.b.position(0);
        buf.b.put(b);
        buf.b.position(0);
        buf.b.limit(buf.size());
    }

    @Override
    public int endWrite(Buffer buf) {
        return buf.b.hasRemaining() ? 4 : 1;
    }

    @Override
    public void beginRead(Buffer buf) {
        buf.resize(7, true);
        buf.b.position(0);
    }

    @Override
    public int endRead(Buffer buf) {
        int end = new HttpParser().isCompleteMessage(buf.b, 0, buf.b.position());
        if (end < 0 && !buf.b.hasRemaining()) {
            buf.resize(buf.size() + 1, true);
            return 1;
        }
        return 0;
    }

    @Override
    public void finish(Buffer readBuffer, Buffer writeBuffer) {
        HttpParser parser = new HttpParser();
        parser.parse(readBuffer.b, 0, readBuffer.b.position());
        if (parser.status() != 200) {
            throw new ConnectFailedException();
        }
    }

    @Override
    public NetworkProxy resolveHost(int protocol) {
        assert (this._host != null);
        return new HTTPNetworkProxy(Network.getAddresses(this._host, this._port, protocol, EndpointSelectionType.Random, false, true).get(0), protocol);
    }

    @Override
    public InetSocketAddress getAddress() {
        assert (this._address != null);
        return this._address;
    }

    @Override
    public String getName() {
        return "HTTP";
    }

    @Override
    public int getProtocolSupport() {
        return this._protocolSupport;
    }
}

