/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.model;

import com.github.arara.model.AraraRuleArgument;
import com.github.arara.utils.AraraUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AraraRuleConfig {
    private String identifier;
    private String name;
    private String command;
    private List<String> commands;
    private List<AraraRuleArgument> arguments;

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
        for (int i = 0; i < commands.size(); ++i) {
            String currentCommand = AraraUtils.removeKeyword(commands.get(i));
            commands.set(i, currentCommand);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = AraraUtils.removeKeyword(command);
    }

    public List<AraraRuleArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<AraraRuleArgument> arguments) {
        this.arguments = arguments;
    }

    public List<String> getIdentifiersList() {
        ArrayList<String> result = new ArrayList<String>();
        for (AraraRuleArgument argument : this.getArguments()) {
            result.add(argument.getIdentifier());
        }
        return result;
    }

    public String checkForForbiddenIdentifiers() {
        for (AraraRuleArgument argument : this.getArguments()) {
            String value = argument.getIdentifier().toLowerCase();
            if (!value.equals("file") && !value.equals("files") && !value.equals("item") && !value.equals("items")) continue;
            return value;
        }
        return null;
    }
}

