/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public class AquaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static Map<Integer, String[]> buttonIconPaths;
    private Font txtFont;

    public AquaEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    @Override
    protected TabCellRenderer createDefaultRenderer() {
        return new AquaEditorTabCellRenderer();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    protected boolean isAntialiased() {
        return true;
    }

    @Override
    protected Font createFont() {
        if (this.txtFont == null) {
            this.txtFont = (Font)UIManager.get("windowTitleFont");
            if (this.txtFont == null) {
                this.txtFont = new Font("Dialog", 0, 11);
            } else if (this.txtFont.isBold()) {
                this.txtFont = new Font(this.txtFont.getName(), 0, this.txtFont.getSize());
            }
        }
        return this.txtFont;
    }

    @Override
    protected Font getTxtFont() {
        return this.createFont();
    }

    @Override
    protected int createRepaintPolicy() {
        return 351;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 7;
        }
        if (n % 2 == 0) {
            ++n;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        graphics.setColor(UIManager.getColor("NbTabControl.editorTabBackground"));
        graphics.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    @Override
    protected void paintAfterTabs(Graphics graphics) {
        int n = this.getTabsAreaWidth();
        int n2 = this.displayer.getWidth();
        int n3 = this.displayer.getHeight();
        if (this.displayer.getModel().size() > 0 && !this.scroll().isLastTabClipped()) {
            int n4 = this.scroll().getLastVisibleTab(this.displayer.getWidth());
            n = this.scroll().getX(n4) + this.scroll().getW(n4);
        } else if (this.displayer.getModel().size() == 0) {
            n = 6;
        }
        graphics.setColor(UIManager.getColor("NbTabControl.borderColor"));
        graphics.drawLine(n, n3 - 1, n2, n3 - 1);
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_popup_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/mac_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/mac_restore_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/mac_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/mac_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        AquaEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }
}

