/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, debounce, displace) {
  Drupal.offCanvas = {
    minDisplaceWidth: 768,

    $mainCanvasWrapper: $('[data-off-canvas-main-canvas]'),

    isOffCanvas: function isOffCanvas($element) {
      return $element.is('#drupal-off-canvas');
    },
    removeOffCanvasEvents: function removeOffCanvasEvents($element) {
      $element.off('.off-canvas');
      $(document).off('.off-canvas');
      $(window).off('.off-canvas');
    },
    beforeCreate: function beforeCreate(_ref) {
      var settings = _ref.settings,
          $element = _ref.$element;

      Drupal.offCanvas.removeOffCanvasEvents($element);

      $('body').addClass('js-tray-open');
      settings.dialogClass += ' ui-dialog-off-canvas';

      settings.position = {
        my: 'left top',
        at: Drupal.offCanvas.getEdge() + ' top',
        of: window
      };

      settings.height = $(window).height();
    },
    beforeClose: function beforeClose(_ref2) {
      var $element = _ref2.$element;

      $('body').removeClass('js-tray-open');

      Drupal.offCanvas.removeOffCanvasEvents($element);

      Drupal.offCanvas.$mainCanvasWrapper.css('padding-' + Drupal.offCanvas.getEdge(), 0);
    },
    afterCreate: function afterCreate(_ref3) {
      var $element = _ref3.$element,
          settings = _ref3.settings;

      var eventData = { settings: settings, $element: $element, offCanvasDialog: this };

      $element.on('dialogContentResize.off-canvas', eventData, Drupal.offCanvas.handleDialogResize).on('dialogContentResize.off-canvas', eventData, Drupal.offCanvas.bodyPadding);

      Drupal.offCanvas.getContainer($element).attr('data-offset-' + Drupal.offCanvas.getEdge(), '');

      $(window).on('resize.off-canvas', eventData, debounce(Drupal.offCanvas.resetSize, 100)).trigger('resize.off-canvas');
    },
    render: function render(_ref4) {
      var settings = _ref4.settings;

      $('.ui-dialog-off-canvas, .ui-dialog-off-canvas .ui-dialog-titlebar').toggleClass('ui-dialog-empty-title', !settings.title);
    },
    handleDialogResize: function handleDialogResize(event) {
      var $element = event.data.$element;
      var $container = Drupal.offCanvas.getContainer($element);

      var $offsets = $container.find('> :not(#drupal-off-canvas, .ui-resizable-handle)');
      var offset = 0;

      $element.css({ height: 'auto' });
      var modalHeight = $container.height();

      $offsets.each(function (i, e) {
        offset += $(e).outerHeight();
      });

      var scrollOffset = $element.outerHeight() - $element.height();
      $element.height(modalHeight - offset - scrollOffset);
    },
    resetSize: function resetSize(event) {
      var offsets = displace.offsets;
      var $element = event.data.$element;
      var container = Drupal.offCanvas.getContainer($element);

      var topPosition = offsets.top !== 0 ? '+' + offsets.top : '';
      var adjustedOptions = {
        position: {
          my: Drupal.offCanvas.getEdge() + ' top',
          at: Drupal.offCanvas.getEdge() + ' top' + topPosition,
          of: window
        }
      };

      container.css({
        position: 'fixed',
        height: $(window).height() - (offsets.top + offsets.bottom) + 'px'
      });

      $element.dialog('option', adjustedOptions).trigger('dialogContentResize.off-canvas');
    },
    bodyPadding: function bodyPadding(event) {
      if ($('body').outerWidth() < Drupal.offCanvas.minDisplaceWidth) {
        return;
      }
      var $element = event.data.$element;
      var $container = Drupal.offCanvas.getContainer($element);
      var $mainCanvasWrapper = Drupal.offCanvas.$mainCanvasWrapper;

      var width = $container.outerWidth();
      var mainCanvasPadding = $mainCanvasWrapper.css('padding-' + Drupal.offCanvas.getEdge());
      if (width !== mainCanvasPadding) {
        $mainCanvasWrapper.css('padding-' + Drupal.offCanvas.getEdge(), width + 'px');
        $container.attr('data-offset-' + Drupal.offCanvas.getEdge(), width);
        displace();
      }
    },
    getContainer: function getContainer($element) {
      return $element.dialog('widget');
    },
    getEdge: function getEdge() {
      return document.documentElement.dir === 'rtl' ? 'left' : 'right';
    }
  };

  Drupal.behaviors.offCanvasEvents = {
    attach: function attach() {
      $(window).once('off-canvas').on({
        'dialog:beforecreate': function dialogBeforecreate(event, dialog, $element, settings) {
          if (Drupal.offCanvas.isOffCanvas($element)) {
            Drupal.offCanvas.beforeCreate({ dialog: dialog, $element: $element, settings: settings });
          }
        },
        'dialog:aftercreate': function dialogAftercreate(event, dialog, $element, settings) {
          if (Drupal.offCanvas.isOffCanvas($element)) {
            Drupal.offCanvas.render({ dialog: dialog, $element: $element, settings: settings });
            Drupal.offCanvas.afterCreate({ $element: $element, settings: settings });
          }
        },
        'dialog:beforeclose': function dialogBeforeclose(event, dialog, $element) {
          if (Drupal.offCanvas.isOffCanvas($element)) {
            Drupal.offCanvas.beforeClose({ dialog: dialog, $element: $element });
          }
        }
      });
    }
  };
})(jQuery, Drupal, Drupal.debounce, Drupal.displace);