/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright (C) 2008 Google Inc. All Rights Reserved.
 * Copyright (C) 2015-2017 Jason A. Donenfeld <Jason@zx2c4.com>. All Rights Reserved.
 */
var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=console.log;if(!Module["printErr"])Module["printErr"]=console.warn;var nodeFS;var nodePath;Module["read"]=function shell_read(filename,binary){var ret;ret=tryParseAsDataURI(filename);if(!ret){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);ret=nodeFS["readFileSync"](filename)}return binary?ret:ret.toString()};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}else{Module["read"]=function shell_read(){throw"no read() available"}}Module["readBinary"]=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof quit==="function"){Module["quit"]=(function(status,toThrow){quit(status)})}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){Module["readBinary"]=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function shell_print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function shell_printErr(x){console.warn(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw new Error("Unknown runtime environment. Where are we?")}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}if(!Module["quit"]){Module["quit"]=(function(status,toThrow){throw toThrow})}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var Runtime={setTempRet0:(function(value){tempRet0=value;return value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){if(!func)return;assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){if(sig.length===1){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func)}}else if(sig.length===2){sigCache[func]=function dynCall_wrapper(arg){return Runtime.dynCall(sig,func,[arg])}}else{sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,Array.prototype.slice.call(arguments))}}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=(ret+size+15|0)&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;if(end>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){HEAP32[DYNAMICTOP_PTR>>2]=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var ABORT=0;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];assert(func,"Cannot call unknown function "+ident+", make sure it is exported");return func}var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=Runtime.stackAlloc(len);stringToUTF8(str,ret,len)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};function ccall(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){Runtime.stackRestore(stack)}return ret}function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}return(function(){return ccall(ident,returnType,argTypes,arguments)})}Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for getValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var stop;ptr=ret;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx){var endPtr=idx;while(u8Array[endPtr])++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function demangle(func){var __cxa_demangle_func=Module["___cxa_demangle"]||Module["__cxa_demangle"];if(__cxa_demangle_func){try{var s=func.substr(1);var len=lengthBytesUTF8(s)+1;var buf=_malloc(len);stringToUTF8(s,buf,len);var status=_malloc(4);var ret=__cxa_demangle_func(buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}return func}Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");return func}function demangleAll(text){var regex=/__Z[\w\d_]+/g;return text.replace(regex,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){var js=jsStackTrace();if(Module["extraStackTrace"])js+="\n"+Module["extraStackTrace"]();return demangleAll(js)}Module["stackTrace"]=stackTrace;var HEAP,buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE,STATICTOP,staticSealed;var STACK_BASE,STACKTOP,STACK_MAX;var DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0;staticSealed=false;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;if(TOTAL_MEMORY<TOTAL_STACK)Module.printErr("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")");if(Module["buffer"]){buffer=Module["buffer"]}else{{buffer=new ArrayBuffer(TOTAL_MEMORY)}}updateGlobalBufferViews();function getTotalMemory(){return TOTAL_MEMORY}HEAP32[0]=1668509029;HEAP16[1]=25459;if(HEAPU8[2]!==115||HEAPU8[3]!==99)throw"Runtime error: expected the system to be little-endian!";Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function writeStringToMemory(string,buffer,dontAddNull){Runtime.warnOnce("writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!");var lastChar,end;if(dontAddNull){end=buffer+lengthBytesUTF8(string);lastChar=HEAP8[end]}stringToUTF8(string,buffer,Infinity);if(dontAddNull)HEAP8[end]=lastChar}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];if(!Math["trunc"])Math["trunc"]=(function(x){return x<0?Math.ceil(x):Math.floor(x)});Math.trunc=Math["trunc"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_round=Math.round;var Math_min=Math.min;var Math_clz32=Math.clz32;var Math_trunc=Math.trunc;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[(function(){var getRandomValue=(function(){var buf=new Uint32Array(1);window.crypto.getRandomValues(buf);return buf[0]>>>0});Module.getRandomValue=getRandomValue}),(function(){return Module.getRandomValue()})];function _emscripten_asm_const_i(code){return ASM_CONSTS[code]()}STATIC_BASE=Runtime.GLOBAL_BASE;STATICTOP=STATIC_BASE+2192;__ATINIT__.push();memoryInitializer="data:application/octet-stream;base64,AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABgBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAACAAAAjAQAAAAEAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAr/////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD8AAAAeyB2YXIgZ2V0UmFuZG9tVmFsdWUgPSBmdW5jdGlvbigpIHsgdmFyIGJ1ZiA9IG5ldyBVaW50MzJBcnJheSgxKTsgd2luZG93LmNyeXB0by5nZXRSYW5kb21WYWx1ZXMoYnVmKTsgcmV0dXJuIGJ1ZlswXSA+Pj4gMDsgfTsgTW9kdWxlLmdldFJhbmRvbVZhbHVlID0gZ2V0UmFuZG9tVmFsdWU7IH0AeyByZXR1cm4gTW9kdWxlLmdldFJhbmRvbVZhbHVlKCk7IH0=";var tempDoublePtr=STATICTOP;STATICTOP+=16;function ___lock(){}var SYSCALLS={varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.get(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();var ret=0;if(!___syscall146.buffer){___syscall146.buffers=[null,[],[]];___syscall146.printChar=(function(stream,curr){var buffer=___syscall146.buffers[stream];assert(buffer);if(curr===0||curr===10){(stream===1?Module["print"]:Module["printErr"])(UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}})}for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];for(var j=0;j<len;j++){___syscall146.printChar(stream,HEAPU8[ptr+j])}ret+=len}return ret}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___unlock(){}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}__ATEXIT__.push((function(){var fflush=Module["_fflush"];if(fflush)fflush(0);var printChar=___syscall146.printChar;if(!printChar)return;var buffers=___syscall146.buffers;if(buffers[1].length)printChar(1,10);if(buffers[2].length)printChar(2,10)}));DYNAMICTOP_PTR=allocate(1,"i32",ALLOC_STATIC);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=Runtime.alignMemory(STACK_MAX);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;staticSealed=true;var ASSERTIONS=false;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,"Character code "+chr+" ("+String.fromCharCode(chr)+")  at offset "+i+" not in 0x00-0xFF.")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayFromString"]=intArrayFromString;Module["intArrayToString"]=intArrayToString;var keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var decodeBase64=typeof atob==="function"?atob:(function(input){var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output});function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE==="boolean"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,"base64")}catch(_){buf=new Buffer(s,"base64")}return new Uint8Array(buf.buffer,buf.byteOffset,buf.byteLength)}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error("Converting base64 string to bytes failed.")}}function tryParseAsDataURI(filename){var dataURIPrefix="data:application/octet-stream;base64,";if(!(String.prototype.startsWith?filename.startsWith(dataURIPrefix):filename.indexOf(dataURIPrefix)===0)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"enlargeMemory":enlargeMemory,"getTotalMemory":getTotalMemory,"abortOnCannotGrowMemory":abortOnCannotGrowMemory,"invoke_ii":invoke_ii,"invoke_iiii":invoke_iiii,"___lock":___lock,"___setErrNo":___setErrNo,"___syscall140":___syscall140,"___syscall146":___syscall146,"___syscall54":___syscall54,"___syscall6":___syscall6,"___unlock":___unlock,"_emscripten_asm_const_i":_emscripten_asm_const_i,"_emscripten_memcpy_big":_emscripten_memcpy_big,"DYNAMICTOP_PTR":DYNAMICTOP_PTR,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX};// EMSCRIPTEN_START_ASM
var asm=(/** @suppress {uselessCode} */ function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.DYNAMICTOP_PTR|0;var j=env.tempDoublePtr|0;var k=env.ABORT|0;var l=env.STACKTOP|0;var m=env.STACK_MAX|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0.0;var y=0;var z=global.Math.floor;var A=global.Math.abs;var B=global.Math.sqrt;var C=global.Math.pow;var D=global.Math.cos;var E=global.Math.sin;var F=global.Math.tan;var G=global.Math.acos;var H=global.Math.asin;var I=global.Math.atan;var J=global.Math.atan2;var K=global.Math.exp;var L=global.Math.log;var M=global.Math.ceil;var N=global.Math.imul;var O=global.Math.min;var P=global.Math.max;var Q=global.Math.clz32;var R=env.abort;var S=env.assert;var T=env.enlargeMemory;var U=env.getTotalMemory;var V=env.abortOnCannotGrowMemory;var W=env.invoke_ii;var X=env.invoke_iiii;var Y=env.___lock;var Z=env.___setErrNo;var _=env.___syscall140;var $=env.___syscall146;var aa=env.___syscall54;var ba=env.___syscall6;var ca=env.___unlock;var da=env._emscripten_asm_const_i;var ea=env._emscripten_memcpy_big;var fa=0.0;
// EMSCRIPTEN_START_FUNCS
function ia(a){a=a|0;var b=0;b=l;l=l+a|0;l=l+15&-16;return b|0}function ja(){return l|0}function ka(a){a=a|0;l=a}function la(a,b){a=a|0;b=b|0;l=a;m=b}function ma(a,b){a=a|0;b=b|0;if(!n){n=a;o=b}}function na(a){a=a|0;y=a}function oa(){return y|0}function pa(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Ra=0,Sa=0,Va=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0;Ob=l;l=l+2640|0;rb=Ob+2456|0;sb=Ob+2304|0;Mb=Ob+2152|0;tb=Ob+2e3|0;ub=Ob+1848|0;vb=Ob+1696|0;Nb=Ob+1544|0;Fb=Ob+1392|0;Gb=Ob+1240|0;Hb=Ob+1088|0;h=Ob+936|0;g=Ob+784|0;f=Ob+632|0;e=Ob+480|0;Ib=Ob+328|0;pb=Ob+248|0;Jb=Ob+168|0;Kb=Ob+80|0;Lb=Ob;qb=Ob+2608|0;ob=qb;da=ob+32|0;do{a[ob>>0]=a[d>>0]|0;ob=ob+1|0;d=d+1|0}while((ob|0)<(da|0));a[qb>>0]=a[qb>>0]&-8;ob=qb+31|0;a[ob>>0]=a[ob>>0]&63|64;ob=pb;c[ob>>2]=9;c[ob+4>>2]=0;ob=pb+8|0;da=ob+72|0;do{c[ob>>2]=0;ob=ob+4|0}while((ob|0)<(da|0));Wa(Fb+8|0,0,144)|0;ob=Fb;c[ob>>2]=1;c[ob+4>>2]=0;Wa(Gb+8|0,0,144)|0;ob=Gb;c[ob>>2]=1;c[ob+4>>2]=0;Wa(Hb|0,0,152)|0;Wa(h|0,0,152)|0;Wa(g+8|0,0,144)|0;ob=g;c[ob>>2]=1;c[ob+4>>2]=0;Wa(f|0,0,152)|0;Wa(e+8|0,0,144)|0;ob=e;c[ob>>2]=1;c[ob+4>>2]=0;ob=Nb+80|0;da=ob+72|0;do{c[ob>>2]=0;ob=ob+4|0}while((ob|0)<(da|0));ob=Nb;d=pb;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));oa=Mb+144|0;pa=Mb+64|0;qa=Mb+136|0;ra=Mb+56|0;wa=Mb+128|0;xa=Mb+48|0;ya=Mb+120|0;za=Mb+40|0;Aa=Mb+112|0;Ba=Mb+32|0;Ca=Mb+104|0;Da=Mb+24|0;Ea=Mb+96|0;Fa=Mb+16|0;Ga=Mb+88|0;Ha=Mb+8|0;Ia=Mb+80|0;Ja=tb+144|0;Ka=tb+64|0;La=tb+136|0;Ma=tb+56|0;Na=tb+128|0;Oa=tb+48|0;Pa=tb+120|0;Ra=tb+40|0;Sa=tb+112|0;Va=tb+32|0;Xa=tb+104|0;Ya=tb+24|0;Za=tb+96|0;_a=tb+16|0;$a=tb+88|0;ab=tb+8|0;bb=tb+80|0;fa=Mb+72|0;cb=tb+72|0;db=rb+8|0;eb=sb+8|0;fb=rb+16|0;gb=sb+16|0;hb=rb+24|0;ib=sb+24|0;jb=rb+32|0;kb=sb+32|0;lb=rb+40|0;mb=sb+40|0;nb=rb+48|0;ga=sb+48|0;ha=rb+56|0;ia=sb+56|0;ja=rb+64|0;ka=sb+64|0;la=rb+72|0;ma=sb+72|0;wb=Ib+80|0;xb=Ib+8|0;yb=Ib+16|0;zb=Ib+24|0;Ab=Ib+32|0;Bb=Ib+40|0;Cb=Ib+48|0;Db=Ib+56|0;Eb=Ib+64|0;na=Ib+72|0;m=Nb;ea=0;d=Fb;i=Hb;j=Gb;while(1){k=a[qb+(31-ea)>>0]|0;$=0;aa=e;ba=f;ca=g;g=d;e=i;f=j;_=m;while(1){Y=k&255;Z=Y>>>7;sa(f,_,Z,0);sa(e,g,Z,0);x=f;k=c[x>>2]|0;x=c[x+4>>2]|0;V=f+8|0;T=V;G=c[T>>2]|0;T=c[T+4>>2]|0;Sb=f+16|0;B=Sb;A=c[B>>2]|0;B=c[B+4>>2]|0;C=f+24|0;Pb=C;W=c[Pb>>2]|0;Pb=c[Pb+4>>2]|0;t=f+32|0;u=t;Tb=c[u>>2]|0;u=c[u+4>>2]|0;r=f+40|0;m=r;D=c[m>>2]|0;m=c[m+4>>2]|0;S=f+48|0;da=S;X=c[da>>2]|0;da=c[da+4>>2]|0;J=f+56|0;E=J;P=c[E>>2]|0;E=c[E+4>>2]|0;Ub=f+64|0;v=Ub;M=c[v>>2]|0;v=c[v+4>>2]|0;q=f+72|0;Qb=q;Rb=c[Qb>>2]|0;Qb=c[Qb+4>>2]|0;z=e;L=c[z>>2]|0;z=c[z+4>>2]|0;s=Ta(L|0,z|0,k|0,x|0)|0;o=f;c[o>>2]=s;c[o+4>>2]=y;o=e+8|0;s=o;U=c[s>>2]|0;s=c[s+4>>2]|0;I=Ta(U|0,s|0,G|0,T|0)|0;c[V>>2]=I;c[V+4>>2]=y;V=e+16|0;I=V;O=c[I>>2]|0;I=c[I+4>>2]|0;j=Ta(O|0,I|0,A|0,B|0)|0;c[Sb>>2]=j;c[Sb+4>>2]=y;Sb=e+24|0;j=Sb;i=c[j>>2]|0;j=c[j+4>>2]|0;Wb=Ta(i|0,j|0,W|0,Pb|0)|0;c[C>>2]=Wb;c[C+4>>2]=y;C=e+32|0;Wb=C;p=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;K=Ta(p|0,Wb|0,Tb|0,u|0)|0;c[t>>2]=K;c[t+4>>2]=y;t=e+40|0;K=t;Q=c[K>>2]|0;K=c[K+4>>2]|0;w=Ta(Q|0,K|0,D|0,m|0)|0;c[r>>2]=w;c[r+4>>2]=y;r=e+48|0;w=r;H=c[w>>2]|0;w=c[w+4>>2]|0;n=Ta(H|0,w|0,X|0,da|0)|0;c[S>>2]=n;c[S+4>>2]=y;S=e+56|0;n=S;F=c[n>>2]|0;n=c[n+4>>2]|0;ob=Ta(F|0,n|0,P|0,E|0)|0;c[J>>2]=ob;c[J+4>>2]=y;J=e+64|0;ob=J;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;Vb=Ta(d|0,ob|0,M|0,v|0)|0;c[Ub>>2]=Vb;c[Ub+4>>2]=y;Ub=e+72|0;Vb=Ub;R=c[Vb>>2]|0;Vb=c[Vb+4>>2]|0;Xb=Ta(R|0,Vb|0,Rb|0,Qb|0)|0;c[q>>2]=Xb;c[q+4>>2]=y;z=Ua(k|0,x|0,L|0,z|0)|0;L=e;c[L>>2]=z;c[L+4>>2]=y;s=Ua(G|0,T|0,U|0,s|0)|0;c[o>>2]=s;c[o+4>>2]=y;I=Ua(A|0,B|0,O|0,I|0)|0;c[V>>2]=I;c[V+4>>2]=y;j=Ua(W|0,Pb|0,i|0,j|0)|0;c[Sb>>2]=j;c[Sb+4>>2]=y;Wb=Ua(Tb|0,u|0,p|0,Wb|0)|0;c[C>>2]=Wb;c[C+4>>2]=y;K=Ua(D|0,m|0,Q|0,K|0)|0;c[t>>2]=K;c[t+4>>2]=y;w=Ua(X|0,da|0,H|0,w|0)|0;c[r>>2]=w;c[r+4>>2]=y;n=Ua(P|0,E|0,F|0,n|0)|0;c[S>>2]=n;c[S+4>>2]=y;ob=Ua(M|0,v|0,d|0,ob|0)|0;c[J>>2]=ob;c[J+4>>2]=y;Vb=Ua(Rb|0,Qb|0,R|0,Vb|0)|0;c[Ub>>2]=Vb;c[Ub+4>>2]=y;Ub=_;Vb=c[Ub>>2]|0;Ub=c[Ub+4>>2]|0;R=_+8|0;Qb=R;Rb=c[Qb>>2]|0;Qb=c[Qb+4>>2]|0;J=_+16|0;ob=J;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;v=_+24|0;M=v;S=c[M>>2]|0;M=c[M+4>>2]|0;n=_+32|0;F=n;E=c[F>>2]|0;F=c[F+4>>2]|0;P=_+40|0;r=P;w=c[r>>2]|0;r=c[r+4>>2]|0;H=_+48|0;da=H;X=c[da>>2]|0;da=c[da+4>>2]|0;t=_+56|0;K=t;Q=c[K>>2]|0;K=c[K+4>>2]|0;m=_+64|0;D=m;C=c[D>>2]|0;D=c[D+4>>2]|0;Wb=_+72|0;p=Wb;u=c[p>>2]|0;p=c[p+4>>2]|0;Tb=g;Sb=c[Tb>>2]|0;Tb=c[Tb+4>>2]|0;j=Ta(Sb|0,Tb|0,Vb|0,Ub|0)|0;i=_;c[i>>2]=j;c[i+4>>2]=y;i=g+8|0;j=i;Pb=c[j>>2]|0;j=c[j+4>>2]|0;W=Ta(Pb|0,j|0,Rb|0,Qb|0)|0;c[R>>2]=W;c[R+4>>2]=y;R=g+16|0;W=R;V=c[W>>2]|0;W=c[W+4>>2]|0;I=Ta(V|0,W|0,d|0,ob|0)|0;c[J>>2]=I;c[J+4>>2]=y;J=g+24|0;I=J;O=c[I>>2]|0;I=c[I+4>>2]|0;B=Ta(O|0,I|0,S|0,M|0)|0;c[v>>2]=B;c[v+4>>2]=y;v=g+32|0;B=v;A=c[B>>2]|0;B=c[B+4>>2]|0;o=Ta(A|0,B|0,E|0,F|0)|0;c[n>>2]=o;c[n+4>>2]=y;n=g+40|0;o=n;s=c[o>>2]|0;o=c[o+4>>2]|0;U=Ta(s|0,o|0,w|0,r|0)|0;c[P>>2]=U;c[P+4>>2]=y;P=g+48|0;U=P;T=c[U>>2]|0;U=c[U+4>>2]|0;G=Ta(T|0,U|0,X|0,da|0)|0;c[H>>2]=G;c[H+4>>2]=y;H=g+56|0;G=H;L=c[G>>2]|0;G=c[G+4>>2]|0;z=Ta(L|0,G|0,Q|0,K|0)|0;c[t>>2]=z;c[t+4>>2]=y;t=g+64|0;z=t;x=c[z>>2]|0;z=c[z+4>>2]|0;k=Ta(x|0,z|0,C|0,D|0)|0;c[m>>2]=k;c[m+4>>2]=y;m=g+72|0;k=m;q=c[k>>2]|0;k=c[k+4>>2]|0;Xb=Ta(q|0,k|0,u|0,p|0)|0;c[Wb>>2]=Xb;c[Wb+4>>2]=y;Tb=Ua(Vb|0,Ub|0,Sb|0,Tb|0)|0;Sb=g;c[Sb>>2]=Tb;c[Sb+4>>2]=y;j=Ua(Rb|0,Qb|0,Pb|0,j|0)|0;c[i>>2]=j;c[i+4>>2]=y;W=Ua(d|0,ob|0,V|0,W|0)|0;c[R>>2]=W;c[R+4>>2]=y;I=Ua(S|0,M|0,O|0,I|0)|0;c[J>>2]=I;c[J+4>>2]=y;B=Ua(E|0,F|0,A|0,B|0)|0;c[v>>2]=B;c[v+4>>2]=y;o=Ua(w|0,r|0,s|0,o|0)|0;c[n>>2]=o;c[n+4>>2]=y;U=Ua(X|0,da|0,T|0,U|0)|0;c[P>>2]=U;c[P+4>>2]=y;G=Ua(Q|0,K|0,L|0,G|0)|0;c[H>>2]=G;c[H+4>>2]=y;z=Ua(C|0,D|0,x|0,z|0)|0;c[t>>2]=z;c[t+4>>2]=y;k=Ua(u|0,p|0,q|0,k|0)|0;c[m>>2]=k;c[m+4>>2]=y;ta(Mb,_,e);ta(tb,f,g);m=oa;k=c[m>>2]|0;m=c[m+4>>2]|0;q=pa;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Qa(k|0,m|0,18,0)|0;t=y;m=Ta(p|0,q|0,k|0,m|0)|0;t=Ta(m|0,y|0,u|0,t|0)|0;u=pa;c[u>>2]=t;c[u+4>>2]=y;u=qa;t=c[u>>2]|0;u=c[u+4>>2]|0;m=ra;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Qa(t|0,u|0,18,0)|0;p=y;u=Ta(k|0,m|0,t|0,u|0)|0;p=Ta(u|0,y|0,q|0,p|0)|0;q=ra;c[q>>2]=p;c[q+4>>2]=y;q=wa;p=c[q>>2]|0;q=c[q+4>>2]|0;u=xa;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Qa(p|0,q|0,18,0)|0;k=y;q=Ta(t|0,u|0,p|0,q|0)|0;k=Ta(q|0,y|0,m|0,k|0)|0;m=xa;c[m>>2]=k;c[m+4>>2]=y;m=ya;k=c[m>>2]|0;m=c[m+4>>2]|0;q=za;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Qa(k|0,m|0,18,0)|0;t=y;m=Ta(p|0,q|0,k|0,m|0)|0;t=Ta(m|0,y|0,u|0,t|0)|0;u=za;c[u>>2]=t;c[u+4>>2]=y;u=Aa;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Ba;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Qa(t|0,u|0,18,0)|0;p=y;u=Ta(k|0,m|0,t|0,u|0)|0;p=Ta(u|0,y|0,q|0,p|0)|0;q=Ba;c[q>>2]=p;c[q+4>>2]=y;q=Ca;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Da;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Qa(p|0,q|0,18,0)|0;k=y;q=Ta(t|0,u|0,p|0,q|0)|0;k=Ta(q|0,y|0,m|0,k|0)|0;m=Da;c[m>>2]=k;c[m+4>>2]=y;m=Ea;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Fa;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Qa(k|0,m|0,18,0)|0;t=y;m=Ta(p|0,q|0,k|0,m|0)|0;t=Ta(m|0,y|0,u|0,t|0)|0;u=Fa;c[u>>2]=t;c[u+4>>2]=y;u=Ga;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Ha;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Qa(t|0,u|0,18,0)|0;p=y;u=Ta(k|0,m|0,t|0,u|0)|0;p=Ta(u|0,y|0,q|0,p|0)|0;q=Ha;c[q>>2]=p;c[q+4>>2]=y;q=Ia;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Mb;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Qa(p|0,q|0,18,0)|0;k=y;q=Ta(t|0,u|0,p|0,q|0)|0;k=Ta(q|0,y|0,m|0,k|0)|0;m=Mb;c[m>>2]=k;c[m+4>>2]=y;ua(Mb);m=Ja;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Ka;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Qa(k|0,m|0,18,0)|0;t=y;m=Ta(p|0,q|0,k|0,m|0)|0;t=Ta(m|0,y|0,u|0,t|0)|0;u=Ka;c[u>>2]=t;c[u+4>>2]=y;u=La;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Ma;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Qa(t|0,u|0,18,0)|0;p=y;u=Ta(k|0,m|0,t|0,u|0)|0;p=Ta(u|0,y|0,q|0,p|0)|0;q=Ma;c[q>>2]=p;c[q+4>>2]=y;q=Na;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Oa;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Qa(p|0,q|0,18,0)|0;k=y;q=Ta(t|0,u|0,p|0,q|0)|0;k=Ta(q|0,y|0,m|0,k|0)|0;m=Oa;c[m>>2]=k;c[m+4>>2]=y;m=Pa;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Ra;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Qa(k|0,m|0,18,0)|0;t=y;m=Ta(p|0,q|0,k|0,m|0)|0;t=Ta(m|0,y|0,u|0,t|0)|0;u=Ra;c[u>>2]=t;c[u+4>>2]=y;u=Sa;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Va;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Qa(t|0,u|0,18,0)|0;p=y;u=Ta(k|0,m|0,t|0,u|0)|0;p=Ta(u|0,y|0,q|0,p|0)|0;q=Va;c[q>>2]=p;c[q+4>>2]=y;q=Xa;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Ya;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Qa(p|0,q|0,18,0)|0;k=y;q=Ta(t|0,u|0,p|0,q|0)|0;k=Ta(q|0,y|0,m|0,k|0)|0;m=Ya;c[m>>2]=k;c[m+4>>2]=y;m=Za;k=c[m>>2]|0;m=c[m+4>>2]|0;q=_a;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Qa(k|0,m|0,18,0)|0;t=y;m=Ta(p|0,q|0,k|0,m|0)|0;t=Ta(m|0,y|0,u|0,t|0)|0;u=_a;c[u>>2]=t;c[u+4>>2]=y;u=$a;t=c[u>>2]|0;u=c[u+4>>2]|0;m=ab;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Qa(t|0,u|0,18,0)|0;p=y;u=Ta(k|0,m|0,t|0,u|0)|0;p=Ta(u|0,y|0,q|0,p|0)|0;q=ab;c[q>>2]=p;c[q+4>>2]=y;q=bb;p=c[q>>2]|0;q=c[q+4>>2]|0;u=tb;t=c[u>>2]|0;u=c[u+4>>2]|0;m=Qa(p|0,q|0,18,0)|0;k=y;q=Ta(t|0,u|0,p|0,q|0)|0;k=Ta(q|0,y|0,m|0,k|0)|0;m=tb;c[m>>2]=k;c[m+4>>2]=y;ua(tb);m=Mb;k=c[m>>2]|0;m=c[m+4>>2]|0;q=Ha;p=c[q>>2]|0;q=c[q+4>>2]|0;u=Fa;t=c[u>>2]|0;u=c[u+4>>2]|0;z=Da;x=c[z>>2]|0;z=c[z+4>>2]|0;D=Ba;C=c[D>>2]|0;D=c[D+4>>2]|0;H=za;G=c[H>>2]|0;H=c[H+4>>2]|0;L=xa;K=c[L>>2]|0;L=c[L+4>>2]|0;Q=ra;P=c[Q>>2]|0;Q=c[Q+4>>2]|0;U=pa;T=c[U>>2]|0;U=c[U+4>>2]|0;da=fa;X=c[da>>2]|0;da=c[da+4>>2]|0;n=tb;o=c[n>>2]|0;n=c[n+4>>2]|0;s=Ta(o|0,n|0,k|0,m|0)|0;r=Mb;c[r>>2]=s;c[r+4>>2]=y;r=ab;s=c[r>>2]|0;r=c[r+4>>2]|0;w=Ta(s|0,r|0,p|0,q|0)|0;v=Ha;c[v>>2]=w;c[v+4>>2]=y;v=_a;w=c[v>>2]|0;v=c[v+4>>2]|0;B=Ta(w|0,v|0,t|0,u|0)|0;A=Fa;c[A>>2]=B;c[A+4>>2]=y;A=Ya;B=c[A>>2]|0;A=c[A+4>>2]|0;F=Ta(B|0,A|0,x|0,z|0)|0;E=Da;c[E>>2]=F;c[E+4>>2]=y;E=Va;F=c[E>>2]|0;E=c[E+4>>2]|0;J=Ta(F|0,E|0,C|0,D|0)|0;I=Ba;c[I>>2]=J;c[I+4>>2]=y;I=Ra;J=c[I>>2]|0;I=c[I+4>>2]|0;O=Ta(J|0,I|0,G|0,H|0)|0;M=za;c[M>>2]=O;c[M+4>>2]=y;M=Oa;O=c[M>>2]|0;M=c[M+4>>2]|0;S=Ta(O|0,M|0,K|0,L|0)|0;R=xa;c[R>>2]=S;c[R+4>>2]=y;R=Ma;S=c[R>>2]|0;R=c[R+4>>2]|0;W=Ta(S|0,R|0,P|0,Q|0)|0;V=ra;c[V>>2]=W;c[V+4>>2]=y;V=Ka;W=c[V>>2]|0;V=c[V+4>>2]|0;ob=Ta(W|0,V|0,T|0,U|0)|0;d=pa;c[d>>2]=ob;c[d+4>>2]=y;d=cb;ob=c[d>>2]|0;d=c[d+4>>2]|0;i=Ta(ob|0,d|0,X|0,da|0)|0;j=fa;c[j>>2]=i;c[j+4>>2]=y;n=Ua(k|0,m|0,o|0,n|0)|0;o=tb;c[o>>2]=n;c[o+4>>2]=y;r=Ua(p|0,q|0,s|0,r|0)|0;s=ab;c[s>>2]=r;c[s+4>>2]=y;v=Ua(t|0,u|0,w|0,v|0)|0;w=_a;c[w>>2]=v;c[w+4>>2]=y;A=Ua(x|0,z|0,B|0,A|0)|0;B=Ya;c[B>>2]=A;c[B+4>>2]=y;E=Ua(C|0,D|0,F|0,E|0)|0;F=Va;c[F>>2]=E;c[F+4>>2]=y;I=Ua(G|0,H|0,J|0,I|0)|0;J=Ra;c[J>>2]=I;c[J+4>>2]=y;M=Ua(K|0,L|0,O|0,M|0)|0;O=Oa;c[O>>2]=M;c[O+4>>2]=y;R=Ua(P|0,Q|0,S|0,R|0)|0;S=Ma;c[S>>2]=R;c[S+4>>2]=y;V=Ua(T|0,U|0,W|0,V|0)|0;W=Ka;c[W>>2]=V;c[W+4>>2]=y;d=Ua(X|0,da|0,ob|0,d|0)|0;ob=cb;c[ob>>2]=d;c[ob+4>>2]=y;va(vb,Mb);va(ub,tb);ta(tb,ub,pb);ob=Ja;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Ka;X=c[da>>2]|0;da=c[da+4>>2]|0;W=Qa(d|0,ob|0,18,0)|0;V=y;ob=Ta(X|0,da|0,d|0,ob|0)|0;V=Ta(ob|0,y|0,W|0,V|0)|0;W=Ka;c[W>>2]=V;c[W+4>>2]=y;W=La;V=c[W>>2]|0;W=c[W+4>>2]|0;ob=Ma;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(V|0,W|0,18,0)|0;X=y;W=Ta(d|0,ob|0,V|0,W|0)|0;X=Ta(W|0,y|0,da|0,X|0)|0;da=Ma;c[da>>2]=X;c[da+4>>2]=y;da=Na;X=c[da>>2]|0;da=c[da+4>>2]|0;W=Oa;V=c[W>>2]|0;W=c[W+4>>2]|0;ob=Qa(X|0,da|0,18,0)|0;d=y;da=Ta(V|0,W|0,X|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Oa;c[ob>>2]=d;c[ob+4>>2]=y;ob=Pa;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Ra;X=c[da>>2]|0;da=c[da+4>>2]|0;W=Qa(d|0,ob|0,18,0)|0;V=y;ob=Ta(X|0,da|0,d|0,ob|0)|0;V=Ta(ob|0,y|0,W|0,V|0)|0;W=Ra;c[W>>2]=V;c[W+4>>2]=y;W=Sa;V=c[W>>2]|0;W=c[W+4>>2]|0;ob=Va;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(V|0,W|0,18,0)|0;X=y;W=Ta(d|0,ob|0,V|0,W|0)|0;X=Ta(W|0,y|0,da|0,X|0)|0;da=Va;c[da>>2]=X;c[da+4>>2]=y;da=Xa;X=c[da>>2]|0;da=c[da+4>>2]|0;W=Ya;V=c[W>>2]|0;W=c[W+4>>2]|0;ob=Qa(X|0,da|0,18,0)|0;d=y;da=Ta(V|0,W|0,X|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ya;c[ob>>2]=d;c[ob+4>>2]=y;ob=Za;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=_a;X=c[da>>2]|0;da=c[da+4>>2]|0;W=Qa(d|0,ob|0,18,0)|0;V=y;ob=Ta(X|0,da|0,d|0,ob|0)|0;V=Ta(ob|0,y|0,W|0,V|0)|0;W=_a;c[W>>2]=V;c[W+4>>2]=y;W=$a;V=c[W>>2]|0;W=c[W+4>>2]|0;ob=ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(V|0,W|0,18,0)|0;X=y;W=Ta(d|0,ob|0,V|0,W|0)|0;X=Ta(W|0,y|0,da|0,X|0)|0;da=ab;c[da>>2]=X;c[da+4>>2]=y;da=bb;X=c[da>>2]|0;da=c[da+4>>2]|0;W=tb;V=c[W>>2]|0;W=c[W+4>>2]|0;ob=Qa(X|0,da|0,18,0)|0;d=y;da=Ta(V|0,W|0,X|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=tb;c[ob>>2]=d;c[ob+4>>2]=y;ua(tb);ob=h;d=vb;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));ob=ca;d=tb;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(rb,f);va(sb,e);ta(ba,rb,sb);j=ba+144|0;o=c[j>>2]|0;j=c[j+4>>2]|0;n=ba+64|0;m=n;k=c[m>>2]|0;m=c[m+4>>2]|0;d=Qa(o|0,j|0,18,0)|0;i=y;j=Ta(k|0,m|0,o|0,j|0)|0;i=Ta(j|0,y|0,d|0,i|0)|0;c[n>>2]=i;c[n+4>>2]=y;n=ba+136|0;i=c[n>>2]|0;n=c[n+4>>2]|0;d=ba+56|0;j=d;o=c[j>>2]|0;j=c[j+4>>2]|0;m=Qa(i|0,n|0,18,0)|0;k=y;n=Ta(o|0,j|0,i|0,n|0)|0;k=Ta(n|0,y|0,m|0,k|0)|0;c[d>>2]=k;c[d+4>>2]=y;d=ba+128|0;k=c[d>>2]|0;d=c[d+4>>2]|0;m=ba+48|0;n=m;i=c[n>>2]|0;n=c[n+4>>2]|0;j=Qa(k|0,d|0,18,0)|0;o=y;d=Ta(i|0,n|0,k|0,d|0)|0;o=Ta(d|0,y|0,j|0,o|0)|0;c[m>>2]=o;c[m+4>>2]=y;m=ba+120|0;o=c[m>>2]|0;m=c[m+4>>2]|0;j=ba+40|0;d=j;k=c[d>>2]|0;d=c[d+4>>2]|0;n=Qa(o|0,m|0,18,0)|0;i=y;m=Ta(k|0,d|0,o|0,m|0)|0;i=Ta(m|0,y|0,n|0,i|0)|0;c[j>>2]=i;c[j+4>>2]=y;j=ba+112|0;i=c[j>>2]|0;j=c[j+4>>2]|0;n=ba+32|0;m=n;o=c[m>>2]|0;m=c[m+4>>2]|0;d=Qa(i|0,j|0,18,0)|0;k=y;j=Ta(o|0,m|0,i|0,j|0)|0;k=Ta(j|0,y|0,d|0,k|0)|0;c[n>>2]=k;c[n+4>>2]=y;n=ba+104|0;k=c[n>>2]|0;n=c[n+4>>2]|0;d=ba+24|0;j=d;i=c[j>>2]|0;j=c[j+4>>2]|0;m=Qa(k|0,n|0,18,0)|0;o=y;n=Ta(i|0,j|0,k|0,n|0)|0;o=Ta(n|0,y|0,m|0,o|0)|0;c[d>>2]=o;c[d+4>>2]=y;d=ba+96|0;o=c[d>>2]|0;d=c[d+4>>2]|0;m=ba+16|0;n=m;k=c[n>>2]|0;n=c[n+4>>2]|0;j=Qa(o|0,d|0,18,0)|0;i=y;d=Ta(k|0,n|0,o|0,d|0)|0;i=Ta(d|0,y|0,j|0,i|0)|0;c[m>>2]=i;c[m+4>>2]=y;m=ba+88|0;i=c[m>>2]|0;m=c[m+4>>2]|0;j=ba+8|0;d=j;o=c[d>>2]|0;d=c[d+4>>2]|0;n=Qa(i|0,m|0,18,0)|0;k=y;m=Ta(o|0,d|0,i|0,m|0)|0;k=Ta(m|0,y|0,n|0,k|0)|0;c[j>>2]=k;c[j+4>>2]=y;j=ba+80|0;k=c[j>>2]|0;j=c[j+4>>2]|0;n=ba;m=c[n>>2]|0;n=c[n+4>>2]|0;i=Qa(k|0,j|0,18,0)|0;d=y;j=Ta(m|0,n|0,k|0,j|0)|0;d=Ta(j|0,y|0,i|0,d|0)|0;i=ba;c[i>>2]=d;c[i+4>>2]=y;ua(ba);i=rb;d=c[i>>2]|0;i=c[i+4>>2]|0;j=sb;j=Ua(d|0,i|0,c[j>>2]|0,c[j+4>>2]|0)|0;k=y;n=sb;c[n>>2]=j;c[n+4>>2]=k;n=db;m=c[n>>2]|0;n=c[n+4>>2]|0;o=eb;o=Ua(m|0,n|0,c[o>>2]|0,c[o+4>>2]|0)|0;p=y;r=eb;c[r>>2]=o;c[r+4>>2]=p;r=fb;q=c[r>>2]|0;r=c[r+4>>2]|0;s=gb;s=Ua(q|0,r|0,c[s>>2]|0,c[s+4>>2]|0)|0;t=y;v=gb;c[v>>2]=s;c[v+4>>2]=t;v=hb;u=c[v>>2]|0;v=c[v+4>>2]|0;w=ib;w=Ua(u|0,v|0,c[w>>2]|0,c[w+4>>2]|0)|0;x=y;A=ib;c[A>>2]=w;c[A+4>>2]=x;A=jb;z=c[A>>2]|0;A=c[A+4>>2]|0;B=kb;B=Ua(z|0,A|0,c[B>>2]|0,c[B+4>>2]|0)|0;C=y;E=kb;c[E>>2]=B;c[E+4>>2]=C;E=lb;D=c[E>>2]|0;E=c[E+4>>2]|0;F=mb;F=Ua(D|0,E|0,c[F>>2]|0,c[F+4>>2]|0)|0;G=y;I=mb;c[I>>2]=F;c[I+4>>2]=G;I=nb;H=c[I>>2]|0;I=c[I+4>>2]|0;J=ga;J=Ua(H|0,I|0,c[J>>2]|0,c[J+4>>2]|0)|0;K=y;M=ga;c[M>>2]=J;c[M+4>>2]=K;M=ha;L=c[M>>2]|0;M=c[M+4>>2]|0;O=ia;O=Ua(L|0,M|0,c[O>>2]|0,c[O+4>>2]|0)|0;P=y;R=ia;c[R>>2]=O;c[R+4>>2]=P;R=ja;Q=c[R>>2]|0;R=c[R+4>>2]|0;S=ka;S=Ua(Q|0,R|0,c[S>>2]|0,c[S+4>>2]|0)|0;T=y;V=ka;c[V>>2]=S;c[V+4>>2]=T;V=la;U=c[V>>2]|0;V=c[V+4>>2]|0;W=ma;W=Ua(U|0,V|0,c[W>>2]|0,c[W+4>>2]|0)|0;X=y;ob=ma;c[ob>>2]=W;c[ob+4>>2]=X;ob=wb;da=ob+72|0;do{c[ob>>2]=0;ob=ob+4|0}while((ob|0)<(da|0));Vb=Qa(j|0,k|0,121665,0)|0;Rb=Ib;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=Qa(o|0,p|0,121665,0)|0;Vb=xb;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=Qa(s|0,t|0,121665,0)|0;Rb=yb;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=Qa(w|0,x|0,121665,0)|0;Vb=zb;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=Qa(B|0,C|0,121665,0)|0;Rb=Ab;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=Qa(F|0,G|0,121665,0)|0;Vb=Bb;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=Qa(J|0,K|0,121665,0)|0;Rb=Cb;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=Qa(O|0,P|0,121665,0)|0;Vb=Db;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=Qa(S|0,T|0,121665,0)|0;Rb=Eb;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=Qa(W|0,X|0,121665,0)|0;Vb=na;c[Vb>>2]=Rb;c[Vb+4>>2]=y;ua(Ib);Vb=Ib;Vb=Ta(c[Vb>>2]|0,c[Vb+4>>2]|0,d|0,i|0)|0;Rb=Ib;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=xb;Rb=Ta(c[Rb>>2]|0,c[Rb+4>>2]|0,m|0,n|0)|0;Vb=xb;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=yb;Vb=Ta(c[Vb>>2]|0,c[Vb+4>>2]|0,q|0,r|0)|0;Rb=yb;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=zb;Rb=Ta(c[Rb>>2]|0,c[Rb+4>>2]|0,u|0,v|0)|0;Vb=zb;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=Ab;Vb=Ta(c[Vb>>2]|0,c[Vb+4>>2]|0,z|0,A|0)|0;Rb=Ab;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=Bb;Rb=Ta(c[Rb>>2]|0,c[Rb+4>>2]|0,D|0,E|0)|0;Vb=Bb;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=Cb;Vb=Ta(c[Vb>>2]|0,c[Vb+4>>2]|0,H|0,I|0)|0;Rb=Cb;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=Db;Rb=Ta(c[Rb>>2]|0,c[Rb+4>>2]|0,L|0,M|0)|0;Vb=Db;c[Vb>>2]=Rb;c[Vb+4>>2]=y;Vb=Eb;Vb=Ta(c[Vb>>2]|0,c[Vb+4>>2]|0,Q|0,R|0)|0;Rb=Eb;c[Rb>>2]=Vb;c[Rb+4>>2]=y;Rb=na;Rb=Ta(c[Rb>>2]|0,c[Rb+4>>2]|0,U|0,V|0)|0;Vb=na;c[Vb>>2]=Rb;c[Vb+4>>2]=y;ta(aa,sb,Ib);Vb=aa+144|0;Rb=c[Vb>>2]|0;Vb=c[Vb+4>>2]|0;Tb=aa+64|0;Sb=Tb;Ub=c[Sb>>2]|0;Sb=c[Sb+4>>2]|0;Wb=Qa(Rb|0,Vb|0,18,0)|0;Xb=y;Vb=Ta(Ub|0,Sb|0,Rb|0,Vb|0)|0;Xb=Ta(Vb|0,y|0,Wb|0,Xb|0)|0;c[Tb>>2]=Xb;c[Tb+4>>2]=y;Tb=aa+136|0;Xb=c[Tb>>2]|0;Tb=c[Tb+4>>2]|0;Wb=aa+56|0;Vb=Wb;Rb=c[Vb>>2]|0;Vb=c[Vb+4>>2]|0;Sb=Qa(Xb|0,Tb|0,18,0)|0;Ub=y;Tb=Ta(Rb|0,Vb|0,Xb|0,Tb|0)|0;Ub=Ta(Tb|0,y|0,Sb|0,Ub|0)|0;c[Wb>>2]=Ub;c[Wb+4>>2]=y;Wb=aa+128|0;Ub=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;Sb=aa+48|0;Tb=Sb;Xb=c[Tb>>2]|0;Tb=c[Tb+4>>2]|0;Vb=Qa(Ub|0,Wb|0,18,0)|0;Rb=y;Wb=Ta(Xb|0,Tb|0,Ub|0,Wb|0)|0;Rb=Ta(Wb|0,y|0,Vb|0,Rb|0)|0;c[Sb>>2]=Rb;c[Sb+4>>2]=y;Sb=aa+120|0;Rb=c[Sb>>2]|0;Sb=c[Sb+4>>2]|0;Vb=aa+40|0;Wb=Vb;Ub=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;Tb=Qa(Rb|0,Sb|0,18,0)|0;Xb=y;Sb=Ta(Ub|0,Wb|0,Rb|0,Sb|0)|0;Xb=Ta(Sb|0,y|0,Tb|0,Xb|0)|0;c[Vb>>2]=Xb;c[Vb+4>>2]=y;Vb=aa+112|0;Xb=c[Vb>>2]|0;Vb=c[Vb+4>>2]|0;Tb=aa+32|0;Sb=Tb;Rb=c[Sb>>2]|0;Sb=c[Sb+4>>2]|0;Wb=Qa(Xb|0,Vb|0,18,0)|0;Ub=y;Vb=Ta(Rb|0,Sb|0,Xb|0,Vb|0)|0;Ub=Ta(Vb|0,y|0,Wb|0,Ub|0)|0;c[Tb>>2]=Ub;c[Tb+4>>2]=y;Tb=aa+104|0;Ub=c[Tb>>2]|0;Tb=c[Tb+4>>2]|0;Wb=aa+24|0;Vb=Wb;Xb=c[Vb>>2]|0;Vb=c[Vb+4>>2]|0;Sb=Qa(Ub|0,Tb|0,18,0)|0;Rb=y;Tb=Ta(Xb|0,Vb|0,Ub|0,Tb|0)|0;Rb=Ta(Tb|0,y|0,Sb|0,Rb|0)|0;c[Wb>>2]=Rb;c[Wb+4>>2]=y;Wb=aa+96|0;Rb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;Sb=aa+16|0;Tb=Sb;Ub=c[Tb>>2]|0;Tb=c[Tb+4>>2]|0;Vb=Qa(Rb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(Ub|0,Tb|0,Rb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,Vb|0,Xb|0)|0;c[Sb>>2]=Xb;c[Sb+4>>2]=y;Sb=aa+88|0;Xb=c[Sb>>2]|0;Sb=c[Sb+4>>2]|0;Vb=aa+8|0;Wb=Vb;Rb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;Tb=Qa(Xb|0,Sb|0,18,0)|0;Ub=y;Sb=Ta(Rb|0,Wb|0,Xb|0,Sb|0)|0;Ub=Ta(Sb|0,y|0,Tb|0,Ub|0)|0;c[Vb>>2]=Ub;c[Vb+4>>2]=y;Vb=aa+80|0;Ub=c[Vb>>2]|0;Vb=c[Vb+4>>2]|0;Tb=aa;Sb=c[Tb>>2]|0;Tb=c[Tb+4>>2]|0;Xb=Qa(Ub|0,Vb|0,18,0)|0;Wb=y;Vb=Ta(Sb|0,Tb|0,Ub|0,Vb|0)|0;Wb=Ta(Vb|0,y|0,Xb|0,Wb|0)|0;Xb=aa;c[Xb>>2]=Wb;c[Xb+4>>2]=y;ua(aa);sa(ba,h,Z,0);sa(aa,ca,Z,0);$=$+1|0;if(($|0)==8)break;else{Ub=_;Vb=g;Wb=f;Xb=e;k=Y<<1&255;_=h;f=ba;e=aa;g=ca;h=Ub;ca=Vb;ba=Wb;aa=Xb}}ea=ea+1|0;if((ea|0)==32)break;else{m=h;h=_;d=ca;i=aa;j=ba}}ob=Jb;d=ba;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));ob=Kb;d=aa;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(rb,Kb);va(Hb,rb);va(Gb,Hb);ta(Ib,Gb,Kb);e=Ib+144|0;j=e;i=c[j>>2]|0;j=c[j+4>>2]|0;h=Eb;g=c[h>>2]|0;h=c[h+4>>2]|0;f=Qa(i|0,j|0,18,0)|0;k=y;j=Ta(g|0,h|0,i|0,j|0)|0;k=Ta(j|0,y|0,f|0,k|0)|0;f=Eb;c[f>>2]=k;c[f+4>>2]=y;f=Ib+136|0;k=f;j=c[k>>2]|0;k=c[k+4>>2]|0;i=Db;h=c[i>>2]|0;i=c[i+4>>2]|0;g=Qa(j|0,k|0,18,0)|0;m=y;k=Ta(h|0,i|0,j|0,k|0)|0;m=Ta(k|0,y|0,g|0,m|0)|0;g=Db;c[g>>2]=m;c[g+4>>2]=y;g=Ib+128|0;m=g;k=c[m>>2]|0;m=c[m+4>>2]|0;j=Cb;i=c[j>>2]|0;j=c[j+4>>2]|0;h=Qa(k|0,m|0,18,0)|0;da=y;m=Ta(i|0,j|0,k|0,m|0)|0;da=Ta(m|0,y|0,h|0,da|0)|0;h=Cb;c[h>>2]=da;c[h+4>>2]=y;h=Ib+120|0;da=h;m=c[da>>2]|0;da=c[da+4>>2]|0;k=Bb;j=c[k>>2]|0;k=c[k+4>>2]|0;i=Qa(m|0,da|0,18,0)|0;d=y;da=Ta(j|0,k|0,m|0,da|0)|0;d=Ta(da|0,y|0,i|0,d|0)|0;i=Bb;c[i>>2]=d;c[i+4>>2]=y;i=Ib+112|0;d=i;da=c[d>>2]|0;d=c[d+4>>2]|0;m=Ab;k=c[m>>2]|0;m=c[m+4>>2]|0;j=Qa(da|0,d|0,18,0)|0;ob=y;d=Ta(k|0,m|0,da|0,d|0)|0;ob=Ta(d|0,y|0,j|0,ob|0)|0;j=Ab;c[j>>2]=ob;c[j+4>>2]=y;j=Ib+104|0;ob=j;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=zb;m=c[da>>2]|0;da=c[da+4>>2]|0;k=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(m|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,k|0,Vb|0)|0;k=zb;c[k>>2]=Vb;c[k+4>>2]=y;k=Ib+96|0;Vb=k;ob=c[Vb>>2]|0;Vb=c[Vb+4>>2]|0;d=yb;da=c[d>>2]|0;d=c[d+4>>2]|0;m=Qa(ob|0,Vb|0,18,0)|0;Wb=y;Vb=Ta(da|0,d|0,ob|0,Vb|0)|0;Wb=Ta(Vb|0,y|0,m|0,Wb|0)|0;m=yb;c[m>>2]=Wb;c[m+4>>2]=y;m=Ib+88|0;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=sb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));ta(Ib,sb,rb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Mb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Gb,Mb);ta(Ib,Gb,sb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=tb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Gb,tb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);ta(Ib,Gb,tb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=ub;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Gb,ub);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);ta(Ib,Hb,ub);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=vb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Gb,vb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);ta(Ib,Hb,vb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Gb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);ta(Ib,Gb,ub);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Nb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Gb,Nb);va(Hb,Gb);d=2;do{va(Gb,Hb);va(Hb,Gb);d=d+2|0}while((d|0)<50);ta(Ib,Hb,Nb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Fb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Hb,Fb);va(Gb,Hb);d=2;do{va(Hb,Gb);va(Gb,Hb);d=d+2|0}while((d|0)<100);ta(Ib,Gb,Fb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Hb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Gb,Hb);va(Hb,Gb);d=2;do{va(Gb,Hb);va(Hb,Gb);d=d+2|0}while((d|0)<50);ta(Ib,Hb,Nb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Gb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);va(Gb,Hb);va(Hb,Gb);ta(Ib,Hb,Mb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Lb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));ta(Ib,Jb,Lb);ob=e;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Eb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Eb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=f;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Db;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Db;c[da>>2]=Xb;c[da+4>>2]=y;da=g;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Cb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Cb;c[ob>>2]=d;c[ob+4>>2]=y;ob=h;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Bb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=Bb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=i;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Ab;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=Ab;c[da>>2]=Xb;c[da+4>>2]=y;da=j;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=zb;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=zb;c[ob>>2]=d;c[ob+4>>2]=y;ob=k;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=yb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Qa(d|0,ob|0,18,0)|0;Vb=y;ob=Ta(Xb|0,da|0,d|0,ob|0)|0;Vb=Ta(ob|0,y|0,Wb|0,Vb|0)|0;Wb=yb;c[Wb>>2]=Vb;c[Wb+4>>2]=y;Wb=m;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=xb;d=c[ob>>2]|0;ob=c[ob+4>>2]|0;da=Qa(Vb|0,Wb|0,18,0)|0;Xb=y;Wb=Ta(d|0,ob|0,Vb|0,Wb|0)|0;Xb=Ta(Wb|0,y|0,da|0,Xb|0)|0;da=xb;c[da>>2]=Xb;c[da+4>>2]=y;da=wb;Xb=c[da>>2]|0;da=c[da+4>>2]|0;Wb=Ib;Vb=c[Wb>>2]|0;Wb=c[Wb+4>>2]|0;ob=Qa(Xb|0,da|0,18,0)|0;d=y;da=Ta(Vb|0,Wb|0,Xb|0,da|0)|0;d=Ta(da|0,y|0,ob|0,d|0)|0;ob=Ib;c[ob>>2]=d;c[ob+4>>2]=y;ua(Ib);ob=Kb;d=Ib;da=ob+80|0;do{c[ob>>2]=c[d>>2];ob=ob+4|0;d=d+4|0}while((ob|0)<(da|0));Nb=c[Kb>>2]|0;Pb=(Nb>>31&Nb)>>26;Wb=Pb+(c[Kb+8>>2]|0)|0;Db=(Wb>>31&Wb)>>25;Qb=Db+(c[Kb+16>>2]|0)|0;Xb=(Qb>>31&Qb)>>26;Rb=Xb+(c[Kb+24>>2]|0)|0;Cb=(Rb>>31&Rb)>>25;Sb=Cb+(c[Kb+32>>2]|0)|0;Jb=(Sb>>31&Sb)>>26;Tb=Jb+(c[Kb+40>>2]|0)|0;Ib=(Tb>>31&Tb)>>25;Ub=Ib+(c[Kb+48>>2]|0)|0;Hb=(Ub>>31&Ub)>>26;Vb=Hb+(c[Kb+56>>2]|0)|0;Mb=(Vb>>31&Vb)>>25;Lb=Mb+(c[Kb+64>>2]|0)|0;Gb=(Lb>>31&Lb)>>26;Fb=Gb+(c[Kb+72>>2]|0)|0;Eb=(Fb>>31&Fb)>>25;Nb=(N(Pb,-67108864)|0)+Nb+(Eb*19|0)|0;Pb=(Nb>>31&Nb)>>26;Wb=(N(Db,-33554432)|0)+Wb+Pb|0;Db=(Wb>>31&Wb)>>25;Qb=(N(Xb,-67108864)|0)+Qb+Db|0;Xb=(Qb>>31&Qb)>>26;Rb=(N(Cb,-33554432)|0)+Rb+Xb|0;Kb=(Rb>>31&Rb)>>25;Sb=(N(Jb,-67108864)|0)+Sb+Kb|0;Jb=(Sb>>31&Sb)>>26;Tb=(N(Ib,-33554432)|0)+Tb+Jb|0;Ib=(Tb>>31&Tb)>>25;Ub=(N(Hb,-67108864)|0)+Ub+Ib|0;Hb=(Ub>>31&Ub)>>26;Vb=(N(Mb,-33554432)|0)+Vb+Hb|0;Mb=(Vb>>31&Vb)>>25;Lb=(N(Gb,-67108864)|0)+Lb+Mb|0;Gb=(Lb>>31&Lb)>>26;Fb=(N(Eb,-33554432)|0)+Fb+Gb|0;Eb=(Fb>>31&Fb)>>25;Nb=(N(Pb,-67108864)|0)+Nb+(Eb*19|0)|0;Pb=(Nb>>31&Nb)>>26;Nb=(N(Pb,-67108864)|0)+Nb|0;Pb=(N(Db,-33554432)|0)+Wb+Pb+(Nb>>26)|0;Qb=(N(Xb,-67108864)|0)+Qb+(Pb>>25)|0;Rb=(N(Kb,-33554432)|0)+Rb+(Qb>>26)|0;Sb=(N(Jb,-67108864)|0)+Sb+(Rb>>25)|0;Tb=(N(Ib,-33554432)|0)+Tb+(Sb>>26)|0;Ub=(N(Hb,-67108864)|0)+Ub+(Tb>>25)|0;Vb=(N(Mb,-33554432)|0)+Vb+(Ub>>26)|0;Lb=(N(Gb,-67108864)|0)+Lb+(Vb>>25)|0;Fb=(N(Eb,-33554432)|0)+Fb+(Lb>>26)|0;Eb=(Fb>>25)*19|0;Gb=Eb+(Nb&67108863)>>26;Mb=Gb+(Pb&33554431)>>25;Pb=Gb+Pb|0;Gb=Mb+(Qb&67108863)>>26;Qb=Mb+Qb|0;Mb=Gb+(Rb&33554431)>>25;Rb=Gb+Rb|0;Gb=Mb+(Sb&67108863)>>26;Sb=Mb+Sb|0;Mb=Gb+(Tb&33554431)>>25;Tb=Gb+Tb|0;Gb=Mb+(Ub&67108863)>>26;Ub=Mb+Ub|0;Mb=Gb+(Vb&33554431)>>25;Vb=Gb+Vb|0;Gb=Mb+(Lb&67108863)>>26;Lb=Mb+Lb|0;Mb=Gb+Fb|0;Nb=((Gb+(Fb&33554431)>>25)*19|0)+(Eb+Nb&67108863)|0;Eb=(Pb|-33554432)&Pb<<16;Eb=Eb<<8&Eb;Eb=Eb<<4&Eb;Eb=Eb<<2&Eb;Fb=(Qb|-67108864)&Qb<<16;Fb=Fb<<8&Fb;Fb=Fb<<4&Fb;Fb=Fb<<2&Fb;Gb=(Rb|-33554432)&Rb<<16;Gb=Gb<<8&Gb;Gb=Gb<<4&Gb;Gb=Gb<<2&Gb;Hb=(Sb|-67108864)&Sb<<16;Hb=Hb<<8&Hb;Hb=Hb<<4&Hb;Hb=Hb<<2&Hb;Ib=(Tb|-33554432)&Tb<<16;Ib=Ib<<8&Ib;Ib=Ib<<4&Ib;Ib=Ib<<2&Ib;Jb=(Ub|-67108864)&Ub<<16;Jb=Jb<<8&Jb;Jb=Jb<<4&Jb;Jb=Jb<<2&Jb;Kb=(Vb|-33554432)&Vb<<16;Kb=Kb<<8&Kb;Kb=Kb<<4&Kb;Kb=Kb<<2&Kb;Xb=(Lb|-67108864)&Lb<<16;Xb=Xb<<8&Xb;Xb=Xb<<4&Xb;Xb=Xb<<2&Xb;Wb=(Mb|-33554432)&Mb<<16;Wb=Wb<<8&Wb;Wb=Wb<<4&Wb;Wb=Wb<<2&Wb;Wb=(Eb<<1&Eb&Fb&Fb<<1&Gb&Gb<<1&Hb&Hb<<1&Ib&Ib<<1)>>31&~(Nb+-67108845>>31)&(Jb<<1&Jb)>>31&(Kb<<1&Kb)>>31&(Xb<<1&Xb)>>31&(Wb<<1&Wb)>>31;Nb=Nb-(Wb&67108845)|0;Xb=Wb&33554431;Pb=(Pb&33554431)-Xb|0;Wb=Wb&67108863;Qb=(Qb&67108863)-Wb|0;Rb=(Rb&33554431)-Xb|0;Sb=(Sb&67108863)-Wb|0;Tb=(Tb&33554431)-Xb|0;Ub=(Ub&67108863)-Wb|0;Vb=(Vb&33554431)-Xb|0;Wb=(Lb&67108863)-Wb|0;Xb=(Mb&33554431)-Xb|0;a[b>>0]=Nb;a[b+1>>0]=Nb>>>8;a[b+2>>0]=Nb>>>16;a[b+3>>0]=Pb<<2|Nb>>>24;a[b+4>>0]=Pb>>>6;a[b+5>>0]=Pb>>>14;a[b+6>>0]=Qb<<3|Pb>>>22;a[b+7>>0]=Qb>>>5;a[b+8>>0]=Qb>>>13;a[b+9>>0]=Rb<<5|Qb>>>21;a[b+10>>0]=Rb>>>3;a[b+11>>0]=Rb>>>11;a[b+12>>0]=Sb<<6|Rb>>>19;a[b+13>>0]=Sb>>>2;a[b+14>>0]=Sb>>>10;a[b+15>>0]=Sb>>>18;a[b+16>>0]=Tb;a[b+17>>0]=Tb>>>8;a[b+18>>0]=Tb>>>16;a[b+19>>0]=Ub<<1|Tb>>>24;a[b+20>>0]=Ub>>>7;a[b+21>>0]=Ub>>>15;a[b+22>>0]=Vb<<3|Ub>>>23;a[b+23>>0]=Vb>>>5;a[b+24>>0]=Vb>>>13;a[b+25>>0]=Wb<<4|Vb>>>21;a[b+26>>0]=Wb>>>4;a[b+27>>0]=Wb>>>12;a[b+28>>0]=Xb<<6|Wb>>>20;a[b+29>>0]=Xb>>>2;a[b+30>>0]=Xb>>>10;a[b+31>>0]=Xb>>>18;l=Ob;return}function qa(b){b=b|0;var c=0;da(0)|0;c=0;do{a[b+c>>0]=da(1)|0;c=c+1|0}while((c|0)!=32);a[b>>0]=a[b>>0]&-8;b=b+31|0;a[b>>0]=a[b>>0]&63|64;return}function ra(b,c){b=b|0;c=c|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=0;g=a[c>>0]|0;h=c;e=b;while(1){i=a[h+2>>0]|0;j=d[h+1>>0]|0;k=j>>>4|(g&255)<<4&48;j=j<<2&60|(i&255)>>>6;l=(g&255)>>>2&255;a[e>>0]=l+65+((25-l|0)>>>8&6)-((51-l|0)>>>8&75)-((61-l|0)>>>8&15)+((62-l|0)>>>8&3);a[e+1>>0]=k+65+((25-k|0)>>>8&6)-((51-k|0)>>>8&75)-((61-k|0)>>>8&15)+((62-k|0)>>>8&3);a[e+2>>0]=j+65+((25-j|0)>>>8&6)-((51-j|0)>>>8&75)-((61-j|0)>>>8&15)+((62-j|0)>>>8&3);i=i&63;a[e+3>>0]=i+65+((25-i|0)>>>8&6)-((51-i|0)>>>8&75)-((61-i|0)>>>8&15)+((62-i|0)>>>8&3);e=f+1|0;h=c+(e*3|0)|0;g=a[h>>0]|0;if((e|0)==10)break;else{f=e;e=b+(e<<2)|0}}l=d[c+31>>0]|0;k=l>>>4|(g&255)<<4&48;l=l<<2&60;j=(g&255)>>>2&255;a[b+40>>0]=j+65+((25-j|0)>>>8&6)-((51-j|0)>>>8&75)-((61-j|0)>>>8&15)+((62-j|0)>>>8&3);a[b+41>>0]=k+65+((25-k|0)>>>8&6)-((51-k|0)>>>8&75)-((61-k|0)>>>8&15)+((62-k|0)>>>8&3);a[b+42>>0]=((25-l|0)>>>8&6)+(l|65)-((51-l|0)>>>8&75);a[b+43>>0]=61;a[b+44>>0]=0;return}function sa(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;d=Ua(0,0,d|0,e|0)|0;i=y;g=a;e=c[g>>2]|0;g=c[g+4>>2]|0;f=b;h=(c[f>>2]^e)&d;f=(c[f+4>>2]^g)&i;e=Ra(0,h^e|0,32)|0;g=a;c[g>>2]=e;c[g+4>>2]=y;g=b;h=Ra(0,c[g>>2]^h|0,32)|0;g=b;c[g>>2]=h;c[g+4>>2]=y;g=a+8|0;h=g;f=c[h>>2]|0;h=c[h+4>>2]|0;e=b+8|0;j=e;k=(c[j>>2]^f)&d;j=(c[j+4>>2]^h)&i;f=Ra(0,k^f|0,32)|0;c[g>>2]=f;c[g+4>>2]=y;g=e;k=Ra(0,c[g>>2]^k|0,32)|0;c[e>>2]=k;c[e+4>>2]=y;e=a+16|0;k=e;g=c[k>>2]|0;k=c[k+4>>2]|0;j=b+16|0;f=j;h=(c[f>>2]^g)&d;f=(c[f+4>>2]^k)&i;g=Ra(0,h^g|0,32)|0;c[e>>2]=g;c[e+4>>2]=y;e=j;h=Ra(0,c[e>>2]^h|0,32)|0;c[j>>2]=h;c[j+4>>2]=y;j=a+24|0;h=j;e=c[h>>2]|0;h=c[h+4>>2]|0;f=b+24|0;g=f;k=(c[g>>2]^e)&d;g=(c[g+4>>2]^h)&i;e=Ra(0,k^e|0,32)|0;c[j>>2]=e;c[j+4>>2]=y;j=f;k=Ra(0,c[j>>2]^k|0,32)|0;c[f>>2]=k;c[f+4>>2]=y;f=a+32|0;k=f;j=c[k>>2]|0;k=c[k+4>>2]|0;g=b+32|0;e=g;h=(c[e>>2]^j)&d;e=(c[e+4>>2]^k)&i;j=Ra(0,h^j|0,32)|0;c[f>>2]=j;c[f+4>>2]=y;f=g;h=Ra(0,c[f>>2]^h|0,32)|0;c[g>>2]=h;c[g+4>>2]=y;g=a+40|0;h=g;f=c[h>>2]|0;h=c[h+4>>2]|0;e=b+40|0;j=e;k=(c[j>>2]^f)&d;j=(c[j+4>>2]^h)&i;f=Ra(0,k^f|0,32)|0;c[g>>2]=f;c[g+4>>2]=y;g=e;k=Ra(0,c[g>>2]^k|0,32)|0;c[e>>2]=k;c[e+4>>2]=y;e=a+48|0;k=e;g=c[k>>2]|0;k=c[k+4>>2]|0;j=b+48|0;f=j;h=(c[f>>2]^g)&d;f=(c[f+4>>2]^k)&i;g=Ra(0,h^g|0,32)|0;c[e>>2]=g;c[e+4>>2]=y;e=j;h=Ra(0,c[e>>2]^h|0,32)|0;c[j>>2]=h;c[j+4>>2]=y;j=a+56|0;h=j;e=c[h>>2]|0;h=c[h+4>>2]|0;f=b+56|0;g=f;k=(c[g>>2]^e)&d;g=(c[g+4>>2]^h)&i;e=Ra(0,k^e|0,32)|0;c[j>>2]=e;c[j+4>>2]=y;j=f;k=Ra(0,c[j>>2]^k|0,32)|0;c[f>>2]=k;c[f+4>>2]=y;f=a+64|0;k=f;j=c[k>>2]|0;k=c[k+4>>2]|0;g=b+64|0;e=g;h=(c[e>>2]^j)&d;e=(c[e+4>>2]^k)&i;j=Ra(0,h^j|0,32)|0;c[f>>2]=j;c[f+4>>2]=y;f=g;h=Ra(0,c[f>>2]^h|0,32)|0;c[g>>2]=h;c[g+4>>2]=y;g=a+72|0;h=g;f=c[h>>2]|0;h=c[h+4>>2]|0;e=b+72|0;a=e;d=(c[a>>2]^f)&d;a=(c[a+4>>2]^h)&i;f=Ra(0,d^f|0,32)|0;b=g;c[b>>2]=f;c[b+4>>2]=y;b=e;d=Ra(0,c[b>>2]^d|0,32)|0;c[e>>2]=d;c[e+4>>2]=y;return}function ta(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,z=0,A=0;h=Ra(0,c[b>>2]|0,32)|0;n=y;w=Ra(0,c[d>>2]|0,32)|0;n=Qa(w|0,y|0,h|0,n|0)|0;h=a;c[h>>2]=n;c[h+4>>2]=y;h=Ra(0,c[b>>2]|0,32)|0;n=y;w=d+8|0;s=Ra(0,c[w>>2]|0,32)|0;n=Qa(s|0,y|0,h|0,n|0)|0;h=y;s=b+8|0;r=Ra(0,c[s>>2]|0,32)|0;p=y;v=Ra(0,c[d>>2]|0,32)|0;p=Qa(v|0,y|0,r|0,p|0)|0;h=Ta(p|0,y|0,n|0,h|0)|0;n=a+8|0;c[n>>2]=h;c[n+4>>2]=y;n=Ra(0,c[s>>2]|0,31)|0;h=y;p=Ra(0,c[w>>2]|0,32)|0;h=Qa(p|0,y|0,n|0,h|0)|0;n=y;p=Ra(0,c[b>>2]|0,32)|0;r=y;v=d+16|0;l=Ra(0,c[v>>2]|0,32)|0;r=Qa(l|0,y|0,p|0,r|0)|0;n=Ta(r|0,y|0,h|0,n|0)|0;h=y;r=b+16|0;p=Ra(0,c[r>>2]|0,32)|0;l=y;u=Ra(0,c[d>>2]|0,32)|0;l=Qa(u|0,y|0,p|0,l|0)|0;l=Ta(n|0,h|0,l|0,y|0)|0;h=a+16|0;c[h>>2]=l;c[h+4>>2]=y;h=Ra(0,c[s>>2]|0,32)|0;l=y;n=Ra(0,c[v>>2]|0,32)|0;l=Qa(n|0,y|0,h|0,l|0)|0;h=y;n=Ra(0,c[r>>2]|0,32)|0;p=y;u=Ra(0,c[w>>2]|0,32)|0;p=Qa(u|0,y|0,n|0,p|0)|0;h=Ta(p|0,y|0,l|0,h|0)|0;l=y;p=Ra(0,c[b>>2]|0,32)|0;n=y;u=d+24|0;g=Ra(0,c[u>>2]|0,32)|0;n=Qa(g|0,y|0,p|0,n|0)|0;n=Ta(h|0,l|0,n|0,y|0)|0;l=y;h=b+24|0;p=Ra(0,c[h>>2]|0,32)|0;g=y;j=Ra(0,c[d>>2]|0,32)|0;g=Qa(j|0,y|0,p|0,g|0)|0;g=Ta(n|0,l|0,g|0,y|0)|0;l=a+24|0;c[l>>2]=g;c[l+4>>2]=y;l=Ra(0,c[r>>2]|0,32)|0;g=y;n=Ra(0,c[v>>2]|0,32)|0;g=Qa(n|0,y|0,l|0,g|0)|0;l=y;n=Ra(0,c[s>>2]|0,32)|0;p=y;j=Ra(0,c[u>>2]|0,32)|0;p=Qa(j|0,y|0,n|0,p|0)|0;n=y;j=Ra(0,c[h>>2]|0,32)|0;q=y;o=Ra(0,c[w>>2]|0,32)|0;q=Qa(o|0,y|0,j|0,q|0)|0;n=Ta(q|0,y|0,p|0,n|0)|0;n=Sa(n|0,y|0,1)|0;l=Ta(n|0,y|0,g|0,l|0)|0;g=y;n=Ra(0,c[b>>2]|0,32)|0;p=y;q=d+32|0;j=Ra(0,c[q>>2]|0,32)|0;p=Qa(j|0,y|0,n|0,p|0)|0;p=Ta(l|0,g|0,p|0,y|0)|0;g=y;l=b+32|0;n=Ra(0,c[l>>2]|0,32)|0;j=y;o=Ra(0,c[d>>2]|0,32)|0;j=Qa(o|0,y|0,n|0,j|0)|0;j=Ta(p|0,g|0,j|0,y|0)|0;g=a+32|0;c[g>>2]=j;c[g+4>>2]=y;g=Ra(0,c[r>>2]|0,32)|0;j=y;p=Ra(0,c[u>>2]|0,32)|0;j=Qa(p|0,y|0,g|0,j|0)|0;g=y;p=Ra(0,c[h>>2]|0,32)|0;n=y;o=Ra(0,c[v>>2]|0,32)|0;n=Qa(o|0,y|0,p|0,n|0)|0;g=Ta(n|0,y|0,j|0,g|0)|0;j=y;n=Ra(0,c[s>>2]|0,32)|0;p=y;o=Ra(0,c[q>>2]|0,32)|0;p=Qa(o|0,y|0,n|0,p|0)|0;p=Ta(g|0,j|0,p|0,y|0)|0;j=y;g=Ra(0,c[l>>2]|0,32)|0;n=y;o=Ra(0,c[w>>2]|0,32)|0;n=Qa(o|0,y|0,g|0,n|0)|0;n=Ta(p|0,j|0,n|0,y|0)|0;j=y;p=Ra(0,c[b>>2]|0,32)|0;g=y;o=d+40|0;t=Ra(0,c[o>>2]|0,32)|0;g=Qa(t|0,y|0,p|0,g|0)|0;g=Ta(n|0,j|0,g|0,y|0)|0;j=y;n=b+40|0;p=Ra(0,c[n>>2]|0,32)|0;t=y;k=Ra(0,c[d>>2]|0,32)|0;t=Qa(k|0,y|0,p|0,t|0)|0;t=Ta(g|0,j|0,t|0,y|0)|0;j=a+40|0;c[j>>2]=t;c[j+4>>2]=y;j=Ra(0,c[h>>2]|0,32)|0;t=y;g=Ra(0,c[u>>2]|0,32)|0;t=Qa(g|0,y|0,j|0,t|0)|0;j=y;g=Ra(0,c[s>>2]|0,32)|0;p=y;k=Ra(0,c[o>>2]|0,32)|0;p=Qa(k|0,y|0,g|0,p|0)|0;j=Ta(p|0,y|0,t|0,j|0)|0;t=y;p=Ra(0,c[n>>2]|0,32)|0;g=y;k=Ra(0,c[w>>2]|0,32)|0;g=Qa(k|0,y|0,p|0,g|0)|0;g=Ta(j|0,t|0,g|0,y|0)|0;g=Sa(g|0,y|0,1)|0;t=y;j=Ra(0,c[r>>2]|0,32)|0;p=y;k=Ra(0,c[q>>2]|0,32)|0;p=Qa(k|0,y|0,j|0,p|0)|0;p=Ta(g|0,t|0,p|0,y|0)|0;t=y;g=Ra(0,c[l>>2]|0,32)|0;j=y;k=Ra(0,c[v>>2]|0,32)|0;j=Qa(k|0,y|0,g|0,j|0)|0;j=Ta(p|0,t|0,j|0,y|0)|0;t=y;p=Ra(0,c[b>>2]|0,32)|0;g=y;k=d+48|0;x=Ra(0,c[k>>2]|0,32)|0;g=Qa(x|0,y|0,p|0,g|0)|0;g=Ta(j|0,t|0,g|0,y|0)|0;t=y;j=b+48|0;p=Ra(0,c[j>>2]|0,32)|0;x=y;m=Ra(0,c[d>>2]|0,32)|0;x=Qa(m|0,y|0,p|0,x|0)|0;x=Ta(g|0,t|0,x|0,y|0)|0;t=a+48|0;c[t>>2]=x;c[t+4>>2]=y;t=Ra(0,c[h>>2]|0,32)|0;x=y;g=Ra(0,c[q>>2]|0,32)|0;x=Qa(g|0,y|0,t|0,x|0)|0;t=y;g=Ra(0,c[l>>2]|0,32)|0;p=y;m=Ra(0,c[u>>2]|0,32)|0;p=Qa(m|0,y|0,g|0,p|0)|0;t=Ta(p|0,y|0,x|0,t|0)|0;x=y;p=Ra(0,c[r>>2]|0,32)|0;g=y;m=Ra(0,c[o>>2]|0,32)|0;g=Qa(m|0,y|0,p|0,g|0)|0;g=Ta(t|0,x|0,g|0,y|0)|0;x=y;t=Ra(0,c[n>>2]|0,32)|0;p=y;m=Ra(0,c[v>>2]|0,32)|0;p=Qa(m|0,y|0,t|0,p|0)|0;p=Ta(g|0,x|0,p|0,y|0)|0;x=y;g=Ra(0,c[s>>2]|0,32)|0;t=y;m=Ra(0,c[k>>2]|0,32)|0;t=Qa(m|0,y|0,g|0,t|0)|0;t=Ta(p|0,x|0,t|0,y|0)|0;x=y;p=Ra(0,c[j>>2]|0,32)|0;g=y;m=Ra(0,c[w>>2]|0,32)|0;g=Qa(m|0,y|0,p|0,g|0)|0;g=Ta(t|0,x|0,g|0,y|0)|0;x=y;t=Ra(0,c[b>>2]|0,32)|0;p=y;m=d+56|0;z=Ra(0,c[m>>2]|0,32)|0;p=Qa(z|0,y|0,t|0,p|0)|0;p=Ta(g|0,x|0,p|0,y|0)|0;x=y;g=b+56|0;t=Ra(0,c[g>>2]|0,32)|0;z=y;i=Ra(0,c[d>>2]|0,32)|0;z=Qa(i|0,y|0,t|0,z|0)|0;z=Ta(p|0,x|0,z|0,y|0)|0;x=a+56|0;c[x>>2]=z;c[x+4>>2]=y;x=Ra(0,c[l>>2]|0,32)|0;z=y;p=Ra(0,c[q>>2]|0,32)|0;z=Qa(p|0,y|0,x|0,z|0)|0;x=y;p=Ra(0,c[h>>2]|0,32)|0;t=y;i=Ra(0,c[o>>2]|0,32)|0;t=Qa(i|0,y|0,p|0,t|0)|0;p=y;i=Ra(0,c[n>>2]|0,32)|0;f=y;e=Ra(0,c[u>>2]|0,32)|0;f=Qa(e|0,y|0,i|0,f|0)|0;p=Ta(f|0,y|0,t|0,p|0)|0;t=y;f=Ra(0,c[s>>2]|0,32)|0;i=y;e=Ra(0,c[m>>2]|0,32)|0;i=Qa(e|0,y|0,f|0,i|0)|0;i=Ta(p|0,t|0,i|0,y|0)|0;t=y;p=Ra(0,c[g>>2]|0,32)|0;f=y;e=Ra(0,c[w>>2]|0,32)|0;f=Qa(e|0,y|0,p|0,f|0)|0;f=Ta(i|0,t|0,f|0,y|0)|0;f=Sa(f|0,y|0,1)|0;x=Ta(f|0,y|0,z|0,x|0)|0;z=y;f=Ra(0,c[r>>2]|0,32)|0;t=y;i=Ra(0,c[k>>2]|0,32)|0;t=Qa(i|0,y|0,f|0,t|0)|0;t=Ta(x|0,z|0,t|0,y|0)|0;z=y;x=Ra(0,c[j>>2]|0,32)|0;f=y;i=Ra(0,c[v>>2]|0,32)|0;f=Qa(i|0,y|0,x|0,f|0)|0;f=Ta(t|0,z|0,f|0,y|0)|0;z=y;t=Ra(0,c[b>>2]|0,32)|0;x=y;i=d+64|0;p=Ra(0,c[i>>2]|0,32)|0;x=Qa(p|0,y|0,t|0,x|0)|0;x=Ta(f|0,z|0,x|0,y|0)|0;z=y;f=b+64|0;t=Ra(0,c[f>>2]|0,32)|0;p=y;e=Ra(0,c[d>>2]|0,32)|0;p=Qa(e|0,y|0,t|0,p|0)|0;p=Ta(x|0,z|0,p|0,y|0)|0;z=a+64|0;c[z>>2]=p;c[z+4>>2]=y;z=Ra(0,c[l>>2]|0,32)|0;p=y;x=Ra(0,c[o>>2]|0,32)|0;p=Qa(x|0,y|0,z|0,p|0)|0;z=y;x=Ra(0,c[n>>2]|0,32)|0;t=y;e=Ra(0,c[q>>2]|0,32)|0;t=Qa(e|0,y|0,x|0,t|0)|0;z=Ta(t|0,y|0,p|0,z|0)|0;p=y;t=Ra(0,c[h>>2]|0,32)|0;x=y;e=Ra(0,c[k>>2]|0,32)|0;x=Qa(e|0,y|0,t|0,x|0)|0;x=Ta(z|0,p|0,x|0,y|0)|0;p=y;z=Ra(0,c[j>>2]|0,32)|0;t=y;e=Ra(0,c[u>>2]|0,32)|0;t=Qa(e|0,y|0,z|0,t|0)|0;t=Ta(x|0,p|0,t|0,y|0)|0;p=y;x=Ra(0,c[r>>2]|0,32)|0;z=y;e=Ra(0,c[m>>2]|0,32)|0;z=Qa(e|0,y|0,x|0,z|0)|0;z=Ta(t|0,p|0,z|0,y|0)|0;p=y;t=Ra(0,c[g>>2]|0,32)|0;x=y;e=Ra(0,c[v>>2]|0,32)|0;x=Qa(e|0,y|0,t|0,x|0)|0;x=Ta(z|0,p|0,x|0,y|0)|0;p=y;z=Ra(0,c[s>>2]|0,32)|0;t=y;e=Ra(0,c[i>>2]|0,32)|0;t=Qa(e|0,y|0,z|0,t|0)|0;t=Ta(x|0,p|0,t|0,y|0)|0;p=y;x=Ra(0,c[f>>2]|0,32)|0;z=y;e=Ra(0,c[w>>2]|0,32)|0;z=Qa(e|0,y|0,x|0,z|0)|0;z=Ta(t|0,p|0,z|0,y|0)|0;p=y;t=Ra(0,c[b>>2]|0,32)|0;x=y;e=d+72|0;A=Ra(0,c[e>>2]|0,32)|0;x=Qa(A|0,y|0,t|0,x|0)|0;x=Ta(z|0,p|0,x|0,y|0)|0;p=y;b=b+72|0;z=Ra(0,c[b>>2]|0,32)|0;t=y;d=Ra(0,c[d>>2]|0,32)|0;t=Qa(d|0,y|0,z|0,t|0)|0;t=Ta(x|0,p|0,t|0,y|0)|0;d=a+72|0;c[d>>2]=t;c[d+4>>2]=y;d=Ra(0,c[n>>2]|0,32)|0;t=y;p=Ra(0,c[o>>2]|0,32)|0;t=Qa(p|0,y|0,d|0,t|0)|0;d=y;p=Ra(0,c[h>>2]|0,32)|0;x=y;z=Ra(0,c[m>>2]|0,32)|0;x=Qa(z|0,y|0,p|0,x|0)|0;d=Ta(x|0,y|0,t|0,d|0)|0;t=y;x=Ra(0,c[g>>2]|0,32)|0;p=y;z=Ra(0,c[u>>2]|0,32)|0;p=Qa(z|0,y|0,x|0,p|0)|0;p=Ta(d|0,t|0,p|0,y|0)|0;t=y;d=Ra(0,c[s>>2]|0,32)|0;s=y;x=Ra(0,c[e>>2]|0,32)|0;s=Qa(x|0,y|0,d|0,s|0)|0;s=Ta(p|0,t|0,s|0,y|0)|0;t=y;p=Ra(0,c[b>>2]|0,32)|0;d=y;w=Ra(0,c[w>>2]|0,32)|0;d=Qa(w|0,y|0,p|0,d|0)|0;d=Ta(s|0,t|0,d|0,y|0)|0;d=Sa(d|0,y|0,1)|0;t=y;s=Ra(0,c[l>>2]|0,32)|0;p=y;w=Ra(0,c[k>>2]|0,32)|0;p=Qa(w|0,y|0,s|0,p|0)|0;p=Ta(d|0,t|0,p|0,y|0)|0;t=y;d=Ra(0,c[j>>2]|0,32)|0;s=y;w=Ra(0,c[q>>2]|0,32)|0;s=Qa(w|0,y|0,d|0,s|0)|0;s=Ta(p|0,t|0,s|0,y|0)|0;t=y;p=Ra(0,c[r>>2]|0,32)|0;d=y;w=Ra(0,c[i>>2]|0,32)|0;d=Qa(w|0,y|0,p|0,d|0)|0;d=Ta(s|0,t|0,d|0,y|0)|0;t=y;s=Ra(0,c[f>>2]|0,32)|0;p=y;w=Ra(0,c[v>>2]|0,32)|0;p=Qa(w|0,y|0,s|0,p|0)|0;p=Ta(d|0,t|0,p|0,y|0)|0;t=a+80|0;c[t>>2]=p;c[t+4>>2]=y;t=Ra(0,c[n>>2]|0,32)|0;p=y;d=Ra(0,c[k>>2]|0,32)|0;p=Qa(d|0,y|0,t|0,p|0)|0;t=y;d=Ra(0,c[j>>2]|0,32)|0;s=y;w=Ra(0,c[o>>2]|0,32)|0;s=Qa(w|0,y|0,d|0,s|0)|0;t=Ta(s|0,y|0,p|0,t|0)|0;p=y;s=Ra(0,c[l>>2]|0,32)|0;d=y;w=Ra(0,c[m>>2]|0,32)|0;d=Qa(w|0,y|0,s|0,d|0)|0;d=Ta(t|0,p|0,d|0,y|0)|0;p=y;t=Ra(0,c[g>>2]|0,32)|0;s=y;w=Ra(0,c[q>>2]|0,32)|0;s=Qa(w|0,y|0,t|0,s|0)|0;s=Ta(d|0,p|0,s|0,y|0)|0;p=y;d=Ra(0,c[h>>2]|0,32)|0;t=y;w=Ra(0,c[i>>2]|0,32)|0;t=Qa(w|0,y|0,d|0,t|0)|0;t=Ta(s|0,p|0,t|0,y|0)|0;p=y;s=Ra(0,c[f>>2]|0,32)|0;d=y;w=Ra(0,c[u>>2]|0,32)|0;d=Qa(w|0,y|0,s|0,d|0)|0;d=Ta(t|0,p|0,d|0,y|0)|0;p=y;r=Ra(0,c[r>>2]|0,32)|0;t=y;s=Ra(0,c[e>>2]|0,32)|0;t=Qa(s|0,y|0,r|0,t|0)|0;t=Ta(d|0,p|0,t|0,y|0)|0;p=y;d=Ra(0,c[b>>2]|0,32)|0;r=y;v=Ra(0,c[v>>2]|0,32)|0;r=Qa(v|0,y|0,d|0,r|0)|0;r=Ta(t|0,p|0,r|0,y|0)|0;p=a+88|0;c[p>>2]=r;c[p+4>>2]=y;p=Ra(0,c[j>>2]|0,32)|0;r=y;t=Ra(0,c[k>>2]|0,32)|0;r=Qa(t|0,y|0,p|0,r|0)|0;p=y;t=Ra(0,c[n>>2]|0,32)|0;d=y;v=Ra(0,c[m>>2]|0,32)|0;d=Qa(v|0,y|0,t|0,d|0)|0;t=y;v=Ra(0,c[g>>2]|0,32)|0;s=y;w=Ra(0,c[o>>2]|0,32)|0;s=Qa(w|0,y|0,v|0,s|0)|0;t=Ta(s|0,y|0,d|0,t|0)|0;d=y;h=Ra(0,c[h>>2]|0,32)|0;s=y;v=Ra(0,c[e>>2]|0,32)|0;s=Qa(v|0,y|0,h|0,s|0)|0;s=Ta(t|0,d|0,s|0,y|0)|0;d=y;t=Ra(0,c[b>>2]|0,32)|0;h=y;u=Ra(0,c[u>>2]|0,32)|0;h=Qa(u|0,y|0,t|0,h|0)|0;h=Ta(s|0,d|0,h|0,y|0)|0;h=Sa(h|0,y|0,1)|0;p=Ta(h|0,y|0,r|0,p|0)|0;r=y;h=Ra(0,c[l>>2]|0,32)|0;d=y;s=Ra(0,c[i>>2]|0,32)|0;d=Qa(s|0,y|0,h|0,d|0)|0;d=Ta(p|0,r|0,d|0,y|0)|0;r=y;p=Ra(0,c[f>>2]|0,32)|0;h=y;s=Ra(0,c[q>>2]|0,32)|0;h=Qa(s|0,y|0,p|0,h|0)|0;h=Ta(d|0,r|0,h|0,y|0)|0;r=a+96|0;c[r>>2]=h;c[r+4>>2]=y;r=Ra(0,c[j>>2]|0,32)|0;h=y;d=Ra(0,c[m>>2]|0,32)|0;h=Qa(d|0,y|0,r|0,h|0)|0;r=y;d=Ra(0,c[g>>2]|0,32)|0;p=y;s=Ra(0,c[k>>2]|0,32)|0;p=Qa(s|0,y|0,d|0,p|0)|0;r=Ta(p|0,y|0,h|0,r|0)|0;h=y;p=Ra(0,c[n>>2]|0,32)|0;d=y;s=Ra(0,c[i>>2]|0,32)|0;d=Qa(s|0,y|0,p|0,d|0)|0;d=Ta(r|0,h|0,d|0,y|0)|0;h=y;r=Ra(0,c[f>>2]|0,32)|0;p=y;s=Ra(0,c[o>>2]|0,32)|0;p=Qa(s|0,y|0,r|0,p|0)|0;p=Ta(d|0,h|0,p|0,y|0)|0;h=y;l=Ra(0,c[l>>2]|0,32)|0;d=y;r=Ra(0,c[e>>2]|0,32)|0;d=Qa(r|0,y|0,l|0,d|0)|0;d=Ta(p|0,h|0,d|0,y|0)|0;h=y;p=Ra(0,c[b>>2]|0,32)|0;l=y;q=Ra(0,c[q>>2]|0,32)|0;l=Qa(q|0,y|0,p|0,l|0)|0;l=Ta(d|0,h|0,l|0,y|0)|0;h=a+104|0;c[h>>2]=l;c[h+4>>2]=y;h=Ra(0,c[g>>2]|0,32)|0;l=y;d=Ra(0,c[m>>2]|0,32)|0;l=Qa(d|0,y|0,h|0,l|0)|0;h=y;d=Ra(0,c[n>>2]|0,32)|0;n=y;p=Ra(0,c[e>>2]|0,32)|0;n=Qa(p|0,y|0,d|0,n|0)|0;h=Ta(n|0,y|0,l|0,h|0)|0;l=y;n=Ra(0,c[b>>2]|0,32)|0;d=y;o=Ra(0,c[o>>2]|0,32)|0;d=Qa(o|0,y|0,n|0,d|0)|0;d=Ta(h|0,l|0,d|0,y|0)|0;d=Sa(d|0,y|0,1)|0;l=y;h=Ra(0,c[j>>2]|0,32)|0;n=y;o=Ra(0,c[i>>2]|0,32)|0;n=Qa(o|0,y|0,h|0,n|0)|0;n=Ta(d|0,l|0,n|0,y|0)|0;l=y;d=Ra(0,c[f>>2]|0,32)|0;h=y;o=Ra(0,c[k>>2]|0,32)|0;h=Qa(o|0,y|0,d|0,h|0)|0;h=Ta(n|0,l|0,h|0,y|0)|0;l=a+112|0;c[l>>2]=h;c[l+4>>2]=y;l=Ra(0,c[g>>2]|0,32)|0;h=y;n=Ra(0,c[i>>2]|0,32)|0;h=Qa(n|0,y|0,l|0,h|0)|0;l=y;n=Ra(0,c[f>>2]|0,32)|0;d=y;o=Ra(0,c[m>>2]|0,32)|0;d=Qa(o|0,y|0,n|0,d|0)|0;l=Ta(d|0,y|0,h|0,l|0)|0;h=y;d=Ra(0,c[j>>2]|0,32)|0;j=y;n=Ra(0,c[e>>2]|0,32)|0;j=Qa(n|0,y|0,d|0,j|0)|0;j=Ta(l|0,h|0,j|0,y|0)|0;h=y;l=Ra(0,c[b>>2]|0,32)|0;d=y;k=Ra(0,c[k>>2]|0,32)|0;d=Qa(k|0,y|0,l|0,d|0)|0;d=Ta(j|0,h|0,d|0,y|0)|0;h=a+120|0;c[h>>2]=d;c[h+4>>2]=y;h=Ra(0,c[f>>2]|0,32)|0;d=y;j=Ra(0,c[i>>2]|0,32)|0;d=Qa(j|0,y|0,h|0,d|0)|0;h=y;g=Ra(0,c[g>>2]|0,32)|0;j=y;l=Ra(0,c[e>>2]|0,32)|0;j=Qa(l|0,y|0,g|0,j|0)|0;g=y;l=Ra(0,c[b>>2]|0,32)|0;k=y;m=Ra(0,c[m>>2]|0,32)|0;k=Qa(m|0,y|0,l|0,k|0)|0;g=Ta(k|0,y|0,j|0,g|0)|0;g=Sa(g|0,y|0,1)|0;h=Ta(g|0,y|0,d|0,h|0)|0;d=a+128|0;c[d>>2]=h;c[d+4>>2]=y;f=Ra(0,c[f>>2]|0,32)|0;d=y;h=Ra(0,c[e>>2]|0,32)|0;d=Qa(h|0,y|0,f|0,d|0)|0;f=y;h=Ra(0,c[b>>2]|0,32)|0;g=y;i=Ra(0,c[i>>2]|0,32)|0;g=Qa(i|0,y|0,h|0,g|0)|0;f=Ta(g|0,y|0,d|0,f|0)|0;d=a+136|0;c[d>>2]=f;c[d+4>>2]=y;d=Ra(0,c[b>>2]|0,31)|0;b=y;e=Ra(0,c[e>>2]|0,32)|0;b=Qa(e|0,y|0,d|0,b|0)|0;d=a+144|0;c[d>>2]=b;c[d+4>>2]=y;return}function ua(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=a+80|0;d=f;c[d>>2]=0;c[d+4>>2]=0;d=a;e=c[d>>2]|0;d=c[d+4>>2]|0;i=Ta(d>>31>>>6|0,0,e|0,d|0)|0;i=Ra(i|0,y|0,26)|0;g=y;b=Sa(i|0,g|0,26)|0;b=Ua(e|0,d|0,b|0,y|0)|0;d=a;c[d>>2]=b;c[d+4>>2]=y;d=a+8|0;b=d;b=Ta(i|0,g|0,c[b>>2]|0,c[b+4>>2]|0)|0;g=y;i=Ta(g>>31>>>7|0,0,b|0,g|0)|0;i=Ra(i|0,y|0,25)|0;e=y;j=Sa(i|0,e|0,25)|0;j=Ua(b|0,g|0,j|0,y|0)|0;g=d;c[g>>2]=j;c[g+4>>2]=y;g=a+16|0;j=g;j=Ta(i|0,e|0,c[j>>2]|0,c[j+4>>2]|0)|0;e=y;i=Ta(e>>31>>>6|0,0,j|0,e|0)|0;i=Ra(i|0,y|0,26)|0;b=y;h=Sa(i|0,b|0,26)|0;h=Ua(j|0,e|0,h|0,y|0)|0;c[g>>2]=h;c[g+4>>2]=y;g=a+24|0;h=g;h=Ta(i|0,b|0,c[h>>2]|0,c[h+4>>2]|0)|0;b=y;i=Ta(b>>31>>>7|0,0,h|0,b|0)|0;i=Ra(i|0,y|0,25)|0;e=y;j=Sa(i|0,e|0,25)|0;j=Ua(h|0,b|0,j|0,y|0)|0;c[g>>2]=j;c[g+4>>2]=y;g=a+32|0;j=g;j=Ta(i|0,e|0,c[j>>2]|0,c[j+4>>2]|0)|0;e=y;i=Ta(e>>31>>>6|0,0,j|0,e|0)|0;i=Ra(i|0,y|0,26)|0;b=y;h=Sa(i|0,b|0,26)|0;h=Ua(j|0,e|0,h|0,y|0)|0;c[g>>2]=h;c[g+4>>2]=y;g=a+40|0;h=g;h=Ta(i|0,b|0,c[h>>2]|0,c[h+4>>2]|0)|0;b=y;i=Ta(b>>31>>>7|0,0,h|0,b|0)|0;i=Ra(i|0,y|0,25)|0;e=y;j=Sa(i|0,e|0,25)|0;j=Ua(h|0,b|0,j|0,y|0)|0;c[g>>2]=j;c[g+4>>2]=y;g=a+48|0;j=g;j=Ta(i|0,e|0,c[j>>2]|0,c[j+4>>2]|0)|0;e=y;i=Ta(e>>31>>>6|0,0,j|0,e|0)|0;i=Ra(i|0,y|0,26)|0;b=y;h=Sa(i|0,b|0,26)|0;h=Ua(j|0,e|0,h|0,y|0)|0;c[g>>2]=h;c[g+4>>2]=y;g=a+56|0;h=g;h=Ta(i|0,b|0,c[h>>2]|0,c[h+4>>2]|0)|0;b=y;i=Ta(b>>31>>>7|0,0,h|0,b|0)|0;i=Ra(i|0,y|0,25)|0;e=y;j=Sa(i|0,e|0,25)|0;j=Ua(h|0,b|0,j|0,y|0)|0;c[g>>2]=j;c[g+4>>2]=y;g=a+64|0;j=g;j=Ta(i|0,e|0,c[j>>2]|0,c[j+4>>2]|0)|0;e=y;i=Ta(e>>31>>>6|0,0,j|0,e|0)|0;i=Ra(i|0,y|0,26)|0;b=y;h=Sa(i|0,b|0,26)|0;h=Ua(j|0,e|0,h|0,y|0)|0;c[g>>2]=h;c[g+4>>2]=y;g=a+72|0;h=g;h=Ta(i|0,b|0,c[h>>2]|0,c[h+4>>2]|0)|0;b=y;i=Ta(b>>31>>>7|0,0,h|0,b|0)|0;i=Ra(i|0,y|0,25)|0;e=y;j=Sa(i|0,e|0,25)|0;j=Ua(h|0,b|0,j|0,y|0)|0;c[g>>2]=j;c[g+4>>2]=y;g=f;g=Ta(i|0,e|0,c[g>>2]|0,c[g+4>>2]|0)|0;e=y;i=a;j=c[i>>2]|0;i=c[i+4>>2]|0;b=Qa(g|0,e|0,18,0)|0;h=y;e=Ta(j|0,i|0,g|0,e|0)|0;h=Ta(e|0,y|0,b|0,h|0)|0;b=y;c[f>>2]=0;c[f+4>>2]=0;f=Ta(b>>31>>>6|0,0,h|0,b|0)|0;f=Ra(f|0,y|0,26)|0;e=y;g=Sa(f|0,e|0,26)|0;g=Ua(h|0,b|0,g|0,y|0)|0;b=a;c[b>>2]=g;c[b+4>>2]=y;b=d;b=Ta(f|0,e|0,c[b>>2]|0,c[b+4>>2]|0)|0;a=d;c[a>>2]=b;c[a+4>>2]=y;return}function va(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0;e=l;l=l+160|0;d=e;u=c[b>>2]|0;R=Ra(0,u|0,32)|0;N=y;A=Qa(R|0,N|0,R|0,N|0)|0;E=d;c[E>>2]=A;c[E+4>>2]=y;u=Ra(0,u|0,31)|0;E=y;A=b+8|0;F=c[A>>2]|0;g=Ra(0,F|0,32)|0;x=y;z=Qa(g|0,x|0,u|0,E|0)|0;h=d+8|0;k=h;c[k>>2]=z;c[k+4>>2]=y;k=Qa(g|0,x|0,g|0,x|0)|0;z=y;i=b+16|0;f=Ra(0,c[i>>2]|0,32)|0;H=y;q=Qa(f|0,H|0,R|0,N|0)|0;z=Ta(q|0,y|0,k|0,z|0)|0;z=Sa(z|0,y|0,1)|0;k=d+16|0;q=k;c[q>>2]=z;c[q+4>>2]=y;q=Qa(f|0,H|0,g|0,x|0)|0;z=y;G=b+24|0;P=Ra(0,c[G>>2]|0,32)|0;Q=y;t=Qa(P|0,Q|0,R|0,N|0)|0;z=Ta(t|0,y|0,q|0,z|0)|0;z=Sa(z|0,y|0,1)|0;q=d+24|0;t=q;c[t>>2]=z;c[t+4>>2]=y;t=Qa(f|0,H|0,f|0,H|0)|0;z=y;m=Ra(0,F|0,30)|0;m=Qa(P|0,Q|0,m|0,y|0)|0;z=Ta(m|0,y|0,t|0,z|0)|0;t=y;m=b+32|0;D=Ra(0,c[m>>2]|0,32)|0;r=y;E=Qa(D|0,r|0,u|0,E|0)|0;E=Ta(z|0,t|0,E|0,y|0)|0;t=d+32|0;z=t;c[z>>2]=E;c[z+4>>2]=y;z=Qa(P|0,Q|0,f|0,H|0)|0;E=y;u=Qa(D|0,r|0,g|0,x|0)|0;E=Ta(u|0,y|0,z|0,E|0)|0;z=y;u=b+40|0;v=Ra(0,c[u>>2]|0,32)|0;j=y;M=Qa(v|0,j|0,R|0,N|0)|0;M=Ta(E|0,z|0,M|0,y|0)|0;M=Sa(M|0,y|0,1)|0;z=d+40|0;E=z;c[E>>2]=M;c[E+4>>2]=y;E=Qa(P|0,Q|0,P|0,Q|0)|0;M=y;C=Qa(D|0,r|0,f|0,H|0)|0;M=Ta(C|0,y|0,E|0,M|0)|0;E=y;C=b+48|0;p=Ra(0,c[C>>2]|0,32)|0;o=y;J=Qa(p|0,o|0,R|0,N|0)|0;J=Ta(M|0,E|0,J|0,y|0)|0;E=y;F=Ra(0,F|0,31)|0;F=Qa(v|0,j|0,F|0,y|0)|0;F=Ta(J|0,E|0,F|0,y|0)|0;F=Sa(F|0,y|0,1)|0;E=d+48|0;J=E;c[J>>2]=F;c[J+4>>2]=y;J=Qa(D|0,r|0,P|0,Q|0)|0;F=y;M=Qa(v|0,j|0,f|0,H|0)|0;F=Ta(M|0,y|0,J|0,F|0)|0;J=y;M=Qa(p|0,o|0,g|0,x|0)|0;M=Ta(F|0,J|0,M|0,y|0)|0;J=y;F=b+56|0;s=Ra(0,c[F>>2]|0,32)|0;n=y;B=Qa(s|0,n|0,R|0,N|0)|0;B=Ta(M|0,J|0,B|0,y|0)|0;B=Sa(B|0,y|0,1)|0;J=d+56|0;M=J;c[M>>2]=B;c[M+4>>2]=y;M=Qa(D|0,r|0,D|0,r|0)|0;B=y;K=Qa(p|0,o|0,f|0,H|0)|0;O=y;L=b+64|0;I=Ra(0,c[L>>2]|0,32)|0;w=y;N=Qa(I|0,w|0,R|0,N|0)|0;O=Ta(N|0,y|0,K|0,O|0)|0;K=y;x=Qa(s|0,n|0,g|0,x|0)|0;g=y;N=Qa(v|0,j|0,P|0,Q|0)|0;g=Ta(N|0,y|0,x|0,g|0)|0;g=Sa(g|0,y|0,1)|0;g=Ta(O|0,K|0,g|0,y|0)|0;g=Sa(g|0,y|0,1)|0;B=Ta(g|0,y|0,M|0,B|0)|0;M=d+64|0;g=M;c[g>>2]=B;c[g+4>>2]=y;g=Qa(v|0,j|0,D|0,r|0)|0;B=y;Q=Qa(p|0,o|0,P|0,Q|0)|0;B=Ta(Q|0,y|0,g|0,B|0)|0;g=y;H=Qa(s|0,n|0,f|0,H|0)|0;H=Ta(B|0,g|0,H|0,y|0)|0;g=y;A=Ra(0,c[A>>2]|0,32)|0;B=y;f=Qa(I|0,w|0,A|0,B|0)|0;f=Ta(H|0,g|0,f|0,y|0)|0;g=y;H=Ra(0,c[b>>2]|0,32)|0;Q=y;P=c[b+72>>2]|0;K=Ra(0,P|0,32)|0;O=y;Q=Qa(K|0,O|0,H|0,Q|0)|0;Q=Ta(f|0,g|0,Q|0,y|0)|0;Q=Sa(Q|0,y|0,1)|0;g=d+72|0;c[g>>2]=Q;c[g+4>>2]=y;g=Qa(v|0,j|0,v|0,j|0)|0;Q=y;b=Qa(p|0,o|0,D|0,r|0)|0;Q=Ta(b|0,y|0,g|0,Q|0)|0;g=y;b=Ra(0,c[i>>2]|0,32)|0;i=y;r=Qa(I|0,w|0,b|0,i|0)|0;r=Ta(Q|0,g|0,r|0,y|0)|0;g=y;G=Ra(0,c[G>>2]|0,32)|0;Q=y;D=Qa(s|0,n|0,G|0,Q|0)|0;f=y;B=Qa(K|0,O|0,A|0,B|0)|0;f=Ta(B|0,y|0,D|0,f|0)|0;f=Sa(f|0,y|0,1)|0;f=Ta(r|0,g|0,f|0,y|0)|0;f=Sa(f|0,y|0,1)|0;g=d+80|0;r=g;c[r>>2]=f;c[r+4>>2]=y;j=Qa(p|0,o|0,v|0,j|0)|0;v=y;m=Ra(0,c[m>>2]|0,32)|0;r=y;f=Qa(s|0,n|0,m|0,r|0)|0;v=Ta(f|0,y|0,j|0,v|0)|0;j=y;f=Qa(I|0,w|0,G|0,Q|0)|0;f=Ta(v|0,j|0,f|0,y|0)|0;j=y;i=Qa(K|0,O|0,b|0,i|0)|0;i=Ta(f|0,j|0,i|0,y|0)|0;j=y;f=Sa(i|0,j|0,1)|0;b=y;v=d+88|0;c[v>>2]=f;c[v+4>>2]=b;o=Qa(p|0,o|0,p|0,o|0)|0;p=y;v=Qa(I|0,w|0,m|0,r|0)|0;D=y;u=c[u>>2]|0;B=Ra(0,u|0,32)|0;A=y;H=Qa(s|0,n|0,B|0,A|0)|0;x=y;Q=Qa(K|0,O|0,G|0,Q|0)|0;x=Ta(Q|0,y|0,H|0,x|0)|0;x=Sa(x|0,y|0,1)|0;D=Ta(x|0,y|0,v|0,D|0)|0;D=Sa(D|0,y|0,1)|0;p=Ta(D|0,y|0,o|0,p|0)|0;o=y;D=d+96|0;c[D>>2]=p;c[D+4>>2]=o;C=Ra(0,c[C>>2]|0,32)|0;D=y;n=Qa(s|0,n|0,C|0,D|0)|0;s=y;A=Qa(I|0,w|0,B|0,A|0)|0;s=Ta(A|0,y|0,n|0,s|0)|0;n=y;r=Qa(K|0,O|0,m|0,r|0)|0;r=Ta(s|0,n|0,r|0,y|0)|0;n=y;s=Sa(r|0,n|0,1)|0;m=y;A=d+104|0;c[A>>2]=s;c[A+4>>2]=m;F=c[F>>2]|0;A=Ra(0,F|0,32)|0;B=y;v=Qa(A|0,B|0,A|0,B|0)|0;x=y;w=Qa(I|0,w|0,C|0,D|0)|0;x=Ta(w|0,y|0,v|0,x|0)|0;v=y;u=Ra(0,u|0,31)|0;u=Qa(K|0,O|0,u|0,y|0)|0;u=Ta(x|0,v|0,u|0,y|0)|0;v=y;x=Sa(u|0,v|0,1)|0;w=y;I=d+112|0;c[I>>2]=x;c[I+4>>2]=w;L=c[L>>2]|0;I=Ra(0,L|0,32)|0;H=y;B=Qa(I|0,H|0,A|0,B|0)|0;A=y;D=Qa(K|0,O|0,C|0,D|0)|0;A=Ta(D|0,y|0,B|0,A|0)|0;B=y;D=Sa(A|0,B|0,1)|0;C=y;Q=d+120|0;c[Q>>2]=D;c[Q+4>>2]=C;H=Qa(I|0,H|0,I|0,H|0)|0;I=y;F=Ra(0,F|0,30)|0;F=Qa(K|0,O|0,F|0,y|0)|0;I=Ta(F|0,y|0,H|0,I|0)|0;H=y;F=d+128|0;c[F>>2]=I;c[F+4>>2]=H;L=Ra(0,L|0,31)|0;L=Qa(K|0,O|0,L|0,y|0)|0;F=y;Q=d+136|0;c[Q>>2]=L;c[Q+4>>2]=F;P=Ra(0,P|0,31)|0;O=Qa(P|0,y|0,K|0,O|0)|0;K=y;P=d+144|0;c[P>>2]=O;c[P+4>>2]=K;P=M;Q=c[P>>2]|0;P=c[P+4>>2]|0;G=Qa(O|0,K|0,18,0)|0;N=y;K=Ta(Q|0,P|0,O|0,K|0)|0;N=Ta(K|0,y|0,G|0,N|0)|0;c[M>>2]=N;c[M+4>>2]=y;M=J;N=c[M>>2]|0;M=c[M+4>>2]|0;G=Qa(L|0,F|0,18,0)|0;K=y;F=Ta(N|0,M|0,L|0,F|0)|0;K=Ta(F|0,y|0,G|0,K|0)|0;c[J>>2]=K;c[J+4>>2]=y;J=E;K=c[J>>2]|0;J=c[J+4>>2]|0;G=Qa(I|0,H|0,18,0)|0;F=y;H=Ta(K|0,J|0,I|0,H|0)|0;F=Ta(H|0,y|0,G|0,F|0)|0;c[E>>2]=F;c[E+4>>2]=y;E=z;F=c[E>>2]|0;E=c[E+4>>2]|0;B=Qa(A|0,B|0,36,0)|0;A=y;C=Ta(F|0,E|0,D|0,C|0)|0;A=Ta(C|0,y|0,B|0,A|0)|0;c[z>>2]=A;c[z+4>>2]=y;z=t;A=c[z>>2]|0;z=c[z+4>>2]|0;v=Qa(u|0,v|0,36,0)|0;u=y;w=Ta(A|0,z|0,x|0,w|0)|0;u=Ta(w|0,y|0,v|0,u|0)|0;c[t>>2]=u;c[t+4>>2]=y;t=q;u=c[t>>2]|0;t=c[t+4>>2]|0;n=Qa(r|0,n|0,36,0)|0;r=y;m=Ta(u|0,t|0,s|0,m|0)|0;r=Ta(m|0,y|0,n|0,r|0)|0;c[q>>2]=r;c[q+4>>2]=y;q=k;r=c[q>>2]|0;q=c[q+4>>2]|0;n=Qa(p|0,o|0,18,0)|0;m=y;o=Ta(r|0,q|0,p|0,o|0)|0;m=Ta(o|0,y|0,n|0,m|0)|0;c[k>>2]=m;c[k+4>>2]=y;k=h;m=c[k>>2]|0;k=c[k+4>>2]|0;j=Qa(i|0,j|0,36,0)|0;i=y;b=Ta(m|0,k|0,f|0,b|0)|0;i=Ta(b|0,y|0,j|0,i|0)|0;c[h>>2]=i;c[h+4>>2]=y;h=c[g>>2]|0;g=c[g+4>>2]|0;i=d;j=c[i>>2]|0;i=c[i+4>>2]|0;b=Qa(h|0,g|0,18,0)|0;f=y;g=Ta(j|0,i|0,h|0,g|0)|0;f=Ta(g|0,y|0,b|0,f|0)|0;b=d;c[b>>2]=f;c[b+4>>2]=y;ua(d);b=d;d=a+80|0;do{c[a>>2]=c[b>>2];a=a+4|0;b=b+4|0}while((a|0)<(d|0));l=e;return}function wa(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=l;l=l+16|0;o=x;do if(a>>>0<245){k=a>>>0<11?16:a+11&-8;a=k>>>3;n=c[146]|0;d=n>>>a;if(d&3|0){b=(d&1^1)+a|0;a=624+(b<<1<<2)|0;d=a+8|0;e=c[d>>2]|0;f=e+8|0;g=c[f>>2]|0;if((a|0)==(g|0))c[146]=n&~(1<<b);else{c[g+12>>2]=a;c[d>>2]=g}w=b<<3;c[e+4>>2]=w|3;w=e+w+4|0;c[w>>2]=c[w>>2]|1;w=f;l=x;return w|0}m=c[148]|0;if(k>>>0>m>>>0){if(d|0){b=2<<a;b=d<<a&(b|0-b);b=(b&0-b)+-1|0;h=b>>>12&16;b=b>>>h;d=b>>>5&8;b=b>>>d;f=b>>>2&4;b=b>>>f;a=b>>>1&2;b=b>>>a;e=b>>>1&1;e=(d|h|f|a|e)+(b>>>e)|0;b=624+(e<<1<<2)|0;a=b+8|0;f=c[a>>2]|0;h=f+8|0;d=c[h>>2]|0;if((b|0)==(d|0)){a=n&~(1<<e);c[146]=a}else{c[d+12>>2]=b;c[a>>2]=d;a=n}g=(e<<3)-k|0;c[f+4>>2]=k|3;e=f+k|0;c[e+4>>2]=g|1;c[e+g>>2]=g;if(m|0){f=c[151]|0;b=m>>>3;d=624+(b<<1<<2)|0;b=1<<b;if(!(a&b)){c[146]=a|b;b=d;a=d+8|0}else{a=d+8|0;b=c[a>>2]|0}c[a>>2]=f;c[b+12>>2]=f;c[f+8>>2]=b;c[f+12>>2]=d}c[148]=g;c[151]=e;w=h;l=x;return w|0}i=c[147]|0;if(i){d=(i&0-i)+-1|0;h=d>>>12&16;d=d>>>h;g=d>>>5&8;d=d>>>g;j=d>>>2&4;d=d>>>j;e=d>>>1&2;d=d>>>e;a=d>>>1&1;a=c[888+((g|h|j|e|a)+(d>>>a)<<2)>>2]|0;d=(c[a+4>>2]&-8)-k|0;e=c[a+16+(((c[a+16>>2]|0)==0&1)<<2)>>2]|0;if(!e){j=a;g=d}else{do{h=(c[e+4>>2]&-8)-k|0;j=h>>>0<d>>>0;d=j?h:d;a=j?e:a;e=c[e+16+(((c[e+16>>2]|0)==0&1)<<2)>>2]|0}while((e|0)!=0);j=a;g=d}h=j+k|0;if(j>>>0<h>>>0){f=c[j+24>>2]|0;b=c[j+12>>2]|0;do if((b|0)==(j|0)){a=j+20|0;b=c[a>>2]|0;if(!b){a=j+16|0;b=c[a>>2]|0;if(!b){d=0;break}}while(1){d=b+20|0;e=c[d>>2]|0;if(e|0){b=e;a=d;continue}d=b+16|0;e=c[d>>2]|0;if(!e)break;else{b=e;a=d}}c[a>>2]=0;d=b}else{d=c[j+8>>2]|0;c[d+12>>2]=b;c[b+8>>2]=d;d=b}while(0);do if(f|0){b=c[j+28>>2]|0;a=888+(b<<2)|0;if((j|0)==(c[a>>2]|0)){c[a>>2]=d;if(!d){c[147]=i&~(1<<b);break}}else{c[f+16+(((c[f+16>>2]|0)!=(j|0)&1)<<2)>>2]=d;if(!d)break}c[d+24>>2]=f;b=c[j+16>>2]|0;if(b|0){c[d+16>>2]=b;c[b+24>>2]=d}b=c[j+20>>2]|0;if(b|0){c[d+20>>2]=b;c[b+24>>2]=d}}while(0);if(g>>>0<16){w=g+k|0;c[j+4>>2]=w|3;w=j+w+4|0;c[w>>2]=c[w>>2]|1}else{c[j+4>>2]=k|3;c[h+4>>2]=g|1;c[h+g>>2]=g;if(m|0){e=c[151]|0;b=m>>>3;d=624+(b<<1<<2)|0;b=1<<b;if(!(n&b)){c[146]=n|b;b=d;a=d+8|0}else{a=d+8|0;b=c[a>>2]|0}c[a>>2]=e;c[b+12>>2]=e;c[e+8>>2]=b;c[e+12>>2]=d}c[148]=g;c[151]=h}w=j+8|0;l=x;return w|0}else n=k}else n=k}else n=k}else if(a>>>0<=4294967231){a=a+11|0;k=a&-8;j=c[147]|0;if(j){e=0-k|0;a=a>>>8;if(a)if(k>>>0>16777215)i=31;else{n=(a+1048320|0)>>>16&8;v=a<<n;m=(v+520192|0)>>>16&4;v=v<<m;i=(v+245760|0)>>>16&2;i=14-(m|n|i)+(v<<i>>>15)|0;i=k>>>(i+7|0)&1|i<<1}else i=0;d=c[888+(i<<2)>>2]|0;a:do if(!d){d=0;a=0;v=57}else{a=0;h=k<<((i|0)==31?0:25-(i>>>1)|0);g=0;while(1){f=(c[d+4>>2]&-8)-k|0;if(f>>>0<e>>>0)if(!f){a=d;e=0;f=d;v=61;break a}else{a=d;e=f}f=c[d+20>>2]|0;d=c[d+16+(h>>>31<<2)>>2]|0;g=(f|0)==0|(f|0)==(d|0)?g:f;f=(d|0)==0;if(f){d=g;v=57;break}else h=h<<((f^1)&1)}}while(0);if((v|0)==57){if((d|0)==0&(a|0)==0){a=2<<i;a=j&(a|0-a);if(!a){n=k;break}n=(a&0-a)+-1|0;h=n>>>12&16;n=n>>>h;g=n>>>5&8;n=n>>>g;i=n>>>2&4;n=n>>>i;m=n>>>1&2;n=n>>>m;d=n>>>1&1;a=0;d=c[888+((g|h|i|m|d)+(n>>>d)<<2)>>2]|0}if(!d){i=a;h=e}else{f=d;v=61}}if((v|0)==61)while(1){v=0;d=(c[f+4>>2]&-8)-k|0;n=d>>>0<e>>>0;d=n?d:e;a=n?f:a;f=c[f+16+(((c[f+16>>2]|0)==0&1)<<2)>>2]|0;if(!f){i=a;h=d;break}else{e=d;v=61}}if((i|0)!=0?h>>>0<((c[148]|0)-k|0)>>>0:0){g=i+k|0;if(i>>>0>=g>>>0){w=0;l=x;return w|0}f=c[i+24>>2]|0;b=c[i+12>>2]|0;do if((b|0)==(i|0)){a=i+20|0;b=c[a>>2]|0;if(!b){a=i+16|0;b=c[a>>2]|0;if(!b){b=0;break}}while(1){d=b+20|0;e=c[d>>2]|0;if(e|0){b=e;a=d;continue}d=b+16|0;e=c[d>>2]|0;if(!e)break;else{b=e;a=d}}c[a>>2]=0}else{w=c[i+8>>2]|0;c[w+12>>2]=b;c[b+8>>2]=w}while(0);do if(f){a=c[i+28>>2]|0;d=888+(a<<2)|0;if((i|0)==(c[d>>2]|0)){c[d>>2]=b;if(!b){e=j&~(1<<a);c[147]=e;break}}else{c[f+16+(((c[f+16>>2]|0)!=(i|0)&1)<<2)>>2]=b;if(!b){e=j;break}}c[b+24>>2]=f;a=c[i+16>>2]|0;if(a|0){c[b+16>>2]=a;c[a+24>>2]=b}a=c[i+20>>2]|0;if(a){c[b+20>>2]=a;c[a+24>>2]=b;e=j}else e=j}else e=j;while(0);do if(h>>>0>=16){c[i+4>>2]=k|3;c[g+4>>2]=h|1;c[g+h>>2]=h;b=h>>>3;if(h>>>0<256){d=624+(b<<1<<2)|0;a=c[146]|0;b=1<<b;if(!(a&b)){c[146]=a|b;b=d;a=d+8|0}else{a=d+8|0;b=c[a>>2]|0}c[a>>2]=g;c[b+12>>2]=g;c[g+8>>2]=b;c[g+12>>2]=d;break}b=h>>>8;if(b)if(h>>>0>16777215)b=31;else{v=(b+1048320|0)>>>16&8;w=b<<v;u=(w+520192|0)>>>16&4;w=w<<u;b=(w+245760|0)>>>16&2;b=14-(u|v|b)+(w<<b>>>15)|0;b=h>>>(b+7|0)&1|b<<1}else b=0;d=888+(b<<2)|0;c[g+28>>2]=b;a=g+16|0;c[a+4>>2]=0;c[a>>2]=0;a=1<<b;if(!(e&a)){c[147]=e|a;c[d>>2]=g;c[g+24>>2]=d;c[g+12>>2]=g;c[g+8>>2]=g;break}a=h<<((b|0)==31?0:25-(b>>>1)|0);d=c[d>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(h|0)){v=97;break}e=d+16+(a>>>31<<2)|0;b=c[e>>2]|0;if(!b){v=96;break}else{a=a<<1;d=b}}if((v|0)==96){c[e>>2]=g;c[g+24>>2]=d;c[g+12>>2]=g;c[g+8>>2]=g;break}else if((v|0)==97){v=d+8|0;w=c[v>>2]|0;c[w+12>>2]=g;c[v>>2]=g;c[g+8>>2]=w;c[g+12>>2]=d;c[g+24>>2]=0;break}}else{w=h+k|0;c[i+4>>2]=w|3;w=i+w+4|0;c[w>>2]=c[w>>2]|1}while(0);w=i+8|0;l=x;return w|0}else n=k}else n=k}else n=-1;while(0);d=c[148]|0;if(d>>>0>=n>>>0){b=d-n|0;a=c[151]|0;if(b>>>0>15){w=a+n|0;c[151]=w;c[148]=b;c[w+4>>2]=b|1;c[w+b>>2]=b;c[a+4>>2]=n|3}else{c[148]=0;c[151]=0;c[a+4>>2]=d|3;w=a+d+4|0;c[w>>2]=c[w>>2]|1}w=a+8|0;l=x;return w|0}h=c[149]|0;if(h>>>0>n>>>0){u=h-n|0;c[149]=u;w=c[152]|0;v=w+n|0;c[152]=v;c[v+4>>2]=u|1;c[w+4>>2]=n|3;w=w+8|0;l=x;return w|0}if(!(c[264]|0)){c[266]=4096;c[265]=4096;c[267]=-1;c[268]=-1;c[269]=0;c[257]=0;a=o&-16^1431655768;c[o>>2]=a;c[264]=a;a=4096}else a=c[266]|0;i=n+48|0;j=n+47|0;g=a+j|0;f=0-a|0;k=g&f;if(k>>>0<=n>>>0){w=0;l=x;return w|0}a=c[256]|0;if(a|0?(m=c[254]|0,o=m+k|0,o>>>0<=m>>>0|o>>>0>a>>>0):0){w=0;l=x;return w|0}b:do if(!(c[257]&4)){d=c[152]|0;c:do if(d){e=1032;while(1){a=c[e>>2]|0;if(a>>>0<=d>>>0?(r=e+4|0,(a+(c[r>>2]|0)|0)>>>0>d>>>0):0)break;a=c[e+8>>2]|0;if(!a){v=118;break c}else e=a}b=g-h&f;if(b>>>0<2147483647){a=Xa(b|0)|0;if((a|0)==((c[e>>2]|0)+(c[r>>2]|0)|0)){if((a|0)!=(-1|0)){h=b;g=a;v=135;break b}}else{e=a;v=126}}else b=0}else v=118;while(0);do if((v|0)==118){d=Xa(0)|0;if((d|0)!=(-1|0)?(b=d,p=c[265]|0,q=p+-1|0,b=((q&b|0)==0?0:(q+b&0-p)-b|0)+k|0,p=c[254]|0,q=b+p|0,b>>>0>n>>>0&b>>>0<2147483647):0){r=c[256]|0;if(r|0?q>>>0<=p>>>0|q>>>0>r>>>0:0){b=0;break}a=Xa(b|0)|0;if((a|0)==(d|0)){h=b;g=d;v=135;break b}else{e=a;v=126}}else b=0}while(0);do if((v|0)==126){d=0-b|0;if(!(i>>>0>b>>>0&(b>>>0<2147483647&(e|0)!=(-1|0))))if((e|0)==(-1|0)){b=0;break}else{h=b;g=e;v=135;break b}a=c[266]|0;a=j-b+a&0-a;if(a>>>0>=2147483647){h=b;g=e;v=135;break b}if((Xa(a|0)|0)==(-1|0)){Xa(d|0)|0;b=0;break}else{h=a+b|0;g=e;v=135;break b}}while(0);c[257]=c[257]|4;v=133}else{b=0;v=133}while(0);if(((v|0)==133?k>>>0<2147483647:0)?(u=Xa(k|0)|0,r=Xa(0)|0,s=r-u|0,t=s>>>0>(n+40|0)>>>0,!((u|0)==(-1|0)|t^1|u>>>0<r>>>0&((u|0)!=(-1|0)&(r|0)!=(-1|0))^1)):0){h=t?s:b;g=u;v=135}if((v|0)==135){b=(c[254]|0)+h|0;c[254]=b;if(b>>>0>(c[255]|0)>>>0)c[255]=b;j=c[152]|0;do if(j){b=1032;while(1){a=c[b>>2]|0;d=b+4|0;e=c[d>>2]|0;if((g|0)==(a+e|0)){v=145;break}f=c[b+8>>2]|0;if(!f)break;else b=f}if(((v|0)==145?(c[b+12>>2]&8|0)==0:0)?j>>>0<g>>>0&j>>>0>=a>>>0:0){c[d>>2]=e+h;w=j+8|0;w=(w&7|0)==0?0:0-w&7;v=j+w|0;w=(c[149]|0)+(h-w)|0;c[152]=v;c[149]=w;c[v+4>>2]=w|1;c[v+w+4>>2]=40;c[153]=c[268];break}if(g>>>0<(c[150]|0)>>>0)c[150]=g;d=g+h|0;b=1032;while(1){if((c[b>>2]|0)==(d|0)){v=153;break}a=c[b+8>>2]|0;if(!a)break;else b=a}if((v|0)==153?(c[b+12>>2]&8|0)==0:0){c[b>>2]=g;m=b+4|0;c[m>>2]=(c[m>>2]|0)+h;m=g+8|0;m=g+((m&7|0)==0?0:0-m&7)|0;b=d+8|0;b=d+((b&7|0)==0?0:0-b&7)|0;k=m+n|0;i=b-m-n|0;c[m+4>>2]=n|3;do if((b|0)!=(j|0)){if((b|0)==(c[151]|0)){w=(c[148]|0)+i|0;c[148]=w;c[151]=k;c[k+4>>2]=w|1;c[k+w>>2]=w;break}a=c[b+4>>2]|0;if((a&3|0)==1){h=a&-8;e=a>>>3;d:do if(a>>>0<256){a=c[b+8>>2]|0;d=c[b+12>>2]|0;if((d|0)==(a|0)){c[146]=c[146]&~(1<<e);break}else{c[a+12>>2]=d;c[d+8>>2]=a;break}}else{g=c[b+24>>2]|0;a=c[b+12>>2]|0;do if((a|0)==(b|0)){e=b+16|0;d=e+4|0;a=c[d>>2]|0;if(!a){a=c[e>>2]|0;if(!a){a=0;break}else d=e}while(1){e=a+20|0;f=c[e>>2]|0;if(f|0){a=f;d=e;continue}e=a+16|0;f=c[e>>2]|0;if(!f)break;else{a=f;d=e}}c[d>>2]=0}else{w=c[b+8>>2]|0;c[w+12>>2]=a;c[a+8>>2]=w}while(0);if(!g)break;d=c[b+28>>2]|0;e=888+(d<<2)|0;do if((b|0)!=(c[e>>2]|0)){c[g+16+(((c[g+16>>2]|0)!=(b|0)&1)<<2)>>2]=a;if(!a)break d}else{c[e>>2]=a;if(a|0)break;c[147]=c[147]&~(1<<d);break d}while(0);c[a+24>>2]=g;d=b+16|0;e=c[d>>2]|0;if(e|0){c[a+16>>2]=e;c[e+24>>2]=a}d=c[d+4>>2]|0;if(!d)break;c[a+20>>2]=d;c[d+24>>2]=a}while(0);b=b+h|0;f=h+i|0}else f=i;b=b+4|0;c[b>>2]=c[b>>2]&-2;c[k+4>>2]=f|1;c[k+f>>2]=f;b=f>>>3;if(f>>>0<256){d=624+(b<<1<<2)|0;a=c[146]|0;b=1<<b;if(!(a&b)){c[146]=a|b;b=d;a=d+8|0}else{a=d+8|0;b=c[a>>2]|0}c[a>>2]=k;c[b+12>>2]=k;c[k+8>>2]=b;c[k+12>>2]=d;break}b=f>>>8;do if(!b)b=0;else{if(f>>>0>16777215){b=31;break}v=(b+1048320|0)>>>16&8;w=b<<v;u=(w+520192|0)>>>16&4;w=w<<u;b=(w+245760|0)>>>16&2;b=14-(u|v|b)+(w<<b>>>15)|0;b=f>>>(b+7|0)&1|b<<1}while(0);e=888+(b<<2)|0;c[k+28>>2]=b;a=k+16|0;c[a+4>>2]=0;c[a>>2]=0;a=c[147]|0;d=1<<b;if(!(a&d)){c[147]=a|d;c[e>>2]=k;c[k+24>>2]=e;c[k+12>>2]=k;c[k+8>>2]=k;break}a=f<<((b|0)==31?0:25-(b>>>1)|0);d=c[e>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(f|0)){v=194;break}e=d+16+(a>>>31<<2)|0;b=c[e>>2]|0;if(!b){v=193;break}else{a=a<<1;d=b}}if((v|0)==193){c[e>>2]=k;c[k+24>>2]=d;c[k+12>>2]=k;c[k+8>>2]=k;break}else if((v|0)==194){v=d+8|0;w=c[v>>2]|0;c[w+12>>2]=k;c[v>>2]=k;c[k+8>>2]=w;c[k+12>>2]=d;c[k+24>>2]=0;break}}else{w=(c[149]|0)+i|0;c[149]=w;c[152]=k;c[k+4>>2]=w|1}while(0);w=m+8|0;l=x;return w|0}b=1032;while(1){a=c[b>>2]|0;if(a>>>0<=j>>>0?(w=a+(c[b+4>>2]|0)|0,w>>>0>j>>>0):0)break;b=c[b+8>>2]|0}f=w+-47|0;a=f+8|0;a=f+((a&7|0)==0?0:0-a&7)|0;f=j+16|0;a=a>>>0<f>>>0?j:a;b=a+8|0;d=g+8|0;d=(d&7|0)==0?0:0-d&7;v=g+d|0;d=h+-40-d|0;c[152]=v;c[149]=d;c[v+4>>2]=d|1;c[v+d+4>>2]=40;c[153]=c[268];d=a+4|0;c[d>>2]=27;c[b>>2]=c[258];c[b+4>>2]=c[259];c[b+8>>2]=c[260];c[b+12>>2]=c[261];c[258]=g;c[259]=h;c[261]=0;c[260]=b;b=a+24|0;do{v=b;b=b+4|0;c[b>>2]=7}while((v+8|0)>>>0<w>>>0);if((a|0)!=(j|0)){g=a-j|0;c[d>>2]=c[d>>2]&-2;c[j+4>>2]=g|1;c[a>>2]=g;b=g>>>3;if(g>>>0<256){d=624+(b<<1<<2)|0;a=c[146]|0;b=1<<b;if(!(a&b)){c[146]=a|b;b=d;a=d+8|0}else{a=d+8|0;b=c[a>>2]|0}c[a>>2]=j;c[b+12>>2]=j;c[j+8>>2]=b;c[j+12>>2]=d;break}b=g>>>8;if(b)if(g>>>0>16777215)d=31;else{v=(b+1048320|0)>>>16&8;w=b<<v;u=(w+520192|0)>>>16&4;w=w<<u;d=(w+245760|0)>>>16&2;d=14-(u|v|d)+(w<<d>>>15)|0;d=g>>>(d+7|0)&1|d<<1}else d=0;e=888+(d<<2)|0;c[j+28>>2]=d;c[j+20>>2]=0;c[f>>2]=0;b=c[147]|0;a=1<<d;if(!(b&a)){c[147]=b|a;c[e>>2]=j;c[j+24>>2]=e;c[j+12>>2]=j;c[j+8>>2]=j;break}a=g<<((d|0)==31?0:25-(d>>>1)|0);d=c[e>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(g|0)){v=216;break}e=d+16+(a>>>31<<2)|0;b=c[e>>2]|0;if(!b){v=215;break}else{a=a<<1;d=b}}if((v|0)==215){c[e>>2]=j;c[j+24>>2]=d;c[j+12>>2]=j;c[j+8>>2]=j;break}else if((v|0)==216){v=d+8|0;w=c[v>>2]|0;c[w+12>>2]=j;c[v>>2]=j;c[j+8>>2]=w;c[j+12>>2]=d;c[j+24>>2]=0;break}}}else{w=c[150]|0;if((w|0)==0|g>>>0<w>>>0)c[150]=g;c[258]=g;c[259]=h;c[261]=0;c[155]=c[264];c[154]=-1;b=0;do{w=624+(b<<1<<2)|0;c[w+12>>2]=w;c[w+8>>2]=w;b=b+1|0}while((b|0)!=32);w=g+8|0;w=(w&7|0)==0?0:0-w&7;v=g+w|0;w=h+-40-w|0;c[152]=v;c[149]=w;c[v+4>>2]=w|1;c[v+w+4>>2]=40;c[153]=c[268]}while(0);b=c[149]|0;if(b>>>0>n>>>0){u=b-n|0;c[149]=u;w=c[152]|0;v=w+n|0;c[152]=v;c[v+4>>2]=u|1;c[w+4>>2]=n|3;w=w+8|0;l=x;return w|0}}c[(Ca()|0)>>2]=12;w=0;l=x;return w|0}function xa(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;if(!a)return;d=a+-8|0;f=c[150]|0;a=c[a+-4>>2]|0;b=a&-8;j=d+b|0;do if(!(a&1)){e=c[d>>2]|0;if(!(a&3))return;h=d+(0-e)|0;g=e+b|0;if(h>>>0<f>>>0)return;if((h|0)==(c[151]|0)){a=j+4|0;b=c[a>>2]|0;if((b&3|0)!=3){i=h;b=g;break}c[148]=g;c[a>>2]=b&-2;c[h+4>>2]=g|1;c[h+g>>2]=g;return}d=e>>>3;if(e>>>0<256){a=c[h+8>>2]|0;b=c[h+12>>2]|0;if((b|0)==(a|0)){c[146]=c[146]&~(1<<d);i=h;b=g;break}else{c[a+12>>2]=b;c[b+8>>2]=a;i=h;b=g;break}}f=c[h+24>>2]|0;a=c[h+12>>2]|0;do if((a|0)==(h|0)){d=h+16|0;b=d+4|0;a=c[b>>2]|0;if(!a){a=c[d>>2]|0;if(!a){a=0;break}else b=d}while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}c[b>>2]=0}else{i=c[h+8>>2]|0;c[i+12>>2]=a;c[a+8>>2]=i}while(0);if(f){b=c[h+28>>2]|0;d=888+(b<<2)|0;if((h|0)==(c[d>>2]|0)){c[d>>2]=a;if(!a){c[147]=c[147]&~(1<<b);i=h;b=g;break}}else{c[f+16+(((c[f+16>>2]|0)!=(h|0)&1)<<2)>>2]=a;if(!a){i=h;b=g;break}}c[a+24>>2]=f;b=h+16|0;d=c[b>>2]|0;if(d|0){c[a+16>>2]=d;c[d+24>>2]=a}b=c[b+4>>2]|0;if(b){c[a+20>>2]=b;c[b+24>>2]=a;i=h;b=g}else{i=h;b=g}}else{i=h;b=g}}else{i=d;h=d}while(0);if(h>>>0>=j>>>0)return;a=j+4|0;e=c[a>>2]|0;if(!(e&1))return;if(!(e&2)){a=c[151]|0;if((j|0)==(c[152]|0)){j=(c[149]|0)+b|0;c[149]=j;c[152]=i;c[i+4>>2]=j|1;if((i|0)!=(a|0))return;c[151]=0;c[148]=0;return}if((j|0)==(a|0)){j=(c[148]|0)+b|0;c[148]=j;c[151]=h;c[i+4>>2]=j|1;c[h+j>>2]=j;return}f=(e&-8)+b|0;d=e>>>3;do if(e>>>0<256){b=c[j+8>>2]|0;a=c[j+12>>2]|0;if((a|0)==(b|0)){c[146]=c[146]&~(1<<d);break}else{c[b+12>>2]=a;c[a+8>>2]=b;break}}else{g=c[j+24>>2]|0;a=c[j+12>>2]|0;do if((a|0)==(j|0)){d=j+16|0;b=d+4|0;a=c[b>>2]|0;if(!a){a=c[d>>2]|0;if(!a){d=0;break}else b=d}while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}c[b>>2]=0;d=a}else{d=c[j+8>>2]|0;c[d+12>>2]=a;c[a+8>>2]=d;d=a}while(0);if(g|0){a=c[j+28>>2]|0;b=888+(a<<2)|0;if((j|0)==(c[b>>2]|0)){c[b>>2]=d;if(!d){c[147]=c[147]&~(1<<a);break}}else{c[g+16+(((c[g+16>>2]|0)!=(j|0)&1)<<2)>>2]=d;if(!d)break}c[d+24>>2]=g;a=j+16|0;b=c[a>>2]|0;if(b|0){c[d+16>>2]=b;c[b+24>>2]=d}a=c[a+4>>2]|0;if(a|0){c[d+20>>2]=a;c[a+24>>2]=d}}}while(0);c[i+4>>2]=f|1;c[h+f>>2]=f;if((i|0)==(c[151]|0)){c[148]=f;return}}else{c[a>>2]=e&-2;c[i+4>>2]=b|1;c[h+b>>2]=b;f=b}a=f>>>3;if(f>>>0<256){d=624+(a<<1<<2)|0;b=c[146]|0;a=1<<a;if(!(b&a)){c[146]=b|a;a=d;b=d+8|0}else{b=d+8|0;a=c[b>>2]|0}c[b>>2]=i;c[a+12>>2]=i;c[i+8>>2]=a;c[i+12>>2]=d;return}a=f>>>8;if(a)if(f>>>0>16777215)a=31;else{h=(a+1048320|0)>>>16&8;j=a<<h;g=(j+520192|0)>>>16&4;j=j<<g;a=(j+245760|0)>>>16&2;a=14-(g|h|a)+(j<<a>>>15)|0;a=f>>>(a+7|0)&1|a<<1}else a=0;e=888+(a<<2)|0;c[i+28>>2]=a;c[i+20>>2]=0;c[i+16>>2]=0;b=c[147]|0;d=1<<a;do if(b&d){b=f<<((a|0)==31?0:25-(a>>>1)|0);d=c[e>>2]|0;while(1){if((c[d+4>>2]&-8|0)==(f|0)){a=73;break}e=d+16+(b>>>31<<2)|0;a=c[e>>2]|0;if(!a){a=72;break}else{b=b<<1;d=a}}if((a|0)==72){c[e>>2]=i;c[i+24>>2]=d;c[i+12>>2]=i;c[i+8>>2]=i;break}else if((a|0)==73){h=d+8|0;j=c[h>>2]|0;c[j+12>>2]=i;c[h>>2]=i;c[i+8>>2]=j;c[i+12>>2]=d;c[i+24>>2]=0;break}}else{c[147]=b|d;c[e>>2]=i;c[i+24>>2]=e;c[i+12>>2]=i;c[i+8>>2]=i}while(0);j=(c[154]|0)+-1|0;c[154]=j;if(!j)a=1040;else return;while(1){a=c[a>>2]|0;if(!a)break;else a=a+8|0}c[154]=-1;return}function ya(a){a=a|0;var b=0,d=0;b=l;l=l+16|0;d=b;c[d>>2]=Fa(c[a+60>>2]|0)|0;a=Ba(ba(6,d|0)|0)|0;l=b;return a|0}function za(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0;n=l;l=l+48|0;k=n+16|0;g=n;f=n+32|0;i=a+28|0;e=c[i>>2]|0;c[f>>2]=e;j=a+20|0;e=(c[j>>2]|0)-e|0;c[f+4>>2]=e;c[f+8>>2]=b;c[f+12>>2]=d;e=e+d|0;h=a+60|0;c[g>>2]=c[h>>2];c[g+4>>2]=f;c[g+8>>2]=2;g=Ba($(146,g|0)|0)|0;a:do if((e|0)!=(g|0)){b=2;while(1){if((g|0)<0)break;e=e-g|0;p=c[f+4>>2]|0;o=g>>>0>p>>>0;f=o?f+8|0:f;b=(o<<31>>31)+b|0;p=g-(o?p:0)|0;c[f>>2]=(c[f>>2]|0)+p;o=f+4|0;c[o>>2]=(c[o>>2]|0)-p;c[k>>2]=c[h>>2];c[k+4>>2]=f;c[k+8>>2]=b;g=Ba($(146,k|0)|0)|0;if((e|0)==(g|0)){m=3;break a}}c[a+16>>2]=0;c[i>>2]=0;c[j>>2]=0;c[a>>2]=c[a>>2]|32;if((b|0)==2)d=0;else d=d-(c[f+4>>2]|0)|0}else m=3;while(0);if((m|0)==3){p=c[a+44>>2]|0;c[a+16>>2]=p+(c[a+48>>2]|0);c[i>>2]=p;c[j>>2]=p}l=n;return d|0}function Aa(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=l;l=l+32|0;g=f;e=f+20|0;c[g>>2]=c[a+60>>2];c[g+4>>2]=0;c[g+8>>2]=b;c[g+12>>2]=e;c[g+16>>2]=d;if((Ba(_(140,g|0)|0)|0)<0){c[e>>2]=-1;a=-1}else a=c[e>>2]|0;l=f;return a|0}function Ba(a){a=a|0;if(a>>>0>4294963200){c[(Ca()|0)>>2]=0-a;a=-1}return a|0}function Ca(){return (Da()|0)+64|0}function Da(){return Ea()|0}function Ea(){return 8}function Fa(a){a=a|0;return a|0}function Ga(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;g=l;l=l+32|0;f=g;c[b+36>>2]=3;if((c[b>>2]&64|0)==0?(c[f>>2]=c[b+60>>2],c[f+4>>2]=21523,c[f+8>>2]=g+16,aa(54,f|0)|0):0)a[b+75>>0]=-1;f=za(b,d,e)|0;l=g;return f|0}function Ha(){return 1080}function Ia(a){a=a|0;return 0}function Ja(a){a=a|0;return}function Ka(){Y(1144);return 1152}function La(){ca(1144);return}function Ma(a){a=a|0;var b=0,d=0;do if(a){if((c[a+76>>2]|0)<=-1){b=Na(a)|0;break}d=(Ia(a)|0)==0;b=Na(a)|0;if(!d)Ja(a)}else{if(!(c[94]|0))b=0;else b=Ma(c[94]|0)|0;a=c[(Ka()|0)>>2]|0;if(a)do{if((c[a+76>>2]|0)>-1)d=Ia(a)|0;else d=0;if((c[a+20>>2]|0)>>>0>(c[a+28>>2]|0)>>>0)b=Na(a)|0|b;if(d|0)Ja(a);a=c[a+56>>2]|0}while((a|0)!=0);La()}while(0);return b|0}function Na(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=a+20|0;h=a+28|0;if((c[b>>2]|0)>>>0>(c[h>>2]|0)>>>0?(ha[c[a+36>>2]&3](a,0,0)|0,(c[b>>2]|0)==0):0)a=-1;else{d=a+4|0;e=c[d>>2]|0;f=a+8|0;g=c[f>>2]|0;if(e>>>0<g>>>0)ha[c[a+40>>2]&3](a,e-g|0,1)|0;c[a+16>>2]=0;c[h>>2]=0;c[b>>2]=0;c[f>>2]=0;c[d>>2]=0;a=0}return a|0}function Oa(){}function Pa(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;f=a&65535;e=b&65535;c=N(e,f)|0;d=a>>>16;a=(c>>>16)+(N(e,d)|0)|0;e=b>>>16;b=N(e,f)|0;return (y=(a>>>16)+(N(e,d)|0)+(((a&65535)+b|0)>>>16)|0,a+b<<16|c&65535|0)|0}function Qa(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=a;f=c;c=Pa(e,f)|0;a=y;return (y=(N(b,f)|0)+(N(d,e)|0)+a|a&0,c|0|0)|0}function Ra(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){y=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}y=(b|0)<0?-1:0;return b>>c-32|0}function Sa(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){y=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}y=a<<c-32;return 0}function Ta(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=a+c>>>0;return (y=b+d+(c>>>0<a>>>0|0)>>>0,c|0)|0}function Ua(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=b-d-(c>>>0>a>>>0|0)>>>0;return (y=d,a-c>>>0|0)|0}function Va(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if((e|0)>=8192)return ea(b|0,d|0,e|0)|0;h=b|0;g=b+e|0;if((b&3)==(d&3)){while(b&3){if(!e)return h|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}e=g&-4|0;f=e-64|0;while((b|0)<=(f|0)){c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[b+16>>2]=c[d+16>>2];c[b+20>>2]=c[d+20>>2];c[b+24>>2]=c[d+24>>2];c[b+28>>2]=c[d+28>>2];c[b+32>>2]=c[d+32>>2];c[b+36>>2]=c[d+36>>2];c[b+40>>2]=c[d+40>>2];c[b+44>>2]=c[d+44>>2];c[b+48>>2]=c[d+48>>2];c[b+52>>2]=c[d+52>>2];c[b+56>>2]=c[d+56>>2];c[b+60>>2]=c[d+60>>2];b=b+64|0;d=d+64|0}while((b|0)<(e|0)){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0}}else{e=g-4|0;while((b|0)<(e|0)){a[b>>0]=a[d>>0]|0;a[b+1>>0]=a[d+1>>0]|0;a[b+2>>0]=a[d+2>>0]|0;a[b+3>>0]=a[d+3>>0]|0;b=b+4|0;d=d+4|0}}while((b|0)<(g|0)){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0}return h|0}function Wa(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=b+e|0;d=d&255;if((e|0)>=67){while(b&3){a[b>>0]=d;b=b+1|0}f=h&-4|0;g=f-64|0;i=d|d<<8|d<<16|d<<24;while((b|0)<=(g|0)){c[b>>2]=i;c[b+4>>2]=i;c[b+8>>2]=i;c[b+12>>2]=i;c[b+16>>2]=i;c[b+20>>2]=i;c[b+24>>2]=i;c[b+28>>2]=i;c[b+32>>2]=i;c[b+36>>2]=i;c[b+40>>2]=i;c[b+44>>2]=i;c[b+48>>2]=i;c[b+52>>2]=i;c[b+56>>2]=i;c[b+60>>2]=i;b=b+64|0}while((b|0)<(f|0)){c[b>>2]=i;b=b+4|0}}while((b|0)<(h|0)){a[b>>0]=d;b=b+1|0}return h-e|0}function Xa(a){a=a|0;var b=0,d=0;d=a+15&-16|0;b=c[i>>2]|0;a=b+d|0;if((d|0)>0&(a|0)<(b|0)|(a|0)<0){V()|0;Z(12);return -1}c[i>>2]=a;if((a|0)>(U()|0)?(T()|0)==0:0){c[i>>2]=b;Z(12);return -1}return b|0}function Ya(a,b){a=a|0;b=b|0;return ga[a&1](b|0)|0}function Za(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return ha[a&3](b|0,c|0,d|0)|0}function _a(a){a=a|0;R(0);return 0}function $a(a,b,c){a=a|0;b=b|0;c=c|0;R(1);return 0}

// EMSCRIPTEN_END_FUNCS
var ga=[_a,ya];var ha=[$a,Ga,Aa,za];return{___errno_location:Ca,___muldi3:Qa,_bitshift64Ashr:Ra,_bitshift64Shl:Sa,_curve25519_generate_private:qa,_curve25519_generate_public:pa,_emscripten_get_global_libc:Ha,_fflush:Ma,_free:xa,_i64Add:Ta,_i64Subtract:Ua,_key_to_base64:ra,_malloc:wa,_memcpy:Va,_memset:Wa,_sbrk:Xa,dynCall_ii:Ya,dynCall_iiii:Za,establishStackSpace:la,getTempRet0:oa,runPostSets:Oa,setTempRet0:na,setThrew:ma,stackAlloc:ia,stackRestore:ka,stackSave:ja}})


// EMSCRIPTEN_END_ASM
(Module.asmGlobalArg,Module.asmLibraryArg,buffer);var ___errno_location=Module["___errno_location"]=asm["___errno_location"];var ___muldi3=Module["___muldi3"]=asm["___muldi3"];var _bitshift64Ashr=Module["_bitshift64Ashr"]=asm["_bitshift64Ashr"];var _bitshift64Shl=Module["_bitshift64Shl"]=asm["_bitshift64Shl"];var _curve25519_generate_private=Module["_curve25519_generate_private"]=asm["_curve25519_generate_private"];var _curve25519_generate_public=Module["_curve25519_generate_public"]=asm["_curve25519_generate_public"];var _emscripten_get_global_libc=Module["_emscripten_get_global_libc"]=asm["_emscripten_get_global_libc"];var _fflush=Module["_fflush"]=asm["_fflush"];var _free=Module["_free"]=asm["_free"];var _i64Add=Module["_i64Add"]=asm["_i64Add"];var _i64Subtract=Module["_i64Subtract"]=asm["_i64Subtract"];var _key_to_base64=Module["_key_to_base64"]=asm["_key_to_base64"];var _malloc=Module["_malloc"]=asm["_malloc"];var _memcpy=Module["_memcpy"]=asm["_memcpy"];var _memset=Module["_memset"]=asm["_memset"];var _sbrk=Module["_sbrk"]=asm["_sbrk"];var establishStackSpace=Module["establishStackSpace"]=asm["establishStackSpace"];var getTempRet0=Module["getTempRet0"]=asm["getTempRet0"];var runPostSets=Module["runPostSets"]=asm["runPostSets"];var setTempRet0=Module["setTempRet0"]=asm["setTempRet0"];var setThrew=Module["setThrew"]=asm["setThrew"];var stackAlloc=Module["stackAlloc"]=asm["stackAlloc"];var stackRestore=Module["stackRestore"]=asm["stackRestore"];var stackSave=Module["stackSave"]=asm["stackSave"];var dynCall_ii=Module["dynCall_ii"]=asm["dynCall_ii"];var dynCall_iiii=Module["dynCall_iiii"]=asm["dynCall_iiii"];Runtime.stackAlloc=Module["stackAlloc"];Runtime.stackSave=Module["stackSave"];Runtime.stackRestore=Module["stackRestore"];Runtime.establishStackSpace=Module["establishStackSpace"];Runtime.setTempRet0=Module["setTempRet0"];Runtime.getTempRet0=Module["getTempRet0"];Module["asm"]=asm;if(memoryInitializer){if(typeof Module["locateFile"]==="function"){memoryInitializer=Module["locateFile"](memoryInitializer)}else if(Module["memoryInitializerPrefixURL"]){memoryInitializer=Module["memoryInitializerPrefixURL"]+memoryInitializer}if(ENVIRONMENT_IS_NODE||ENVIRONMENT_IS_SHELL){var data=Module["readBinary"](memoryInitializer);HEAPU8.set(data,Runtime.GLOBAL_BASE)}else{addRunDependency("memory initializer");var applyMemoryInitializer=(function(data){if(data.byteLength)data=new Uint8Array(data);HEAPU8.set(data,Runtime.GLOBAL_BASE);if(Module["memoryInitializerRequest"])delete Module["memoryInitializerRequest"].response;removeRunDependency("memory initializer")});function doBrowserLoad(){Module["readAsync"](memoryInitializer,applyMemoryInitializer,(function(){throw"could not load memory initializer "+memoryInitializer}))}var memoryInitializerBytes=tryParseAsDataURI(memoryInitializer);if(memoryInitializerBytes){applyMemoryInitializer(memoryInitializerBytes.buffer)}else if(Module["memoryInitializerRequest"]){function useRequest(){var request=Module["memoryInitializerRequest"];var response=request.response;if(request.status!==200&&request.status!==0){var data=tryParseAsDataURI(Module["memoryInitializerRequestURL"]);if(data){response=data.buffer}else{console.warn("a problem seems to have happened with Module.memoryInitializerRequest, status: "+request.status+", retrying "+memoryInitializer);doBrowserLoad();return}}applyMemoryInitializer(response)}if(Module["memoryInitializerRequest"].response){setTimeout(useRequest,0)}else{Module["memoryInitializerRequest"].addEventListener("load",useRequest)}}else{doBrowserLoad()}}}function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}ExitStatus.prototype=new Error;ExitStatus.prototype.constructor=ExitStatus;var initialStackTop;var preloadStartTime=null;var calledMain=false;dependenciesFulfilled=function runCaller(){if(!Module["calledRun"])run();if(!Module["calledRun"])dependenciesFulfilled=runCaller};Module["callMain"]=Module.callMain=function callMain(args){args=args||[];ensureInitRuntime();var argc=args.length+1;function pad(){for(var i=0;i<4-1;i++){argv.push(0)}}var argv=[allocate(intArrayFromString(Module["thisProgram"]),"i8",ALLOC_NORMAL)];pad();for(var i=0;i<argc-1;i=i+1){argv.push(allocate(intArrayFromString(args[i]),"i8",ALLOC_NORMAL));pad()}argv.push(0);argv=allocate(argv,"i32",ALLOC_NORMAL);try{var ret=Module["_main"](argc,argv,0);exit(ret,true)}catch(e){if(e instanceof ExitStatus){return}else if(e=="SimulateInfiniteLoop"){Module["noExitRuntime"]=true;return}else{var toLog=e;if(e&&typeof e==="object"&&e.stack){toLog=[e,e.stack]}Module.printErr("exception thrown: "+toLog);Module["quit"](1,e)}}finally{calledMain=true}};function run(args){args=args||Module["arguments"];if(preloadStartTime===null)preloadStartTime=Date.now();if(runDependencies>0){return}preRun();if(runDependencies>0)return;if(Module["calledRun"])return;function doRun(){if(Module["calledRun"])return;Module["calledRun"]=true;if(ABORT)return;ensureInitRuntime();preMain();if(Module["onRuntimeInitialized"])Module["onRuntimeInitialized"]();if(Module["_main"]&&shouldRunNow)Module["callMain"](args);postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout((function(){setTimeout((function(){Module["setStatus"]("")}),1);doRun()}),1)}else{doRun()}}Module["run"]=Module.run=run;function exit(status,implicit){if(implicit&&Module["noExitRuntime"]){return}if(Module["noExitRuntime"]){}else{ABORT=true;EXITSTATUS=status;STACKTOP=initialStackTop;exitRuntime();if(Module["onExit"])Module["onExit"](status)}if(ENVIRONMENT_IS_NODE){process["exit"](status)}Module["quit"](status,new ExitStatus(status))}Module["exit"]=Module.exit=exit;var abortDecorators=[];function abort(what){if(Module["onAbort"]){Module["onAbort"](what)}if(what!==undefined){Module.print(what);Module.printErr(what);what=JSON.stringify(what)}else{what=""}ABORT=true;EXITSTATUS=1;var extra="\nIf this abort() is unexpected, build with -s ASSERTIONS=1 which can give more information.";var output="abort("+what+") at "+stackTrace()+extra;if(abortDecorators){abortDecorators.forEach((function(decorator){output=decorator(output,what)}))}throw output}Module["abort"]=Module.abort=abort;if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=true;if(Module["noInitialRun"]){shouldRunNow=false}run()




