/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoTransporterException;

@Named
public final class DefaultTransporterProvider
implements TransporterProvider,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private Collection<TransporterFactory> factories = new ArrayList<TransporterFactory>();

    public DefaultTransporterProvider() {
    }

    @Inject
    DefaultTransporterProvider(Set<TransporterFactory> transporterFactories, LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
        this.setTransporterFactories(transporterFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setTransporterFactories(locator.getServices(TransporterFactory.class));
    }

    public DefaultTransporterProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultTransporterProvider addTransporterFactory(TransporterFactory factory) {
        this.factories.add(Objects.requireNonNull(factory, "transporter factory cannot be null"));
        return this;
    }

    public DefaultTransporterProvider setTransporterFactories(Collection<TransporterFactory> factories) {
        this.factories = factories == null ? new ArrayList<TransporterFactory>() : factories;
        return this;
    }

    @Override
    public Transporter newTransporter(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<TransporterFactory> factories = new PrioritizedComponents<TransporterFactory>(session);
        for (TransporterFactory factory : this.factories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoTransporterException> errors = new ArrayList<NoTransporterException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                Transporter transporter = ((TransporterFactory)factory.getComponent()).newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using transporter ").append(transporter.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, transporter);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    this.logger.debug(buffer.toString());
                }
                return transporter;
            }
            catch (NoTransporterException noTransporterException) {
                errors.add(noTransporterException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain transporter factory for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No transporter factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" using the registered transporter factories: ");
            factories.list(buffer);
        }
        throw new NoTransporterException(repository, buffer.toString(), errors.size() == 1 ? (NoTransporterException)errors.get(0) : null);
    }
}

