/*
 * Decompiled with CFR 0.152.
 */
package test.tools;

import common.MidiEventComparator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import test.suite.MidiAdaptorTest;

public class MidiTools
extends MidiAdaptorTest {
    public static void filterOptionalMeta(List output) {
        Iterator it = output.iterator();
        while (it.hasNext()) {
            MidiEvent me = (MidiEvent)it.next();
            MidiMessage mm = me.getMessage();
            if (mm.getStatus() != 255) continue;
            MetaMessage meta = (MetaMessage)mm;
            int type = meta.getType();
            if (type == 3) {
                it.remove();
                continue;
            }
            if (type == 47) {
                it.remove();
                continue;
            }
            if (type != 88) continue;
            byte[] data = meta.getData();
            byte[] newData = new byte[]{data[data.length - 4], data[data.length - 3], 24, 8};
            try {
                meta.setMessage(88, newData, 4);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
    }

    public static void compareEvents(MidiEvent m1, MidiEvent m2) {
        String s1 = MidiTools.stringize(m1);
        String s2 = MidiTools.stringize(m2);
        MidiTools.assertEquals((String)s1, (String)s2);
    }

    public static void compareMessages(MidiMessage m1, MidiMessage m2) {
        String s1 = MidiTools.stringize(m1);
        String s2 = MidiTools.stringize(m2);
        MidiTools.assertEquals((String)s1, (String)s2);
    }

    public static void hexize(int status, StringBuffer sb) {
        MidiTools.hexbit(status >> 4 & 0xF, sb);
        MidiTools.hexbit(status & 0xF, sb);
    }

    public static void hexbit(int i, StringBuffer sb) {
        String hex = "0123456789ABCDEF";
        sb.append(hex.charAt(i));
    }

    public static void prioritizeByChannel(List output) {
        Collections.sort(output, new Comparator(){

            public int compare(Object o1, Object o2) {
                MidiEvent m1 = (MidiEvent)o1;
                MidiEvent m2 = (MidiEvent)o2;
                if (m1.getTick() < m2.getTick()) {
                    return -1;
                }
                if (m1.getTick() > m2.getTick()) {
                    return 1;
                }
                MidiMessage mm1 = m1.getMessage();
                MidiMessage mm2 = m2.getMessage();
                int s1 = mm1.getStatus();
                int s2 = mm2.getStatus();
                if (s1 >= 240) {
                    return 0;
                }
                if (s2 >= 240) {
                    return 0;
                }
                int c1 = s1 & 0xF;
                int c2 = s2 & 0xF;
                if (c1 != c2) {
                    return c1 - c2;
                }
                int x1 = s1 & 0xF0;
                int x2 = s2 & 0xF0;
                if (x1 == 144 && x2 == 144) {
                    ShortMessage sm1 = (ShortMessage)mm1;
                    ShortMessage sm2 = (ShortMessage)mm2;
                    return sm1.getData1() - sm2.getData1();
                }
                return 0;
            }
        });
    }

    public static String stringize(MidiEvent e) {
        String s1 = Long.toString(e.getTick());
        return String.valueOf(s1) + ":" + MidiTools.stringize(e.getMessage());
    }

    public static String stringize(MidiMessage m) {
        StringBuffer sb = new StringBuffer();
        int status = m.getStatus();
        if (m instanceof ShortMessage) {
            ShortMessage sm = (ShortMessage)m;
            MidiTools.hexize(status, sb);
            MidiTools.hexize(sm.getData1(), sb);
            MidiTools.hexize(sm.getData2(), sb);
        } else {
            int l = m.getLength();
            byte[] data = m.getMessage();
            int i = 0;
            while (i < l) {
                MidiTools.hexize(data[i], sb);
                ++i;
            }
        }
        return sb.toString();
    }

    public static void remapTicks(List output, int sourcePPQ, int destPPQ) {
        Iterator it = output.iterator();
        while (it.hasNext()) {
            MidiEvent event = (MidiEvent)it.next();
            long t1 = event.getTick();
            t1 *= (long)destPPQ;
            event.setTick(t1 /= (long)sourcePPQ);
        }
    }

    public static void remapNoteOff(List output) {
        int r100 = 0;
        int r101 = 0;
        LinkedList<MidiEvent> results = new LinkedList<MidiEvent>();
        Iterator it = output.iterator();
        while (it.hasNext()) {
            MidiEvent me = (MidiEvent)it.next();
            MidiMessage mm = me.getMessage();
            int status = mm.getStatus();
            int command = status & 0xF0;
            int channel = status & 0xF;
            if (command == 128) {
                ShortMessage s1 = (ShortMessage)mm;
                ShortMessage s2 = new ShortMessage();
                try {
                    s2.setMessage(144 + channel, s1.getData1(), 0);
                    MidiEvent me2 = new MidiEvent(s2, me.getTick());
                    results.add(me2);
                }
                catch (InvalidMidiDataException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command == 224) continue;
            if (command == 176) {
                ShortMessage sm = (ShortMessage)mm;
                int controller = sm.getData1();
                int value = sm.getData2();
                switch (controller) {
                    case 100: {
                        r100 = value;
                        results.add(me);
                        break;
                    }
                    case 101: {
                        r101 = value;
                        results.add(me);
                        break;
                    }
                    case 6: {
                        if (r100 == 0 && r101 == 0) {
                            ShortMessage s2 = new ShortMessage();
                            try {
                                s2.setMessage(176 + channel, 6, 12);
                            }
                            catch (InvalidMidiDataException e) {
                                e.printStackTrace();
                            }
                            MidiEvent me2 = new MidiEvent(s2, me.getTick());
                            results.add(me2);
                            break;
                        }
                        results.add(me);
                        break;
                    }
                    default: {
                        results.add(me);
                        break;
                    }
                }
                continue;
            }
            results.add(me);
        }
        output.clear();
        output.addAll(results);
    }

    public static int load(String midiFile, List eventList) throws InvalidMidiDataException, IOException {
        File file = new File(midiFile);
        MidiFileFormat mff = MidiSystem.getMidiFileFormat(file);
        int ppq = mff.getResolution();
        Sequence seq = MidiSystem.getSequence(file);
        Track[] tracks = seq.getTracks();
        int t = 0;
        while (t < tracks.length) {
            Track track = tracks[t];
            int size = track.size();
            int j = 0;
            while (j < size) {
                MidiEvent event = track.get(j);
                eventList.add(event);
                ++j;
            }
            ++t;
        }
        Collections.sort(eventList, new MidiEventComparator());
        return ppq;
    }

    public static void remapChannel(List original, int effectsChannel, int mainChannel) {
        LinkedList<MidiEvent> results = new LinkedList<MidiEvent>();
        Iterator it = original.iterator();
        block5: while (it.hasNext()) {
            MidiEvent me = (MidiEvent)it.next();
            MidiMessage mm = me.getMessage();
            int status = mm.getStatus();
            int command = status & 0xF0;
            int channel = status & 0xF;
            if (channel != effectsChannel - 1 || command == 240) {
                results.add(me);
                continue;
            }
            switch (command) {
                case 128: 
                case 144: {
                    ShortMessage source = (ShortMessage)mm;
                    ShortMessage replacement = new ShortMessage();
                    try {
                        replacement.setMessage(command + (mainChannel - 1), source.getData1(), source.getData2());
                        MidiEvent me2 = new MidiEvent(replacement, me.getTick());
                        results.add(me2);
                    }
                    catch (InvalidMidiDataException e) {
                        e.printStackTrace();
                    }
                    continue block5;
                }
            }
        }
        original.clear();
        original.addAll(results);
    }

    public static void remapEvents(List original, String[] eventRemap) throws Exception {
        LinkedList<MidiEvent> results = new LinkedList<MidiEvent>();
        int nextEventRemap = 0;
        Iterator it = original.iterator();
        while (it.hasNext()) {
            MidiEvent me = (MidiEvent)it.next();
            String thisEvent = MidiTools.stringize(me);
            if (nextEventRemap < eventRemap.length && thisEvent.equals(eventRemap[nextEventRemap])) {
                String replacement = eventRemap[nextEventRemap + 1];
                nextEventRemap += 2;
                if (replacement.equals("")) continue;
                int colon = replacement.indexOf(":");
                int time = Integer.parseInt(replacement.substring(0, colon), 10);
                int status = Integer.parseInt(replacement.substring(colon + 1, colon + 3), 16);
                int data1 = Integer.parseInt(replacement.substring(colon + 3, colon + 5), 16);
                int data2 = Integer.parseInt(replacement.substring(colon + 5, colon + 7), 16);
                ShortMessage sm = new ShortMessage();
                try {
                    sm.setMessage(status, data1, data2);
                    MidiEvent me2 = new MidiEvent(sm, time);
                    results.add(me2);
                }
                catch (InvalidMidiDataException e) {
                    e.printStackTrace();
                }
                continue;
            }
            results.add(me);
        }
        if (nextEventRemap < eventRemap.length) {
            throw new Exception("No match found to event " + eventRemap[nextEventRemap]);
        }
        original.clear();
        original.addAll(results);
    }
}

