/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;

public class ReciprocalDoubleValuesSource
extends DoubleValuesSource {
    private final double distToEdge;
    private final DoubleValuesSource input;

    public ReciprocalDoubleValuesSource(double distToEdge, DoubleValuesSource input) {
        this.distToEdge = distToEdge;
        this.input = input;
    }

    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final DoubleValues in = this.input.getValues(ctx, scores);
        return new DoubleValues(){

            public double doubleValue() throws IOException {
                return ReciprocalDoubleValuesSource.this.recip(in.doubleValue());
            }

            public boolean advanceExact(int doc) throws IOException {
                return in.advanceExact(doc);
            }
        };
    }

    private double recip(double in) {
        return this.distToEdge / (in + this.distToEdge);
    }

    public boolean needsScores() {
        return this.input.needsScores();
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        Explanation expl = this.input.explain(ctx, docId, scoreExplanation);
        return Explanation.match((float)((float)this.recip(expl.getValue())), (String)(this.distToEdge + " / (v + " + this.distToEdge + "), computed from:"), (Explanation[])new Explanation[]{expl});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReciprocalDoubleValuesSource that = (ReciprocalDoubleValuesSource)((Object)o);
        return Double.compare(that.distToEdge, this.distToEdge) == 0 && Objects.equals(this.input, that.input);
    }

    public int hashCode() {
        return Objects.hash(this.distToEdge, this.input);
    }

    public String toString() {
        return "recip(" + this.distToEdge + ", " + this.input.toString() + ")";
    }
}

