/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.document.SuggestScoreDocPriorityQueue;

public class TopSuggestDocs
extends TopDocs {
    public static final TopSuggestDocs EMPTY = new TopSuggestDocs(0, new SuggestScoreDoc[0], 0.0f);

    public TopSuggestDocs(int totalHits, SuggestScoreDoc[] scoreDocs, float maxScore) {
        super((long)totalHits, (ScoreDoc[])scoreDocs, maxScore);
    }

    public SuggestScoreDoc[] scoreLookupDocs() {
        return (SuggestScoreDoc[])this.scoreDocs;
    }

    public static TopSuggestDocs merge(int topN, TopSuggestDocs[] shardHits) {
        SuggestScoreDocPriorityQueue priorityQueue = new SuggestScoreDocPriorityQueue(topN);
        for (TopSuggestDocs shardHit : shardHits) {
            for (SuggestScoreDoc scoreDoc : shardHit.scoreLookupDocs()) {
                if (scoreDoc == priorityQueue.insertWithOverflow(scoreDoc)) break;
            }
        }
        SuggestScoreDoc[] topNResults = priorityQueue.getResults();
        if (topNResults.length > 0) {
            return new TopSuggestDocs(topNResults.length, topNResults, topNResults[0].score);
        }
        return EMPTY;
    }

    public static class SuggestScoreDoc
    extends ScoreDoc
    implements Comparable<SuggestScoreDoc> {
        public final CharSequence key;
        public final CharSequence context;

        public SuggestScoreDoc(int doc, CharSequence key, CharSequence context, float score) {
            super(doc, score);
            this.key = key;
            this.context = context;
        }

        @Override
        public int compareTo(SuggestScoreDoc o) {
            return Lookup.CHARSEQUENCE_COMPARATOR.compare(this.key, o.key);
        }

        public boolean equals(Object other) {
            if (!(other instanceof SuggestScoreDoc)) {
                return false;
            }
            return this.key.equals(((SuggestScoreDoc)other).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return "key=" + this.key + " doc=" + this.doc + " score=" + this.score + " shardIndex=" + this.shardIndex;
        }
    }
}

