/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.TypeTokenFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class KeepTypesFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<String> keepTypes;
    private static final String KEEP_TYPES_KEY = "types";

    KeepTypesFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        List arrayKeepTypes = settings.getAsList(KEEP_TYPES_KEY, null);
        if (arrayKeepTypes == null) {
            throw new IllegalArgumentException("keep_types requires `types` to be configured");
        }
        this.keepTypes = new HashSet<String>(arrayKeepTypes);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new TypeTokenFilter(tokenStream, this.keepTypes, true);
    }
}

