/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

abstract class AtomicLongFieldData
implements AtomicNumericFieldData {
    private final long ramBytesUsed;
    private final IndexNumericFieldData.NumericType numericType;

    AtomicLongFieldData(long ramBytesUsed, IndexNumericFieldData.NumericType numericType) {
        this.ramBytesUsed = ramBytesUsed;
        this.numericType = numericType;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        switch (this.numericType) {
            case DATE: {
                return new ScriptDocValues.Dates(this.getLongValues());
            }
            case BOOLEAN: {
                return new ScriptDocValues.Booleans(this.getLongValues());
            }
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getLongValues());
    }

    @Override
    public final SortedNumericDoubleValues getDoubleValues() {
        return FieldData.castToDouble(this.getLongValues());
    }

    @Override
    public void close() {
    }
}

