/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SSubEachIterable
extends AStatement {
    private AExpression expression;
    private final SBlock block;
    private final Locals.Variable variable;
    private Definition.Cast cast = null;
    private Locals.Variable iterator = null;
    private Definition.Method method = null;

    SSubEachIterable(Location location, Locals.Variable variable, AExpression expression, SBlock block) {
        super(location);
        this.variable = Objects.requireNonNull(variable);
        this.expression = Objects.requireNonNull(expression);
        this.block = block;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        this.iterator = locals.addVariable(this.location, locals.getDefinition().getType("Iterator"), "#itr" + this.location.getOffset(), true);
        if (this.expression.actual.dynamic) {
            this.method = null;
        } else {
            this.method = this.expression.actual.struct.methods.get(new Definition.MethodKey("iterator", 0));
            if (this.method == null) {
                throw this.createError(new IllegalArgumentException("Unable to create iterator for the type [" + this.expression.actual.name + "]."));
            }
        }
        this.cast = locals.getDefinition().caster.getLegalCast(this.location, locals.getDefinition().DefType, this.variable.type, true, true);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        this.expression.write(writer, globals);
        if (this.method == null) {
            Type methodType = Type.getMethodType((Type)Type.getType(Iterator.class), (Type[])new Type[]{Type.getType(Object.class)});
            writer.invokeDefCall("iterator", methodType, 5, new Object[0]);
        } else {
            this.method.write(writer);
        }
        writer.visitVarInsn(this.iterator.type.type.getOpcode(54), this.iterator.getSlot());
        Label begin = new Label();
        Label end = new Label();
        writer.mark(begin);
        writer.visitVarInsn(this.iterator.type.type.getOpcode(21), this.iterator.getSlot());
        writer.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_HASNEXT);
        writer.ifZCmp(153, end);
        writer.visitVarInsn(this.iterator.type.type.getOpcode(21), this.iterator.getSlot());
        writer.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_NEXT);
        writer.writeCast(this.cast);
        writer.visitVarInsn(this.variable.type.type.getOpcode(54), this.variable.getSlot());
        if (this.loopCounter != null) {
            writer.writeLoopCounter(this.loopCounter.getSlot(), this.statementCount, this.location);
        }
        this.block.continu = begin;
        this.block.brake = end;
        this.block.write(writer, globals);
        writer.goTo(begin);
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.variable.type.name, this.variable.name, this.expression, this.block);
    }
}

