/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBaseCircle;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

class GeoExactCircle
extends GeoBaseCircle {
    protected final GeoPoint center;
    protected final double cutoffAngle;
    protected final double actualAccuracy;
    protected final List<SidedPlane> circlePlanes;
    protected final Map<SidedPlane, Membership> eitherBounds;
    protected final GeoPoint[] edgePoints;
    protected final List<GeoPoint[]> notableEdgePoints;
    protected static final GeoPoint[] circlePoints = new GeoPoint[0];

    public GeoExactCircle(PlanetModel planetModel, double lat, double lon, double cutoffAngle, double accuracy) {
        super(planetModel);
        if (lat < -1.5707963267948966 || lat > 1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of bounds");
        }
        if (lon < -Math.PI || lon > Math.PI) {
            throw new IllegalArgumentException("Longitude out of bounds");
        }
        if (cutoffAngle < 0.0) {
            throw new IllegalArgumentException("Cutoff angle out of bounds");
        }
        if (cutoffAngle < 1.0E-12) {
            throw new IllegalArgumentException("Cutoff angle cannot be effectively zero");
        }
        this.center = new GeoPoint(planetModel, lat, lon);
        this.cutoffAngle = cutoffAngle;
        this.actualAccuracy = accuracy < 1.0E-12 ? 1.0E-12 : accuracy;
        ArrayList<SidedPlane> circlePlanes = new ArrayList<SidedPlane>();
        ArrayList<GeoPoint[]> notableEdgePoints = new ArrayList<GeoPoint[]>();
        ArrayList<ApproximationSlice> slices = new ArrayList<ApproximationSlice>(100);
        GeoPoint northPoint = planetModel.surfacePointOnBearing(this.center, cutoffAngle, 0.0);
        GeoPoint southPoint = planetModel.surfacePointOnBearing(this.center, cutoffAngle, Math.PI);
        GeoPoint eastPoint = planetModel.surfacePointOnBearing(this.center, cutoffAngle, 1.5707963267948966);
        GeoPoint westPoint = planetModel.surfacePointOnBearing(this.center, cutoffAngle, 4.71238898038469);
        if (planetModel.c > planetModel.ab) {
            slices.add(new ApproximationSlice(this.center, eastPoint, 1.5707963267948966, westPoint, -1.5707963267948966, northPoint, 0.0));
            slices.add(new ApproximationSlice(this.center, westPoint, 4.71238898038469, eastPoint, 1.5707963267948966, southPoint, Math.PI));
        } else {
            slices.add(new ApproximationSlice(this.center, northPoint, Math.PI * 2, southPoint, Math.PI, eastPoint, 1.5707963267948966));
            slices.add(new ApproximationSlice(this.center, southPoint, Math.PI, northPoint, 0.0, westPoint, 4.71238898038469));
        }
        while (slices.size() > 0) {
            ApproximationSlice thisSlice = (ApproximationSlice)slices.remove(slices.size() - 1);
            double interpPoint1Bearing = (thisSlice.point1Bearing + thisSlice.middlePointBearing) * 0.5;
            GeoPoint interpPoint1 = planetModel.surfacePointOnBearing(this.center, cutoffAngle, interpPoint1Bearing);
            double interpPoint2Bearing = (thisSlice.point2Bearing + thisSlice.middlePointBearing) * 0.5;
            GeoPoint interpPoint2 = planetModel.surfacePointOnBearing(this.center, cutoffAngle, interpPoint2Bearing);
            if (Math.abs(thisSlice.plane.evaluate(interpPoint1)) < this.actualAccuracy && Math.abs(thisSlice.plane.evaluate(interpPoint2)) < this.actualAccuracy) {
                if (circlePlanes.size() != 0 && ((SidedPlane)circlePlanes.get(circlePlanes.size() - 1)).isNumericallyIdentical(thisSlice.plane)) continue;
                circlePlanes.add(thisSlice.plane);
                notableEdgePoints.add(new GeoPoint[]{thisSlice.endPoint1, thisSlice.endPoint2});
                continue;
            }
            slices.add(new ApproximationSlice(this.center, thisSlice.endPoint1, thisSlice.point1Bearing, thisSlice.middlePoint, thisSlice.middlePointBearing, interpPoint1, interpPoint1Bearing));
            slices.add(new ApproximationSlice(this.center, thisSlice.middlePoint, thisSlice.middlePointBearing, thisSlice.endPoint2, thisSlice.point2Bearing, interpPoint2, interpPoint2Bearing));
        }
        this.edgePoints = new GeoPoint[]{northPoint};
        this.circlePlanes = circlePlanes;
        if (circlePlanes.size() == 1) {
            this.eitherBounds = null;
            this.notableEdgePoints = null;
        } else {
            this.notableEdgePoints = notableEdgePoints;
            this.eitherBounds = new HashMap<SidedPlane, Membership>(circlePlanes.size());
            for (int i = 0; i < circlePlanes.size(); ++i) {
                SidedPlane thisPlane = (SidedPlane)circlePlanes.get(i);
                SidedPlane previousPlane = i == 0 ? (SidedPlane)circlePlanes.get(circlePlanes.size() - 1) : (SidedPlane)circlePlanes.get(i - 1);
                SidedPlane nextPlane = i == circlePlanes.size() - 1 ? (SidedPlane)circlePlanes.get(0) : (SidedPlane)circlePlanes.get(i + 1);
                this.eitherBounds.put(thisPlane, new EitherBound(previousPlane, nextPlane));
            }
        }
    }

    public GeoExactCircle(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.center.getLatitude());
        SerializableObject.writeDouble(outputStream, this.center.getLongitude());
        SerializableObject.writeDouble(outputStream, this.cutoffAngle);
        SerializableObject.writeDouble(outputStream, this.actualAccuracy);
    }

    @Override
    public double getRadius() {
        return this.cutoffAngle;
    }

    @Override
    public GeoPoint getCenter() {
        return this.center;
    }

    @Override
    protected double distance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.center, x, y, z);
    }

    @Override
    protected void distanceBounds(Bounds bounds, DistanceStyle distanceStyle, double distanceValue) {
        this.getBounds(bounds);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.circlePlanes == null) {
            return 0.0;
        }
        if (this.circlePlanes.size() == 1) {
            return distanceStyle.computeDistance(this.planetModel, (Plane)this.circlePlanes.get(0), x, y, z, new Membership[0]);
        }
        double outsideDistance = Double.POSITIVE_INFINITY;
        for (SidedPlane plane : this.circlePlanes) {
            Membership[] membershipArray = new Membership[]{this.eitherBounds.get(plane)};
            double distance = distanceStyle.computeDistance(this.planetModel, (Plane)plane, x, y, z, membershipArray);
            if (!(distance < outsideDistance)) continue;
            outsideDistance = distance;
        }
        return outsideDistance;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        if (this.circlePlanes == null) {
            return true;
        }
        for (Membership membership : this.circlePlanes) {
            if (membership.isWithin(x, y, z)) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        if (this.circlePlanes == null) {
            return false;
        }
        if (this.circlePlanes.size() == 1) {
            return this.circlePlanes.get(0).intersects(this.planetModel, p, notablePoints, circlePoints, bounds, new Membership[0]);
        }
        for (int edgeIndex = 0; edgeIndex < this.circlePlanes.size(); ++edgeIndex) {
            SidedPlane edge = this.circlePlanes.get(edgeIndex);
            GeoPoint[] points = this.notableEdgePoints.get(edgeIndex);
            if (!edge.intersects(this.planetModel, p, notablePoints, points, bounds, this.eitherBounds.get(edge))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        if (this.circlePlanes == null) {
            return false;
        }
        if (this.circlePlanes.size() == 1) {
            return geoShape.intersects(this.circlePlanes.get(0), circlePoints, new Membership[0]);
        }
        for (int edgeIndex = 0; edgeIndex < this.circlePlanes.size(); ++edgeIndex) {
            SidedPlane edge = this.circlePlanes.get(edgeIndex);
            GeoPoint[] points = this.notableEdgePoints.get(edgeIndex);
            if (!geoShape.intersects(edge, points, this.eitherBounds.get(edge))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        if (this.circlePlanes == null) {
            return;
        }
        bounds.addPoint(this.center);
        if (this.circlePlanes.size() == 1) {
            bounds.addPlane(this.planetModel, this.circlePlanes.get(0), new Membership[0]);
            return;
        }
        for (SidedPlane plane : this.circlePlanes) {
            bounds.addPlane(this.planetModel, plane, this.eitherBounds.get(plane));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoExactCircle)) {
            return false;
        }
        GeoExactCircle other = (GeoExactCircle)o;
        return super.equals(other) && other.center.equals(this.center) && other.cutoffAngle == this.cutoffAngle && other.actualAccuracy == this.actualAccuracy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.center.hashCode();
        long temp = Double.doubleToLongBits(this.cutoffAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.actualAccuracy);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoExactCircle: {planetmodel=" + this.planetModel + ", center=" + this.center + ", radius=" + this.cutoffAngle + "(" + this.cutoffAngle * 180.0 / Math.PI + "), accuracy=" + this.actualAccuracy + "}";
    }

    protected static class ApproximationSlice {
        public final SidedPlane plane;
        public final GeoPoint endPoint1;
        public final double point1Bearing;
        public final GeoPoint endPoint2;
        public final double point2Bearing;
        public final GeoPoint middlePoint;
        public final double middlePointBearing;

        public ApproximationSlice(GeoPoint center, GeoPoint endPoint1, double point1Bearing, GeoPoint endPoint2, double point2Bearing, GeoPoint middlePoint, double middlePointBearing) {
            this.endPoint1 = endPoint1;
            this.point1Bearing = point1Bearing;
            this.endPoint2 = endPoint2;
            this.point2Bearing = point2Bearing;
            this.middlePoint = middlePoint;
            this.middlePointBearing = middlePointBearing;
            this.plane = SidedPlane.constructNormalizedThreePointSidedPlane(center, endPoint1, endPoint2, middlePoint);
            if (this.plane == null) {
                throw new IllegalArgumentException("Either circle is too large to fit on ellipsoid or accuracy is too high; could not construct a plane with endPoint1=" + endPoint1 + " bearing " + point1Bearing + ", endPoint2=" + endPoint2 + " bearing " + point2Bearing + ", middle=" + middlePoint + " bearing " + middlePointBearing);
            }
        }
    }

    protected static class EitherBound
    implements Membership {
        protected final SidedPlane sideBound1;
        protected final SidedPlane sideBound2;

        public EitherBound(SidedPlane sideBound1, SidedPlane sideBound2) {
            this.sideBound1 = sideBound1;
            this.sideBound2 = sideBound2;
        }

        @Override
        public boolean isWithin(Vector v) {
            return this.sideBound1.isWithin(v) && this.sideBound2.isWithin(v);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return this.sideBound1.isWithin(x, y, z) && this.sideBound2.isWithin(x, y, z);
        }

        public String toString() {
            return "(" + this.sideBound1 + "," + this.sideBound2 + ")";
        }
    }
}

