/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.ResourceFactory;
import net.sf.freecol.common.resources.ResourceMapper;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;

public class FreeColDataFile {
    private static final Logger logger = Logger.getLogger(FreeColDataFile.class.getName());
    protected static final String ZIP_FILE_EXTENSION = "zip";
    private static final String RESOURCE_FILE_PREFIX = "resources";
    private static final String RESOURCE_FILE_SUFFIX = ".properties";
    private static final String resourceScheme = "resource:";
    private final File file;
    private final String jarDirectory;

    public FreeColDataFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File " + file.getName() + " does not exist");
        }
        this.file = file;
        this.jarDirectory = file.isDirectory() ? null : FreeColDataFile.findJarDirectory(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findJarDirectory(File file) {
        String expected = file.getName().substring(0, file.getName().lastIndexOf(46));
        try (JarFile jf = new JarFile(file);){
            JarEntry entry = jf.entries().nextElement();
            String en = entry.getName();
            int index = en.lastIndexOf(47);
            String name = "";
            if (index > 0) {
                name = en.substring(0, index + 1);
            }
            String string = name;
            return string;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while reading data file.", e);
            return expected;
        }
    }

    public static List<String> getFileNames(String prefix, String suffix, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        ArrayList<String> result = new ArrayList<String>(4);
        if (!language.isEmpty()) {
            language = "_" + language;
        }
        if (!country.isEmpty()) {
            country = "_" + country;
        }
        if (!variant.isEmpty()) {
            variant = "_" + variant;
        }
        result.add(prefix + suffix);
        String filename = prefix + language + suffix;
        if (!result.contains(filename)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + language + country + suffix)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + language + country + variant + suffix)) {
            result.add(filename);
        }
        return result;
    }

    public static List<String> getResourceFileNames() {
        return FreeColDataFile.getFileNames(RESOURCE_FILE_PREFIX, RESOURCE_FILE_SUFFIX, Locale.getDefault());
    }

    protected URI getURI(String name) {
        try {
            if (name.startsWith("urn:")) {
                try {
                    return new URI(name);
                }
                catch (URISyntaxException e) {
                    logger.log(Level.WARNING, "Resource creation failure with: " + name, e);
                    return null;
                }
            }
            if (this.file.isDirectory()) {
                return new File(this.file, name).toURI();
            }
            return new URI("jar:file", this.file + "!/" + this.jarDirectory + name, null);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "Failed to lookup: " + this.file + "/" + name, e);
            return null;
        }
    }

    public BufferedInputStream getInputStream(String filename) throws IOException {
        URLConnection connection = this.getURI(filename).toURL().openConnection();
        connection.setDefaultUseCaches(false);
        return new BufferedInputStream(connection.getInputStream());
    }

    public ResourceMapping getResourceMapping() {
        Properties properties = new Properties();
        LogBuilder lb = new LogBuilder(64);
        lb.add("Resource mapping");
        lb.mark();
        for (String fileName : FreeColDataFile.getResourceFileNames()) {
            try {
                BufferedInputStream is = this.getInputStream(fileName);
                Throwable throwable = null;
                try {
                    properties.load(is);
                    lb.add(", ", this.file, "/", fileName, " loaded");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e) {
                lb.add(", ", this.file, "/", fileName, " not found");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "ResourceMapping read exception: " + this.file + "/" + fileName, e);
                return null;
            }
        }
        ResourceMapping rc = new ResourceMapping();
        ArrayList<String> todo = new ArrayList<String>();
        Enumeration<?> pn = properties.propertyNames();
        ResourceMapper rm = new ResourceMapper(rc);
        while (pn.hasMoreElements()) {
            String key = (String)pn.nextElement();
            String value = properties.getProperty(key);
            if (value.startsWith(resourceScheme)) {
                todo.add(key);
                continue;
            }
            URI uri = this.getURI(value);
            if (uri == null) continue;
            rm.setKey(key);
            ResourceFactory.createResource(uri, rm);
        }
        boolean progress = true;
        ArrayList<String> miss = new ArrayList<String>();
        while (progress && !todo.isEmpty()) {
            miss.clear();
            progress = false;
            while (!todo.isEmpty()) {
                String key = (String)todo.remove(0);
                String value = properties.getProperty(key).substring(resourceScheme.length());
                if (!rc.duplicateResource(value, key)) {
                    miss.add(key);
                    continue;
                }
                progress = true;
            }
            todo.addAll(miss);
        }
        if (!todo.isEmpty()) {
            lb.add(", could not resolve virtual resource/s: ", StringUtils.join(" ", todo));
        }
        if (lb.grew(new Object[0])) {
            lb.log(logger, Level.INFO);
        }
        return rc;
    }

    public static FileFilter makeFileFilter(String requiredFile, String ... endings) {
        return f -> {
            String name = f.getName();
            return name.startsWith(".") ? false : (requiredFile != null && f.isDirectory() ? new File(f, requiredFile).exists() : CollectionUtils.any(endings, e -> name.endsWith("." + e) && name.length() > e.length()));
        };
    }
}

