/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

public class FileOption
extends AbstractOption<File> {
    private static final Logger logger = Logger.getLogger(FileOption.class.getName());
    private File value = null;

    public FileOption(Specification specification) {
        super(specification);
    }

    @Override
    public FileOption clone() {
        FileOption result = new FileOption(this.getSpecification());
        result.setValues(this);
        return result;
    }

    @Override
    public File getValue() {
        return this.value;
    }

    @Override
    public void setValue(File value) {
        File oldValue = this.value;
        this.value = value;
        if (value != oldValue) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.value = valueString != null ? new File(valueString) : (defaultValueString != null ? new File(defaultValueString) : null);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value.getAbsolutePath());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" value=").append(this.value == null ? "null" : this.value.getName()).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return FileOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "fileOption";
    }
}

