/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AddWordAction;
import com.inet.jortho.Dictionary;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Suggestion;
import com.inet.jortho.Tokenizer;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckerListener
implements PopupMenuListener,
LanguageChangeListener {
    private final JComponent menu;
    private Dictionary dictionary;
    private Locale locale;
    private final SpellCheckerOptions options;

    public CheckerListener(JComponent jComponent, SpellCheckerOptions spellCheckerOptions) {
        this.menu = jComponent;
        this.options = spellCheckerOptions == null ? SpellChecker.getOptions() : spellCheckerOptions;
        SpellChecker.addLanguageChangeLister(this);
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (this.dictionary == null) {
            this.menu.setEnabled(false);
            return;
        }
        JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
        Component component = jPopupMenu.getInvoker();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            if (!jTextComponent.isEditable()) {
                this.menu.setEnabled(false);
                return;
            }
            try {
                String string;
                int n = this.getCursorPosition(jTextComponent);
                if (n < 0) {
                    this.menu.setEnabled(false);
                    return;
                }
                int n2 = Utilities.getWordStart(jTextComponent, n);
                int n3 = Utilities.getWordEnd(jTextComponent, n);
                String string2 = jTextComponent.getText(n2, n3 - n2);
                Tokenizer tokenizer = new Tokenizer(jTextComponent, this.dictionary, this.locale, n, this.options);
                do {
                    string = tokenizer.nextInvalidWord();
                } while (tokenizer.getWordOffset() < n2);
                this.menu.removeAll();
                if (!string2.equals(string)) {
                    this.menu.setEnabled(false);
                    return;
                }
                List<Suggestion> list = this.dictionary.searchSuggestions(string2);
                this.menu.setEnabled(list.size() > 0);
                boolean bl = tokenizer.isFirstWordInSentence() && Utils.isFirstCapitalized(string2);
                this.addSuggestionMenuItem(jTextComponent, n2, n3, list, bl);
                this.addMenuItemAddToDictionary(jTextComponent, string2, list.size() > 0);
            }
            catch (BadLocationException badLocationException) {
                SpellChecker.getMessageHandler().handleException(badLocationException);
            }
        }
    }

    protected int getCursorPosition(JTextComponent jTextComponent) throws BadLocationException {
        int n;
        Caret caret = jTextComponent.getCaret();
        Point point = jTextComponent.getMousePosition();
        if (point != null) {
            n = jTextComponent.viewToModel(point);
            int n2 = Utilities.getRowStart(jTextComponent, n);
            int n3 = Utilities.getRowEnd(jTextComponent, n);
            Rectangle rectangle = jTextComponent.modelToView(n2).union(jTextComponent.modelToView(n3));
            if (!rectangle.contains(point)) {
                return -1;
            }
        } else {
            n = Math.min(caret.getDot(), caret.getMark());
        }
        Document document = jTextComponent.getDocument();
        if (n > 0 && (n >= document.getLength() || Character.isWhitespace(document.getText(n, 1).charAt(0)))) {
            --n;
        }
        return n;
    }

    protected void addSuggestionMenuItem(final JTextComponent jTextComponent, final int n, final int n2, List<Suggestion> list, boolean bl) {
        for (int i = 0; i < list.size() && i < this.options.getSuggestionsLimitMenu(); ++i) {
            Suggestion suggestion = list.get(i);
            String string = suggestion.getWord();
            if (bl) {
                string = Utils.getCapitalized(string);
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            this.menu.add(jMenuItem);
            final String string2 = string;
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.setSelectionEnd(n2);
                    jTextComponent.replaceSelection(string2);
                }
            });
        }
    }

    protected void addMenuItemAddToDictionary(JTextComponent jTextComponent, String string, boolean bl) {
        UserDictionaryProvider userDictionaryProvider = SpellChecker.getUserDictionaryProvider();
        if (userDictionaryProvider == null) {
            return;
        }
        JMenuItem jMenuItem = new JMenuItem(new AddWordAction(jTextComponent, string));
        if (bl) {
            if (this.menu instanceof JMenu) {
                ((JMenu)this.menu).addSeparator();
            } else if (this.menu instanceof JPopupMenu) {
                ((JPopupMenu)this.menu).addSeparator();
            }
        }
        this.menu.add(jMenuItem);
        this.menu.setEnabled(true);
    }

    @Override
    public void languageChanged(LanguageChangeEvent languageChangeEvent) {
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
    }
}

