/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.ModeControllerHookAdapter;
import freemind.view.mindmapview.MapView;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class FitToPage
extends ModeControllerHookAdapter {
    private MapView view;

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        this.view = this.getController().getView();
        if (this.view == null) {
            return;
        }
        this.zoom();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FitToPage.this.scroll();
            }
        });
    }

    private int shift(int coord1, int size1, int coord2, int size2) {
        return coord1 - coord2 + (size1 - size2) / 2;
    }

    private void scroll() {
        Rectangle rect = this.view.getInnerBounds();
        Rectangle viewer = this.view.getVisibleRect();
        this.view.scrollBy(this.shift(rect.x, rect.width, viewer.x, viewer.width), this.shift(rect.y, rect.height, viewer.y, viewer.height));
    }

    private void zoom() {
        Rectangle rect = this.view.getInnerBounds();
        double oldZoom = this.getController().getView().getZoom();
        JViewport viewPort = (JViewport)this.view.getParent();
        JScrollPane pane = (JScrollPane)viewPort.getParent();
        Dimension viewer = viewPort.getExtentSize();
        this.logger.info("Found viewer rect=" + viewer.height + "/" + rect.height + ", " + viewer.width + "/" + rect.width);
        double newZoom = (double)viewer.width * oldZoom / ((double)rect.width + 0.0);
        double heightZoom = (double)viewer.height * oldZoom / ((double)rect.height + 0.0);
        if (heightZoom < newZoom) {
            newZoom = heightZoom;
        }
        this.logger.info("Calculated new zoom " + newZoom);
        this.getController().getController().setZoom((float)newZoom);
    }
}

