/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.extensions.MindMapHook;
import freemind.main.Resources;
import freemind.modes.ModeController;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

public class HookAdapter
implements MindMapHook {
    private String name;
    private Properties properties;
    private ModeController controller;
    protected Logger logger;
    private MindMapHook.PluginBaseClassSearcher baseClass;

    public HookAdapter() {
        if (this.logger == null) {
            this.logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.baseClass = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void startupMapHook() {
    }

    @Override
    public void shutdownMapHook() {
        this.controller = null;
    }

    protected ModeController getController() {
        return this.controller;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setController(ModeController controller) {
        this.controller = controller;
    }

    @Override
    public String getResourceString(String property) {
        String result = this.properties.getProperty(property);
        if (result == null) {
            result = this.getController().getText(property);
        }
        if (result == null) {
            this.logger.warning("The following property was not found:" + property);
        }
        return result;
    }

    public URL getResource(String resourceName) {
        return this.getClass().getClassLoader().getResource(resourceName);
    }

    @Override
    public Object getPluginBaseClass() {
        return this.baseClass.getPluginBaseObject();
    }

    @Override
    public void setPluginBaseClass(MindMapHook.PluginBaseClassSearcher baseClass) {
        this.baseClass = baseClass;
    }

    protected void obtainFocusForSelected() {
        this.getController().getController().obtainFocusForSelected();
    }
}

