/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.filter.util.SortedMapListModel;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.NodeAttributeTableModel;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;

public class MapRegistry {
    private SortedMapListModel mapIcons;
    private AttributeRegistry attributes;
    private MindMap map;
    private ModeController modeController;

    public MapRegistry(MindMap map, ModeController modeController) {
        this.map = map;
        this.modeController = modeController;
        this.mapIcons = new SortedMapListModel();
        this.attributes = new AttributeRegistry(this);
    }

    public void addIcon(MindIcon icon) {
        this.mapIcons.add(icon);
    }

    public SortedMapListModel getIcons() {
        return this.mapIcons;
    }

    public AttributeRegistry getAttributes() {
        return this.attributes;
    }

    public void registrySubtree(MindMapNode root, boolean registerMyself) {
        if (registerMyself) {
            this.registryNodeIcons(root);
            this.registryAttributes(root);
        }
        ListIterator iterator = root.childrenUnfolded();
        while (iterator.hasNext()) {
            MindMapNode node = (MindMapNode)iterator.next();
            this.registrySubtree(node, true);
        }
    }

    private void registryAttributes(MindMapNode node) {
        NodeAttributeTableModel model = node.getAttributes();
        if (model == null) {
            return;
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            this.attributes.registry(model.getAttribute(i));
        }
    }

    public void registryNodeIcons(MindMapNode node) {
        List icons = node.getIcons();
        for (MindIcon icon : icons) {
            this.addIcon(icon);
        }
    }

    public MindMap getMap() {
        return this.map;
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public void save(Writer fileout) throws IOException {
        this.getAttributes().save(fileout);
    }
}

