/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.DeleteNodeAction;
import freemind.controller.actions.generated.instance.NewNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.PermanentNodeHook;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.view.mindmapview.NodeView;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class NewChildAction
extends AbstractAction
implements ActorXml {
    private final MindMapController c;
    private static Logger logger = null;

    public NewChildAction(MindMapController modeController) {
        super(modeController.getText("new_child"), new ImageIcon(modeController.getResource("images/idea.png")));
        this.c = modeController;
        this.c.getActionFactory().registerActor(this, this.getDoActionClass());
        if (logger == null) {
            logger = this.c.getFrame().getLogger(NewChildAction.class.getName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.c.addNew(this.c.getSelected(), 2, null);
    }

    @Override
    public void act(XmlAction action) {
        NewNodeAction addNodeAction = (NewNodeAction)action;
        NodeAdapter parent = this.c.getNodeFromID(addNodeAction.getNode());
        int index = addNodeAction.getIndex();
        MindMapNode newNode = this.c.newNode("", parent.getMap());
        newNode.setLeft(addNodeAction.getPosition().equals("left"));
        String newId = addNodeAction.getNewId();
        String givenId = this.c.getModel().getLinkRegistry().registerLinkTarget(newNode, newId);
        if (!givenId.equals(newId)) {
            throw new IllegalArgumentException("Designated id '" + newId + "' was not given to the node. It received '" + givenId + "'.");
        }
        this.c.insertNodeInto(newNode, parent, index);
        for (PermanentNodeHook hook : parent.getActivatedHooks()) {
            hook.onNewChild(newNode);
        }
    }

    @Override
    public Class getDoActionClass() {
        return NewNodeAction.class;
    }

    public MindMapNode addNew(MindMapNode target, int newNodeMode, KeyEvent e) {
        MindMapNode targetNode = target;
        MindMapNode newNode = null;
        switch (newNodeMode) {
            case 3: 
            case 4: {
                if (!targetNode.isRoot()) {
                    MindMapNode parent = targetNode.getParentNode();
                    int childPosition = parent.getChildPosition(targetNode);
                    if (newNodeMode == 3) {
                        ++childPosition;
                    }
                    newNode = this.addNewNode(parent, childPosition, targetNode.isLeft());
                    NodeView nodeView = this.c.getNodeView(newNode);
                    this.c.select(nodeView);
                    this.c.edit.edit(nodeView, this.c.getNodeView(target), e, true, false, false);
                    break;
                }
                newNodeMode = 2;
            }
            case 1: 
            case 2: {
                boolean parentFolded = targetNode.isFolded();
                if (parentFolded) {
                    this.c.setFolded(targetNode, false);
                }
                int position = this.c.getFrame().getProperty("placenewbranches").equals("last") ? targetNode.getChildCount() : 0;
                newNode = this.addNewNode(targetNode, position);
                NodeView nodeView = this.c.getNodeView(newNode);
                if (newNodeMode == 2) {
                    this.c.select(nodeView);
                }
                this.c.edit.edit(nodeView, this.c.getNodeView(target), e, true, parentFolded, false);
                break;
            }
        }
        return newNode;
    }

    public MindMapNode addNewNode(MindMapNode parent, int index) {
        return this.addNewNode(parent, index, parent.isNewChildLeft());
    }

    public MindMapNode addNewNode(MindMapNode parent, int index, boolean newNodeIsLeft) {
        if (index == -1) {
            index = parent.getChildCount();
        }
        this.c.getModel().getLinkRegistry().registerLinkTarget(parent);
        String newId = this.c.getModel().getLinkRegistry().generateUniqueID(null);
        NewNodeAction newNodeAction = this.getAddNodeAction(parent, index, newId, newNodeIsLeft);
        DeleteNodeAction deleteAction = this.c.deleteChild.getDeleteNodeAction(newId);
        this.c.doTransaction(this.c.getText("new_child"), new ActionPair((XmlAction)newNodeAction, (XmlAction)deleteAction));
        return (MindMapNode)parent.getChildAt(index);
    }

    public NewNodeAction getAddNodeAction(MindMapNode parent, int index, String newId, boolean newNodeIsLeft) {
        String pos = newNodeIsLeft ? "left" : "right";
        NewNodeAction newNodeAction = new NewNodeAction();
        newNodeAction.setNode(this.c.getNodeID(parent));
        newNodeAction.setPosition(pos);
        newNodeAction.setIndex(index);
        newNodeAction.setNewId(newId);
        return newNodeAction;
    }
}

