/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.FileHeader;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.RunProxy;
import org.mozilla.javascript.tools.debugger.SwingGui;

class FileWindow
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = -6212382604952082370L;
    private SwingGui debugGui;
    private Dim.SourceInfo sourceInfo;
    FileTextArea textArea;
    private FileHeader fileHeader;
    private JScrollPane p;
    int currentPos;
    private JLabel statusBar;

    void load() {
        String string = this.getUrl();
        if (string != null) {
            RunProxy runProxy = new RunProxy(this.debugGui, 2);
            runProxy.fileName = string;
            runProxy.text = this.sourceInfo.source();
            new Thread(runProxy).start();
        }
    }

    public int getPosition(int n) {
        int n2 = -1;
        try {
            n2 = this.textArea.getLineStartOffset(n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n2;
    }

    public boolean isBreakPoint(int n) {
        return this.sourceInfo.breakableLine(n) && this.sourceInfo.breakpoint(n);
    }

    public void toggleBreakPoint(int n) {
        if (!this.isBreakPoint(n)) {
            this.setBreakPoint(n);
        } else {
            this.clearBreakPoint(n);
        }
    }

    public void setBreakPoint(int n) {
        boolean bl;
        if (this.sourceInfo.breakableLine(n) && (bl = this.sourceInfo.breakpoint(n, true))) {
            this.fileHeader.repaint();
        }
    }

    public void clearBreakPoint(int n) {
        boolean bl;
        if (this.sourceInfo.breakableLine(n) && (bl = this.sourceInfo.breakpoint(n, false))) {
            this.fileHeader.repaint();
        }
    }

    public FileWindow(SwingGui swingGui, Dim.SourceInfo sourceInfo) {
        super(SwingGui.getShortName(sourceInfo.url()), true, true, true, true);
        this.debugGui = swingGui;
        this.sourceInfo = sourceInfo;
        this.updateToolTip();
        this.currentPos = -1;
        this.textArea = new FileTextArea(this);
        this.textArea.setRows(24);
        this.textArea.setColumns(80);
        this.p = new JScrollPane();
        this.fileHeader = new FileHeader(this);
        this.p.setViewportView(this.textArea);
        this.p.setRowHeaderView(this.fileHeader);
        this.setContentPane(this.p);
        this.pack();
        this.updateText(sourceInfo);
        this.textArea.select(0);
    }

    private void updateToolTip() {
        Component component = this.getComponent(1);
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.getUrl());
        }
    }

    public String getUrl() {
        return this.sourceInfo.url();
    }

    public void updateText(Dim.SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        String string = sourceInfo.source();
        if (!this.textArea.getText().equals(string)) {
            this.textArea.setText(string);
            int n = 0;
            if (this.currentPos != -1) {
                n = this.currentPos;
            }
            this.textArea.select(n);
        }
        this.fileHeader.update();
        this.fileHeader.repaint();
    }

    public void setPosition(int n) {
        this.textArea.select(n);
        this.currentPos = n;
        this.fileHeader.repaint();
    }

    public void select(int n, int n2) {
        int n3 = this.textArea.getDocument().getLength();
        this.textArea.select(n3, n3);
        this.textArea.select(n, n2);
    }

    public void dispose() {
        this.debugGui.removeWindow(this);
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("Cut")) {
            if (string.equals("Copy")) {
                this.textArea.copy();
            } else if (string.equals("Paste")) {
                // empty if block
            }
        }
    }
}

