# <#GAPDoc Label="Groebner1">
# <Subsection Label="Groebner">
# <Heading>Defining ideal of toric variety</Heading>
# We want to compute the groebner basis of the ideal
# defining the affine toric variety associated to the cone
# generated by the inequalities [ [ 7, -1 ], [ 0, 1 ] ], 
# i.e. a rational normal curve.
# <Example>
# <![CDATA[
# gap> LoadPackage( "4ti2Interface" );
# true
# gap> cone := [ [ 7, -1 ], [ 0, 1 ] ];
# [ [ 7, -1 ], [ 0, 1 ] ]
# gap> basis := 4ti2Interface_hilbert_inequalities( cone );;
# gap> groebner := 4ti2Interface_groebner_matrix( basis );;
# gap> time;
# 0
# gap> Length( groebner );
# 21
# ]]></Example></Subsection>
# <#/GAPDoc> 

LoadPackage( "4ti2Interface" );
cone := [ [ 7, -1 ], [ 0, 1 ] ];
basis := 4ti2Interface_hilbert_inequalities( cone );;
groebner := 4ti2Interface_groebner_matrix( basis );;
time;
Length( groebner );
