##########################################################################
##
#W  canbas.gd                  QuaGroup                     Willem de Graaf
##
##
##  Declarations for operations, attributes connected to canonical bases.
##

#1
##  Functions for computing elements of the canonical basis of 
##  a quantized uea.

##########################################################################
##
#C  IsCanonicalBasisOfQuantumUEA( <obj> )
##
DeclareCategory( "IsCanonicalBasisOfQuantumUEA", IsObject );

###########################################################################
##
#O  PBWElements( <B>, <rt> )
##
##  Here <B> is the canonical basis of a quantized uea, and `rt' a list
##  of non-negative integers representing a positive element of the 
##  root lattice. This function returns the elements of <B>, of weight <rt>
##  (written as linear combinations of the elements of the PBW-basis).
##
DeclareOperation( "PBWElements", [ IsCanonicalBasisOfQuantumUEA, IsList ] );

############################################################################
##
#O  MonomialElements( <B>, <rt> )
##
##  This does the same as `PBWElements', except that the elements are
##  written as linear combinations of monomials in the generators.
##
DeclareOperation( "MonomialElements", [IsCanonicalBasisOfQuantumUEA,IsList ]);

###########################################################################
##
#O  Strings( <B>, <rt> )
##
##  Adapted strings corresponding to the elements of the canonical basis.
##  Here a string like `[ 1, 2, 2, 3 ]' corresponds to the string
##  $\tilde{F}_1^2\tilde{F}_2^3 \cdot 1$, where $\tilde{F}_i$ is the
##  $i$-th Kashiwara operator. If an element like that occurs on the
##  `k'-th position of the output of `Strings( <B>, <rt> )' then
##  the crystal element of the `k'-th element of `PBWElements( <B>, <rt> )'
##  is given by this string. (BETTER description!!). 
##
DeclareOperation( "Strings", [IsCanonicalBasisOfQuantumUEA,IsList ]);


#############################################################################
##
#A  CrystalBasis( <V> )
##
##  Here <V> is a finite-dimensional left module over a quantized enveloping
##  algebra. This function returns a basis of <V> that is also a basis
##  over ${\bf Z}[q]$ of the ${\bf Z}[q]$-lattice generated by all
##  $\tilde{F}_{\alpha_{i_1}}\cdots \tilde{F}_{\alpha_{i_r}}\cdot v_0$.
##  REM: only works if the basis vectors of Basis(<V>) are all weight
##  vectors! (Usually the case).
##
DeclareAttribute( "CrystalBasis", IsAlgebraModule );

############################################################################
##
#C  IsCrystalVector( <obj> )
##
## Category of crystal vectors.
##
DeclareCategory( "IsCrystalVector", IsObject );

############################################################################
##
#A  PBWMonomial( <v> )
##
##  A crystal vector always has the form `m^v0', where v0 is a highest
##  weight vector, and `m' a PBW-monomial. This function returns that
##  monomial.
DeclareAttribute( "PBWMonomial", IsCrystalVector );

#############################################################################
##
#A  CrystalVectors( <V> )
##
##  Here <V> is a finite-dimensional left module over a quantized enveloping
##  algebra.
##  Let <B> be the crystal basis of <V> (i.e., output by `CrystalBasis').
##  This function returns a list of cosets of the basis elements of
##  <B> mod $q L(\lambda)$.
##
DeclareAttribute( "CrystalVectors", IsAlgebraModule );

############################################################################
##
#O  StringMonomial( <mon> )
##
##  Computes the "string" corresponding to the PBW-monomial <mon>. 
##  
##  
DeclareOperation( "StringMonomial", [ IsQEAElement ] );

############################################################################
##
#O  PrincipalMonomial( <p> )
##
##  Computes the principal monomial of an element of the canonical basis.
##  
##  
DeclareOperation( "PrincipalMonomial", [ IsQEAElement ] );
