#############################################################################
##
#W  orbitgrowthtype.g             GAP4 Package `RCWA'             Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing list of
##  orbit growth types, as far as known.
##
##  Given an index i, the entry orbitgrowthtype[i] provides information on
##  the orbit growth functions of the group grps[i], thus whether they grow
##  linearly or exponentially, or whether they are bounded, or whether
##  the orbits are all finite or even the group is finite altogether.
##  The entry may be an integer, in which case the meaning is given by
##  trsstatusset[orbitgrowthtype[i]], or it may be a list of integers
##  with the same meaning if the group has infinite orbits with different
##  growth types. Note that the data has been obtained by heuristic means,
##  and thus there may be errors.
##
#############################################################################

return
[5,5,5,5,5,[16,20],5,5,16,5,16,[16,20],5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,20,16,20,
 5,5,20,5,16,5,20,5,16,16,5,5,16,16,20,11,20,20,11,20,
 20,11,20,20,20,20,11,5,5,5,5,16,5,5,[16,20],5,
 [16,20],16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,16,5,
 5,5,5,5,20,20,20,16,16,5,5,20,5,20,5,5,5,20,20,20,20,
 20,16,16,20,20,20,20,11,20,20,11,11,11,20,20,5,5,5,7,5,
 5,7,5,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,7,7,5,5,
 5,7,5,7,7,7,7,7,5,5,7,5,7,5,7,5,7,7,7,7,7,7,7,6,6,
 6,6,6,7,7,7,6,7,7,7,5,5,20,5,5,20,5,20,20,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,20,20,20,
 5,5,20,5,20,5,5,5,20,20,5,5,20,20,20,11,11,11,11,11,11,
 11,11,11,11,11,11,5,7,5,5,7,5,7,7,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,15,16,5,5,5,20,5,20,20,15,16,16,5,5,
 [15,20],5,16,5,20,5,16,[15,20],20,20,16,16,16,20,20,
 20,20,20,20,20,20,20,20,20,20,7,5,5,7,5,7,7,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,15,16,5,5,5,20,5,20,20,15,16,
 16,5,5,[15,20],5,16,5,20,5,16,[15,20],20,20,16,16,16,
 20,20,20,20,20,20,20,20,20,20,20,20,20,7,7,7,7,20,
 [16,20],16,16,[16,20],16,16,[16,20],[16,20],7,16,20,
 16,16,20,16,16,7,15,[16,20],[16,20],7,7,7,[15,20],
 [15,20],15,7,15,20,[16,20],7,[16,20],7,7,7,7,
 [16,20],[16,20],16,16,7,7,15,15,7,7,15,7,16,16,16,7,
 16,16,16,5,20,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,20,5,5,5,5,5,5,5,20,20,20,5,5,20,5,20,5,5,5,20,
 20,5,5,20,20,20,11,11,11,11,11,11,11,11,11,11,11,11,7,5,
 7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,16,5,5,5,20,
 5,20,20,15,16,16,5,5,[15,20],5,16,5,20,5,16,[15,20],
 20,20,16,16,16,20,20,20,20,20,20,20,20,20,20,20,20,7,20,
 7,[16,20],[16,20],[16,20],16,16,7,[16,20],16,16,16,
 20,[16,20],[16,20],20,[16,20],[16,20],[16,20],
 [16,20],16,16,7,16,7,[15,20],[15,20],7,7,7,20,16,15,
 16,15,7,16,7,15,7,7,7,15,7,7,16,16,16,16,[16,20],7,7,
 15,[16,20],15,7,7,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,15,16,5,5,5,20,5,20,20,15,16,16,5,5,[15,20],5,16,
 5,20,5,16,[15,20],20,20,16,16,16,20,20,20,20,20,20,20,
 20,20,20,20,20,7,[16,20],[16,20],[16,20],16,16,7,
 [16,20],16,16,16,20,[16,20],[16,20],20,[16,20],
 [16,20],[16,20],[16,20],16,16,7,16,7,[15,20],
 [15,20],7,7,7,20,16,15,16,15,7,16,7,15,7,7,7,15,7,7,
 16,16,16,16,[16,20],7,7,15,[16,20],15,7,7,[16,20],16,
 16,[16,20],16,16,[16,20],[16,20],7,16,20,16,16,20,16,
 16,7,15,[16,20],[16,20],7,7,7,[15,20],[15,20],15,7,
 15,20,[16,20],7,[16,20],7,7,7,7,[16,20],[16,20],16,
 16,7,7,15,15,7,7,15,7,16,16,16,7,16,16,16,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,[15,20],[16,20],5,5,5,20,5,5,5,
 [16,20],16,[16,20],5,5,[16,20],5,[16,20],5,20,5,15,
 15,20,20,[16,20],16,[16,20],20,13,13,20,12,12,13,12,12,
 12,12,13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],
 [15,20],5,5,5,5,5,20,20,[16,20],[16,20],16,5,5,15,5,
 [16,20],5,5,5,[16,20],[16,20],20,20,[16,20],
 [16,20],16,13,20,20,13,13,13,20,12,13,12,13,20,5,5,5,5,
 5,5,5,5,5,5,5,5,5,16,16,5,5,5,20,5,20,20,[16,20],16,
 16,5,5,16,5,[16,20],5,20,5,16,16,20,20,[16,20],16,16,
 20,20,20,20,13,13,20,20,13,20,13,20,5,5,5,5,5,5,5,5,5,
 5,5,5,[16,20],[16,20],5,5,5,20,5,20,20,15,[16,20],
 [16,20],5,5,[16,20],5,16,5,20,5,[15,20],[16,20],5,
 5,16,[16,20],[16,20],12,13,13,12,20,20,13,13,20,13,20,
 13,5,5,5,5,5,5,5,5,5,5,5,[16,20],16,5,5,5,20,5,20,
 20,16,[16,20],16,5,5,16,5,16,5,20,5,16,[16,20],20,20,
 16,[16,20],16,13,20,20,13,20,20,20,13,20,13,20,20,5,5,
 5,5,5,5,5,5,5,5,[16,20],16,5,5,5,5,5,20,20,[16,20],
 16,16,5,5,16,5,16,5,5,5,[16,20],[16,20],20,20,16,16,
 16,14,20,20,14,14,14,20,14,14,14,14,20,5,5,5,5,5,5,5,5,
 5,15,15,5,5,5,20,5,5,5,[16,20],16,[16,20],5,5,
 [16,20],5,[16,20],5,20,5,[16,20],[15,20],20,20,
 [16,20],16,[16,20],12,12,12,12,13,13,12,20,13,20,13,12,
 5,5,5,5,5,5,5,5,16,16,5,5,5,20,5,20,20,16,16,[16,20],
 5,5,[16,20],5,16,5,20,5,16,16,20,20,16,16,[16,20],20,
 13,13,20,20,20,13,20,20,20,20,13,5,5,5,5,5,5,5,
 [16,20],[16,20],5,5,5,20,5,20,20,16,16,16,5,5,
 [16,20],5,16,5,20,5,16,[16,20],5,5,16,16,16,14,14,14,
 14,20,20,14,14,20,14,20,14,5,5,5,5,5,5,[16,20],16,5,5,
 5,[15,20],5,20,20,16,16,16,5,5,16,5,16,5,[15,20],5,
 16,[16,20],15,15,16,16,16,19,16,16,19,16,16,16,19,16,19,
 16,16,5,5,5,5,5,20,20,5,5,5,5,5,5,5,20,20,20,5,5,20,
 5,20,5,5,5,20,20,5,5,20,20,20,11,11,11,11,11,11,11,11,
 11,11,11,11,5,5,5,5,16,16,5,5,5,5,5,20,20,20,16,16,5,
 5,20,5,20,5,5,5,20,20,20,20,20,16,16,20,20,20,20,11,20,
 20,11,11,11,20,20,5,5,5,16,16,5,5,5,5,5,20,20,20,16,16,
 5,5,20,5,20,5,5,5,20,20,20,20,20,16,16,20,20,20,20,11,
 20,20,11,11,11,20,20,5,5,20,20,5,5,5,5,5,5,5,20,20,20,
 5,5,20,5,20,5,5,5,20,20,5,5,20,20,20,11,11,11,11,11,11,
 11,11,11,11,11,11,5,16,16,5,5,5,5,5,20,20,20,16,16,5,5,
 20,5,20,5,5,5,20,20,20,20,20,16,16,20,20,20,20,11,20,20,
 11,11,11,20,20,16,16,5,5,5,5,5,20,20,20,16,16,5,5,20,5,
 20,5,5,5,20,20,20,20,20,16,16,20,20,20,20,11,20,20,11,
 11,11,20,20,16,20,20,20,20,20,20,20,15,7,16,20,20,20,20,
 [15,20],20,20,20,[15,20],7,16,16,[15,20],7,16,16,16,
 16,16,20,16,[15,16],20,20,20,16,[15,16],20,20,20,20,20,
 16,16,20,16,7,20,20,15,20,15,20,20,20,20,15,7,7,15,16,7,
 16,16,16,16,20,16,16,20,20,20,16,16,5,5,20,5,20,20,20,
 16,20,5,5,20,5,16,5,20,5,16,16,5,5,16,16,20,11,20,20,
 11,20,20,11,20,20,20,20,11,5,20,5,20,20,20,16,20,5,5,20,
 5,16,5,20,5,16,16,5,5,16,16,20,11,20,20,11,20,20,11,20,
 20,20,20,11,20,5,5,5,16,20,16,5,5,16,5,16,5,20,5,20,20,
 20,20,16,20,16,20,11,11,20,20,11,20,20,20,20,11,20,20,20,
 20,16,16,16,5,20,20,20,7,20,5,20,7,16,20,20,7,16,16,16,
 13,13,16,20,[16,20],12,20,20,20,[16,20],12,5,5,16,20,
 16,5,5,16,5,16,5,20,5,20,20,20,20,16,20,16,20,11,11,20,
 20,11,20,20,20,20,11,20,5,20,7,16,5,20,20,20,16,5,20,5,
 16,20,20,20,16,7,16,13,20,20,13,[16,20],20,[16,20],12,
 [16,20],12,20,[16,20],20,7,16,5,20,20,20,16,5,20,5,16,
 20,20,20,16,7,16,13,20,20,13,[16,20],20,[16,20],12,
 [16,20],12,20,[16,20],15,7,20,20,16,20,16,16,16,16,
 [15,20],20,20,20,16,15,7,16,20,20,16,16,20,16,16,16,16,
 20,16,16,20,16,[15,20],16,16,20,16,20,16,7,16,16,16,20,
 16,16,7,7,16,16,7,16,16,16,16,7,16,20,20,16,20,16,16,16,
 16,[15,20],15,9,9,16,16,20,15,[15,16,20],[15,16,20],
 15,[15,16,20],[16,20],7,[16,20],[15,16,20],[16,20],
 [16,20],7,5,20,5,20,5,5,5,20,20,5,5,20,20,20,11,11,11,
 11,11,11,11,11,11,11,11,11,20,5,16,5,20,5,16,16,5,5,16,
 16,20,11,20,20,11,20,20,11,20,20,20,20,11,20,6,16,20,16,
 20,[15,20],16,16,6,[15,20],16,16,20,20,16,16,20,16,16,
 16,16,20,16,16,5,20,5,16,16,5,5,16,16,20,11,20,20,11,20,
 20,11,20,20,20,20,11,16,7,16,6,16,16,16,20,16,16,
 [16,20],[16,20],[16,20],[16,20],7,[15,16,20],
 [15,16,20],15,7,15,[15,16,20],[15,16,20],20,5,20,20,
 20,20,16,20,16,20,11,11,20,20,11,20,20,20,20,11,20,20,7,
 16,20,20,7,16,16,16,13,13,16,20,[16,20],12,20,20,20,
 [16,20],12,20,20,20,20,16,20,16,20,11,11,20,20,11,20,20,
 20,20,11,20,16,20,20,6,16,[15,20],20,16,16,20,16,16,20,
 16,16,16,16,20,20,20,16,7,15,20,16,16,20,[15,16,20],16,
 20,16,[15,16,20],16,16,20,5,16,16,9,20,[16,20],
 [16,20],20,12,12,20,16,12,16,12,20,16,16,9,20,[16,20],
 [16,20],20,12,12,20,16,12,16,12,20,16,16,[16,20],
 [16,20],[16,20],[16,20],7,[15,16,20],[15,16,20],15,
 7,15,[15,16,20],[15,16,20],16,16,7,7,16,16,7,16,16,16,
 16,7,16,15,[15,16,20],[15,16,20],15,[15,16,20],
 [16,20],7,[16,20],[15,16,20],[16,20],[16,20],7,20,
 20,11,20,20,20,20,20,20,20,20,11,20,20,20,20,20,20,20,20,
 20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
 20,20,11,20,20,20,20,20,20,20,11,20,20,20,20,20,11,20,11,
 20,20,20,20,20,20,20,20,5,5,5,5,15,5,5,[15,20],5,
 [15,20],15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,
 5,5,20,5,20,20,20,20,16,5,5,20,5,20,5,20,5,20,20,20,20,
 16,20,20,20,11,11,11,20,11,20,11,11,20,11,11,5,5,5,15,5,
 5,[15,20],5,[15,20],15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,20,20,5,5,5,20,5,20,20,20,20,16,5,5,20,5,20,5,20,
 5,20,20,20,20,16,20,20,20,11,11,11,20,11,20,11,11,20,11,
 11,5,5,[16,20],5,5,5,5,5,[16,20],5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,20,[15,20],20,5,
 5,5,5,20,5,5,5,20,20,5,5,16,5,20,11,20,11,11,20,11,11,
 5,11,11,5,11,5,[16,20],5,5,5,5,15,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,20,20,
 [15,20],5,5,20,5,5,5,20,5,5,5,20,20,20,20,[15,20],11,
 11,11,20,11,11,20,11,5,11,5,11,20,5,5,20,5,15,15,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,15,5,5,5,[15,20],5,
 [15,20],20,15,16,16,5,5,5,5,5,5,5,5,5,5,20,20,16,20,
 [16,20],20,20,20,11,11,20,20,5,5,20,5,20,20,15,15,16,
 16,[16,20],[16,20],20,16,[16,20],16,16,[15,20],
 [16,20],[16,20],[16,20],20,20,20,20,16,16,20,[15,20],
 20,20,16,15,16,15,20,[15,20],16,16,20,20,20,20,20,20,20,
 20,20,20,[16,20],[16,20],7,[15,20],7,15,16,[15,20],
 16,16,15,16,20,20,16,20,16,5,15,5,[15,20],20,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,20,5,20,5,20,
 [15,20],20,5,5,20,5,20,5,20,5,20,20,5,5,16,5,20,11,11,
 5,11,11,20,11,11,5,20,11,11,15,5,16,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,16,5,5,5,15,5,15,5,16,[16,20],
 [16,20],5,5,20,5,20,5,20,5,20,20,20,20,16,5,16,20,20,
 5,20,20,11,11,20,5,20,5,20,7,16,16,20,5,[18,20],20,20,
 20,20,20,[16,20],20,5,20,20,20,20,20,16,16,5,20,20,20,
 20,20,16,16,16,16,20,20,5,20,20,20,5,20,[15,20],
 [15,20],16,16,16,16,16,16,18,5,12,13,20,13,20,20,16,16,
 16,20,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,
 5,5,5,16,5,16,5,16,[16,20],16,5,5,5,5,5,5,5,5,5,5,5,
 5,16,20,16,16,20,5,20,20,20,20,5,11,20,11,16,15,20,20,
 20,5,20,[15,20],20,20,[18,20],[16,20],5,20,20,20,20,
 20,5,20,5,20,20,16,20,16,5,20,16,16,20,20,16,20,16,20,
 16,20,20,20,[15,20],[15,20],16,20,16,13,12,20,20,13,16,
 16,16,5,16,20,20,[16,20],[15,20],[16,20],[15,20],
 [16,20],[16,20],[16,20],[16,20],[16,20],[16,20],20,
 20,20,20,20,20,20,15,20,20,20,16,20,16,20,15,7,7,20,20,
 20,20,[15,20],20,20,20,20,20,20,20,7,20,16,16,7,20,15,
 16,16,16,20,15,15,20,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,20,5,5,5,20,5,20,5,20,[16,20],[16,20],5,5,5,5,5,
 5,5,5,20,20,20,20,[16,20],5,[16,20],13,12,5,13,11,11,
 12,5,5,11,5,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,
 5,5,20,5,20,20,20,[15,20],[15,20],5,5,5,5,20,5,5,5,
 5,5,20,20,[15,20],20,[15,20],11,13,11,11,12,12,13,5,5,
 11,5,13,5,5,5,5,5,5,5,5,5,5,5,5,5,20,[16,20],5,5,5,
 16,5,16,20,[16,20],16,16,5,5,20,5,5,5,20,5,5,5,20,20,
 16,20,[16,20],13,13,11,20,13,13,20,5,5,13,5,13,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,5,5,5,20,5,20,5,20,[16,20],
 [16,20],5,5,5,5,5,5,5,5,20,20,5,5,[16,20],5,
 [16,20],11,11,5,11,13,13,11,5,11,12,11,11,5,5,5,5,5,5,
 5,5,5,5,5,20,16,5,5,5,[16,20],5,[16,20],20,16,16,16,
 5,5,5,5,20,5,5,5,5,5,5,5,16,5,16,13,20,11,13,20,13,13,
 5,11,13,11,20,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,16,5,16,
 5,16,16,16,5,5,5,5,5,5,5,5,5,5,5,5,16,5,16,14,14,11,
 13,13,13,14,5,5,14,5,14,5,5,5,5,5,5,5,5,5,5,20,5,5,5,
 20,5,20,5,20,[15,20],[16,20],5,5,20,5,20,5,20,5,20,
 20,20,20,[16,20],5,[16,20],11,11,5,11,11,11,11,11,5,
 13,5,11,5,5,5,5,5,5,5,5,5,[16,20],5,5,5,[16,20],5,
 [16,20],5,[16,20],[16,20],[16,20],5,5,20,5,20,5,20,
 5,20,20,5,5,[16,20],5,[16,20],13,13,5,13,13,20,13,11,
 11,20,11,13,5,5,5,5,5,5,5,5,16,5,5,5,[16,20],5,
 [16,20],5,16,[16,20],16,5,5,5,5,5,5,5,5,5,5,5,5,16,
 20,16,14,13,5,13,14,14,14,5,11,13,11,13,5,5,5,5,5,5,20,
 16,5,5,5,[16,20],5,[16,20],20,16,[16,20],16,5,5,5,5,
 20,5,5,5,20,20,20,20,16,20,16,13,20,12,12,20,13,13,5,12,
 12,12,20,5,5,5,5,5,5,20,5,5,5,20,5,20,5,20,20,20,5,5,
 5,5,5,5,5,5,5,5,5,5,20,5,20,11,11,5,11,11,11,11,5,5,
 11,5,11,5,5,5,5,20,20,5,5,5,20,5,20,20,20,20,16,5,5,5,
 5,5,5,5,5,5,5,20,20,20,20,20,20,11,11,11,11,11,20,5,5,
 11,11,11,5,5,5,20,20,5,5,5,20,5,20,20,20,20,16,5,5,5,
 5,5,5,5,5,5,5,20,20,20,20,20,20,11,11,11,11,11,20,5,5,
 11,11,11,5,5,20,20,5,5,5,20,5,20,20,20,16,20,5,5,5,5,
 5,5,5,5,20,20,5,5,20,20,20,11,20,11,11,11,20,11,5,5,11,
 11,11,5,5,7,5,5,5,7,5,7,5,7,16,16,5,5,5,5,5,5,5,5,5,
 5,5,5,16,5,16,20,20,5,20,20,20,20,5,5,20,5,20,5,7,5,5,
 5,7,5,7,5,7,16,16,5,5,5,5,5,5,5,5,5,5,5,5,16,5,16,
 20,20,5,20,20,20,20,5,5,20,5,20,20,5,20,5,20,5,20,5,20,
 16,16,5,5,5,5,5,5,5,5,20,20,20,20,20,20,20,12,[16,20],
 12,11,11,12,[16,20],5,5,11,12,11,20,20,7,7,7,7,20,20,
 16,7,20,20,20,20,20,20,20,20,20,20,20,20,16,20,7,16,16,
 20,16,16,16,16,20,20,16,20,7,5,5,20,5,20,5,20,20,20,5,
 5,5,5,5,5,5,5,5,5,5,5,20,5,20,11,11,5,11,11,11,11,5,
 5,11,5,11,5,20,5,20,20,20,16,20,5,5,5,5,5,5,5,5,20,20,
 5,5,20,20,20,11,20,11,11,11,20,11,5,5,11,11,11,7,5,7,5,
 7,16,16,5,5,5,5,5,5,5,5,5,5,5,5,16,5,16,20,20,5,20,
 20,20,20,5,5,20,5,20,7,20,20,7,6,16,20,20,20,20,20,20,
 20,20,20,20,20,20,7,20,16,16,16,20,16,16,16,16,20,20,16,
 20,[15,16],7,5,7,16,16,5,5,5,5,5,5,5,5,5,5,5,5,16,5,
 16,20,20,5,20,20,20,20,5,5,20,5,20,20,7,6,16,20,20,20,
 20,20,20,20,20,20,20,20,20,7,20,16,16,16,20,16,16,16,16,
 20,20,16,20,[15,16],20,16,16,5,5,5,5,5,5,5,5,20,20,20,
 20,20,20,20,12,[16,20],12,11,11,12,[16,20],5,5,11,12,
 11,16,7,20,20,20,20,20,20,20,20,20,20,20,20,16,20,7,16,
 16,20,16,16,16,16,20,20,16,20,7,16,20,20,20,20,20,20,20,
 20,[16,20],[16,20],20,20,16,16,16,[16,20],7,
 [15,16,20],[16,20],16,15,[15,16,20],20,20,16,[16,20],
 [16,20],20,20,20,20,20,20,20,20,20,20,[15,16,20],
 [15,16,20],16,16,20,15,[15,16,20],[15,16,20],16,
 [16,20],[16,20],7,20,20,[16,20],[16,20],16,5,20,5,
 20,5,20,5,20,20,5,5,16,5,20,11,11,5,11,20,11,11,11,11,
 20,5,11,20,5,20,5,20,5,20,20,5,5,16,5,20,11,11,5,11,20,
 11,11,11,11,20,5,11,5,20,20,5,20,20,20,20,20,16,5,16,11,
 11,5,16,12,11,11,12,12,[16,20],5,11,20,5,5,5,5,5,5,5,
 20,20,20,11,11,11,11,11,11,11,11,11,11,11,11,20,20,20,20,
 20,20,20,16,20,16,11,11,11,20,20,11,11,20,20,20,11,20,20,
 5,5,5,20,20,20,5,16,11,11,5,20,11,11,11,11,11,11,5,20,
 20,20,20,20,20,16,5,16,11,11,5,16,12,11,11,12,12,
 [16,20],5,11,5,5,20,20,20,5,16,11,11,5,20,11,11,11,11,
 11,11,5,20,5,5,5,16,20,20,12,13,5,12,13,13,11,20,5,12,
 20,11,5,5,16,20,20,12,13,5,12,13,13,11,20,5,12,20,11,5,
 20,20,[16,20],13,11,20,13,11,11,12,20,5,12,5,13,20,20,
 [16,20],13,11,20,13,11,11,12,20,5,12,5,13,20,16,16,7,
 20,16,7,16,16,16,16,7,20,16,20,20,20,20,11,11,20,20,11,
 11,11,20,11,16,[16,20],20,15,[15,16,20],[16,20],16,
 [16,20],[15,16,20],[16,20],20,7,20,13,11,19,20,20,11,
 11,19,13,16,12,19,20,20,20,11,11,20,13,14,11,11,13,12,11,
 10,11,5,11,20,19,20,13,13,20,11,20,11,19,13,12,20,11,20,
 20,11,11,20,12,19,11,11,19,13,11,5,12,10,13,13,10,12,11,
 20,11,5,5,5,15,5,5,[15,20],5,[15,20],15,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,20,20,16,
 5,5,20,5,20,5,20,5,20,20,20,20,16,20,20,20,11,11,11,20,
 11,20,11,11,20,11,11,5,5,[15,20],5,5,20,5,20,15,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,20,20,5,
 16,5,5,20,5,20,5,5,5,20,5,20,20,20,[15,20],20,20,11,
 20,11,11,5,11,11,11,11,11,5,5,15,5,5,20,5,[16,20],5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,
 20,20,20,5,5,20,5,[15,20],5,20,5,20,20,20,20,[15,20],
 20,5,11,5,11,11,20,11,11,20,11,11,11,5,16,5,5,20,5,
 [15,20],[15,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,5,5,5,20,5,5,[15,20],20,5,16,5,5,16,5,16,5,20,5,
 16,5,[15,20],20,[16,20],[16,20],20,20,5,11,20,11,5,
 20,20,20,20,20,5,5,[15,20],[15,20],20,16,16,20,5,20,
 20,20,[18,20],20,20,[15,20],[16,20],20,5,20,20,20,20,
 20,20,20,20,20,[15,20],20,5,16,16,20,16,5,20,20,20,16,
 20,[15,20],20,20,5,16,16,16,16,16,16,20,16,16,16,20,13,
 20,20,13,12,5,5,[16,20],5,[16,20],5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,20,20,5,5,16,5,5,20,
 5,20,5,5,5,20,20,20,5,20,[15,20],20,11,5,11,5,11,11,
 20,11,11,11,20,11,[15,20],5,20,20,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,15,5,20,16,5,5,
 [15,20],5,[16,20],5,20,5,[15,20],20,15,5,16,16,5,20,
 5,20,5,20,20,11,11,20,20,20,5,[16,20],[16,20],16,
 [16,20],[15,20],[16,20],[15,20],[16,20],[16,20],
 [16,20],[16,20],[16,20],[16,20],20,20,20,20,20,20,20,
 20,20,20,20,20,20,20,16,20,20,7,20,20,[15,20],20,16,20,
 20,20,[15,20],20,16,20,6,7,[15,20],15,20,16,20,16,20,
 16,15,16,16,7,[15,20],16,7,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,16,5,20,16,5,5,16,5,16,5,5,
 5,16,5,16,5,16,[16,20],5,20,11,20,5,20,5,20,20,16,16,
 20,11,[15,20],[15,20],[16,20],[16,20],20,16,[16,20],
 [16,20],16,16,[16,20],20,20,20,20,20,20,20,20,20,16,16,
 [16,20],20,20,[15,20],20,[15,20],7,20,20,15,16,6,16,
 [16,20],20,15,20,[15,20],20,16,16,20,16,20,15,20,16,
 [15,20],16,16,[16,20],15,16,20,20,20,20,5,20,[16,20],
 20,[18,20],20,20,20,5,20,20,20,20,[15,20],[15,20],20,
 20,20,16,20,16,20,5,16,16,5,20,16,20,16,20,16,20,16,16,
 20,5,16,16,20,16,16,20,20,13,5,13,12,16,16,18,20,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,5,20,20,5,
 [16,20],5,5,20,5,[16,20],5,20,5,20,5,20,20,[16,20],
 [15,20],20,13,5,12,11,11,5,12,11,11,11,11,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,20,5,5,[16,20],
 5,5,20,5,[16,20],5,5,5,20,5,20,5,[16,20],[16,20],5,
 11,11,13,5,12,5,13,11,12,11,12,11,5,5,5,5,5,5,5,5,5,5,
 5,5,5,20,20,5,5,5,5,5,5,[16,20],20,5,[16,20],5,5,
 [16,20],5,[16,20],5,5,5,[16,20],5,[16,20],20,
 [16,20],[16,20],20,20,11,20,11,13,5,13,13,13,13,13,11,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,5,20,
 [15,20],5,5,20,5,[15,20],5,20,5,20,20,20,5,[15,20],
 [15,20],20,11,5,11,5,13,11,11,12,13,12,13,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,[16,20],5,5,16,5,5,16,
 5,16,5,5,5,16,20,[16,20],5,16,16,20,13,11,13,5,13,11,
 20,13,20,13,20,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,[16,20],5,20,16,5,5,16,5,16,5,5,5,16,5,[16,20],5,
 16,[16,20],5,13,11,14,5,13,5,14,14,13,14,13,11,5,5,5,
 5,5,5,5,5,5,20,20,5,5,5,20,5,5,20,5,5,[16,20],5,5,
 20,5,[16,20],5,20,5,20,5,20,5,[16,20],[16,20],5,11,
 5,11,5,11,5,11,13,11,13,11,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,5,20,16,20,20,16,5,5,[16,20],5,[16,20],5,20,5,
 [16,20],20,16,20,16,16,5,13,5,13,5,20,11,13,20,13,13,
 13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,16,5,5,16,
 5,16,5,5,5,16,5,16,5,16,16,5,13,5,14,5,14,11,13,13,14,
 13,14,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,[16,20],5,20,
 16,5,5,16,5,16,5,20,5,16,20,[16,20],5,16,[16,20],20,
 12,12,13,5,13,12,20,12,20,13,20,12,5,5,5,5,5,20,20,5,5,
 5,5,5,5,20,20,5,16,5,5,20,5,20,5,5,5,20,5,20,20,20,20,
 20,20,5,11,11,11,5,20,11,11,11,11,11,5,5,5,5,5,5,5,5,
 5,5,5,5,20,5,5,20,5,5,20,5,20,5,5,5,20,5,20,5,20,20,
 5,11,5,11,5,11,5,11,11,11,11,11,5,5,5,5,20,20,5,5,5,5,
 5,5,20,20,5,16,5,5,20,5,20,5,5,5,20,5,20,20,20,20,20,
 20,5,11,11,11,5,20,11,11,11,11,11,5,5,20,20,5,5,5,5,5,
 20,20,5,20,20,5,5,20,5,20,5,5,5,20,20,20,5,20,16,5,11,
 11,20,5,11,11,11,11,11,11,20,5,5,20,20,5,5,5,5,5,20,20,
 5,20,20,5,5,20,5,20,5,5,5,20,20,20,5,20,16,5,11,11,20,
 5,11,11,11,11,11,11,20,5,5,5,5,5,5,5,5,5,20,5,20,20,5,
 5,20,5,20,5,5,5,20,5,20,5,20,20,20,11,11,11,11,11,11,
 11,11,11,11,11,11,5,5,5,5,5,5,20,20,20,20,16,5,5,20,5,
 20,5,5,5,20,20,20,20,20,[16,20],20,13,20,12,20,11,5,13,
 12,11,12,13,5,5,5,5,5,5,20,20,20,20,16,5,5,20,5,20,5,
 5,5,20,20,20,20,20,[16,20],20,13,20,12,20,11,5,13,12,
 11,12,13,5,5,5,20,5,20,20,5,20,20,5,5,20,5,20,5,20,5,
 20,20,20,5,16,20,5,11,11,11,5,20,11,11,11,11,20,11,5,5,
 5,5,5,7,5,5,16,5,5,7,5,16,5,5,5,7,5,7,5,16,16,5,20,
 5,20,5,20,5,20,20,20,20,20,5,5,5,5,7,5,5,16,5,5,7,5,
 16,5,5,5,7,5,7,5,16,16,5,20,5,20,5,20,5,20,20,20,20,
 20,5,20,20,20,20,20,20,5,20,20,5,[16,20],5,5,20,20,20,
 20,20,[15,16,20],20,20,12,5,11,20,13,20,11,12,13,13,11,
 5,5,20,20,5,20,5,5,20,5,16,5,20,5,20,5,20,20,20,20,20,
 11,5,11,11,11,5,11,20,20,11,11,11,20,5,20,20,5,20,20,5,
 20,5,20,5,20,5,20,5,16,16,5,11,12,12,5,[16,20],12,11,
 11,11,12,[16,20],5,20,20,7,20,20,7,7,16,7,20,20,7,20,
 20,20,16,7,20,16,20,16,20,16,20,16,16,[15,16,20],16,16,
 20,5,16,5,5,20,5,16,5,20,20,20,5,20,5,20,20,20,
 [16,20],5,11,12,11,5,12,16,11,11,11,12,20,5,20,20,5,20,
 5,20,5,20,20,20,5,16,16,20,11,20,20,12,20,20,11,11,11,
 20,20,11,20,20,16,16,16,16,20,20,16,20,7,16,16,16,16,7,
 20,16,16,16,20,7,16,16,16,7,16,5,20,5,20,5,5,5,20,5,20,
 5,20,20,5,11,5,11,5,11,5,11,11,11,11,11,5,20,5,20,5,20,
 5,20,20,20,5,16,20,5,11,11,11,5,20,11,11,11,11,20,11,5,
 7,6,7,20,20,20,20,7,20,6,16,20,16,20,16,20,16,20,16,16,
 7,16,16,20,16,5,5,5,7,5,7,5,16,16,5,20,5,20,5,20,5,20,
 20,20,20,20,5,16,[16,20],16,6,20,16,16,20,16,16,
 [16,20],20,[16,20],[16,20],16,20,[15,16,20],15,7,16,
 [16,20],[15,16,20],5,5,7,5,7,5,16,16,5,20,5,20,5,20,
 5,20,20,20,20,20,5,20,20,20,20,20,[15,16,20],20,20,12,
 5,11,20,13,20,11,12,13,13,11,5,20,5,20,20,20,20,20,11,5,
 11,11,11,5,11,20,20,11,11,11,20,7,20,6,16,20,16,20,16,
 20,16,20,16,16,7,16,16,20,20,5,16,16,5,11,12,12,5,
 [16,20],12,11,11,11,12,[16,20],5,20,16,7,20,16,20,16,
 20,16,20,16,16,[15,16,20],16,16,20,20,20,20,[16,20],5,
 11,12,11,5,12,16,11,11,11,12,16,20,[16,20],[16,20],
 [16,20],20,7,[15,16,20],[16,20],16,16,15,[15,16,20],
 20,20,16,[16,20],15,20,[15,16,20],[15,16,20],16,
 [16,20],[16,20],[16,20],7,20,20,11,11,20,11,11,20,20,
 20,11,11,20,11,20,12,19,11,20,20,20,19,20,13,12,10,13,5,
 11,11,11,13,13,10,11,20,13,11,19,19,20,20,11,11,11,13,13,
 13,11,11,5,12,19,20,11,20,20,11,11,11,11,13,12,10,20,20,
 19,20,12,20,11,19,13,16,14,12,20,11,11,5,5,16,5,5,20,5,
 20,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,[15,20],
 20,5,5,5,5,5,5,20,20,15,20,5,5,5,5,15,5,16,5,5,16,20,
 [15,20],20,[15,20],[15,20],11,20,20,20,11,12,11,12,20,
 11,12,12,5,[16,20],5,5,20,5,[16,20],20,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,15,20,5,5,5,20,5,20,20,20,
 [15,20],20,5,5,20,5,[15,20],5,[15,20],5,20,[15,20],
 20,15,20,15,15,11,12,20,20,11,20,11,20,12,11,12,12,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,
 5,20,5,5,16,16,5,5,5,5,5,5,5,5,20,5,20,20,5,20,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,20,16,16,[15,20],20,
 5,[15,20],5,20,[15,20],5,20,5,20,20,5,20,5,20,16,5,
 20,5,5,20,5,20,20,20,6,20,20,5,20,20,6,5,20,20,20,20,5,
 16,16,16,16,13,20,16,16,20,20,13,20,20,20,20,20,5,
 [16,20],5,16,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,
 5,5,5,5,20,5,20,5,5,15,20,5,5,20,5,15,5,15,5,20,15,5,
 16,20,15,15,11,12,12,12,11,20,11,20,12,11,20,20,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,16,
 5,5,5,5,5,5,16,5,5,5,20,5,5,20,20,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,16,16,16,[15,20],5,5,[15,20],5,16,
 [15,20],5,15,5,20,20,5,20,5,20,16,20,20,5,5,20,5,20,
 20,20,6,20,20,5,20,20,6,5,20,20,20,20,20,16,16,16,16,13,
 20,20,20,20,20,13,20,20,20,16,16,20,16,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,
 16,5,16,5,5,16,5,16,5,16,16,11,20,20,20,5,20,5,20,20,
 11,20,20,5,[15,20],[15,20],5,20,5,20,[15,20],5,20,5,
 20,20,5,20,5,20,20,20,20,5,5,5,5,20,20,20,16,16,20,5,
 20,20,16,5,16,20,5,16,20,20,20,7,7,20,20,20,20,13,16,20,
 16,20,13,20,20,[15,20],[15,20],5,5,5,15,[15,20],5,16,
 5,20,20,5,20,5,20,20,20,20,5,5,20,5,20,20,20,16,16,20,
 5,20,20,16,5,16,20,20,16,20,20,20,7,7,20,16,20,20,13,20,
 20,20,16,13,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 [16,20],20,5,5,5,5,5,5,20,20,20,20,5,5,5,5,20,5,
 [16,20],5,5,[16,20],20,[16,20],20,20,20,11,5,12,12,
 11,11,11,11,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 [16,20],20,5,5,5,5,5,5,20,20,16,20,5,5,5,5,16,5,16,5,
 5,16,20,[16,20],20,20,20,11,12,12,12,11,5,11,5,12,11,
 12,12,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,
 20,20,5,5,5,5,5,5,5,5,20,5,5,20,20,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,
 20,5,20,5,5,20,20,5,5,20,5,20,5,[16,20],5,20,[16,20],
 5,16,20,16,16,11,12,5,5,11,12,11,12,12,11,12,12,5,5,5,
 5,5,5,5,5,5,5,5,20,5,5,5,5,5,5,20,20,20,5,5,5,5,20,
 5,5,5,20,5,5,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,5,16,20,5,5,
 5,5,16,5,[16,20],5,5,[16,20],5,16,20,[15,20],
 [15,20],5,16,16,16,5,13,11,13,16,5,16,16,5,5,5,5,5,5,
 5,5,5,[16,20],5,5,5,5,20,5,20,5,5,20,20,5,5,20,5,20,
 5,[16,20],5,20,[16,20],5,[16,20],20,20,20,11,5,11,11,
 11,12,11,12,5,11,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,
 20,5,5,5,5,5,5,20,5,5,5,20,5,20,20,5,20,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],5,5,5,5,5,
 5,5,5,5,[15,20],20,5,5,5,5,[15,20],5,16,5,5,16,5,
 [16,20],20,16,16,5,16,12,12,11,16,5,16,16,5,16,16,5,5,
 5,5,5,5,[16,20],20,5,5,5,20,5,5,5,5,5,5,5,5,5,5,5,
 5,[16,20],5,20,[16,20],20,[16,20],5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,20,20,5,
 16,5,5,5,5,5,5,20,5,5,20,20,20,5,20,20,20,5,11,11,5,5,
 20,5,5,5,11,11,5,5,5,5,20,20,5,5,5,5,5,5,20,20,5,16,
 5,5,5,5,5,5,20,5,5,20,20,20,5,20,20,20,5,11,11,5,5,20,
 5,5,5,11,11,5,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,20,5,5,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,7,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,16,5,7,5,5,7,5,
 7,5,16,16,5,20,20,20,5,20,5,20,20,5,20,20,5,20,20,5,5,
 5,5,5,20,5,5,5,5,5,5,20,5,5,5,20,5,5,20,20,20,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,7,5,5,5,5,5,5,5,5,5,16,5,5,
 5,5,5,16,5,7,5,5,7,5,7,5,16,16,5,20,20,20,5,20,5,20,
 20,5,20,20,20,20,20,20,20,20,20,20,20,16,20,20,20,20,7,
 16,20,7,7,20,7,20,20,20,7,7,20,16,7,7,20,16,20,16,16,
 20,9,9,5,5,5,5,5,20,20,20,5,20,5,5,20,5,5,20,20,5,5,
 20,5,20,5,20,20,12,5,20,20,5,5,12,5,5,5,5,5,5,5,20,5,
 20,5,5,20,5,5,5,20,5,20,5,20,5,20,20,5,20,16,5,5,5,11,
 5,5,20,11,5,11,11,20,5,5,5,20,5,5,20,20,5,5,5,5,5,5,
 5,5,20,5,20,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,20,5,5,5,5,5,5,20,5,5,20,5,20,20,5,5,11,5,
 5,5,11,5,11,5,5,11,5,5,20,20,20,20,20,5,20,5,20,5,20,
 5,20,5,5,20,5,20,20,5,5,5,5,5,5,12,20,5,20,5,12,5,5,
 5,20,20,5,5,5,5,5,5,5,5,20,5,20,20,5,20,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,12,5,20,5,5,5,12,20,20,5,20,20,
 20,20,16,5,5,5,11,5,5,20,11,5,11,11,20,5,5,5,5,16,5,5,
 5,5,5,5,20,5,20,20,20,20,5,12,12,20,5,11,11,5,5,20,5,
 5,5,11,11,5,16,5,5,5,5,5,5,20,5,20,20,20,20,5,12,12,
 20,5,11,11,5,5,20,5,5,5,11,11,5,20,5,12,16,5,5,6,16,
 20,6,5,16,16,16,16,5,16,16,16,20,[16,20],5,[16,20],16,
 20,16,16,5,5,5,5,5,5,20,5,5,20,20,20,20,16,16,16,5,20,
 20,11,5,[16,20],5,5,11,20,20,5,20,5,20,5,20,5,20,20,5,
 20,16,5,5,5,11,5,5,20,11,5,11,11,20,5,5,5,5,5,5,20,5,
 5,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,12,20,20,
 5,20,20,20,20,16,5,5,5,11,5,5,20,11,5,11,11,20,5,5,16,
 5,7,5,5,7,5,7,5,16,16,5,20,20,20,5,20,5,20,20,5,20,20,
 5,6,16,20,6,5,16,16,16,16,5,16,16,16,20,[16,20],5,
 [16,20],16,20,16,16,20,5,5,20,20,20,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,7,20,20,20,7,20,16,16,20,7,16,16,20,6,
 20,6,7,20,16,16,5,7,5,7,5,16,16,5,20,20,20,5,20,5,20,
 20,5,20,20,20,5,20,20,5,5,5,5,5,5,12,20,5,20,5,12,5,5,
 20,7,20,16,16,20,7,16,16,20,6,20,6,7,20,16,16,20,5,20,
 20,12,5,20,20,5,5,12,5,5,5,5,5,20,7,7,20,16,7,7,20,16,
 20,16,16,20,9,9,5,5,11,20,5,5,[16,20],20,11,20,20,16,
 5,5,5,20,16,[16,20],[16,20],5,16,20,16,16,5,16,16,20,
 16,[16,20],[16,20],5,16,20,16,16,5,16,16,5,11,11,11,5,
 5,5,5,11,12,12,20,20,12,5,5,5,5,11,20,20,5,5,20,12,20,
 20,5,5,5,5,20,12,20,20,5,5,5,11,10,11,12,5,5,5,5,5,5,
 12,20,20,5,5,11,11,11,5,12,20,20,11,20,20,5,5,5,5,7,5,
 5,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,
 5,5,20,5,20,20,20,20,20,5,5,5,5,20,5,20,5,20,5,20,20,
 20,20,20,11,11,20,20,20,11,11,11,11,5,5,5,7,5,5,5,5,20,
 20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,
 20,20,20,20,20,5,5,5,5,20,5,20,5,20,5,20,20,20,20,20,
 11,11,20,20,20,11,11,11,11,5,5,5,20,20,20,20,16,20,
 [16,20],[15,20],16,[16,20],[16,20],16,[16,20],
 [16,20],16,16,20,[15,20],16,20,20,15,16,20,[16,20],
 [16,20],16,16,7,20,[15,20],15,16,15,20,20,[15,20],
 [16,20],7,16,16,16,[16,20],20,16,16,7,16,15,15,16,7,
 15,7,[16,20],[15,16,20],[16,20],7,20,20,20,5,20,5,20,
 20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,
 5,5,20,20,20,5,5,20,5,20,5,5,5,20,20,5,5,20,20,20,11,
 11,11,11,11,11,11,11,11,11,11,11,20,5,5,7,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,20,5,20,20,20,5,
 5,20,5,20,5,20,5,5,20,20,5,20,20,20,20,20,11,11,11,5,5,
 5,20,11,11,11,20,20,16,20,5,20,5,20,20,20,5,20,5,5,20,
 5,5,20,20,20,20,5,5,5,5,5,5,20,20,20,20,20,5,5,5,15,5,
 5,5,20,5,5,5,[15,20],16,[15,20],12,13,11,11,11,11,11,
 11,13,20,20,20,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 20,20,5,5,5,5,5,20,5,20,20,20,5,5,20,5,20,5,20,5,5,20,
 20,5,20,20,20,20,20,11,11,11,5,5,5,20,11,11,11,20,5,20,
 20,5,5,5,20,5,5,5,5,20,20,5,5,20,20,20,5,5,5,20,5,5,
 5,20,16,[15,20],20,5,20,5,[15,20],5,5,5,5,5,20,20,15,
 20,20,11,11,13,12,13,20,20,20,11,11,11,11,[16,20],15,
 [16,20],[16,20],16,16,[16,20],[16,20],16,16,20,15,20,
 20,16,[15,20],[16,20],15,[16,20],20,16,[15,20],16,
 [15,20],20,20,16,15,20,[16,20],16,[16,20],7,7,16,16,
 20,[16,20],15,15,7,16,15,15,7,16,15,7,20,20,20,7,
 [16,20],[16,20],[15,16,20],5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,20,20,5,5,5,5,5,5,5,20,5,20,5,5,20,5,20,5,20,5,
 5,5,5,20,[16,20],5,20,13,12,12,13,11,5,5,5,11,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,20,20,
 20,20,5,5,5,5,[16,20],5,5,5,20,20,20,20,20,20,20,11,
 13,13,11,12,5,11,5,12,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,
 5,[15,20],[15,20],5,5,5,5,5,5,20,20,20,[15,20],5,5,
 20,5,[16,20],5,20,5,20,5,20,20,[16,20],20,[15,20],20,
 13,20,13,13,5,11,5,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 20,20,5,5,5,20,5,20,20,20,20,20,5,5,20,5,20,5,5,5,5,
 20,5,5,20,20,[16,20],11,11,11,11,13,11,5,5,13,5,11,5,
 5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,20,20,
 20,5,5,5,5,[15,20],5,5,5,5,5,5,5,20,20,[15,20],13,
 20,13,12,20,11,5,5,13,5,5,11,5,5,5,5,5,5,5,5,5,5,20,
 20,5,5,5,5,5,20,20,20,20,[16,20],5,5,5,5,16,5,5,5,5,
 20,5,5,16,5,[16,20],12,20,20,12,13,5,11,5,12,5,5,11,5,
 5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,5,5,20,5,[16,20],5,
 5,20,5,20,5,20,5,20,5,20,5,20,5,20,11,11,11,11,11,5,5,
 11,11,11,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,5,5,20,
 20,[16,20],5,5,5,5,[15,20],5,20,5,20,20,5,5,[15,20],
 20,[16,20],12,13,12,12,13,5,5,11,20,5,11,5,5,5,5,5,5,
 5,5,20,20,5,5,5,20,5,5,5,20,5,16,5,5,20,5,[16,20],5,
 20,5,5,20,5,5,[16,20],20,16,13,12,12,13,20,11,5,5,20,
 5,11,5,5,5,5,5,5,5,[18,20],20,5,5,5,[15,20],5,20,20,
 20,5,16,5,5,20,5,16,5,20,5,20,20,20,5,16,5,16,19,16,16,
 19,16,5,5,5,16,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,
 20,5,20,5,5,5,5,20,5,5,5,5,5,5,5,20,5,20,11,11,11,11,
 11,5,11,5,11,5,5,11,5,5,5,5,20,20,5,5,5,5,5,5,20,20,
 5,16,5,5,5,5,20,5,5,5,5,5,20,20,20,[15,20],20,20,11,
 20,11,11,5,11,5,11,5,11,5,5,5,5,[15,20],20,5,5,5,5,5,
 5,20,20,20,20,5,5,5,5,20,5,5,5,5,5,20,20,20,20,20,11,
 11,20,20,11,11,11,5,11,5,5,5,5,5,20,20,5,5,5,5,5,5,5,
 20,20,20,5,5,5,5,20,5,5,5,5,20,5,5,20,20,20,11,11,11,
 11,11,11,5,5,11,5,11,5,5,20,15,5,5,5,5,5,20,5,20,20,
 20,5,5,5,5,20,5,5,5,5,5,5,5,20,20,20,20,20,11,11,11,5,
 5,5,11,5,11,11,20,20,5,5,5,5,5,20,5,20,[15,20],20,5,
 5,5,5,20,5,5,5,5,5,5,5,20,5,16,11,20,11,20,11,11,5,5,
 11,5,5,11,20,20,20,20,20,20,20,20,20,16,[15,20],20,20,
 20,20,[15,20],20,20,20,20,16,[15,20],[15,20],[15,20],
 16,[15,20],20,15,16,20,20,20,20,20,20,20,[16,20],20,20,
 20,20,20,20,[15,20],20,20,20,16,20,20,20,20,[15,20],20,
 20,20,20,20,20,20,[15,20],20,7,16,20,20,15,20,20,
 [16,20],20,20,20,20,[18,20],5,5,20,5,20,20,20,
 [15,20],20,5,5,5,5,20,5,5,5,20,20,5,5,16,5,20,11,20,
 11,11,20,11,5,5,11,11,5,5,5,20,5,20,20,20,20,20,5,5,5,
 5,20,5,5,5,16,5,5,5,20,20,20,11,11,20,11,20,11,5,11,11,
 5,5,5,20,5,5,5,20,5,[16,20],5,5,20,5,16,5,20,5,5,5,
 5,5,[16,20],5,16,20,11,11,20,20,5,11,5,20,11,5,5,20,
 20,20,[15,20],16,16,5,5,5,5,16,20,5,20,5,5,5,20,16,5,
 16,12,12,12,16,20,20,5,11,13,11,5,5,5,5,15,5,16,5,5,20,
 5,16,5,20,5,5,5,5,5,16,5,16,20,11,11,20,20,5,5,5,20,5,
 5,5,5,20,12,20,5,5,5,5,16,5,5,5,16,5,5,5,16,5,20,12,
 20,13,12,[16,20],11,5,5,16,5,5,20,20,12,[15,20],5,5,
 5,5,16,5,5,5,16,5,20,20,16,16,20,12,13,20,12,[16,20],
 11,20,5,16,5,11,5,20,7,20,20,20,20,[15,20],20,[15,20],
 20,20,20,20,20,[15,20],20,16,15,20,20,16,20,20,20,20,20,
 20,20,[16,20],20,5,20,5,5,20,5,5,5,20,16,5,5,16,20,16,
 11,16,20,20,20,16,5,5,12,20,20,20,20,20,16,20,16,16,16,
 16,20,20,[16,20],[16,20],[16,20],16,20,15,[16,20],
 [16,20],15,[15,16,20],20,15,20,[15,16,20],20,20,20,5,
 20,5,20,5,5,5,20,5,5,5,20,5,20,11,11,11,11,11,5,5,11,
 11,11,5,5,5,5,20,5,20,5,5,16,5,5,20,20,20,11,20,11,11,
 11,5,5,5,20,11,11,5,5,16,16,5,20,20,5,16,5,[16,20],5,
 16,16,12,12,12,13,5,5,11,19,[15,16,20],5,20,16,5,20,5,
 20,20,5,5,20,[15,20],20,11,11,20,11,11,5,5,11,20,5,11,
 5,16,16,[16,20],[16,20],16,20,[15,20],20,16,[16,20],
 16,16,16,16,16,20,20,15,7,15,20,20,20,5,5,5,20,5,16,5,
 16,20,11,11,20,20,5,5,5,20,5,5,5,20,5,16,5,20,16,20,16,
 12,12,12,16,13,5,5,11,20,5,20,5,5,5,5,20,16,5,[16,20],
 20,11,11,20,20,5,5,11,20,5,5,11,20,5,5,16,20,20,12,12,
 16,12,16,5,5,[15,16,20],13,11,5,5,5,5,16,16,20,12,19,
 13,12,16,11,5,5,[16,20],5,[15,16,20],5,5,20,20,
 [16,20],20,16,[16,20],13,11,5,11,5,11,5,5,5,20,20,
 [16,20],13,16,[16,20],20,11,5,11,20,11,5,5,11,20,16,
 16,16,16,16,7,20,20,15,16,15,20,20,20,20,20,16,11,12,20,
 20,20,20,5,16,5,15,[16,20],[16,20],15,[15,16,20],20,
 20,20,[15,16,20],20,20,15,20,20,11,20,11,11,11,20,13,12,
 13,11,20,20,11,11,11,20,12,13,12,20,20,13,12,12,20,11,11,
 11,20,12,13,13,20,11,11,11,12,12,13,11,11,11,11,5,5,11,
 10,11,10,5,11,11,10,11,11,11,10,11,13,12,12,5,5,5,7,5,
 5,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,
 5,5,20,5,20,20,20,20,20,5,5,5,5,20,5,20,5,20,5,20,20,
 20,20,20,11,11,20,20,20,11,11,11,11,5,5,5,20,20,20,20,7,
 16,[16,20],[15,20],[16,20],[16,20],16,16,15,[16,20],
 [16,20],[16,20],[16,20],20,[16,20],[15,20],20,16,
 [15,20],20,20,16,15,15,7,20,16,16,15,16,15,20,20,
 [16,20],16,[16,20],[16,20],[16,20],15,15,[16,20],
 [16,20],16,7,16,[16,20],[15,16,20],7,7,15,15,16,16,
 [16,20],20,20,20,5,20,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,20,5,5,5,20,5,20,20,5,20,20,5,5,20,5,20,5,
 20,5,20,20,20,20,20,20,20,5,5,11,11,11,20,20,20,5,11,11,
 11,20,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,
 5,5,20,5,20,20,5,20,20,5,5,20,5,20,5,20,5,20,20,20,20,
 20,20,20,5,5,11,11,11,20,20,20,5,11,11,11,20,16,20,20,5,
 5,5,20,20,20,20,20,5,5,20,5,5,5,20,5,5,5,5,5,20,5,20,
 16,5,20,20,20,20,5,5,20,5,20,5,20,20,20,20,16,[15,20],
 16,11,11,11,11,11,12,13,13,11,20,20,20,20,20,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,5,20,20,
 5,5,5,5,20,5,20,5,5,5,20,20,20,20,20,11,11,11,11,11,11,
 11,11,11,11,11,11,20,15,[16,20],[16,20],[15,20],16,
 [16,20],[16,20],[16,20],16,[16,20],15,20,20,[15,20],
 16,[16,20],15,15,20,20,15,[16,20],[16,20],16,20,20,7,
 16,[16,20],[16,20],16,16,16,7,[16,20],[16,20],20,
 [15,20],15,[16,20],16,15,16,20,20,15,16,16,7,15,7,20,
 [16,20],[15,16,20],[16,20],20,5,20,5,20,20,20,5,20,5,
 20,5,20,5,5,5,20,20,20,5,5,20,5,16,20,5,[15,20],16,5,
 5,5,20,16,5,20,5,5,5,20,20,20,20,20,20,20,13,12,13,11,
 11,11,20,11,11,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,5,5,5,20,5,20,20,20,20,20,5,5,5,5,5,5,20,5,20,5,20,
 20,20,20,20,11,5,12,13,11,11,12,11,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,20,20,5,20,20,5,5,
 5,5,20,5,20,5,5,5,20,20,5,20,5,5,11,13,11,12,12,13,11,
 5,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,
 20,20,20,20,20,5,5,5,5,5,5,20,5,20,5,[15,20],[15,20],
 5,[15,20],20,11,5,13,20,12,13,20,12,5,5,5,11,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,5,20,5,5,5,5,5,
 5,5,20,5,5,20,20,20,20,20,20,5,5,11,11,13,13,11,12,11,
 5,11,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,
 [15,20],[15,20],5,[15,20],20,5,5,5,5,5,5,20,5,5,20,
 20,20,20,[15,20],5,5,11,20,13,13,20,13,13,5,5,11,5,5,
 5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,5,[16,20],
 20,5,5,5,5,20,5,20,5,5,5,20,20,20,[16,20],5,5,11,20,
 12,12,13,20,13,5,5,5,11,5,5,5,5,5,5,5,5,5,5,20,5,5,5,
 20,5,20,20,5,20,20,5,5,20,5,20,5,20,5,20,20,20,20,20,
 20,5,5,5,11,11,11,11,11,13,5,11,5,5,5,5,5,5,5,5,5,5,
 5,20,5,5,5,[15,20],5,20,20,5,[15,20],5,5,5,20,5,20,
 5,[15,20],5,20,20,20,20,20,20,5,5,5,13,12,20,13,12,20,
 11,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,5,
 [16,20],20,5,5,5,5,5,5,20,5,20,20,20,20,20,[16,20],
 20,5,5,12,13,20,20,12,13,11,5,11,5,5,5,5,5,5,5,
 [15,20],20,5,5,5,[18,20],5,20,20,5,[16,20],5,5,5,5,
 5,5,5,20,5,20,[15,20],[18,20],20,5,[16,20],5,5,5,16,
 19,16,16,16,19,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,
 20,20,20,[15,20],5,5,20,5,5,5,20,5,5,5,20,20,5,20,
 [15,20],11,5,11,20,11,11,20,11,5,5,5,11,5,5,5,5,5,5,
 5,5,5,20,5,20,20,5,20,20,5,5,5,5,5,5,20,5,5,5,20,20,
 5,20,5,11,5,11,11,11,11,11,11,5,5,11,5,5,5,5,20,20,5,
 5,5,20,5,20,20,20,20,20,5,5,5,5,20,5,20,5,5,5,20,15,5,
 20,20,11,5,20,20,11,11,11,11,11,5,5,5,5,5,20,5,5,5,5,
 20,5,20,20,5,16,5,5,5,5,5,5,5,20,5,5,20,20,20,5,16,5,
 5,11,20,11,11,20,11,11,5,5,11,5,5,5,20,5,5,5,20,5,
 [15,20],20,5,20,20,5,5,5,5,5,5,20,5,5,20,20,20,20,20,
 5,5,5,11,11,11,20,20,11,5,11,11,5,5,5,5,5,5,20,5,20,
 20,20,[16,20],5,5,5,5,5,5,5,20,5,20,20,20,20,5,20,16,
 5,11,11,20,20,20,11,20,5,5,5,11,5,5,20,5,20,5,20,20,20,
 [15,20],12,5,5,20,20,5,20,20,5,5,20,20,[15,20],5,
 [16,20],20,11,20,20,[16,20],12,12,13,12,5,5,11,5,5,5,
 20,20,5,[15,20],20,20,20,13,5,5,20,20,5,20,20,5,5,5,
 20,[15,20],20,[16,20],20,11,5,13,[16,20],12,12,20,12,
 5,5,5,5,5,5,20,5,20,20,5,20,5,5,5,5,5,5,5,20,5,5,5,
 20,20,20,20,5,5,11,11,11,11,11,11,11,5,11,5,5,5,20,5,
 20,15,5,20,20,5,5,5,5,5,5,20,5,20,5,20,20,20,20,5,11,
 11,20,11,20,11,11,11,5,5,5,5,20,5,20,20,5,20,[15,20],
 5,5,5,5,5,5,20,5,20,5,20,20,[15,20],20,5,11,5,11,11,
 20,11,20,11,5,11,5,5,[15,20],20,20,[15,20],6,20,20,20,
 20,20,20,20,20,20,20,20,20,20,16,[15,20],20,20,20,20,20,
 16,15,20,20,20,[16,20],20,20,20,20,20,16,5,5,5,5,5,5,
 5,20,5,20,20,20,20,5,20,5,5,5,11,20,20,20,11,20,5,5,5,
 5,20,20,16,20,20,20,20,20,20,20,20,20,20,20,20,20,16,
 [15,20],20,20,[16,20],20,20,15,16,20,20,20,20,20,20,20,
 [15,20],16,20,20,20,20,20,20,20,20,[15,20],20,20,20,20,
 16,20,20,20,16,20,20,20,15,20,20,20,[16,20],20,16,16,20,
 5,5,5,12,5,20,5,20,20,20,20,20,20,16,20,5,12,20,16,12,
 12,13,11,5,5,11,20,20,20,20,20,20,20,[15,20],20,
 [16,20],[16,20],[15,20],[15,20],16,[16,20],16,20,
 [15,20],[16,20],[15,16,20],15,15,[16,20],[16,20],20,
 20,20,20,5,5,20,5,5,5,20,5,20,5,16,20,16,16,16,16,5,20,
 20,20,12,16,11,5,20,20,20,5,20,5,[15,20],5,20,5,20,20,
 20,20,[15,20],20,5,5,5,11,11,20,11,11,20,11,11,5,5,20,
 5,20,5,[15,20],5,20,20,20,20,20,20,20,5,5,11,11,11,20,
 11,20,5,11,5,11,20,16,20,20,5,20,20,[15,20],20,16,16,
 12,5,5,12,13,12,12,16,20,11,20,5,11,16,5,20,5,5,5,20,
 20,5,[16,20],5,5,5,20,20,11,11,20,20,11,5,11,5,5,16,
 16,20,20,20,7,16,16,16,5,5,20,20,20,11,12,16,16,20,20,
 20,20,5,5,5,15,20,5,16,5,5,5,20,20,11,11,20,20,5,5,5,
 5,16,[15,20],[15,20],20,7,20,[15,20],7,20,20,20,16,
 20,20,20,16,[16,20],20,20,15,5,5,20,16,5,20,16,5,5,11,
 20,11,11,11,20,20,5,5,20,5,20,20,12,20,5,5,5,12,12,20,
 13,12,[16,20],5,11,5,5,20,20,12,[15,20],5,5,11,12,12,
 13,20,12,[16,20],5,11,20,5,20,20,7,20,[16,20],20,15,
 20,20,20,16,20,20,20,20,20,20,[15,20],16,20,20,20,16,20,
 20,20,16,15,20,20,[16,20],20,5,20,20,11,12,16,20,20,20,
 20,16,5,5,20,20,20,15,[16,20],[16,20],[16,20],15,
 [15,16,20],20,20,15,20,20,20,12,16,11,20,20,20,20,5,5,
 16,5,13,12,13,11,11,11,5,11,11,10,12,12,13,11,11,11,5,
 11,10,10,20,20,20,11,20,12,11,11,11,20,20,20,20,13,11,11,
 11,11,20,20,12,11,11,11,20,20,11,13,12,12,20,11,12,13,12,
 11,12,12,13,10,10,11,5,5,5,5,5,5,5,16,16,20,20,5,20,5,
 5,5,5,20,5,20,20,5,20,5,20,20,5,20,5,20,[15,20],5,5,
 20,[15,20],20,20,5,5,20,20,20,5,5,20,20,5,5,20,16,16,
 16,12,12,16,16,16,12,12,12,12,5,5,5,5,7,5,20,20,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,5,20,20,
 20,20,5,5,20,5,20,5,5,5,20,20,5,20,20,20,20,11,11,5,5,
 5,11,11,11,11,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,20,5,5,5,5,20,5,20,20,20,5,5,5,5,20,5,5,5,
 20,5,5,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,7,16,
 16,20,16,5,16,5,20,20,5,20,5,5,20,5,20,5,20,20,20,20,5,
 20,20,5,5,[15,20],20,20,20,20,5,5,20,20,5,20,20,16,5,
 20,20,16,16,16,12,12,5,5,5,12,12,12,12,16,16,16,20,20,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,5,20,
 20,20,20,5,5,20,5,20,5,5,5,20,20,5,20,20,20,20,11,11,5,
 5,5,11,11,11,11,20,20,20,5,20,20,5,5,5,20,20,5,20,5,20,
 20,5,5,5,20,20,20,20,5,5,20,5,20,20,20,16,16,20,5,20,
 20,16,5,5,5,5,5,20,20,20,20,20,20,20,12,12,12,20,20,20,
 20,12,12,12,20,20,5,5,5,20,20,5,20,5,20,20,5,5,5,20,20,
 20,20,5,5,20,5,20,20,20,16,16,20,5,20,20,16,5,5,5,5,5,
 20,20,20,20,20,20,20,12,12,12,20,20,20,20,12,12,12,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,5,20,
 [15,20],5,20,5,5,5,5,5,5,5,5,20,5,20,[15,20],20,20,
 20,11,5,11,11,11,5,11,11,11,5,5,11,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,[15,20],20,5,5,5,20,5,20,[15,20],20,20,20,
 5,5,5,5,20,5,5,5,20,5,20,20,20,20,20,11,11,11,11,11,11,
 11,5,5,5,11,11,5,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],20,
 5,5,5,[15,20],5,5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,20,
 [16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,20,5,5,5,5,[15,20],5,20,20,20,20,5,5,5,
 5,5,5,5,20,5,5,20,5,20,20,20,20,5,11,11,11,11,11,5,11,
 11,11,11,11,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,5,15,5,20,
 [16,20],[15,20],5,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 20,5,5,5,5,20,5,5,20,20,20,20,5,5,5,5,20,5,5,5,20,20,
 20,20,20,5,5,12,12,20,12,12,12,12,5,5,5,11,11,5,5,5,5,
 5,5,5,5,5,20,5,5,5,5,20,5,5,20,20,5,20,5,5,20,5,20,5,
 20,5,16,5,5,20,20,20,20,11,5,11,11,11,5,11,11,11,11,11,
 5,5,5,5,5,5,5,5,5,[15,20],5,5,5,5,[16,20],5,5,
 [16,20],[16,20],5,5,5,5,5,5,5,5,20,5,20,20,5,
 [16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,5,5,5,5,20,5,20,20,20,20,20,5,5,20,5,20,5,5,5,20,
 5,5,20,20,20,20,5,12,12,5,20,12,5,12,12,11,11,11,5,5,5,
 5,5,5,16,5,5,5,5,16,5,5,16,16,5,5,5,5,5,5,5,5,5,5,
 20,20,20,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,20,20,5,5,5,20,5,5,20,15,5,16,5,5,5,5,5,5,5,5,
 5,5,20,20,5,20,20,20,5,11,11,5,5,20,5,5,11,5,11,5,5,5,
 5,20,20,5,5,5,20,5,5,[15,20],20,5,16,5,5,5,5,5,5,5,
 5,5,5,20,20,20,20,20,20,5,11,11,5,5,20,5,5,11,11,5,5,
 5,5,20,5,5,5,5,20,5,5,16,16,5,5,5,5,5,5,5,5,5,5,20,
 5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,15,5,5,5,
 5,20,5,20,20,20,16,5,5,5,5,5,5,5,5,5,5,20,5,20,5,20,
 5,5,20,11,5,11,20,5,5,5,5,11,11,5,20,20,5,5,5,20,5,20,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,20,5,5,5,5,20,5,20,20,20,16,5,5,5,5,5,
 5,5,5,5,5,20,5,20,20,5,20,5,20,5,11,11,20,5,5,5,5,11,
 11,20,20,16,20,16,7,20,20,15,16,20,20,20,20,20,20,20,20,
 20,16,[15,20],20,20,20,20,20,20,15,20,20,20,15,20,20,20,
 20,20,20,5,5,20,20,5,20,20,[15,20],5,20,5,5,5,5,5,5,
 5,5,5,5,5,20,20,20,20,12,5,20,20,5,5,12,5,5,5,5,5,5,
 5,[15,20],5,20,20,20,16,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,5,20,5,20,11,5,11,20,5,5,5,11,5,11,5,16,5,5,20,20,
 5,5,5,5,5,5,5,5,5,5,20,5,5,20,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,20,5,5,20,20,5,16,5,5,5,5,5,5,5,5,5,5,5,
 20,20,20,5,20,5,5,11,11,5,20,5,5,11,11,5,7,[15,20],
 [15,20],7,16,20,20,20,20,20,20,20,20,20,20,20,20,15,20,
 20,20,20,[15,20],20,20,20,[15,20],20,20,20,20,20,20,5,
 7,7,5,5,5,5,5,5,5,5,5,5,7,5,5,7,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,
 5,5,5,12,20,5,20,12,5,5,5,5,5,5,16,20,16,20,20,20,20,
 20,20,20,20,16,20,[15,20],[15,20],20,20,20,[15,20],20,
 20,20,20,20,[15,20],20,20,20,20,20,20,16,20,20,20,20,20,
 20,20,20,20,20,20,20,20,20,20,15,20,20,20,20,20,15,20,20,
 20,20,20,5,5,5,5,5,5,5,5,5,5,20,5,20,16,16,16,5,7,20,
 20,20,7,5,5,5,20,20,20,5,5,5,5,5,5,5,5,5,5,20,20,16,
 16,16,7,5,20,20,20,5,7,5,5,20,20,20,5,20,5,16,5,20,5,
 16,5,5,20,20,20,5,5,5,5,11,11,5,5,20,20,11,11,5,5,5,5,
 5,20,5,5,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,20,5,20,16,5,20,20,20,20,20,5,5,5,5,5,5,5,12,12,20,
 20,5,16,5,20,5,20,5,5,20,20,20,20,5,5,11,11,5,5,5,20,
 20,11,11,5,5,20,16,16,5,5,16,16,16,16,5,5,20,20,20,5,5,
 7,7,20,20,20,5,5,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,20,20,20,5,[15,20],20,20,20,5,5,5,20,20,5,5,12,
 12,5,5,5,20,5,5,15,5,20,20,5,5,11,11,5,5,5,20,20,11,5,
 11,5,5,7,13,12,12,5,5,11,12,13,5,5,16,16,13,11,12,5,20,
 20,20,5,5,12,5,5,5,12,5,5,5,20,20,20,20,5,20,20,12,5,
 20,20,20,5,12,5,5,5,5,5,20,20,20,20,20,20,20,20,20,20,
 15,15,20,20,20,5,5,20,20,5,20,20,20,20,20,20,20,20,5,5,
 20,20,20,20,5,20,20,20,20,20,20,5,20,20,20,20,5,20,20,
 20,20,20,5,20,5,11,12,12,5,5,5,5,12,12,11,12,11,11,5,5,
 5,5,12,11,12,5,5,12,11,11,11,5,5,5,5,11,12,12,12,5,5,
 5,11,12,12,12,5,5,5,5,5,5,12,11,12,5,5,12,12,11,5,11,
 12,11,11,12,11,5,5,5,20,20,5,16,20,20,5,5,20,5,5,5,20,
 5,5,20,5,5,5,5,5,5,5,20,5,5,20,5,5,5,20,20,15,5,20,
 20,20,20,5,20,5,20,20,20,5,[15,20],16,[15,20],11,11,
 20,20,20,12,13,13,11,11,11,11,5,20,16,16,20,5,5,20,5,20,
 20,5,20,5,20,20,5,5,5,20,5,5,20,5,5,20,5,20,20,20,20,
 20,20,5,20,20,20,5,20,5,20,20,20,5,16,16,16,12,12,20,20,
 20,12,12,12,12,20,20,20,20,16,16,20,5,5,20,5,20,20,5,20,
 5,20,20,5,5,5,20,5,5,20,5,5,20,5,20,20,20,20,20,20,5,
 20,20,20,5,20,5,20,20,20,5,16,16,16,12,12,20,20,20,12,
 12,12,12,20,20,20,20,16,20,5,5,20,20,5,5,20,5,5,20,5,5,
 5,20,5,5,20,20,5,5,20,5,20,5,20,20,20,5,5,20,20,20,5,
 5,5,5,5,5,5,16,[15,20],16,12,13,20,20,20,11,11,11,13,
 11,11,11,16,[16,20],16,[16,20],16,16,16,[16,20],
 [16,20],16,[16,20],16,16,16,16,16,16,16,16,16,16,16,16,
 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
 16,16,16,16,16,16,7,16,7,16,16,16,16,16,[16,20],16,
 [16,20],[16,20],16,16,[16,20],[16,20],[16,20],16,20,
 [16,20],[16,20],20,[16,20],[16,20],16,[15,20],
 [16,20],[16,20],[16,20],[16,20],[16,20],[15,20],
 [15,20],[15,20],16,15,20,[16,20],16,[16,20],7,
 [16,20],16,[16,20],[16,20],[16,20],[16,20],[16,20],
 7,16,15,15,16,16,15,7,[16,20],[15,16,20],[16,20],7,
 [16,20],[16,20],[15,16,20],20,20,20,20,20,20,20,20,20,
 20,20,20,20,20,20,20,20,[16,20],20,20,[16,20],20,20,
 [15,20],[15,20],16,[15,20],20,20,20,[16,20],16,20,20,
 16,20,20,[16,20],[18,20],16,16,[15,16,20],15,[16,20],
 [16,20],[15,16],[16,20],16,[15,16,20],[16,20],
 [16,20],20,20,20,20,20,20,20,20,5,5,20,20,5,20,5,5,5,
 20,5,20,20,5,20,20,5,20,20,13,14,5,5,5,20,[16,20],20,
 20,20,5,5,16,20,16,16,[16,20],15,13,[16,20],16,16,
 [15,20],13,12,12,5,5,11,20,5,20,5,5,5,5,[15,20],20,5,
 5,5,5,20,20,15,5,20,[15,20],5,5,20,[16,20],13,20,5,5,
 20,[16,20],16,5,20,20,20,5,20,20,16,16,[16,20],12,12,
 [16,20],16,[16,20],13,12,13,13,20,20,20,20,20,20,20,20,
 20,[16,20],20,20,20,20,20,[15,20],20,20,20,20,[15,20],
 20,20,20,[16,20],[15,20],16,20,20,20,[16,20],16,20,20,
 20,20,[15,20],20,20,16,16,[16,20],16,[15,16,20],
 [16,20],[16,20],[15,16,20],15,[16,20],16,16,20,16,20,
 20,20,5,20,5,15,5,5,20,5,20,20,5,[15,20],5,5,[16,20],
 5,20,20,[15,20],20,13,5,5,5,[16,20],14,5,5,20,5,5,5,
 5,16,16,[16,20],13,13,[16,20],[16,20],16,12,13,13,12,
 20,5,20,5,5,20,5,20,5,5,5,20,5,20,20,20,5,5,[16,20],
 20,20,20,[16,20],[15,16,20],[15,16,20],5,5,5,16,14,5,
 5,5,5,5,5,5,16,16,[16,20],12,13,[16,20],[16,20],
 [16,20],12,13,[16,18],13,5,5,11,20,20,5,20,5,20,5,5,
 5,5,5,20,5,5,20,5,5,16,[16,20],13,[16,20],20,20,20,
 20,[16,20],20,20,20,20,20,[15,20],20,16,16,[16,20],
 [16,20],13,16,[16,20],[16,20],15,16,13,13,12,5,5,5,5,
 20,5,5,5,5,20,5,5,20,5,20,[16,20],5,5,20,[15,20],
 [16,20],16,20,5,5,20,16,5,20,20,20,20,20,5,16,16,
 [16,20],13,12,16,[16,20],[16,20],12,12,12,12,20,5,5,
 20,[15,20],5,5,5,20,5,20,5,20,5,5,[16,20],20,5,5,
 [16,20],16,[16,20],5,5,20,[16,20],14,5,20,5,5,5,20,
 20,16,16,[16,20],12,13,16,16,[16,20],16,13,16,14,12,12,
 5,20,20,5,20,5,5,[16,20],5,20,5,20,[15,16,20],5,5,
 [16,20],16,16,19,20,5,20,20,16,5,5,20,20,20,20,20,16,
 16,[16,20],13,13,16,16,[16,20],13,13,13,13,5,5,5,20,
 20,20,20,20,20,20,20,20,20,[15,20],20,20,20,20,20,15,20,
 20,20,20,20,20,20,20,20,20,16,16,[15,20],[15,20],15,15,
 20,[15,20],15,[15,20],20,16,20,20,20,20,16,20,5,5,5,5,
 5,20,5,5,20,5,5,20,20,12,16,5,5,5,20,13,20,20,20,5,5,
 16,16,20,16,16,13,11,16,16,20,11,13,12,12,5,11,5,5,5,5,
 20,5,20,5,5,20,5,5,20,20,11,20,5,5,20,20,20,5,5,20,5,
 5,5,16,20,16,16,12,11,16,16,20,11,12,12,12,5,5,5,5,5,
 20,5,20,20,5,20,5,5,5,20,16,12,20,20,5,20,13,5,5,5,16,
 16,5,5,16,16,20,11,13,16,20,16,12,11,12,13,5,11,5,20,5,
 20,20,5,20,20,5,20,5,20,20,20,5,5,5,20,11,5,5,5,5,5,5,
 5,16,20,16,12,12,20,20,20,12,12,11,11,20,5,20,5,5,20,5,
 20,16,20,20,5,20,[16,20],13,5,5,5,20,11,5,5,5,5,5,5,
 5,16,20,16,12,13,20,[16,20],16,13,13,11,11,5,5,11,5,20,
 20,5,20,5,5,20,20,20,12,20,20,5,20,[18,20],20,20,20,16,
 16,20,16,16,16,16,11,[15,16,20],16,16,16,12,13,20,20,5,
 11,5,20,5,20,20,5,20,5,20,11,12,5,5,5,20,11,5,5,5,5,5,
 5,5,16,20,20,12,11,20,20,20,11,12,11,11,20,5,5,20,20,20,
 20,20,20,[15,20],15,20,20,20,20,20,20,20,20,20,20,20,20,
 20,7,[15,20],[15,20],20,16,[15,20],[15,20],15,15,20,
 20,20,16,20,20,5,20,5,5,20,20,20,11,20,5,5,20,20,5,5,5,
 16,20,5,5,16,16,20,11,12,16,20,16,12,11,12,12,5,5,5,20,
 20,5,5,16,13,[16,20],5,5,5,20,12,5,5,5,5,5,5,5,16,20,
 16,13,13,20,16,[16,20],12,12,11,11,11,5,5,16,20,20,16,
 16,[16,20],20,20,20,20,20,20,20,20,20,20,20,20,16,
 [15,20],16,20,[16,20],[15,20],16,[15,16],[15,16],20,
 20,20,[16,20],20,20,5,5,16,20,20,5,5,5,20,11,5,5,5,5,
 5,5,5,16,20,16,12,12,20,16,16,12,12,11,11,5,5,5,5,20,
 12,11,5,5,5,20,11,5,5,5,5,5,5,5,20,20,16,11,12,20,20,
 20,12,11,11,11,5,5,20,20,12,20,20,5,20,20,20,20,20,20,
 16,20,16,16,16,16,16,12,13,16,16,16,11,[15,16,20],20,20,
 5,11,5,[16,20],16,20,20,20,20,20,20,20,20,20,20,16,16,
 16,[15,20],16,[15,16],20,15,[15,16],16,20,[16,20],20,
 20,20,20,[16,20],20,13,20,12,20,20,11,12,11,16,16,11,11,
 16,16,16,12,16,16,[16,20],15,15,13,13,12,20,20,20,12,11,
 16,20,20,20,20,13,12,12,16,16,16,16,15,15,13,16,15,
 [16,20],12,16,12,13,20,20,20,20,20,20,[16,20],5,20,5,
 20,5,5,5,16,16,20,11,12,16,20,[16,20],12,11,13,13,11,5,
 5,5,20,20,5,20,5,20,20,5,5,16,16,20,11,12,20,20,20,12,
 11,12,12,20,20,5,20,[16,20],20,20,20,20,20,16,16,16,16,
 16,13,11,16,16,20,12,13,20,20,20,11,5,7,20,20,20,20,20,
 20,20,[15,20],7,[15,20],20,20,7,[15,20],[15,20],20,
 20,15,16,20,16,20,20,16,[15,16,20],[16,20],[16,20],20,
 [15,16,20],16,7,16,13,13,7,[15,16,20],[16,20],12,12,
 16,7,20,20,20,5,20,5,5,20,16,20,16,16,12,11,16,16,20,11,
 12,12,12,5,5,5,20,20,20,5,16,16,16,16,12,11,16,16,20,11,
 12,20,20,20,5,5,5,5,20,20,20,16,16,13,11,16,[15,16,20],
 20,11,12,12,13,5,5,11,20,5,5,16,16,20,11,16,16,20,
 [16,20],20,11,[15,16,20],13,12,5,5,5,5,16,16,20,11,16,
 16,20,[16,20],20,11,13,13,20,20,5,16,20,16,16,[16,20],
 11,16,16,20,11,16,13,13,5,20,20,20,16,16,16,11,16,7,20,
 11,20,[16,20],13,5,5,12,16,16,16,16,16,16,7,16,20,20,
 16,16,20,20,16,20,20,7,16,16,16,16,16,16,20,16,20,15,16,
 16,15,16,20,16,20,16,20,20,16,12,[16,20],15,[15,16,20],
 12,12,12,12,12,11,12,[16,20],[15,16,20],16,12,11,12,12,
 12,11,11,16,16,[16,20],[16,20],16,16,20,20,20,16,
 [15,16,20],16,[15,16,20],[15,16,18,20],20,20,20,15,
 [15,16,20],[15,16,20],[15,16,20],20,20,20,12,12,11,12,
 11,11,12,12,11,11,12,12,11,11,12,12,12,11,5,5,5,20,5,7,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,20,5,
 20,20,5,20,20,5,5,20,5,20,5,20,5,20,20,20,20,20,20,20,
 5,5,11,11,11,20,20,20,5,11,11,11,7,20,16,[16,20],
 [16,20],[16,20],15,16,16,[16,20],[16,20],16,16,20,
 [16,20],[16,20],20,20,[16,20],[16,20],20,15,16,16,15,
 7,20,[15,20],16,16,7,20,20,20,[15,20],15,16,15,16,15,
 [16,20],[15,20],16,15,16,7,[16,20],[16,20],20,20,20,
 16,7,15,[15,16,20],15,7,7,20,20,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,20,5,5,5,5,20,5,5,20,20,20,20,5,5,20,5,
 20,5,5,5,20,20,5,20,20,20,20,11,11,5,5,5,11,11,11,11,
 20,20,20,20,[16,20],[16,20],[16,20],[15,20],[16,20],
 16,[16,20],16,16,16,20,[16,20],20,20,[16,20],[16,20],
 20,[16,20],[15,20],20,16,16,16,[15,20],20,[15,20],16,
 7,20,16,15,15,15,7,16,16,20,16,16,16,15,16,7,20,20,
 [16,20],[16,20],[15,16,20],7,7,15,20,15,16,7,20,5,5,
 5,20,20,20,20,20,5,20,5,5,5,5,5,5,20,20,20,5,5,5,20,5,
 5,16,[15,20],5,5,20,20,[15,20],5,5,5,20,20,5,5,20,20,
 15,20,20,11,11,11,11,11,11,20,13,12,13,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,5,5,5,20,5,5,5,20,5,20,5,5,20,5,
 20,5,5,5,20,20,20,20,[16,20],5,20,11,5,5,11,5,11,12,
 11,5,11,11,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,
 5,5,5,20,20,20,20,20,5,5,20,5,[16,20],5,5,5,20,20,20,
 5,20,20,20,5,11,11,5,5,12,13,11,5,11,12,13,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,20,[15,20],5,
 5,20,5,[16,20],5,5,5,20,20,20,20,[16,20],20,[15,20],
 5,11,5,11,5,12,13,12,5,12,13,20,5,5,5,5,5,5,5,5,5,5,
 5,5,20,20,5,5,5,20,5,20,5,5,20,20,5,5,20,5,20,5,20,5,
 20,20,5,5,20,20,[16,20],5,5,5,5,11,13,11,12,11,12,13,
 11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,20,
 20,5,5,20,5,[15,20],5,5,5,20,20,20,5,20,20,[15,20],5,
 5,11,5,5,13,20,12,11,13,20,13,5,5,5,5,5,5,5,5,5,5,20,
 5,5,5,5,5,5,5,5,20,20,[16,20],5,5,20,5,16,5,5,5,20,
 20,20,20,16,5,[16,20],5,11,11,5,5,12,20,13,5,13,13,20,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,[16,20],5,
 5,20,5,20,5,20,5,20,20,5,20,20,5,20,5,5,5,5,5,11,11,
 13,5,13,11,11,5,5,5,5,5,5,5,5,5,20,5,5,5,20,5,20,5,
 20,20,[16,20],5,5,20,5,[15,20],5,20,5,[15,20],
 [15,20],5,20,[15,20],20,[16,20],5,5,5,5,11,20,13,13,
 5,20,13,12,5,5,5,5,5,5,5,20,5,5,5,5,5,5,20,20,5,5,16,
 5,5,20,5,[16,20],5,5,5,20,20,5,5,[16,20],20,16,5,5,
 5,5,11,20,12,12,11,13,20,12,5,5,5,5,5,5,20,20,5,5,5,
 20,5,20,20,20,5,16,5,5,20,5,16,5,5,5,20,[18,20],
 [15,20],20,16,5,16,5,5,5,5,5,16,16,19,5,19,16,16,5,5,
 5,5,5,5,20,5,5,5,5,5,5,5,20,5,20,5,5,20,5,20,5,5,5,
 20,20,5,5,20,5,20,11,5,5,11,5,11,11,11,5,11,11,11,5,5,
 5,5,20,20,5,5,5,5,5,20,20,5,5,16,5,5,20,5,20,5,5,5,
 20,20,20,5,20,[15,20],20,11,5,11,5,5,11,20,11,5,11,20,
 11,5,5,5,16,5,5,5,5,5,5,5,5,5,20,20,5,5,20,5,20,5,5,
 5,20,20,5,20,20,20,20,11,11,5,5,5,11,11,11,5,11,20,20,
 5,5,20,5,5,5,5,5,5,5,5,5,20,20,5,5,20,5,20,5,5,5,20,
 20,5,5,20,20,20,5,11,11,5,5,11,11,11,5,11,11,11,5,5,16,
 5,5,5,5,5,20,20,5,20,20,5,5,20,5,20,5,5,5,20,20,20,5,
 20,20,20,5,5,11,11,5,20,20,11,5,11,11,11,20,20,5,5,5,5,
 5,5,5,5,[15,20],20,5,5,20,5,20,5,5,5,20,20,5,20,20,5,
 16,5,11,5,11,5,20,11,11,5,11,11,20,20,5,5,5,5,5,5,5,5,
 16,16,5,5,20,5,20,5,5,5,20,16,5,16,20,16,16,5,
 [15,16,20],11,5,5,13,16,12,5,12,19,[16,20],5,5,5,5,5,
 16,16,20,20,16,5,5,20,5,20,5,5,5,20,20,5,5,20,20,
 [16,20],11,5,5,[15,16,20],5,16,16,12,5,12,12,13,5,5,
 20,5,20,5,5,[15,20],20,5,5,20,5,20,5,20,5,20,20,5,5,
 16,5,20,5,11,5,5,11,20,11,11,5,20,11,11,5,5,5,5,20,5,
 20,20,5,5,20,5,20,5,5,5,[15,20],20,5,5,20,20,20,5,11,
 5,5,5,11,11,11,11,20,20,11,5,5,5,5,20,5,[16,20],5,5,
 20,5,16,5,5,5,20,20,20,20,[16,20],5,16,11,5,5,5,11,11,
 20,20,5,20,11,20,20,20,5,16,20,20,5,20,20,5,[16,20],5,
 5,5,20,[15,20],5,5,[16,20],5,20,5,5,5,5,11,[16,20],
 11,13,5,20,16,11,5,5,16,5,16,5,5,20,5,16,5,5,5,20,20,
 20,20,16,5,16,5,5,5,5,5,11,20,20,5,20,11,20,5,5,16,16,
 5,20,20,5,20,5,20,5,20,20,20,5,[15,20],12,16,5,11,11,
 5,20,20,[16,20],12,5,12,13,16,5,5,16,5,5,20,20,20,5,5,
 5,[15,20],20,20,5,20,13,16,5,5,11,5,5,13,[16,20],12,
 20,12,20,16,5,[16,20],5,5,20,5,16,20,5,20,20,20,5,5,
 16,5,16,[15,16,20],5,5,11,5,12,13,12,20,16,12,19,20,5,
 20,20,5,20,5,20,5,20,16,5,20,16,20,16,5,16,20,20,20,16,
 11,12,5,20,20,20,20,20,[15,20],20,16,16,20,16,[15,20],
 [15,20],16,16,[16,20],16,20,15,20,20,15,20,16,7,16,20,
 16,16,16,5,20,5,20,5,5,5,20,20,5,5,20,5,20,5,5,5,5,11,
 11,11,11,11,11,11,11,20,5,20,5,20,5,20,15,5,5,20,20,20,
 5,5,11,5,11,20,11,20,5,11,11,11,20,16,[15,20],20,20,20,
 20,[15,20],[15,20],6,20,[15,20],20,20,20,20,20,20,20,
 16,[16,20],15,20,20,16,5,5,5,20,20,5,5,20,[15,20],20,
 5,5,11,5,5,11,11,20,11,11,20,11,16,[16,20],[16,20],6,
 [15,20],16,16,20,16,[16,20],20,20,20,20,20,[16,20],
 [15,16,20],15,[15,20],15,[16,20],[15,16,20],5,5,20,
 20,20,20,16,5,16,5,5,5,5,5,11,20,20,5,20,11,20,20,20,
 [15,20],20,20,[16,20],5,[15,20],5,5,5,20,11,[16,20],
 11,20,11,13,16,11,20,20,20,20,16,5,[16,20],5,5,5,11,5,
 11,20,20,11,20,11,20,20,20,20,16,20,[15,20],20,20,20,20,
 [16,20],20,20,15,[18,20],16,20,20,20,20,[15,20],16,
 [15,20],20,[16,20],20,20,20,16,20,20,20,20,15,20,5,16,
 16,16,11,5,20,11,5,12,20,16,5,12,12,13,16,5,16,5,20,5,
 11,5,12,13,16,5,12,12,20,20,16,20,20,20,20,[15,20],
 [16,20],[15,16,20],15,20,15,[16,20],[15,16,20],20,20,
 20,16,5,5,20,20,20,20,12,16,11,15,20,20,15,20,16,16,16,
 20,16,16,7,5,10,11,11,11,11,11,5,12,13,13,11,10,10,11,
 11,11,5,13,13,12,5,5,13,12,13,10,11,11,11,5,13,13,12,11,
 11,11,11,12,12,13,11,11,11,11,20,20,11,20,11,20,20,11,20,
 20,11,11,11,20,20,13,12,12,20,20,20,20,16,16,20,5,5,20,
 5,20,20,5,20,5,20,20,5,5,5,20,5,5,20,5,5,20,5,20,20,
 20,20,20,20,5,20,20,20,5,20,5,20,20,20,5,16,16,16,12,12,
 20,20,20,12,12,12,12,20,20,20,5,7,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,20,20,5,5,5,5,5,20,5,20,20,20,5,5,20,5,
 20,5,20,5,5,20,20,5,20,20,20,20,20,11,11,11,5,5,5,20,
 11,11,11,5,5,20,5,20,5,20,20,5,5,5,5,20,5,20,5,20,5,
 20,20,5,20,5,5,20,5,20,16,16,20,5,[15,20],20,16,5,20,
 20,5,20,[15,20],5,20,20,20,5,5,12,12,12,16,16,16,5,12,
 12,12,20,16,5,16,5,20,20,5,20,5,20,20,5,20,5,20,5,16,
 20,5,20,20,5,[15,20],5,5,16,16,5,5,20,20,16,5,20,20,
 20,20,20,20,20,20,20,16,16,12,12,12,5,5,5,16,12,12,12,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,20,5,20,
 20,20,5,5,20,5,20,5,20,5,5,20,20,20,20,5,20,11,11,5,11,
 11,11,11,11,5,11,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 5,5,5,5,5,5,20,20,5,20,20,5,5,20,5,20,5,20,5,5,20,
 [15,20],20,5,20,5,11,11,11,11,5,11,11,11,11,5,11,11,5,
 5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,[16,20],5,
 5,5,5,5,5,[16,20],5,5,5,[16,20],5,5,[15,20],
 [16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,5,5,5,20,5,[15,20],20,5,20,20,5,
 5,20,5,20,5,20,5,20,[15,20],20,5,20,20,20,5,11,11,5,
 11,11,11,11,11,11,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,[16,20],20,5,5,5,5,5,[15,20],5,5,5,[16,20],5,
 5,15,15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,20,5,5,5,5,5,20,20,20,20,20,5,5,20,5,20,
 5,20,5,5,20,20,5,20,20,20,11,11,12,12,5,12,20,5,11,5,
 12,12,5,5,5,5,5,5,5,5,5,5,20,5,5,5,20,5,20,5,5,20,20,
 5,5,[15,20],5,20,5,[15,20],5,20,20,20,5,20,5,5,5,5,
 5,11,11,11,11,11,11,11,5,11,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,5,15,5,5,5,5,5,5,15,5,5,5,[16,20],5,20,[16,20],
 [15,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,20,20,5,5,5,20,5,20,5,5,5,20,5,5,20,5,5,5,20,5,5,
 20,20,5,20,20,20,5,11,12,5,12,20,12,12,11,12,12,5,5,5,
 5,5,5,5,20,20,5,5,5,20,5,16,5,5,5,5,5,5,16,5,5,5,
 [16,20],5,5,16,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,16,5,5,5,5,5,20,5,20,20,20,5,5,20,5,5,5,
 20,5,5,20,20,20,5,5,16,11,11,5,20,5,5,11,11,5,5,5,20,
 5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,20,5,5,20,5,20,5,20,
 5,5,20,15,5,5,16,5,11,5,20,5,5,11,11,5,11,5,20,5,5,5,
 5,20,5,5,5,5,5,5,20,5,5,5,5,5,5,20,5,5,5,20,5,5,20,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,
 5,5,20,20,5,20,5,5,5,20,5,5,5,20,5,5,[15,20],20,5,5,
 16,5,5,11,20,5,5,11,11,5,11,5,20,5,5,5,20,5,5,5,5,5,
 20,5,5,5,5,5,5,20,5,5,5,20,5,5,16,16,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,20,5,20,20,20,5,5,
 20,5,20,5,20,5,5,20,20,20,5,5,16,11,11,5,20,5,11,5,11,
 5,5,5,20,5,5,5,5,5,5,20,5,5,20,20,5,5,20,20,5,5,20,5,
 5,[15,20],20,20,5,20,5,20,20,12,5,5,5,5,5,20,5,12,5,
 5,5,5,5,5,16,5,16,12,13,5,20,20,5,12,7,7,20,5,16,20,
 20,5,5,16,13,11,5,16,5,11,13,12,12,5,5,16,5,5,20,5,15,
 5,5,20,20,5,5,20,5,20,5,20,5,20,20,20,5,16,5,5,11,11,
 5,5,20,11,5,11,5,20,5,5,5,5,5,20,20,5,5,5,5,5,20,5,5,
 5,20,5,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 20,5,5,20,20,5,5,20,5,5,5,20,5,20,20,20,5,16,5,5,11,
 11,5,5,20,5,11,11,5,20,5,5,20,[15,20],5,20,20,5,20,5,
 20,5,20,5,20,5,5,20,20,5,20,5,5,5,5,5,5,12,20,20,20,5,
 12,5,5,20,5,20,5,5,5,5,20,5,5,5,20,5,5,20,20,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,20,20,20,20,20,16,16,20,20,7,
 15,20,20,20,15,20,16,20,20,20,20,20,20,15,20,20,20,20,15,
 20,20,5,5,20,5,5,20,20,5,5,20,5,20,20,[15,20],5,5,20,
 5,5,5,12,5,5,20,20,5,5,5,12,5,20,20,5,5,20,5,20,5,20,
 20,5,20,20,5,5,5,20,20,20,5,12,5,5,5,5,5,5,5,12,5,20,
 5,20,5,5,5,20,20,20,20,20,20,16,16,16,20,20,20,20,20,20,
 5,20,5,20,20,20,5,5,20,20,5,5,20,5,20,20,20,20,16,16,
 16,20,20,20,20,20,5,20,20,5,20,20,20,5,[15,20],5,20,5,
 20,5,20,20,20,5,16,5,5,11,5,5,5,20,11,5,11,11,20,5,5,
 16,5,5,5,20,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,20,7,20,20,[15,20],[15,20],7,20,16,20,20,20,20,
 20,20,[15,20],20,20,20,20,[15,20],20,20,20,5,20,5,5,
 20,20,5,5,16,5,5,11,20,5,5,5,11,11,11,5,20,5,5,20,20,
 20,20,20,20,16,16,16,20,5,20,20,20,20,5,20,20,20,20,20,
 7,5,5,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,[15,20],
 20,20,[15,20],[15,20],20,20,16,20,20,20,[15,20],20,20,
 20,20,20,20,20,[15,20],5,20,20,20,5,5,16,11,5,5,20,5,
 11,5,11,11,5,5,20,20,20,5,20,5,5,5,5,5,5,12,20,5,20,5,
 12,5,5,16,20,20,16,20,20,20,[15,20],20,20,20,20,20,20,
 20,[15,20],20,20,20,16,20,20,20,15,20,20,20,20,20,20,20,
 15,20,5,5,20,5,5,5,12,5,5,20,20,5,5,5,12,5,5,20,20,5,
 5,7,20,20,20,20,7,5,5,5,20,20,7,5,5,20,20,20,20,5,7,5,
 20,20,5,7,5,20,20,20,20,5,5,7,5,11,12,12,5,5,5,5,12,
 11,12,12,11,11,5,5,5,5,11,12,11,5,5,11,12,12,11,5,5,5,
 5,12,11,12,12,5,5,5,12,11,11,12,5,5,5,5,5,5,12,11,12,
 5,5,11,12,11,5,11,12,12,12,11,12,5,5,5,16,7,16,
 [16,20],16,16,[16,20],[16,20],16,[16,20],[16,20],16,
 15,[16,20],16,[15,20],20,20,16,[15,20],16,[16,20],
 [16,20],16,7,15,[16,20],7,15,16,[16,20],20,20,20,16,
 [16,20],16,15,[16,20],16,20,7,16,7,16,16,15,20,20,20,
 [15,16,20],[16,20],[16,20],16,7,7,15,16,[16,20],
 [16,20],[16,20],16,16,[16,20],[16,20],[16,20],16,16,
 20,[16,20],[16,20],20,[16,20],[16,20],[16,20],
 [16,20],[16,20],[16,20],[16,20],[16,20],[16,20],
 [15,20],[15,20],16,16,7,20,[16,20],[15,20],[16,20],
 15,[16,20],[16,20],[16,20],[15,20],16,[16,20],16,15,
 16,7,[16,20],[16,20],[16,20],[16,20],[15,16,20],16,
 7,15,[15,16,20],15,16,7,[16,20],16,16,16,[16,20],
 [16,20],[16,20],16,[16,20],[16,20],16,16,16,16,16,16,
 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,7,16,16,
 7,20,20,20,20,20,20,20,20,20,20,20,20,20,20,[16,20],20,
 [15,20],20,20,20,20,20,20,[15,16,20],[15,20],16,
 [15,16,20],[16,20],20,20,20,16,20,20,20,[16,20],20,20,
 [16,20],[16,20],16,16,15,16,20,16,20,[16,20],
 [15,18,20],16,[15,18,20],[16,20],16,[16,20],20,5,5,
 20,20,20,20,5,5,20,5,20,20,20,20,20,5,5,5,5,5,5,
 [16,20],20,[15,16,18,20],[16,20],20,5,5,5,[16,20],5,
 5,5,[16,20],5,20,20,[16,20],16,16,15,13,12,5,5,13,12,
 [16,20],13,[16,20],16,[16,20],20,5,20,20,5,20,5,5,20,
 5,20,5,20,20,20,5,5,5,5,5,5,[15,18,20],5,14,14,20,5,
 5,20,16,5,5,20,[15,20],5,[15,20],[16,20],[16,20],16,
 16,12,12,20,5,20,12,12,13,12,[16,20],[16,20],16,5,20,
 20,20,20,5,5,20,20,5,5,20,5,5,20,5,5,20,20,20,16,5,
 [16,20],14,20,20,5,5,13,5,20,20,20,20,5,20,[16,20],16,
 16,[16,20],12,5,11,12,13,12,[15,20],13,[16,20],
 [16,20],16,20,20,5,20,5,20,20,5,5,5,20,20,5,5,5,20,20,
 5,20,[16,20],20,14,20,20,5,5,20,14,5,5,5,[15,20],5,
 20,5,[16,20],16,16,12,12,5,20,5,12,12,12,12,16,
 [16,20],[16,20],20,20,20,20,20,[16,20],20,20,20,
 [16,20],20,20,20,20,20,[15,20],20,20,[15,16,20],15,15,
 [16,18,20],[16,20],20,20,20,16,20,20,20,[15,16,20],
 [16,20],20,20,[16,20],16,16,[15,18,20],15,16,20,20,16,
 16,16,[16,20],[16,20],[16,20],[15,16],20,20,20,20,
 [16,20],20,20,20,[16,20],20,20,20,20,20,20,20,20,
 [16,20],20,16,16,20,20,20,20,[15,20],20,[15,20],16,
 [15,20],20,[15,20],20,[15,16,20],16,16,16,[16,20],20,
 20,20,16,[15,18,20],15,[15,18,20],[15,16],16,16,20,5,
 5,20,5,5,5,20,5,5,20,5,20,20,5,5,[15,20],5,16,14,20,
 5,5,5,16,5,20,20,[16,20],20,20,5,[16,20],16,16,12,13,
 20,20,20,12,13,12,12,[16,20],16,[16,20],20,20,[16,20],
 20,20,20,[16,20],[15,20],20,20,20,20,20,20,20,[16,20],
 20,16,[16,20],[16,20],20,20,20,[16,20],20,20,20,
 [16,20],[15,20],[16,20],15,[16,20],16,16,16,16,20,20,
 16,15,[16,20],[15,18,20],16,16,16,[16,20],5,20,5,20,
 5,20,20,20,20,5,20,20,5,5,[16,20],20,14,20,20,5,5,20,
 14,5,20,5,[15,18,20],20,20,5,[16,20],16,16,12,12,5,5,
 5,12,12,12,12,16,16,16,20,20,20,20,20,16,16,5,5,5,5,5,
 5,20,20,13,[16,20],20,5,5,5,12,5,5,5,20,20,5,5,20,16,
 16,12,12,5,11,5,13,13,11,11,20,16,[16,20],20,20,20,20,
 20,20,20,20,20,20,20,20,16,20,20,7,20,20,20,20,20,20,20,
 20,[15,20],20,16,20,[15,20],7,[15,20],15,20,16,20,20,
 20,16,20,20,[15,20],7,[15,20],20,5,20,16,20,5,5,5,5,
 5,20,20,20,20,20,20,5,5,5,11,5,5,5,20,5,5,20,20,16,16,
 12,12,5,5,5,12,12,11,11,20,16,16,20,20,20,5,5,5,5,5,5,
 20,20,20,16,13,20,5,5,5,12,5,5,5,20,20,5,20,20,16,16,
 12,13,11,5,5,13,13,11,11,20,16,16,20,20,20,5,5,5,5,5,
 20,20,20,20,20,20,5,5,5,11,5,5,5,20,5,5,5,20,16,16,12,
 12,20,20,5,12,12,11,11,20,20,20,20,20,20,20,20,20,20,20,
 20,20,15,20,20,20,20,20,20,20,20,20,20,20,20,20,[15,20],
 [15,20],7,20,15,20,16,20,16,20,20,20,[15,20],[15,20],
 15,20,5,5,5,5,5,16,16,16,16,19,20,5,5,5,12,5,5,5,20,
 16,5,16,20,7,16,20,[15,16,20],12,5,5,13,14,11,11,20,16,
 16,5,5,5,5,5,16,16,16,16,16,20,5,5,5,12,5,5,5,20,20,
 20,20,20,16,16,20,13,20,20,5,13,19,11,11,20,16,16,5,5,
 20,20,20,20,20,[16,20],11,20,20,5,5,13,5,5,20,20,20,5,
 20,16,20,16,11,13,5,5,11,12,11,12,13,[16,20],20,16,20,
 5,5,5,16,5,11,20,20,5,5,20,20,5,5,5,16,5,20,5,16,16,
 20,12,11,5,5,5,11,12,12,12,16,16,20,5,5,5,16,5,11,
 [15,16,20],20,5,5,20,13,20,5,5,16,5,16,5,16,16,20,13,
 11,5,5,11,11,13,12,12,[15,16,20],16,20,16,20,20,16,
 [16,20],12,20,20,5,5,16,5,20,16,20,20,5,16,16,20,16,11,
 13,5,5,12,[15,16,20],11,20,14,[16,20],20,16,5,20,20,
 20,11,20,5,5,5,20,5,20,20,20,5,5,20,16,20,16,11,12,5,5,
 5,12,11,12,12,16,20,16,20,20,16,[16,20],20,5,5,5,12,5,
 20,5,20,20,5,5,16,16,16,12,20,5,12,20,20,13,12,11,20,16,
 [16,20],20,20,7,[15,20],20,20,20,16,16,20,20,16,20,16,
 20,16,16,[15,20],16,20,16,20,20,20,16,16,20,16,7,15,
 [18,20],20,20,5,5,5,16,5,20,5,20,20,5,20,16,16,16,
 [15,16,20],20,5,11,5,20,11,13,11,16,16,16,20,20,20,11,
 12,20,11,[16,20],13,20,16,12,20,16,16,16,13,15,20,20,20,
 16,12,12,13,[16,20],16,15,20,11,11,13,20,20,11,12,16,20,
 16,12,16,7,16,16,12,20,20,20,13,7,13,12,[15,16,20],7,
 [16,20],20,20,20,15,20,20,20,20,20,20,20,15,[15,20],
 [15,20],20,20,20,20,16,20,20,15,16,15,[15,20],[15,20],
 5,5,20,5,20,20,20,20,5,20,16,20,16,11,12,5,20,20,12,11,
 12,12,20,20,20,20,12,20,5,5,20,5,16,5,20,16,20,11,11,20,
 5,5,11,11,12,12,20,20,20,16,20,5,5,16,5,5,5,16,16,20,
 13,11,11,5,5,11,12,12,13,16,16,20,20,16,[16,20],16,12,
 16,16,15,16,16,12,12,20,20,20,13,13,15,16,15,16,[16,20],
 5,5,16,5,16,5,16,16,20,12,11,5,5,5,11,12,12,12,16,16,
 20,16,20,20,5,16,16,20,16,11,13,5,20,20,13,11,20,19,
 [16,20],20,16,20,5,5,20,16,20,16,11,12,5,11,5,13,11,13,
 13,16,20,[16,20],20,16,20,16,16,[15,20],20,20,20,20,
 [16,20],20,16,[15,16],[16,20],[15,16],16,[15,20],5,
 20,16,16,16,12,20,5,5,20,20,12,11,11,20,16,16,5,16,16,
 20,16,11,[16,18,20],5,20,11,[16,20],13,13,16,16,20,16,
 16,16,13,20,5,11,5,20,11,[16,20],12,16,16,16,16,16,20,
 20,20,20,16,16,16,15,16,15,16,16,16,16,16,16,20,20,20,16,
 20,16,16,7,16,20,16,20,16,20,16,16,16,20,16,16,7,12,12,
 11,11,12,12,12,12,[15,16,20],16,[15,16,20],11,11,11,12,
 11,12,12,[15,16,20],[16,20],15,5,5,11,12,12,11,20,20,
 20,5,12,11,11,11,20,20,20,11,11,11,12,20,20,20,12,12,11,
 [15,16,20],[16,20],16,12,12,[15,16,18,20],16,
 [15,16,20],12,15,[16,20],[15,16,20],16,[16,20],
 [15,16,20],16,16,16,20,5,20,20,5,20,5,20,5,5,5,5,20,5,
 5,5,20,5,5,5,20,5,5,5,5,20,20,[15,20],16,20,5,20,5,
 16,5,5,5,20,5,20,5,20,20,20,11,11,11,11,11,20,20,20,11,
 13,12,13,16,16,[16,20],[16,20],[16,20],[16,20],16,16,
 [16,20],16,[16,20],16,20,[15,20],[16,20],20,16,
 [16,20],[16,20],20,[16,20],20,[16,20],[16,20],15,20,
 7,16,15,16,6,20,16,7,7,15,[15,20],16,16,16,16,15,16,7,
 7,[15,16,20],[16,20],[16,20],20,20,20,15,16,15,16,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,20,5,20,
 [16,20],20,5,5,5,5,20,5,5,5,20,5,20,20,20,16,20,20,12,
 5,11,5,5,5,5,13,13,13,12,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,5,5,5,5,5,5,20,20,20,[16,20],5,5,5,5,5,20,5,20,
 5,5,20,20,20,20,[16,20],5,12,20,11,5,5,5,11,5,12,13,
 12,20,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,
 20,5,20,20,5,5,5,5,20,5,5,5,5,20,20,20,20,[16,20],20,
 13,12,5,5,5,12,5,11,12,13,20,13,5,5,5,5,5,5,5,5,5,5,
 5,5,20,5,5,5,5,20,5,20,20,5,[16,20],20,5,5,20,5,5,5,
 20,5,5,20,5,20,5,[16,20],20,13,12,5,5,11,11,5,5,20,12,
 20,12,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,20,5,20,20,20,
 [15,20],20,5,5,20,5,20,5,5,5,20,5,20,5,20,[15,20],20,
 20,13,5,11,5,5,5,12,12,20,13,12,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,20,5,5,5,5,5,5,5,
 20,20,5,11,13,11,5,5,5,11,5,12,12,11,13,5,5,5,5,5,5,5,
 5,5,5,20,5,5,5,20,5,5,20,5,16,20,5,5,20,5,20,5,20,5,
 20,5,5,5,20,[16,20],20,13,13,5,5,5,5,5,11,12,20,12,13,
 5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,20,5,5,[16,20],20,5,
 5,5,5,20,5,20,5,20,20,5,5,20,20,20,13,20,11,12,5,5,5,
 5,13,13,12,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,20,12,11,5,5,11,11,
 5,5,13,11,13,11,5,5,5,5,5,5,20,20,5,5,5,20,5,5,5,5,
 16,5,5,5,5,5,5,5,5,5,20,20,20,5,5,16,5,20,13,5,5,5,5,
 5,5,13,20,13,13,5,5,5,5,5,5,16,5,5,5,20,5,20,5,15,20,
 [15,20],5,5,5,5,5,5,5,5,5,5,5,5,5,20,[15,20],20,11,
 5,11,5,5,11,5,11,11,11,20,5,5,5,5,5,5,5,5,5,5,5,5,15,
 5,20,16,5,5,20,5,5,5,5,5,20,5,[15,20],5,5,[16,20],5,
 20,11,11,5,5,5,11,5,20,20,20,11,5,5,5,16,5,5,5,5,5,5,
 5,5,5,20,5,5,5,5,5,20,5,5,5,5,20,5,[15,20],5,20,20,
 11,11,5,5,5,11,5,11,11,11,20,20,5,5,15,5,5,5,5,5,5,5,
 5,5,16,5,5,5,5,5,5,5,20,5,5,[15,20],5,20,5,16,5,11,
 20,11,5,5,11,5,5,11,11,20,11,5,5,15,5,5,5,5,5,15,5,20,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,20,20,20,5,11,11,
 5,5,5,11,11,11,11,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,20,20,11,11,5,11,5,11,5,5,11,11,11,
 11,5,5,5,5,5,5,5,5,5,16,5,5,20,5,5,20,5,5,5,5,16,5,
 16,5,[16,20],5,11,[16,20],11,5,5,20,5,5,13,12,16,16,
 20,5,5,5,20,16,5,16,16,16,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,16,[16,20],16,5,20,13,5,11,5,12,13,12,12,5,5,15,5,
 [15,20],5,20,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,16,
 20,5,20,20,5,5,11,11,5,5,11,20,11,20,5,5,5,5,[15,20],
 5,20,20,5,5,20,5,20,5,5,5,[15,20],5,5,5,20,20,5,11,
 11,5,5,5,5,11,11,11,20,20,11,5,5,5,5,5,20,16,5,5,5,5,
 5,5,5,5,5,5,5,5,16,20,5,20,11,5,5,20,5,20,5,11,20,11,
 11,16,15,5,16,[16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,16,
 20,20,13,12,5,5,11,20,11,5,12,16,12,16,20,5,[15,20],16,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,5,5,5,5,5,5,
 11,20,11,20,5,5,[16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,
 16,20,20,[16,20],16,5,13,20,11,5,5,12,12,12,13,5,20,16,
 20,5,5,5,20,20,5,5,16,5,15,5,20,[16,20],5,12,12,11,5,
 5,5,20,13,13,[16,20],16,12,[16,20],[15,18,20],5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,13,[16,20],13,5,11,5,5,20,5,
 12,12,12,16,20,20,20,20,20,20,20,16,20,20,[16,20],20,
 [16,20],16,[16,20],16,[16,20],15,20,20,20,15,20,20,
 [16,20],[15,16,20],[16,20],15,5,5,5,5,5,5,5,5,20,5,
 16,5,16,16,16,16,12,20,20,20,5,16,5,11,20,20,20,5,
 [15,20],5,[15,20],5,5,5,16,5,20,5,[15,20],20,5,11,
 11,5,5,11,5,5,11,20,20,11,11,5,5,20,5,15,5,5,16,5,5,5,
 20,20,11,20,11,11,5,5,5,5,20,11,11,11,5,13,15,5,5,16,5,
 16,5,[15,20],[16,20],5,12,12,5,5,20,5,5,11,16,
 [16,20],13,12,20,5,5,5,5,5,5,5,5,20,5,11,11,11,5,5,5,
 5,11,11,11,11,11,5,16,[15,20],16,5,20,16,16,16,16,12,
 11,20,20,20,5,5,16,16,20,20,20,5,5,20,5,16,5,5,16,5,20,
 11,5,5,5,5,5,5,20,20,20,11,16,5,16,5,15,5,[16,20],16,
 11,[16,20],13,20,5,5,5,11,16,12,13,16,5,5,5,16,5,20,
 [15,20],11,11,5,11,5,5,5,11,20,11,11,20,5,5,5,16,16,5,
 13,12,5,5,11,5,13,20,12,16,16,12,5,5,5,16,20,12,16,20,
 5,5,11,5,5,16,11,[16,20],13,5,20,[16,20],5,16,12,20,
 5,11,5,11,5,16,13,12,12,5,16,16,12,13,5,11,5,13,5,20,
 16,11,[16,20],16,20,5,20,20,5,5,16,20,20,20,20,16,11,
 12,20,[15,16,20],[16,20],[15,20],20,20,20,20,20,15,
 [16,20],15,[16,20],20,20,5,16,5,20,20,20,20,11,12,16,
 20,12,12,13,11,11,11,20,20,20,20,12,13,12,11,11,11,20,20,
 20,11,5,5,10,10,11,13,11,11,11,5,11,10,11,13,11,11,11,
 10,11,10,12,11,11,11,5,5,11,12,12,13,5,11,13,12,12,11,
 12,13,12,20,11,20,20,20,20,20,20,5,5,5,20,20,5,20,5,20,
 20,5,5,5,20,20,20,20,5,5,20,5,20,20,20,16,16,20,5,20,
 20,16,5,5,5,5,5,20,20,20,20,20,20,20,12,12,12,20,20,20,
 20,12,12,12,20,20,20,20,20,20,5,5,5,20,20,20,5,5,20,20,
 20,5,5,5,[15,20],20,16,5,20,16,16,20,20,[16,20],5,
 [16,20],5,20,20,5,5,20,20,[16,20],13,[16,20],12,5,
 [15,20],13,16,16,[16,20],[16,20],5,[16,20],13,13,20,
 20,20,20,20,20,20,20,20,20,20,20,20,[16,20],[15,20],20,
 20,20,20,20,20,20,20,20,16,16,[16,20],20,[16,20],20,
 [16,20],20,20,20,20,[15,20],[15,20],20,16,[15,20],16,
 20,16,15,16,[16,20],[16,20],[15,16],[16,20],20,16,
 [15,16,20],16,5,5,5,20,5,5,5,20,20,5,5,5,20,20,20,5,
 5,20,20,5,20,5,5,16,16,20,5,[15,20],20,[16,20],5,5,
 20,5,5,[16,20],20,16,16,16,20,5,12,12,12,16,[16,20],
 [16,20],5,12,12,12,20,5,20,20,20,20,5,20,5,5,20,20,5,
 5,5,5,5,16,20,20,5,5,16,16,20,20,20,5,[16,20],20,20,
 20,5,20,20,20,13,14,[16,20],5,5,15,12,13,[16,20],16,
 16,11,[15,20],13,12,20,20,5,20,5,5,[15,20],5,20,5,
 [16,20],5,5,5,5,5,5,5,20,20,5,16,16,15,5,[15,20],20,
 [16,20],5,5,20,5,20,[16,20],5,13,20,14,20,5,12,13,12,
 [16,20],16,[16,20],20,13,12,12,20,5,20,20,5,20,5,5,5,
 [16,20],5,5,5,20,5,20,5,5,5,20,16,16,[15,20],5,
 [16,20],5,[16,20],20,20,5,5,20,[16,20],20,[16,20],
 16,13,12,12,16,16,13,16,[16,20],16,5,13,14,14,20,20,20,
 20,[16,20],20,20,20,[16,20],20,20,20,20,20,[16,20],20,
 [15,20],20,20,16,16,20,20,[15,20],20,[15,16,20],20,
 [18,20],16,20,20,[16,20],20,[15,20],16,16,20,20,16,
 [16,20],[15,16,20],[16,20],[16,20],[15,16,20],20,15,
 [16,20],[16,20],20,5,5,15,5,5,5,[16,20],5,20,20,5,
 20,20,5,20,5,20,16,16,[15,20],5,[16,20],5,[16,20],5,
 20,20,20,20,[15,20],20,20,13,16,20,20,13,13,13,[16,20],
 [16,20],16,20,12,13,13,5,5,20,5,5,5,16,5,5,5,20,5,5,
 5,20,20,5,16,16,20,5,[16,20],5,[16,20],20,5,5,20,20,
 [16,20],5,[15,16,20],[15,16,20],14,5,5,12,[16,18],
 13,[16,20],[16,20],[16,20],11,12,13,13,20,20,5,20,5,
 20,20,20,20,5,20,20,5,[16,20],5,20,16,16,20,5,16,5,
 [16,20],5,20,20,5,[16,20],[15,16,20],5,19,16,16,5,5,
 13,13,13,16,[16,20],16,5,13,13,13,20,20,20,20,20,5,20,
 5,5,5,5,5,20,5,20,16,16,20,5,20,5,20,5,5,5,5,20,20,20,
 12,13,[16,20],11,5,12,12,11,16,[16,20],20,5,11,13,13,
 20,20,20,20,20,20,20,20,20,20,20,20,20,20,[15,20],7,20,
 20,[15,20],20,[15,20],20,20,20,20,20,20,20,20,15,20,16,
 20,15,20,20,[15,20],15,[15,20],20,20,16,20,20,5,20,20,
 20,5,5,5,5,5,5,5,5,16,16,20,5,20,5,20,5,5,5,5,20,20,
 20,11,20,20,20,20,12,12,11,20,20,20,5,11,12,12,20,20,16,
 16,5,5,5,5,5,5,5,5,16,16,20,5,20,5,20,5,5,5,5,20,20,
 5,12,16,13,5,11,13,12,11,16,16,20,5,11,13,13,20,20,16,5,
 5,5,5,5,20,5,5,16,16,20,5,20,5,20,5,5,5,5,20,20,5,11,
 20,20,5,5,12,12,11,16,16,20,5,11,12,12,20,20,20,20,20,
 20,20,20,20,20,7,[15,20],20,20,20,20,[15,20],20,20,20,
 20,20,20,20,20,20,7,20,16,20,15,20,7,[15,20],[15,20],
 20,20,20,16,20,5,5,5,5,5,20,5,20,16,16,20,5,20,5,20,5,
 5,5,5,16,20,20,12,16,[16,20],20,20,20,13,11,16,
 [16,20],20,5,11,16,13,5,5,5,5,5,16,5,20,16,16,20,5,20,
 5,20,5,5,5,5,16,20,20,12,16,[16,20],12,5,20,
 [15,16,20],11,16,[16,20],20,5,11,[16,20],13,5,5,16,
 20,20,5,5,16,20,20,20,20,5,16,5,16,20,5,5,20,20,16,12,
 13,5,11,11,13,13,16,20,16,5,12,11,12,20,5,5,5,20,5,20,
 16,20,5,20,20,16,5,5,5,20,5,20,5,20,20,11,20,5,12,11,
 12,20,20,20,20,12,12,11,5,5,5,5,5,20,16,20,5,16,20,16,
 20,5,5,20,5,20,5,[16,20],13,12,11,5,12,11,13,20,
 [16,20],16,5,13,13,11,20,16,5,16,16,20,16,5,16,5,16,5,
 16,20,5,20,20,5,16,11,20,5,20,11,13,16,16,20,16,20,
 [16,20],11,13,20,5,20,16,20,20,5,20,5,16,5,16,20,5,20,
 20,5,20,11,20,5,5,11,12,12,16,20,16,5,12,11,12,5,20,16,
 16,20,20,20,5,16,5,16,20,5,20,20,20,20,12,20,5,11,11,20,
 [15,16,20],16,16,16,5,12,13,20,5,20,20,20,5,20,20,16,5,
 5,5,20,5,20,5,11,12,11,5,5,12,11,11,20,20,20,20,11,12,
 11,16,16,20,20,20,5,16,5,16,20,5,5,20,20,16,12,16,20,12,
 12,20,13,16,20,16,5,12,11,20,16,[15,20],16,[15,20],20,
 16,20,16,16,20,16,[15,20],16,16,16,7,20,16,16,16,16,7,
 16,16,20,20,20,16,[15,20],20,16,16,16,16,20,20,16,16,16,
 16,16,16,16,16,20,16,20,20,16,7,16,20,16,16,16,20,20,20,
 15,20,16,20,20,20,[15,20],20,15,20,20,20,20,20,20,16,
 [15,20],[15,20],15,16,15,20,20,20,5,16,5,16,20,5,20,
 20,5,20,11,20,5,5,11,12,12,16,20,16,5,12,11,12,20,16,16,
 16,20,20,20,16,20,16,[16,20],20,20,20,20,20,[16,20],
 [15,20],16,[15,16],[16,20],[15,16],20,20,16,20,5,5,
 5,5,16,5,13,[16,20],11,5,5,13,11,13,20,16,[16,20],11,
 12,12,11,16,16,16,20,16,16,16,15,16,16,20,20,20,20,16,16,
 16,15,16,15,16,16,5,5,5,5,16,5,20,20,11,5,5,12,11,12,
 20,16,16,5,12,12,11,20,5,16,20,16,16,11,[15,16,20],5,5,
 11,[16,20],20,16,20,7,12,16,11,13,5,20,20,20,13,11,
 [15,16,20],5,5,11,13,12,16,20,[15,16,20],11,12,11,13,
 5,20,5,12,11,11,20,5,11,11,12,20,20,20,5,12,11,11,20,20,
 12,20,[18,20],5,11,12,20,13,16,16,16,5,11,[15,16,20],
 20,20,[16,20],16,20,[16,20],20,[15,16],20,20,15,
 [15,16],16,20,20,[16,20],20,20,12,16,20,5,11,20,12,16,
 20,16,5,12,11,20,20,20,20,20,12,12,16,16,[16,20],15,20,
 15,13,13,20,20,20,15,13,13,16,15,[16,20],20,12,16,12,20,
 20,12,16,12,7,[16,20],[15,16,20],20,13,13,7,5,11,11,
 11,20,20,20,5,11,12,11,11,12,11,20,20,20,5,12,11,12,12,
 12,[16,20],15,[15,16,20],11,12,12,11,12,16,[15,16,20],
 [15,16,20],11,12,12,12,[16,20],[15,16,20],16,12,12,11,
 12,16,16,20,[16,20],[16,20],16,16,20,[15,16,20],16,
 [15,16,20],20,15,[15,16,20],[15,16,18,20],11,11,11,12,
 12,12,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
 [15,20],[16,20],20,20,[15,20],20,[16,20],20,20,16,
 [15,16,20],20,20,20,[16,20],16,20,20,16,20,20,20,
 [15,20],16,16,[15,20],[15,16],16,16,15,[15,18,20],20,
 20,20,16,16,[16,20],[15,18,20],20,5,5,20,20,20,20,5,
 20,20,20,5,5,5,20,20,20,5,5,5,5,16,20,5,16,[16,20],5,
 20,5,20,16,20,20,20,5,5,20,20,14,[16,20],13,[16,20],
 [16,20],13,15,13,5,12,11,16,[16,20],13,12,20,5,20,20,
 5,20,5,20,20,5,5,5,5,20,[16,20],20,5,20,20,5,[15,20],
 5,5,16,[16,20],5,5,5,20,16,5,5,20,5,5,20,20,14,16,
 [16,20],[16,20],16,12,12,12,20,20,20,[16,20],13,12,12,
 5,20,20,20,20,5,20,5,5,20,5,5,5,[16,20],20,20,5,20,5,
 [16,20],5,5,16,[16,20],5,5,20,20,16,5,20,5,20,20,5,5,
 16,[15,16,18,20],[16,20],[16,20],16,12,[16,20],13,12,
 5,5,[16,20],[15,20],13,12,20,20,5,20,5,20,5,5,5,5,20,
 5,[15,20],20,5,20,20,5,[16,20],20,5,16,[16,20],20,5,
 20,20,16,5,5,5,5,20,20,5,20,14,14,16,[16,20],12,12,12,
 5,5,20,[16,20],12,12,12,20,20,20,20,[16,20],20,20,20,
 20,20,[15,20],[16,20],[16,20],20,20,[16,20],20,
 [16,20],20,20,16,[16,20],20,20,20,[16,20],16,20,15,20,
 20,[15,20],20,20,[16,20],16,[16,20],16,16,15,
 [15,18,20],[16,20],20,16,20,[16,20],16,16,16,20,20,20,
 [16,20],20,20,20,20,20,20,[16,20],20,20,20,20,20,
 [15,16,20],20,20,16,[16,20],20,20,[15,20],[16,20],16,
 20,[16,20],20,[15,20],20,20,20,[15,16,20],16,16,
 [16,20],16,[16,20],16,[15,18,20],20,20,16,[16,20],15,
 16,[15,18,20],20,5,20,5,5,20,5,20,5,[15,20],20,5,5,
 [15,20],5,[15,18,20],5,5,16,[16,20],5,5,5,20,16,5,
 [16,20],20,20,20,5,5,14,13,16,[16,20],[16,20],13,12,
 12,20,20,5,16,12,12,13,20,[16,20],20,20,20,20,20,
 [16,20],[15,16,20],[16,20],20,20,20,20,[15,16,20],20,
 20,16,[16,20],20,20,15,[16,20],16,20,20,20,20,20,
 [15,20],20,[16,18,20],15,16,[16,20],[16,20],16,16,16,
 16,20,20,[15,16],[15,18,20],15,[16,20],20,20,5,20,5,
 20,20,[15,18,20],20,5,20,20,5,[16,20],5,5,16,[16,20],
 5,5,20,20,16,5,5,5,20,20,20,20,20,14,14,16,16,12,12,12,
 5,5,5,16,12,12,12,20,20,20,20,20,20,20,20,20,20,20,20,
 [15,20],20,20,[15,20],15,20,20,20,20,[15,20],20,20,20,
 20,20,20,20,20,20,15,15,[15,20],20,15,20,20,16,20,
 [15,20],20,20,16,20,5,5,5,20,20,20,5,5,5,5,20,20,5,20,
 16,5,5,20,20,16,20,20,20,5,5,20,5,11,[16,20],13,
 [16,20],20,13,12,11,5,11,5,16,11,13,13,5,5,5,20,20,20,
 5,5,5,5,20,5,5,20,16,5,5,5,20,16,5,20,20,5,5,20,20,11,
 20,20,20,20,12,12,11,5,20,20,20,11,12,12,5,5,20,20,20,
 20,5,5,5,20,20,5,16,20,20,20,20,20,16,5,20,5,5,20,5,5,
 13,16,12,20,16,13,11,13,11,5,5,16,12,12,11,20,5,16,20,5,
 20,20,5,16,5,5,16,16,5,5,5,20,20,5,5,5,5,5,5,5,20,11,
 20,16,16,11,12,12,5,5,5,20,12,11,12,5,16,20,5,20,5,20,
 20,5,20,16,16,5,5,5,20,20,5,5,5,5,5,5,5,13,12,16,16,
 16,11,13,12,11,5,5,20,12,11,13,20,20,5,5,5,5,20,20,5,
 16,16,20,5,20,20,16,5,20,5,20,16,20,20,20,16,12,20,16,
 20,11,12,5,20,5,16,12,20,11,[15,20],20,16,16,16,16,20,
 20,16,16,20,20,20,20,[15,20],20,20,20,20,20,20,20,16,20,
 16,[15,16],16,20,[15,16],16,20,[16,20],20,15,20,20,
 [16,20],20,20,16,20,16,20,20,7,[15,20],20,20,20,20,
 [15,20],20,20,20,20,20,20,20,7,20,20,[15,20],7,20,20,
 16,16,20,20,[15,20],15,20,20,5,5,5,20,20,5,16,20,20,5,
 20,20,16,5,5,5,20,20,5,5,20,20,11,20,20,12,11,12,20,5,
 20,20,12,12,11,16,20,16,5,5,16,16,5,5,5,20,20,5,5,5,5,
 5,5,5,[15,16,20],11,13,[15,16,20],16,11,13,13,5,11,5,
 20,12,11,12,16,16,5,16,16,16,5,5,5,20,20,5,5,5,20,5,5,
 5,16,12,16,16,16,11,13,[16,20],[16,18,20],20,5,20,16,
 11,13,16,5,20,16,16,5,5,5,20,20,5,5,5,5,5,5,5,20,11,
 20,16,16,11,12,12,5,5,5,20,12,11,12,20,20,16,16,20,20,
 20,20,[15,20],20,20,20,16,16,20,20,7,20,16,16,7,20,16,
 16,16,20,20,15,16,20,20,5,16,16,5,20,20,20,16,5,5,5,16,
 16,20,20,[16,20],[16,20],12,20,16,20,12,13,5,20,11,
 [16,20],13,20,11,16,20,5,5,5,20,20,5,5,5,5,5,5,5,11,
 11,12,20,20,11,12,11,20,5,5,20,11,11,12,16,16,16,16,
 [15,20],16,20,16,20,16,7,20,20,7,16,16,16,7,20,20,16,
 16,20,20,16,16,16,16,20,20,16,[15,20],16,16,16,16,20,20,
 16,16,16,16,15,15,16,16,15,16,20,16,20,16,20,20,16,20,20,
 20,16,5,5,5,16,16,5,5,[16,20],13,12,20,16,12,11,13,5,
 5,11,[16,20],13,12,11,20,20,16,5,20,5,20,16,5,5,20,20,
 11,20,16,12,11,12,5,5,5,16,12,12,11,20,16,20,20,5,16,16,
 16,20,20,[18,20],16,16,16,20,13,11,5,5,11,16,
 [15,16,20],20,11,7,20,20,20,20,20,20,20,20,15,20,
 [15,20],[15,20],16,20,20,20,20,16,15,20,15,20,16,16,16,
 16,16,16,16,16,16,16,16,16,16,16,16,20,20,16,7,20,16,20,
 20,20,5,5,16,20,11,20,20,16,20,12,12,11,5,5,5,16,11,12,
 12,20,20,16,16,16,12,20,16,16,16,20,[16,20],11,5,5,11,
 16,13,20,12,5,5,16,16,12,13,[16,20],16,20,13,13,11,5,5,
 11,[16,20],11,12,12,20,5,5,16,16,12,20,16,13,11,19,20,
 5,20,16,20,13,11,5,5,19,16,12,20,16,13,11,14,12,5,5,16,
 20,[15,16,20],11,20,12,[16,20],16,[16,20],20,
 [15,16,20],20,11,5,12,5,16,11,13,14,11,[16,20],16,
 [16,20],20,13,20,11,5,20,20,16,11,13,19,20,20,
 [15,16,20],7,13,13,7,20,20,20,[16,20],16,12,12,20,
 [16,20],16,16,12,12,20,20,20,15,13,15,13,15,16,13,15,13,
 20,20,20,[16,20],12,12,16,16,[15,16,20],15,
 [15,16,18,20],20,20,20,16,[15,16,20],[15,16,20],16,
 [16,20],[16,20],16,20,20,20,16,16,[16,20],[16,20],12,
 12,11,11,12,16,12,12,11,12,11,12,12,[15,16,20],12,12,12,
 12,11,12,[15,16,20],12,11,12,5,5,20,12,11,11,5,20,12,
 11,12,20,11,12,11,[15,16,20],15,[15,16,20],12,12,12,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,20,20,5,
 20,5,5,20,5,20,5,20,5,20,5,20,20,20,20,20,11,11,11,11,
 5,5,11,13,5,13,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,
 5,5,5,5,5,5,20,20,5,20,5,5,20,5,20,5,20,5,20,5,20,20,
 20,20,20,11,11,11,11,5,5,11,13,5,13,5,11,5,5,5,5,5,5,
 5,5,5,5,5,5,5,20,5,5,5,20,5,20,5,20,20,20,5,5,5,5,20,
 5,5,5,5,20,5,20,20,20,20,11,11,11,11,11,11,11,5,11,5,
 11,11,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,20,20,20,
 20,20,5,5,5,5,20,5,5,5,5,5,5,20,20,5,20,12,11,11,12,5,
 5,11,5,5,5,5,11,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,
 20,20,20,20,20,5,5,5,5,20,5,5,5,5,5,5,20,20,5,20,12,
 11,11,12,5,5,11,5,5,5,5,11,5,5,5,5,5,5,5,5,5,5,20,5,
 5,5,5,5,5,5,20,20,20,5,5,20,5,20,5,20,5,20,5,5,20,20,
 20,20,11,5,5,11,5,5,5,11,5,11,5,5,5,5,5,5,5,5,5,5,5,
 20,5,5,5,20,5,5,5,20,5,20,5,5,5,5,5,5,20,5,20,20,5,
 20,20,5,20,11,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 20,20,5,5,5,20,5,5,5,20,20,20,5,5,5,5,5,5,5,5,5,20,
 20,20,20,20,20,11,5,5,11,12,12,5,5,12,5,12,5,5,5,5,5,
 5,5,20,20,5,5,5,20,5,5,5,20,20,20,5,5,5,5,5,5,5,5,5,
 20,20,20,20,20,20,11,5,5,11,12,12,5,5,12,5,12,5,5,5,5,
 5,5,5,20,5,5,5,5,5,5,5,20,5,[16,20],5,5,5,5,5,5,5,
 5,5,5,20,20,20,5,[16,20],13,5,5,13,5,5,12,5,5,5,5,12,
 5,5,5,5,20,20,5,5,5,5,5,5,20,20,5,[16,20],5,5,5,5,5,
 5,5,5,5,5,20,20,20,[15,20],20,13,5,12,11,5,5,12,5,5,
 5,11,5,5,5,5,[16,20],20,5,5,5,5,5,5,20,20,5,20,5,5,
 5,5,5,5,5,5,5,5,20,[16,20],20,20,20,11,5,11,11,5,5,
 11,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,20,[15,20],20,
 5,5,5,5,5,5,5,5,5,20,5,20,20,[15,20],20,11,12,12,11,
 5,11,5,5,5,5,11,5,5,20,[16,20],5,5,5,5,5,15,5,20,20,
 20,5,5,5,5,5,5,5,5,5,5,5,20,20,20,20,11,11,11,11,5,5,
 5,5,5,5,11,11,5,20,5,5,5,5,5,20,5,20,[16,20],20,5,5,
 5,5,5,5,5,5,5,20,5,20,20,5,[16,20],11,12,5,13,5,12,5,
 5,5,5,5,12,20,5,5,5,5,5,5,5,20,16,20,5,5,5,5,5,5,5,
 5,5,[16,20],20,[16,20],20,16,20,11,[15,16,20],15,11,
 5,12,20,5,5,5,13,5,20,20,20,20,20,[16,20],20,20,20,
 [16,20],20,20,20,20,20,20,20,20,20,20,20,20,15,20,
 [15,16,20],15,20,20,[15,16,20],20,15,[15,20],20,20,15,
 20,20,5,5,20,5,20,5,20,[16,20],20,5,5,5,5,5,5,5,5,20,
 20,5,20,[16,20],5,20,11,12,5,11,11,11,5,5,5,11,5,5,5,
 5,5,5,[15,20],20,20,20,5,5,5,5,5,5,5,5,[16,20],5,5,
 20,20,20,20,11,11,5,11,5,11,11,5,5,11,11,5,20,5,5,20,
 20,5,16,5,5,5,5,5,5,5,5,5,5,5,20,[16,20],5,20,13,5,
 5,11,12,5,12,5,5,12,5,5,15,20,5,[16,20],[15,18,20],
 20,20,5,20,5,5,5,20,5,5,5,5,20,16,5,20,12,5,5,12,16,
 [16,20],5,5,5,13,5,5,5,5,[16,20],5,20,5,5,5,5,20,5,
 5,5,20,5,5,20,20,5,20,12,5,5,12,12,5,5,12,12,5,5,5,5,
 20,16,20,5,5,5,5,5,5,5,5,20,5,5,20,16,5,20,12,13,5,12,
 [16,20],16,5,5,5,12,12,20,20,12,16,5,5,5,5,5,5,5,5,
 [16,20],5,20,20,20,20,20,12,12,[15,18],12,5,5,
 [15,16,20],5,5,5,13,5,20,[15,16,20],20,20,20,20,20,20,
 20,20,20,20,20,20,16,20,16,[15,16,20],20,20,15,20,15,20,
 20,20,15,20,16,20,5,20,5,5,20,5,20,5,5,16,5,16,
 [16,20],16,[16,20],12,[16,20],19,14,[15,16],[16,20],
 5,5,12,16,16,14,20,20,16,20,20,20,20,16,20,20,[16,20],
 20,[16,20],16,[16,20],[15,16],20,[16,20],15,20,20,16,
 20,20,[16,20],[16,20],[16,20],5,20,5,[16,20],5,20,5,
 20,5,5,20,[16,20],5,20,11,5,5,11,11,5,5,11,11,11,5,5,
 5,5,20,5,[16,20],5,5,[16,20],5,20,20,5,20,11,5,11,11,
 11,11,5,11,5,11,5,5,5,16,[16,20],5,20,20,5,[16,20],
 20,[16,20],5,20,12,5,5,13,12,5,5,15,12,[16,20],5,5,
 [16,20],5,5,5,5,5,20,20,20,16,20,11,5,12,11,5,5,5,12,
 12,5,13,5,20,16,16,[15,18,20],20,5,16,[16,20],16,
 [16,20],12,5,16,14,16,5,5,[16,20],16,[15,16],16,16,
 20,5,5,5,[15,20],20,20,20,20,12,5,5,11,5,5,5,5,12,12,
 12,5,16,5,[16,20],20,[16,20],16,20,16,12,5,5,[16,20],
 5,5,5,16,13,5,5,5,20,5,5,[16,20],20,5,[16,20],20,5,
 5,20,12,5,5,19,16,5,5,13,20,5,20,[16,20],5,20,12,11,5,
 12,13,5,5,[16,20],5,16,5,5,5,20,20,16,20,12,12,5,12,5,
 16,5,5,5,5,[16,20],5,20,20,[15,20],20,13,5,
 [15,16,20],11,5,5,15,20,20,5,12,20,[15,20],20,
 [16,20],20,20,20,15,20,20,20,16,[16,20],20,15,[15,20],
 20,20,[16,20],[16,20],20,16,[16,20],16,[16,20],
 [16,20],[16,20],[16,20],20,20,20,16,14,[16,20],11,5,
 14,[15,16,18],14,14,5,16,5,15,[15,16,20],20,[15,16],
 20,[16,20],[15,16,20],[16,20],[15,16,20],20,20,
 [16,20],11,12,20,12,11,11,11,12,12,12,12,12,12,11,5,5,
 5,5,12,12,12,11,5,11,12,12,11,5,5,5,12,12,12,12,12,11,
 11,11,12,11,11,12,11,5,5,5,11,5,11,12,11,5,5,12,11,12,
 11,12,11,11,12,13,12,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,20,5,5,5,5,5,5,20,20,5,20,5,5,20,5,20,5,20,5,20,
 5,20,20,20,20,20,11,11,11,11,5,5,11,13,5,13,5,11,5,5,5,
 5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,20,20,5,20,5,5,5,
 5,5,20,5,5,5,5,20,20,5,5,20,20,5,11,11,5,11,11,11,5,
 11,5,11,11,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,20,
 20,5,20,5,5,5,5,5,20,5,5,5,5,20,20,5,5,20,20,5,11,11,
 5,11,11,11,5,11,5,11,11,5,5,5,5,5,5,5,5,5,5,20,5,5,5,
 5,5,5,5,20,5,20,20,5,5,5,5,20,5,5,5,5,5,20,5,20,20,
 20,5,11,11,5,5,5,11,5,5,5,5,11,5,5,5,5,5,5,5,5,5,20,
 5,5,5,5,5,5,5,20,5,20,20,5,5,20,5,20,5,20,5,20,5,20,
 5,20,20,20,5,11,11,5,11,11,11,11,11,11,11,11,5,5,5,5,5,
 5,5,5,20,5,5,5,5,20,5,5,20,5,20,20,5,5,5,5,20,5,20,5,
 20,20,20,5,20,20,5,5,12,12,5,11,11,12,5,11,5,11,12,5,5,
 5,5,5,5,5,20,5,5,5,5,20,5,5,20,5,20,20,5,5,5,5,20,5,
 20,5,20,20,20,5,20,20,5,5,12,12,5,11,11,12,5,11,5,11,
 12,5,5,5,5,5,5,20,5,5,5,5,20,5,5,20,5,5,5,5,5,5,5,
 20,5,5,5,5,20,20,5,5,20,5,5,11,11,5,5,5,11,5,5,5,5,
 11,5,5,5,5,5,20,20,5,5,5,5,5,5,20,20,5,[15,20],5,5,
 5,5,20,5,5,5,5,5,20,20,5,20,[15,20],11,11,11,11,5,5,
 13,5,5,5,5,13,5,5,5,5,20,20,5,5,5,5,5,5,20,5,5,
 [16,20],5,5,5,5,20,5,5,5,5,5,20,5,5,[16,20],5,11,11,
 13,5,5,5,13,5,5,5,12,11,5,5,5,[16,20],20,5,5,5,5,5,
 5,20,20,5,20,5,5,5,5,20,5,5,5,5,5,20,[16,20],5,20,20,
 11,11,11,11,5,5,11,5,11,5,11,11,5,5,20,5,5,5,5,5,5,20,
 20,5,[16,20],5,5,5,5,5,20,5,5,5,5,20,20,5,5,[16,20],
 5,5,13,13,5,5,12,11,5,5,5,12,11,5,20,[16,20],5,5,5,5,
 5,[16,20],20,5,20,20,5,5,5,5,20,5,5,5,5,20,20,5,5,20,
 5,11,11,11,5,5,11,11,5,5,5,11,11,20,5,5,5,5,5,5,5,20,
 5,[16,20],5,5,5,5,5,20,5,5,5,5,5,20,5,5,20,16,5,13,
 11,12,5,12,11,5,5,5,5,13,20,20,20,20,20,20,20,20,20,16,
 20,20,20,20,20,15,20,20,20,20,[16,20],20,[16,20],20,
 [16,20],20,20,[15,16,20],15,20,20,20,20,15,20,20,16,20,
 5,5,5,5,5,[16,20],20,20,5,14,5,5,5,5,20,5,5,5,5,5,
 20,20,5,20,[15,20],[15,18],12,11,[15,16,20],5,5,12,5,
 5,5,5,12,5,5,20,5,20,20,5,[15,20],5,5,5,5,5,20,5,5,
 5,5,5,20,5,[15,20],20,5,5,13,11,5,12,12,11,5,5,11,5,
 11,5,20,5,20,[16,20],5,20,5,5,5,5,5,20,5,5,5,15,5,20,
 5,20,20,5,5,11,11,5,11,11,11,5,5,5,5,11,5,5,5,20,5,5,
 [16,20],5,5,5,5,20,5,5,5,20,5,20,5,[16,20],20,5,12,
 11,11,5,12,5,13,5,5,12,5,11,[16,20],20,20,[16,20],
 [16,18,20],5,5,5,5,5,20,5,5,20,5,5,20,5,16,20,5,5,12,
 12,5,[15,18],[15,16,20],12,5,12,13,5,12,5,20,[16,20],
 20,20,5,5,5,5,20,5,5,5,5,5,20,5,5,20,5,5,12,11,5,5,5,
 12,12,5,12,5,12,20,5,14,5,5,5,5,5,20,5,5,5,5,5,20,5,
 16,20,5,5,13,11,5,[15,16,20],15,11,5,5,12,20,11,20,20,
 16,20,20,20,20,15,20,20,20,[16,20],20,20,20,20,[16,20],
 20,20,20,15,20,20,20,[15,16,20],20,20,15,[15,20],20,5,
 [16,18,20],5,5,20,5,16,20,5,20,20,20,20,5,16,20,20,
 [15,16,20],12,12,15,5,5,12,20,11,5,5,13,20,5,20,20,5,
 20,5,20,5,12,16,20,20,[16,20],[16,20],16,5,[16,20],
 14,14,16,[15,16],13,5,5,16,16,20,5,5,16,5,20,20,5,20,
 5,5,16,20,16,[16,20],16,[15,16],12,14,16,14,5,
 [16,20],12,5,16,14,16,5,20,5,[16,20],5,5,5,20,5,20,5,
 [16,20],20,5,5,11,11,5,12,5,11,11,12,11,5,11,5,5,20,5,
 15,5,5,[15,20],20,5,20,20,5,5,11,11,11,11,5,11,5,11,
 11,11,11,20,[16,20],15,5,20,20,5,[16,20],20,
 [15,18,20],20,5,5,12,12,11,5,5,12,16,12,[16,20],5,12,
 16,5,20,5,5,20,20,20,5,16,5,5,11,13,5,5,5,11,12,12,5,
 12,11,20,16,[16,20],[16,20],16,[15,20],16,[16,20],16,
 16,20,16,[16,20],[16,20],[16,20],20,16,[16,20],
 [16,20],[16,20],[16,20],[16,20],5,5,5,5,[16,20],5,
 5,20,5,5,11,12,5,5,5,12,12,5,5,5,11,[16,20],5,
 [16,20],20,[16,20],16,20,16,5,12,12,16,5,5,12,16,13,
 12,20,12,5,5,20,[16,20],5,20,[16,20],5,11,11,13,5,5,
 20,16,13,12,5,20,5,20,5,16,20,5,5,13,12,5,13,5,12,
 [16,20],12,16,5,12,20,5,12,16,5,5,13,12,5,12,[15,18],
 12,5,20,5,[15,16,20],12,20,20,[15,16,20],20,[15,20],
 20,[15,16,20],20,20,20,15,20,20,15,20,20,5,20,16,20,12,
 12,[15,18],5,5,11,16,5,5,5,12,20,5,[16,18],13,12,5,
 [16,20],19,14,[15,16],14,[16,20],5,12,20,[16,20],
 [16,20],[15,16],20,20,[16,20],15,20,[16,20],20,16,
 [16,20],[16,18],14,11,[16,20],5,14,16,14,14,5,5,
 [16,20],11,12,11,12,5,11,5,5,11,12,12,20,12,12,11,20,
 11,11,12,12,20,11,11,12,20,12,12,11,11,20,5,12,12,12,11,
 5,5,11,12,12,11,12,5,5,11,11,5,5,11,12,12,12,11,12,12,
 20,5,12,11,12,12,12,12,5,12,11,5,5,5,5,5,5,5,5,5,5,5,
 5,20,20,5,5,5,20,5,20,5,5,20,20,5,5,5,5,5,5,5,5,5,20,
 20,20,20,20,20,5,11,11,5,12,12,11,5,12,5,12,11,5,5,5,5,
 5,5,5,5,5,5,5,20,20,5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,
 5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,5,5,20,20,5,5,5,
 5,5,5,5,5,5,20,20,20,20,20,20,5,11,11,5,12,12,11,5,12,
 5,12,11,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,5,
 20,5,5,20,5,20,5,20,5,20,5,20,20,20,5,5,5,5,5,5,5,5,
 5,11,5,11,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,
 5,5,5,5,5,5,5,5,5,20,5,20,20,20,20,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,
 5,20,5,5,5,5,5,5,5,5,5,5,20,20,20,20,5,5,5,5,5,11,11,
 5,5,11,5,11,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,20,5,5,
 5,5,5,5,5,5,5,20,5,20,20,20,20,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,[16,20],5,5,5,5,5,5,20,
 [16,20],5,16,5,5,5,5,5,5,20,5,5,5,20,20,20,20,
 [16,20],13,5,11,20,5,5,20,5,5,5,5,13,5,5,5,5,20,20,5,
 5,5,5,5,5,[16,20],20,5,[16,20],5,5,5,5,5,5,5,5,5,5,
 [16,20],20,5,[16,20],20,20,11,20,11,5,5,13,5,5,5,13,
 5,5,5,5,20,20,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,5,5,
 5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 [16,20],20,5,5,5,5,5,5,5,5,[16,20],5,5,5,5,5,20,5,
 5,5,5,15,20,20,5,16,5,11,20,13,5,5,13,5,5,5,5,12,11,5,
 20,20,5,5,5,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,
 20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,
 5,5,16,5,5,5,5,5,5,5,5,5,5,20,20,20,5,5,16,5,13,5,13,
 11,20,5,11,5,11,11,12,20,20,20,20,20,20,20,20,20,16,20,
 20,20,20,20,20,20,20,20,20,[16,20],20,20,20,[16,20],20,
 20,[16,20],16,20,20,15,20,15,20,20,[16,20],20,20,20,20,
 20,20,[16,20],20,[16,20],20,16,20,20,20,20,20,20,20,20,
 20,20,20,20,20,20,[16,20],16,20,20,[16,20],15,20,20,20,
 20,15,20,[15,20],5,5,15,5,[15,20],5,5,[16,20],20,5,
 5,20,5,5,5,5,5,5,5,20,20,16,5,5,5,13,5,11,13,12,11,5,
 5,12,5,5,5,20,5,5,20,5,5,5,5,5,5,5,5,5,5,5,20,5,20,
 20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,5,20,20,
 [16,20],5,5,5,5,20,5,5,5,20,5,20,20,[16,20],5,20,13,
 5,5,5,20,11,12,11,11,13,5,5,[16,20],[16,20],5,
 [16,20],[16,20],20,5,5,5,5,20,5,5,5,5,20,20,20,13,5,
 20,5,5,5,5,12,20,20,5,5,12,5,5,5,5,[16,20],5,5,5,5,
 5,5,5,5,5,5,20,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,13,11,5,5,5,5,5,5,20,5,5,5,20,20,16,20,5,5,12,
 5,5,20,12,11,12,5,5,5,5,20,5,16,5,5,5,5,5,5,5,5,
 [16,20],20,[16,20],20,12,16,11,20,5,12,11,5,5,20,5,5,
 12,12,5,20,[16,20],5,5,5,5,20,5,5,5,5,5,20,20,5,11,
 16,20,5,11,12,11,5,20,5,5,12,5,13,5,5,5,5,20,5,5,5,5,
 20,20,20,20,16,16,16,5,16,14,14,13,[16,20],20,5,5,20,
 14,14,5,5,20,20,5,5,12,20,20,5,16,20,16,[16,20],
 [16,20],16,5,14,14,16,20,[16,20],20,20,16,16,14,5,
 [16,20],5,[16,20],5,5,5,[16,20],5,20,20,[16,20],5,
 5,11,5,11,5,12,5,5,12,13,12,5,11,5,5,5,5,20,5,5,20,20,
 20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,13,16,20,5,
 [16,20],5,[16,20],20,[16,20],20,5,5,5,5,5,5,11,11,
 12,12,[16,20],5,5,[16,20],5,20,5,5,5,20,20,5,
 [16,20],5,5,5,12,5,11,5,5,13,20,5,12,5,5,14,16,
 [16,20],5,16,16,[16,20],[16,20],[16,20],5,5,14,14,
 14,5,5,[16,20],16,16,14,14,20,5,5,20,[16,20],20,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,[15,20],5,20,20,[16,20],
 5,5,16,5,5,5,[16,20],5,5,11,12,12,5,5,5,5,5,20,
 [16,20],5,5,[16,20],5,5,5,12,11,11,5,20,13,11,5,12,5,
 20,20,13,5,12,5,5,5,5,12,5,5,[16,20],5,12,5,11,20,20,
 5,16,5,5,12,5,5,5,12,5,5,11,5,20,20,20,16,[16,20],20,
 [15,20],20,[16,20],20,20,20,16,16,16,15,15,20,20,20,
 [16,20],20,20,20,16,20,15,20,[16,20],20,20,20,20,5,5,
 14,13,5,5,[16,20],16,14,16,16,[16,20],20,5,5,19,14,
 [16,20],20,5,16,14,[15,20],[15,20],20,[16,20],5,14,
 19,20,[16,20],20,16,19,16,16,20,5,[16,20],5,11,12,11,
 5,5,5,5,11,12,11,12,11,11,5,5,5,5,12,11,11,5,5,11,12,
 11,11,5,5,5,5,11,11,11,11,5,5,5,12,11,12,12,5,5,5,5,5,
 5,12,12,11,5,5,11,11,12,5,20,12,11,12,12,11,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,5,20,20,5,20,5,5,5,
 5,5,20,5,5,5,5,20,20,5,5,20,20,5,11,11,5,11,11,11,5,
 11,5,11,11,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,20,5,20,5,
 5,20,20,5,5,5,5,5,5,5,5,5,20,20,20,20,20,20,5,11,11,5,
 12,12,11,5,12,5,12,11,5,5,5,5,5,5,5,5,5,5,20,5,5,5,
 20,5,20,5,20,20,20,5,5,20,5,20,5,20,5,20,20,5,20,20,5,
 20,13,5,5,13,11,11,5,11,11,11,11,5,5,5,5,5,5,5,5,5,5,
 20,5,5,5,20,5,20,5,20,20,20,5,5,20,5,20,5,20,5,20,20,
 5,20,20,5,20,13,5,5,13,11,11,5,11,11,11,11,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,5,20,5,5,20,20,5,5,5,5,20,5,5,5,
 5,20,5,5,20,20,20,5,5,5,5,11,11,5,5,11,5,11,5,5,5,5,
 5,5,5,20,5,5,5,5,20,5,20,5,5,20,5,5,5,5,5,5,5,5,5,5,
 20,20,5,5,5,20,5,5,5,5,11,11,5,5,11,5,11,5,5,5,5,5,5,
 5,20,5,5,5,20,5,20,5,20,20,[16,20],5,5,5,5,5,5,5,5,
 5,20,5,5,5,5,[16,20],11,5,5,11,11,11,11,5,11,5,11,11,
 5,5,5,5,5,5,5,5,5,20,5,20,20,5,20,[15,20],5,5,5,5,5,
 5,5,5,5,20,20,5,5,[15,20],20,11,5,11,5,11,11,11,5,11,
 5,13,5,5,5,5,[15,20],5,5,5,5,20,5,20,5,5,20,20,5,5,
 5,5,5,5,5,5,5,20,5,15,5,20,20,11,11,5,5,11,11,11,11,
 11,5,11,11,5,5,20,5,5,5,5,20,5,20,20,5,[16,20],5,5,5,
 5,5,5,5,5,5,5,20,5,5,5,[16,20],20,5,11,11,5,11,13,5,
 5,11,5,13,5,5,5,15,5,5,5,20,5,[16,20],20,5,20,20,5,5,
 5,5,5,5,5,5,5,20,20,5,5,20,20,5,5,11,5,11,11,11,5,11,
 5,11,5,20,5,5,5,5,20,5,20,5,20,16,5,5,5,5,5,5,5,20,5,
 5,20,5,20,5,5,16,5,12,5,12,11,13,5,5,11,5,11,12,5,5,
 20,5,20,5,20,5,5,16,12,5,5,20,5,5,5,5,5,5,[16,20],5,
 [16,20],5,16,16,5,[15,16,20],15,5,12,12,11,5,12,5,13,
 20,5,5,20,20,5,[16,20],5,20,20,16,5,5,20,5,5,5,5,5,5,
 20,5,5,5,12,[16,20],15,5,5,[16,20],12,12,13,5,12,5,
 13,12,5,5,20,5,20,5,5,[16,20],5,5,5,5,5,5,5,5,5,20,
 20,5,5,[16,20],5,20,5,11,5,5,13,13,5,5,11,12,11,5,5,
 20,5,20,[16,20],5,20,5,5,5,5,5,5,5,5,5,[16,20],20,5,
 5,20,20,20,5,11,11,5,11,11,5,5,11,11,11,5,20,5,20,5,5,
 20,[16,20],5,5,5,5,5,5,5,5,5,20,5,5,[16,20],5,20,12,
 5,5,5,13,11,12,5,11,12,11,5,[16,20],20,20,[16,20],
 [15,16,20],20,20,20,20,20,20,20,20,20,20,20,20,20,
 [16,20],20,[15,20],15,20,20,20,15,[15,16,20],20,20,20,
 [15,20],20,20,20,5,15,20,5,5,5,20,5,5,5,5,5,5,20,5,5,
 20,5,20,5,5,5,12,12,12,5,5,11,5,11,5,20,20,16,20,20,20,
 20,20,20,20,20,20,20,20,20,20,16,20,[15,20],15,[15,20],
 20,20,[15,16,20],15,20,20,20,20,20,20,5,20,16,5,5,5,5,
 5,5,5,5,[16,20],20,20,5,5,14,20,12,20,[15,18],5,12,
 11,[15,16,20],5,12,5,12,5,20,[15,18,20],5,5,20,5,5,5,
 20,20,5,20,5,5,16,20,[16,20],[16,20],5,5,16,12,12,5,
 11,12,5,12,12,20,20,20,20,20,20,20,20,20,20,[16,20],20,
 20,[16,20],[16,20],16,20,16,[16,20],[16,20],15,
 [15,16,20],20,20,[16,20],[15,16,20],[16,20],[16,20],
 5,5,16,5,5,5,5,5,5,20,16,16,16,[16,20],[16,20],
 [16,20],5,19,[16,18],14,12,[16,20],5,12,16,14,14,5,
 20,5,[15,20],5,20,5,20,20,5,5,[15,20],5,20,5,5,5,5,
 13,11,5,12,13,12,11,5,20,5,20,5,[16,20],5,20,[16,20],
 5,5,20,5,20,5,11,5,5,11,11,5,11,11,11,11,11,5,20,
 [16,20],5,20,20,20,[16,20],5,[16,18,20],5,16,5,5,5,
 20,12,12,5,[15,18],13,[15,16,20],12,11,16,5,5,5,5,20,
 5,5,5,[16,20],20,5,5,12,5,11,11,5,12,13,5,13,5,5,16,
 [16,20],[15,20],20,5,16,16,16,16,5,5,14,14,16,11,5,
 [16,20],[16,20],[15,16,18],14,14,5,5,5,20,[16,20],5,
 20,20,20,12,5,5,12,12,11,5,5,12,5,12,5,[16,20],20,
 [16,20],5,[16,20],20,20,16,5,5,5,16,11,11,5,15,13,20,
 11,5,5,20,20,[16,20],20,5,[16,20],12,5,5,16,20,11,5,
 13,20,5,11,13,20,5,5,14,5,20,5,5,5,5,13,11,5,
 [15,16,20],12,15,11,5,20,20,20,16,15,20,16,20,15,20,15,
 20,20,20,20,[15,16,20],20,5,5,[16,18,20],20,13,5,
 [15,16,20],5,12,12,15,5,12,5,12,11,5,20,[16,20],12,20,
 5,15,12,12,5,16,12,5,12,13,20,20,16,14,5,12,[16,20],14,
 14,16,16,[15,16],13,5,20,[16,19],16,[15,16],5,12,14,
 16,14,20,5,[16,20],5,[16,20],[16,20],20,[16,20],16,
 [16,20],[16,20],[16,20],16,20,16,[16,20],5,11,12,12,
 11,5,5,12,12,12,12,11,11,12,11,5,5,11,12,12,12,5,11,12,
 11,12,12,5,11,5,12,12,11,12,12,5,11,5,20,12,12,20,11,20,
 11,11,11,20,12,20,12,5,11,12,12,11,11,12,12,11,12,20,12,
 11,5,11,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,20,20,20,
 20,20,5,5,5,5,20,5,5,5,5,5,5,20,20,5,20,12,11,11,12,5,
 5,11,5,5,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,5,5,20,5,5,20,5,20,5,20,5,20,5,5,5,20,20,20,5,5,5,
 5,11,11,5,12,11,12,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 5,20,20,5,5,5,5,5,5,5,5,5,20,5,20,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,5,5,20,5,5,20,5,20,5,20,5,20,5,5,5,20,20,20,5,5,5,
 5,11,11,5,12,11,12,11,5,5,5,5,5,5,5,20,5,5,5,5,20,5,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,[15,20],5,5,5,5,5,20,
 20,15,20,[16,20],5,5,5,5,20,5,5,5,5,5,5,5,5,5,16,12,
 11,5,13,11,5,13,5,5,5,11,20,5,5,5,5,5,5,5,5,5,5,5,20,
 [16,20],5,5,[16,20],5,5,5,5,5,5,5,5,5,20,[16,20],5,
 5,16,5,13,5,13,5,5,11,20,5,11,5,20,11,5,5,5,20,5,5,5,
 5,5,5,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],5,5,5,5,20,5,20,
 20,5,[16,20],5,5,5,5,5,5,5,5,5,5,[16,20],20,5,5,
 [16,20],5,5,13,20,5,11,20,11,5,5,5,13,5,5,5,20,5,5,5,
 5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,20,5,20,20,20,
 [16,20],20,5,5,5,5,20,5,5,5,20,5,5,5,5,5,[16,20],11,
 12,5,20,5,13,5,5,5,11,5,13,5,20,20,5,20,5,20,20,5,16,
 5,5,5,5,5,5,5,5,5,20,[16,20],5,20,5,20,12,5,20,12,5,
 11,20,5,5,5,5,13,5,5,5,5,5,5,[16,20],20,[16,20],11,
 12,5,5,5,20,5,5,5,20,5,20,5,5,5,20,[16,20],11,11,5,
 20,5,5,12,11,5,5,5,20,5,5,[16,20],5,[16,20],20,5,16,
 5,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],5,5,5,20,11,5,20,
 13,5,5,11,13,5,11,5,20,5,20,20,5,5,5,5,5,5,5,5,5,5,5,
 20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,
 5,16,5,5,5,5,5,5,20,5,5,5,5,20,16,5,5,20,5,5,11,13,5,
 13,11,5,20,5,5,[16,20],[16,20],20,[16,20],[16,20],
 20,5,5,20,5,20,5,5,20,5,5,5,20,16,5,5,5,20,11,11,12,
 20,5,5,5,12,5,5,20,20,[16,20],5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,16,20,20,
 20,20,20,20,20,20,20,20,20,20,20,16,20,20,20,[15,20],20,
 15,[16,20],16,20,20,20,15,20,20,20,20,16,20,20,20,20,20,
 20,20,20,[16,20],20,[16,20],20,20,16,20,15,20,16,20,20,
 20,[16,20],15,20,20,20,20,20,[16,20],5,5,5,5,5,5,5,5,
 5,5,20,5,12,5,14,20,20,5,12,5,5,5,5,20,5,5,12,5,5,5,
 5,5,5,5,5,20,20,20,5,5,16,[16,20],[16,20],20,
 [16,20],14,16,14,16,5,5,5,14,14,14,5,5,12,5,5,5,5,5,
 5,5,[16,20],5,[16,20],16,16,[16,20],20,14,14,14,5,16,
 5,20,14,14,14,5,15,5,16,5,5,5,[15,20],5,5,5,[16,20],
 20,20,5,11,5,5,13,5,11,13,20,12,11,5,20,5,5,5,20,5,5,
 20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,13,[16,20],
 5,5,[16,20],5,[16,20],5,[16,20],20,5,5,5,5,5,5,5,5,
 12,12,20,20,20,[16,20],5,5,5,20,5,20,5,20,[16,20],20,
 11,5,13,5,5,5,5,20,13,11,12,5,5,13,[16,20],[16,20],
 12,5,16,16,[16,20],16,5,5,14,16,14,5,5,16,[16,20],16,
 14,14,5,5,5,5,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,[16,20],5,20,20,[16,20],5,5,16,11,5,5,20,5,11,5,
 12,12,5,5,5,20,5,20,[16,20],5,20,[16,20],11,5,5,13,5,
 5,5,13,12,11,5,12,5,5,5,13,11,5,5,5,5,11,12,5,5,20,20,
 12,11,5,20,5,5,16,5,5,13,20,5,5,12,11,5,5,5,20,5,5,20,
 [16,20],20,12,5,20,5,5,11,12,11,5,5,20,5,5,5,13,5,5,
 11,11,5,5,5,20,5,11,5,12,5,5,14,14,5,5,16,14,14,13,14,
 [16,20],20,20,5,14,14,16,5,5,14,14,16,14,20,[16,20],5,
 16,14,5,16,5,14,14,16,14,5,5,[16,20],5,11,12,12,5,5,5,
 5,11,12,11,12,11,11,5,5,5,5,12,11,12,5,5,11,12,11,11,5,
 5,5,5,12,11,11,11,5,5,5,12,11,11,12,5,5,5,5,5,5,11,12,
 11,5,5,11,11,12,5,12,11,11,11,11,11,5,5,5,5,5,5,5,5,5,
 5,5,5,20,5,5,5,5,20,5,5,5,5,20,20,5,5,20,5,20,5,20,5,
 20,20,20,5,20,20,5,5,12,12,5,5,5,12,11,5,11,5,12,5,5,
 5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,20,20,5,5,5,5,5,5,
 20,5,20,20,5,5,20,5,5,5,11,11,5,5,5,11,5,5,5,5,11,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,5,20,5,
 5,5,5,5,5,5,20,20,20,5,11,11,5,11,11,11,5,11,5,11,11,
 5,5,5,5,5,5,20,5,5,5,5,20,5,5,5,5,20,20,5,5,20,5,20,
 5,20,5,20,20,20,5,20,20,5,5,12,12,5,5,5,12,11,5,11,5,
 12,5,5,5,5,5,5,16,5,5,5,5,5,20,5,[16,20],20,[16,20],
 5,5,5,5,5,5,5,5,5,5,5,5,20,5,16,12,11,11,12,5,5,13,5,
 5,5,5,13,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],5,20,16,5,
 5,5,5,5,5,5,5,5,5,[16,20],5,20,[16,20],5,12,11,13,5,
 5,5,13,5,5,5,12,11,5,5,5,16,5,5,5,5,5,5,5,5,5,20,20,
 5,5,5,5,20,5,5,5,5,20,5,[16,20],20,5,5,5,12,12,12,5,
 12,11,5,5,5,12,12,5,5,[16,20],5,5,5,5,5,5,5,5,5,16,
 20,5,5,5,5,5,5,5,5,5,[16,20],5,20,20,[16,20],5,5,13,
 13,5,5,12,11,5,5,5,12,11,5,5,[16,20],5,5,5,20,5,
 [16,20],5,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,
 12,12,11,12,12,12,12,5,5,5,5,12,5,5,5,5,5,5,5,5,5,5,
 [16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,16,5,20,11,
 12,5,12,11,5,5,5,5,20,5,5,5,5,5,5,5,5,5,16,20,5,20,5,
 5,12,5,5,20,5,[16,20],5,16,20,16,5,5,[16,20],13,5,5,
 20,12,12,12,5,[15,16],16,20,5,5,5,20,[16,20],5,16,20,
 [16,20],5,5,5,5,5,5,5,5,5,5,5,5,20,5,[16,20],12,12,
 11,[15,16,20],11,20,13,5,5,5,5,12,5,5,[16,20],5,16,5,
 5,[16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],5,5,5,
 13,11,5,12,12,11,5,5,12,5,11,5,5,5,5,16,5,20,20,5,5,5,
 5,20,5,5,5,[16,20],5,20,5,20,20,5,12,11,12,5,12,5,12,
 5,12,5,5,11,5,5,5,5,5,20,[16,20],5,5,5,5,5,5,5,5,5,
 5,5,5,[16,20],5,5,12,11,11,5,12,5,20,5,5,13,5,11,16,
 16,5,16,[16,20],[15,20],5,5,5,5,5,5,5,5,5,5,5,5,16,
 5,20,12,13,11,5,12,[15,16,20],13,5,5,13,5,13,20,5,16,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,12,11,11,11,11,
 11,11,5,5,11,5,11,5,5,[16,20],20,5,5,5,5,5,5,5,5,5,
 5,5,5,16,5,12,20,13,11,11,[15,16,20],12,12,5,5,20,5,
 12,5,20,16,20,5,5,5,20,5,5,5,16,5,[16,20],5,16,16,5,
 20,11,13,5,5,5,[16,20],5,5,5,13,11,[15,20],[16,20],
 5,5,5,5,5,5,5,5,5,5,5,5,16,5,19,[15,16,20],13,12,12,
 5,11,13,5,5,5,5,13,20,20,20,20,20,20,20,20,20,20,
 [16,20],20,20,16,[16,20],16,20,[15,16],[16,20],
 [16,20],[16,20],[16,20],[16,20],20,20,[16,20],
 [16,20],[15,20],20,20,16,20,20,20,20,20,[15,16,20],20,
 [16,20],20,[16,20],[16,20],16,[16,20],[16,20],
 [16,20],[16,20],[16,20],20,[15,16,20],20,20,[16,20],
 [15,16,20],[15,16,20],5,16,5,[16,20],5,5,5,[16,20],
 5,20,5,16,5,5,5,11,11,5,12,5,11,12,12,12,5,11,5,5,20,
 5,[16,20],5,5,[16,20],5,5,20,20,20,5,12,12,5,5,5,11,
 5,12,5,5,12,5,16,[16,20],5,5,[16,20],5,[16,20],5,
 [16,20],5,5,16,11,13,5,5,5,13,15,13,[15,16,20],11,11,
 [16,20],5,5,5,5,5,5,5,20,[16,20],5,5,11,20,5,5,5,11,
 13,12,5,12,11,20,16,16,[16,20],5,[15,20],16,[16,20],
 [16,20],16,12,13,16,16,16,5,13,[16,20],16,14,
 [15,16,20],20,5,5,20,5,[16,20],5,20,5,5,11,11,11,5,
 11,5,11,11,11,11,5,11,16,5,[16,20],5,16,20,13,16,5,13,
 13,[16,20],5,5,12,13,12,5,5,16,5,20,5,[16,20],20,20,
 [16,20],5,19,19,13,5,12,11,12,13,5,12,19,5,5,5,16,
 [15,20],5,13,12,13,5,12,5,13,[15,16,20],5,13,5,12,5,
 5,20,16,5,5,13,13,12,5,12,11,20,5,5,[15,16,20],13,5,
 16,[16,20],5,13,12,[16,20],5,12,5,13,20,5,12,20,12,20,
 5,16,5,11,12,12,5,11,11,[15,16,20],13,5,20,13,20,20,16,
 16,16,20,[16,20],[16,20],[16,20],[16,20],[16,20],16,
 20,16,5,16,19,[16,20],5,12,[16,19],19,16,16,5,
 [16,20],12,14,[16,20],11,16,5,19,14,14,14,5,5,
 [16,20],12,12,12,11,11,12,5,11,11,11,11,20,12,12,12,20,
 11,12,12,12,20,12,12,12,20,12,12,11,12,20,11,11,12,11,11,
 5,11,12,13,12,12,13,5,5,11,12,5,5,12,13,12,11,11,12,12,
 20,5,12,12,11,12,12,12,5,11,12,5,5,5,5,5,5,5,5,5,20,5,
 5,5,20,5,20,5,20,20,20,5,5,20,5,20,5,20,5,20,20,5,20,
 20,5,20,13,5,5,13,11,11,5,11,11,11,11,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,20,20,5,5,20,5,5,20,5,20,5,20,5,20,5,5,
 5,20,20,20,5,5,5,5,11,11,5,12,11,12,11,5,5,5,5,5,5,5,
 20,5,5,5,5,20,5,5,5,5,20,20,5,5,20,5,20,5,20,5,20,20,
 20,5,20,20,5,5,12,12,5,5,5,12,11,5,11,5,12,5,5,5,5,5,
 5,20,5,5,5,5,5,5,5,20,5,[16,20],5,5,20,5,20,5,20,5,
 20,5,20,20,20,5,[16,20],11,5,5,11,5,5,11,11,5,11,5,11,
 5,5,5,5,20,20,5,5,5,5,5,5,20,5,5,[16,20],5,5,20,5,
 20,5,20,5,20,5,20,5,20,[16,20],5,11,5,11,5,5,5,11,11,
 5,11,11,5,5,5,5,[16,20],5,5,5,5,5,5,5,5,5,5,20,5,5,
 20,5,20,5,20,5,20,5,5,[16,20],20,20,20,11,5,11,11,5,
 11,11,11,5,11,5,5,5,5,20,5,5,5,5,5,5,5,5,5,[15,20],
 20,5,5,20,5,20,5,20,5,20,20,5,5,20,[15,20],5,5,11,11,
 5,5,11,5,11,5,11,11,5,5,5,[16,20],5,5,5,5,5,[15,20],
 5,5,20,20,5,5,20,5,20,5,20,5,20,5,5,5,20,20,5,11,11,
 11,5,11,5,5,11,5,11,11,5,5,5,5,5,5,20,5,5,5,5,16,20,
 5,5,20,5,20,5,20,5,20,5,5,5,20,5,[16,20],5,12,5,13,5,
 12,5,11,5,11,5,12,20,5,5,5,5,5,5,5,5,16,20,5,5,20,20,
 20,5,20,5,20,[16,20],5,[16,20],20,16,20,5,[16,20],16,
 5,5,5,5,12,5,12,12,5,5,5,5,5,5,[16,20],20,20,5,
 [16,20],5,5,20,5,20,20,20,20,20,5,5,5,20,5,
 [15,18,20],16,5,5,[16,20],5,5,13,12,5,12,11,5,5,5,20,
 5,20,5,5,[15,20],20,5,5,20,5,20,5,20,5,20,20,5,5,
 [16,20],5,5,5,11,5,5,11,11,5,11,5,13,5,5,5,5,5,5,15,
 5,20,20,5,5,20,5,20,5,20,5,[16,20],20,5,5,20,20,5,5,
 11,5,5,5,11,5,11,11,11,11,5,5,5,20,5,5,5,[16,20],5,5,
 20,5,20,5,20,5,20,5,20,5,16,5,5,13,5,5,5,12,5,12,11,5,
 13,5,5,[15,20],20,5,[16,20],[15,20],20,20,20,20,5,20,
 5,20,5,20,20,5,20,[16,20],5,5,5,12,5,20,[15,18],
 [15,16,20],5,11,20,12,5,20,5,5,[16,20],20,20,5,5,20,
 5,20,5,20,5,20,5,5,20,20,5,20,12,12,5,5,5,5,5,11,5,12,
 5,12,5,5,20,20,5,20,20,5,20,5,20,5,20,5,5,5,16,12,5,5,
 13,5,5,[15,16,20],15,5,12,5,12,11,5,5,5,16,5,5,20,20,
 20,5,20,5,[16,20],5,20,5,20,16,5,12,12,15,5,5,5,
 [16,20],12,20,12,13,5,5,[16,20],5,5,20,5,20,5,20,20,
 20,5,20,5,16,5,16,[16,20],5,5,16,5,5,12,13,5,12,5,12,
 20,5,20,20,5,20,5,20,5,20,16,5,20,16,16,16,5,16,14,14,
 [16,18],[16,20],5,11,5,16,14,14,20,20,16,20,20,20,
 [15,20],20,15,20,16,16,[16,20],[16,20],[16,20],
 [16,20],20,16,[16,20],[16,20],20,[16,20],16,20,
 [16,20],[16,20],[16,20],5,20,5,[16,20],5,20,5,20,5,
 5,5,[16,20],5,5,5,5,5,5,11,5,5,13,11,13,5,5,20,5,20,
 5,[16,20],5,20,[16,20],5,5,20,5,5,5,5,5,5,11,11,5,
 11,5,11,5,5,20,[16,20],[16,20],20,20,20,20,[16,20],
 20,[15,16,20],20,20,15,20,15,20,20,20,20,15,16,
 [15,16,20],20,20,[16,20],5,20,5,20,5,5,5,20,[16,20],
 5,5,5,12,5,5,5,5,13,12,11,12,5,20,[16,20],[16,20],
 [15,16,20],20,20,16,[16,20],[16,20],[16,20],20,20,
 [16,20],[16,20],[16,20],20,20,[15,16],[16,20],15,
 [15,16,20],[15,16,20],20,5,20,5,15,5,20,5,20,5,5,5,
 12,5,5,12,12,5,12,5,12,[16,20],20,[16,20],20,[16,20],
 20,16,16,20,15,20,16,20,20,20,15,[15,20],20,20,[16,20],
 20,5,5,16,16,5,16,5,5,5,19,5,5,12,20,13,20,5,16,20,20,
 20,16,20,20,15,20,15,20,[15,20],20,20,[15,16,20],20,15,
 20,20,5,5,20,16,5,5,13,12,5,20,[15,18],5,12,5,11,
 [15,16,20],5,20,20,[15,18,20],5,13,5,[16,20],5,5,5,
 16,12,5,12,5,5,20,20,16,5,5,5,16,5,5,5,[16,20],5,12,
 5,13,20,20,[16,20],[16,20],20,20,16,[16,20],[16,20],
 15,[16,20],[15,16,20],20,20,20,16,16,[16,20],5,5,19,
 [16,18],14,14,12,[16,20],12,[16,18],16,5,[16,20],5,
 [16,18],16,13,16,12,5,16,11,11,12,11,5,11,11,5,12,12,
 12,12,11,11,5,5,11,5,12,12,13,11,5,11,12,12,11,11,5,5,
 5,11,11,12,11,11,5,11,11,11,12,11,11,5,5,5,11,5,12,11,
 11,12,5,12,11,12,11,20,12,12,12,12,12,11,12,5,5,5,5,5,
 5,5,5,20,5,5,5,5,20,5,5,20,5,20,20,5,5,5,5,20,5,20,5,
 20,20,20,5,20,20,5,5,12,12,5,11,11,12,5,11,5,11,12,5,5,
 5,5,5,5,20,20,5,5,5,20,5,20,20,5,5,5,5,5,5,5,5,5,20,
 5,20,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,[16,20],5,5,5,20,5,5,5,[16,20],5,[16,20],5,5,5,
 5,5,5,20,5,20,20,5,5,5,5,[16,20],12,5,5,12,5,11,12,5,
 11,11,5,13,5,5,5,5,5,5,5,5,5,20,5,5,[15,20],20,5,16,
 5,5,5,5,5,5,20,5,20,20,15,5,20,[16,20],5,12,5,12,5,
 11,5,13,11,5,5,13,5,5,5,5,20,5,5,5,5,20,5,5,5,5,5,5,
 5,5,5,5,5,5,20,5,20,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,15,5,5,5,5,20,5,5,5,5,16,5,5,5,5,5,5,5,20,
 5,20,[16,20],5,5,5,[16,20],20,5,12,13,5,5,13,5,5,11,
 11,20,5,5,5,20,5,5,5,20,5,20,5,5,5,5,5,5,5,5,5,5,20,
 5,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,20,5,5,5,5,[16,20],5,5,5,5,5,5,5,20,5,20,20,5,20,
 20,20,[16,20],5,12,5,13,5,12,11,5,5,5,5,20,5,5,20,5,
 20,20,20,5,5,16,5,5,5,5,20,5,5,20,5,20,[16,20],20,20,
 5,20,5,5,20,12,5,5,5,5,5,20,5,12,11,5,5,20,20,5,
 [16,20],5,[16,20],5,13,5,5,5,5,12,20,20,5,20,20,5,5,
 20,20,[16,20],12,5,5,[16,20],5,5,12,5,12,5,5,5,5,5,
 [16,20],5,[16,20],5,5,[16,20],5,5,5,20,5,20,5,20,5,
 20,20,5,5,[16,20],5,5,5,13,5,5,13,20,5,11,5,20,11,5,
 5,20,5,5,20,5,5,5,5,5,5,5,5,5,20,5,20,20,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,20,5,5,[16,20],5,5,
 20,5,20,5,20,5,20,20,20,5,[16,20],20,20,13,5,11,11,12,
 5,20,5,5,13,5,11,[16,20],[16,20],20,[16,20],[16,20],
 16,20,20,20,20,20,20,20,20,20,20,20,20,16,20,16,15,15,20,
 [16,20],16,[16,20],20,20,20,20,20,[16,20],5,5,16,5,5,
 5,5,5,5,5,5,20,5,20,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,16,12,20,20,20,5,11,5,20,5,20,20,5,5,16,5,5,
 12,12,5,5,20,12,5,11,5,20,5,5,5,20,16,5,5,5,5,5,5,20,
 5,[16,20],20,[16,20],20,11,12,5,5,5,11,12,11,5,20,5,
 5,5,12,5,20,[16,20],5,5,5,5,5,5,20,5,20,20,5,20,20,5,
 13,[16,20],5,11,12,11,5,5,5,5,5,5,12,5,20,5,11,5,5,5,
 20,5,20,[16,20],5,5,[16,20],16,[16,20],20,[16,20],
 16,16,14,[16,20],5,20,5,19,14,[15,20],20,5,5,5,5,5,
 20,5,20,20,13,5,16,16,[16,20],[16,20],20,16,16,14,5,
 [16,20],5,5,14,14,16,5,[16,20],5,[16,20],5,20,5,
 [16,20],20,5,20,16,5,5,5,5,5,5,20,11,5,20,13,13,5,5,
 20,5,5,5,20,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,16,[16,20],20,5,[16,20],20,[16,20],5,[16,20],20,
 20,12,5,5,5,20,11,11,12,13,20,5,5,16,5,20,5,20,20,5,5,
 5,16,5,11,11,20,11,5,5,11,13,12,5,13,5,5,[16,20],
 [16,20],[16,20],20,20,16,[16,20],16,[16,20],20,5,16,
 16,19,20,20,[16,20],[16,20],14,19,16,20,5,20,20,
 [16,20],5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,[16,20],20,
 20,20,[16,20],20,20,16,20,20,15,[16,20],20,20,20,16,
 [15,20],20,20,20,20,20,5,[15,20],20,5,16,11,5,11,20,5,
 5,11,12,12,5,5,13,20,20,20,16,20,20,15,20,20,20,
 [15,20],20,15,[16,20],15,16,20,20,20,20,20,16,20,20,
 [16,20],15,15,20,16,20,20,20,20,[16,20],20,5,20,
 [16,20],20,12,5,20,5,20,5,12,5,5,5,5,5,12,5,14,5,5,5,
 12,12,5,5,[16,20],5,5,5,12,5,5,16,16,20,20,[16,20],
 14,16,14,14,16,5,20,5,20,14,[16,20],5,20,14,14,14,14,5,
 16,5,16,14,5,[16,20],5,14,14,13,14,5,5,16,5,12,20,11,
 5,5,5,5,11,11,12,12,12,11,5,5,5,5,12,11,12,5,5,11,12,
 12,11,5,5,5,5,11,12,12,12,5,5,5,12,11,11,12,5,5,5,5,5,
 5,11,12,11,5,5,12,11,12,5,12,11,11,11,12,11,5,5,5,5,5,
 5,5,5,5,20,20,5,5,5,20,5,5,5,20,20,20,5,5,5,5,5,5,5,
 5,5,20,20,20,20,20,20,11,5,5,11,12,12,5,5,12,5,12,5,5,
 5,5,5,5,5,[16,20],5,5,5,20,5,20,5,16,5,16,5,5,5,5,5,
 5,5,5,5,5,5,5,20,20,[16,20],12,5,5,12,11,11,12,5,11,
 5,11,12,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,[16,20],5,5,
 5,5,5,5,5,5,20,5,[16,20],5,20,[16,20],5,12,5,12,5,
 11,11,12,5,11,5,13,5,5,5,5,[16,20],5,5,5,5,5,5,5,5,
 5,20,20,5,5,5,5,20,5,5,5,5,20,5,[16,20],20,20,20,5,5,
 5,5,11,12,5,5,12,5,12,12,5,5,[16,20],5,5,5,5,5,5,5,
 5,5,[16,20],20,5,5,5,5,5,5,20,5,5,[16,20],5,5,20,16,
 5,5,12,12,5,11,13,5,5,11,5,13,5,5,5,[16,20],5,5,5,20,
 5,16,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,20,5,5,
 5,5,12,12,12,5,11,12,11,12,5,5,5,5,5,5,5,5,5,5,
 [16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,[16,20],5,
 12,5,13,11,20,5,5,11,5,11,12,5,5,5,5,5,5,5,5,5,16,20,
 5,20,5,5,5,5,5,20,5,[16,20],5,[16,20],20,[16,20],5,
 5,[15,16,20],12,20,12,13,5,11,13,5,13,5,5,5,5,5,20,16,
 5,[16,20],[15,20],16,5,5,5,5,5,5,5,5,5,5,5,5,
 [15,16,20],20,[16,20],12,5,5,[15,16,20],13,13,12,5,
 11,13,11,5,5,5,[16,20],5,[16,20],5,5,[16,20],20,5,5,
 5,5,5,5,5,5,5,5,5,5,16,20,5,5,12,5,5,13,13,5,5,11,12,
 11,5,5,5,5,5,[16,20],5,5,20,5,5,20,5,20,5,5,5,
 [16,20],5,20,5,20,20,5,5,5,12,5,12,11,12,12,12,12,12,
 5,5,5,5,5,5,5,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,
 [16,20],20,5,13,5,5,5,20,11,12,5,11,12,11,5,[16,20],
 [16,20],5,[16,20],[16,20],16,5,5,5,5,5,5,5,5,5,5,5,
 5,[16,20],20,[15,20],12,20,5,20,13,[16,20],12,5,11,
 13,11,5,5,5,[16,20],5,20,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,20,11,5,5,11,11,11,12,5,11,11,11,11,5,5,[16,20],16,
 5,5,5,5,5,5,5,5,5,5,5,5,16,20,20,5,13,5,5,[16,20],
 13,5,5,12,20,12,5,5,5,16,20,5,5,5,12,20,5,5,[16,20],
 5,16,5,20,[16,20],5,20,5,12,5,12,11,[15,16,20],11,11,
 20,13,5,5,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,16,20,16,
 [15,16,20],11,5,20,13,13,5,5,12,16,12,13,20,5,5,5,5,5,
 5,5,20,5,16,5,12,[16,20],[16,20],[16,20],5,[16,20],
 [16,19],16,19,[16,20],12,5,12,16,19,16,20,20,16,20,20,
 20,20,20,20,20,16,20,[16,20],16,[16,20],16,20,[16,20],
 [16,20],[16,20],16,[16,20],20,16,16,16,[16,20],5,
 [16,20],5,16,5,5,5,16,5,5,5,[16,20],20,5,5,5,5,5,13,
 11,5,12,13,12,11,5,5,5,5,5,[16,20],5,5,16,5,5,20,20,
 20,5,12,12,5,11,12,5,12,12,5,12,5,5,19,16,5,5,16,5,16,
 5,[16,20],[15,20],5,5,5,12,5,13,11,5,12,13,
 [15,16,20],13,5,16,5,5,5,5,5,5,5,20,[16,20],5,5,5,
 12,5,11,11,5,12,20,5,20,5,20,16,[16,20],[16,20],5,20,
 16,16,16,16,5,5,19,14,14,11,5,16,[16,20],14,[16,20],
 14,5,5,20,5,16,5,20,20,5,11,5,12,5,11,11,11,11,11,11,
 11,5,[16,20],5,16,5,16,20,20,16,5,20,11,[15,16,20],11,
 12,5,12,13,5,12,13,5,20,5,16,20,20,16,5,12,12,13,11,19,
 5,13,19,5,19,13,5,5,5,[16,20],20,5,5,5,20,5,13,11,11,
 [15,16,20],12,12,12,5,5,5,20,16,13,5,16,20,12,11,13,5,
 5,16,5,[16,20],12,5,[15,20],[16,20],5,13,5,
 [15,16,20],5,13,12,12,5,13,11,13,5,20,20,16,5,5,5,12,
 11,13,5,[16,20],16,5,13,12,20,20,[16,20],[15,16,20],
 20,20,[15,16],[16,20],[16,20],[16,20],[15,16,20],
 [16,20],[16,20],20,20,[16,20],[16,20],[16,20],20,
 [16,20],[16,20],[16,20],[16,20],[15,20],20,
 [15,16,20],20,14,[15,16,20],5,[16,20],13,16,16,
 [16,19],20,12,12,16,5,12,11,12,11,5,5,11,11,12,11,12,
 12,12,12,5,11,12,11,11,12,5,12,12,12,11,12,11,12,5,11,
 12,12,11,11,5,11,5,20,12,12,20,12,20,11,12,12,20,12,20,
 12,11,11,11,12,12,12,13,12,11,12,20,12,12,11,12,5,5,5,5,
 5,20,15,5,5,5,20,5,5,20,[15,20],5,16,5,5,5,5,5,5,5,
 5,5,20,20,20,20,5,[16,20],13,11,5,12,11,5,12,5,5,5,12,
 20,5,5,5,5,20,20,5,5,5,20,5,5,[16,20],5,20,16,5,5,5,
 5,5,5,5,5,5,20,[16,20],5,20,[16,20],20,12,5,12,5,5,
 12,20,5,11,5,20,12,5,5,5,[16,20],5,5,5,5,20,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,20,20,20,[16,20],5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,[16,20],5,5,5,5,20,5,5,5,5,16,
 5,5,5,5,5,5,5,5,5,5,[16,20],20,5,5,16,5,5,12,20,5,
 12,20,12,5,5,5,12,5,5,20,[16,20],5,5,5,20,5,[16,20],
 5,5,5,5,5,5,5,5,5,5,20,5,5,20,20,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,20,5,5,5,5,20,5,5,5,5,16,5,5,5,5,5,5,
 5,5,5,5,20,20,20,5,20,16,11,13,5,20,5,12,5,5,5,11,5,
 12,20,20,20,20,20,20,20,20,20,16,20,20,20,20,20,16,20,20,
 20,20,[16,20],20,[16,20],20,[16,20],16,20,[16,20],
 [16,20],20,20,20,20,20,15,20,[16,20],[16,20],5,5,20,
 20,5,[16,20],5,[16,20],12,20,5,20,20,5,5,20,20,5,5,
 20,20,5,20,5,[16,20],[15,18],5,5,[16,20],20,12,13,5,
 5,5,5,5,5,5,[16,20],5,[16,20],5,5,[16,20],20,5,5,5,
 5,20,5,5,5,20,20,20,5,16,20,5,5,20,12,5,20,12,5,5,12,
 12,5,11,5,20,5,5,[16,20],5,5,5,5,5,5,5,5,5,5,5,
 [16,20],20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,
 20,20,20,5,[16,20],5,5,20,5,20,5,5,5,20,20,20,5,
 [16,20],5,20,20,5,5,11,12,5,12,11,5,20,5,5,20,
 [16,20],20,[16,20],[16,20],20,20,20,20,20,20,20,20,20,
 20,20,20,20,[16,20],20,20,20,20,20,20,[16,20],[16,20],
 15,20,20,[15,20],20,20,5,5,20,5,5,5,5,5,5,5,5,5,5,20,
 20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,13,5,20,
 5,5,5,12,5,5,20,5,20,20,5,16,5,5,11,12,5,5,[16,20],
 12,5,11,11,20,5,5,5,5,16,5,5,5,5,5,5,5,20,[16,20],20,
 [16,20],5,5,14,12,20,5,13,12,5,5,[16,20],5,5,11,13,
 11,5,[16,20],5,5,5,5,20,5,5,5,20,20,20,5,12,5,13,16,
 5,11,12,11,5,5,5,5,5,5,12,5,5,5,5,20,5,5,5,5,5,
 [16,20],20,5,16,16,[16,20],5,16,16,14,16,[16,20],20,
 20,5,19,16,16,20,5,12,5,5,5,5,5,20,20,[16,20],5,
 [16,20],16,16,16,5,14,14,14,5,[16,20],20,5,14,14,14,5,
 [15,20],5,[16,20],5,20,5,15,20,20,5,16,5,5,5,12,5,5,
 12,5,11,12,20,13,11,5,5,5,5,5,[16,20],5,5,[16,20],20,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,13,20,5,5,
 [16,20],20,[16,20],5,[16,20],5,20,5,5,5,5,5,11,11,
 12,12,16,5,5,16,5,20,5,5,20,20,5,5,16,5,11,5,12,5,5,5,
 5,20,12,11,13,5,5,16,16,[16,20],16,20,16,16,[16,20],
 [16,20],5,20,16,14,14,5,20,[16,20],16,14,14,16,20,5,5,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,[15,20],5,
 [16,20],20,[16,20],5,5,16,5,12,20,16,5,5,5,16,13,20,
 5,20,5,20,20,[15,20],5,5,16,5,12,5,12,5,5,5,12,13,5,
 12,13,20,20,20,20,12,5,5,5,12,5,13,5,20,[16,20],5,16,
 5,5,20,20,20,16,16,20,16,20,20,20,[16,20],20,20,16,20,
 [16,20],15,20,20,[16,20],20,[15,20],20,[16,20],20,15,
 20,[16,20],20,20,20,20,20,5,5,16,20,5,5,[15,18],5,20,
 5,16,20,5,12,13,5,5,14,14,5,20,[16,20],14,14,14,14,16,
 5,5,5,19,16,[16,20],20,20,16,16,14,15,5,16,5,14,14,5,
 [16,20],20,16,14,14,16,5,20,16,5,11,12,12,5,5,5,5,12,
 11,12,13,11,12,5,5,5,5,11,12,12,5,5,12,13,11,12,5,5,5,
 5,12,11,12,11,5,5,5,13,12,11,13,5,5,5,5,5,5,11,13,12,
 5,5,11,12,13,5,12,12,11,11,13,12,5,5,5,5,5,5,5,20,20,
 5,5,5,5,5,5,20,20,5,16,5,5,5,5,5,5,5,5,5,5,20,20,5,
 20,20,20,5,11,11,5,5,20,5,5,5,11,11,5,5,5,20,20,5,5,5,
 5,5,5,20,20,5,16,5,5,5,5,5,5,5,5,5,5,20,20,5,20,20,
 20,5,11,11,5,5,20,5,5,5,11,11,5,5,20,20,5,5,5,5,5,5,
 5,20,20,20,5,5,5,5,5,5,5,5,5,20,5,5,5,20,20,11,11,11,
 11,5,11,11,5,5,5,11,11,5,5,7,5,5,5,5,5,20,5,20,20,20,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,11,11,5,20,5,11,11,5,
 5,5,5,20,5,7,5,5,5,5,5,20,5,20,20,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,16,11,11,5,20,5,11,11,5,5,5,5,20,20,5,
 5,5,5,5,5,5,20,20,16,5,5,5,5,5,5,5,5,5,20,20,20,5,20,
 20,11,20,12,11,5,5,[16,20],5,5,5,12,11,20,20,20,20,20,
 16,20,20,16,15,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
 7,15,16,20,16,20,15,16,20,20,20,20,7,5,5,20,5,20,5,20,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,11,11,5,11,11,
 11,11,5,5,11,5,11,5,5,5,5,20,20,5,20,5,5,5,5,5,5,5,5,
 20,5,5,5,5,5,20,11,5,5,11,5,5,11,5,5,5,5,11,20,5,5,5,
 7,5,16,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,5,5,11,11,
 5,20,5,5,11,5,11,20,20,5,16,20,16,5,5,5,5,5,5,5,5,5,
 5,5,5,20,5,20,16,5,5,11,12,20,11,5,5,12,5,11,5,5,7,5,
 16,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,20,5,5,11,11,5,20,
 5,5,11,5,11,5,20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,
 16,11,12,5,11,20,12,11,5,5,5,5,[16,20],20,5,16,5,5,5,
 5,5,5,5,5,20,5,20,20,5,11,20,12,5,11,11,5,5,[16,20],
 5,5,5,11,11,20,7,20,20,20,20,20,20,20,20,20,20,20,20,16,
 20,15,16,20,20,15,16,20,16,20,20,15,20,16,20,5,5,5,5,5,
 5,5,5,5,11,5,5,20,20,16,11,20,11,20,11,20,11,5,5,11,11,
 20,20,20,20,20,20,20,20,20,20,20,[15,16,20],[15,16,20],
 16,16,20,15,20,[15,16,20],15,[15,16,20],20,7,20,20,
 [16,20],[16,20],[16,20],5,20,5,20,5,5,5,20,5,5,5,20,
 5,20,11,5,5,11,11,5,11,11,11,11,5,11,5,5,5,5,20,5,5,
 20,5,5,5,5,20,11,5,5,11,5,5,11,5,5,5,5,11,5,20,20,5,
 20,20,5,20,20,20,5,16,11,5,5,16,5,5,11,12,12,20,5,11,
 20,5,5,5,5,5,5,5,5,20,20,11,5,11,11,5,5,11,11,11,5,11,
 11,20,11,20,20,5,20,20,20,20,16,11,5,11,20,11,5,11,20,
 20,12,11,20,20,5,5,5,20,20,5,5,16,11,5,5,20,5,5,11,11,
 11,5,5,20,20,5,20,20,20,5,5,16,11,5,5,16,5,5,11,11,11,
 5,5,11,5,5,20,20,5,5,16,11,5,5,20,5,5,11,11,11,5,5,20,
 5,5,5,11,5,20,12,5,5,11,11,5,11,20,5,11,5,11,5,5,5,20,
 20,11,11,5,12,5,11,11,5,5,5,20,11,5,5,20,[16,20],13,5,
 20,13,5,5,12,20,5,5,5,13,5,20,[16,20],13,5,20,13,5,5,
 12,20,5,5,5,13,5,20,20,11,5,11,20,11,20,12,11,20,5,11,
 20,20,11,20,11,5,11,20,11,11,5,20,11,15,[15,16,20],20,
 15,20,[16,20],[16,20],[16,20],[15,16,20],20,20,7,11,
 13,11,13,11,20,11,11,13,12,20,11,13,10,5,11,5,5,11,10,
 12,11,5,10,12,11,10,5,5,11,11,12,20,13,13,11,11,20,10,
 12,10,11,5,5,11,11,5,5,10,11,13,11,11,13,13,11,5,11,10,
 13,10,10,12,5,11,11,5,5,5,20,20,5,5,5,5,5,5,20,20,5,
 16,5,5,5,5,5,5,5,5,5,5,20,20,5,20,20,20,5,11,11,5,5,
 20,5,5,5,11,11,5,5,20,20,5,5,5,5,5,20,20,5,20,20,5,5,
 5,5,5,5,5,5,5,20,20,5,5,16,5,11,11,20,5,5,11,11,5,5,
 5,20,5,5,20,20,5,5,5,5,5,20,20,5,20,20,5,5,5,5,5,5,5,
 5,5,20,20,5,5,16,5,11,11,20,5,5,11,11,5,5,5,20,5,5,5,
 5,5,5,5,5,5,20,5,20,20,5,5,5,5,5,5,5,5,5,5,20,5,5,
 20,20,11,11,11,11,5,11,11,5,5,5,11,11,5,5,5,5,5,5,20,
 20,20,20,16,5,5,5,5,5,5,5,5,5,20,20,20,5,[16,20],20,
 13,20,12,20,5,5,13,5,5,5,13,5,5,5,5,5,5,20,20,20,20,
 16,5,5,5,5,5,5,5,5,5,20,20,20,5,[16,20],20,13,20,12,
 20,5,5,13,5,5,5,13,5,5,5,20,5,20,20,5,20,20,5,5,5,5,
 5,5,5,5,5,5,20,5,20,20,5,11,11,11,5,11,11,11,5,5,11,
 11,5,5,5,5,5,7,5,5,16,5,5,5,5,5,5,5,5,20,5,20,5,20,
 20,5,20,5,11,5,11,5,20,5,5,11,11,5,5,5,5,7,5,5,16,5,
 5,5,5,5,5,5,5,20,5,20,5,20,20,5,20,5,11,5,11,5,20,5,
 5,11,11,5,20,20,20,20,20,20,5,5,5,5,5,5,5,5,5,5,20,5,
 11,20,5,12,5,11,5,11,20,11,5,5,11,11,5,5,20,20,5,20,5,
 5,5,5,5,5,5,5,5,5,20,5,5,20,5,11,5,11,5,5,5,11,5,5,
 5,11,5,20,5,20,20,5,5,5,5,5,5,5,5,5,5,20,5,20,16,5,
 11,12,11,5,20,12,11,5,5,5,[16,20],5,20,20,7,20,20,20,
 20,20,20,20,20,16,20,20,20,16,15,20,16,20,15,20,16,20,16,
 20,20,15,16,20,5,16,5,5,5,5,5,5,5,5,5,5,20,5,5,20,11,
 [16,20],5,11,11,5,5,12,5,5,5,11,11,20,5,5,5,5,5,5,5,
 5,5,11,20,5,20,16,20,11,20,20,12,12,20,11,5,5,11,20,11,
 20,20,20,20,20,20,20,20,16,20,7,16,16,16,16,7,20,16,16,
 16,20,7,20,20,16,7,16,5,20,5,20,5,5,5,20,5,20,5,20,20,
 5,11,5,11,5,11,5,11,11,11,11,11,5,5,5,5,5,20,5,5,20,
 20,5,5,20,5,11,5,11,5,5,5,11,5,5,5,11,5,20,20,20,5,5,
 20,5,16,5,20,16,5,11,5,16,5,5,5,11,12,12,20,11,5,20,5,
 5,5,5,5,7,5,5,16,5,11,5,20,5,5,5,11,11,11,5,20,5,20,
 11,20,20,5,16,20,20,16,20,11,5,20,11,11,5,11,20,20,11,
 20,11,5,5,5,5,7,5,5,16,5,11,5,20,5,5,5,11,11,11,5,20,
 5,20,5,20,20,20,5,20,20,11,5,11,20,5,5,11,11,11,5,11,5,
 5,5,20,20,5,20,20,11,5,11,11,5,5,11,11,11,5,11,11,5,20,
 5,20,20,5,16,5,11,5,12,5,11,20,5,12,11,5,20,5,5,16,5,
 11,11,12,5,5,11,11,5,5,5,[16,20],5,20,20,7,20,16,20,
 16,20,20,20,15,16,[15,20],20,16,20,5,20,20,[16,20],5,
 11,12,5,5,11,20,5,5,11,12,20,5,20,11,11,5,20,11,20,11,
 11,20,11,5,20,[16,20],[16,20],15,20,20,[15,16,20],15,
 [15,16,20],[16,20],20,7,20,20,11,11,20,5,11,20,11,11,
 5,11,20,11,20,12,12,11,20,11,11,13,20,13,12,10,10,5,11,
 5,5,11,13,10,11,11,13,11,13,12,11,20,11,5,11,13,10,10,5,
 11,5,11,13,10,10,5,11,5,11,5,5,10,12,10,11,11,12,20,12,
 5,10,12,10,11,13,11,11,5,11,5,5,7,5,5,5,5,5,5,5,5,5,
 16,5,5,5,5,5,5,5,5,5,5,20,5,20,5,20,20,5,20,11,11,5,
 20,5,5,5,5,11,11,5,20,20,5,5,5,5,5,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,7,
 5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,5,5,20,5,20,5,
 20,20,5,20,11,11,5,20,5,5,5,5,11,11,20,20,20,20,20,20,
 20,20,20,16,20,20,20,20,20,20,20,20,20,20,16,20,20,20,16,
 16,20,16,[16,20],[16,20],20,16,20,20,20,20,[15,16,20],
 [15,16,20],5,5,5,5,5,20,20,20,5,20,5,5,5,5,5,5,5,5,
 5,5,5,20,5,20,20,12,5,20,20,5,5,12,5,5,5,5,5,5,5,20,
 5,20,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,11,
 5,5,11,11,5,5,5,11,5,5,5,20,5,5,20,20,5,5,5,5,5,5,5,
 5,5,5,20,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,20,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,11,5,5,5,
 11,5,11,5,5,11,5,5,20,20,20,20,20,5,5,5,5,5,5,5,5,5,
 5,5,5,20,11,5,5,5,5,5,5,11,20,5,5,5,11,5,5,5,20,20,5,
 5,5,5,5,5,5,5,5,5,20,5,5,20,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,11,5,5,5,5,5,5,5,5,5,5,5,5,20,20,5,5,5,
 11,5,5,20,11,5,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,20,
 5,20,20,5,11,11,20,5,11,11,5,5,20,5,5,5,11,11,5,16,5,
 5,5,5,5,5,5,5,20,5,20,20,5,11,11,20,5,11,11,5,5,20,5,
 5,5,11,11,5,5,5,5,5,5,5,5,5,5,20,5,20,20,16,16,5,16,
 20,20,11,[16,20],5,5,5,11,20,20,5,5,5,5,5,5,5,5,5,5,
 20,20,20,16,16,16,5,20,20,11,5,[16,20],5,5,11,20,20,5,
 20,5,20,5,5,5,20,5,5,20,20,5,5,5,5,5,5,11,5,5,11,11,
 11,5,5,5,5,5,5,20,5,5,20,5,20,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,11,20,5,5,20,5,20,20,20,5,5,5,5,5,5,5,5,5,
 11,11,20,5,5,16,5,20,5,5,5,5,7,5,20,20,5,5,11,11,5,5,
 5,20,20,5,11,11,5,20,16,20,5,5,16,20,16,16,5,5,20,20,
 11,5,5,[16,20],16,11,20,20,5,5,5,5,20,20,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,20,5,20,5,16,5,20,20,5,5,20,20,5,5,
 5,12,12,5,5,5,5,5,5,7,5,20,20,5,5,11,11,5,5,5,20,20,
 5,11,11,5,5,20,11,5,5,5,5,5,5,11,5,5,20,5,11,5,5,5,
 20,5,20,20,5,12,5,5,5,12,5,5,5,5,20,20,20,5,20,20,12,
 5,20,20,5,5,12,5,5,5,5,5,20,16,16,20,20,[16,20],
 [16,20],20,20,20,16,16,20,[16,20],[16,20],5,5,11,11,
 5,5,20,11,11,11,11,20,5,5,5,20,20,20,20,5,20,20,20,20,
 5,20,20,20,20,20,20,5,20,20,20,20,5,20,20,5,11,11,10,5,
 5,5,5,11,12,12,12,12,10,5,5,5,5,10,11,11,5,5,11,12,12,
 11,5,5,5,5,11,12,12,11,5,5,5,10,10,10,10,5,5,5,5,5,5,
 10,12,12,5,5,10,11,11,5,10,11,11,10,12,12,5,5,5,5,20,
 20,5,5,5,5,5,20,20,5,20,20,5,5,5,5,5,5,5,5,5,20,20,5,
 5,16,5,11,11,20,5,5,11,11,5,5,5,20,5,7,5,5,5,5,5,5,5,
 5,5,16,5,5,5,5,5,5,5,5,5,5,20,5,20,5,20,20,5,20,11,
 11,5,20,5,5,5,5,11,11,20,20,20,20,20,20,20,20,20,7,20,
 20,20,20,20,20,20,20,20,20,7,20,16,20,7,16,20,16,15,16,
 20,16,20,20,20,20,16,15,5,5,5,5,5,20,20,20,20,20,5,5,5,
 5,5,5,5,5,5,20,5,5,5,16,20,12,11,11,20,5,11,12,5,5,5,
 16,5,5,5,20,5,20,20,5,16,5,5,5,5,5,5,5,5,5,20,20,5,5,
 20,20,5,5,20,11,5,11,20,5,5,5,11,11,5,5,20,5,20,20,5,
 16,5,5,5,5,5,5,5,5,5,20,20,5,5,20,20,5,5,20,11,5,11,
 20,5,5,5,11,11,5,5,5,5,5,5,20,20,5,5,5,5,5,5,5,5,5,
 20,5,5,20,20,5,11,11,11,5,11,11,11,5,5,11,11,5,20,20,
 20,20,16,5,5,5,5,5,5,5,5,5,5,20,5,5,11,20,5,5,12,11,
 5,11,[16,20],5,5,5,11,11,5,5,5,20,20,5,5,5,5,5,5,5,
 5,5,5,20,5,5,5,20,5,5,11,11,5,5,11,5,5,5,5,11,5,5,5,
 16,20,5,5,5,5,5,5,5,5,20,20,20,5,20,16,5,5,13,13,5,20,
 12,20,5,5,5,13,5,5,16,20,5,5,5,5,5,5,5,5,20,20,20,5,
 20,16,5,5,13,13,5,20,12,20,5,5,5,13,5,20,20,5,5,5,5,5,
 5,5,5,5,20,5,5,5,20,11,20,11,11,11,5,12,5,5,5,5,11,11,
 20,20,20,20,20,20,20,20,20,16,7,20,16,16,20,16,20,7,16,
 16,16,7,20,20,20,16,16,16,5,5,5,5,5,5,5,5,5,20,11,5,
 20,16,20,20,11,20,12,11,11,20,5,5,11,20,11,5,20,5,20,5,
 5,5,20,20,5,5,20,20,5,5,11,11,5,11,11,5,11,11,11,11,5,
 5,5,20,5,20,5,5,7,5,5,5,16,5,5,11,20,5,5,11,5,11,11,
 5,20,5,5,11,20,5,5,20,20,20,5,20,20,5,5,11,12,5,5,11,
 5,11,11,20,11,5,20,5,20,5,5,7,5,5,5,16,5,5,11,20,5,5,
 11,5,11,11,5,20,5,5,20,20,20,16,5,20,20,16,20,5,11,20,
 11,11,11,5,20,20,12,20,12,5,5,5,20,20,5,5,20,5,5,11,11,
 5,5,11,5,5,5,5,11,5,20,5,16,5,20,5,16,20,5,11,11,20,5,
 11,5,12,12,5,[16,20],5,5,20,5,20,5,20,20,5,11,11,11,5,
 11,5,11,11,5,11,11,20,5,5,20,20,5,5,16,11,5,12,11,5,20,
 5,12,11,5,20,20,20,7,20,20,16,16,20,20,15,20,16,
 [15,20],20,16,20,5,5,16,5,11,11,[16,20],5,5,11,11,5,
 5,5,12,5,5,20,20,5,[16,20],11,12,5,11,5,20,5,5,11,12,
 20,5,11,20,11,5,20,20,12,12,11,20,11,5,20,16,16,7,20,20,
 16,16,16,16,20,7,20,12,20,11,20,5,20,11,11,11,5,11,20,
 11,13,11,11,11,5,5,5,11,13,10,11,13,13,20,11,11,11,12,
 20,12,11,11,20,12,12,13,11,20,11,5,13,10,11,11,5,11,5,
 12,10,10,11,5,11,5,11,11,11,13,11,13,5,5,11,13,11,5,11,
 13,11,10,12,10,11,5,11,5,7,5,5,5,5,5,20,5,20,20,20,5,
 5,5,5,5,5,5,5,5,5,5,5,5,5,16,11,11,5,20,5,11,11,5,5,
 5,5,20,20,5,5,5,5,5,20,5,5,20,20,5,5,5,5,5,5,5,5,5,
 20,20,20,5,20,5,20,20,12,5,5,5,5,5,5,5,12,5,20,20,20,
 20,20,7,20,16,16,16,20,20,20,20,20,20,20,20,20,20,20,20,
 20,20,16,[16,20],[16,20],20,16,20,[16,20],[16,20],20,
 20,20,20,16,5,5,20,5,7,5,5,20,20,5,5,5,5,5,5,5,5,5,5,
 5,5,16,5,5,11,11,5,5,20,11,11,5,5,20,5,5,5,5,5,20,20,
 5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,20,5,7,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,
 16,5,5,11,11,5,5,20,11,11,5,5,20,5,5,20,16,5,20,20,20,
 5,5,5,5,5,5,5,5,5,5,5,5,20,5,5,5,5,5,5,12,20,20,5,5,
 12,5,5,20,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,5,20,20,16,16,20,20,20,20,20,20,
 20,20,20,20,20,20,16,20,20,[16,20],[16,20],20,20,16,
 [16,20],[16,20],20,20,16,20,20,5,20,20,5,5,5,5,5,5,5,
 5,20,20,20,5,5,20,5,5,5,12,5,5,20,20,5,5,5,12,5,20,20,
 5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,20,20,5,12,5,5,5,5,5,
 5,5,12,5,5,5,5,5,5,5,5,5,5,11,11,5,16,16,16,20,20,20,
 20,20,20,20,5,5,20,20,20,5,5,5,5,5,5,5,5,5,11,11,5,16,
 16,16,20,20,20,20,20,20,20,5,5,20,20,20,5,20,5,20,5,5,
 5,20,5,5,5,20,5,5,5,5,5,5,11,5,5,11,11,11,5,5,20,5,5,
 5,20,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,11,
 20,5,5,20,20,20,5,20,5,5,5,5,5,5,5,5,5,11,11,20,5,5,
 20,5,5,5,5,5,5,5,5,20,5,5,5,11,5,5,5,5,11,11,5,11,5,
 5,11,20,20,5,5,20,20,20,20,5,5,11,11,11,5,5,20,20,11,
 11,11,20,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
 20,5,20,20,20,5,5,20,5,5,5,20,5,5,5,11,11,5,5,5,5,5,
 5,20,5,5,20,5,5,5,11,5,5,5,11,11,5,5,11,5,5,5,11,5,5,
 5,5,5,5,11,5,5,20,5,11,5,5,5,5,5,16,5,11,11,20,5,5,
 11,11,5,5,5,20,5,5,5,16,5,11,11,20,5,5,11,11,5,5,5,20,
 5,5,5,11,5,5,5,11,5,5,5,20,5,5,5,11,5,5,20,20,5,5,16,
 20,20,11,11,[16,20],5,5,5,20,20,16,5,5,20,20,11,11,5,
 [16,20],5,20,20,5,16,5,20,20,11,11,5,5,[16,20],5,12,
 11,11,5,5,5,5,12,11,12,12,11,11,5,5,5,5,12,11,12,5,5,
 11,11,10,10,5,5,5,5,12,12,11,10,5,5,5,12,12,10,10,5,5,
 5,5,5,5,11,12,11,5,5,11,12,11,5,10,10,10,10,10,10,5,5,
 5,5,5,5,5,5,5,5,5,5,16,5,5,5,5,5,5,5,5,5,5,16,5,16,
 5,20,20,5,[16,20],12,12,5,[16,20],5,5,5,5,12,12,5,5,
 5,5,5,16,5,16,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,16,
 12,12,5,[16,20],5,12,12,5,5,5,5,16,5,5,7,5,20,5,20,
 16,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,5,20,5,11,11,20,
 5,5,5,11,5,11,5,5,5,5,20,5,20,5,5,5,5,5,5,5,5,5,20,
 5,5,5,5,5,20,5,11,5,11,5,11,5,5,5,5,5,11,5,5,5,5,5,
 20,20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,11,11,5,11,11,
 11,11,5,5,11,5,11,7,16,5,16,16,5,5,5,5,5,5,5,5,5,5,5,
 5,5,20,5,20,5,16,5,12,12,[15,16,20],5,5,5,12,5,12,20,
 5,20,16,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,20,5,20,5,11,
 11,20,5,5,5,11,5,11,5,5,[16,20],20,5,5,5,5,5,5,5,5,
 5,5,5,5,20,5,16,20,13,5,13,20,13,5,5,5,5,5,13,5,20,20,
 5,5,5,5,5,5,5,5,20,5,20,5,5,11,20,5,12,11,11,5,11,20,
 5,5,5,11,11,[16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,
 16,20,13,5,13,20,13,5,5,5,5,5,13,20,20,20,20,20,20,20,
 20,20,20,[15,16,20],20,[15,16,20],16,16,16,20,15,
 [16,20],[16,20],[16,20],7,20,20,20,[15,16,20],
 [15,16,20],15,5,5,5,5,5,5,5,5,5,5,11,5,20,20,16,20,
 11,11,20,11,11,20,5,5,11,11,20,5,20,5,20,5,5,5,20,5,5,
 5,20,5,20,5,11,5,11,11,11,5,11,11,11,5,11,5,5,20,5,7,
 5,5,20,5,20,5,5,16,5,11,5,20,5,11,5,11,11,5,5,20,5,11,
 20,5,5,20,5,20,5,20,5,20,5,11,5,12,5,11,5,11,11,20,5,
 11,20,5,5,5,5,5,5,5,5,20,20,5,11,11,11,5,11,5,11,11,5,
 11,11,5,20,20,20,20,5,20,20,20,16,5,11,11,20,11,11,5,20,
 20,11,11,20,5,5,5,5,20,5,5,5,20,5,11,5,11,5,11,5,5,5,
 5,5,11,7,5,16,5,16,5,5,16,5,12,5,16,5,12,5,12,12,5,5,
 [16,20],5,20,5,20,5,5,16,5,11,5,20,5,11,5,11,11,5,5,
 20,5,5,5,11,5,20,5,12,5,11,11,11,5,20,5,11,5,11,5,5,5,
 20,16,5,13,5,13,5,12,5,20,5,5,20,12,5,5,20,20,11,11,20,
 11,5,11,11,5,5,5,5,12,5,20,16,5,13,5,13,5,12,5,20,5,5,
 20,12,5,20,11,20,5,11,20,20,11,11,11,20,5,11,20,12,20,
 20,11,5,20,11,11,12,5,20,11,16,16,20,7,20,7,16,16,16,20,
 20,7,11,10,12,10,11,5,5,5,10,11,13,12,20,12,20,11,11,11,
 13,13,11,11,5,13,10,11,10,5,5,11,11,20,13,13,12,11,11,
 20,13,11,11,10,5,5,11,11,11,11,12,12,20,5,5,10,10,12,5,
 10,10,12,10,11,13,5,11,11,5,5,5,5,5,20,20,20,20,16,5,5,
 5,5,5,5,5,5,5,20,20,20,5,[16,20],20,13,20,12,20,5,5,
 13,5,5,5,13,5,20,5,20,5,20,5,5,16,5,5,5,5,5,5,5,5,5,
 20,20,5,20,20,11,5,5,[16,20],11,5,11,12,5,5,5,11,11,5,
 5,5,20,20,20,20,16,5,5,5,5,5,5,5,5,5,20,20,5,20,11,11,
 5,5,20,11,5,11,20,5,5,5,11,11,5,5,5,5,5,5,20,20,5,5,
 5,5,5,5,5,5,5,20,5,20,20,11,5,11,20,11,5,11,5,12,5,5,
 11,11,5,20,20,20,20,16,5,5,5,5,5,5,5,5,5,20,20,5,20,
 11,11,5,5,20,11,5,11,20,5,5,5,11,11,5,5,5,20,20,5,5,5,
 5,5,5,5,5,5,20,20,5,20,5,11,5,5,20,11,5,5,5,5,5,5,5,
 11,5,20,5,20,20,5,5,5,5,5,5,5,5,20,20,20,20,20,13,5,
 20,[15,16,20],12,5,20,12,5,5,5,5,13,5,20,16,16,5,5,5,
 5,5,5,5,5,20,20,20,20,20,20,20,12,[16,20],12,11,11,12,
 [16,20],5,5,11,12,11,20,16,5,5,5,5,5,5,5,5,20,20,20,
 20,5,12,11,20,20,12,11,5,5,20,5,5,5,12,11,20,20,20,20,
 20,20,20,20,20,16,7,20,16,16,7,16,20,7,[18,20],
 [15,16,20],20,16,20,20,20,16,16,16,5,5,5,5,5,5,5,5,5,
 20,13,20,20,16,16,[15,20],20,14,12,11,5,20,5,5,11,14,
 16,5,20,5,20,5,5,5,20,20,5,20,20,11,5,5,20,11,5,11,5,
 5,12,11,11,11,5,5,20,20,5,20,5,5,16,5,20,5,20,5,5,20,
 12,5,5,5,5,5,20,5,12,5,5,12,20,5,5,20,20,20,20,20,11,
 5,5,20,11,5,5,5,5,11,11,20,11,5,16,5,5,20,5,16,5,16,5,
 [15,16,20],20,5,20,13,20,5,5,5,13,13,5,13,5,5,16,16,
 20,16,5,16,20,16,16,5,20,20,12,11,5,5,20,[15,20],12,14,
 [16,20],5,5,5,20,20,20,5,11,5,5,20,11,5,5,5,5,5,5,5,
 11,5,20,5,16,5,16,5,[15,16,20],20,5,20,13,20,5,5,5,13,
 13,5,13,5,5,20,5,16,5,20,20,5,20,11,11,5,5,5,[16,20],
 11,5,11,11,20,5,20,12,11,5,5,16,11,5,12,5,5,20,5,12,11,
 5,20,16,20,7,16,20,7,16,20,20,16,20,20,16,20,7,16,20,5,
 20,20,12,20,[15,16,20],20,5,5,12,5,5,5,11,5,20,16,16,
 20,16,[16,20],[16,20],20,16,20,16,16,20,[15,16,20],
 [15,16,20],11,5,11,[15,16,20],11,5,20,12,11,12,11,20,
 11,5,16,[16,20],[16,20],16,11,11,16,16,16,16,11,7,20,
 12,[15,16,18,20],[16,20],20,5,16,[15,16,20],[16,20],
 12,5,16,20,20,12,11,10,5,20,5,5,11,12,11,[15,16],
 [15,16,20],[15,16,20],15,20,20,20,[15,16,20],[16,20],
 [15,16,20],[16,20],11,13,11,12,12,11,12,11,5,13,13,13,
 11,5,11,5,11,10,11,10,5,11,5,5,5,5,11,13,13,5,5,10,12,
 13,20,11,12,13,10,12,11,11,5,[15,16,20],5,20,20,5,16,5,
 20,20,20,5,5,5,5,5,5,5,5,5,5,5,5,16,5,20,12,11,5,20,
 11,11,12,5,5,16,5,5,5,5,5,20,20,20,5,11,5,5,5,5,5,5,
 5,5,20,5,5,5,5,5,20,11,5,5,20,5,5,11,5,5,5,5,5,5,20,
 16,5,16,20,[16,20],5,5,5,5,5,5,5,5,5,5,5,5,[16,20],
 5,20,13,5,5,20,12,20,12,5,5,13,5,5,20,16,5,16,20,
 [16,20],5,5,5,5,5,5,5,5,5,5,5,5,[16,20],5,20,13,5,
 5,20,12,20,12,5,5,13,5,5,20,5,16,5,20,5,5,5,5,5,5,5,
 5,5,5,5,5,20,5,20,12,5,5,20,20,5,12,5,5,5,5,5,20,16,
 16,16,20,20,20,20,20,20,20,20,20,20,20,20,16,20,16,16,16,
 20,15,[15,20],16,16,20,20,16,20,16,20,20,20,5,5,5,5,5,
 5,5,5,20,20,20,20,5,13,20,12,5,12,20,5,20,[15,16,20],
 5,5,5,13,5,16,16,20,20,20,20,20,20,20,20,20,20,20,20,16,
 20,16,[15,16],16,20,[15,16],16,20,[16,20],20,20,20,20,
 [16,20],16,5,5,5,5,5,5,5,5,5,11,5,5,16,16,16,16,20,
 12,[16,20],12,20,[16,20],5,5,16,[15,16,20],16,11,11,
 11,11,11,11,11,11,12,12,20,13,16,16,16,15,20,[16,20],16,
 16,11,16,11,11,16,16,16,5,20,5,20,5,5,5,20,5,5,5,20,5,
 20,11,5,5,20,11,5,11,11,11,12,5,5,20,5,5,20,20,5,5,20,
 5,5,5,5,20,11,5,5,20,5,5,11,5,5,5,5,5,5,12,20,20,20,
 20,20,20,20,20,5,16,11,5,5,16,5,5,11,12,12,20,5,5,20,5,
 5,5,5,5,5,5,5,20,20,11,5,11,20,5,5,11,11,11,5,12,5,11,
 11,20,20,5,5,20,20,20,16,11,5,11,[15,16,20],11,5,11,20,
 20,12,11,12,5,20,5,20,20,20,5,5,16,11,5,5,16,5,5,11,11,
 11,5,5,5,20,5,20,20,20,5,5,16,11,5,5,16,5,5,11,11,11,
 5,5,5,5,5,5,20,5,5,16,11,5,5,[15,16,20],5,5,11,11,11,
 5,5,12,5,5,5,12,5,20,11,5,5,20,11,5,11,20,5,11,5,5,20,
 5,5,16,20,12,11,5,20,5,11,12,5,5,5,16,5,20,5,20,20,12,
 5,20,20,5,5,12,5,5,5,5,5,5,20,20,13,5,20,[15,16,20],
 5,5,12,20,5,5,5,12,5,20,20,12,5,20,15,16,14,12,11,20,5,
 5,20,19,16,15,20,5,12,19,11,12,5,20,5,16,16,20,7,20,
 [15,16,18,20],[18,20],20,16,20,20,16,[16,20],12,
 [15,16],12,11,12,11,11,12,12,13,11,[15,16,20],11,5,11,
 5,5,13,13,13,20,5,11,12,11,11,5,5,5,20,[15,16,20],
 [15,16,20],[15,16,20],[15,16,20],20,20,16,11,12,11,10,
 5,5,5,[16,20],5,5,13,13,13,11,11,13,12,13,5,11,11,11,
 10,11,11,5,5,5,5,20,5,20,20,5,16,5,5,5,5,5,5,5,5,5,
 20,20,5,5,20,20,5,5,20,11,5,11,20,5,5,5,11,11,5,20,5,
 7,5,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,16,5,5,11,11,5,
 5,20,11,11,5,5,20,5,5,7,20,20,16,6,20,20,20,20,20,20,
 20,20,20,20,20,20,20,7,20,16,20,16,20,16,15,16,20,20,20,
 16,20,15,20,5,20,16,5,5,5,5,5,5,5,5,5,5,5,5,5,20,5,
 20,5,20,5,11,11,20,5,5,5,11,5,11,20,20,15,16,20,20,20,
 20,20,20,20,20,20,20,20,20,7,20,20,15,16,20,20,16,15,16,
 20,20,16,20,20,5,16,20,5,5,5,5,5,5,5,5,20,20,20,5,20,
 20,5,5,[16,20],12,5,11,11,20,5,5,11,12,5,16,20,5,5,5,
 5,5,5,5,5,5,5,5,5,20,5,20,20,11,5,12,11,16,5,5,5,11,
 5,12,20,20,20,20,20,20,20,20,20,[16,20],[16,20],20,20,
 16,16,16,20,7,[15,16,20],[15,16,20],15,15,20,20,20,
 [16,20],[16,20],[16,20],5,5,5,5,5,5,5,5,5,5,11,5,
 16,20,20,20,11,11,11,20,11,20,5,5,20,11,11,5,20,5,20,5,
 20,5,20,20,5,5,16,5,5,5,11,5,5,20,11,5,11,11,20,5,5,
 20,5,20,5,20,5,20,20,5,5,16,5,5,5,11,5,5,20,11,5,11,
 11,20,5,5,5,11,20,5,5,20,20,20,5,16,5,5,5,11,5,5,12,
 11,5,11,11,[16,20],5,5,20,5,5,5,5,5,5,5,20,20,5,5,11,
 11,5,11,11,5,11,11,11,11,5,5,20,20,20,20,5,20,16,20,20,
 5,11,11,11,20,11,5,20,20,20,11,11,5,5,5,5,20,5,20,5,5,
 5,11,5,5,11,11,5,5,5,11,5,5,20,20,20,5,20,16,5,20,5,
 11,5,20,11,11,5,12,12,[16,20],5,5,5,5,5,20,20,5,20,5,
 11,5,11,11,11,5,11,11,11,5,11,5,5,5,16,20,5,5,13,5,5,
 13,13,5,20,5,12,20,5,5,5,16,20,5,5,13,5,5,13,13,5,20,
 5,12,20,5,5,20,20,5,11,11,20,5,11,11,11,5,5,12,5,5,20,
 5,11,5,11,5,11,11,11,5,20,5,11,5,11,20,20,16,7,20,20,7,
 16,16,16,16,7,20,20,5,11,20,20,5,11,20,12,11,11,11,20,5,
 11,20,5,20,11,20,11,11,11,11,5,20,11,10,10,13,11,5,5,5,
 13,10,11,12,12,20,20,11,11,11,20,13,13,5,11,13,11,11,10,
 11,5,5,11,13,10,11,11,11,5,5,11,13,13,12,20,11,11,11,11,
 11,20,12,12,5,5,13,10,10,5,12,10,11,13,10,10,11,11,5,5,
 5,5,7,5,5,16,5,5,5,5,5,5,5,5,20,5,20,5,20,20,5,20,5,
 11,5,11,5,20,5,5,11,11,5,20,20,20,20,16,5,5,5,5,5,5,5,
 5,5,20,20,5,20,11,11,5,5,20,11,5,11,20,5,5,5,11,11,5,
 5,20,20,5,5,5,5,5,5,5,5,5,5,20,5,5,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,20,5,20,5,5,5,5,5,5,5,5,5,20,5,5,5,
 20,20,5,5,12,20,5,20,12,5,5,5,5,5,5,20,20,16,20,20,20,
 20,20,20,20,20,7,20,16,20,16,16,20,16,20,[16,20],20,
 [16,20],20,16,20,20,[16,20],[16,20],20,5,20,5,5,5,5,
 5,5,5,5,20,5,5,5,5,5,11,20,5,5,11,5,5,5,5,5,5,5,11,
 5,5,5,5,5,5,5,5,5,20,20,5,5,16,16,20,5,[16,20],20,11,
 20,16,5,5,5,20,20,11,5,5,5,5,5,5,5,5,20,5,20,5,16,16,
 20,[16,20],5,20,11,20,5,16,5,5,20,20,11,5,20,5,16,5,5,
 5,7,5,5,5,20,20,5,5,5,11,5,11,5,5,20,20,11,11,5,5,5,
 5,5,20,5,20,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,20,5,5,16,5,20,5,20,20,5,5,5,5,5,5,5,5,12,12,20,20,
 5,16,5,5,5,7,5,5,5,20,20,5,5,5,11,5,11,5,5,20,20,11,
 11,5,5,11,20,16,5,5,20,16,16,20,5,5,20,11,20,5,5,16,
 [16,20],20,20,11,5,5,20,5,20,5,5,5,5,5,5,5,5,5,5,5,
 5,5,5,5,5,20,20,20,5,20,5,5,20,5,5,5,20,5,5,5,11,11,
 5,5,5,20,5,5,20,5,5,20,5,5,5,11,5,5,5,11,11,5,5,11,
 20,20,20,16,16,20,20,20,[16,20],20,[16,20],20,20,16,16,
 [16,20],[16,20],20,5,5,20,20,5,5,12,5,5,5,12,5,5,5,
 20,20,5,5,20,20,5,12,5,20,5,20,5,12,5,5,5,5,5,5,5,11,
 5,5,5,11,5,5,5,20,5,5,5,11,5,5,20,20,20,5,20,20,20,20,
 20,20,20,5,5,20,20,20,5,20,20,20,20,20,20,20,5,11,11,5,
 20,5,11,11,11,11,5,5,20,5,12,10,12,5,5,5,5,12,12,10,11,
 10,11,5,5,5,5,12,12,10,5,5,12,11,11,12,5,5,5,5,11,10,
 10,11,5,5,5,12,11,11,12,5,5,5,5,5,5,11,11,10,5,5,12,
 12,10,5,12,12,11,11,11,10,5,5,5,20,16,5,16,20,[16,20],
 5,5,5,5,5,5,5,5,5,5,5,5,[16,20],5,20,13,5,5,20,12,
 20,12,5,5,13,5,5,5,5,7,5,16,5,5,5,5,5,5,5,5,5,5,5,5,
 20,5,20,20,5,5,11,11,5,20,5,5,11,5,11,5,5,20,20,5,5,5,
 5,5,5,5,5,5,5,5,5,16,5,5,12,12,5,5,[16,20],12,12,5,
 5,[16,20],5,5,5,5,16,5,5,5,5,5,5,5,5,16,5,16,5,20,
 20,5,[16,20],5,12,5,12,5,[16,20],5,5,12,12,5,5,16,5,
 5,5,5,5,5,5,5,5,5,5,5,20,5,20,[15,16,20],5,5,12,12,
 5,16,5,5,12,5,12,20,5,5,5,5,5,5,5,5,5,11,5,5,16,20,
 20,11,20,11,11,20,20,11,5,5,20,11,11,20,20,20,20,20,20,
 20,20,[16,20],20,[16,20],20,16,16,16,7,20,[16,20],
 [16,20],[16,20],20,15,20,20,[15,16,20],[15,16,20],
 [15,16,20],5,7,5,20,5,5,5,20,5,20,5,16,5,5,11,5,5,5,
 20,5,11,11,11,20,5,5,5,5,5,5,20,5,5,20,5,5,20,5,5,11,
 5,5,5,11,5,11,5,5,11,5,5,5,20,7,5,5,16,5,16,5,16,5,5,
 12,5,5,5,16,5,12,12,12,[15,16,20],5,5,20,5,5,5,5,5,5,
 5,20,20,5,11,5,11,5,11,5,11,11,11,11,11,5,20,11,20,20,
 5,20,20,16,20,20,11,5,11,11,20,5,11,20,20,20,11,11,5,5,
 20,5,20,5,16,5,5,11,5,5,5,20,5,11,11,11,20,5,5,20,5,
 20,5,20,20,5,20,11,5,5,20,11,5,11,11,11,11,5,5,5,5,5,
 20,20,5,20,11,5,5,11,11,5,11,11,11,11,5,11,5,5,5,
 [16,20],20,5,13,5,20,5,13,5,13,20,5,13,5,5,5,5,20,20,
 5,11,11,5,5,12,11,11,5,5,11,20,5,5,[16,20],20,5,13,5,
 20,5,13,5,13,20,5,13,5,5,20,5,11,11,5,5,11,11,5,11,20,
 5,11,5,11,20,20,[15,16,20],[15,16,20],20,20,15,
 [16,20],[16,20],[16,20],[15,16,20],7,20,20,5,20,11,
 20,5,11,11,20,11,11,11,20,5,20,11,5,20,11,11,20,11,11,
 11,5,20,11,13,13,20,11,20,11,11,20,12,12,10,10,13,5,11,
 5,5,12,10,10,5,11,10,12,10,11,11,5,5,11,11,12,10,11,11,
 5,5,12,20,12,13,20,11,11,11,5,5,13,10,10,11,11,20,13,13,
 5,13,11,11,12,10,10,11,11,5,16,20,7,16,20,20,20,20,20,
 20,20,20,20,20,20,20,20,16,20,16,20,16,20,[16,20],
 [16,20],16,20,20,20,[15,16,20],20,[15,16,20],20,16,16,
 16,20,20,20,20,20,20,20,20,20,20,20,20,7,20,16,20,
 [16,20],20,16,[15,16],[15,16],16,20,20,[16,20],20,20,
 20,16,20,5,5,5,5,5,5,5,5,20,20,20,20,11,12,5,5,20,12,
 5,11,20,20,5,5,11,12,5,16,16,20,20,20,20,20,20,20,20,20,
 20,20,20,16,20,16,16,16,20,16,16,16,16,20,20,16,20,16,20,
 20,20,20,20,20,20,20,20,20,20,20,20,16,16,16,20,7,16,16,
 16,6,20,20,20,[15,20],20,[16,20],5,5,5,5,5,5,5,5,5,
 5,12,5,16,20,16,16,5,11,16,19,20,15,5,5,14,11,12,20,20,
 5,[16,20],5,5,20,20,20,5,20,[15,16,20],5,20,5,5,5,20,
 13,20,5,12,13,13,5,5,20,5,20,5,20,5,5,20,5,5,20,5,5,5,
 5,5,5,12,20,5,20,5,12,5,5,5,13,20,20,20,20,20,20,20,16,
 5,20,5,5,5,5,12,20,5,12,12,[15,16,20],5,20,20,5,5,5,
 5,5,5,5,11,20,5,5,5,11,5,11,20,5,11,12,11,11,5,5,
 [16,20],16,20,20,5,16,16,20,16,5,5,11,[15,16,20],19,
 20,5,15,16,19,11,12,5,5,5,5,20,5,11,5,5,5,5,5,5,11,20,
 5,5,5,11,5,5,20,20,20,5,20,[15,16,20],5,20,5,5,5,20,
 13,20,5,12,13,13,5,5,5,5,5,20,20,5,20,5,5,5,11,11,20,
 5,11,16,11,5,11,20,5,20,20,5,5,5,5,5,5,12,20,5,20,5,
 12,5,5,5,5,13,20,5,5,11,5,5,13,[15,16,20],5,20,5,12,
 20,5,5,12,20,5,11,5,20,5,11,20,11,5,5,11,5,5,12,5,11,
 5,5,5,11,12,20,5,20,20,12,5,11,11,16,16,16,11,11,16,
 [16,20],16,[16,20],16,7,11,20,5,11,12,20,5,11,
 [15,16,20],11,11,12,11,20,5,16,[15,16,20],5,20,
 [16,20],[16,20],12,12,16,16,5,20,5,11,13,12,20,20,5,5,
 13,11,13,11,13,13,[15,20],5,5,5,13,11,13,5,11,
 [15,16,20],10,11,10,11,5,5,[16,20],[15,16,20],11,11,
 13,11,5,5,[15,16],12,12,12,12,11,11,20,20,20,
 [15,16,20],[15,16,20],[15,16,20],5,5,12,11,11,20,12,
 10,11,12,11,13,11,[15,16,20],5,5,20,20,5,5,5,5,5,5,5,
 5,5,5,5,5,5,20,5,20,5,12,5,20,20,12,5,5,5,5,5,5,20,5,
 20,5,5,5,5,5,5,5,5,20,5,20,20,5,11,5,5,5,11,5,5,5,20,
 5,5,5,11,5,20,16,20,20,20,20,20,20,20,20,20,20,20,20,16,
 20,16,16,20,20,[16,20],[16,20],20,16,20,20,[16,20],20,
 [16,20],5,5,5,5,5,5,5,5,5,5,11,5,5,16,20,16,5,7,11,
 20,20,7,5,5,5,20,11,20,5,5,5,5,5,5,5,5,5,5,11,5,16,
 20,16,7,5,11,20,20,5,7,5,5,20,11,20,5,20,5,16,5,20,5,
 20,5,5,20,20,5,20,5,5,5,11,11,5,5,20,20,11,5,11,5,5,5,
 5,20,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,5,20,20,5,20,20,20,5,20,5,5,5,5,5,5,5,12,12,20,5,
 20,20,5,5,5,5,5,5,5,5,20,5,5,5,11,5,5,5,5,11,11,5,11,
 5,5,20,16,16,5,5,16,16,20,16,5,5,11,20,20,5,5,7,7,20,
 11,20,5,5,5,5,20,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,
 20,20,5,20,20,5,20,5,5,5,20,20,5,5,12,12,5,5,5,20,5,5,
 20,20,5,20,5,5,5,11,11,5,5,20,20,11,5,11,5,5,5,11,5,
 11,5,5,5,11,11,5,5,16,5,11,5,11,5,5,5,20,5,5,11,5,5,
 5,11,5,5,5,5,20,5,5,5,20,5,11,5,20,5,5,5,11,5,5,5,5,
 5,11,5,11,5,5,5,11,11,5,5,16,5,11,5,11,5,5,20,20,5,20,
 20,20,20,20,20,20,5,20,5,11,11,20,5,5,11,11,11,11,5,20,
 5,20,20,5,20,20,20,20,20,20,20,5,20,5,10,11,11,5,5,5,5,
 12,10,12,10,12,12,5,5,5,5,11,10,11,5,5,11,10,11,11,5,5,
 5,5,12,12,12,12,5,5,5,12,12,12,12,5,5,5,5,5,5,12,10,
 12,5,5,11,10,11,5,12,11,12,12,10,12,5,5,5,5,16,20,5,5,
 5,5,5,5,5,5,20,20,20,5,20,16,5,5,13,13,5,20,12,20,5,5,
 5,13,5,[16,20],20,5,5,5,5,5,5,5,5,5,5,5,5,20,5,16,
 20,13,5,13,20,13,5,5,5,5,5,13,16,11,11,11,11,11,11,11,
 11,13,20,12,11,16,16,16,11,16,[16,20],16,16,15,20,11,11,
 16,[16,20],[16,20],5,5,5,5,5,5,5,5,5,20,11,5,16,16,
 16,20,[16,20],12,12,[16,20],16,20,5,5,[16,20],16,
 [15,16,20],20,20,5,20,5,20,5,20,5,5,5,16,5,5,5,11,5,
 5,[16,20],11,5,11,11,12,5,5,5,5,11,20,20,5,20,20,20,5,
 16,5,5,5,11,5,5,20,11,5,11,11,20,5,5,5,11,20,20,5,20,
 20,20,5,16,5,5,5,11,5,5,20,11,5,11,11,20,5,5,20,5,5,5,
 5,5,5,5,20,20,5,5,11,11,5,20,11,5,11,11,5,12,5,5,12,
 20,20,20,5,20,16,20,20,5,11,11,11,[16,20],11,5,20,20,
 12,11,11,20,5,5,5,20,5,20,5,5,5,11,5,5,20,11,5,5,5,5,
 5,5,20,20,20,20,20,16,5,20,5,11,5,20,20,11,5,12,12,20,
 5,5,5,5,5,20,20,5,20,5,11,5,11,20,11,5,11,11,5,5,12,
 20,5,5,20,20,5,5,12,20,5,[15,16,20],12,5,20,5,12,5,5,
 20,5,16,16,5,11,12,12,5,[16,20],12,11,11,11,12,
 [16,20],5,5,20,16,5,11,12,20,5,20,12,11,5,5,5,20,5,20,
 5,12,5,11,5,11,20,11,5,20,5,5,5,11,20,20,16,16,20,20,7,
 [18,20],[15,16,20],20,16,16,20,20,5,[16,20],19,
 [15,20],5,20,14,12,11,12,5,20,5,13,20,5,[15,20],20,14,
 16,11,11,5,5,20,[16,20],11,11,[15,16,20],11,5,5,5,13,
 13,13,12,13,[15,16,20],12,11,11,11,14,12,12,5,20,12,11,
 10,11,5,20,5,20,12,11,11,11,5,5,20,[15,16],[15,16,20],
 [15,16,20],[15,16,20],15,20,20,[16,20],11,11,13,11,13,
 5,5,13,13,13,5,11,10,11,11,11,10,5,5,5,5,16,5,5,5,5,5,
 5,5,5,20,5,20,20,5,11,11,20,5,11,11,5,5,20,5,5,5,11,
 11,20,5,5,5,5,5,5,5,5,20,13,20,5,16,16,20,5,20,14,11,
 12,[15,20],20,5,5,[16,20],19,12,20,20,20,20,20,20,20,
 20,16,20,7,16,16,16,16,16,20,15,20,[15,16,20],20,7,20,
 20,16,16,16,5,20,20,16,5,5,5,16,5,20,5,20,20,5,5,5,12,
 5,11,5,20,11,[16,20],11,12,5,5,5,5,5,20,5,20,20,20,5,
 5,11,5,5,5,11,5,5,5,20,5,5,5,11,5,5,16,20,5,5,16,5,
 16,5,20,[16,20],5,5,5,13,5,5,5,20,12,13,20,12,5,16,20,
 5,5,16,5,16,5,20,[16,20],5,5,5,13,5,5,5,20,12,13,20,
 12,5,20,12,20,16,5,16,20,16,16,20,5,5,14,11,16,5,20,
 [15,20],20,12,20,11,5,5,20,5,16,5,5,20,5,5,5,12,5,5,
 5,20,20,5,5,12,5,20,20,20,20,20,5,11,20,5,5,11,20,5,5,
 20,11,11,5,11,5,20,5,20,20,5,11,20,5,5,11,11,5,5,20,11,
 12,5,11,11,20,16,20,16,16,20,16,20,16,20,16,20,15,
 [15,20],16,16,16,20,20,5,20,20,5,5,12,12,5,5,12,20,5,
 5,20,[15,16,20],5,20,16,16,20,[16,20],20,[15,16],20,
 16,20,[15,16],16,20,20,[16,20],20,5,11,12,20,5,11,12,
 5,5,20,20,5,5,11,12,16,5,[16,20],16,16,5,20,12,
 [16,20],12,[15,16,20],20,[16,20],5,11,16,16,15,11,20,
 [16,20],16,16,[16,20],11,16,11,12,11,11,20,5,11,
 [16,20],11,11,5,11,20,5,13,11,13,5,[15,20],5,5,13,13,
 11,12,10,12,20,20,5,5,13,12,11,11,[16,20],12,[15,16],
 12,13,11,12,11,5,11,[15,16,20],10,11,5,11,5,11,
 [15,16,20],11,13,5,11,5,20,5,5,11,12,10,20,20,
 [15,16,20],[15,16,20],[15,16,20],20,11,12,11,12,12,10,
 [16,20],5,11,20,5,5,5,5,5,5,5,5,5,11,5,5,16,20,16,20,
 15,11,19,16,16,5,5,5,12,11,20,20,20,20,20,20,20,20,20,
 20,20,16,16,16,16,16,7,20,16,16,16,20,7,20,20,
 [15,16,18,20],20,[16,20],5,20,5,16,5,20,20,20,5,5,5,
 20,5,20,20,5,5,12,11,5,5,16,11,11,5,12,5,5,5,5,20,5,5,
 20,5,5,5,5,11,20,5,5,11,5,5,5,5,5,5,5,11,5,[16,20],
 20,20,5,20,5,20,20,20,5,[16,20],20,5,5,13,5,5,5,13,13,
 20,5,12,20,5,5,5,5,5,5,5,5,20,11,20,5,11,11,5,5,5,12,
 11,5,11,11,20,13,[16,20],16,5,20,16,16,20,16,20,5,11,
 19,12,5,5,16,15,16,11,14,20,20,5,5,20,5,5,5,20,20,5,5,
 12,5,5,5,5,20,5,5,12,20,20,20,20,20,20,5,16,20,5,5,
 [16,20],20,5,5,13,12,5,5,12,20,5,20,20,20,5,[16,20],
 20,5,5,13,5,5,5,13,13,20,5,12,5,5,20,11,5,12,20,5,5,
 12,11,5,5,16,5,11,5,12,5,5,5,20,12,20,11,5,11,5,11,5,
 5,5,5,20,11,20,5,20,13,[15,16,20],5,20,12,5,5,12,5,20,
 5,5,13,20,20,20,[16,20],5,11,12,11,5,12,16,11,11,11,12,
 5,16,[15,16,20],12,5,16,20,[15,16,20],16,16,12,20,5,
 [16,20],11,[16,20],11,20,11,5,11,12,11,12,5,20,11,16,
 [16,20],11,15,20,16,16,16,[16,20],11,11,16,20,
 [15,16,20],[15,16],[15,16,18,20],20,15,20,20,
 [15,16,20],[15,16,20],[16,20],10,12,11,20,5,5,5,11,
 10,12,11,5,11,11,11,10,5,5,11,[16,20],12,13,12,12,11,
 11,12,13,13,13,11,5,5,11,5,5,5,13,11,12,5,5,13,11,13,
 20,13,11,12,11,11,12,5,[16,20],11,5,5,5,5,5,5,5,5,5,
 11,11,5,16,16,16,20,20,20,20,20,20,20,5,5,20,20,20,20,
 20,5,20,5,20,5,20,20,5,5,16,20,20,5,20,11,11,20,20,5,
 11,11,20,11,11,11,20,5,5,16,20,20,16,5,20,16,16,16,5,20,
 20,20,20,20,5,20,20,20,20,20,5,11,20,20,5,20,12,20,5,16,
 20,20,5,20,11,11,12,20,5,11,11,[16,20],11,12,20,5,20,5,
 5,20,5,5,20,16,20,5,20,20,11,11,20,5,11,11,11,20,12,5,
 16,20,20,16,5,20,16,16,16,5,20,20,20,20,20,5,20,20,20,
 20,20,5,5,5,11,20,5,20,20,20,5,20,11,11,11,20,5,5,5,11,
 11,11,16,20,16,5,16,16,16,16,5,20,12,16,12,20,5,
 [16,20],16,[15,16,20],16,[16,20],5,20,5,20,20,20,16,
 5,20,11,20,11,20,5,11,11,11,11,20,[16,20],5,5,16,16,20,
 5,20,12,11,19,15,5,20,5,19,16,12,11,[15,16,20],16,7,16,
 11,7,16,[16,20],[16,20],16,11,11,20,[16,20],[16,20],
 [16,20],5,20,16,20,11,20,[15,16,20],11,11,20,11,5,5,
 11,12,12,20,16,16,5,16,12,14,11,[16,20],5,20,5,11,
 [15,16,20],19,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
 16,[15,16,20],16,16,[15,16,20],[15,16,20],16,
 [15,16,20],[15,16,20],[15,16,20],[15,16,20],16,
 [15,16,20],16,16,16,16,16,16,16,16,16,16,16,16,20,12,12,
 12,20,5,5,5,13,13,13,16,16,16,7,20,20,20,16,16,15,20,20,
 16,13,13,13,20,20,20,20,16,13,13,12,20,20,20,15,13,13,12,
 20,20,20,20,20,20,16,16,16,5,5,12,12,13,5,12,12,13,13,
 13,13,20,20,20,5,16,5,20,20,5,5,20,5,20,5,16,20,20,20,
 5,11,12,20,5,20,11,11,20,11,11,5,5,5,5,20,5,5,20,11,5,
 20,20,20,20,5,11,11,11,5,20,5,5,11,11,11,20,16,16,20,20,
 16,5,16,20,16,16,16,20,5,[15,16,20],16,16,5,20,16,
 [16,20],[15,16,20],12,12,20,20,5,5,5,5,20,5,20,16,20,
 20,5,20,11,11,5,20,11,11,11,20,11,5,11,20,20,5,16,20,16,
 16,16,20,5,20,20,20,5,20,20,20,20,20,20,11,20,20,5,16,
 20,16,16,16,20,5,20,20,20,5,20,20,20,20,20,20,20,5,20,
 12,20,20,20,16,20,5,12,16,11,5,20,11,11,11,11,12,5,5,20,
 20,20,20,16,20,5,11,20,11,5,20,11,11,11,11,20,5,
 [16,20],5,16,16,20,20,5,16,12,14,5,15,20,5,20,12,11,11,
 5,20,16,20,20,11,11,12,11,11,20,5,5,11,[15,16,20],11,
 [15,16,20],16,16,16,7,11,[16,20],16,[16,20],11,16,11,
 20,[16,20],16,[16,20],20,16,16,16,5,[15,16,20],14,11,
 5,[16,20],20,5,11,12,14,16,16,16,[16,20],[16,20],
 [16,20],7,[16,20],7,[16,20],[16,20],16,[16,20],
 [16,20],16,16,16,16,16,16,16,16,16,16,16,16,16,15,
 [15,16,20],[15,16,20],15,[15,16,20],[15,16,20],16,
 [15,16,20],[15,16,20],[15,16,20],[15,16,20],16,20,16,
 15,16,20,7,20,20,16,16,16,13,13,13,5,20,5,5,12,12,12,20,
 20,12,16,12,13,20,20,20,20,13,16,12,13,20,20,20,12,16,13,
 13,20,20,20,20,5,5,13,13,13,20,20,16,16,16,5,13,13,13,
 12,12,13,20,20,20,20,5,20,5,20,5,20,20,5,5,16,5,5,5,11,
 5,5,20,11,5,11,11,20,5,5,20,15,7,20,20,20,20,16,20,6,
 20,20,15,20,20,20,16,20,16,15,16,16,20,20,16,5,5,5,7,5,
 5,5,20,20,5,5,5,11,5,11,5,5,20,20,11,11,5,20,[16,20],
 16,6,20,20,16,20,16,16,20,20,[16,20],[16,20],[16,20],
 20,20,15,7,15,[15,16,20],[15,16,20],5,5,20,5,20,5,16,
 5,5,11,5,5,5,20,5,11,11,11,20,5,5,20,20,20,5,20,
 [15,16,20],5,20,5,5,5,20,13,20,5,12,13,13,5,5,20,5,5,
 20,20,5,20,5,5,5,11,11,5,5,20,20,11,5,11,20,20,20,15,
 16,20,20,20,15,20,16,20,20,16,7,15,16,20,5,5,16,20,5,5,
 12,5,5,[16,20],12,5,11,11,11,20,5,5,16,20,5,12,5,20,5,
 11,5,12,11,11,16,5,5,20,5,11,5,5,5,11,11,5,5,16,11,11,
 5,11,20,20,[16,20],[16,20],20,20,7,[15,16,20],
 [15,16,20],15,[16,20],15,20,20,5,11,11,20,5,11,11,11,
 20,20,11,20,5,12,11,5,20,11,11,11,20,20,11,5,20,5,10,11,
 13,5,5,11,11,12,11,10,11,10,13,5,5,11,11,13,10,10,5,11,
 10,10,13,13,11,5,5,11,11,10,12,13,11,5,5,12,12,20,11,20,
 11,11,5,11,11,13,11,10,11,11,13,10,11,20,11,13,13,20,12,
 12,11,11,5,5,11,20,20,5,20,20,20,5,16,5,5,5,11,5,5,20,
 11,5,11,11,20,5,5,20,5,20,5,5,7,5,5,5,16,5,5,11,20,5,
 5,11,5,11,11,5,20,5,5,16,20,20,16,5,20,16,16,16,5,20,
 20,20,20,20,5,20,20,20,20,20,20,5,5,20,20,5,5,5,5,5,5,
 5,5,5,5,5,5,5,5,5,5,7,20,20,20,16,20,20,16,20,
 [16,20],20,16,20,[16,20],20,[16,20],[16,20],20,20,16,
 5,20,5,20,5,5,16,5,11,5,20,5,11,5,11,11,5,5,20,20,5,5,
 20,5,5,5,5,5,5,12,20,5,20,5,12,5,5,20,20,20,16,20,20,
 [15,16,20],16,20,20,[16,20],20,[16,20],[15,16,20],20,
 16,20,5,5,20,5,11,5,20,5,5,5,11,5,5,5,5,5,5,5,20,5,5,
 5,12,5,20,5,20,5,5,5,12,5,5,11,20,5,5,[16,20],20,11,
 20,20,16,5,5,5,11,20,[16,20],5,5,20,11,20,20,5,16,5,
 11,20,5,[16,20],5,20,11,20,20,5,5,16,5,10,10,11,5,5,5,
 5,10,11,10,11,12,12,5,5,5,5,11,12,11,5,5,12,10,12,11,5,
 5,5,5,12,10,12,12,5,5,5,11,10,11,12,5,5,5,5,5,5,12,11,
 12,5,5,11,10,10,5,12,11,12,11,12,11,5,5,5,16,20,5,5,16,
 5,16,5,20,[16,20],5,5,5,13,5,5,5,20,12,13,20,12,5,16,
 20,[16,20],16,11,16,16,16,16,16,11,11,[16,20],[16,20],
 16,11,20,15,16,16,[16,20],16,20,20,16,20,7,20,16,20,20,
 [16,20],20,20,20,16,20,[16,20],[16,20],[16,20],16,20,
 20,20,20,20,20,20,16,5,16,11,11,5,16,12,11,11,12,12,
 [16,20],5,11,20,5,20,20,20,5,[16,20],20,5,5,13,5,5,5,
 13,13,20,5,12,20,16,20,16,16,20,20,20,20,20,[16,20],20,
 16,[15,16],[16,20],[15,16],16,20,20,5,16,20,5,5,12,5,
 5,20,12,5,11,11,20,20,5,20,16,16,20,16,20,16,20,16,20,
 16,16,16,16,16,20,20,5,13,5,5,5,12,5,5,20,[16,20],12,
 20,5,12,20,20,[15,16,18,20],20,20,20,7,16,16,16,
 [16,20],6,20,20,5,12,11,16,5,5,11,16,19,20,20,15,5,16,
 11,5,16,5,11,12,19,14,20,5,15,5,13,13,13,5,5,11,
 [16,20],[15,16,20],11,11,11,11,11,5,5,11,11,
 [15,16,20],10,11,5,5,11,13,12,12,20,20,5,5,11,13,12,12,
 20,5,20,11,13,13,13,[15,20],5,5,5,11,11,[15,16,20],10,
 11,[16,20],11,[15,16,20],11,11,12,[15,16],12,13,
 [16,20],11,13,20,20,5,20,16,16,16,20,20,16,16,16,16,20,
 20,7,16,16,20,20,7,7,16,16,16,5,5,5,5,7,5,5,16,5,11,5,
 20,5,5,5,11,11,11,5,20,5,20,5,16,5,16,5,[15,16,20],20,
 5,20,13,20,5,5,5,13,13,5,13,5,5,5,5,7,5,20,20,5,5,11,
 11,5,5,5,20,20,5,11,11,5,5,5,20,20,5,5,5,12,5,12,5,5,
 [16,20],16,12,12,5,5,5,5,16,5,5,12,[16,20],5,5,12,5,
 12,12,5,[16,20],5,5,5,16,5,12,5,[15,16,20],5,5,5,12,
 12,12,5,16,5,5,20,20,5,5,12,12,5,5,5,16,[16,20],5,12,
 12,20,5,11,11,11,5,20,11,11,20,20,20,11,5,20,
 [15,16,20],[15,16,20],7,20,20,[16,20],[16,20],
 [16,20],15,20,15,20,11,11,11,20,5,11,11,20,20,5,11,20,
 5,12,10,11,5,5,11,11,11,13,10,12,10,10,5,5,11,11,11,13,
 11,11,11,13,13,20,20,11,20,11,5,10,11,13,13,5,11,5,10,
 10,13,12,5,11,5,5,11,11,10,12,10,11,11,11,12,10,20,12,
 20,13,13,11,13,11,5,11,11,20,20,5,16,20,16,16,16,20,5,
 20,20,20,5,20,20,20,20,20,20,15,20,16,11,7,16,16,16,11,
 20,16,16,[16,20],11,11,16,15,[16,20],16,16,16,20,20,7,
 16,16,16,20,20,[15,16,20],[15,16,20],[15,16,20],20,20,
 7,15,[16,20],[16,20],[16,20],20,20,16,16,16,16,20,20,
 [15,16,18,20],20,[15,20],20,20,6,16,16,16,16,5,20,16,
 16,16,5,16,16,[16,20],[15,16,20],[16,20],5,20,20,12,
 [15,16,18,20],12,20,16,16,16,16,5,[16,20],12,12,5,
 [16,20],20,20,16,[15,16,20],16,16,16,16,20,20,[16,20],
 16,20,20,20,7,7,16,16,16,16,16,[15,16,20],[15,16,20],
 [15,16,20],[15,16,20],16,[15,16,20],[15,16,20],15,16,
 15,[15,16,20],[15,16,20],16,16,16,16,16,16,16,16,16,16,
 16,16,16,[16,20],[16,20],[16,20],16,[16,20],[16,20],
 [16,20],16,7,[16,20],[16,20],7,5,13,13,13,5,5,20,20,
 13,12,12,13,13,13,5,5,20,20,12,12,12,20,20,12,12,16,16,
 20,20,20,20,12,12,16,16,20,20,20,12,12,16,16,20,20,20,5,
 20,20,13,13,13,20,20,13,13,13,7,15,16,16,16,16,16,20,20,
 20,20,5,20,20,20,5,5,16,11,5,5,16,5,5,11,11,11,5,5,5,
 5,5,20,20,5,5,16,11,5,5,20,5,5,11,11,11,5,5,20,5,20,5,
 20,5,5,5,5,5,5,12,5,20,20,5,12,5,5,20,5,5,20,5,5,11,
 5,5,5,11,5,5,5,5,20,5,20,20,16,20,[15,16,20],20,16,20,
 20,20,[16,20],[16,20],[15,16,20],20,16,20,5,5,20,5,5,
 5,12,5,5,20,20,5,5,5,12,5,5,20,11,5,5,7,11,20,20,20,7,
 5,5,5,20,11,7,5,5,11,20,20,20,5,7,5,20,11,5,7,5,11,20,
 20,20,5,5,7,5,12,11,12,5,5,5,5,12,12,12,10,10,11,5,5,
 5,5,11,11,10,5,5,10,11,11,12,5,5,5,5,10,12,12,11,5,5,
 5,10,12,12,12,5,5,5,5,5,5,11,10,10,5,5,12,12,11,5,12,
 12,11,12,12,12,5,5,5,20,16,20,7,20,20,7,20,16,20,7,20,
 15,20,16,15,20,20,7,20,5,20,13,5,20,5,5,5,20,12,20,5,
 [15,16,20],12,12,5,5,20,16,20,16,16,20,[15,16,20],16,
 16,20,[16,20],20,[16,20],[15,16,20],20,16,16,20,5,20,
 16,12,5,20,20,5,5,12,11,11,5,5,20,20,16,7,20,20,16,16,
 20,16,20,16,16,20,20,16,5,20,11,12,5,20,[16,20],
 [15,16,20],11,14,14,16,5,5,20,11,[15,16,20],[16,20],
 20,5,12,11,14,19,5,16,5,16,16,20,7,20,[16,20],20,16,16,
 20,20,7,5,11,[16,20],11,5,5,11,11,10,11,11,11,[16,20],
 11,5,5,11,[16,20],13,13,13,20,5,11,10,12,13,5,20,5,20,
 [16,20],[16,20],16,16,20,20,[15,20],11,10,12,12,20,5,
 5,5,[16,20],11,13,13,13,11,11,11,11,11,12,11,13,14,12,
 12,16,5,5,5,5,5,20,11,5,20,5,5,5,11,11,5,5,
 [15,16,20],12,11,5,11,5,20,5,20,16,5,11,5,[16,20],5,
 11,5,11,11,5,20,11,20,5,20,16,11,5,20,11,5,5,11,11,11,
 5,5,16,20,16,15,20,20,15,16,20,20,20,7,7,20,16,15,5,20,
 11,11,5,11,20,11,11,20,20,20,5,11,20,11,11,20,11,5,11,
 11,20,20,5,20,11,[16,20],[16,20],20,7,20,[15,16,20],
 [15,16,20],[15,16,20],[16,20],20,20,15,5,10,13,11,5,
 5,11,11,10,11,12,10,13,11,5,5,11,11,10,10,12,11,5,10,10,
 12,13,5,5,11,11,12,12,20,20,11,11,20,10,10,12,13,5,5,11,
 5,11,11,11,10,13,11,11,11,10,13,20,13,13,20,12,12,20,5,
 11,11,5,5,16,20,5,5,13,5,5,13,13,5,20,5,12,20,5,5,
 [16,20],20,5,13,5,20,5,13,5,13,20,5,13,5,5,11,5,11,5,
 5,5,11,11,5,5,16,5,11,5,11,16,11,[16,20],[16,20],11,
 11,16,[16,20],16,16,16,15,20,11,5,16,[15,16,20],20,5,
 [16,20],12,12,[16,20],16,16,20,5,12,11,5,20,11,11,11,
 [15,16,20],12,11,5,20,5,13,11,12,5,5,20,5,12,13,10,13,
 11,12,5,5,20,5,12,13,11,5,[16,20],11,11,[15,16,20],13,
 11,5,5,11,11,11,[15,16,20],11,11,5,5,12,13,[15,16,20],
 13,12,11,11,5,20,5,12,11,10,20,5,12,11,10,16,[15,16],
 [15,16,20],[15,16,20],13,13,11,[16,20],11,5,5,5,16,5,
 11,11,20,5,5,11,11,5,5,5,20,5,5,20,16,5,13,5,13,5,12,
 5,20,5,5,20,12,20,5,11,14,5,5,20,14,11,12,16,[15,20],
 20,5,20,16,16,16,20,20,15,20,[15,16,20],16,20,7,20,12,
 14,5,20,5,20,11,12,[16,20],5,20,[15,20],11,11,11,11,
 11,5,5,5,11,[15,16,20],10,13,12,13,12,11,11,
 [15,16,20],12,[16,20],11,5,5,13,11,13,13,5,[15,20],5,
 5,12,11,13,13,5,20,20,12,10,12,13,20,20,5,11,[16,20],
 11,12,[15,16],12,5,5,11,[15,16,20],10,5,11,
 [15,16,20],11,11,[15,16,20],11,20,5,20,5,20,[16,20],
 13,5,20,13,5,5,12,20,5,5,5,13,20,5,14,11,20,5,15,11,19,
 16,12,16,5,5,20,[18,20],20,7,20,20,16,16,16,[16,20],
 20,7,20,19,11,20,15,5,11,19,[15,16,20],12,5,5,16,11,
 [15,16,20],12,12,11,12,11,[15,16,20],12,14,12,
 [15,16,20],11,10,5,11,5,5,11,11,11,20,20,[15,16,20],
 [15,16],[15,16,18,20],[15,16,20],20,15,20,5,10,12,11,
 11,5,5,20,10,12,11,11,20,5,5,11,5,5,11,11,10,[16,20],
 11,12,13,11,5,13,13,13,13,13,13,5,5,5,5,11,11,11,5,11,
 20,11,11,16,12,20,5,11,16,[15,16,20],16,20,[16,20],5,
 12,12,16,[16,20],5,20,16,[16,20],[16,20],11,16,11,
 [16,20],[16,20],16,16,11,20,15,5,12,12,11,5,20,20,5,
 11,13,12,13,13,11,20,5,20,5,10,12,12,[16,20],5,11,11,
 [16,20],13,5,5,11,11,12,12,16,14,11,11,12,10,11,
 [16,20],11,5,5,11,5,20,5,11,11,12,20,5,11,11,12,15,
 [16,20],[16,20],16,11,13,16,5,11,[16,20],5,20,20,20,
 5,20,20,20,20,20,20,20,5,20,20,5,20,20,20,20,20,20,20,5,
 20,20,13,13,16,20,20,20,20,16,12,12,13,13,16,20,20,20,20,
 16,12,12,5,20,12,12,12,13,20,5,5,20,12,12,13,13,20,5,5,
 16,16,16,16,7,20,20,20,20,20,16,13,13,20,20,16,13,13,20,
 15,13,13,16,12,12,20,20,5,20,20,20,20,5,20,20,20,20,5,
 20,20,20,16,12,12,20,20,20,20,13,16,13,16,12,13,20,20,20,
 20,13,16,13,20,20,16,15,16,16,20,7,20,5,13,13,13,12,5,
 20,5,13,13,13,12,5,20,5,20,20,20,12,16,12,20,20,13,16,
 13,20,12,16,12,13,15,13,20,5,20,20,13,15,13,20,20,20,20,
 12,13,16,13,16,13,20,20,20,20,12,12,16,20,5,12,12,12,13,
 5,5,20,20,16,16,16,16,20,20,7,12,13,12,13,5,5,20,20,20,
 20,13,13,16,20,20,13,13,16,20,13,13,16,13,12,16,5,20,20,
 12,11,11,5,5,5,5,12,11,12,11,12,11,11,11,12,11,11,11,11,
 11,12,11,11,11,11,12,11,12,11,12,12,11,11,5,5,5,11,11,
 11,5,5,12,12,11,5,11,11,11,12,12,12,12,12,12,12,11,12,
 11,11,11,11,12,11,12,11,11,11,12,11,11,11,11,11,11,12,11,
 11,11,5,5,5,12,11,12,5,5,11,11,11,5,11,11,11,11,12,11,
 12,11,11,5,11,12,12,11,5,5,5,12,11,11,12,5,5,5,11,12,
 11,11,11,11,11,11,11,12,11,11,11,12,11,11,11,11,5,5,5,
 12,12,12,12,5,5,5,12,12,11,11,11,12,12,11,11,11,11,12,
 11,11,12,11,11,12,5,5,5,12,11,11,12,11,11,12,11,11,11,
 11,12,11,11,11,12,11,11,5,5,5,5,5,11,12,11,5,12,11,12,
 11,11,11,11,12,12,5,12,12,11,11,11,11,12,11,11,11,12,11,
 12,12,11,11,12,12,5];

#############################################################################
##
#E  orbitgrowthtype.g . . . . . . . . . . . . . . . . . . . . . . . ends here
