#############################################################################
##
#W  refinementseqlngs.g            GAP4 Package `RCWA'            Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing a list of lists
##  of numbers of parts into which Z can be partitioned by applying words of
##  length 1, 2, 3, ... in the generators. For finite groups, the sequences
##  get constant at the length of a shortest respected partition of the res-
##  pective group.
##
#############################################################################

local  refinementseqlngsset, refinementseqlngspos, i;

refinementseqlngsset :=
[[3,3],[3,4,5,7,9,12,16,21,28,37,49,65,86,114,151,200,
   265,351,465],
 [3,4,6,8,12,16,24,32,48,64,96,128,192,256,384,512],
 [4,4],[4,5,5],[4,5,6,6],
 [4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37],
 [4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49,50,51],
 [4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49,50,51,52],
 [4,5,6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,
   32,33,35,36,38,39,41,42,44,45,47,48,50,51],
 [4,5,6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,
   32,33,35,36,38,39,41,42,44,45,47,48,50,51,53],
 [4,5,6,8,10,13,16,21,26,34,42,55,68,89,110,144,178,233,
   288,377,466],
 [4,5,6,8,10,13,17,22,29,38,50,66,87,115,152,201,266,352,
   466],
 [4,5,6,8,11,14,19,25,33,44,58,77,102,135,179,237,314,416]
  ,[4,5,7,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,
   31,32,34,35,37,38,40,41,43,44,46,47,49,50,52],
 [4,5,7,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,
   32,34,35,37,38,40,41,43,44,46,47,49,50,52,53],
 [4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513],
 [4,5,7,10,14,20,28,40,56,80,112,160,224,320,448],
 [4,6,6],
 [4,6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,
   33,34,36,37,39,40,42,43,45,46,48,49,51,52],
 [4,6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,
   33,34,36,37,39,40,42,43,45,46,48,49,51,52,54],
 [4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40],
 [4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,
   42,44,46,48],
 [4,6,8,12,16,22,30,40,54,72,96,128,170,226,300,398,528],
 [4,6,8,12,20,32,52,84,136,220,356,576],
 [4,6,9,13,18,25,34,46,62,83,111,148,197,262,348,462],
 [4,6,9,13,19,27,39,55,79,111,159,223,319,447],
 [4,6,10,14,22,30,46,62,94,126,190,254,382,510],
 [4,6,10,16,26,42,68,110,178,288,466],
 [4,7,11,17,25,37,53,77,109,157,221,317,445],[5,5],
 [5,6,6],[5,6,7,7],
 [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36],
 [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37],
 [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37,38],
 [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49],
 [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49,50],
 [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49,50,51],
 [5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
   24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49,50,51,52],
 [5,6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,
   33,34,36,37,39,40,42,43,45,46,48,49],
 [5,6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,
   33,34,36,37,39,40,42,43,45,46,48,49,51],
 [5,6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,
   33,34,36,37,39,40,42,43,45,46,48,49,51,52],
 [5,6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,
   33,34,36,37,39,40,42,43,45,46,48,49,51,52,54],
 [5,6,7,9,11,14,17,22,27,35,43,56,69,90,111,145,179,234,
   289,378,467],
 [5,6,7,9,11,14,18,23,30,39,51,67,88,116,153,202,267,353,
   467],
 [5,6,7,9,12,15,20,26,34,45,59,78,103,136,180,238,315,417]
  ,[5,6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,
   32,33,35,36,38,39,41,42,44,45,47,48,50],
 [5,6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,
   33,35,36,38,39,41,42,44,45,47,48,50,51],
 [5,6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,
   33,35,36,38,39,41,42,44,45,47,48,50,51,53],
 [5,6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,
   33,35,36,38,39,41,42,44,45,47,48,50,51,53,54],
 [5,6,8,10,14,18,26,34,50,66,98,130,194,258,386,514],
 [5,6,8,11,15,21,29,41,57,81,113,161,225,321,449],
 [5,7,7],[5,7,8,8],
 [5,7,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,
   34,35,37,38,40,41,43,44,46,47,49,50],
 [5,7,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,
   34,35,37,38,40,41,43,44,46,47,49,50,52],
 [5,7,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,
   34,35,37,38,40,41,43,44,46,47,49,50,52,53],
 [5,7,9,9],
 [5,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,
   34,36,37,39,40,42,43,45,46,48,49,51,52],
 [5,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,
   34,36,37,39,40,42,43,45,46,48,49,51,52,54],
 [5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39],
 [5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45],
 [5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45,47,49,51,53,55],
 [5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45,47,49,51,53,55,57,59,61,63],
 [5,7,9,13,15,19,21,25,27,31,33,37,39,43,45,49,51,55,57,
   61,63],
 [5,7,9,13,17,23,31,41,55,73,97,129,171,227,301,399,529],
 [5,7,9,13,21,33,53,85,137,221,357,577],
 [5,7,10,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55],
 [5,7,10,14,19,26,35,47,63,84,112,149,198,263,349,463],
 [5,7,10,14,20,28,40,56,80,112,160,224,320,448],
 [5,7,11,13,17,19,23,25,29,31,35,37,41,43,47,49,53,55,59,
   61,65],[5,7,11,15,23,31,47,63,95,127,191,255,383,511],
 [5,7,11,17,27,43,69,111,179,289,467],
 [5,8,11,14,17,20,23,26,29,32,35,38,41,44],
 [5,8,11,14,17,20,23,26,29,32,35,38,41,44,47],
 [5,8,11,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56],
 [5,8,12,18,25,35,48,65,88,118,158,211,281],
 [5,8,12,18,26,38,54,78,110,158,222,318,446],
 [5,8,13,19,27,38,52,71,96,129,173,231,308],
 [5,8,13,19,29,41,61,85,125,173,253,349,509],
 [5,8,15,26,37,52,67,86,105,128,151,178,205],
 [5,8,15,26,41,68,118,213,406],
 [5,8,15,26,44,81,148,277,519],[5,9,9],
 [5,9,11,15,17,21,23,27,29,33,35,39,41,45,47,51,53,57,59,
   63,65],[5,9,15,23,35,51,75,107,155,219,315,443],
 [5,10,16,26,38,58,82,122,170,250,346,506],[5,12,12],
 [5,12,15,18,21,24,29,36,45,58,73,93,117,146,184,231,290,
   364,458],
 [5,12,15,18,23,30,37,47,58,73,91,112,139,172,213,262,323,
   399,492],
 [5,12,15,18,23,30,37,48,61,78,101,130,169,220,287,376,493]
  ,[5,12,16,20,28,40,52,72,96,128,172,228,304,404],
 [5,12,19,30,41,56,71,90,109,132,155,182,209],
 [5,12,19,30,41,56,73,94,117,144,171,202,233],
 [5,12,19,30,43,60,77,98,119,144,169,198,227],
 [5,12,19,30,47,87,168,351,760],
 [5,12,19,33,64,134,276,580],
 [5,12,19,34,57,101,188,361,704],
 [5,12,19,34,59,100,184,369,774],
 [5,12,19,34,66,137,288,610],
 [5,12,19,35,63,118,208,375,668],
 [5,12,19,36,55,88,149,255,445],
 [5,12,19,36,63,117,207,372,664],
 [5,12,19,37,70,126,232,436],
 [5,12,22,40,68,120,216,384,720],
 [5,12,22,40,76,160,328,672],[5,12,22,44,84,152,288,536],
 [5,12,23,42,73,120,199,310,501],
 [5,12,23,42,73,120,199,325,563],
 [5,12,23,42,73,120,214,402],[5,12,23,42,73,127,229,402],
 [5,12,23,42,80,164,334,678],[5,12,23,45,87,157,290,526],
 [5,12,26,56,116,240,488],[6,6],[6,7,7],[6,7,8,8],
 [6,7,8,9,9],[6,7,8,9,10,10],
 [6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
   25,26,27,28,29,30,31,32,33,34,35,36,37,38],
 [6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
   25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
   43,44,45,46,47,48,49,50,51],
 [6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
   25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
   43,44,45,46,47,48,49,50,51,52],
 [6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
   25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
   43,44,45,46,47,48,49,50,51,52,53,54,55],
 [6,7,8,9,11,12,13,15,16,17,19,20,21,23,24,25,27,28,29,
   31,32,33,35,36,37,39,40,41,43,44,45,47,48,49,51,52,53,
   55,56,57,59,60,61,63,64,65],
 [6,7,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,
   33,35,36,38,39,41,42,44,45,47,48,50,51],
 [6,7,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,
   33,35,36,38,39,41,42,44,45,47,48,50,51,53],
 [6,7,8,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,
   41,43,45,47,49,51,53,55,57,59,61,63,65],
 [6,7,8,9,11,13,16,19,22,27,32,38,46,54,65,78,92,111,132,
   157,189,224,268,321,381,457],
 [6,7,8,9,11,13,16,20,25,31,38,47,58,72,89,110,136,168,
   208,257,318,393,486],
 [6,7,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,
   34,35,37,38,40,41,43,44,46,47,49,50,52],
 [6,7,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,
   34,35,37,38,40,41,43,44,46,47,49,50,52,53],
 [6,7,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,
   42,44,46,48,50,52,54,56,58,60,62,64,66],
 [6,7,8,10,12,15,18,23,28,36,44,57,70,91,112,146,180,235,
   290,379,468],
 [6,7,8,10,12,15,19,24,31,40,52,68,89,117,154,203,268,354,
   468],
 [6,7,8,10,12,16,20,26,32,42,52,68,84,110,136,178,220,288,
   356,466],
 [6,7,8,10,13,16,21,27,35,46,60,79,104,137,181,239,316,418 
  ],[6,7,9,9],[6,7,9,10,10],
 [6,7,9,10,11,13,14,15,17,18,19,21,22,23,25,26,27,29,30,
   31,33,34,35,37,38,39,41,42,43,45,46,47,49,50,51,53,54,
   55,57,58,59,61,62,63,65,66],
 [6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,
   34,36,37,39,40,42,43,45,46,48,49,51,52],
 [6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,
   34,36,37,39,40,42,43,45,46,48,49,51,52,54],
 [6,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45,47,49,51,53,55,57,59,61,63,65,67],
 [6,7,9,11,13,16,20,24,29,36,44,53,65,80,97,118,145,177,
   215,263,322,392,478],
 [6,7,9,11,14,17,21,26,32,40,49,61,75,93,115,142,176,217,
   269,332,411],
 [6,7,9,11,14,18,23,29,37,47,60,76,97,123,157,199,254,322,
   411],
 [6,7,9,11,14,18,23,30,39,51,67,88,116,153,202,267,353,467 
  ],[6,7,9,11,15,19,27,35,51,67,99,131,195,259,387,515],
 [6,7,9,12,16,22,30,42,58,82,114,162,226,322,450],
 [6,7,9,13,18,26,36,52,72,104,144,208,288,416],[6,8,8],
 [6,8,9,9],[6,8,9,10,10],
 [6,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
   26,27,28,29,30,31,32,33,34,35,36,37,38],
 [6,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
   26,27,28,29,30,31,32,33,34,35,36,37,38,39],
 [6,8,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,
   34,36,37,39,40,42,43,45,46,48,49,51],
 [6,8,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,
   34,36,37,39,40,42,43,45,46,48,49,51,52],
 [6,8,9,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,
   42,44,46,48,50,52,54,56,58,60,62,64],
 [6,8,9,10,12,14,17,20,25,30,37,44,54,64,79,94,116,138,
   170,202,249,296,365,434],
 [6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,
   35,36,38,39,41,42,44,45,47,48,50,51,53],
 [6,8,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,
   35,36,38,39,41,42,44,45,47,48,50,51,53,54],
 [6,8,10,10],
 [6,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,
   35,37,38,40,41,43,44,46,47,49,50,52],
 [6,8,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,
   35,37,38,40,41,43,44,46,47,49,50,52,53],
 [6,8,10,12,12],
 [6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40],
 [6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46],
 [6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48],
 [6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54],
 [6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64],
 [6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64,66],
 [6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64,66,68],
 [6,8,10,12,16,20,24,30,38,46,56,70,86,104,128,158,192,
   234,288,352,428],
 [6,8,10,14,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58,
   62],[6,8,10,14,16,20,22,26,28,32,34,38,40,44,46,50,
   52,56,58,62,64],
 [6,8,10,14,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58,
   62,64,68],
 [6,8,10,14,18,24,30,40,50,66,82,108,134,176,218,286,354,
   464],[6,8,10,14,18,24,32,42,56,74,98,130,172,228,302,
   400],[6,8,10,14,18,26,34,50,66,98,130,194,258,386,514]
  ,[6,8,10,14,20,26,36,48,64,86,114,152,202,268,356,472],
 [6,8,10,14,20,28,40,56,78,110,154,216,304,426],
 [6,8,10,14,22,34,54,86,138,222,358,578],
 [6,8,10,14,22,36,58,94,152,246,398,644],
 [6,8,11,13,16,19,21,24,27,29,32,35,37,40,43,45,48,51,53,
   56,59,61,64,67,69],
 [6,8,11,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56],
 [6,8,11,14,18,22,27,32,38,44,51,58,66,74,83,92,102,112,
   123,134,146,158,171,184,198,212,227,242],
 [6,8,11,14,18,22,27,32,38,44,51,58,66,74,83,92,102,112,
   123,134,146,158,171,184,198,212,227,242,258],
 [6,8,11,14,19,25,33,44,58,77,102,135,179,237,314,416],
 [6,8,11,15,21,29,41,57,81,113,161,225,321,449],
 [6,8,12,12],
 [6,8,12,14,18,20,24,26,30,32,36,38,42,44,48,50,54,56,60,
   62,66],
 [6,8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72],
 [6,8,12,16,22,30,40,54,72,96,128,170,226,300,398,528],
 [6,8,12,16,24,32,48,64,96,128,192,256,384,512],
 [6,8,12,16,24,36,52,76,112,164,240,352,516],
 [6,8,12,17,24,34,48,68,96,136,192,272,384,544],
 [6,8,12,18,26,38,54,78,110,158,222,318,446],
 [6,8,12,18,28,42,64,98,148,226,344,522],[6,9,9],
 [6,9,10,10],[6,9,10,11,11],
 [6,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37],
 [6,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49],
 [6,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51],[6,9,11,11],
 [6,9,11,12,12],
 [6,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,
   36,38,39,41,42,44,45,47,48,50],
 [6,9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,
   36,38,39,41,42,44,45,47,48,50,51],[6,9,11,13,13],
 [6,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45],[6,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,
   39,41,43,45,47,49,51,53,55,57,59,61],
 [6,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63],
 [6,9,11,15,17,21,23,27,29,33,35,39,41,45,47,51,53,57,59,
   63],[6,9,12,13,13],[6,9,12,14,14],
 [6,9,12,15,18,21,24,27,30,33,36,39,42,45],
 [6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57],
 [6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60]
  ,[6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,
   60,63],[6,9,12,16,20,25,30,36,42,49,56,64,72,81],
 [6,9,12,16,22,29,39,52,69,92,122,162,215,285,378],
 [6,9,12,17,21,26,30,35,39,44,48,53,57,62],
 [6,9,12,17,22,30,38,51,64,85,106,140,174,229,284],
 [6,9,12,17,23,31,42,56,75,100,133,177,235],
 [6,9,12,17,23,31,42,56,75,100,133,177,235,312],
 [6,9,13,13],[6,9,13,15,16,16],
 [6,9,13,15,19,21,25,27,31,33,37,39,43,45,49,51,55,57,61,
   63],[6,9,13,16,19,22,25,28,31,34,37,40,43,46,49,52,
   55,58,61,64],
 [6,9,13,17,21,25,29,33,37,41,45,49,53,57,61,65,69,73,77,
   81],[6,9,13,17,22,27,33,39,46,53,61,69,78,87],
 [6,9,13,18,22,27,31,36,40,45,49,54,58,63],
 [6,9,13,18,26,35,48,65,87,117,156,208,277,368],
 [6,9,13,18,26,38,55,80,117,171,250,366,536],
 [6,9,13,19,26,36,49,66,89,119,159,212,282],
 [6,9,13,19,29,42,64,94,141,210,312,467],
 [6,9,13,20,31,49,78,125,201,324,523],
 [6,9,14,18,23,27,32,36,41,45,50,54,59,63],
 [6,9,14,19,27,37,50,68,91,122,163,217,289,384],
 [6,9,14,20,30,42,62,86,126,174,254,350],
 [6,9,14,20,31,45,68,101,150,225,333,499],
 [6,9,14,22,35,56,90,145,234,378,611],
 [6,9,15,23,34,50,72,104,148,212,300,428],
 [6,9,15,23,37,59,95,153,247,399,645],
 [6,9,16,25,32,43,56,67,82,99,114,133,154,173,196,221,244],
 [6,9,16,25,32,43,56,69,86,105,124,145,168,191,216,243,270]
  ,[6,9,16,26,38,67,107,172,281,450],
 [6,9,16,26,42,81,121,192,352,602],
 [6,9,16,28,41,66,98,143,216,306,439],
 [6,9,16,28,41,66,98,143,229,346,534],
 [6,9,16,28,41,71,114,182,296,458],
 [6,9,16,28,42,67,99,145,218,308,442],
 [6,9,16,28,42,67,99,145,231,348,537],
 [6,9,16,28,42,72,115,184,298,461],
 [6,9,16,28,53,93,164,293,534],
 [6,9,16,28,53,93,164,293,549],
 [6,9,16,28,53,98,164,293,549],
 [6,9,16,29,51,97,186,367,700],
 [6,9,16,29,55,95,189,339,692],
 [6,9,16,29,56,102,200,394,744],
 [6,9,16,29,57,103,202,397,758],
 [6,9,16,29,58,98,195,381,756],[6,9,16,29,63,103,209,408]
  ,[6,9,16,29,64,104,211,411],[6,10,10],[6,10,11,11],
 [6,10,12,12],[6,10,12,13,13],
 [6,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40],
 [6,10,12,16,18,22,24,28,30,34,36,40,42,46,48,52,54,58,
   60,64,66],[6,10,13,14,14],[6,10,13,15,15],
 [6,10,13,16,19,22,25,28,31,34,37,40,43,46],
 [6,10,13,16,19,22,25,28,31,34,37,40,43,46,49,52],
 [6,10,14,14],[6,10,14,15,15],
 [6,10,14,18,22,26,30,34,38,42,46,50],
 [6,10,14,18,22,26,30,34,38,42,46,50,54,58],
 [6,10,14,18,22,26,30,34,38,42,46,50,54,58,62,66],
 [6,10,14,19,23,28,32,37,41,46,50,55,59],
 [6,10,14,19,23,28,32,37,41,46,50,55,59,64],
 [6,10,14,22,30,46,62,94,126,190,254,382,510],
 [6,10,14,22,38,62,102,166,270,438],
 [6,10,15,19,24,28,33,37,42,46,51,55,60,64],
 [6,10,15,20,25,30,35,40,45,50,55,60,65],
 [6,10,15,20,25,30,35,40,45,50,55,60,65,70],
 [6,10,15,21,30,41,56,76,102,137,183],
 [6,10,15,22,31,43,59,80,108,145,194,259],
 [6,10,16,24,34,48,66,90,122,164,220],
 [6,10,16,24,36,52,76,108,156,220,316],
 [6,10,16,24,36,52,76,108,156,220,316,444],
 [6,10,16,26,42,68,110,178,288,466],
 [6,10,18,30,50,82,134,218,354,574],[6,11,13,13],
 [6,11,15,20,24,29,33,38,42,47,51,56,60,65],
 [6,11,16,21,26,31,36,41,46,51,56],
 [6,11,16,21,26,31,36,41,46,51,56,61],
 [6,11,18,27,39,55,76,104,141,190],
 [6,11,18,28,42,62,90,130,186],
 [6,11,20,29,42,55,72,89,110,131,156,181,210],
 [6,11,20,29,42,55,72,91,114,139,168,199,232],
 [6,11,20,29,42,57,76,97,120,145,172,201],
 [6,11,20,29,42,57,76,97,120,145,172,201,232],
 [6,11,20,29,55,106,233,459],
 [6,11,20,30,43,57,74,92,113,135,160,186],
 [6,11,20,30,43,57,74,92,113,135,160,186,215],
 [6,11,20,31,44,59,76,95,116,139,164,191],
 [6,11,20,31,44,59,76,95,116,139,164,191,220],
 [6,11,20,32,52,93,169,302,537],
 [6,11,20,33,54,83,130,213,363,619],
 [6,11,20,33,54,95,171,303,538],
 [6,11,20,34,47,69,86,116,137,175,200,246],
 [6,11,20,34,57,94,154,251,408],
 [6,11,20,35,56,99,177,311,562],
 [6,11,20,36,66,119,213,380,675],
 [6,11,20,36,66,127,251,511],[6,11,20,36,79,140,304,591],
 [6,11,20,37,67,129,254,515],[6,11,20,37,80,142,307,596],
 [6,11,20,41,71,133,240,424],[6,11,23,37,77,129,265,449],
 [6,11,23,41,93,153,329,625],
 [6,11,24,39,74,113,200,295,533],
 [6,11,24,39,74,113,215,341,658],
 [6,11,24,39,81,135,276,449],
 [6,11,24,40,75,115,202,298,536],
 [6,11,24,40,75,115,217,344,661],
 [6,11,24,40,82,137,278,453],[6,11,24,51,107,233,494],
 [6,11,24,51,107,233,511],[6,11,24,51,114,233,511],
 [6,11,25,34,56,69,99,116,154,175,221,246],
 [6,11,25,34,56,71,103,126,166,193,241,272],
 [6,11,26,41,80,134,290,524],[6,11,26,48,116,208,488],
 [6,12,20,30,42,56,72,90,110,132,156,182,210],
 [6,12,20,30,44,60,78,98,120,144,170,198],
 [6,12,20,32,48,72,104,152,216,312,440],
 [6,12,20,36,54,88,130,200,310,485],
 [6,12,20,36,54,88,142,229,376,610],
 [6,12,20,36,60,103,171,282,470],
 [6,12,21,37,50,74,91,123,144,184,209,257],
 [6,12,23,42,68,121,216,395,716],
 [6,12,23,45,86,163,303,544],
 [6,12,25,39,71,112,204,314,565],
 [6,12,25,40,71,99,156,201,292,358,491],
 [6,12,26,36,58,72,102,120,158,180,226,252],
 [6,12,26,51,102,206,411],[6,12,26,51,117,278,691],
 [6,12,26,53,101,190,349,634],[6,12,26,54,111,228,501],
 [6,12,26,54,119,254,571],[6,12,29,62,142,313,710],
 [6,12,29,62,152,339,788],[6,12,29,62,152,355,846],
 [6,13,20,36,60,103,169,284,487],
 [6,13,22,38,51,75,92,124,145,185,210,258],
 [6,13,28,55,109,219,438],[6,13,28,59,121,247,512],
 [6,13,28,59,134,290,683],[6,13,28,63,149,345,829],
 [6,13,28,63,156,350,823],[6,13,32,69,155,337,726],
 [6,13,32,69,155,337,751],[6,13,32,69,164,337,751],
 [7,7],[7,8,8],[7,9,9],[7,12,12],
 [7,12,15,18,21,26,33,42,53,67,85,107,134,168,212,266,334,
   419],[7,12,15,20,25,32,40,50,63,78,97,120,149,184,227,
   280,346,426],
 [7,12,15,20,25,32,41,52,67,86,111,144,187,244,319,418],
 [7,12,16,24,32,44,60,80,108,144,192,256,340,452],
 [7,12,21,30,43,56,73,90,111,132,157,182,211],
 [7,12,21,30,43,58,77,98,121,146,173,202,233],
 [7,12,21,32,45,60,77,96,117,140,165,192,221],
 [7,12,21,36,57,100,178,312,563],
 [7,12,21,36,65,119,248,519],[7,12,21,42,72,134,241,425],
 [7,12,21,43,73,136,244,429],[7,12,21,43,94,186,412],
 [7,12,26,48,116,208,488],[7,12,27,42,81,135,291,525],
 [7,12,27,49,117,209,489],[8,8],[8,9,9],[8,9,10,10],
 [8,9,10,11,11],
 [8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51],
 [8,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51],
 [8,9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51,52],[8,10,10],
 [8,10,12,12],[8,10,12,14,14],
 [8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48],
 [8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64],
 [8,10,12,14,18,20,24,26,30,32,36,38,42,44,48,50,54,56,
   60,62,66],
 [8,10,12,16,18,22,24,28,30,34,36,40,42,46,48,52,54,58,
   60,64,66],
 [8,10,12,16,20,26,34,44,58,76,100,132,174,230,304,402],
 [8,10,14,14],
 [8,10,14,16,18,22,24,26,30,32,34,38,40,42,46,48,50,54,
   56,58,62,64,66,70,72,74,78,80],
 [8,10,14,16,18,22,24,26,30,32,34,38,40,42,46,48,50,54,
   56,58,62,64,66,70,72,74,78,80,82],
 [8,10,14,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58,
   62,64,68],
 [8,10,14,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74,
   78,82,86],
 [8,10,14,18,26,34,50,66,98,130,194,258,386,514],
 [8,11,11],[8,11,14,15,16,16],
 [8,11,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,
   46,48],
 [8,11,14,18,22,29,36,47,58,76,94,123,152,199,246,322],
 [8,11,14,19,24,31,38,47,56,67,78,91,104],
 [8,11,18,27,34,45,58,69,84,101,116,135,156,175,198,223,246 
  ],[8,12,12],
 [8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,
   80,84,88],
 [8,12,16,22,32,42,58,76,104,136,186,242,330,428],
 [8,12,16,22,32,44,62,82,114,152,210,276,380,502],
 [8,13,13],
 [8,13,16,19,22,27,34,43,54,68,86,108,135,169,213,267,335,
   420],[8,13,16,21,26,33,41,51,64,79,98,121,150,185,228,
   281,347,427],
 [8,13,16,21,26,33,42,53,68,87,112,145,188,245,320,419],
 [8,13,17,25,33,45,61,81,109,145,193,257,341,453],
 [8,13,18,28,38,53,73,98,133,178,238,318],
 [8,13,20,29,42,57,74,93,114,137,162,189,218],
 [8,13,20,33,56,89,163,294,589],
 [8,13,20,33,61,106,209,372,730],
 [8,13,21,30,46,63,95,133,197,270,398,548],
 [8,13,21,30,46,68,100,146,210,304,432],
 [8,13,22,31,44,57,74,91,112,133,158,183,212],
 [8,13,22,31,44,59,78,99,122,147,174,203,234],
 [8,13,22,33,46,61,78,97,118,141,166,193,222],
 [8,13,22,33,59,112,239,482],
 [8,13,22,37,58,101,179,313,564],
 [8,13,22,37,66,120,249,520],[8,13,22,43,73,135,242,426],
 [8,13,22,44,74,137,245,430],[8,13,22,44,95,187,413],
 [8,13,25,44,84,150,286,522],
 [8,13,26,41,76,115,202,297,535],
 [8,13,26,41,76,115,217,343,660],
 [8,13,26,41,83,137,278,451],
 [8,13,27,36,58,71,101,118,156,177,223,248],
 [8,13,27,37,59,73,103,121,159,181,227,253],
 [8,13,27,49,117,209,489],[8,13,28,43,82,136,292,526],
 [8,13,28,50,118,210,490],[8,14,14],
 [8,14,17,21,24,28,31,35,38,42,45,49,52,56,59,63,66,70,
   73,77,80,84,87,91,94,98,101,105,108],
 [8,14,23,33,46,60,77,95,116,138,163,189,218],
 [8,14,23,39,52,76,93,125,146,186,211,259],[8,15,15],
 [8,15,17,17],[8,15,17,19,21,22,23,24,24],
 [8,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,
   85,87,89,91,93,95],
 [8,15,18,21,26,33,40,50,61,76,94,115,142,175,216,265,326,
   402],
 [8,15,18,21,26,33,40,51,64,81,104,133,172,223,290,379,496]
  ,[8,15,19,25,29,35,39,45,49,55,59,65,69,75,79,85,89,
   95,99],
 [8,15,20,23,28,31,36,39,44,47,52,55,60,63,68,71,76,79,
   84,87,92,95,100,103,108,111,116,119],
 [8,15,20,23,28,31,36,39,44,47,52,55,60,63,68,71,76,79,
   84,87,92,95,100,103,108,111,116,119,124],
 [8,15,22,31,40,51,62,75,88,103,118,135,152],
 [8,15,22,34,46,65,84,115,146,196,246,327],
 [8,15,24,35,48,63,80,99,120,143,168,195,224],
 [8,15,24,37,56,75,102,127,162,193,236,273],
 [8,15,24,39,73,144,301,634],
 [8,15,24,40,53,77,94,126,147,187,212,260],
 [8,15,24,40,60,97,160,273,464],
 [8,15,24,40,75,134,237,429],
 [8,15,24,44,74,123,198,335,540],
 [8,15,24,44,80,135,230,385,644],
 [8,15,24,48,87,154,283,497],[8,15,27,52,100,182,334,626],
 [8,15,29,58,126,252,532],
 [8,18,24,32,44,58,75,96,121,152,191,239,296,367,454],
 [8,18,24,32,44,58,76,100,130,170,222,290,380,498],
 [8,18,26,36,48,63,81,103,130,164,205,255,317,392],
 [8,18,26,36,48,64,84,110,144,188,246,322,422],
 [8,18,27,45,58,84,101,135,156,198,223,273],
 [8,18,32,50,72,98,128,162,200,242],
 [8,18,32,52,78,106,140,176,218,262],
 [8,18,32,52,78,108,142,180,222],
 [8,18,32,52,78,108,142,180,222,268],
 [8,18,32,55,96,190,399,910],[8,18,32,58,112,232,534],
 [8,18,32,58,121,260,596],[8,18,32,58,122,276,676],
 [8,18,32,58,132,304,730],[8,18,32,60,126,282,690],
 [8,18,32,65,152,344,791],[8,18,32,66,125,237,442],
 [8,18,32,68,168,376,875],[8,18,32,70,170,394,956],
 [8,18,32,72,176,412],[8,18,34,54,78,106,138,174,214],
 [8,18,34,54,78,106,138,174,214,258],
 [8,18,35,65,111,203,357,663],[8,18,35,65,126,245,440],
 [8,18,35,70,125,245,530],[8,18,35,71,135,255,479],
 [8,18,35,82,197,445],[8,18,36,77,143,276,511],
 [8,18,37,65,117,211,439],[8,18,37,75,173,337,757],
 [8,18,37,79,146,281,518],[8,18,38,74,140,284,614],
 [8,18,38,76,174,406],[8,18,38,82,182,365,747],
 [8,18,40,70,146,283,615],[8,18,40,77,175,357,791],
 [8,18,40,80,156,336,748],[8,18,40,80,185,367,813],
 [8,18,40,96,234,546],[8,18,43,97,225,461],
 [8,18,46,97,218,440],[8,21,43,85,147,259,417],
 [8,21,43,85,147,281,515],[8,21,43,85,169,377,765],
 [8,21,43,95,193,391,743],[8,21,45,99,231,467],
 [8,21,53,119,263,555],[9,9],[9,10,10],[9,10,11,11],
 [9,10,11,12,12],[9,10,11,12,13,13],
 [9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38],
 [9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38,39],
 [9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38,39,40],
 [9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51],
 [9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52],
 [9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53],
 [9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
   27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55,56,57,58],
 [9,10,11,12,13,14,15,17,18,19,20,21,23,24,25,26,27,29,
   30,31,32,33,35,36,37,38,39,41,42,43,44,45,47,48,49,50,
   51,53,54,55,56,57,59,60,61,62,63,65,66,67],
 [9,10,11,12,13,15,15],[9,10,11,12,14,14],
 [9,10,11,12,14,15,16,17,19,20,21,22,24,25,26,27,29,30,
   31,32,34,35,36,37,39,40,41,42,44,45,46,47,49,50,51,52,
   54,55,56,57,59,60,61,62,64,65,66,67,69,70],
 [9,10,11,12,14,15,16,18,19,20,22,23,24,26,27,28,30,31,
   32,34,35,36,38,39,40,42,43,44,46,47,48,50,51,52,54,55,
   56,58,59,60,62,63,64,66],
 [9,10,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,
   35,36,38,39,41,42,44,45,47,48,50,51,53],
 [9,10,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,
   35,36,38,39,41,42,44,45,47,48,50,51,53,54],
 [9,10,11,12,14,16,17,18,20,22,23,24,26,28,29,30,32,34,
   35,36,38,40,41,42,44,46,47,48,50,52,53,54,56,58,59,60,
   62,64,65,66,68,70,71,72,74,76,77,78,80,82],
 [9,10,11,12,14,16,17,19,21,22,24,26,27,29,31,32,34,36,
   37,39,41,42,44,46,47,49,51,52,54,56,57,59,61,62,64,66,
   67,69,71,72,74,76],
 [9,10,11,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,
   42,44,46,48,50,52,54,56,58,60,62,64,66],
 [9,10,11,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,
   42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,
   78,80,82,84,86,88],
 [9,10,11,12,14,16,20,22,26,28,32,34,38,40,44,46,50,52,
   56,58,62,64,68,70,74,76,80,82,86,88],
 [9,10,11,13,14,14],
 [9,10,11,13,14,15,16,17,19,20,21,22,23,25,26,27,28,29,
   31,32,33,34,35,37,38,39,40,41,43,44,45,46,47,49,50,51,
   52,53,55,56,57,58,59,61,62,63,64,65,67,68],
 [9,10,11,13,14,15,16,18,19,20,21,23,24,25,26,28,29,30,
   31,33,34,35,36,38,39,40,41,43,44,45,46,48,49,50,51,53,
   54,55,56,58,59,60,61,63,64,65,66,68,69,70],
 [9,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,
   35,37,38,40,41,43,44,46,47,49,50,52],
 [9,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,
   35,37,38,40,41,43,44,46,47,49,50,52,53],
 [9,10,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,
   35,37,38,40,41,43,44,46,47,49,50,52,53,55],
 [9,10,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45,47,49,51,53,55,57,59,61,63,65,67],
 [9,10,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,
   79,81,83,85,87,89],
 [9,10,11,13,15,18,20,23,25,28,30,33,35,38,40,43,45,48,
   50,53,55,58,60,63,65,68,70,73,75,78],
 [9,10,11,13,15,18,21,24,27,30,33,36,39,42,45,48,51,54,
   57,60,63,66,69,72,75,78,81,84,87,90],
 [9,10,11,13,15,19,21,25,27,31,33,37,39,43,45,49,51,55,
   57,61,63,67,69,73,75,79,81,85,87,91],
 [9,10,11,13,15,19,23,30,36,47,57,75,91,120,146,193,235,
   311,379,502],[9,10,12,12],[9,10,12,13,13],
 [9,10,12,13,14,15,15],
 [9,10,12,13,14,15,17,18,19,20,22,23,24,25,27,28,29,30,
   32,33,34,35,37,38,39,40,42,43,44,45,47,48,49,50,52,53,
   54,55,57,58,59,60,62,63,64,65,67,68,69,70],
 [9,10,12,13,14,16,17,18,20,21,22,24,25,26,28,29,30,32,
   33,34,36,37,38,40,41,42,44,45,46,48,49,50,52,53,54,56,
   57,58,60,61,62,64,65],
 [9,10,12,13,14,16,17,18,20,21,22,24,25,26,28,29,30,32,
   33,34,36,37,38,40,41,42,44,45,46,48,49,50,52,53,54,56,
   57,58,60,61,62,64,65,66],
 [9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51,52],
 [9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51,52,54],
 [9,10,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51,52,54,55],
 [9,10,12,13,15,17,18,20,22,23,25,27,28,30,32,33,35,37,
   38,40,42,43,45,47,48,50,52,53,55,57,58,60,62,63,65,67,
   68,70,72,73,75,77,78],
 [9,10,12,14,15,17,19,20,22,24,25,27,29,30,32,34,35,37,
   39,40,42,44,45,47,49,50,52,54,55,57,59,60,62,64,65,67,
   69,70,72,74,75,77,79],
 [9,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64,66],
 [9,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64,66,68],
 [9,10,12,14,17,19,22,24,27,29,32,34,37,39,42,44,47,49,
   52,54,57,59,62,64,67,69,72,74,77,79,82],
 [9,10,12,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56,
   59,62,65,68,71,74,77,80,83,86,89,92],
 [9,10,12,14,17,20,24,29,35,42,51,62,75,91,111,135,164,
   200,244,297,362,442],
 [9,10,12,14,17,21,26,33,42,54,70,91,119,156,205,270,356,
   470],
 [9,10,12,14,18,21,26,31,38,47,57,71,86,107,131,162,200,
   246,305,375,465],
 [9,10,12,15,17,20,22,25,27,30,32,35,37,40,42,45,47,50,
   52,55,57,60,62,65,67,70,72,75,77,80,82],
 [9,10,12,15,18,22,27,34,42,53,66,84,105,134,168,215,270,
   346,435],
 [9,10,12,16,22,30,42,58,82,114,162,226,322,450],
 [9,11,11],[9,11,12,12],[9,11,12,13,13],
 [9,11,12,13,14,14],[9,11,12,13,14,15,15],
 [9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
   28,29,30,31,32,33,34,35,36,37,38,39,40],
 [9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
   28,29,30,31,32,33,34,35,36,37,38,39,40,41],
 [9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
   28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,
   46,47,48,49,50,51,52],
 [9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
   28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,
   46,47,48,49,50,51,52,53],
 [9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
   28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,
   46,47,48,49,50,51,52,53,54,55,56,57,58,59],
 [9,11,12,13,14,16,17,18,19,21,22,23,24,26,27,28,29,31,
   32,33,34,36,37,38,39,41,42,43,44,46,47,48,49,51,52,53,
   54,56,57,58,59,61,62,63,64,66,67,68,69,71],
 [9,11,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51,52],
 [9,11,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,
   36,37,39,40,42,43,45,46,48,49,51,52,54],
 [9,11,12,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45,47,49,51,53,55,57,59,61,63,65],
 [9,11,12,13,15,17,20,22,25,27,30,32,35,37,40,42,45,47,
   50,52,55,57,60,62,65,67,70,72,75],[9,11,12,14,15,15],
 [9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,
   36,38,39,41,42,44,45,47,48,50,51,53],
 [9,11,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,
   36,38,39,41,42,44,45,47,48,50,51,53,54],[9,11,13,13],
 [9,11,13,14,14],[9,11,13,14,15,15],
 [9,11,13,14,15,16,16],
 [9,11,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41],
 [9,11,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41,42],
 [9,11,13,14,16,17,18,19,21,22,23,24,26,27,28,29,31,32,
   33,34,36,37,38,39,41,42,43,44,46,47,48,49,51,52,53,54,
   56,57,58,59,61,62,63,64,66,67,68,69,71,72],
 [9,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,35,
   37,38,40,41,43,44,46,47,49,50,52],
 [9,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,35,
   37,38,40,41,43,44,46,47,49,50,52,53],
 [9,11,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,35,
   37,38,40,41,43,44,46,47,49,50,52,53,55],
 [9,11,13,14,16,18,19,20,22,24,25,26,28,30,31,32,34,36,
   37,38,40,42,43,44,46,48,49,50,52,54,55,56,58,60,61,62,
   64,66,67,68,70,72,73,74,76,78,79,80,82,84],
 [9,11,13,14,16,18,19,21,23,24,26,28,29,31,33,34,36,38,
   39,41,43,44,46,48,49,51,53,54,56,58,59,61,63,64,66,68,
   69,71,73,74,76,78],
 [9,11,13,14,16,18,19,21,23,24,26,28,29,31,33,34,36,38,
   39,41,43,44,46,48,49,51,53,54,56,58,59,61,63,64,66,68,
   69,71,73,74,76,78,79],
 [9,11,13,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64],
 [9,11,13,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,
   80,82,84,86,88,90],[9,11,13,15,15],
 [9,11,13,15,16,17,17],
 [9,11,13,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
   30,31,32,33,34,35,36,37,38,39,40,41,42],
 [9,11,13,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
   30,31,32,33,34,35,36,37,38,39,40,41,42,43],
 [9,11,13,15,17,17],
 [9,11,13,15,17,18,20,22,23,25,27,28,30,32,33,35,37,38,
   40,42,43,45,47,48,50,52,53,55,57,58,60,62,63,65,67,68,
   70,72,73,75,77,78],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63,65],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63,65,67],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63,65,67,69],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79]
  ,[9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,
   43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,
   79,81],
 [9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,
   81,83,85,87,89,91,93,95,97,99,101,103,105,107],
 [9,11,13,15,18,19,21,24,25,27,30,31,33,36,37,39,42,43,
   45,48,49,51,54,55,57,60,61,63,66,67,69,72,73,75,78,79,
   81,84,85,87,90,91],
 [9,11,13,15,18,20,23,25,27,30,32,35,37,39,42,44,47,49,
   51,54,56,59,61,63,66,68,71,73,75,78,80,83,85,87,90,92]
  ,[9,11,13,15,18,20,23,25,28,30,33,35,38,40,43,45,48,
   50,53,55,58,60,63,65,68,70,73,75,78,80,83],
 [9,11,13,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,
   60,63,66,69,72,75,78,81,84,87,90,93],
 [9,11,13,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,
   60,63,66,69,72,75,78,81,84,87,90,93,96],
 [9,11,13,15,18,22,25,28,32,35,38,42,45,48,52,55,58,62,
   65,68,72,75,78,82,85,88,92,95,98,102,105,108,112,115,
   118,122,125,128],
 [9,11,13,15,18,22,25,28,32,35,38,42,45,48,52,55,58,62,
   65,68,72,75,78,82,85,88,92,95,98,102,105,108,112,115,
   118,122,125,128,132],
 [9,11,13,15,19,21,23,27,29,31,35,37,39,43,45,47,51,53,
   55,59,61,63,67],
 [9,11,13,15,19,21,25,27,31,33,37,39,43,45,49,51,55],
 [9,11,13,15,19,21,25,27,31,33,37,39,43,45,49,51,55,57,
   61,63,67,69,73,75,79,81,85,87,91,93,97],
 [9,11,13,15,19,23,27,33,41,49,59,73,89,107,131,161,195,
   237,291,355],
 [9,11,13,15,19,25,31,41,53,69,91,119,157,207,273,361,477],
 [9,11,13,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,
   46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,
   82,84,86,88,90,92],
 [9,11,13,16,18,21,23,26,28,31,33,36,38,41,43,46,48,51,
   53,56,58,61,63,66,68,71,73,76,78,81],
 [9,11,13,16,18,21,23,26,28,31,33,36,38,41,43,46,48,51,
   53,56,58,61,63,66,68,71,73,76,78,81,83],
 [9,11,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,
   61,64,67,70,73,76,79,82,85,88,91,94],
 [9,11,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,
   61,64,67,70,73,76,79,82,85,88,91,94,97],
 [9,11,13,16,19,22,26,30,34,39,44,49,55,61,67,74,81,88,
   96,104,112,121,130,139,149,159,169,180,191,202,214,226,
   238,251,264,277,291],
 [9,11,13,16,19,23,28,34,42,51,63,77,95,117,144,178,219,
   271,334,413],
 [9,11,13,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,
   76,80,84,88,92,96,100,104,108,112,116],
 [9,11,13,16,20,25,31,38,47,58,72,89,110,136,168,208,257,
   318,393,486],
 [9,11,13,16,21,26,34,43,57,73,98,126,170,219,296,382,517],
 [9,11,13,16,21,29,39,54,75,105,147,207,291,411],
 [9,11,13,17,19,23,25,29,31,35,37,41,43,47,49,53,55],
 [9,11,13,17,19,23,25,29,31,35,37,41,43,47,49,53,55,59,
   61,65],
 [9,11,13,17,20,25,30,36,43,50,59,67,78,87,100,110,125,
   136,153,165,184,197,218,232,255,270,295],
 [9,11,13,17,21,25,29,33,37,41,45,49,53,57,61,65,69],
 [9,11,13,17,21,27,33,43,53,69,85,111,137,179,221,289],
 [9,11,13,17,21,27,35,45,59,77,101,133,175,231,305,403],
 [9,11,13,17,21,29,37,53,69,101,133,197,261,389,517],
 [9,11,13,17,23,29,39,51,67,89,117,155,205,271,359,475],
 [9,11,13,17,25,41,65,105,169,273,441],[9,11,14,14],
 [9,11,14,15,15],[9,11,14,15,16,16],
 [9,11,14,15,16,18,18],
 [9,11,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,
   38,39,41,42,44,45,47,48,50,51,53],
 [9,11,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,
   38,39,41,42,44,45,47,48,50,51,53,54],
 [9,11,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,
   38,39,41,42,44,45,47,48,50,51,53,54,56],
 [9,11,14,16,17,17],[9,11,14,16,17,18,18],
 [9,11,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,
   46,48,50,52,54,56,58,60,62,64,66],
 [9,11,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,
   46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,
   82,84,86,88,90,92],
 [9,11,14,16,18,21,23,25,28,30,32,35,37,39,42,44,46,49,
   51,53,56,58,60,63,65,67,70,72,74,77,79,81,84,86,88,91,
   93,95,98,100,102],
 [9,11,14,16,19,21,23,26,28,31,33,35,38,40,43,45,47,50,
   52,55,57,59,62,64,67,69,71,74,76,79,81,83,86,88,91,93]
  ,[9,11,14,16,19,21,24,26,29,31,34,36,39,41,44,46,49,
   51,54,56,59,61,64,66,69,71,74,76,79,81],
 [9,11,14,16,19,22,24,27,30,32,35,38,40,43,46,48,51,54,
   56,59,62,64,67],
 [9,11,14,16,19,22,24,27,30,32,35,38,40,43,46,48,51,54,
   56,59,62,64,67,70],
 [9,11,14,16,20,22,26,28,32,34,38,40,44,46,50,52,56],
 [9,11,14,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,
   76,80,84,88,92,96,100,104,108,112],
 [9,11,14,16,20,24,30,38,46,58,70,88,108,134,166,204,254,
   312,388,478],
 [9,11,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,
   47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,
   83,85,87,89],
 [9,11,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56],
 [9,11,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,
   62,65,68,71,74,77,80,83,86,89,92,95],
 [9,11,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,
   62,65,68,71,74,77,80,83,86,89,92,95,98],
 [9,11,14,17,21,25,29,33,37,41,45,49,53,57,61,65,69],
 [9,11,14,17,21,26,31,38,46,55,67,80,96,116,138,166,199,
   237,285,340,406],
 [9,11,14,17,21,27,34,43,54,69,87,111,140,179,226,289,365,
   467],[9,11,14,17,22,28,35,45,55,70,86,108,134,166,207,
   255],
 [9,11,14,17,22,28,36,47,61,80,105,138,182,240,317,419],
 [9,11,14,18,21,25,30,34,39,45,50,56,63,69,76,84,91,99,
   108,116,125,135,144,154,165,175,186,198,209,221,234,246,
   259,273,286,300,315],
 [9,11,14,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74,
   78,82,86,90,94,98,102,106,110,114],
 [9,11,14,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74,
   78,82,86,90,94,98,102,106,110,114,118],
 [9,11,14,18,22,27,32,39,45,54,61,72,80,93,102,117,127,
   144,155,174,186,207,220,243,257,282,297],
 [9,11,14,18,23,28,35,41,50,57,68,76,89,98,113,123,140,
   151,170,182,203,216,239,253,278],
 [9,11,14,18,23,28,35,41,50,57,68,76,89,98,113,123,140,
   151,170,182,203,216,239,253,278,293],
 [9,11,14,18,23,29,37,47,60,76,97,123,157,199,254,322],
 [9,11,14,18,24,32,42,56,74,98,130,172,228,302,400],
 [9,11,14,19,25,33,44,58,77,102,135,179,237,314,416],
 [9,11,14,19,29,44,70,109,177,279,457],[9,11,15,15],
 [9,11,15,17,17],
 [9,11,15,17,19,21,25,27,29,31,35,37,39,41,45,47,49,51,
   55,57,59,61,65,67,69,71,75,77,79,81,85,87,89,91,95],
 [9,11,15,17,19,23,25,27,31,33,35,39,41,43,47,49,51,55,
   57,59,63,65,67],
 [9,11,15,17,21,23,27,29,33,35,39,41,45,47,51,53,57],
 [9,11,15,17,21,23,27,29,33,35,39,41,45,47,51,53,57,59,
   63,65,69,71,75,77,81,83,87,89,93],
 [9,11,15,17,21,23,27,29,33,35,39,41,45,47,51,53,57,59,
   63,65,69,71,75,77,81,83,87,89,93,95],
 [9,11,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84,87,90,93,96],
 [9,11,15,18,24,28,36,41,51,57,69,76,90,98,114,123,141,
   151,171,182,204,216,240,253,279,293,321],
 [9,11,15,19,21,25,29,31,35,39,41,45,49,51,55,59,61,65,
   69,71,75,79,81],
 [9,11,15,19,21,25,29,31,35,39,41,45,49,51,55,59,61,65,
   69,71,75,79,81,85,89,91,95],
 [9,11,15,19,23,27,31,35,39,43,47,51,55,59,63,67,71],
 [9,11,15,19,23,27,31,35,39,43,47,51,55,59,63,67,71,75,
   79,83,87,91,95,99,103,107,111,115],
 [9,11,15,19,25,29,35,39,45,49,55,59,65,69,75,79,85],
 [9,11,15,19,25,33,43,57,75,99,131,173,229,303,401],
 [9,11,15,19,27,35,47,63,83,111,147,195,259,343,455],
 [9,11,15,20,26,34,45,59,78,103,136,180,238,315,417],
 [9,11,15,21,27,37,49,65,87,115,153,203,269,357,473],
 [9,11,15,21,29,41,57,81,113,161,225,321,449],[9,12,12],
 [9,12,13,13],[9,12,13,14,14],[9,12,13,14,15,15],
 [9,12,13,14,15,16,17,18,18],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48,49],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48,49,50,51],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48,49,50,51,52],
 [9,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
   29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48,49,50,51,52,53,54],
 [9,12,13,14,16,17,18,20,21,22,24,25,26,28,29,30,32,33,
   34,36,37,38,40,41,42,44,45,46,48,49,50,52,53,54,56,57,
   58,60,61,62,64],
 [9,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,36,
   37,39,40,42,43,45,46,48,49],
 [9,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,36,
   37,39,40,42,43,45,46,48,49,51],
 [9,12,13,15,16,18,19,21,22,24,25,27,28,30,31,33,34,36,
   37,39,40,42,43,45,46,48,49,51,52,54],[9,12,14,14],
 [9,12,14,15,15],[9,12,14,15,16,16],
 [9,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,
   38,39,41,42,44,45,47,48,50],
 [9,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,
   38,39,41,42,44,45,47,48,50,51],
 [9,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,
   38,39,41,42,44,45,47,48,50,51,53],
 [9,12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,
   38,39,41,42,44,45,47,48,50,51,53,54],[9,12,14,16,16],
 [9,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42],
 [9,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46 
  ],[9,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,
   44,46,48,50,52,54,56,58,60],
 [9,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,
   46,48,50,52,54,56,58,60,62],
 [9,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,
   46,48,50,52,54,56,58,60,62,64,66,68],
 [9,12,14,16,19,21,24,26,29,31,34,36,39,41,44,46,49,51,
   54,56,59,61,64,66,69,71,74,76,79,81],
 [9,12,14,16,20,22,24,28,30,32,36,38,40,44,46,48,52,54,
   56,60,62,64,68,70,72,76,78,80,84,86,88,92,94,96,100,
   102,104,108,110],
 [9,12,14,16,20,26,30,36,46,56,66,82,102,122,148,184,224,
   270,332,408],
 [9,12,14,17,19,22,24,27,29,32,34,37,39,42,44,47,49,52,
   54,57,59,62,64,67,69,72,74,77,79,82],
 [9,12,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56],
 [9,12,14,17,20,24,28,32,37,42,48,53,60,66,74,80,89,96,
   106,113,124,132,144,152,165,174,188,197],
 [9,12,14,17,21,25,30,37,44,54,65,79,95,116,139,170,204,
   249,299,365,438],
 [9,12,14,17,21,26,32,39,48,59,73,90,111,137,169,209],
 [9,12,14,18,20,24,26,30,32,36,38,42,44,48,50,54,56],
 [9,12,14,18,20,24,26,30,32,36,38,42,44,48,50,54,56,60,62 
  ],[9,12,14,18,22,28,34,44,54,70,86,112,138,180,222,290,
   358],[9,12,14,18,22,30,36,48,58,78,94,126,152,204,246,
   330],[9,12,15,15],[9,12,15,16,16],
 [9,12,15,16,17,17],[9,12,15,16,17,18,18],
 [9,12,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40],
 [9,12,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41],
 [9,12,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42,43],
 [9,12,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42,43,44],
 [9,12,15,17,18,18],[9,12,15,17,19,19],
 [9,12,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43],
 [9,12,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,
   47,49,51,53,55,57,59,61,63,65,67],
 [9,12,15,17,20,22,25,27,30,32,35,37,40,42,45,47,50,52,
   55,57,60,62,65,67,70,72,75,77,80],[9,12,15,18,19,19],
 [9,12,15,18,20,22,22],[9,12,15,18,21,22,22],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63 
  ],[9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,
   60,63,66,69],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84,87],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84,87,90,93,96],
 [9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84,87,90,93,96,99],
 [9,12,15,18,21,25,31,39,49,61,78,98,124,154,196,245,309,
   384,488],
 [9,12,15,18,21,25,31,39,51,64,82,102,129,160,203,252,321,
   399,508],
 [9,12,15,18,23,30,38,48,61,78,99,126,160,204,259,330,419],
 [9,12,15,19,22,26,29,33,36,40,43,47,50,54,57,61,64,68,
   71,75,78,82,85,89,92,96,99,103,106],
 [9,12,15,19,23,27,31,35,39,43,47,51,55,59,63,67,71],
 [9,12,15,19,23,27,31,36,41,46,51,57,63,69,75,82,89,96,
   103,111,119,127,135],
 [9,12,15,19,23,28,33,39,45,52,59,67,75],
 [9,12,15,19,23,28,33,39,45,52,59,67,75,84,93,103,113,124,
   135,147,159,172,185,199,213,228,243],
 [9,12,15,19,23,28,33,39,45,52,59,67,75,84,93,103,113,124,
   135,147,159,172,185,199,213,228,243,259],
 [9,12,15,19,23,29,37,47,61,79,103,135,177,233,307,405],
 [9,12,15,19,24,30,37,45,55,67,82,100,122,149,182,223,273,
   335,411],
 [9,12,15,19,24,30,38,49,61,77,95,119,148,184,229],
 [9,12,15,19,24,32,43,59,81,113,157,221,309,437],
 [9,12,15,19,25,30,37,43,51,58,67,75,85,94],
 [9,12,15,19,25,30,38,44,54,61,73,81,95,104,120,130,148,
   159,179,191,213,226,250,264,290,305,333],
 [9,12,15,19,25,31,39,48,61,75,94,115,145,177,221,269,337,
   410],[9,12,15,19,25,31,40,49,62,76,96,117,147,179,225,
   273,342,415],
 [9,12,15,19,25,32,40,53,67,86,112,144,184,241],
 [9,12,15,19,25,32,42,53,70,90,120,154,207,269,364,473],
 [9,12,15,20,23,29,32,38,41,47,50,56,59,65,68,74,77,83],
 [9,12,15,20,25,31,38,45,54,62,73,82,95,105,120,131,148,
   160,179,192,213,227,250,265,290,306],
 [9,12,15,20,25,33,41,52,65,81,102,126,158,195,243],
 [9,12,15,20,25,33,41,54,67,88,109,143,177,232],
 [9,12,15,20,25,33,41,54,67,88,109,143,177,232,287],
 [9,12,15,20,26,34,43,54,68,85,107,133,166,206,256],
 [9,12,15,20,26,35,47,62,83,110,147,196,261,349,464],
 [9,12,15,20,26,35,47,62,84,110,148,197,263,350,467],
 [9,12,15,20,27,36,49,66,89,120,161,216],
 [9,12,15,21,25,33,38,48,54,66,73,87],
 [9,12,15,21,25,33,38,48,54,66,73,87,95],
 [9,12,15,21,26,36,44,60,73,99,120,162,196,264,319],
 [9,12,15,21,27,37,49,66,90,120,166,221],[9,12,16,17,17],
 [9,12,16,18,19,19],[9,12,16,18,19,20,20],
 [9,12,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
   48,50,52,54,56,58,60,62,64,66,68,70],
 [9,12,16,18,22,24,28,30,34,36,40,42,46,48,52,54,58,60],
 [9,12,16,18,22,24,28,30,34,36,40,42,46,48,52,54,58,60,64 
  ],[9,12,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58],
 [9,12,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61],
 [9,12,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,64 
  ],[9,12,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,
   61,64,67,70,73,76,79,82,85],
 [9,12,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,
   64,67,70,73,76,79,82,85,88,91],
 [9,12,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,
   64,67,70,73,76,79,82,85,88,91,94],
 [9,12,16,19,23,26,30,33,37,40,44,47,51,54,58,61,65,68,
   72,75,79,82,86,89,93,96,100,103,107],
 [9,12,16,19,23,26,31,34,38,41,46,49,53,56,61,64,68,71,
   76,79,83],
 [9,12,16,19,24,28,31,36,40,43,48,52,55,60,64,67,72,76,
   79,84,88,91,96],
 [9,12,16,19,24,29,36,45,54,67,80,99,120,147,180,219,270,
   329,406],
 [9,12,16,19,24,32,39,47,60,75,90,111,139,169,205,254,312],
 [9,12,16,19,24,32,39,47,60,75,90,111,139,169,205,254,312,
   378],[9,12,16,19,25,29,36,40,47,52,60,66,74,80,89,96]
  ,[9,12,16,20,22,23,23],
 [9,12,16,20,22,26,30,32,36,40,42,46,50,52,56,60,62,66,
   70,72,76,80,82,86,90,92,96,100,102,106,110,112,116,120,
   122,126,130],
 [9,12,16,20,23,26,29,32,35,38,41,44,47,50,53,56,59,62,65 
  ],[9,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72],
 [9,12,16,20,25,30,36,42,49,56,64,72,81,90,100],
 [9,12,16,20,25,30,36,42,49,56,64,72,81,90,100,110],
 [9,12,16,20,25,30,36,43,50,59,68,79,91,104,120,136,156,
   177,201,229,258,294,331],
 [9,12,16,20,25,31,38,46,54,65,76,89,103,121,140,161,186,
   215,247],
 [9,12,16,20,25,32,43,55,71,91,120,156,202,262,341],
 [9,12,16,20,26,33,41,51,64,79,97,120,148,181,222,273],
 [9,12,16,20,26,33,41,51,64,79,97,120,148,181,222,273,334,
   408],[9,12,16,20,27,37,49,66,91,123,167,229,313,426],
 [9,12,16,21,27,34,42,51,61,72,84,97,111,126,142,159],
 [9,12,16,21,27,36,49,67,91,124,170,234,322,443],
 [9,12,16,21,27,37,47,62,78,103,129,169,211,276,344],
 [9,12,16,21,29,38,51,68,90,120,159,211,280,371],
 [9,12,16,21,29,38,51,68,90,120,159,211,280,371,492],
 [9,12,16,22,28,35,43,51,61,70,82,92,106,117,133,145],
 [9,12,16,22,30,40,54,72,96,128,170,226,300,398,528],
 [9,12,16,22,30,41,55,74,99,132,176,234,311],
 [9,12,16,22,30,42,58,82,114,162,226,322,450],
 [9,12,16,22,31,44,62,88,124,176,248,352,496],
 [9,12,16,24,32,48,64,96,128,192,256,384,512],
 [9,12,17,19,19],
 [9,12,17,19,21,25,27,29,33,35,37,41,43,45,49,51,53,57,
   59,61,65,67,69,73,75,77,81,83,85,89,91,93,97,99,101,
   105,107,109,113],
 [9,12,17,19,23,25,29,31,35,37,41,43,47,49,53,55,59],
 [9,12,17,19,23,25,29,31,35,37,41,43,47,49,53,55,59,61,65 
  ],[9,12,17,20,24,26,30,32,36,38,42,44,48,50,54,56,60,
   62,66,68,72,74,78,80,84,86,90,92,96],
 [9,12,17,20,24,27,32,35,39,42,47,50,54,57,62,65,69,72,
   77,80,84,87,92,95,99,102,107],
 [9,12,17,20,24,27,32,35,39,42,47,50,54,57,62,65,69,72,
   77,80,84,87,92,95,99,102,107,110],[9,12,17,21,22,22],
 [9,12,17,21,27,31,37,41,47,51,57,61,67,71,77,81,87,91],
 [9,12,17,22,29,37,48,62,79,100,125,157,196,245,305],
 [9,12,17,22,30,40,53,71,94,125,166,220,292,387,513],
 [9,12,17,22,31,41,55,74,97,130,172,228,303,401],
 [9,12,17,23,27,32,38,42,47,53,57,62,68,72,77,83,87],
 [9,12,17,23,31,42,55,74,99,131,175,232,308,409],
 [9,12,17,23,31,42,56,75,100,133,177,235,312,414],
 [9,12,17,23,32,42,58,77,106,143,195,266],
 [9,12,17,23,34,51,79,125,199,319,513],
 [9,12,17,25,34,47,64,86,116,155,207,276,367,488],
 [9,12,18,22,27,31,36,40,45,49,54,58,63,67,72,76,81,85],
 [9,12,18,23,30,35,42,47,54,59,66,71,78,83,90,95],
 [9,12,18,23,30,35,42,47,54,59,66,71,78,83,90,95,102],
 [9,12,18,23,30,43,58,77,107,147,198,272,374,509],
 [9,12,18,24,34,46,62,84,112,150,200,266,354],
 [9,12,18,24,34,46,62,84,112,150,200,266,354,470],
 [9,12,19,28,35,46,59,70,85,102,117,136,157,176,199,224,247 
  ],[9,12,19,28,37,48,61,74,89,106,123,142,163,184,207,
   232,257],
 [9,12,19,28,38,50,63,77,93,110,128,148,169,191,215,240],
 [9,12,19,28,38,50,63,77,93,110,128,148,169,191,215,240,266 
  ],[9,12,19,28,40,58,86,125,180,260,377,544],
 [9,12,19,28,47,69,101,161,246,360,544],
 [9,12,19,31,50,76,112,169,262,391,609],
 [9,12,19,31,50,80,116,177,280,415],
 [9,12,19,31,50,81,128,208,329,517],
 [9,12,19,31,50,85,132,216,347,541],
 [9,12,21,36,55,84,131,190,277,412],
 [9,12,21,36,59,93,158,252,394,642],[9,13,13],
 [9,13,14,14],[9,13,14,15,15],
 [9,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
   30,31,32,33,34,35,36,37,38,39],
 [9,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,35,37,
   38,40,41,43,44,46,47,49,50],
 [9,13,14,16,17,19,20,22,23,25,26,28,29,31,32,34,35,37,
   38,40,41,43,44,46,47,49,50,52],[9,13,15,15],
 [9,13,15,16,16],[9,13,15,17,17],
 [9,13,15,17,19,21,23,25,27,29,31,33,35,37,39],
 [9,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41],
 [9,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47 
  ],[9,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,
   45,47,49,51,53,55,57,59,61,63],
 [9,13,15,17,20,22,24,27,29,31,34,36,38,41,43,45,48,50,
   52,55,57,59,62,64,66,69,71,73,76,78,80,83,85,87,90,92,
   94,97,99,101,104],
 [9,13,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84],
 [9,13,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84,87],
 [9,13,15,18,22,26,31,36,42,48,55,62,70,78,87,96,106,116,
   127,138,150,162,175,188,202,216,231],
 [9,13,15,18,22,27,32,39,47,57,69,84,101,123,148,180,217,
   264,318,387,466],[9,13,16,16],[9,13,16,17,17],
 [9,13,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46],
 [9,13,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
   48,50,52,54,56,58,60,62],
 [9,13,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
   48,50,52,54,56,58,60,62,64],[9,13,16,19,20,21,21],
 [9,13,16,19,22,25,28,31,34,37,40,43,46,49,52],
 [9,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55],
 [9,13,16,19,24,29,34,41,48,55,64,73,82,93,104],
 [9,13,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58],
 [9,13,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58,62],
 [9,13,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58,62,64 
  ],[9,13,16,20,23,26,30,33,36,40,43,46,50,53,56,60,63,
   66,70,73,76,80,83,86,90,93,96,100,103],
 [9,13,16,20,24,29,36,44,55,67,83,102,126,156,192,238,293],
 [9,13,16,20,25,32,41,52,66,84,107,136,173,220,280,356,453]
  ,[9,13,16,21,27,34,42,51,61,72,84,97,111,126,142,159,
   177,196,216,237,259,282,306,331,357,384],[9,13,17,17],
 [9,13,17,19,19],[9,13,17,19,20,20],[9,13,17,19,21,21],
 [9,13,17,19,21,23,25,27,29,31,33,35,37,39,41],
 [9,13,17,19,21,23,25,27,29,31,33,35,37,39,41,43],
 [9,13,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65,67],[9,13,17,20,21,21],
 [9,13,17,20,23,25,27,27],
 [9,13,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,62],
 [9,13,17,21,25,29,33,37,41,45,49,53,57,61,65],
 [9,13,17,21,25,29,33,37,41,45,49,53,57,61,65,69,73],
 [9,13,17,21,25,29,33,37,41,45,49,53,57,61,65,69,73,77],
 [9,13,17,21,29,37,53,69,101,133,197,261,389,517],
 [9,13,17,22,27,33,39,46,53,61,69,78,87,97,107,118,129,
   141,153,166,179,193,207,222,237,253,269],
 [9,13,17,22,27,34,43,55,70,89,112,141,177,222,278,348,436]
  ,[9,13,17,22,28,34,41,49,57,66,76,86,97,109,121,134,
   148,162,177,193,209,226],
 [9,13,17,22,28,35,44,54,68,84,105,129,161,198,246,301,374,
   458],[9,13,17,22,29,39,53,72,96,129,175,235,316,427],
 [9,13,17,22,29,40,53,70,91,122,163,216,285,382,511],
 [9,13,17,23,29,37,45,55,65,77],
 [9,13,17,23,29,37,45,55,65,77,89,103,117],
 [9,13,17,23,29,38,49,64,84,112,148,198,265,357,478],
 [9,13,17,23,29,39,49,65,81,107,133,175],
 [9,13,17,23,30,39,51,66,86,112,146,191,250,328,431],
 [9,13,17,23,30,40,53,70,93,123,163,216,286],
 [9,13,17,23,31,43,58,79,106,145,197,270,367,504],
 [9,13,17,24,31,44,57,81,105,149,193,274,355],
 [9,13,18,21,22,22],
 [9,13,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74,78,
   82,86,90,94,98,102,106,110,114,118],
 [9,13,18,22,27,31,36,40,45,49,54,58,63,67,72,76,81,85],
 [9,13,18,23,28,33,38,43,48,53,58,63,68,73,78,83,88],
 [9,13,18,23,30,39,50,62,78,98,121,149,185,228,279,343,422]
  ,[9,13,18,24,30,38,47,58,72,90,111,138,170,212,260,322,
   395,490],
 [9,13,18,24,31,39,48,58,69,81,94,108,123,139,156,174],
 [9,13,18,24,31,41,53,69,88,114,145,187],
 [9,13,18,24,32,41,54,68,87,109,137,172,214,268,332],
 [9,13,18,24,32,43,59,80,110,151,209,289,402],
 [9,13,18,24,32,44,60,80,107,144,192,256,346,467],
 [9,13,18,25,33,42,52,63,75,88,102,117,133,150,168,187],
 [9,13,18,26,38,55,82,120,179,265],[9,13,19,21,21],
 [9,13,19,23,23],[9,13,19,23,25,25],
 [9,13,19,23,27,31,35,39,43,47,51,55,59,63,67],
 [9,13,19,23,27,31,35,39,43,47,51,55,59,63,67,71,75],
 [9,13,19,24,30,37,47,59,76,96,121,152,191,240,299,376,469]
  ,[9,13,19,24,32,39,47,56,66,75,87,98,110,123,137,150,
   166,181,197,214,232],
 [9,13,19,25,33,43,55,69,87,109,135,167,207,255,313],
 [9,13,19,25,34,46,67,96,134,187,265,377,531],
 [9,13,19,25,35,46,63,83,114,151,207,277,380,511],
 [9,13,19,25,35,47,63,85,113,151,201,267],
 [9,13,19,25,35,47,65,91,125,172,236,327,450],
 [9,13,19,27,39,57,83,121,177,259,379],
 [9,13,19,27,41,59,89,131,195,291],
 [9,13,20,29,37,48,61,73,88,105,121,140,161,181,204,229,253 
  ],[9,13,20,29,39,51,64,78,94,111,129,149,170,192,216,
   241,267],
 [9,13,21,29,37,49,61,73,89,105,121,141,161,181,205,229,253 
  ],[9,13,21,29,37,50,64,79,96,114,133,154,176,199,224,
   250,277],[9,13,21,31,45,63,87,119,161,217,291,389,519],
 [9,13,21,33,47,73,105,151,238,355,544],
 [9,13,21,33,47,78,121,190,305,468],
 [9,13,21,33,53,85,137,221,357,577],
 [9,13,25,41,53,73,97,117,145,177,205,241,281],
 [9,13,25,41,57,77,101,125,153,185,217,253,293],
 [9,13,25,45,67,111,167,247,405],
 [9,13,25,45,67,121,199,325,539],
 [9,13,25,45,87,159,301,577],[9,13,25,45,87,169,287,525],
 [9,13,25,45,87,169,323,623],[9,14,14],[9,14,15,15],
 [9,14,15,16,16],[9,14,16,16],[9,14,16,18,18],
 [9,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48 
  ],[9,14,16,18,21,23,25,27,29,31,33,35,37,39,41,43,45,
   47,49,51,53,55,57,59,61,63,65],
 [9,14,16,19,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84],
 [9,14,16,19,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84,87],
 [9,14,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,
   64,67,70,73,76,79,82,85],
 [9,14,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,
   64,67,70,73,76,79,82,85,88],
 [9,14,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58,62],
 [9,14,16,20,22,26,28,32,34,38,40,44,46,50,52,56,58,62,64 
  ],[9,14,17,17],[9,14,17,18,18],
 [9,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49 
  ],[9,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,
   47,49,51,53,55,57,59,61,63],
 [9,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65],[9,14,17,20,21,21],
 [9,14,17,20,21,22,22],
 [9,14,17,20,23,28,35,44,55,69,87,109,136,170,214,268,336,
   421],[9,14,17,21,23,27,29,33,35,39,41,45,47,51,53,57,
   59,63],
 [9,14,17,21,23,27,29,33,35,39,41,45,47,51,53,57,59,63,65 
  ],[9,14,17,22,26,31,35,40,44,49,53,58,62,67,71],
 [9,14,17,22,27,34,42,52,65,80,99,122,151,186,229,282,348,
   428],
 [9,14,17,22,27,34,43,54,69,88,113,146,189,246,321,420],
 [9,14,18,19,19],
 [9,14,18,20,24,26,30,32,36,38,42,44,48,50,54,56,60,62],
 [9,14,18,20,24,26,30,32,36,38,42,44,48,50,54,56,60,62,66 
  ],[9,14,18,21,22,22],
 [9,14,18,21,24,27,30,33,36,39,42,45,48,51,54],
 [9,14,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74],
 [9,14,18,26,34,46,62,82,110,146,194,258,342,454],
 [9,14,19,19],[9,14,19,21,21],[9,14,19,22,23,23],
 [9,14,19,24,29,34,39,44,49,54,59,64,69],
 [9,14,19,26,36,48,65,87,116,155,206],
 [9,14,19,29,39,54,74,99,134,179,239,319],
 [9,14,19,29,44,59,84,114,154,209,279,374],
 [9,14,20,26,32,38,44,50,56,62,68,74,80,86,92],
 [9,14,21,30,43,58,75,94,115,138,163,190],
 [9,14,21,30,49,85,156,295,579],
 [9,14,21,33,60,104,197,355,690],
 [9,14,22,27,35,44,55,69,86,107,133,164,204,251,311,382,473 
  ],[9,14,22,27,35,44,56,71,91,116,150,193,251,326,426],
 [9,14,22,31,39,51,64,76,92,109,125,145,166,186,210,235,259 
  ],[9,14,23,32,45,58,75,92,113,134,159,184],
 [9,14,23,32,45,58,75,92,113,134,159,184,213],
 [9,14,23,32,45,60,79,100,123,148,175,204],
 [9,14,23,32,45,60,79,100,123,148,175,204,235],
 [9,14,23,34,47,62,79,98,119,142,167,194],
 [9,14,23,34,47,62,79,98,119,142,167,194,223],
 [9,14,23,34,52,72,108,151,223,306,450],
 [9,14,23,34,52,77,113,165,237,343,487],
 [9,14,23,34,60,113,240,484],
 [9,14,23,38,59,102,180,314,565],
 [9,14,23,38,67,121,250,521],[9,14,23,44,74,136,243,427],
 [9,14,23,45,75,138,246,431],[9,14,23,45,96,188,414],
 [9,14,24,34,54,79,119,174,259,379,559],
 [9,14,24,39,59,94,144,219,339,514],
 [9,14,26,40,80,132,268,452],
 [9,14,27,48,83,138,225,360,598],
 [9,14,27,48,83,138,240,406],[9,14,27,48,90,160,301,530],
 [9,14,28,37,59,72,102,119,157,178,224,249],
 [9,14,28,39,61,76,106,125,163,186,232,259],
 [9,14,28,49,88,163,287,517],[9,14,28,50,118,210,490],
 [9,14,29,44,83,137,293,527],[9,14,29,51,119,211,491],
 [9,15,15],[9,15,17,17],[9,15,17,18,18],
 [9,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65],
 [9,15,18,22,25,29,32,36,39,43,46,50,53,57,60,64,67,71,
   74,78,81,85,88,92,95,99,102],
 [9,15,18,22,26,29,33,37,40,44,48,51,55,59,62,66,70,73,
   77,81,84],
 [9,15,18,22,27,34,42,51,62,77,96,118,145,180,223,274,336,
   415],
 [9,15,18,22,28,35,45,55,69,84,105,128,160,195,244,297,371,
   451],[9,15,19,19],[9,15,19,21,21],
 [9,15,19,23,27,31,35,39,43,47,51,55,59,63,67],
 [9,15,19,25,30,37,44,52,60,69,79,89,100,111,124,136,150,
   163,179,193,210,225,244,260],
 [9,15,19,25,31,38,46,54,64,73,85,95,109,120,136,148,166,
   179,199,213,235,250,274,290],
 [9,15,19,25,31,39,48,59,72,88,107,130,158,192,233,283,344,
   418],[9,15,19,27,37,49,67,89,119,159,211,281,373,495],
 [9,15,20,29,41,56,79,106,144,196,261,351],
 [9,15,20,29,41,57,78,106,146,202,277,379],
 [9,15,20,29,41,58,84,118,168,238,336,475],
 [9,15,21,27,33,39,45,51,57,63,69,75,81],
 [9,15,21,28,35,43,51,60,69,79,89,100,111],
 [9,15,21,32,43,60,77,105,133,178,223,296],
 [9,15,21,32,44,61,79,107,137,182,230,303],
 [9,15,21,32,44,61,84,113,153,205,274],
 [9,15,21,32,44,66,90,129,176,249,342,478],
 [9,15,22,28,34,40,46,52,58,64,70,76],
 [9,15,22,28,34,40,46,52,58,64,70,76,82],
 [9,15,22,29,36,43,50,57,64,71,78,85,92],
 [9,15,22,33,50,68,96,131,177,240,321],
 [9,15,22,34,52,76,112,161,233,336],
 [9,15,22,34,52,76,112,161,233,336,481],
 [9,15,22,34,52,82,125,192,295,453],
 [9,15,22,35,50,72,102,141,195,266,361,488],
 [9,15,23,33,45,59,75,93,113,135,159,185],
 [9,15,23,33,46,62,82,108,141,181,231,294],
 [9,15,23,33,47,63,81,101,123,147,173,201],
 [9,15,23,33,50,74,109,160,236,346],
 [9,15,23,33,50,74,109,160,236,346,508],
 [9,15,23,33,50,78,130,217,351,571],
 [9,15,23,33,51,75,114,169,256,380,579],
 [9,15,23,33,52,88,159,298,582],
 [9,15,23,37,68,124,242,451],
 [9,15,23,38,65,116,214,392,689],
 [9,15,23,39,57,91,145,232,379,613],
 [9,15,23,39,63,106,174,285,473],
 [9,15,23,39,70,130,237,446],[9,15,23,39,74,148,290,582],
 [9,15,24,34,47,61,78,96,117,139,164,190],
 [9,15,24,34,47,61,78,96,117,139,164,190,219],
 [9,15,24,34,47,62,81,102,127,152,181,210],
 [9,15,24,34,47,63,83,105,129,155,183,213],
 [9,15,24,35,48,63,80,99,120,143,168,195],
 [9,15,24,35,49,67,89,115,148,186,235,291],
 [9,15,24,35,50,65,84,103,126,149,176,203],
 [9,15,24,35,61,114,241,486],
 [9,15,24,36,50,66,84,104,126,150,176,204],
 [9,15,24,40,53,77,94,126,147,187,212,260],
 [9,15,24,40,61,98,151,257,405],
 [9,15,24,40,61,105,183,318,570],
 [9,15,24,40,67,113,204,355,636],
 [9,15,24,40,69,124,253,527],[9,15,24,40,69,132,261,581],
 [9,15,24,41,54,79,96,129,150,191,216,265],
 [9,15,24,43,72,120,194,329,532],
 [9,15,24,46,76,139,247,432],[9,15,24,46,85,150,277,489],
 [9,15,24,47,82,146,264,463],[9,15,24,47,82,148,268,469],
 [9,15,24,47,98,193,419],[9,15,24,47,98,205,431],
 [9,15,25,35,49,63,81,99,121,143,169,195],
 [9,15,25,40,67,108,177,285,465],
 [9,15,25,42,67,110,170,278,423],
 [9,15,25,47,78,141,250,436],
 [9,15,26,43,66,100,146,214,306,442],
 [9,15,26,47,73,128,225,406],
 [9,15,26,48,77,132,212,351,566],
 [9,15,26,50,91,170,315,565],
 [9,15,27,39,61,85,129,177,265,361,537],
 [9,15,27,44,74,123,203,341,596],
 [9,15,27,44,77,123,206,331,543],
 [9,15,27,48,88,137,234,378,639],
 [9,15,28,38,59,73,102,120,157,179,224,250],
 [9,15,28,38,61,78,109,130,169,194,241,270],
 [9,15,28,44,71,111,180,288,470],
 [9,15,28,44,77,129,212,354,581],
 [9,15,28,44,79,119,206,302,540],
 [9,15,28,44,79,119,221,348,665],
 [9,15,28,44,86,141,282,457],[9,15,28,44,86,142,282,474],
 [9,15,28,44,86,142,282,490],
 [9,15,28,46,73,117,196,341,590],
 [9,15,28,46,85,158,273,499],
 [9,15,28,50,85,143,230,372,610],
 [9,15,28,50,85,143,245,418],[9,15,28,50,92,165,306,556],
 [9,15,28,51,101,205,421],[9,15,28,53,93,168,296,541],
 [9,15,28,53,99,196,374,726],
 [9,15,29,39,61,75,105,123,161,183,229,255],
 [9,15,29,41,64,80,111,131,170,194,241,269],
 [9,15,29,53,121,225,505],[9,15,29,56,104,214,468],
 [9,15,29,56,117,251,536],[9,15,29,59,119,229,494],
 [9,15,29,59,127,241,505],[9,15,29,59,127,273,595],
 [9,15,29,61,112,212,393,708],[9,15,30,46,85,140,296,532],
 [9,15,30,47,75,100,140,173,225,266,330,379],
 [9,15,30,52,91,164,320,631],[9,15,30,53,121,215,495],
 [9,15,30,59,127,252,532],[9,15,32,53,104,165,309,475],
 [9,16,16],[9,16,18,18],
 [9,16,19,22,27,32,37,44,52,60,70,83,96,111,130,151,174,
   203,236,272,315,366,423],
 [9,16,19,22,27,32,37,44,53,62,73,88,105,124,149,180,215,
   258,313,378,455],
 [9,16,19,23,26,30,33,37,40,44,47,51,54,58,61,65,68,72,
   75,79,82,86,89,93,96,100],
 [9,16,19,24,27,32,35,40,43,48,51,56,59,64,67,72,75,80,
   83,88,91,96,99,104,107,112,115],[9,16,20,20],
 [9,16,20,22,24,26,26],
 [9,16,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,
   52,54,56,58,60,62,64,66,68],
 [9,16,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,
   52,54,56,58,60,62,64,66,68,70],
 [9,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,
   84,88,92,96,100,104,108,112,116],
 [9,16,20,26,30,36,40,46,50,56,60,66,70,76,80,86,90,96,
   100],[9,16,20,26,30,36,40,46,50,56,60,66,70,76,80,86,
   90,96,100,106],[9,16,21,21],[9,16,22,24,24],
 [9,16,23,30,37,44,51,58,65,72,79,86],
 [9,16,23,32,41,52,63,76,89,104],
 [9,16,23,32,41,52,63,76,89,104,119,136,153],
 [9,16,23,35,47,66,85,116,147,197],
 [9,16,23,36,49,74,99,144,189,272,355,508],
 [9,16,24,28,34,38,44,48,54,58,64,68,74,78,84,88,94,98,
   104,108,114,118,124,128,134],
 [9,16,24,28,34,38,44,48,54,58,64,68,74,78,84,88,94,98,
   104,108,114,118,124,128,134,138],
 [9,16,24,28,36,40,48,52,60,64,72,76,84,88,96,100,108,112,
   120],
 [9,16,24,30,40,50,62,76,92,112,134,160,190,226,268,316,372 
  ],[9,16,24,30,40,50,64,80,102,128,164,208,268,344,446],
 [9,16,25,35,48,62,79,97,118,140,165,191],
 [9,16,25,35,49,65,85,105,129,153,181,209],
 [9,16,25,35,50,67,86,107,130,155,182,211],
 [9,16,25,36,49,64,81,100,121,144,169,196],
 [9,16,25,36,49,64,83,106,131,160,189,222],
 [9,16,25,36,49,65,84,107,132,159,188,219],
 [9,16,25,36,49,65,85,108,137,166,202,237],
 [9,16,25,36,49,66,87,110,135,162,191,222],
 [9,16,25,36,51,70,89,112,135,162,189,220],
 [9,16,25,37,52,69,88,109,132,157,184,213],
 [9,16,25,37,53,69,89,109,133,157,185,213],
 [9,16,25,37,53,70,92,114,142,169,203,235],
 [9,16,25,37,53,71,95,122,158,198,252,311],
 [9,16,25,37,53,71,96,122,158,191,236,276],
 [9,16,25,38,53,70,89,110,133,158,185,214],
 [9,16,25,39,72,142,290,606],[9,16,25,39,72,142,291,607],
 [9,16,25,41,54,78,95,127,148,188,213,261],
 [9,16,25,42,55,80,97,130,151,192,217,266],
 [9,16,25,42,56,83,103,139,163,207,235,287],
 [9,16,25,42,61,96,151,239,387,622],
 [9,16,25,42,63,101,154,261,409],
 [9,16,25,42,63,101,163,276,463],
 [9,16,25,42,67,111,180,292,482],
 [9,16,25,42,69,102,175,296,506],
 [9,16,25,42,69,116,207,359,641],
 [9,16,25,42,77,134,238,428],
 [9,16,25,43,58,84,103,137,160,202,229,279],
 [9,16,25,44,79,144,251,455],
 [9,16,25,45,74,123,197,334,537],
 [9,16,25,45,79,134,226,381,635],
 [9,16,25,45,79,142,251,445],[9,16,25,48,87,153,281,494],
 [9,16,25,48,88,165,317,573],
 [9,16,26,37,52,67,86,105,128,151,178,205],
 [9,16,26,38,52,68,86,106,128,152,178,206],
 [9,16,26,44,65,99,149,227,351,520],
 [9,16,26,44,66,100,144,205,287,396,550],
 [9,16,26,44,71,114,188,310,511],
 [9,16,26,44,77,132,225,378,629],
 [9,16,27,49,76,131,229,411],[9,16,27,52,94,173,320,571],
 [9,16,28,40,59,83,114,157,212,286],
 [9,16,28,40,59,83,114,157,212,286,384],
 [9,16,28,42,68,101,155,233,348],
 [9,16,28,45,69,105,158,235,348,514],
 [9,16,29,40,61,76,105,124,161,184,229,256],
 [9,16,29,40,63,81,113,135,175,201,249,279],
 [9,16,29,46,81,122,224,352,669],
 [9,16,29,46,88,144,285,462],
 [9,16,29,52,87,146,233,391,660],
 [9,16,29,52,87,153,270,483],[9,16,29,52,102,203,399,753],
 [9,16,29,53,95,173,315,579],[9,16,29,55,104,190,339,623],
 [9,16,29,55,108,209,400],[9,16,29,60,120,243,507],
 [9,16,29,61,121,251,501],
 [9,16,30,40,62,76,106,124,162,184,230,256],
 [9,16,30,45,72,100,150,206,296,405],
 [9,16,30,45,73,102,157,231,355,533],
 [9,16,30,46,68,92,122,154,192,232,278,326],
 [9,16,30,58,115,228,502],[9,16,30,58,128,265,575],
 [9,16,30,61,138,258,549],[9,16,30,63,115,216,399,716],
 [9,16,31,46,82,126,203,330,536],
 [9,16,31,46,82,138,237,408],[9,16,31,54,93,167,323,636],
 [9,16,31,55,123,219,499],[9,16,31,56,108,214,416],
 [9,16,31,61,129,256,536],[9,16,31,62,124,248,510],
 [9,17,17],[9,17,18,18],[9,17,19,19],
 [9,17,20,24,26,30,32,36,38,42,44,48,50,54,56,60,62,66],
 [9,17,20,24,26,30,32,36,38,42,44,48,50,54,56,60,62,66,68 
  ],[9,17,21,24,25,25],
 [9,17,21,27,31,37,41,47,51,57,61,67,71,77,81,87,91,97,
   101],[9,17,21,27,31,37,41,47,51,57,61,67,71,77,81,87,
   91,97,101,107],[9,17,23,27,30,33,34,35,35],
 [9,17,23,27,31,34,37,40,43,46,49,52,55,58,61,64,67],
 [9,17,23,27,31,34,37,40,43,46,49,52,55,58,61,64,67,70],
 [9,17,23,34,41,52,59,70,77,88,95,106],
 [9,17,24,30,36,42,48,54,60,66,72,78],
 [9,17,24,30,36,42,48,54,60,66,72,78,84],
 [9,17,25,35,49,63,79,99,119,141,167,193,221,253],
 [9,17,26,38,51,67,84,104,125,149,174,202],
 [9,17,26,38,52,70,91,114,139,166,195,226],
 [9,17,26,38,53,71,90,112,135,161,188,218],
 [9,17,26,42,57,79,100,128,155,189,222,262],
 [9,17,26,42,66,108,175,286,463],
 [9,17,26,43,56,81,98,131,152,193,218,267],
 [9,17,27,34,38,45,49,56,60,67,71,78,82,89,93,100,104,111,
   115,122,126,133,137,144,148],
 [9,17,27,34,45,52,63,70,81,88,99,106],
 [9,17,27,35,45,57,73,91,107,125,145,169,195,219,245,273,
   305,339],[9,17,27,39,54,71,93,117,145,178,216,260],
 [9,17,27,39,55,73,95,119,147,179,216,257],
 [9,17,27,40,55,73,93,116,141,169,199,232],
 [9,17,27,40,55,74,96,121,151,185,224,268],
 [9,17,27,40,56,75,96,121,151,186,227,274],
 [9,17,27,44,58,83,101,134,156,197,223,272],
 [9,17,27,45,65,91,119,153,189,231,275,325],
 [9,17,27,45,65,99,142,222,322,509],
 [9,17,27,45,66,95,126,164,204,250,298,352],
 [9,17,27,45,68,110,164,260,386,615],
 [9,17,27,45,71,107,173,277,444],
 [9,17,27,45,77,125,207,337,548],
 [9,17,27,46,67,102,152,231,355,525],
 [9,17,27,46,68,103,147,209,291,401],
 [9,17,27,46,73,117,191,314,515],
 [9,17,27,46,79,135,228,382,634],
 [9,17,28,40,56,73,94,116,142,169,200,232],
 [9,17,28,41,55,72,90,111,134,161,191,224],
 [9,17,28,41,55,72,91,114,140,169,202],
 [9,17,28,41,55,72,91,114,140,169,202,237],
 [9,17,28,42,60,83,111,142,178],
 [9,17,28,45,66,91,120,153,190,231,276,325],
 [9,17,28,45,66,93,124,161,201,247,295,349],
 [9,17,28,45,69,96,131,170,219,272,334],
 [9,17,28,45,70,99,138,179,228,279,338],
 [9,17,28,46,73,107,156,219,310],
 [9,17,28,46,74,111,167,237,337],
 [9,17,28,52,93,169,302,537],
 [9,17,29,40,54,74,91,111,139,162,188,224,253,285,329],
 [9,17,29,41,56,72,91,111,134,158,185,213],
 [9,17,29,42,60,79,102,127,155,186],
 [9,17,29,45,72,112,187,302,483],
 [9,17,29,46,76,123,212,351,583],
 [9,17,30,44,63,83,108,134,165,197,234,272],
 [9,17,30,44,64,86,115,145,180,216,257,299],
 [9,17,30,48,78,124,207,343,562],
 [9,17,30,50,77,123,194,313,507],
 [9,17,30,50,85,144,233,385,634],
 [9,17,30,50,91,153,254,422],
 [9,17,30,54,83,135,218,345,567],
 [9,17,30,54,91,156,257,425],
 [9,17,31,42,64,79,109,128,166,189,235,262],
 [9,17,31,47,69,93,123,155,193,233,279,327],
 [9,17,31,47,70,96,130,166,208,252,302,354],
 [9,17,31,47,71,99,133,169,211,255,305,357],
 [9,17,31,47,74,103,153,210,300,410],
 [9,17,31,47,75,105,160,235,359,538],
 [9,17,31,53,89,145,248,430],[9,17,31,53,96,174,316,555],
 [9,17,31,55,98,176,310,578],[9,17,31,60,118,232,508],
 [9,17,31,60,131,269,581],[9,17,31,63,141,262,556],
 [9,17,31,66,136,266,552],[9,17,31,66,139,281,586],
 [9,17,32,47,78,115,178,279,441],
 [9,17,32,47,78,127,207,345,554],
 [9,17,32,48,84,129,206,334,540],
 [9,17,32,48,84,141,240,412],[9,17,32,55,93,159,269,446],
 [9,17,32,59,104,179,309,535],
 [9,17,33,49,73,97,129,161,201,241],
 [9,17,33,51,75,101,133,167,207],
 [9,17,33,51,75,101,133,167,207,249],
 [9,17,33,51,77,107,143,183,227],
 [9,17,33,53,77,105,137,173,213],
 [9,17,33,56,87,131,184,255,336,440],
 [9,17,33,60,103,169,272,435],[9,17,33,60,103,177,301,501]
  ,[9,17,33,63,116,221,414],[9,17,33,63,119,228,438],
 [9,17,33,66,156,354,910],[9,17,33,69,125,241,445],
 [9,17,33,71,127,245,451],[9,17,34,63,125,226,472],
 [9,17,34,63,137,282,618],[9,17,34,68,140,273,545],
 [9,17,34,71,143,297,608],[9,17,34,71,166,391,957],
 [9,17,34,74,135,270,543],[9,17,34,74,153,312,635],
 [9,17,35,56,102,173,310,537],[9,17,35,59,116,201,382,710]
  ,[9,17,35,64,118,228,438],[9,17,35,67,132,237,436],
 [9,17,35,74,135,258,557],[9,17,35,74,135,263,524],
 [9,17,35,74,153,300,641],[9,17,35,74,153,305,646],
 [9,17,36,55,97,139,227,331,503],
 [9,17,36,59,103,153,239,341,500],[9,17,36,67,165,356,916]
  ,[9,17,36,76,179,428],[9,17,38,85,221,480],
 [9,17,39,65,127,197,385,621],[9,17,39,65,141,241,507],
 [9,17,39,67,129,201,389,657],[9,17,39,67,143,259,569],
 [9,17,39,73,164,342,782],[9,17,39,73,171,333,755],
 [9,17,39,85,187,437],[9,17,39,85,194,454],
 [9,17,39,85,201,419],[9,17,39,85,201,471],
 [9,17,41,57,97,121,177,209,281],
 [9,17,41,61,101,129,185,221,293],[9,17,41,67,140,247,557]
  ,[9,17,41,74,176,328,776],[9,17,42,83,186,370,815],
 [9,17,42,95,218,485],[9,17,43,83,211,387,931],
 [9,17,44,84,212,388,932],[9,18,20,20],[9,18,23,23],
 [9,18,33,50,73,98,129,162,201],
 [9,18,33,50,73,98,129,162,201,242],
 [9,18,33,52,78,108,142,180,222],
 [9,18,33,60,101,184,337,602],[9,18,33,66,119,224,409],
 [9,18,34,52,76,102,134,168,208],
 [9,18,34,52,76,102,134,168,208,250],
 [9,18,34,54,78,106,138,174,214],
 [9,18,34,60,84,126,158,216,256],[9,18,34,72,128,246,452],
 [9,18,36,69,127,244,462],[9,18,36,75,145,283,533],
 [9,18,39,68,120,224,421],[9,18,39,78,152,288,533],
 [9,18,39,78,152,302,612],[9,18,39,81,164,359,801],
 [9,18,39,81,178,379,854],[9,18,39,86,163,317,595],
 [9,18,40,68,137,224,451],[9,18,40,68,144,246,512],
 [9,18,41,58,97,122,177,210,281],
 [9,18,41,60,102,134,192,232,306],[9,18,42,70,143,252,562]
  ,[9,18,42,77,179,334,782],[9,18,42,86,186,397,902],
 [9,18,42,91,230,493],[9,18,42,91,235,587],
 [9,18,42,92,212,490],[9,18,42,92,226,526],
 [9,18,42,92,226,548],[9,18,42,94,247,648],
 [9,18,43,78,173,306,649],[9,18,45,87,215,395,939],
 [9,19,28,41,54,71,88,109,130,155,180,209],
 [9,19,28,46,59,85,102,136,157,199,224,274],
 [9,19,28,46,72,119,178,278,427],
 [9,19,30,43,58,75,94,115,138,163,190,219],
 [9,19,30,48,63,89,108,142,165,207,234,284],
 [9,19,33,51,73,99,129,163,201],
 [9,19,33,51,73,99,129,163,201,243],
 [9,19,33,51,77,107,141,179,221],
 [9,19,33,61,93,155,255,419],[9,19,33,61,105,185,313,535],
 [9,19,34,64,103,181,276,466],[9,19,34,64,103,181,276,497]
  ,[9,19,34,64,103,181,307,621],
 [9,19,34,64,103,196,322,621],[9,19,34,64,118,256,490],
 [9,19,34,71,125,241,414],[9,19,35,53,77,103,135,169,209],
 [9,19,35,63,87,131,163,223,263],[9,19,39,74,140,259,472],
 [9,19,39,79,175,385,899],[9,19,40,63,109,181,322,509],
 [9,19,40,68,115,164,257,343,502],
 [9,19,40,68,121,178,283,381,570],[9,19,40,84,168,365,811]
  ,[9,19,40,89,166,322,602],[9,19,41,85,177,361,737],
 [9,19,43,61,101,127,183,217,289],[9,19,43,94,234,501],
 [9,19,43,94,239,595],[9,19,45,86,193,393,878],
 [9,19,45,93,201,379,847],[9,19,45,93,215,463],
 [9,19,45,95,187,359,669],[9,19,45,107,239,543],
 [9,19,45,107,255,611],[9,19,48,121,297,751],
 [9,19,51,115,271,609],[9,19,51,115,289,657],
 [9,19,51,115,289,689],[9,19,51,121,297,720],
 [9,20,29,48,61,88,105,140,161,204,229,280],
 [9,20,32,48,68,96,132,180,244,328],
 [9,20,35,54,77,104,135,170,209],
 [9,20,35,54,77,104,135,171,212],
 [9,20,35,54,77,104,137,174,217],
 [9,20,35,54,77,105,138,176,219],
 [9,20,35,54,77,106,139,178,219],
 [9,20,35,54,79,108,141,178,219],
 [9,20,35,55,80,108,141,177,218],
 [9,20,35,55,80,108,141,178,221],
 [9,20,35,55,80,109,144,183,228],
 [9,20,35,55,80,109,144,183,229],
 [9,20,35,56,79,108,139,176,215],
 [9,20,35,56,81,112,145,184,225],[9,20,35,60,105,211,460],
 [9,20,35,61,122,262,598],[9,20,35,61,126,284,666],
 [9,20,35,61,126,284,667],[9,20,35,64,144,325,782],
 [9,20,35,66,131,244,451],[9,20,35,66,131,269,584],
 [9,20,35,66,131,277,628],[9,20,35,67,134,280,611],
 [9,20,35,67,140,314,716],[9,20,35,69,148,326,744],
 [9,20,35,73,168,370,826],[9,20,35,75,180,412],
 [9,20,35,75,180,420],[9,20,35,77,186,430],
 [9,20,39,72,117,192,329,575],[9,20,39,72,123,208,335,540]
  ,[9,20,39,72,123,208,335,569],
 [9,20,39,72,123,221,385,704],[9,20,39,72,135,257,457],
 [9,20,39,73,126,213,343,551],[9,20,39,73,126,213,343,580]
  ,[9,20,39,73,126,226,393,715],[9,20,39,74,137,261,463],
 [9,20,39,77,145,271,490],[9,20,39,77,145,271,491],
 [9,20,39,77,145,272,492],[9,20,39,78,145,272,511],
 [9,20,39,78,145,303,686],[9,20,39,89,204,462],
 [9,20,41,72,121,218,392,702],[9,20,41,72,129,208,349,540]
  ,[9,20,41,72,129,208,349,585],[9,20,41,72,129,229,465],
 [9,20,41,73,132,212,355,547],[9,20,41,73,132,212,355,592]
  ,[9,20,41,73,132,233,471],[9,20,41,81,181,349,773],
 [9,20,41,84,154,292,533],[9,20,41,84,154,292,534],
 [9,20,41,85,155,294,536],[9,20,42,72,148,288,624],
 [9,20,42,84,192,380,832],[9,20,43,84,159,294,533],
 [9,20,43,84,159,317,646],[9,20,43,86,167,314,579],
 [9,20,43,86,167,314,646],[9,20,43,86,192,437],
 [9,20,43,91,190,367,730],[9,20,45,90,175,328,603],
 [9,20,45,90,175,369,804],[9,20,45,95,199,409],
 [9,20,45,95,199,434],[9,20,45,99,233,524],
 [9,20,45,104,224,490],[9,20,45,105,250,574],
 [9,20,46,104,236,480],[9,20,50,104,228,456],
 [9,20,59,117,305,565],[9,21,36,56,79,107,138,174],
 [9,21,36,56,79,107,139,177],[9,21,36,56,79,107,140,178],
 [9,21,36,56,80,110,144,182],[9,21,36,56,81,111,144,182],
 [9,21,37,57,81,109,141,177],[9,21,37,57,81,109,142,180],
 [9,21,37,57,82,112,147,185],[9,21,38,57,82,109,142,177],
 [9,21,38,57,82,109,142,179],[9,21,38,57,82,111,146,185],
 [9,21,40,64,97,131,178,222],[9,21,40,64,97,131,180,227],
 [9,21,40,64,99,136,185,232],[9,21,40,68,97,139,178,234],
 [9,21,40,68,97,139,179,237],[9,21,40,68,98,142,184,244],
 [9,21,40,70,123,199,332,516],[9,21,40,70,123,199,353,590]
  ,[9,21,40,70,132,233,448],[9,21,40,74,117,195,290,454],
 [9,21,40,74,117,195,316,519],[9,21,40,74,129,228,381,650]
  ,[9,21,41,69,107,151,205,265],
 [9,21,41,69,107,151,206,268],[9,21,41,69,108,154,212,275]
  ,[9,21,41,73,122,201,318,503],
 [9,21,41,73,122,201,331,571],[9,21,41,73,127,225,378,641]
  ,[9,21,41,73,127,225,378,643],
 [9,21,42,69,118,181,290,423],[9,21,42,69,118,181,290,459]
  ,[9,21,42,69,118,199,337,569],
 [9,21,42,74,118,179,254,352],[9,21,42,74,118,179,254,354]
  ,[9,21,42,74,118,181,259,362],
 [9,21,44,82,141,231,362,558],[9,21,44,82,141,231,388,634]
  ,[9,21,44,82,141,239,388,626],[9,21,44,82,141,239,409],
 [9,21,44,82,150,273,504],[9,21,44,82,153,269,460],
 [9,21,45,85,152,261,451],[9,21,45,85,157,285,509],
 [9,21,46,86,158,267,444],[9,21,46,86,158,285,498],
 [9,22,38,68,92,138,170,232,272],
 [9,22,39,76,120,204,341,583],[9,22,39,76,138,256,453],
 [9,23,53,110,226,500],[9,23,53,110,249,599],
 [9,23,53,116,251,567],[9,23,53,116,252,592],
 [9,23,53,116,263,635],[9,23,53,123,287,691],
 [9,23,53,124,308,794],[9,23,53,131,335,829],
 [9,23,53,133,331,845],[9,23,56,126,274,643],
 [9,23,56,133,334,965],[9,23,56,134,329,867],
 [9,23,56,153,418],[9,23,59,138,320,740],
 [9,23,59,138,335,821],[9,23,59,138,359,939],
 [9,23,59,144,345,807],[9,23,59,147,345,781],
 [9,23,59,147,369,887],[9,23,59,154,410],
 [9,23,64,158,384,948],[9,23,64,158,384,973],
 [9,23,64,158,393,973],[9,23,64,167,427],
 [9,23,67,167,427],[9,23,67,167,436],
 [9,24,49,96,165,288,461],[9,24,49,96,165,288,506],
 [9,24,49,96,165,309,535],[9,24,49,96,186,402],
 [9,24,49,105,199,381,705],[9,24,51,96,171,317,637],
 [9,24,51,109,245,489],[9,24,58,128,276,576],[10,10],
 [12,12],[12,14,15,15],[12,14,15,16,16],
 [12,14,15,16,17,17],[12,14,15,16,17,18,18],
 [12,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42],
 [12,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42,43],
 [12,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
   49,50,51,52,53,54],
 [12,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
   49,50,51,52,53,54,55],
 [12,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
   49,50,51,52,53,54,55,56],
 [12,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
   31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
   49,50,51,52,53,54,55,56,57,58,59,60,61,62],
 [12,14,15,16,18,18],
 [12,14,15,16,18,19,20,21,23,24,25,26,28,29,30,31,33,34,
   35,36,38,39,40,41,43,44,45,46,48,49,50,51,53,54,55,56,
   58,59,60,61,63,64,65,66,68,69,70,71,73,74],
 [12,14,15,16,18,19,20,22,23,24,26,27,28,30,31,32,34,35,
   36,38,39,40,42,43,44,46,47,48,50,51,52,54,55,56,58,59,
   60,62,63,64,66,67,68],
 [12,14,15,16,18,19,21,22,24,25,27,28,30,31,33,34,36,37,
   39,40,42,43,45,46,48,49,51,52,54,55],
 [12,14,15,16,18,20,21,23,25,26,28,30,31,33,35,36,38,40,
   41,43,45,46,48,50,51,53,55,56,58,60,61,63,65,66,68,70,
   71,73,75,76,78,80],[12,14,15,17,17],
 [12,14,15,17,18,18],
 [12,14,15,17,18,19,20,22,23,24,25,27,28,29,30,32,33,34,
   35,37,38,39,40,42,43,44,45,47,48,49,50,52,53,54,55,57,
   58,59,60,62,63,64,65,67,68,69,70,72,73,74],
 [12,14,15,17,18,19,21,22,23,25,26,27,29,30,31,33,34,35,
   37,38,39,41,42,43,45,46,47,49,50,51,53,54,55,57,58,59,
   61,62,63,65,66],
 [12,14,15,17,18,19,21,22,23,25,26,27,29,30,31,33,34,35,
   37,38,39,41,42,43,45,46,47,49,50,51,53,54,55,57,58,59,
   61,62,63,65,66,67],
 [12,14,15,17,18,20,21,23,24,26,27,29,30,32,33,35,36,38,
   39,41,42,44,45,47,48,50,51,53,54,56],
 [12,14,15,17,19,20,22,24,25,27,29,30,32,34,35,37,39,40,
   42,44,45,47,49,50,52,54,55,57,59,60,62,64,65,67,69,70,
   72,74,75,77,79],
 [12,14,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,
   47,49,51,53,55,57,59,61,63,65,67,69],
 [12,14,15,17,19,22,24,27,29,32,34,37,39,42,44,47,49,52,
   54,57,59,62,64,67,69,72,74,77,79],
 [12,14,15,17,19,22,24,27,29,32,34,37,39,42,44,47,49,52,
   54,57,59,62,64,67,69,72,74,77,79,82],
 [12,14,15,17,20,22,25,27,30,32,35,37,40,42,45,47,50,52,
   55,57,60,62,65,67,70,72,75,77,80],
 [12,14,15,17,20,22,25,27,30,32,35,37,40,42,45,47,50,52,
   55,57,60,62,65,67,70,72,75,77,80,82],[12,14,16,16],
 [12,14,16,17,17],[12,14,16,17,18,18],
 [12,14,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
   32,33,34,35,36,37,38,39,40,41,42,43],
 [12,14,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
   32,33,34,35,36,37,38,39,40,41,42,43,44],
 [12,14,16,17,19,20,22,23,25,26,28,29,31,32,34,35,37,38,
   40,41,43,44,46,47,49,50,52,53,55,56],
 [12,14,16,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
   33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,
   51,52,53,54,55,56,57],
 [12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
   48,50,52,54,56,58,60,62,64,66,68,70],
 [12,14,16,18,22,28,38,51,71,97,137,189,269,373,533],
 [12,14,16,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,
   85,87,89,91,93],
 [12,14,16,19,21,23,26,28,31,33,35,38,40,43,45,47,50,52,
   55,57,59,62,64,67,69,71,74,76,79,81,83,86,88,91,93],
 [12,14,16,19,21,24,26,29,31,34,36,39,41,44,46,49,51,54,
   56,59,61,64,66,69,71,74,76,79,81,84],
 [12,14,16,19,21,24,27,30,33,36,39,42,45,48,51,54,57,60,
   63,66,69,72,75,78,81,84,87,90,93,96],
 [12,14,17,18,18],[12,14,17,18,19,20,20],
 [12,14,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
   33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,
   51,52,53,54,55,56,57],[12,14,17,18,19,21,21],
 [12,14,17,18,19,21,22,23,25,26,27,29,30,31,33,34,35,37,
   38,39,41,42,43,45,46,47,49,50,51,53,54,55,57,58,59,61,
   62,63,65,66,67,69],
 [12,14,17,18,19,21,22,23,25,26,27,29,30,31,33,34,35,37,
   38,39,41,42,43,45,46,47,49,50,51,53,54,55,57,58,59,61,
   62,63,65,66,67,69,70],[12,14,17,19,20,20],
 [12,14,17,19,20,21,21],
 [12,14,17,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
   34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,
   52,53,54,55,56,57,58],[12,14,17,19,20,22,23,23],
 [12,14,17,19,20,22,23,25,26,28,29,31,32,34,35,37,38,40,
   41,43,44,46,47,49,50,52,53,55,56,58],
 [12,14,17,19,21,22,23,23],
 [12,14,17,19,21,22,24,25,27,28,30,31,33,34,36,37,39,40,
   42,43,45,46,48,49,51,52,54,55,57,58],
 [12,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65,67,69,71],
 [12,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,
   85,87,89,91],
 [12,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,
   85,87,89,91,93],
 [12,14,17,19,21,24,26,28,31,33,35,38,40,42,45,47,49,52,
   54,56,59,61,63,66,68,70,73,75,77,80,82,84,87,89,91,94,
   96,98,101,103,105],
 [12,14,17,19,21,24,26,29,31,33,36,38,41,43,45,48,50,53,
   55,57,60,62,65,67,69,72,74,77,79,81,84,86,89,91,93],
 [12,14,17,19,21,25,27,31,33,37,39,43,45,49,51,55,57,61,
   63,67,69,73,75,79,81,85,87,91,93],
 [12,14,17,19,21,25,27,31,33,37,39,43,45,49,51,55,57,61,
   63,67,69,73,75,79,81,85,87,91,93,97],
 [12,14,17,19,22,23,25,26,28,29,31,32,34,35,37,38,40,41,
   43,44,46,47,49,50,52,53,55,56,58,59],
 [12,14,17,19,22,23,25,28,29,31,34,35,37,40,41,43,46,47,
   49,52,53,55,58,59,61,64,65,67,70,71,73,76,77,79,82,83,
   85,88,89,91,94],
 [12,14,17,19,22,24,27,29,32,34,37,39,42,44,47,49,52,54,
   57,59,62,64,67,69,72,74,77,79,82,84],
 [12,14,17,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,
   64,67,70,73,76,79,82,85,88,91,94],
 [12,14,17,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,
   64,67,70,73,76,79,82,85,88,91,94,97],
 [12,14,17,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,
   50,52,54,56,58,60,62,64,66,68,70,72],
 [12,14,17,20,22,26,28,32,34,38,40,44,46,50,52,56,58,62,
   64,68,70,74,76,80,82,86,88,92,94],
 [12,14,17,20,22,26,28,32,34,38,40,44,46,50,52,56,58,62,
   64,68,70,74,76,80,82,86,88,92,94,98],
 [12,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,62,
   65,68,71,74,77,80,83,86,89,92,95],
 [12,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,62,
   65,68,71,74,77,80,83,86,89,92,95,98],
 [12,14,17,20,23,27,31,35,40,45,50,56,62,68,75,82,89,97,
   105,113,122,131,140,150,160,170,181,192],
 [12,14,17,20,23,28,34,41,50,60,72,87,105,127,154,186,225,
   272,329,398,482],
 [12,14,17,20,23,29,34,43,51,63,77,94,117,142,177,216,268,
   330,407],
 [12,14,17,20,23,29,35,45,55,70,86,109,139,176,225,283,361,
   457],
 [12,14,17,20,24,26,30,32,36,38,42,44,48,50,54,56,60,62,
   66,68,72,74,78,80,84,86,90,92,96],
 [12,14,17,20,24,26,30,32,36,38,42,44,48,50,54,56,60,62,
   66,68,72,74,78,80,84,86,90,92,96,98],
 [12,14,17,20,24,27,30,34,37,40,44,47,50,54,57,60,64,67,
   70,74,77,80,84,87,90,94,97,100,104],
 [12,14,17,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,
   80,84,88,92,96,100,104,108,112,116,120],
 [12,14,17,20,25,28,33,37,44,48,55,60,69,74,83,89,100,106,
   117,124,137,144,157,165,180,188,203,212],
 [12,14,17,20,25,28,34,39,45,51,59,65,74,82,91,100,111,
   120,132,143,155,167,181,193,208,222,237],
 [12,14,17,20,25,30,37,45,55,68,83,103,126,156,192,237,293,
   361,447],
 [12,14,17,20,25,30,38,48,61,78,99,129,166,216,278,362,470]
  ,[12,14,17,21,25,30,35,41,47,54,61,69,77,86,95,105,115,
   126,137,149,161,174,187,201,215,230,245],
 [12,14,17,21,25,31,36,44,50,60,67,79,87,101,110,126,136,
   154,165,185,197,219,232,256,270,296],
 [12,14,17,21,25,31,37,43,51,59,67,77,87,97,109,121,133,
   147,161,175,191,207,223,241,259,277],
 [12,14,17,21,25,31,39,48,60,73,91,112,139,172,212,263,324,
   402],
 [12,14,17,21,26,32,40,50,62,78,98,122,154,194,242,306,386,
   482],
 [12,14,17,21,26,32,40,50,63,79,100,126,160,202,257,325,414 
  ],[12,14,17,21,26,33,41,52,65,83,104,133,167,214,269,
   345,434],
 [12,14,17,21,26,34,44,56,74,96,126,166,218,288,380,502],
 [12,14,17,21,27,32,38,46,53,61,71,80,90,102,113,125,139,
   152,166,182,197,213,231,248,266,286],
 [12,14,17,21,27,32,40,49,61,76,93,116,142,177,218,270,334,
   412],
 [12,14,17,21,28,34,44,58,74,98,128,168,222,292,386,510],
 [12,14,17,22,26,33,38,47,53,64,71,84,92,107,116,133,143,
   162,173,194,206,229,242,267,281,308],
 [12,14,17,22,27,35,43,56,69,90,111,145,179,234,289,378,467 
  ],[12,15,16,17,17],
 [12,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
   32,33,34,35,36,37,38,39,40,41,42,43],
 [12,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
   32,33,34,35,36,37,38,39,40,41,42,43,44],
 [12,15,16,18,18],[12,15,16,18,19,19],
 [12,15,16,18,19,20,20],
 [12,15,16,18,19,20,22,23,24,26,27,28,30,31,32,34,35,36,
   38,39,40,42,43,44,46,47,48,50,51,52,54,55,56,58,59,60,
   62,63,64,66,67],
 [12,15,16,18,19,20,22,23,24,26,27,28,30,31,32,34,35,36,
   38,39,40,42,43,44,46,47,48,50,51,52,54,55,56,58,59,60,
   62,63,64,66,67,68],
 [12,15,16,18,19,21,22,24,25,27,28,30,31,33,34,36,37,39,
   40,42,43,45,46,48,49,51,52,54,55,57],
 [12,15,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
   48,50,52,54,56,58,60,62,64,66,68,70],[12,15,17,17],
 [12,15,17,19,20,22,24,26,29,33,35,38,42,44,47,51,53,56,
   60,62,65,69,71,74,78,80,83,87,89,92,96,98,101,105,107,
   110,114,116,119],
 [12,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,
   49,51,53,55,57,59,61,63,65,67,69,71],
 [12,15,17,19,22,24,26,29,31,33,35,38,40,42,45,47,49,51,
   54,56,58,61,63,65,67,70,72,74,77,79,81,83,86,88,90,93,
   95,97,99,102,104,106,109,111,113,115],
 [12,15,17,19,22,25,27,30,33,35,38,41,43,46,49,51,54,57,
   59,62,65,67,70,73,75,78,81,83,86,89,91,94,97,99,102,
   105,107,110,113,115,118],
 [12,15,17,19,23,26,28,31,34,36,38,41,44,46,48,51,54,56,
   58,61,64,66,68,71,74,76,78,81,84,86,88,91,94,96,98,
   101,104,106,108,111,114,116,118,121,124,126,128,131,134],
 [12,15,17,19,23,26,28,31,34,36,38,41,44,46,48,51,54,56,
   58,61,64,66,68,71,74,76,78,81,84,86,88,91,94,96,98,
   101,104,106,108,111,114,116,118,121,124,126,128,131,134,
   136],[12,15,17,20,21,22,22],[12,15,17,20,21,23,23],
 [12,15,17,20,22,25,27,30,32,35,37,40,42,45,47,50,52,55,
   57,60,62,65,67,70,72,75,77,80,82,85],
 [12,15,17,20,22,26,29,34,37,42,45,50,53,58,61,66,69,74,
   77,82,85,90,93,98,101,106,109,114,117,122,125,130,133,
   138,141,146,149,154,157,162,165,170,173,178,181,186],
 [12,15,17,20,23,28,33,40,47,57,67,82,97,119,141,173,205,
   252,299,368,437],
 [12,15,17,21,24,28,33,38,46,54,63,76,89,106,127,149,179,
   213,252,303,359,428],
 [12,15,17,21,25,29,33,37,41,45,49,53,57,61,65,69,73,77,
   81,85,89,93,97,101,105,109,113,117,121],
 [12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,
   66,69,72,75,78,81,84,87,90,93,96],
 [12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,
   66,69,72,75,78,81,84,87,90,93,96,99],
 [12,15,18,21,25,31,39,47,58,71,89,108,134,164,205,249,309,
   377,470],
 [12,15,18,21,25,31,39,49,61,75,93,114,141,173,214,263,325,
   399,493],
 [12,15,18,21,25,31,40,51,65,83,109,142,186,243,324,428],
 [12,15,19,24,29,35,41,49,56,65,73,84,93,105,115,129,140,
   155,167,184,197,215,229,249,264,285],
 [12,15,19,24,29,35,42,51,60,71,84,101,118,139,164,197,230,
   271,320,385,450],
 [12,15,19,24,29,36,42,51,58,69,77,90,99,114,124,141,152,
   171,183,204,217,240,254,279,294,321],
 [12,15,19,24,30,37,46,57,71,88,110,137,172,215,271,340,430 
  ],[12,15,19,24,30,38,49,64,82,107,140,186,243,323,427],
 [12,15,19,24,30,39,51,68,91,121,162,219,294,399,539],
 [12,15,20,25,32,40,50,62,78,96,120,147,184,225,280,342,426 
  ],[12,15,20,25,32,40,50,63,78,97,120,149,184,227,280,
   346,426],
 [12,15,20,25,32,40,51,64,82,104,134,172,223,289,377,492],
 [12,16,16],[12,16,17,17],[12,16,17,18,19,20,20],
 [12,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
   33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,
   51,52,53,54,55,56,57,58,59,60,61,62,63,64],
 [12,16,17,18,19,21,21],
 [12,16,17,18,19,21,22,23,24,26,27,28,29,31,32,33,34,36,
   37,38,39,41,42,43,44,46,47,48,49,51,52,53,54,56,57,58,
   59,61,62,63,64,66,67,68,69,71,72,73,74,76],
 [12,16,17,18,20,21,22,23,25,26,27,28,30,31,32,33,35,36,
   37,38,40,41,42,43,45,46,47,48,50,51,52,53,55,56,57,58,
   60,61,62,63,65,66,67,68,70,71,72,73,75,76],
 [12,16,18,18],[12,16,18,20,20],[12,16,18,20,21,21],
 [12,16,18,20,21,22,22],
 [12,16,18,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
   35,36,37,38,39,40,41,42,43,44,45,46],
 [12,16,18,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
   35,36,37,38,39,40,41,42,43,44,45,46,47],
 [12,16,18,20,21,22,24,25,26,27,28,30,31,32,33,34,36,37,
   38,39,40,42,43,44,45,46,48,49,50,51,52,54,55,56,57,58,
   60,61,62,63,64,66,67,68,69,70,72,73,74,75],
 [12,16,18,20,21,23,24,26,27,29,30,32,33,35,36,38,39,41,
   42,44,45,47,48,50,51,53,54,56,57,59],
 [12,16,18,20,22,23,24,24],[12,16,18,20,22,24,25,25],
 [12,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,
   50,52],
 [12,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,
   50,52,54,56,58],
 [12,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,
   50,52,54,56,58,60],
 [12,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,
   50,52,54,56,58,60,62,64,66,68,70,72],
 [12,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,
   50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80],
 [12,16,18,20,24,27,31,33,37,39,43,45,49,51,55,57,61,63,
   67,69,73,75,79,81,85,87,91,93],
 [12,16,18,20,24,27,31,33,37,39,43,45,49,51,55,57,61,63,
   67,69,73,75,79,81,85,87,91,93,97],
 [12,16,18,20,24,27,32,34,38,40,44,46,50,52,56,58,62,64,
   68,70,74,76,80,82,86,88,92,94],
 [12,16,18,20,24,27,32,34,38,40,44,46,50,52,56,58,62,64,
   68,70,74,76,80,82,86,88,92,94,98],
 [12,16,18,20,24,27,32,36,42,46,52,56,62,66,72,76,82,86,
   92,96,102,106,112,116,122,126,132],
 [12,16,18,21,23,25,26,28,29,31,32,34,35,37,38,40,41,43,
   44,46,47,49,50,52,53,55,56,58,59,61],
 [12,16,18,21,23,26,28,31,33,36,38,41,43,46,48,51,53,56,
   58,61,63,66,68,71,73,76,78,81,83],
 [12,16,18,21,24,25,25],
 [12,16,18,21,24,28,33,38,44,50,56,62,68,74,80,86,92,98,
   104,110,116,122,128,134,140,146,152,158],
 [12,16,18,22,22],[12,16,18,22,24,26,26],
 [12,16,18,22,24,26,30,32,34,38,40,42,46,48,50,54,56,58,
   62,64,66,70,72,74,78,80],
 [12,16,18,22,24,26,30,32,34,38,40,42,46,48,50,54,56,58,
   62,64,66,70,72,74,78,80,82],
 [12,16,18,22,24,28,30,34,36,40,42,46,48,52,54,58,60,64,
   66,70],
 [12,16,18,22,24,28,30,34,36,40,42,46,48,52,54,58,60,64,
   66,70,72,76,78,82,84,88,90,94,96],
 [12,16,18,22,24,28,30,34,36,40,42,46,48,52,54,58,60,64,
   66,70,72,76,78,82,84,88,90,94,96,100],
 [12,16,18,22,26,26],
 [12,16,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74,78,
   82,86],
 [12,16,18,22,26,32,38,48,58,74,90,116,142,184,226,294,362,
   472],
 [12,16,18,22,28,34,44,56,72,94,122,160,210,276,364,480],
 [12,16,20,21,22,22],[12,16,20,21,23,23],
 [12,16,20,22,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
   38,39,40,41,42,43,44,45,46,47,48,49],
 [12,16,20,22,25,26,27,27],
 [12,16,20,22,25,26,28,29,31,32,34,35,37,38,40,41,43,44,
   46,47,49,50,52,53,55,56,58,59,61],
 [12,16,20,22,25,27,30,32,35,37,40,42,45,47,50,52,55,57,
   60,62,65,67,70,72,75,77,80,82,85],[12,16,20,23,23],
 [12,16,20,23,26,29,32,35,38,41,44,47,50,53,56,59,62,65,
   68,71,74,77,80],
 [12,16,20,23,27,30,34,37,41,44,48,51,55,58,62,65,69,72,
   76,79,83,86,90,93,97,100,104,107],
 [12,16,20,23,27,32,35,39,44,47,51,56,59,63,68,71,75,80,
   83,87,92,95,99],[12,16,20,24,27,28,29,29],
 [12,16,20,24,28,30,33,35,38,40,43,45,48,50,53,55,58,60,
   63,65,68,70,73,75,78,80,83,85,88],
 [12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76],
 [12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,
   84],[12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,
   76,80,84,88],
 [12,16,20,24,28,33,36,41,45,49,53,58,61,66,70,74,78,83,
   86,91,95,99,103],
 [12,16,20,24,28,33,37,41,46,50,54,59,63,67,72,76,80,85,
   89,93,98,102,106],
 [12,16,20,24,28,34,41,52,64,79,96,121,149,185,225,282,345,
   428],
 [12,16,20,24,29,33,37,42,46,50,55,59,63,68,72,76,81,85,
   89,94,98,102,107],
 [12,16,20,24,29,34,40,46,53,60,68,76,85,94,104,114,125,
   136,148,160,173,186],
 [12,16,20,24,29,36,43,52,63,75,91,109,130,157,187,224,269,
   320,384,459],
 [12,16,20,24,30,40,54,72,96,126,168,222,296,392,522],
 [12,16,20,24,31,37,47,56,71,85,108,129,164,196,249,297,
   377,450],
 [12,16,20,24,31,37,48,57,73,87,112,133,170,202,259,307,
   392,465],
 [12,16,20,24,31,38,49,60,78,98,129,163,217,279,375,484],
 [12,16,20,24,31,38,51,62,83,103,142,176,243,305,428],
 [12,16,20,24,32,48,76,122,194,314,506],
 [12,16,20,26,32,39,46,55,63,73,82,94,104,117,128,143,155,
   171,184,202,216,235,250,271,287],
 [12,16,20,26,32,40,47,57,65,77,86,100,110,126,137,155,167,
   187,200,222,236,260,275,301,317],
 [12,16,20,26,33,40,48,57,67,77,88,100,113,126,140,155,171,
   187,204,222,241,260,280,301,323],
 [12,16,20,26,33,40,49,58,68,78,90,102,115,128,143,158,174,
   190,208,226,245,264,285,306,328],
 [12,16,20,26,36,51,73,103,145,205,289,409],
 [12,16,22,26,30,34,38,42,46,50,54,58,62,66,70,74,78],
 [12,16,22,26,34,42,50,58,68,80,90,102,114,130,142,158,172,
   192],[12,16,22,27,33,39,46,53,61,69,78,87,97,107,118,
   129],
 [12,16,22,28,34,40,46,52,58,64,70,76,82,88,94,100],
 [12,16,22,28,34,42,50,58,68,78,88,100,112,124,138,152,166,
   182,198,214,232,250,268,288],
 [12,16,22,28,36,44,54,64,76,88,102,116,132,148,166,184],
 [12,16,22,28,36,46,60,76,96,124,156,196,252,316,396,508],
 [12,16,22,28,38,50,64,82,106,136,174,222,284,362,462],
 [12,16,22,29,37,46,55,66,76,89,100,115,127,144,157,176],
 [12,16,22,29,38,49,63,81,104,133,170,217,277,353,450],
 [12,16,22,30,38,48,60,76,92,112,136,168,200,240,288,352,
   416],
 [12,16,22,30,38,50,60,76,88,108,122,146,162,190,208,240,
   260,296],
 [12,16,22,30,38,50,62,82,104,138,176,232,296,390,498],
 [12,16,22,30,40,52,68,88,114,146,188,240,308,392,502],
 [12,16,22,30,40,54,72,98,132,182,248,346,476],
 [12,16,22,30,41,57,80,111,156,218,305,428],
 [12,16,22,31,42,56,74,97,126,163,210,270,346,443],
 [12,16,22,32,42,56,74,104,134,176,230,320,410],
 [12,16,22,32,44,64,88,128,176,256,352,512],
 [12,16,22,32,46,66,96,140,204,298,436],[12,17,21,22,22],
 [12,17,21,23,23],[12,17,21,23,24,24],
 [12,17,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63],
 [12,17,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66,
   69,72,75,78,81,84,87,90,93],
 [12,17,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66,
   69,72,75,78,81,84,87,90,93,96],
 [12,17,21,25,29,33,37,41,45,49,53,57,61,65,69,73,77],
 [12,17,21,25,30,34,39,43,48,52,57,61,66,70,75,79,84],
 [12,17,21,26,34,44,60,80,112,152,216,296,424],
 [12,17,22,27,31,35,39,43,47,51,55,59,63,67,71,75,79,83,
   87,91,95,99,103,107,111,115,119],
 [12,17,22,27,31,36,41,45,50,55,59,64,69,73,78,83,87,92,
   97,101,106,111],
 [12,17,22,27,32,38,43,48,54,59,64,70,75,80,86,91,96,102,
   107,112,118,123],
 [12,17,22,27,34,41,49,58,67,78,88,101,112,127,139,156,169,
   188,202,223,238,261,277,302],
 [12,17,22,27,34,41,52,64,81,101,127,159,198,249,309,389,
   482],
 [12,17,22,27,34,43,54,69,86,107,130,160,197,242,295,359,
   440],
 [12,17,22,27,34,43,57,75,99,129,170,223,297,392,521],
 [12,17,22,28,34,40,48,58,71,87,109,136,167,206,254,314,
   384,472],
 [12,17,22,28,36,43,51,61,70,80,92,103,115,129,142,156,172,
   187,203,221,238],
 [12,17,22,28,36,45,55,68,84,102,124,152,185,224,273,333,
   404],
 [12,17,22,28,36,46,59,75,96,125,165,216,282,369,483],
 [12,17,22,28,36,46,60,81,111,149,201,278,386,532],
 [12,17,22,28,36,49,65,85,109,146,196,260,340,457],
 [12,17,22,29,37,46,56,67,79,92,106,121,137,154,172,191],
 [12,17,22,29,38,50,65,84,108,139,178,228,291,372,474],
 [12,17,22,29,38,52,72,96,127,172,234,313,417],
 [12,17,22,29,39,52,68,88,113,145,184,232,292,366,456],
 [12,17,22,30,38,48,58,70,82,96,110,126,142,160,178,198],
 [12,17,22,30,40,52,69,90,118,155,203,267,351,462],
 [12,17,22,30,40,55,74,101,135,185,251,346,469],
 [12,18,21,24,24],
 [12,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66],
 [12,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66,
   69],[12,18,21,25,25],
 [12,18,21,25,26,28,29,31,32,34,35,37,38,40,41,43,44,46,
   47,49,50,52,53,55],
 [12,18,21,25,28,31,34,37,40,43,46,49,52,55,58,61,64],
 [12,18,21,25,29,34,39,45,51,58,65,73],
 [12,18,21,25,29,34,39,45,51,58,65,73,81],
 [12,18,21,26,26],[12,18,21,26,28,30,30],
 [12,18,21,26,29,35,38,44,47,53,56,62,65,71,74,80,83],
 [12,18,21,26,31,39,47,60,73,94,115,149,183,238],
 [12,18,23,26,27,27],
 [12,18,23,26,29,32,35,38,41,44,47,50,53,56,59,62,65,68],
 [12,18,23,27,29,30,31,31],
 [12,18,23,27,30,31,33,34,36,37,39,40,42,43,45,46,48,49,
   51,52,54,55,57,58],
 [12,18,23,27,31,34,37,40,43,46,49,52,55,58,61,64,67],
 [12,18,23,27,32,37,43,49,56,63,71,79],
 [12,18,23,27,32,37,43,49,56,63,71,79,88],
 [12,18,23,28,32,35,40,44,47,52,56,59,64,68,71,76,80],
 [12,18,23,28,34,36,36],
 [12,18,23,28,34,40,46,52,58,64,70,76,82,88,94,100],
 [12,18,23,28,34,40,46,52,58,64,70,76,82,88,94,100,106],
 [12,18,23,28,36,45,58,75,97,127,166,218,287],
 [12,18,23,29,35,39,46,51,56,62,68,72,79,84,89],
 [12,18,23,29,36,41,46,51,57,64,69,74,79,85,92,97,102,107,
   113],[12,18,23,29,37,45,55,65,77,89,103,117],
 [12,18,23,29,38,49,65,85,112,148,195,258,341],
 [12,18,24,30,36,42,48,54,60,66,72,78,84,90,96,102],
 [12,18,24,30,38,50,68,92,123,161,208,267,344,445],
 [12,18,24,32,44,58,76,100,130,170,222,290,380,498],
 [12,18,24,32,44,60,81,107,139,178,228,293,378,487],
 [12,18,25,28,31,31],
 [12,18,25,28,34,37,43,46,52,55,61,64,70,73,79,82,88],
 [12,18,25,29,33,35,37,39,41,43,45,47,49,51,53,55,57,59,
   61,63,65,67,69,71],
 [12,18,25,29,36,41,50,56,67,74,87,95],
 [12,18,25,30,35,37,39,39],
 [12,18,25,32,39,46,53,60,67,74,81,88,95,102,109,116,123],
 [12,18,25,32,42,56,73,97,128,169,224,296,392],
 [12,18,25,33,44,51,61,72,79,89,100,107,117,128,135,145],
 [12,18,25,33,47,61,81,109,143,191,253,335],
 [12,18,25,33,47,61,81,109,143,191,253,335,445],
 [12,18,25,34,41,48,55,62,69,76,83,90,97,104,111,118,125],
 [12,18,25,34,44,61,82,109,147,195,260,346],
 [12,18,25,34,44,61,82,109,147,195,260,346,459],
 [12,18,26,36,39,42,43,45,45],
 [12,18,26,36,39,44,47,51,55,57,61,63,65,69,71,75,77,79,
   83,85,89,91,93,97,99,103,105,107,111,113,117,119],
 [12,18,26,36,48,62,80,102,128,160,200,248,306,378],
 [12,18,26,36,48,62,80,102,128,160,200,248,306,378,466],
 [12,18,26,36,48,64,84,110,144,188,246,322,422],
 [12,18,26,36,49,65,85,109,139,177,225,285,360,452],
 [12,18,26,36,49,68,92,124,167,223,298,397,528],
 [12,18,26,36,49,68,98,140,197,276,394],
 [12,18,26,36,49,68,98,140,197,276,394,556],
 [12,18,26,36,49,68,100,147,220,340,535],
 [12,18,26,36,49,69,94,130,171,241,339,494],
 [12,18,26,36,49,69,99,148,210,306,437],
 [12,18,26,36,49,73,102,142,191,277,387,560],
 [12,18,26,36,50,69,94,125,165,217,286,379,501],
 [12,18,26,36,50,70,100,146,218,332,514],
 [12,18,26,36,55,82,126,195,314,489],
 [12,18,26,38,49,63,82,98,118,143,163,189,220,244,276],
 [12,18,26,38,49,63,82,98,118,143,163,189,220,244,276,313],
 [12,18,26,38,49,63,82,98,119,145,165,192,224,248,281],
 [12,18,26,38,49,65,86,104,130,161,185,219,258,290,334],
 [12,18,26,38,49,65,90,116,159,218,288,394,523],
 [12,18,26,38,57,84,124,182,268,392,572],
 [12,18,26,38,59,85,124,183,278,412],
 [12,18,26,38,59,89,132,195,304,454],
 [12,18,26,38,59,90,140,222,354,551],
 [12,18,27,36,47,59,73,88,105,123,143,164],
 [12,18,27,36,49,64,85,109,143,182,237,300],
 [12,18,27,38,54,74,101,137,184,247,330,440],
 [12,18,27,38,56,79,113,156,219,303,423],
 [12,18,27,40,51,66,78,93,105,120,132,147],
 [12,18,27,40,57,81,114,162,228,324,456],
 [12,18,27,42,56,76,98,123,150,183,215,253],
 [12,18,27,42,62,95,142,217,326,496],
 [12,18,28,42,62,90,132,190,274,396,568],
 [12,18,28,42,62,92,134,196,284,412],
 [12,18,30,50,79,123,194,298,471],
 [12,18,30,50,83,131,216,350,557],[12,19,21,21],
 [12,19,21,23,25,25],[12,19,22,22],[12,19,22,23,23],
 [12,19,22,23,24,24],[12,19,22,24,26,26],
 [12,19,22,25,25],[12,19,23,23],
 [12,19,23,24,25,26,27,27],[12,19,23,25,25],
 [12,19,23,25,27,27],[12,19,23,26,26],[12,19,24,27,27],
 [12,19,25,25],[12,19,25,29,29],
 [12,19,25,33,44,54,66,81,95,111,130,148,168,191,213,237,
   264],
 [12,19,25,33,45,55,67,83,97,113,133,151,171,195,217,241,
   269],
 [12,19,26,33,44,55,66,81,96,111,130,149,168,191,214,237],
 [12,19,26,33,44,55,66,81,96,111,130,149,168,191,214,237,
   264],[12,19,27,29,29],
 [12,19,27,35,42,53,65,77,88,103,119,135,150,169,189,209,
   228,251,275,299],
 [12,19,27,36,46,57,69,82,96,111,127,144,162,181,201],
 [12,19,27,36,46,57,69,82,96,111,127,144,162,181,201,222],
 [12,19,27,36,46,57,70,85,102,121,142,166,194,226,262],
 [12,19,27,36,47,60,75,93,114,138,167,201,240,287,342],
 [12,19,27,36,47,61,77,95,115,137,161,187,215,245,277],
 [12,19,27,36,47,61,79,101,128,162,206,263,335,426],
 [12,19,27,36,47,63,86,119,165,229,317,437],
 [12,19,27,37,51,71,98,136,189,260,354,480],
 [12,19,27,38,54,78,110,155,219,307,429],
 [12,19,28,39,52,67,84,103,124,147,172,199],
 [12,19,28,39,53,70,91,112,137,162,191,220],
 [12,19,28,39,54,73,92,115,138,165,192,223],
 [12,19,28,41,57,77,104,140,186,245,321,421],
 [12,19,28,41,58,80,109,148,200,270,363,487],
 [12,19,28,41,58,81,112,153,207,280,377,506],
 [12,19,28,41,58,81,113,159,225,320,456],
 [12,19,28,42,61,86,120,167,231,319,439],
 [12,19,28,42,62,91,132,189,270,385,548],
 [12,19,28,42,63,94,138,201,291,419],
 [12,19,28,42,63,94,141,213,324,495],
 [12,19,28,42,66,107,176,285,464],
 [12,19,28,43,67,108,175,285,462],
 [12,19,28,45,80,137,241,431],
 [12,19,29,39,53,69,83,103,125,143,169,197,219,251,285,311],
 [12,19,29,41,55,71,89,109,131,155,181,209],
 [12,19,29,41,56,74,97,120,147,174,205,236],
 [12,19,29,43,68,103,157,236,364,545],
 [12,19,29,43,73,117,177,301,485],
 [12,19,29,45,61,83,105,133,161,195,229,269],
 [12,19,30,41,56,71,90,109,132,155,182,209],
 [12,19,30,43,58,75,94,115,138,163,190,219],
 [12,19,30,45,62,83,106,133,162,195,230,269],
 [12,19,30,46,63,85,108,136,165,199,234,274],
 [12,19,30,47,64,87,110,139,168,203,238,279],
 [12,19,31,43,59,75,95,115,139,163,191,219],
 [12,19,31,47,65,87,111,139,169,203,239,279],
 [12,19,31,47,68,101,151,223,333,495],
 [12,19,31,51,82,138,230,378,617],
 [12,19,32,46,65,85,110,136,167,199,236,274],
 [12,19,33,50,70,93,119,148,180,215,253,294],
 [12,19,33,54,98,192,392,796],[12,19,34,57,103,199,400],
 [12,19,35,52,84,143,246,433],[12,19,35,63,116,227,461],
 [12,19,36,61,113,199,354,632],
 [12,19,36,65,113,207,364,646],
 [12,19,36,65,119,215,384,688],[12,19,37,74,150,304,616],
 [12,19,37,74,150,312,664],[12,20,24,25,25],
 [12,20,24,25,26,26],
 [12,20,24,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
   41,42,43,44,45,46,47,48,49],[12,20,24,26,28,29,29],
 [12,20,24,26,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49,50],[12,20,24,26,28,30,31,31]
  ,[12,20,24,27,29,29],
 [12,20,24,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,
   57,59,61,63,65,67],[12,20,24,27,30,31,32,32],
 [12,20,24,28,31,34,37,40,43,46,49,52,55,58,61],
 [12,20,24,28,31,34,37,40,43,46,49,52,55,58,61,64],
 [12,20,24,28,32,34,36,37,38,39,40,41,42,43,44,45,46,47,
   48,49,50,51,52,53],[12,20,24,28,32,35,37,37],
 [12,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,84,
   88,92,96,100,104,108],[12,20,25,27,29,31,31],
 [12,20,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,
   57,59,61,63,65,67],[12,20,25,28,29,29],
 [12,20,25,28,29,30,30],[12,20,28,33,34,35,35],
 [12,20,28,33,35,36,36],
 [12,20,28,33,37,42,46,51,55,60,64,69,73,78,82,87,91,96,
   100,105,109,114,118,123,127],
 [12,20,28,33,39,43,49,53,59,63,69,73,79,83,89,93,99],
 [12,20,28,34,37,38,39,40,40],
 [12,20,28,34,37,40,43,44,44],
 [12,20,28,35,38,43,47,49,53,57,59,63,67,69,73,77,79,83,
   87,89,93,97,99],
 [12,20,28,35,41,50,58,68,78,90,103,116,131,146,164,180,
   200,218,241,260,285,306],
 [12,20,28,35,41,50,58,69,80,93,107,122,139,156,176,195,
   218,239,265,288,317,342],
 [12,20,28,35,43,49,57,63,71,77,85,91,99,105,113,119],
 [12,20,28,36,40,42,42],
 [12,20,28,36,44,52,60,68,76,84,92],
 [12,20,28,40,60,84,116,160,216,292],
 [12,20,28,40,60,88,126,176,246,344],[12,20,29,30,32,32],
 [12,20,29,33,41,45,53,57,65,69,77,81,89,93,101,105],
 [12,20,29,33,41,45,53,57,65,69,77,81,89,93,101,105,113],
 [12,20,30,41,55,70,88,107,129,152,178,205],
 [12,20,30,41,55,71,92,115,145,174,211,246],
 [12,20,30,42,55,71,88,108,129,153,178,206],
 [12,20,30,42,56,71,89,108,130,153,179,206],
 [12,20,30,42,59,75,96,116,141,165,194,222],
 [12,20,30,42,59,76,99,121,150,177,212,244],
 [12,20,30,44,63,82,104,131,158,188,223,258],
 [12,20,30,44,63,83,106,133,161,192,227,263],
 [12,20,30,44,63,84,108,135,164,196,231,268],
 [12,20,30,44,65,95,141,208,304,447],
 [12,20,30,44,78,148,299,615],
 [12,20,30,45,61,82,104,131,159,192,226,265],
 [12,20,30,45,61,83,108,139,176,215,262],
 [12,20,30,46,65,87,112,140,171,205,242],
 [12,20,30,46,65,88,115,145,180,217,260],
 [12,20,30,46,71,111,184,299,478],
 [12,20,30,46,72,115,191,316,510],
 [12,20,30,48,73,101,136,174,219,267,322],
 [12,20,30,48,74,106,144,188,238,294,356],
 [12,20,30,50,85,140,234,389,646],
 [12,20,30,50,85,146,244,409],
 [12,20,32,48,68,96,132,180,244,328],
 [12,20,32,48,70,98,136,188,258,350],
 [12,20,32,48,72,108,164,252,392,616],
 [12,20,32,54,90,158,286,514],[12,20,32,54,90,164,294,535]
  ,[12,20,32,60,108,197,359,644],
 [12,20,32,60,108,203,367,664],
 [12,20,34,48,67,87,112,138,169,201,238],
 [12,20,34,48,67,87,112,138,169,201,238,276],
 [12,20,34,50,72,94,122,150,184,218,258],
 [12,20,34,52,83,133,217,360,585],
 [12,20,34,54,86,122,168,218,278,342,416],
 [12,20,34,57,93,159,277,490],[12,20,34,58,99,160,272,456]
  ,[12,20,34,60,110,196,347,631],
 [12,20,34,61,99,177,301,546],
 [12,20,36,60,107,182,340,619],[12,20,36,66,128,231,427],
 [12,21,25,25],[12,21,25,26,26],[12,21,25,27,27],
 [12,21,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,
   57,59,61,63,65,67,69],
 [12,21,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,
   57,59,61,63,65,67,69,71],[12,21,25,28,30,30],
 [12,21,29,30,30],
 [12,21,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,
   61,63,65,67,69,71,73],
 [12,21,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,
   61,63,65,67,69,71,73,75],[12,21,29,32,34,34],
 [12,21,29,33,33],[12,21,29,34,38,38],[12,21,29,35,35],
 [12,21,30,42,55,71,88,108,129,153,178,206],
 [12,21,30,42,55,72,92,116,145,176,212,249],
 [12,21,30,42,57,75,94,116,139,165,192,222],
 [12,21,30,43,59,78,100,124,152,181,215],
 [12,21,30,43,59,78,100,124,152,181,215,249],
 [12,21,30,46,61,83,104,132,159,193,226,266],
 [12,21,30,46,63,87,110,140,169,205,240],
 [12,21,30,46,63,87,110,140,169,205,240,282],
 [12,21,30,46,65,98,145,225,343,527],
 [12,21,30,47,68,98,129,169,210,260,311],
 [12,21,32,39,43,50,54,61,65,72,76,83,87,94,98,105,109,
   116,120,127,131,138,142],
 [12,21,32,39,43,50,54,61,65,72,76,83,87,94,98,105,109,
   116,120,127,131,138,142,149],
 [12,21,32,45,60,79,100,123,148,175,206,239,274,311],
 [12,21,32,45,60,79,100,123,148,175,206,239,274,311,350],
 [12,21,32,45,60,79,100,123,152,183,218,251,286,327],
 [12,21,34,48,67,87,112,138,169,201,238,276],
 [12,21,34,48,67,88,116,147,186,229,277],
 [12,21,34,49,70,93,120,149,182,217,256],
 [12,21,34,49,71,95,125,157,195,235,281],
 [12,21,34,51,70,93,120,149,182,219,258,301],
 [12,21,34,52,77,114,175,266,414],
 [12,21,34,53,80,115,158,207,264,327,398],
 [12,21,34,54,81,127,198,317,511],
 [12,21,34,54,87,133,214,348,560],
 [12,21,34,54,89,148,237,389,638],
 [12,21,34,54,95,157,258,426],
 [12,21,34,58,87,139,222,349,571],
 [12,21,34,58,95,160,261,429],
 [12,21,38,59,81,112,147,181,226,275,321,380],
 [12,22,40,66,105,167,270,424],
 [12,22,40,66,111,192,339,613],
 [12,22,40,66,119,211,390,757],
 [12,22,40,66,123,210,389,667],
 [12,22,44,70,119,178,279,399,612],
 [12,22,44,70,125,186,306,458],[12,22,44,74,131,231,418],
 [12,22,44,74,131,247,468],[12,22,44,74,139,242,453],
 [12,22,44,78,133,216,335,503],
 [12,22,44,78,133,225,371,598],
 [12,22,44,78,139,208,322,461],[12,22,44,82,151,289,532],
 [12,22,44,82,159,308,589],[12,22,44,82,159,308,623],
 [12,24,40,60,84,112,144,180,220],
 [12,24,40,60,86,119,160,208,263],
 [12,24,40,62,91,124,161,202,247],
 [12,24,40,62,91,126,167,213,265],
 [12,24,40,62,92,126,164,206,252],
 [12,24,40,70,116,205,343,608],[12,24,40,76,135,241,403],
 [12,24,40,76,150,269,507],
 [12,24,42,65,92,123,158,197,240],
 [12,24,42,65,93,126,164,207,255],
 [12,24,42,65,95,133,180,235,298],
 [12,24,42,66,94,126,162,202,246],
 [12,24,42,67,100,140,187,240,300],
 [12,24,42,77,139,282,512],[12,24,42,80,144,278,479],
 [12,24,44,87,151,273,455],[12,24,44,87,151,292,513],
 [12,24,44,88,171,315,592],[12,24,46,86,188,426],
 [12,24,46,86,189,429],[12,24,46,87,192,435],
 [12,24,46,92,178,339,627],[12,24,48,88,168,340,695],
 [12,24,48,98,210,439],[12,24,50,93,184,369,763],
 [12,24,50,103,226,472],[12,24,52,117,253,602],
 [12,24,52,120,266,619],[12,24,54,118,250,527],
 [12,24,54,118,264,596],[12,24,54,131,289,669],
 [12,24,56,115,258,567],[12,24,58,133,319,747],
 [12,25,42,63,88,117,150,187],
 [12,25,42,63,88,117,150,187,228],
 [12,25,42,67,102,145,196,253],
 [12,25,42,71,98,141,178,235,282],
 [12,25,42,72,120,213,358,631],[12,25,42,73,155,340,803],
 [12,25,42,80,144,255,424],
 [12,25,43,65,91,121,155,193,235],
 [12,25,43,65,92,126,166,213,265],
 [12,25,43,66,94,127,165,208,256],
 [12,25,43,66,96,132,173,219,269],
 [12,25,43,66,96,135,183,241,308],
 [12,25,43,67,95,127,163,203,247],
 [12,25,43,67,96,129,166,207,252],
 [12,25,43,67,96,130,168,210,256],
 [12,25,43,73,110,160,218,289,367],
 [12,25,43,74,113,172,250,357,501],
 [12,25,43,74,113,172,257,390,608],
 [12,25,43,75,105,151,191,251,301],
 [12,25,43,76,138,241,436],[12,25,43,81,140,240,400],
 [12,25,44,70,100,134,172,214,260],
 [12,25,44,71,105,145,191,243,301],
 [12,25,44,71,105,146,194,249,311],
 [12,25,44,78,118,168,224,290,362],
 [12,25,44,79,123,188,272,377],
 [12,25,44,79,123,188,272,377,515],
 [12,25,44,84,159,273,504],[12,25,44,85,163,294,548],
 [12,25,46,73,106,145,190,241],
 [12,25,48,71,108,141,192,235,300],
 [12,25,48,81,137,237,416],[12,25,48,84,152,281,503],
 [12,25,48,84,162,296,545],[12,25,48,89,147,261,458],
 [12,25,48,92,162,305,558],[12,25,48,94,162,289,478],
 [12,25,48,96,183,334,619],
 [12,25,49,75,116,153,208,255,324],
 [12,25,49,79,119,165,221,283,355],
 [12,25,49,88,168,342,702],[12,25,49,89,160,269,474],
 [12,25,49,89,160,293,537],[12,25,49,90,166,300,551],
 [12,25,49,92,177,337,629],[12,25,49,96,198,384,782],
 [12,25,49,96,207,423],[12,25,49,99,213,439],
 [12,25,49,100,195,383,720],[12,25,49,100,216,450],
 [12,25,49,106,198,402],[12,25,49,106,226,466],
 [12,25,49,106,226,473],[12,25,49,106,231,493],
 [12,25,50,84,130,183,246,315,394],
 [12,25,50,95,180,333,608],[12,25,50,95,180,333,675],
 [12,25,50,95,205,456],[12,25,50,98,188,343,636],
 [12,25,51,83,127,175,235,299,375],
 [12,25,51,86,164,284,556],[12,25,51,95,176,323,581],
 [12,25,51,95,189,343,632],[12,25,51,103,186,351,635],
 [12,25,52,105,202,391,723],[12,25,52,105,213,438],
 [12,25,52,105,231,490],[12,25,52,105,238,556],
 [12,25,52,113,220,443],[12,25,52,116,274,612],
 [12,25,52,116,290,652],[12,25,52,123,248,527],
 [12,25,52,123,251,554],[12,25,52,123,278,607],
 [12,25,52,123,281,621],[12,25,53,78,117,158,213,272,339],
 [12,25,53,81,132,178,255,321,420],
 [12,25,53,82,121,162,213,266,329],
 [12,25,53,85,136,182,255,315,410],
 [12,25,56,91,156,216,335,436],
 [12,25,56,91,162,230,361,474],[12,25,56,91,171,282,527],
 [12,25,57,124,260,542],[12,25,60,123,283,640],
 [12,25,60,123,290,642],[12,25,60,123,297,671],
 [12,25,60,141,335,823],[12,25,60,141,351,890],
 [12,27,59,118,229,432],[12,27,59,123,279,654],
 [12,27,62,146,373,945],[12,27,69,143,341,724],
 [12,27,69,143,341,784],[12,27,69,167,407],
 [12,27,72,170,442],[12,27,72,170,456],
 [12,27,72,196,524],[12,27,72,196,534],
 [12,30,56,90,132,182,240],[12,30,56,90,132,184,246],
 [12,30,56,90,134,188,252],[12,30,56,92,138,192,254],
 [12,30,56,94,144,202,268],[12,30,56,108,252,628],
 [12,30,56,118,288,728],[12,30,56,119,292,734],
 [12,30,56,128,340,890],[12,30,56,128,340,892],
 [12,30,56,128,344,884],[12,30,58,94,138,190,250],
 [12,30,58,94,140,196,262],[12,30,58,96,144,200,264],
 [12,30,58,132,346,924],[12,30,60,98,144,198,260],
 [12,30,63,117,233,477],[12,30,63,126,271,633],
 [12,30,63,133,295,619],[12,30,63,152,385,969],
 [12,30,64,120,216,398,787],[12,30,64,120,238,483],
 [12,30,64,130,250,550],[12,30,64,130,290,738],
 [12,30,64,132,267,519],[12,30,64,134,295,617],
 [12,30,64,154,402],[12,30,66,124,222,406],
 [12,30,66,124,244,491],[12,30,66,136,322,822],
 [12,30,66,138,301,626],[12,30,66,168,458],
 [12,30,68,142,334,842],[12,30,68,156,382,962],
 [12,30,68,164,420],[12,30,68,172,464],
 [12,30,70,144,326,788],[12,30,70,146,292,601],
 [12,30,70,146,317,724],[12,30,70,161,392,954],
 [12,30,70,168,426],[12,30,70,176,474],
 [12,30,72,150,350,870],[12,30,72,155,307,604],
 [12,30,72,161,352,746],[12,30,72,161,353,750],
 [12,30,72,161,354,752],[12,30,72,162,356,752],
 [12,30,72,180,480],[12,30,73,157,310,609],
 [12,30,73,163,355,751],[12,30,74,159,315,616],
 [12,30,78,204,528],[12,30,79,206,517],
 [12,30,80,193,486],[12,30,80,198,485],
 [12,30,80,198,500],[12,30,82,196,443],
 [12,30,88,236,642],[12,30,90,240,650],
 [12,31,58,93,136,187,246],[12,31,58,93,136,188,250],
 [12,31,58,93,137,191,255],[12,31,58,94,140,196,260],
 [12,31,59,97,143,197,259],[12,31,64,109,166,235,316],
 [12,31,64,109,167,239,325],[12,31,64,109,167,239,326],
 [12,31,64,110,170,244,332],[12,31,64,110,170,245,333],
 [12,31,64,119,202,342,582],[12,31,64,119,209,375,680],
 [12,31,64,119,212,370,665],[12,31,64,119,221,404],
 [12,31,64,124,232,445],[12,31,64,124,243,467],
 [12,31,65,113,173,245,329],[12,31,65,113,174,247,332],
 [12,31,67,138,277,537],[12,31,67,139,270,511],
 [12,31,70,135,242,414],[12,31,70,135,242,430],
 [12,31,70,135,249,447],[12,31,70,135,251,464],
 [12,31,70,140,272,522],[12,31,70,140,273,527],
 [12,31,73,154,307,607],[12,31,73,155,313,605],
 [12,33,81,176,384,862],[12,33,81,186,435],
 [12,33,81,193,439],[12,33,81,200,547],
 [12,33,81,207,541],[12,33,86,218,577],
 [12,33,86,218,595],[12,33,86,228,569],
 [12,33,86,228,595],[12,33,86,233,638],
 [12,33,86,251,788],[12,33,91,222,525],
 [12,33,91,222,540],[12,33,91,222,555],
 [12,33,91,231,589],[12,33,96,274,760],
 [12,33,96,274,769],[12,35,77,153,311,665],
 [12,35,77,177,399,867],[12,35,87,221,497],
 [12,35,93,221,483],[12,36,80,160,288,504],
 [12,36,80,160,288,554],[12,36,80,160,322,681],
 [12,36,80,173,383,845],[12,36,80,182,405],
 [12,36,89,223,499],[12,36,94,223,486],
 [12,41,109,263,591],[15,15],[15,17,17],[15,17,18,18],
 [15,17,19,20,20],[15,17,19,20,21,21],
 [15,17,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
   35,36,37,38,39,40,41,42,43,44,45,46],
 [15,17,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
   35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,
   53,54,55,56,57,58,59,60,61,62,63,64,65,66],
 [15,17,19,21,22,23,23],[15,17,19,21,22,23,24,24],
 [15,17,19,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
   36,37,38,39,40,41,42,43,44,45,46,47],
 [15,17,19,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
   36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,
   54,55,56,57,58,59],[15,17,19,21,23,24,25,25],
 [15,17,19,21,23,25,27,28,29,30,31,32,33,34,35,36,37,38,
   39,40,41,42,43,44,45,46,47,48,49,50],
 [15,17,19,22,23,24,24],
 [15,17,19,22,23,25,26,28,29,31,32,34,35,37,38,40,41,43,
   44,46,47,49,50,52,53,55,56,58,59,61],
 [15,17,19,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,
   52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,
   88,90,92],
 [15,17,19,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,
   52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,
   88,90,92,94],
 [15,17,19,22,24,27,29,32,34,37,39,42,44,47,49,52,54,57,
   59,62,64,67,69,72,74,77,79,82,84],
 [15,17,19,22,24,27,30,33,36,39,42,45,48,51,54,57,60,63,
   66,69,72,75,78,81,84,87,90,93,96],
 [15,17,20,21,22,23,24,24],[15,17,20,21,22,24,25,25],
 [15,17,20,22,24,25,25],
 [15,17,20,22,24,27,29,31,34,36,38,41,43,45,48,50,52,55,
   57,59,62,64,66,69,71,73,76,78,80,83,85,87,90,92,94,97,
   99,101,104,106],
 [15,17,20,22,25,27,29,31,33,35,37,39,41,43,45,47,49,51,
   53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,
   89,91,93,95],
 [15,17,20,22,25,28,32,35,39,42,46,49,53,56,60,63,67,70,
   74,77,81,84,88,91,95,98,102,105],
 [15,17,20,22,25,28,32,35,39,42,46,49,53,56,60,63,67,70,
   74,77,81,84,88,91,95,98,102,105,109],
 [15,17,20,22,25,29,33,37,41,45,49,53,57,61,65,69,73,77,
   81,85,89,93,97,101,105,109,113,117],
 [15,17,20,22,26,28,31,34,36,40,42,45,48,50,54,56,59,62,
   64,68,70,73,76,78,82,84,87,90,92,96,98,101,104,106],
 [15,17,20,22,26,29,33,36,40,43,47,50,54,57,61,64,68,71,
   75,78,82,85,89,92,96,99,103,106,110],
 [15,17,20,23,24,24],[15,17,20,23,25,25],
 [15,17,20,23,25,27,30,32,34,37,39,41,44,46,48,51,53,55,
   58,60,62,65,67,69,72,74,76,79,81,83,86,88,90,93,95,97,
   100,102],
 [15,17,20,23,25,27,30,32,34,37,39,41,44,46,48,51,53,55,
   58,60,62,65,67,69,72,74,76,79,81,83,86,88,90,93,95,97,
   100,102,104],
 [15,17,20,23,25,28,30,34,36,40,42,46,48,52,54,58,60,64,
   66,70,72,76,78,82,84,88,90,94,96],
 [15,17,20,23,25,29,31,34,37,40,42,46,48,51,54,57,59,63,
   65,68,71,74,76,80,82,85,88,91,93],
 [15,17,20,23,26,28,31,34,36,39,42,44,47,50,52,55,58,60,
   63,66,68,71,74,76,79,82,84,87,90,92,95,98,100,103,106,
   108,111,114],
 [15,17,20,23,26,29,31,34,37,40,43,45,48,51,54,57,59,62,
   65,68,71,73,76,79,82,85,87,90,93,96,99,101,104,107],
 [15,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,62,65,
   68,71,74,77,80,83,86,89,92,95,98],
 [15,17,20,23,26,30,33,36,40,43,46,50,53,56,60,63,66,70,
   73,76,80,83,86,90,93,96,100,103],
 [15,17,20,23,26,30,33,36,40,43,46,50,53,56,60,63,66,70,
   73,76,80,83,86,90,93,96,100,103,106],
 [15,17,20,23,27,30,33,37,40,43,47,50,53,57,60,63,67,70,
   73,77,80,83,87,90,93,97,100,103],
 [15,17,20,23,27,30,33,37,40,43,47,50,53,57,60,63,67,70,
   73,77,80,83,87,90,93,97,100,103,107],
 [15,17,20,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,
   54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,
   90,92,94],
 [15,17,20,24,26,29,32,35,38,41,44,47,50,53,56,59,62,65,
   68,71,74,77,80,83,86,89,92,95,98],
 [15,17,21,22,24,24],
 [15,17,21,22,24,25,27,28,30,31,33,34,36,37,39,40,42,43,
   45,46,48,49,51,52,54,55,57,58,60,61],
 [15,17,21,23,27,29,33,35,39,41,45,47,51,53,57,59,63,65,
   69,71,75,77,81,83,87,89,93,95],
 [15,17,21,23,27,29,33,35,39,41,45,47,51,53,57,59,63,65,
   69,71,75,77,81,83,87,89,93,95,99],[15,18,18],
 [15,18,21,22,24,24],[15,18,21,22,24,25,25],
 [15,18,21,23,25,25],
 [15,18,21,23,27,29,33,35,39,41,45,47,51,53,57,59,63,65,
   69,71,75,77,81,83,87,89,93,95,99],
 [15,18,21,24,28,31,35,38,42,45,49,52,56,59,63,66,70,73,
   77,80,84,87,91,94,98,101,105,108],
 [15,18,21,24,28,31,35,38,42,45,49,52,56,59,63,66,70,73,
   77,80,84,87,91,94,98,101,105,108,112],
 [15,18,21,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,
   84,88,92,96,100,104,108,112,116],
 [15,18,21,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,
   84,88,92,96,100,104,108,112,116,120],[15,19,19],
 [15,19,23,26,29,31,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55],
 [15,19,23,26,29,31,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55,56],
 [15,19,23,26,29,32,35,38,41,44,47,50,53,56,59,62,65,68,
   71,74,77,80,83,86,89,92,95,98,101],
 [15,19,23,27,31,35,39,43,47,51,55,59,63,67,71,75,79,83,
   87,91,95,99,103,107,111,115,119,123],[15,20,20],
 [15,20,25,30,35,42,52,65,82,101,126,152,186,223,271,327,
   398,484],
 [15,20,25,30,35,42,52,66,83,103,127,154,186,224,271,329,
   400],
 [15,20,25,31,39,47,57,67,80,94,112,130,154,179,211,244,
   288,334,394,455],
 [15,20,25,31,39,47,57,68,82,96,114,133,158,184,217,252,
   298,345,406],
 [15,20,25,31,39,47,57,68,82,97,116,136,162,189,223,259,
   305,353,414],
 [15,20,25,31,39,47,58,69,84,99,119,139,165,192,227,263,
   310,358,421],
 [15,20,25,31,39,47,58,72,91,112,139,168,206,246,300,362,
   446],
 [15,20,25,31,39,48,60,73,90,108,131,155,187,222,269,320,
   388,461],
 [15,20,25,31,39,48,61,75,94,115,144,174,215,259,318,382,
   470],[15,20,25,31,39,48,61,77,100,127,165,209,273,348,
   455],[15,20,25,31,39,49,64,82,108,138,181,230,304,389,
   513],[15,20,25,32,41,54,68,88,112,143,183,231,295,375,
   474],[15,20,25,32,41,54,68,88,113,144,184,235,300,384,
   489],[15,20,25,32,41,54,69,89,113,145,186,237,303,385,
   493],[15,20,25,32,41,54,69,89,114,145,184,235,298,378,
   481],[15,20,25,32,41,54,69,90,117,152,199,260,341,448],
 [20,20],[20,22,22],[20,22,23,23],[20,22,23,24,24],
 [20,22,23,24,25,25],
 [20,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
   39,40,41,42,43,44,45,46,47,48,49],
 [20,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
   39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,
   57,58,59],
 [20,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
   39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,
   57,58,59,60],
 [20,22,23,24,25,27,28,29,31,32,33,35,36,37,39,40,41,43,
   44,45,47,48,49,51,52,53,55,56,57,59,60,61,63,64,65,67,
   68,69,71],
 [20,22,23,24,25,27,29,31,33,35,37,39,41,43,45,47,49,51,
   53,55,57,59,61,63,65,67,69,71],
 [20,22,23,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,
   54,56,58,60,62,64,66,68,70,72],[20,22,23,25,25],
 [20,22,23,25,26,27,29,30,31,33,34,35,37,38,39,41,42,43,
   45,46,47,49,50,51,53,54,55,57,58,59,61,62,63,65,66,67,
   69,70,71],
 [20,22,23,25,26,28,29,31,32,34,35,37,38,40,41,43,44,46,
   47,49,50,52,53,55,56,58,59,61],
 [20,22,23,25,26,28,29,31,32,34,35,37,38,40,41,43,44,46,
   47,49,50,52,53,55,56,58,59,61,62],
 [20,22,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,
   55,57,59,61,63,65,67,69,71,73],[20,22,24,24],
 [20,22,24,25,25],[20,22,24,25,26,26],
 [20,22,24,25,26,27,27],
 [20,22,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
   40,41,42,43,44,45,46,47,48,49,50],
 [20,22,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
   40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,
   58,59,60],
 [20,22,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
   40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,
   58,59,60,61],
 [20,22,24,25,26,28,29,30,32,33,34,36,37,38,40,41,42,44,
   45,46,48,49,50,52,53,54,56,57,58,60,61,62,64,65,66,68,
   69,70,72],[20,22,24,25,27,27],
 [20,22,24,25,27,28,30,31,33,34,36,37,39,40,42,43,45,46,
   48,49,51,52,54,55,57,58,60,61],
 [20,22,24,25,27,28,30,31,33,34,36,37,39,40,42,43,45,46,
   48,49,51,52,54,55,57,58,60,61,63],[20,22,24,26,26],
 [20,22,24,26,27,27],
 [20,22,24,26,27,29,30,32,33,35,36,38,39,41,42,44,45,47,
   48,50,51,53,54,56,57,59,60,62],
 [20,22,24,26,27,29,30,32,33,35,36,38,39,41,42,44,45,47,
   48,50,51,53,54,56,57,59,60,62,63],
 [20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,
   56,58,60,62,64,66,68,70,72,74],
 [20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,
   56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,
   92,94],
 [20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,
   56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,
   92,94,96],
 [20,22,24,26,29,32,35,38,41,44,47,50,53,56,59,62,65,68,
   71,74,77,80,83,86,89,92,95,98],
 [20,22,24,26,30,32,36,38,42,44,48,50,54,56,60,62,66,68,
   72,74,78,80,84,86,90,92,96],
 [20,22,24,26,30,32,36,38,42,44,48,50,54,56,60,62,66,68,
   72,74,78,80,84,86,90,92,96,98],[20,22,24,27,27],
 [20,22,24,27,28,29,29],
 [20,22,24,27,28,30,31,33,34,36,37,39,40,42,43,45,46,48,
   49,51,52,54,55,57,58,60,61,63],
 [20,22,24,27,28,30,31,33,34,36,37,39,40,42,43,45,46,48,
   49,51,52,54,55,57,58,60,61,63,64],
 [20,22,24,27,28,30,33,34,36,39,40,42,45,46,48,51,52,54,
   57,58,60,63,64,66,69,70,72,75,76,78,81,82,84,87,88,90,
   93,94,96],
 [20,22,24,28,30,34,36,40,42,46,48,52,54,58,60,64,66,70,
   72,76,78,82,84,88,90,94,96],
 [20,22,24,28,30,34,36,40,42,46,48,52,54,58,60,64,66,70,
   72,76,78,82,84,88,90,94,96,100],[20,22,25,26,26],
 [20,22,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
   41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,
   59,60,61,62],
 [20,22,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
   41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,
   59,60,61,62,63],[20,22,25,26,27,29,29],
 [20,22,25,27,28,29,29],
 [20,22,25,27,29,30,32,33,35,36,38,39,41,42,44,45,47,48,
   50,51,53,54,56,57,59,60,62,63],
 [20,22,25,27,29,30,32,33,35,36,38,39,41,42,44,45,47,48,
   50,51,53,54,56,57,59,60,62,63,65],
 [20,22,25,27,29,32,34,37,39,41,44,46,49,51,53,56,58,61,
   63,65,68,70,73,75,77,80,82,85,87,89,92,94,97],
 [20,22,25,27,30,32,35,37,40,42,45,47,50,52,55,57,60,62,
   65,67,70,72,75,77,80,82,85,87],[20,23,23],
 [20,23,24,24],
 [20,23,24,25,27,28,30,31,33,34,36,37,39,40,42,43,45,46,
   48,49,51,52,54,55,57,58,60,61],
 [20,23,24,25,27,28,30,31,33,34,36,37,39,40,42,43,45,46,
   48,49,51,52,54,55,57,58,60,61,63],[20,23,24,26,26],
 [20,23,25,25],[20,23,25,26,27,27],
 [20,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,
   57,59,61,63,65,67,69,71,73,75],
 [20,23,25,28,31,34,37,40,43,46,49,52,55,58,61,64,67,70,
   73,76,79,82,85,88,91,94,97],
 [20,23,25,28,31,34,37,40,43,46,49,52,55,58,61,64,67,70,
   73,76,79,82,85,88,91,94,97,100],[20,24,24],
 [20,24,26,26],[20,24,26,27,27],[20,24,26,27,28,28],
 [20,24,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
   42,43,44,45,46,47,48,49,50,51,52],
 [20,24,26,28,29,30,30],
 [20,24,26,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
   43,44,45,46,47,48,49,50,51,52],
 [20,24,26,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
   43,44,45,46,47,48,49,50,51,52,53],
 [20,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,
   58,60,62,64,66,68,70,72,74,76],[20,24,28,28],
 [20,24,28,29,30,32,32],[20,24,28,30,30],
 [20,24,28,30,31,32,32],[20,24,28,30,32,32],
 [20,24,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,
   60],[20,24,28,30,32,35,37,40,42,44,47,49,52,54,56,59,
   61,64,66,68,71,73,76,78,80,83,85,88,90,92,95,97,100],
 [20,24,28,30,33,35,37,38,38],
 [20,24,28,30,33,35,38,40,42,45,47,50,52,54,57,59,62,64,
   66,69,71,74,76,78,81,83,86,88,90,93,95,98,100],
 [20,24,28,30,33,35,38,40,43,45,48,50,53,55,58,60,63,65,
   68,70,73,75,78,80,83,85,88,90],
 [20,24,28,30,34,35,36,38,38],[20,24,28,31,32,32],
 [20,24,28,31,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
   65,66,67,68],
 [20,24,28,31,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
   65,66,67,68,69],
 [20,24,28,31,33,36,38,41,43,46,48,51,53,56,58,61,63,66,
   68,71,73,76,78,81,83,86,88,91],
 [20,24,28,31,33,37,38,40,41,43,44,46,47,49,50,52,53,55,
   56,58,59,61,62,64,65,67,68,70],
 [20,24,28,31,34,36,37,38,38],
 [20,24,28,31,34,36,38,39,41,42,44,45,47,48,50,51,53,54,
   56,57,59,60,62,63,65,66,68,69],[20,24,28,32,32],
 [20,24,28,32,34,36,36],[20,24,28,32,34,36,38,38],
 [20,24,28,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,
   62],[20,24,28,32,34,36,38,40,42,44,46,48,50,52,54,56,
   58,60,62,64,66,68,70,72,74,76],
 [20,24,28,32,35,38,41,44,47,50,53,56,59,62,65,68,71,74,
   77,80,83,86,89,92,95,98,101],[20,24,28,34,36,38,38],
 [20,24,28,34,36,40,42,46,48,52,54,58,60,64,66,70,72,76,
   78],[20,24,28,34,38,42,46,50,54,58,62,66,70,74,78,82,
   86,90,94,98,102,106,110,114],
 [20,24,28,34,38,42,48,52,58,62,66,72,76,82,86,90,96,100,
   106,110,114],
 [20,24,28,34,38,42,48,52,58,62,66,72,76,82,86,90,96,100,
   106,110,114,120],
 [20,24,28,34,38,44,48,54,58,64,68,74,78,84,88,94,98,104,
   108],
 [20,24,28,34,38,44,50,56,62,68,74,80,86,92,98,104,110,
   116,122],[20,24,30,32,34,36,38,38],
 [20,24,30,34,38,40,40],
 [20,24,30,34,38,44,48,52,58,62,66,72,76,80,86,90,94,100,
   104,108,114,118,122,128,132],
 [20,24,30,34,40,44,48,52,56,60,64,68,72,76,80,84,88,92,
   96,100,104,108,112,116,120],
 [20,24,30,34,40,46,54,60,68,74,82,88,96,102,110,116,124,
   130],[20,24,30,34,40,46,54,60,68,74,82,88,96,102,110,
   116,124,130,138],
 [20,24,30,34,42,46,52,58,62,70,74,80,86,90,98,102,108,
   114,118,126,130],
 [20,24,30,34,42,48,56,62,70,76,84,90,98,104,112,118,126,
   132],[20,24,30,34,42,48,56,62,70,76,84,90,98,104,112,
   118,126,132,140],[20,24,30,36,38,38],
 [20,24,30,36,40,44,50,54,58,64,68,72,78,82,86,92,96,100,
   106,110,114,120,124,128],
 [20,24,30,36,40,46,50,58,62,70,74,82,86,94,98,106,110,
   118,122],
 [20,24,30,36,40,48,52,58,64,70,74,82,86,92,98,104,108,116 
  ],[20,24,30,36,40,48,52,58,64,70,74,82,86,92,98,104,
   108,116,120],
 [20,24,30,36,42,48,52,58,64,70,76,80,86,92,98,104,108,
   114,120,126,132],
 [20,24,30,36,42,48,54,60,66,72,78,84,90,96,102,108,114,
   120],
 [20,24,30,36,42,48,54,60,66,72,78,84,90,96,102,108,114,
   120,126],
 [20,24,30,38,42,46,50,54,58,62,66,70,74,78,82,86,90,94,
   98,102,106,110,114,118],
 [20,24,30,38,42,48,54,60,66,72,78,84,90,96,102,108,114,
   120],
 [20,24,30,38,42,48,54,60,66,72,78,84,90,96,102,108,114,
   120,126],[20,24,32,34,38,38],
 [20,24,32,34,38,40,44,46,50,52,56,58,62,64,68,70,74,76,
   80],
 [20,24,32,36,44,48,56,60,68,72,80,84,92,96,104,108,116,
   120],
 [20,24,32,36,44,48,56,60,68,72,80,84,92,96,104,108,116,
   120,128],[20,25,25],[20,25,27,27],[20,25,27,29,29],
 [20,25,27,29,30,32,34,36,39,42,44,47,50,52,55,58,60,63,
   66,68,71,74,76,79,82,84,87,90,92,95,98,100,103,106,108,
   111],[20,25,27,29,31,31],
 [20,25,27,29,31,32,33,34,34],
 [20,25,27,29,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
   63,64,65,66],[20,25,27,29,32,34,35,36,36],
 [20,25,27,29,32,34,35,37,39,40,42,44,45,47,49,50,52,54,
   55,57,59,60,62,64,65,67,69,70,72,74,75,77,79,80,82,84,
   85,87,89],
 [20,25,27,29,32,34,36,38,41,43,45,47,50,52,54,56,59,61,
   63,65,68,70,72,74,77,79,81,83,86,88,90,92,95,97,99,
   101,104,106],
 [20,25,27,29,32,34,36,38,41,43,45,47,50,52,54,56,59,61,
   63,65,68,70,72,74,77,79,81,83,86,88,90,92,95,97,99,
   101,104,106,108],[20,25,27,30,30],
 [20,25,27,30,31,32,32],
 [20,25,27,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54],
 [20,25,27,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55],
 [20,25,27,30,31,33,33],
 [20,25,27,30,31,33,34,36,37,39,40,42,43,45,46,48,49,51,
   52,54,55,57,58,60,61,63,64,66],
 [20,25,27,31,33,35,39,41,43,47,49,51,55,57,59,63,65,67,
   71,73,75,79,81,83,87,89,91,95,97,99,103,105,107,111,
   113,115,119],[20,25,27,31,34,36,37,37],
 [20,25,27,31,34,36,38,40,42,44,46,48,50,52,54,56,58,60,
   62,64,66,68,70,72,74,76,78,80],
 [20,25,27,31,34,37,41,44,47,51,54,57,61,64,67,71,74,77,
   81,84,87,91,94,97,101,104,107],
 [20,25,27,31,34,37,41,44,47,51,54,57,61,64,67,71,74,77,
   81,84,87,91,94,97,101,104,107,111],
 [20,25,27,31,34,37,41,45,49,53,57,61,65,69,73,77,81,85,
   89,93,97,101,105,109,113,117,121],
 [20,25,27,31,34,38,43,48,56,64,73,86,99,116,137,159,189,
   223,262,313,369,438],
 [20,25,30,35,42,52,63,79,96,118,142,172,207,249,302,365,
   444],
 [20,25,30,35,42,52,64,79,96,116,139,165,198,237,285,341,
   409],[20,25,30,35,42,52,64,81,102,130,166,212,271,348,
   449],[20,25,30,35,42,53,66,84,106,135,172,220,281,360,
   462],[20,25,30,37,45,56,69,84,102,122,146,175,210,252,
   302,362,431],
 [20,25,30,37,45,56,69,84,102,122,147,175,211,252,303,362,
   432],[20,25,30,37,45,56,69,87,110,140,179,227,290,373,
   481],[20,25,30,37,45,56,70,88,112,144,184,238,308,400],
 [20,25,30,37,46,59,73,93,117,148,188,236,300,380,479],
 [20,25,30,37,46,59,73,93,118,149,189,240,305,389,494],
 [20,25,30,37,46,59,74,94,118,150,191,242,308,390,498],
 [20,25,30,37,46,59,74,94,119,150,189,240,303,383,486],
 [20,25,30,37,46,59,74,95,122,157,204,265,346,453],
 [20,25,31,38,45,53,61,70,79,89,99,111,122,135,147,161,174,
   189,203,220,235,253,269,288],
 [20,25,31,38,45,53,61,70,79,89,99,111,122,135,147,161,174,
   189,203,220,235,253,269,288,305],
 [20,25,31,38,45,53,61,70,80,91,103,117,131,147,164,183,
   204,228,253,282,312,346,383,425],
 [20,25,31,38,45,53,62,72,83,95,109,125,142,161,183,208,
   235,265,300,340,383,431],
 [20,25,31,38,45,54,62,73,82,95,105,120,131,148,160,179,
   192,213,227,250,265,290,306,333],
 [20,25,31,38,45,54,65,77,91,107,125,147,172,201,236,276,
   321,375,438],
 [20,25,31,38,45,54,65,79,95,115,139,168,200,240,287,346,
   414],
 [20,25,31,38,46,55,66,78,93,109,129,151,178,208,245,286,
   337,393,463],
 [20,25,31,38,46,56,67,80,95,113,134,160,190,225,266,314,
   371,439],
 [20,25,31,38,46,56,68,82,98,117,140,167,198,235,280,333,
   394,467],
 [20,25,31,38,46,57,71,87,109,134,167,206,258,318,399,492],
 [20,25,31,38,46,58,71,87,104,126,150,181,213,255,300,357,
   417],[20,25,31,38,46,58,72,91,111,137,166,202,242,294,
   353,431],
 [20,25,31,38,47,59,75,93,117,145,183,227,286,355,448],
 [20,25,31,38,47,59,75,94,119,149,188,236,297,371,466],
 [20,25,32,39,48,57,69,81,96,113,133,156,184,215,253,296,
   347,407],
 [20,25,32,39,48,57,69,82,98,116,138,161,192,222,263,304,
   358,413],
 [20,25,32,39,48,58,69,81,96,113,133,154,180,210,246,285,
   331,385,450],
 [20,25,32,39,48,58,70,83,100,117,140,163,194,225,266,307,
   362,417],
 [20,25,32,39,48,58,70,83,100,118,141,164,196,227,269,310,
   366,422],
 [20,25,32,39,48,58,70,84,99,117,138,161,191,224,264,310,
   364,426],
 [20,25,32,39,48,58,70,84,100,119,140,166,196,231,273,322,
   379,446],
 [20,25,32,39,48,58,70,85,100,120,141,166,197,232,274,324,
   381,448],[20,26,26],[20,26,27,27],
 [20,26,28,30,31,31],[20,26,28,30,31,32,33,33],
 [20,26,28,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
   63,64,65,66],
 [20,26,28,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
   63,64,65,66,67],[20,26,28,30,31,32,34,34],
 [20,26,28,30,32,33,34,34],
 [20,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,
   60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,
   96,98],
 [20,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,
   60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,
   96,98,100],[20,26,28,30,33,35,35],
 [20,26,28,30,33,35,36,37,38,38],
 [20,26,28,30,33,35,37,38,38],
 [20,26,28,30,33,35,38,40,42,45,47,50,52,54,57,59,62,64,
   66,69,71,74,76,78,81,83,86,88,90,93,95,98,100],
 [20,26,28,31,33,33],[20,26,28,31,33,34,34],
 [20,26,28,31,33,34,35,36,37,38,39,40,41,42,43,44,45,46,
   47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
   65,66,67,68],
 [20,26,28,31,33,35,36,38,39,41,42,44,45,47,48,50,51,53,
   54,56,57,59,60,62,63,65,66,68],
 [20,26,28,31,33,36,38,40,41,43,44,46,47,49,50,52,53,55,
   56,58,59,61,62,64,65,67,68,70],
 [20,26,28,31,33,36,38,41,43,46,48,51,53,56,58,61,63,66,
   68,71,73,76,78,81,83,86,88],
 [20,26,28,31,33,36,38,41,43,46,48,51,53,56,58,61,63,66,
   68,71,73,76,78,81,83,86,88,91],
 [20,26,28,31,34,37,40,43,46,49,52,55,58,61,64,67,70,73,
   76,79,82,85,88,91,94,97,100],[20,26,32,34,38,38],
 [20,26,32,36,40,40],
 [20,26,32,36,44,48,56,60,68,72,80,84,92,96,104,108,116,
   120],
 [20,26,32,36,44,48,56,60,68,72,80,84,92,96,104,108,116,
   120,128],
 [20,26,32,38,44,50,56,62,68,74,80,86,92,98,104,110,116,
   122,128,134,140,146,152,158,164,170],
 [20,26,32,38,44,51,60,71,85,99,119,139,167,193,231,269,
   325,376,452],
 [20,26,32,38,44,51,60,72,88,107,130,159,190,230,272,329,
   393,478],
 [20,26,32,38,46,52,60,66,74,80,88,94,102,108,116,122,130,
   136],
 [20,26,32,39,48,57,68,79,94,109,129,148,175,201,237,271,
   321,368,435],
 [20,26,32,39,48,57,68,80,94,110,129,150,175,204,237,276,
   321,374,435],
 [20,26,32,39,48,57,68,80,95,112,133,155,183,213,250,290,
   340,394,461],
 [20,26,32,39,48,57,69,81,97,113,134,156,184,214,252,292,
   343,396,464],
 [20,26,32,39,48,57,69,81,98,115,138,161,191,222,262,303,
   357,412],
 [20,26,32,39,48,57,69,82,98,115,136,158,187,218,257,299,
   352,408],
 [20,26,32,39,48,57,69,82,98,115,137,160,190,221,261,303,
   356,411],
 [20,26,32,39,48,57,69,82,98,116,138,162,191,223,262,305,
   357,414],
 [20,26,32,39,48,58,69,82,98,115,136,159,187,219,257,299,
   352,410],
 [20,26,32,39,48,58,69,82,98,116,137,161,190,223,261,304,
   356,414],
 [20,26,32,39,48,58,70,82,97,114,135,157,185,216,254,294,
   345,402],
 [20,26,32,39,48,58,71,85,103,122,148,173,209,245,297,349,
   423],[20,26,32,39,48,58,71,85,103,124,148,176,209,249,
   297,354,423],
 [20,26,32,39,48,58,71,87,107,129,156,185,222,263,316,378,
   457],[20,28,28],
 [20,28,36,42,48,52,56,58,60,62,64,66,68,70,72,74,76,78,
   80],[20,28,36,42,48,54,60,66,72,78,84,90,96,102,108,
   114,120,126],
 [20,28,36,44,52,60,68,76,84,92,100,108,116,124,132,140,
   148,156],[20,30,30],
 [20,30,40,52,68,84,104,124,150,178,214,250,298,348,412],
 [20,30,40,52,68,84,104,126,154,182,218,256,306,358,424],
 [20,30,40,52,68,84,104,126,154,184,222,262,314,368,436],
 [20,30,40,52,68,84,106,128,158,188,228,268,320,374,444],
 [20,30,40,52,68,86,110,136,170,206,252,300,364,434],
 [20,30,40,54,72,98,126,166,216,276,356,454],
 [20,30,40,54,72,98,126,166,216,278,358,460],
 [20,30,40,54,72,98,128,168,216,280,358,458],
 [20,30,40,54,72,98,128,168,216,280,362,464],
 [20,30,40,54,72,98,128,170,224,294,388,510],
 [20,30,40,54,72,100,134,180,238,314,416],
 [20,30,40,54,72,100,136,184,248,332,440],
 [20,30,40,54,72,100,136,184,250,332,444],
 [20,30,40,54,76,98,130,166,218,276,362,454],
 [20,30,40,54,76,100,134,172,230,294,386,488],
 [20,30,40,54,76,100,136,172,226,286,374,468],
 [20,30,40,54,76,100,136,178,240,306,404],
 [20,30,40,54,76,102,136,182,240,318,420],
 [20,30,40,54,76,104,140,185,245,326,430],
 [20,30,40,54,76,106,146,198,270,370,508],
 [20,30,42,56,72,90,110,134,162,194,230,272,322,380],
 [20,30,42,56,72,91,114,144,181,227,284,355,443],
 [20,30,42,56,74,98,130,173,230,306,407],
 [20,30,42,56,75,101,138,188,255,344,466],
 [20,30,42,56,75,102,137,183,244,327,434],
 [20,30,42,56,75,103,142,195,265,357,478],
 [20,30,42,58,80,109,146,194,257,340,450],
 [20,30,42,58,81,111,151,204,276,373,505],
 [20,30,42,58,81,111,154,213,295,413],
 [20,30,44,62,84,114,152,202,268,354,468],
 [20,30,44,62,85,114,150,198,259,337,435],
 [20,30,44,62,86,116,156,210,282,376,502],
 [20,30,44,62,86,118,160,216,288,382,504],
 [20,30,44,62,86,118,161,221,302,413],
 [20,30,44,62,86,119,164,229,318,446],[25,25],
 [25,27,27],[25,27,28,28],[25,27,29,29],
 [25,27,29,30,30],[25,27,29,30,31,31],
 [25,27,29,30,31,32,33,33],
 [25,27,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54],
 [25,27,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55],
 [25,27,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
   63,64,65,66,67,68,69,70,71,72,73,74,75],
 [25,27,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
   45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
   63,64,65,66,67,68,69,70,71,72,73,74,75,76],
 [25,27,29,31,31],[25,27,29,31,32,32],
 [25,27,29,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,
   46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
   64,65,66],
 [25,27,29,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,
   46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
   64,65,66,67],[25,27,29,32,32],[25,27,29,32,33,33],
 [25,27,29,32,33,34,35,35],[25,27,29,32,33,34,36,36],
 [25,27,29,32,33,35,36,38,39,41,42,44,45,47,48,50,51,53,
   54,56,57,59,60,62,63,65,66,68],
 [25,27,29,32,34,35,35],[25,27,29,32,34,35,36,36],
 [25,27,29,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,
   62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,
   98],[25,27,29,32,34,36,38,40,42,44,46,48,50,52,54,56,
   58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,
   94,96,98,100],
 [25,27,29,32,34,36,39,41,44,46,48,51,53,56,58,60,63,65,
   68,70,72,75,77,80,82,84,87,89,92,94,96,99,101],
 [25,27,29,32,34,37,38,39,41,43,46,47,48,50,52,55,56,57,
   59,61,64,65,66,68,70,73,74,75,77,79,82,83,84,86,88,91,
   92,93,95,97,100,101,102,104,106,109,110,111,113,115],
 [25,27,29,32,34,37,39,41,43,46,48,50,52,55,57,59,61,64,
   66,68,70,73,75,77,79,82,84,86,88,91,93,95,97,100,102,
   104,106,109,111,113,115,118,120,122,124,127],
 [25,27,29,32,34,37,39,42,44,47,49,52,54,57,59,62,64,67,
   69,72,74,77,79,82,84,87,89,92],
 [25,27,29,32,34,37,40,43,46,49,52,55,58,61,64,67,70,73,
   76,79,82,85,88,91,94,97,100],
 [25,27,29,32,34,37,40,43,46,49,52,55,58,61,64,67,70,73,
   76,79,82,85,88,91,94,97,100,103,106,109,112,115,118,121,
   124,127,130],
 [25,27,29,32,34,38,41,46,50,55,59,64,68,73,77,82,86,91,
   95,100,104,109,113,118,122,127,131],[25,27,31,31],
 [25,27,31,32,32],[25,27,31,32,33,34,34],
 [25,27,31,32,34,34],
 [25,27,31,32,34,35,37,38,40,41,43,44,46,47,49,50,52,53,
   55,56,58,59,61,62,64,65,67,68],[25,27,31,33,33],
 [25,27,31,33,35,35],[25,27,31,33,35,36,36],
 [25,27,31,33,35,36,38,39,41,42,44,45,47,48,50,51,53,54,
   56,57,59,60,62,63,65,66,68,69],
 [25,27,31,33,36,37,38,40,42,45,46,47,49,51,54,55,56,58,
   60,63,64,65,67,69,72,73,74,76,78,81,82,83,85,87,90,91,
   92,94,96,99,100,101,103,105,108,109,110,112,114,117],
 [25,27,31,33,36,38,40,41,43,44,46,47,49,50,52,53,55,56,
   58,59,61,62,64,65,67,68,70,71],
 [25,27,31,33,36,39,43,48,52,57,61,66,70,75,79,84,88,93,
   97,102,106,111,115,120,124,129,133],
 [25,27,31,33,37,39,43,45,49,51,55,57,61,63,67,69,73,75,
   79,81,85,87,91,93,97,99,103],[25,28,28],[25,29,29],
 [25,30,30],[25,30,32,32],[25,30,32,33,34,34],
 [25,30,32,33,34,35,35],
 [25,30,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,
   48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
   66],[25,30,32,33,34,35,36,37,38,39,40,41,42,43,44,45,
   46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
   64,65,66,67],[25,30,32,33,35,36,36],
 [25,30,32,33,35,36,37,37],
 [25,30,32,33,35,36,37,38,40,41,42,43,45,46,47,48,50,51,
   52,53,55,56,57,58,60,61,62,63,65,66,67,68,70,71,72,73,
   75,76,77,78,80,81,82,83,85],
 [25,30,32,33,35,36,37,38,40,41,42,43,45,46,47,48,50,51,
   52,53,55,56,57,58,60,61,62,63,65,66,67,68,70,71,72,73,
   75,76,77,78,80,81,82,83,85,86],
 [25,30,32,33,35,37,37],[25,30,32,33,35,37,38,38],
 [25,30,32,33,35,37,38,39,41,43,44,45,47,49,50,51,53,55,
   56,57,59,61,62,63,65,67,68,69,71,73,74,75,77,79,80,81,
   83,85,86,87,89,91,92,93,95],
 [25,30,32,33,35,37,38,40,42,43,45,47,48,50,52,53,55,57,
   58,60,62,63,65,67,68,70,72,73,75,77,78,80,82,83,85,87]
  ,[25,30,32,33,35,37,38,40,42,43,45,47,48,50,52,53,55,
   57,58,60,62,63,65,67,68,70,72,73,75,77,78,80,82,83,85,
   87,88],
 [25,30,32,33,35,38,39,41,44,45,47,50,51,53,56,57,59,62,
   63,65,68,69,71,74,75,77,80,81,83,86,87,89,92,93,95,98]
  ,[25,30,32,34,36,36],[25,30,32,34,36,37,38,39,39],
 [25,30,32,34,36,37,38,39,40,41,42,43,44,45,46,47,48,49,
   50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
   68,69],
 [25,30,32,34,38,41,43,46,49,51,53,56,59,61,63,66,69,71,
   73,76,79,81,83,86,89,91,93,96,99,101,103,106,109,111,
   113,116,119,121,123,126,129,131,133,136],
 [25,30,32,34,38,41,43,46,50,53,56,60,63,66,70,73,76,80,
   83,86,90,93,96,100,103,106,110,113,116,120,123,126,130,
   133,136,140],
 [25,30,37,42,49,56,67,78,93,110,131,155,185,216,258,299,
   354,410],
 [25,30,37,42,49,56,67,79,94,111,132,155,183,216,255,302,
   360,426],
 [25,30,37,42,49,56,67,79,94,112,133,156,185,216,256,303,
   360,429],
 [25,30,37,42,49,56,67,80,95,113,137,161,194,226,270,313,
   372,429],
 [25,30,37,42,49,56,67,80,95,114,135,160,189,224,265,315,
   377,449],
 [25,30,37,42,49,56,67,80,95,115,136,163,193,228,268,314,
   368,430],
 [25,30,37,44,53,62,73,86,101,118,137,160,187,218,253,294,
   343,400],
 [25,30,37,44,53,62,74,86,101,118,138,161,189,220,258,301,
   352,412],
 [25,30,37,44,53,62,74,87,103,121,143,166,197,227,268,309,
   363,418],
 [25,30,37,44,53,63,74,86,101,118,138,159,185,215,251,290,
   336,390,455],
 [25,30,37,44,53,63,74,87,102,120,140,163,190,222,259,301,
   350,408],
 [25,30,37,44,53,63,75,88,104,122,143,169,198,233,274,321,
   377,443],
 [25,30,37,44,53,63,75,88,105,122,145,168,199,230,271,312,
   367,422],
 [25,30,37,44,53,63,75,88,105,123,146,169,201,232,274,315,
   371,427],
 [25,30,37,44,53,63,75,89,104,122,143,166,196,229,269,315,
   369,431],
 [25,30,37,44,53,63,75,89,105,124,145,171,199,233,271,316,
   367,427],
 [25,30,37,44,53,63,75,89,105,124,145,171,201,236,278,327,
   384,451],
 [25,30,37,44,53,63,75,90,105,125,146,171,202,237,279,329,
   386,453],
 [25,30,37,44,53,63,75,90,106,126,148,174,204,238,278,324,
   377,438],[25,32,34,35,35],[25,32,34,35,36,36],
 [25,32,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,
   50,51,52,53,54,55,56,57,58],
 [25,32,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,
   50,51,52,53,54,55,56,57,58,59],[25,32,34,36,36],
 [25,32,34,36,37,37],[25,32,34,36,37,38,38],
 [25,32,34,36,37,38,40,41,42,44,45,46,48,49,50,52,53,54,
   56,57,58,60,61,62,64,65,66,68,69,70,72,73,74,76,77,78,
   80],[25,32,34,36,37,39,40,42,43,45,46,48,49,51,52,54,
   55,57,58,60,61,63,64,66,67,69,70],
 [25,32,34,36,38,38],[25,32,34,36,38,39,39],
 [25,32,34,36,38,39,41,43,44,46,48,49,51,53,54,56,58,59,
   61,63,64,66,68,69,71,73,74,76,78,79,81,83,84,86,88,89,
   91],[25,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,
   62,64,66,68,70,72,74,76,78,80],
 [25,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,
   66,68,70,72,74,76,78,80,82],
 [25,32,34,36,38,41,43,46,48,51,53,56,58,61,63,66,68,71,
   73,76,78,81,83,86,88,91],
 [25,32,34,36,38,41,43,46,48,51,53,56,58,61,63,66,68,71,
   73,76,78,81,83,86,88,91,93],[25,32,34,36,39,39],
 [25,32,34,36,39,41,44,46,49,51,54,56,59,61,64,66,69,71,
   74,76,79,81,84,86,89,91],
 [25,32,34,36,39,41,44,46,49,51,54,56,59,61,64,66,69,71,
   74,76,79,81,84,86,89,91,94],[25,32,35,38,39,39],
 [25,32,35,38,39,40,42,44,47,49,52,54,57,59,62,64,67,69,
   72,74,77,79,82,84,87,89],[25,32,35,38,40,41,41],
 [25,32,35,38,40,41,42,42],
 [25,32,35,38,40,43,46,48,49,49],
 [25,32,35,38,41,43,46,48,50,52,54,57,59,62,64,66,68,70,
   73,75,78,80,82,84,86,89,91,94,96,98,100,102,105,107,
   110,112,114],
 [25,32,35,38,41,45,49,54,58,63,67,72,76,81,85,90,94,99,
   103,108,112],
 [25,32,35,38,42,47,52,57,62,67,72,77,82,87,92,97,102,107,
   112,117,122],[25,32,36,40,41,41],
 [25,32,36,40,42,43,44,44],[25,32,36,40,42,44,45,45],
 [25,32,36,40,43,46,48,50,52,54,56,58,60,62,64,66,68,70,
   72,74,76],
 [25,32,36,40,43,46,48,50,52,54,56,58,60,62,64,66,68,70,
   72,74,76,78],[25,32,36,41,42,42],
 [25,32,36,41,43,43],[25,32,36,41,43,45,46,46],
 [25,32,36,41,43,45,46,48,49,51,52,54,55,57,58,60,61,63,
   64,66,67,69,70,72,73,75,76],[25,32,36,41,44,45,47,47]
  ,[25,32,36,41,44,46,48,48],
 [25,32,36,41,44,47,49,51,52,54,55,57,58,60,61,63,64,66,
   67,69,70,72,73,75,76,78,79],
 [25,32,36,41,44,47,49,52,54,57,59,62,64,67,69,72,74,77,
   79,82,84,87,89,92,94,97],
 [25,32,36,41,44,47,50,53,56,59,62,65,68,71,74,77,80,83,
   86,89,92,95,98,101,104],
 [25,32,36,41,44,48,50,52,54,56,58,60,62,64,66,68,70,72,
   74,76,78],
 [25,32,36,41,44,48,50,52,54,56,58,60,62,64,66,68,70,72,
   74,76,78,80],
 [25,32,36,41,45,48,50,51,52,53,54,55,56,57,58,59,60,61,
   62,63,64,65,66,67,68,69,70],
 [25,32,36,41,45,48,51,52,53,53],
 [25,32,36,41,45,48,51,54,57,60,63,66,69,72,75,78,81,84,
   87,90,93,96,99,102,105],
 [25,32,36,41,45,48,52,55,59,63,66,70,73,77,81,84,88,91,
   95,99,102,106],
 [25,32,36,41,45,48,52,55,59,63,66,70,73,77,81,84,88,91,
   95,99,102,106,109],[25,32,36,41,45,49,51,51],
 [25,32,36,41,45,49,53,57,61,65,69,73,77,81,85,89,93,97,
   101,105,109],
 [25,32,36,41,45,50,54,59,63,68,72,77,81,86,90,95,99,104,
   108,113,117],
 [25,32,36,41,46,50,56,61,66,72,77,82,88,93,98,104,109,
   114,120,125],
 [25,32,36,41,46,50,56,61,66,72,77,82,88,93,98,104,109,
   114,120,125,130],
 [25,32,36,42,44,46,47,49,50,52,53,55,56,58,59,61,62,64,
   65,67,68,70,71,73,74,76,77],
 [25,32,36,42,45,48,51,54,57,60,63,66,69,72,75,78,81,84,
   87,90,93,96,99,102,105],
 [25,32,36,42,45,49,51,55,57,61,63,67,69,73,75,79,81,85,
   87,91,93,97,99,103,105,109],
 [25,32,36,42,46,49,53,56,60,64,67,71,74,78,82,85,89,92,
   96,100,103,107],
 [25,32,36,42,46,49,53,56,60,64,67,71,74,78,82,85,89,92,
   96,100,103,107,110],
 [25,32,36,42,46,50,52,54,55,57,58,60,61,63,64,66,67,69,
   70,72,73,75,76,78,79,81,82],[25,32,36,42,46,51,54,54]
  ,[25,32,36,42,46,52,56,62,66,72,76,82,86,92,96,102,106,
   112,116,122],
 [25,32,36,42,46,52,56,62,66,72,76,82,86,92,96,102,106,
   112,116,122,126],
 [25,32,36,42,46,52,57,62,67,72,77,83,87,93,97,103,108,
   113,118,123,128,134],
 [25,32,36,42,47,53,58,65,71,76,83,89,94,101,107,112,119,
   125,130,137],
 [25,32,38,44,50,56,62,68,74,80,86,92,98,104,110,116,122,
   128,134,140,146,152,158,164,170],
 [25,32,38,44,51,60,72,84,99,116,137,158,186,216,254,294,
   345,400],
 [25,32,38,44,51,60,72,85,100,116,136,159,187,217,254,295,
   345,400],
 [25,32,38,44,51,60,72,85,100,118,139,163,192,224,263,306,
   357,414],
 [25,32,38,44,51,60,73,89,108,130,156,185,221,260,312,373,
   449],
 [25,32,39,47,55,64,73,83,93,104,116,129,142,156,170,185,
   200,216,233,251,269,288,307],
 [25,32,39,47,55,64,73,83,94,106,118,132,145,160,174,190,
   206,224,241,261,279,300,319],
 [25,32,39,47,55,64,73,83,94,107,121,137,153,171,190,212,
   236,264,293,326,360,399,441],
 [25,32,39,47,55,64,73,84,95,108,121,137,152,171,189,212,
   234,262,288,322,353,394,432],
 [25,32,39,47,55,65,74,86,96,110,121,137,149,167,180,200,
   214,236,251,275,291,317,334],
 [25,32,39,47,55,65,75,86,97,109,121,135,148,164,179,196,
   212,230,247,267,285,307,327],
 [25,32,39,47,56,65,76,87,101,115,132,150,172,194,221,249,
   284,319,362,407],
 [25,32,39,47,56,66,76,87,99,112,127,144,162,182,203,226,
   252,281,313,349,387,429],
 [25,32,39,47,56,66,77,89,102,116,131,147,164,182,201,221,
   242,264,287,311,336,362,389],
 [25,32,39,47,56,66,78,91,108,125,148,171,202,233,275,317,
   375,432],
 [25,32,39,47,56,66,79,93,111,130,154,180,212,247,291,339,
   400],[25,32,39,47,56,67,79,94,110,130,152,179,209,246,
   287,338,394,464],[25,35,35],[25,35,39,39],
 [25,35,39,43,47,47],[25,35,39,43,47,49,51,53,53],
 [25,35,39,43,47,49,51,53,55,57,59,61,63,65,67,69,71,73,
   75,77,79,81,83,85,87],
 [25,35,39,43,49,51,53,55,59,61,63,65,69,71,73,75,79,81,
   83,85,89,91,93,95,99,101,103,105,109,111],
 [25,35,39,43,49,53,55,57,57],
 [25,35,39,43,49,53,55,57,59,61,63,65,67,69,71,73,75,77,
   79,81,83,85,87,89,91],
 [25,35,39,43,49,53,55,59,63,65,69,73,75,79,83,85,89,93,
   95,99,103,105,109,113,115],
 [25,35,39,43,49,53,57,63,67,71,75,81,85,89,95,99,103,107,
   113,117,121,127,131,135,139,145],
 [25,35,39,43,51,57,61,67,73,77,81,87,93,97,101,107,113,
   117,121,127,133,137,141,147,153,157,161,167],
 [25,35,39,43,51,57,61,67,75,81,87,95,101,107,115,121,127,
   135,141,147,155,161,167],
 [25,35,39,43,51,57,61,67,75,81,87,95,101,107,115,121,127,
   135,141,147,155,161,167,175],
 [25,35,45,59,77,103,131,171,219,281,361,457],
 [25,35,45,59,77,103,133,173,223,285,363,465],
 [25,35,45,59,77,105,139,185,245,321,421],
 [25,35,45,59,77,105,141,189,251,341,463],
 [25,35,45,59,77,105,141,191,259,343,463],
 [25,35,49,63,81,99,123,147,179,213,255,301,359,419],
 [25,35,49,63,81,99,123,149,179,215,255,301,359,421],
 [25,35,49,63,81,101,123,147,177,211,251,293,345,405],
 [25,35,49,63,81,101,125,151,183,217,259,307,365,431],
 [25,35,49,63,81,101,125,151,183,219,261,313,371,441],
 [25,35,49,63,81,101,125,151,185,221,267,313,377,439],
 [25,35,49,63,81,101,125,153,183,221,263,313,373,443],
 [25,35,49,63,81,101,125,153,187,223,271,317,383,445],
 [25,35,49,63,81,101,125,155,185,225,267,317,379,449],
 [25,35,49,63,81,101,125,155,187,227,271,323,383,451],
 [25,35,49,67,89,119,157,207,273,359,473],
 [25,35,49,67,90,119,155,203,264,342,440],
 [25,35,49,67,91,121,161,215,287,381,507],
 [25,35,49,67,91,123,165,221,293,387,509],
 [25,35,49,67,91,123,166,226,307,418],
 [25,35,49,67,91,124,169,234,323,451],
 [25,37,49,61,73,85,97,109,121,133,145,157,169,181],
 [25,37,49,61,75,93,115,141,172,210,256,311,378],
 [25,37,49,61,75,93,116,143,176,217,266,327,401],
 [25,37,49,61,75,93,117,145,179,220,270,331,405],
 [25,37,49,61,75,93,118,151,193,248,323,425],
 [25,37,49,61,75,93,118,151,194,249,323,425],
 [25,37,49,63,81,102,126,155,190,232,282,342,416],
 [25,37,49,63,81,103,128,158,193,236,287,348,422],
 [25,37,49,63,81,103,130,163,206,263,339,440],
 [25,37,49,63,81,104,133,169,216,279,364,478],
 [25,37,49,63,81,104,133,170,218,282,368,484],
 [25,37,51,67,85,105,127,153,183,217,255,299,351],
 [25,37,51,67,85,105,129,157,189,225,267,317,375],
 [25,37,51,67,85,106,130,159,193,233,281,339,409],
 [25,37,51,67,85,106,131,161,196,238,289,351,425],
 [25,37,51,67,85,107,131,159,191,229,273,323,381],
 [25,37,51,67,86,108,134,165,202,246,299,363,441],
 [25,37,51,67,86,108,135,169,212,266,336,428],
 [25,37,51,67,86,109,135,167,206,253,309,377,461],
 [25,37,51,67,86,109,138,174,220,279,357,458],
 [25,37,51,67,87,109,133,161,195,235,279,329,389],
 [25,37,51,67,87,111,140,177,225,287,366,471],
 [25,37,51,67,87,113,149,201,279,399,587],[25,39,45,45],
 [25,39,45,48,48],[25,39,45,48,49,50,50],
 [25,39,45,49,49],[25,39,45,51,51],[25,39,47,47],
 [25,39,47,52,52],[25,39,49,49],[25,39,49,56,59,59],
 [25,39,49,58,65,70,74,74],
 [25,39,49,58,65,70,74,75,76,76],[25,39,49,59,62,65,65],
 [25,39,49,59,63,66,67,67],[25,39,50,52,52],
 [25,39,51,51],[25,39,51,58,63,64,64],
 [25,39,51,58,63,64,65,65],[25,39,51,59,66,73,78,78],
 [25,39,51,61,68,73,76,76],[25,39,51,65,70,74,74],
 [25,39,51,65,70,74,75,76,76],[25,39,52,59,66,73,76,76],
 [25,39,52,59,66,76,79,79],[25,39,53,60,65,65],
 [25,39,53,66,72,76,78,78],[25,39,53,66,73,78,78],
 [25,39,53,67,89,111,133,163,193,223,261,299,337],
 [25,39,53,67,89,111,133,163,193,223,261,299,337,383],
 [25,39,53,68,73,76,76],
 [25,39,53,75,97,127,157,195,233,279,325],
 [25,39,53,75,100,128,170,218,287,378,477],
 [25,39,53,75,103,144,200,259,344,447],
 [25,39,54,65,71,73,74,74],[25,39,54,65,71,73,74,76,76],
 [25,39,55,62,68,68],[25,39,55,65,72,79,82,82],
 [25,39,55,68,74,76,76],[25,39,55,72,78,82,82],
 [25,39,55,76,105,148,204,266,354,457],
 [25,39,55,77,101,131,165,205,249,299,351],
 [25,39,55,77,103,135,169,209,251,299,349],
 [25,39,55,78,100,126,163,199,242,280,326,383],
 [25,39,55,88,122,177,255,361,514],
 [25,39,55,88,130,202,293,422],[25,39,56,66,76,79,79],
 [25,39,56,70,91,97,97],
 [25,39,56,70,92,117,139,169,202,232,270,311,349],
 [25,39,56,70,92,117,139,169,202,232,270,311,349,395],
 [25,39,56,70,95,122,144,179,216,246,291,338,376],
 [25,39,56,73,76,76],[25,39,56,73,79,79],
 [25,39,57,71,93,119,141,171,205,235,273,315,353],
 [25,39,57,71,93,119,141,171,205,235,273,315,353,399],
 [25,39,57,72,79,82,82],
 [25,39,57,79,105,135,169,207,249,295,345],
 [25,39,57,89,119,163,205,261,315,383],
 [25,39,57,89,119,163,205,261,315,383,449],
 [25,39,57,89,134,207,300,432],[25,39,59,73,85,85],
 [25,39,59,81,109,139,175,213,257,303,355],
 [25,39,59,82,106,134,171,211,254,294,342,399],
 [25,39,59,89,121,163,207,261,317,383],
 [25,39,59,89,121,163,207,261,317,383,451],
 [25,39,59,93,125,171,215,273,329,399],
 [25,39,59,94,142,224,334,483],
 [25,39,60,86,112,152,200,246,319,418],
 [25,39,60,89,144,196,291,421],
 [25,39,60,92,125,169,214,270,327,395],
 [25,39,60,92,125,177,244,308,403],
 [25,39,60,92,128,174,224,284,348,422],
 [25,39,60,93,134,191,258,360,479],
 [25,39,60,94,139,199,285,404],
 [25,39,60,94,144,223,333,477],
 [25,39,60,96,144,215,302,435],
 [25,39,61,93,127,171,217,273,331,399],
 [25,39,63,100,154,226,322,441],[25,39,67,127,247,495],
 [25,40,57,80,111,151,199,264,345,448],
 [25,40,57,80,111,152,202,266,346,450],
 [25,40,57,80,111,152,203,272,361,478],
 [25,40,57,80,112,157,213,284,374,493],
 [25,40,57,80,112,157,215,294,396,529],
 [25,40,57,80,112,159,223,314,446],
 [25,40,61,88,121,166,223,298,397,526],
 [25,40,61,88,122,165,220,289,378,492],
 [25,40,61,88,122,166,221,290,380,493],
 [25,40,61,88,123,166,222,291,381,496],
 [25,40,61,88,123,167,223,292,383,497],
 [25,40,61,88,124,170,230,308,409],
 [25,40,61,88,124,170,231,309,411],
 [25,40,61,88,124,170,233,314,419],
 [25,40,61,88,124,171,230,308,410],
 [25,40,61,88,124,171,231,309,412],
 [25,40,61,88,124,171,234,315,423],
 [25,40,61,88,124,175,244,343,481],
 [25,42,54,58,62,70,76,78,82,84,86,90,92,94,98,100,102,
   106,108,110,114,116,118],
 [25,42,54,62,70,80,88,98,106,116,124,134,142,152,160,170,
   178],[25,42,54,62,72,82,90,102,112,120,130,140,150,160,
   170,178,188,200,208],
 [25,42,54,62,72,82,92,104,114,122,132,146,158,168,176,186,
   200,212,222],[25,42,56,58,59,60,60],
 [25,42,56,58,59,61,61],[25,42,56,62,68,68],
 [25,42,56,62,69,70,71,72,72],
 [25,42,56,62,69,71,72,73,73],
 [25,42,56,62,69,74,80,84,90,94,100,104,110,114,120],
 [25,42,56,62,69,74,80,84,90,94,100,104,110,114,120,124],
 [25,42,56,62,69,75,81,85,91,95,101,105,111,115,121,125],
 [25,42,58,66,70,78,82,84,88,90,90],
 [25,42,58,70,80,88,92,96,98,98],
 [25,42,58,70,80,88,92,98,104,108,114,120,124,130,136,140,
   146,152,156,162,168],
 [25,42,58,70,82,98,112,126,142,156,170,186,200,214,230,244]
  ,[25,42,58,70,82,98,112,126,142,158,174,190,206,222,238,
   254],[25,42,60,70,77,78,79,81,82,83,83],
 [25,42,60,70,77,78,79,81,82,84,84],
 [25,42,60,71,80,82,83,84,84],
 [25,42,60,75,89,98,110,118,130,138,150,158,170,178],
 [25,42,60,75,89,99,111,119,131,139,151,159,171,179],
 [25,42,60,75,92,97,97],[25,42,60,75,92,99,99],
 [25,42,60,76,93,104,120,130,146,156,172,182,198,208],
 [25,42,60,79,103,118,137,150,168,180,198,210,228],
 [25,42,60,79,104,126,156,189,224,253,292,336],
 [25,42,60,79,104,130,162,194,231,269,312],
 [25,42,60,79,104,130,162,194,231,269,312,355],
 [25,42,63,89,119,171,241,329,427],
 [25,42,63,95,131,171,217,269,325,394,475],
 [25,42,63,95,131,174,234,316,412],
 [25,42,63,95,135,191,252,343,458],
 [25,42,63,95,135,204,317,479],
 [25,42,63,95,139,200,280,398,562],
 [25,42,63,97,139,192,260,370,488],
 [25,42,63,97,140,206,290,423],
 [25,42,63,97,140,207,308,453],
 [25,42,63,97,140,214,330,515],
 [25,42,63,97,143,209,292,410],
 [25,42,63,97,143,213,309,483],
 [25,42,63,103,157,238,349,503],
 [25,42,63,103,161,250,364,521],
 [25,42,63,103,164,256,381,563],
 [25,42,63,103,167,261,379,554],[25,42,63,103,167,296,540],
 [25,42,64,92,128,169,217,270,330,395],
 [25,42,64,97,146,205,290,390,539],
 [25,42,64,97,146,210,309,439],
 [25,42,64,97,146,220,346,545],
 [25,42,64,100,159,238,351,492],[25,42,64,100,160,251,408],
 [25,42,67,103,133,184,255,353,478],
 [25,42,67,105,142,200,275,383,544],
 [25,42,67,111,165,248,352,509],
 [25,42,67,111,165,248,359,551],[25,42,67,111,165,262,413],
 [25,42,67,111,165,265,425],
 [25,45,53,55,57,60,61,62,63,63],
 [25,45,53,55,57,61,63,65,69,71,73,77,79,81,85,87,89,93,
   95,97,101,103,105,109,111,113,117,119,121,125,127,129,
   133,135],[25,45,53,58,63,66,67,68,68],
 [25,45,53,58,63,66,67,69,70,70],
 [25,45,53,58,63,66,67,69,71,72,74,76,77,79,81,82,84,86,
   87,89,91,92,94,96,97,99,101,102,104,106,107,109,111],
 [25,45,53,58,63,66,67,69,71,72,74,76,77,79,81,82,84,86,
   87,89,91,92,94,96,97,99,101,102,104,106,107,109,111,112]
  ,[25,45,53,58,63,66,68,69,69],
 [25,45,53,58,63,66,68,71,73,73],
 [25,45,53,58,63,68,73,79,85,92,100,108,116,124,132,140,
   148,156,164,172,180,188,196],
 [25,45,53,58,63,68,73,79,85,92,100,108,116,124,132,140,
   148,156,164,172,180,188,196,204],
 [25,45,53,58,64,71,76,82,87,93,98,104,109,115,120,126,131,
   137,142,148,153,159,164,170],
 [25,45,53,58,64,71,77,83,89,95,101,107,113,119,125,131,
   137,143,149,155,161,167,173,179],
 [25,45,53,58,64,72,78,85,92,99,105,113,119,126,133,140,
   146,154,160,167,174,181,187],
 [25,45,53,58,64,72,78,85,92,99,105,113,119,126,133,140,
   146,154,160,167,174,181,187,195],
 [25,45,53,58,64,72,79,86,93,101,108,117,124,132,139,148,
   155,163,170,179,186,194,201],
 [25,45,53,58,64,72,79,86,93,101,108,117,124,132,139,148,
   155,163,170,179,186,194,201,210],
 [25,45,53,58,64,72,79,87,96,104,112,121,129,137,146,154,
   162,171,179,187,196,204,212],
 [25,45,55,59,61,64,65,66,68,69,70,72,73,74,76,77,78,80,
   81,82,84,85,86,88,89,90,92,93,94,96,97,98,100,101,102],
 [25,45,55,59,61,65,67,69,73,75,77,81,83,85,89,91,93,97,
   99,101,105,107,109,113,115,117,121,123,125,129,131,133,
   137,139],
 [25,45,55,62,68,74,80,86,92,98,104,110,116,122,128,134,
   140,146,152,158,164,170,176],
 [25,45,55,62,68,74,80,86,92,98,104,110,116,122,128,134,
   140,146,152,158,164,170,176,182],
 [25,45,55,62,68,75,82,89,96,103,110,117,124,131,138,145,
   152,159,166,173,180,187,194],
 [25,45,55,62,68,75,82,89,96,103,110,117,124,131,138,145,
   152,159,166,173,180,187,194,201],
 [25,45,55,62,69,74,78,82,84,85,85],
 [25,45,55,62,69,74,78,84,88,91,94,96,98,99,99],
 [25,45,55,62,69,75,80,86,91,94,97,100,102,105,108,110,113,
   116,118,121,124,126,129,132,134,137,140,142,145,148,150,
   153],
 [25,45,55,62,69,75,80,87,93,98,104,109,114,120,125,130,
   136,141,146,152,157,162,168,173,178,184,189,194,200,205],
 [25,45,55,62,69,75,80,87,93,98,104,109,114,120,125,130,
   136,141,146,152,157,162,168,173,178,184,189,194,200,205,
   210],[25,45,57,61,63,65,65],
 [25,45,57,64,68,71,75,78,82,85,89,92,96,99,103,106,110,
   113,117,120,124],
 [25,45,57,64,68,71,75,78,82,85,89,92,96,99,103,106,110,
   113,117,120,124,127],[25,45,57,64,70,72,74,76,76],
 [25,45,57,64,70,75,79,82,86,89,93,96,100,103,107,110,114,
   117,121,124,128,131],
 [25,45,57,64,70,77,81,84,88,91,95,98,102,105,109,112,116,
   119,123,126,130],[25,45,61,74,84,90,92,96,96],
 [25,45,61,74,84,92,94,98,98],
 [25,45,61,75,85,93,103,113,123,131,141,149,159,167,177,185,
   195],
 [25,45,61,75,85,93,103,113,123,133,143,153,163,173,183,193,
   203],[25,45,61,77,93,99,99],[25,45,61,77,93,103,103],
 [25,45,61,81,103,117,133,145,159,169,183,193,207,217,231,
   241,255],
 [25,45,61,81,103,123,149,179,211,239,275,317,359],
 [25,45,61,81,103,123,149,181,213,241,277,321,363],
 [25,45,65,95,131,173,221,275,335,401],
 [25,45,65,95,131,175,223,279,339,407],
 [25,45,65,98,144,210,306,441],
 [25,45,65,102,160,242,354,499],[25,45,65,102,160,249,409],
 [25,45,68,98,127,164,210,266,335,411],
 [25,45,68,101,139,199,289,458],
 [25,45,68,103,144,203,288,418],
 [25,45,68,105,150,204,274,375,510],
 [25,45,68,105,155,236,354,528],
 [25,45,68,106,151,220,309,444],
 [25,45,68,107,160,233,338,476],
 [25,45,68,107,162,236,340,493],
 [25,45,68,107,163,243,352,520],
 [25,45,68,107,164,243,357,538],
 [25,45,68,107,167,262,391,584],
 [25,45,68,110,168,254,374,538],
 [25,45,68,110,171,264,385,550],[25,45,68,110,173,277,451],
 [25,45,68,114,193,342,622],[25,45,68,114,196,345,602],
 [25,45,68,114,197,358,674],
 [25,45,71,112,154,214,288,396,547],
 [25,45,71,113,155,229,335,505],
 [25,45,71,113,155,235,373,637],
 [25,45,71,114,160,220,292,394,533],
 [25,45,71,114,162,226,308,420],
 [25,45,71,117,171,259,387,607],[25,45,71,121,191,309,499],
 [25,45,71,121,195,323,525],[25,46,59,66,76,76],
 [25,46,59,66,76,79,79],[25,46,59,73,79,79],
 [25,46,63,77,97,97],[25,46,63,92,128,169,217,270,330,395]
  ,[25,46,63,92,128,174,224,284,348,422],
 [25,46,67,106,159,226,317,429],[25,46,67,111,181,268,400],
 [25,46,67,111,185,299,459],
 [25,48,71,97,130,166,212,268,337,426],
 [25,48,71,100,145,197,268,361,482],
 [25,48,71,101,137,190,266,373,522],
 [25,48,71,101,138,182,236,304,385,490],
 [25,48,71,101,139,183,242,315,411],
 [25,48,71,101,140,183,242,314,411],
 [25,48,71,102,143,197,267,355,467],
 [25,48,71,102,144,197,266,353,463],
 [25,48,71,102,145,199,267,357,469],
 [25,48,71,103,141,199,272,377,520],
 [25,48,71,103,143,195,263,356,475],
 [25,48,71,103,143,202,282,400],
 [25,48,71,103,144,201,269,365,484],
 [25,48,71,104,148,203,277,375,503],
 [25,48,71,104,148,207,279,374,489],
 [25,48,71,104,148,207,282,381,510],
 [25,48,71,104,150,209,285,379,502],
 [25,48,71,104,154,217,313,442],
 [25,48,71,105,148,212,304,429],
 [25,48,71,105,149,209,287,389,524],
 [25,48,71,105,149,212,295,416],
 [25,48,71,105,152,210,286,380,505],
 [25,48,71,105,154,226,348,568],
 [25,48,71,105,154,227,353,575],
 [25,48,71,107,156,222,309,434],
 [25,48,71,107,160,227,313,426],
 [25,48,71,107,160,230,325,459],
 [25,48,71,107,160,231,329,470],
 [25,48,71,108,162,232,325,448],
 [25,48,71,108,163,231,319,427],[25,48,71,108,169,257,404],
 [25,48,71,109,163,230,312,426],
 [25,53,77,106,127,145,155,162,165,165],
 [25,53,77,106,131,161,191,229,267,313,359],
 [25,53,81,125,169,229,289,365,441],
 [25,60,95,161,257,397,583],[25,60,95,161,257,401],
 [25,60,95,161,261,432],[25,60,95,162,249,422],
 [25,60,95,167,283,457],[25,60,95,167,283,466],
 [25,60,95,167,283,476],[25,60,95,167,287,488],
 [25,60,95,167,287,507],[25,60,95,172,295,526],
 [25,60,95,172,295,530],[30,30],[30,35,37,37],
 [30,35,37,38,38],[30,35,37,38,39,39],
 [30,35,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,
   53,54,55,56,57,58,59,60,61],
 [30,35,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,
   53,54,55,56,57,58,59,60,61,62],
 [30,35,37,38,39,40,42,44,45,47,49,50,52,54,55,57,59,60,
   62,64,65,67,69,70,72,74,75,77,79,80,82,84,85,87,89,90,
   92],[30,35,37,38,39,41,43,46,48,51,53,56,58,61,63,66,
   68,71,73,76,78,81,83,86,88,91],[30,35,37,39,39],
 [30,35,37,39,40,40],[30,35,37,39,40,41,41],
 [30,35,37,39,40,41,42,42],
 [30,35,37,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,
   54,55,56,57,58,59,60,61,62],
 [30,35,37,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,
   54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,
   72,73],
 [30,35,37,39,40,41,42,44,45,46,47,49,50,51,52,54,55,56,
   57,59,60,61,62,64,65,66,67,69,70,71,72,74,75,76,77,79,
   80,81,82,84,85,86,87,89,90,91],
 [30,35,37,39,40,42,43,43],
 [30,35,37,39,40,42,43,45,46,48,49,51,52,54,55,57,58,60,
   61,63,64,66,67,69,70,72,73],[30,35,37,39,40,42,44,44]
  ,[30,35,37,39,40,42,44,46,47,49,51,53,54,56,58,60,61,
   63,65,67,68,70,72,74,75,77,79,81,82,84,86,88,89,91,93,
   95,96,98,100,102,103,105,107,109],
 [30,35,37,39,40,42,44,46,47,49,51,53,54,56,58,60,61,63,
   65,67,68,70,72,74,75,77,79,81,82,84,86,88,89,91,93,95,
   96,98,100,102,103,105,107,109,110],[30,35,37,39,41,41],
 [30,35,37,39,41,42,43,43],[30,35,37,39,41,42,43,44,44],
 [30,35,37,39,41,42,43,44,45,46,47,48,49,50,51,52,53,54,
   55,56,57,58,59,60,61,62,63],
 [30,35,37,39,41,42,43,44,45,46,47,48,49,50,51,52,53,54,
   55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
   73,74],
 [30,35,37,39,41,42,43,45,46,47,49,50,51,53,54,55,57,58,
   59,61,62,63,65,66,67,69,70,71,73,74,75,77,78,79,81,82,
   83,85],[30,35,37,39,41,42,44,44],
 [30,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,
   69,71,73,75,77,79,81,83,85],
 [30,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,
   69,71,73,75,77,79,81,83,85,87,89,91,93,95],
 [30,35,37,39,41,43,46,46],
 [30,35,37,39,41,44,46,49,51,54,56,59,61,64,66,69,71,74,
   76,79,81,84,86,89,91,94],
 [30,35,37,39,41,45,48,52,55,59,62,66,69,73,76,80,83,87,
   90,94,97,101,104,108,111,115],
 [30,35,37,39,42,43,44,45,46,46],
 [30,35,37,39,42,43,44,45,46,47,48,49,50,51,52,53,54,55,
   56,57,58,59,60,61,62,63,64],[30,35,37,39,42,43,45,45]
  ,[30,35,37,39,42,44,45,46,46],
 [30,35,37,39,42,44,45,47,48,48],
 [30,35,37,39,42,44,45,47,49,50,52,54,55,57,59,60,62,64,
   65,67,69,70,72,74,75,77,79,80,82,84,85,87,89,90,92,94,
   95],[30,35,37,39,42,44,46,48,50,52,54,56,58,60,62,64,
   66,68,70,72,74,76,78,80,82,84],
 [30,35,37,39,42,44,46,48,50,52,54,56,58,60,62,64,66,68,
   70,72,74,76,78,80,82,84,86],
 [30,35,37,39,42,44,46,48,51,53,55,57,60,62,64,66,69,71,
   73,75,78,80,82,84,87,89,91,93,96,98,100,102,105,107,
   109,111],
 [30,35,37,39,42,44,46,48,51,53,55,57,60,62,64,66,69,71,
   73,75,78,80,82,84,87,89,91,93,96,98,100,102,105,107,
   109,111,114],
 [30,35,37,39,42,44,47,49,51,53,55,57,59,61,63,65,67,69,
   71,73,75,77,79,81,83,85,87],
 [30,35,37,39,42,44,47,50,52,55,58,60,63,66,68,71,74,76,
   79,82,84,87,90,92,95,98,100,103,106,108,111,114,116,119,
   122],
 [30,35,37,39,42,44,48,50,53,56,58,62,64,67,70,72,76,78,
   81,84,86,90,92,95,98,100,104,106,109,112,114,118,120,
   123,126,128,132,134,137,140,142,146,148,151,154,156,160,
   162,165],[30,35,37,40,41,41],
 [30,35,37,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,
   55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
   73],[30,35,37,40,41,42,43,44,45,46,47,48,49,50,51,52,
   53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,
   71,72,73,74],[30,35,37,40,41,42,44,44],
 [30,35,37,40,42,43,44,44],
 [30,35,37,40,42,44,45,47,48,50,51,53,54,56,57,59,60,62,
   63,65,66,68,69,71,72,74,75],
 [30,35,37,40,42,45,47,50,52,55,57,60,62,65,67,70,72,75,
   77,80,82,85,87,90,92,95],[30,35,41,43,45,46,46],
 [30,35,41,43,45,46,47,48,49,50,51,52,53,54,55,56,57,58,
   59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,
   77,78],[30,35,41,43,45,46,47,49,49],
 [30,35,41,43,45,48,50,53,55,57,60,62,65,67,69,72,74,77,
   79,81,84,86,89,91,93,96,98,101,103,105,108],
 [30,35,41,43,45,48,50,53,55,57,60,62,65,67,69,72,74,77,
   79,81,84,86,89,91,93,96,98,101,103,105,108,110],
 [30,35,41,43,45,48,51,53,54,54],
 [30,35,41,43,46,48,49,49],
 [30,35,41,43,46,48,50,51,52,53,54,55,56,57,58,59,60,61,
   62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
   80,81],
 [30,35,41,43,46,48,50,51,53,54,56,57,59,60,62,63,65,66,
   68,69,71,72,74,75,77,78,80],
 [30,35,41,43,46,48,51,53,56,58,61,63,66,68,71,73,76,78,
   81,83,86,88,91,93,96,98],
 [30,35,41,43,46,48,51,54,56,57,59,60,62,63,65,66,68,69,
   71,72,74,75,77,78,80,81,83],[30,35,41,44,47,48,48],
 [30,35,41,44,47,48,49,51,52,53,55,56,57,59,60,61,63,64,
   65,67,68,69,71,72,73,75,76,77,79,80,81,83,84,85,87,88,
   89,91],
 [30,35,41,44,47,50,54,57,60,63,66,70,73,76,79,82,86,89,
   92,95,98,102,105,108,111,114,118,121,124,127,130],
 [30,35,41,44,48,51,53,55,57,59,61,63,65,67,69,71,73,75,
   77,79,81,83,85,87,89,91],
 [30,35,41,47,53,59,65,71,77,83,89,95,101,107,113,119,125,
   131,137,143,149,155,161,167,173],
 [30,35,41,47,54,63,74,85,99,113,132,151,176,201,236,269,
   315,360,424],
 [30,35,41,47,54,63,74,86,99,115,133,155,178,207,239,279,
   320,374,432],
 [30,35,41,47,54,63,74,87,102,119,139,161,187,218,255,297,
   346,402],
 [30,35,41,47,54,63,75,86,101,117,138,159,187,216,255,293,
   343,395,463],
 [30,35,41,47,54,63,75,87,102,119,139,162,189,219,257,298,
   347,404],
 [30,35,41,47,54,63,75,89,106,125,150,175,208,242,290,341,
   410],[30,35,41,47,54,63,75,90,107,128,151,181,211,252,
   296,356,420],
 [30,35,41,48,56,64,73,82,92,102,113,124,136,148,161,174,
   188,202,217,232,248,264,281,298],
 [30,35,41,48,56,64,73,82,92,103,115,128,142,157,173,190,
   209,230,253,278,305,334,365],
 [30,35,41,48,56,64,73,82,93,104,116,128,141,154,168,182,
   198,214,231,248,266,284,303],
 [30,35,41,48,56,64,74,85,97,110,124,140,158,177,199,223,
   250,280,312,349,390,435],
 [30,35,41,48,56,65,75,86,99,113,130,149,170,195,223,254,
   291,332,379,434],[30,35,42,44,44],
 [30,35,42,45,47,49,49],[30,35,42,45,47,49,50,51,51],
 [30,35,42,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,
   75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,
   109],[30,35,42,45,47,50,50],
 [30,35,42,45,48,49,50,51,52,53,54,55,56,57,58,59,60,61,
   62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
   80,81],
 [30,35,42,45,48,50,53,54,56,57,59,60,62,63,65,66,68,69,
   71,72,74,75,77,78,80,81,83],
 [30,35,42,45,48,51,54,57,60,63,66,69,72,75,78,81,84,87,
   90,93,96,99,102,105,108,111],
 [30,35,42,46,50,55,59,62,65,67,69,70,71,72,72],
 [30,35,42,46,50,55,59,62,65,68,70,71,72,72],
 [30,35,42,46,50,55,60,64,69,73,77,82,86,90,95,99,103,108,
   112,116,121,125,129,134,138,142,147,151,155,160,164,168,
   173,177,181],
 [30,35,42,46,50,55,60,64,69,75,79,84,90,94,99,105,109,
   114,120,124,129,135,139,144,150,154,159,165,169,174,180,
   184,189,195,199],
 [30,35,42,47,52,55,58,62,66,69,72,76,79,82,86,90,93,96,
   100,103,106,110,114,117,120,124,127,130,134,138,141,144,
   148,151,154,158,162,165,168,172],
 [30,35,42,47,52,57,62,67,71,75,79,83,87,91,95,99,103,107,
   111,115,119,123,127,131,135,139,143,147,151,155,159,163,
   167,171,175,179,183,187,191,195],
 [30,35,42,47,52,58,64,68,74,79,83,90,95,99,106,111,115,
   122,127,131,138,143,147,154,159,163,170,175,179,186,191,
   195,202,207,211],
 [30,35,42,47,53,58,62,66,69,72,76,79,82,86,89,92,96,99,
   102,106,109,112,116,119,122,126],
 [30,35,42,47,53,58,63,69,74,78,82,87,93,98,102,106,111,
   117,122,126,130,135,141,146,150,154,159,165,170,174],
 [30,35,42,47,53,59,66,74,80,86,93,100,108,118,127,135,145,
   155,165,178,190,200,213,226,238,254,269,281,297,313,327],
 [30,35,42,47,54,61,68,77,86,95,105,114,123,133,142,151,
   161,170,179,189,198,207,217,226,235,245,254,263,273,282,
   291],
 [30,35,42,47,54,63,73,84,94,104,115,127,141,154,168,183,
   199,217,234,252,271,291,313],
 [30,35,42,49,58,67,79,91,106,123,143,166,194,225,263,306,
   357,417],
 [30,35,42,49,58,68,79,91,106,123,143,164,190,220,256,295,
   341,395,460],
 [30,35,42,49,58,68,79,92,107,125,145,168,195,227,264,306,
   355,413],
 [30,35,42,49,58,68,80,93,110,127,150,173,204,235,276,317,
   372,427],
 [30,35,42,49,58,68,80,93,110,128,151,174,206,237,279,320,
   376,432],
 [30,35,42,49,58,68,80,94,109,127,148,171,201,234,274,320,
   374,436],
 [30,35,42,49,58,68,80,94,110,129,150,176,206,241,283,332,
   389,456],
 [30,35,42,50,58,67,76,86,97,109,121,135,148,163,177,193,
   209,227,244,264,282,303,322],
 [30,35,42,50,58,67,77,87,99,111,125,140,157,174,195,215,
   240,265,295,325,362,397],
 [30,35,42,50,58,67,77,87,99,111,125,140,157,174,195,215,
   240,265,295,325,362,397,442],
 [30,35,42,50,58,67,77,88,100,113,128,145,163,183,206,232,
   260,291,327,368,412],
 [30,35,42,50,58,68,77,89,99,113,124,140,152,170,183,203,
   217,239,254,278,294,320,337],
 [30,35,42,50,58,68,78,90,103,118,134,153,173,197,222,252,
   284,322,362,410],
 [30,35,42,50,59,68,78,89,100,112,124,138,152,167,182,199,
   215,233,250,270,289,310,330],
 [30,35,42,50,59,69,79,90,102,115,130,147,165,185,206,229,
   255,284,316,352,390,432],
 [30,35,42,50,59,69,81,94,110,128,149,174,202,236,274,320,
   372,435],
 [30,35,42,50,59,69,82,96,114,133,157,183,215,250,294,342,
   403],[30,35,42,51,62,73,87,103,122,144,170,199,234,274,
   319,373,434],
 [30,35,42,51,62,74,88,102,120,141,165,191,221,258,301,349,
   403],[30,35,42,51,62,74,89,105,125,148,175,205,241,283,
   330,385,448],
 [30,35,42,51,62,74,89,106,125,146,172,200,235,277,324,381,
   446],[30,35,42,51,62,74,89,107,127,150,178,208,246,291,
   342,405],
 [30,35,42,52,62,74,86,102,120,144,168,202,238,286,336,406],
 [30,35,42,52,62,75,89,107,125,148,172,202,233,271,310,358,
   407],[30,35,42,52,62,75,89,107,126,150,174,204,234,270,
   308,354,402],
 [30,35,42,52,63,76,90,107,125,147,170,199,230,267,306,354,
   405],[30,35,42,52,63,77,93,112,134,161,191,229,270,322,
   381,452],
 [30,35,42,52,63,77,93,113,135,163,194,233,276,330,390,465],
 [30,35,42,52,63,78,94,115,140,172,211,258,316,385,471],
 [30,35,42,52,64,80,100,126,157,197,246,310,386,488],
 [30,40,44,44],[30,40,44,46,48,48],
 [30,40,44,46,48,50,50],
 [30,40,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,
   76,78,80,82,84,86],
 [30,40,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,
   76,78,80,82,84,86,88],[30,40,44,46,50,52,52],
 [30,40,44,46,50,52,54,54],
 [30,40,44,46,50,52,54,56,60,62,64,66,70,72,74,76,80,82,
   84,86,90,92,94,96,100,102,104,106,110,112],
 [30,40,44,46,50,54,54],
 [30,40,44,46,50,54,56,60,64,66,70,74,76,80,84,86,90,94,
   96,100,104,106,110,114],[30,40,44,48,48],
 [30,40,44,48,50,52,52],
 [30,40,44,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76],
 [30,40,44,48,50,54,58,62,68,76,80,86,94,98,104,112,116,
   122,130,134,140,148],
 [30,40,44,48,50,54,60,66,72,78,84,90,96,102,108,114,120],
 [30,40,44,48,50,54,60,66,72,78,84,90,96,102,108,114,120,
   126],[30,40,44,48,52,52],
 [30,40,44,48,52,56,60,64,68,72,76,80,84,88,92,96,100,104,
   108,112,116,120,124,128],
 [30,40,44,48,56,62,66,72,78,82,86,92,98,102,106,112,118,
   122,126,132,138,142,146,152,158,162,166,172],
 [30,40,44,48,56,62,66,72,80,86,92,100,106,112,120,126,132,
   140,146,152,160,166,172],[30,40,44,50,50],
 [30,40,44,50,52,52],[30,40,44,50,52,54,54],
 [30,40,44,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78],
 [30,40,44,50,52,54,58,60,62,66,68,70,74,76,78,82,84,86,
   90,92,94,98,100],[30,40,44,50,52,56,56],
 [30,40,44,50,52,56,58,62,64,68,70,74,76,80,82,86,88,92],
 [30,40,44,50,54,56,56],
 [30,40,44,50,54,56,58,60,62,64,66,68,70,72,74,76,78,80],
 [30,40,44,50,54,58,60,60],
 [30,40,44,50,54,58,62,66,70,74,78,82,86,90,94,98,102,106]
  ,[30,40,44,50,54,58,64,68,72,78,82,86,92,96,100,106,110 
  ],[30,40,44,50,54,58,64,68,72,78,82,86,92,96,100,106,
   110,114],[30,40,44,50,54,60,62,64,66,68,68],
 [30,40,44,50,54,60,64,68,74,78,84,88,92,98,102,108,112,
   116,122,126],
 [30,40,44,50,54,60,66,72,76,80,84,88,92,96,100,104,108,
   112],[30,40,44,50,54,60,66,72,78,84,90,96,102,108,114,
   120,126],
 [30,40,44,50,54,62,68,78,84,94,100,110,116,126,132,142,
   148,158,164,174,180,190,196,206,212],
 [30,40,44,50,54,62,68,78,86,100,112,134,152,184,210,256],
 [30,40,44,52,52],[30,40,44,52,54,58,58],
 [30,40,44,52,54,58,60,64,66,70,72,76,78,82,84,88,90,94],
 [30,40,44,52,56,60,68,72,76,84,88,92,100,104,108,116,120,
   124,132,136,140,148],
 [30,40,44,52,56,60,68,72,76,84,88,92,100,104,108,116,120,
   124,132,136,140,148,152],
 [30,40,44,52,58,60,64,66,68,72,74,76,80,82,84,88,90,92,
   96,98,100,104,106],[30,40,44,52,58,62,64,64],
 [30,40,44,52,58,62,66,70,74,78,82,86,90,94,98,102,106,110 
  ],[30,40,44,52,58,64,70,74,80,86,90,96,102,106,112,118,
   122,128,134,138,144],
 [30,40,44,52,58,64,70,74,80,86,90,96,102,106,112,118,122,
   128,134,138,144,150],
 [30,40,44,52,58,64,72,78,84,92,98,104,112,118,124,132,138]
  ,[30,40,44,52,58,64,72,80,88,96,104,112,120,128,136,144,
   152],[30,40,44,52,58,66,70,76,80,86,90,96,100,106,110,
   116,120,126,130,136,140,146,150,156,160,166],
 [30,40,44,52,58,66,72,82,90,102,110,122,130,142,150,162,
   170],[30,40,44,52,60,64,70,74,80,84,90,94,100,104,110,
   114,120],
 [30,40,44,52,60,66,72,80,88,96,102,108,116,124,132,138,
   144,152,160],
 [30,40,44,52,60,66,74,80,86,94,100,106,114,120,126,134,
   140,146,154,160,166],
 [30,40,44,52,60,66,74,82,90,98,106,114,122,130,138,146,154 
  ],[30,40,50,60,72,88,108,128,154,182,216,252,298,348,412 
  ],[30,40,50,60,72,88,108,130,154,182,216,256,300,352,414 
  ],[30,40,50,60,72,88,108,132,160,192,230,272,322,376,442 
  ],[30,40,50,60,72,88,110,138,170,210,254,308,366,440],
 [30,40,52,54,54],
 [30,40,52,66,80,96,112,130,148,168,188,212,234,260,284,312]
  ,[30,40,52,66,80,96,112,130,150,172,196,224,252,284,318,
   356],
 [30,40,52,66,80,96,114,134,156,180,208,240,274,312,356],
 [30,40,52,66,80,96,114,134,156,180,208,240,274,312,356,406]
  ,[30,40,52,66,80,98,114,136,154,180,200,230,252,286,310,
   348],
 [30,40,52,66,82,100,122,146,176,208,248,292,346,406],
 [30,40,52,66,82,104,132,172,226,300,398,532],
 [30,40,52,66,82,104,134,170,216,272,344,434],
 [30,40,52,66,82,104,134,174,222,284,360,458],
 [30,40,52,66,84,110,148,196,260,342,460],
 [30,40,54,64,76,86,94,104,116,126,134,144,156,166,174,184,
   196,206,214,224,236,246],
 [30,40,54,64,76,88,104,122,140,156,176,200,226,246,272,304,
   334,360,394,430],
 [30,40,54,64,78,92,104,120,140,162,182,204,230,258,284,312,
   344,378,410],
 [30,40,54,64,78,92,106,120,134,148,162,176,190,204,218,232]
  ,[30,40,54,64,78,92,106,122,142,166,190,218,252,290,332,
   380,434],
 [30,40,54,64,78,94,110,128,148,168,188,206,224,244,264,284,
   302,320],
 [30,40,54,64,78,94,112,136,164,198,240,288,350,422],
 [30,40,54,64,78,96,116,140,168,200,240,286,340,404],
 [30,40,54,64,78,96,116,142,174,212,258,312,376,454],
 [30,40,54,68,86,104,128,152,184,218,260,306,364,424],
 [30,40,54,68,86,104,128,154,184,220,260,306,364,426],
 [30,40,54,68,86,106,128,152,182,216,256,298,350,410],
 [30,40,54,68,86,106,128,154,184,220,260,306,360,424],
 [30,40,54,68,86,106,130,156,188,222,264,312,370,436],
 [30,40,54,68,86,106,130,156,188,224,266,318,376,446],
 [30,40,54,68,86,106,130,156,190,226,272,318,382,444],
 [30,40,54,68,86,106,130,158,188,226,268,318,378,448],
 [30,40,54,68,86,106,130,158,190,228,270,322,378,446],
 [30,40,54,68,86,106,130,158,192,228,276,322,388,450],
 [30,40,54,68,86,106,130,160,190,230,272,322,384,454],
 [30,40,54,68,86,106,130,160,192,232,276,328,388,456],
 [30,40,54,70,92,116,146,178,220,268,326,396,478],
 [30,40,54,70,92,116,146,182,222,272,330,398,482],
 [30,40,54,70,92,116,148,186,230,284,346,420],
 [30,40,54,70,92,116,148,186,230,284,348,422],
 [30,40,54,70,92,116,148,186,234,292,362,450],
 [30,40,54,70,92,116,148,186,234,294,370,460],
 [30,40,54,70,92,116,148,188,236,296,370,460],
 [30,40,54,70,92,118,150,186,236,294,366,450],
 [30,40,54,72,90,112,138,172,206,248,298,364,430],
 [30,40,54,72,90,114,138,168,200,242,282,338,388,456],
 [30,40,54,72,92,116,144,180,220,270,326,398,476],
 [30,40,54,72,92,118,144,180,214,262,306,370,426],
 [30,40,54,72,92,118,146,182,220,268,320,386,458],
 [30,40,54,72,92,118,148,186,230,286,348,430],
 [30,40,54,72,92,118,148,186,232,290,360,450],
 [30,40,54,76,98,130,166,218,272,356,442],
 [30,40,54,76,100,134,172,230,296,392,500],
 [30,40,54,76,100,136,174,230,294,390,498],
 [30,40,54,76,100,136,176,236,302,400],
 [30,40,54,76,100,136,178,242,314,422],[30,45,51,57,57],
 [30,45,51,57,60,63,63],
 [30,45,51,57,60,63,66,69,72,75,78,81,84,87,90,93],
 [30,45,51,60,61,63,64,66,67,69,70,72,73,75,76,78,79,81,
   82,84],[30,45,51,60,62,64,64],
 [30,45,51,60,62,66,66],[30,45,51,60,63,66,66],
 [30,45,51,60,63,66,69,72,75,78,81,84,87,90,93],
 [30,45,51,60,63,69,69],
 [30,45,51,60,63,69,72,78,81,87,90,96,99,105,108],
 [30,45,51,60,64,68,69,70,70],
 [30,45,51,60,64,68,71,74,77,80,83,86,89,92,95],
 [30,45,51,60,64,69,70,72,73,75,76,78,79,81,82,84,85],
 [30,45,51,60,64,69,74,80,86,93,100,108],
 [30,45,51,60,64,71,75,83,87,95,99,107,111,119],
 [30,45,51,60,64,72,74,78,80,84,86,90,92,96,98,102,104],
 [30,45,51,60,65,70,72,74,74],
 [30,45,51,60,65,72,77,82,87,92,97,102,107,112,117],
 [30,45,51,60,65,73,76,79,79],
 [30,45,51,60,65,75,80,90,95,105,110,120,125,135,140,150],
 [30,45,51,60,65,75,81,93,99,111,117,129,135,147],
 [30,45,55,61,66,68,70,72,74,76,76],
 [30,45,55,61,66,69,70,70],
 [30,45,55,61,66,70,72,74,76,78,78],[30,45,55,65,68,68],
 [30,45,55,65,68,69,70,70],
 [30,45,55,65,69,72,75,76,77,78,79,80,81,82,83,84,85,86,
   87,88],[30,45,55,65,70,72,72],
 [30,45,55,65,71,75,75],[30,45,55,65,71,77,79,79],
 [30,45,55,65,72,77,79,81,83,85,87,89,91,93,95,97,99,101,
   103,105],
 [30,45,55,65,72,78,80,82,84,86,88,90,92,94,96,98,100,102,
   104,106],[30,45,55,67,75,87,101,113,129,147,163,183,205 
  ],[30,45,55,67,76,89,102,113,128,145,160,179,200,219],
 [30,45,55,69,81,90,93,93],
 [30,45,55,69,88,111,132,157,188,221,250,285,328,371,408],
 [30,45,55,71,94,124,153,198,244,283,344,404],
 [30,45,56,62,64,64],[30,45,56,62,66,69,70,70],
 [30,45,56,62,66,69,72,75,78,81,84,87,90,93,96,99],
 [30,45,56,63,67,68,68],
 [30,45,56,63,67,71,75,79,83,87,91,95,99,103,107],
 [30,45,56,63,68,69,69],[30,45,56,63,68,70,71,71],
 [30,45,56,63,68,71,72,72],
 [30,45,56,63,68,71,73,75,77,79,81,83,85,87,89,91,93,95,
   97,99],
 [30,45,56,63,68,71,74,77,80,83,86,89,92,95,98,101],
 [30,45,56,63,68,72,75,78,81,84,87,90,93,96,99,102],
 [30,45,56,63,68,72,76,80,84,88,92,96,100,104,108],
 [30,45,56,63,68,73,75,76,76],[30,45,56,63,69,71,72,72],
 [30,45,56,63,69,72,74,75,76,76],
 [30,45,56,63,69,73,74,74],
 [30,45,56,63,69,73,75,78,80,83,85,88,90,93,95,98,100,103,
   105,108],
 [30,45,56,63,69,73,77,80,84,87,91,94,98,101,105,108,112,
   115,119,122],
 [30,45,56,63,69,74,80,85,91,96,102,107,113,118],
 [30,45,56,63,69,76,80,83,84,84],
 [30,45,56,63,70,76,81,85,91,96,101,105,111,116,121,125,
   131,136],[30,45,56,63,70,76,82,84,84],
 [30,45,56,63,70,77,83,90,97,103,110,117,123,130,137],
 [30,45,56,63,70,77,85,91,98,105,113,119,126,133,141,147,
   154],[30,45,56,63,70,78,86,94,102,110,118,126,134,142,
   150,158,166,174,182],
 [30,45,56,63,70,79,88,97,107,116,125,135,144,153,163],
 [30,45,56,63,71,76,80,81,81],
 [30,45,56,63,71,77,83,88,96,102,108,113,121,127,133,138,
   146,152],[30,45,56,63,71,79,81,81],
 [30,45,56,63,71,79,90,99,110,119,130,139,150,159,170,179,
   190,199],
 [30,45,56,63,71,80,87,96,105,112,121,130,137,146,155],
 [30,45,56,63,71,82,91,102,111,122,131,142,151,162,171,182,
   191,202],[30,45,56,63,71,83,97,118,144,179,226,287],
 [30,45,56,65,71,72,72],[30,45,56,65,71,75,79,80,80],
 [30,45,56,65,71,75,82,87,91,98,103,107,114,119],
 [30,45,56,65,73,77,78,78],
 [30,45,56,65,73,77,80,83,86,89,92,95,98,101,104],
 [30,45,56,65,73,79,83,84,84],
 [30,45,56,65,73,79,85,91,97,103,109,115,121,127],
 [30,45,56,65,73,79,85,91,97,103,109,115,121,127,133],
 [30,45,56,65,73,80,88,96,104,112,120,128,136,144],
 [30,45,56,65,73,80,90,98,105,115,123,130],
 [30,45,56,65,73,82,92,101,110,119,128,137,146,155],
 [30,45,56,65,74,76,76],[30,45,56,65,76,83,89,91,91],
 [30,45,56,65,76,84,89,90,90],
 [30,45,56,65,76,84,92,97,104,109,116,121,128,133,140,145],
 [30,45,56,65,76,86,101,115,135,153,178],
 [30,45,56,65,76,87,101,116,134,153,175],
 [30,45,56,65,76,89,109,131,163,205,259,333],
 [30,45,59,71,77,83,85,86,86],
 [30,45,59,71,79,88,96,105,114,123,132,141,150,159],
 [30,45,59,71,81,93,104,118,136,150,167,190,213,242],
 [30,45,59,74,89,113,132,158,196,227,261,311,350],
 [30,45,59,75,84,89,96,101,104,106,110,112,114,115,117,118],
 [30,45,59,75,85,91,97,103,110,115,117,118,120,121,121],
 [30,45,59,75,85,92,99,107,113,119,125,131,137,143],
 [30,45,59,75,89,100,107,115,121,129,135,143,149,157],
 [30,45,59,75,89,102,113,118,122,122],
 [30,45,59,75,90,105,120,136,150,167,181],
 [30,45,59,75,91,107,122,138,151,167,179,195,207],
 [30,45,59,77,93,118,153,185,233,294,357],
 [30,45,59,77,94,118,146,171,208,245,281,329],
 [30,45,59,78,94,109,116,120,125,130,136,141,145,148,152,155 
  ],[30,45,59,78,95,118,142,178,225,279,339,407],
 [30,45,59,79,102,129,155,197,248,302,363],
 [30,45,59,81,120,164,232,348,525],
 [30,45,59,82,112,146,180,223,263,306,353,411],
 [30,45,61,72,84,88,88],[30,45,61,72,85,92,95,97,97],
 [30,45,61,72,85,96,107,118,129,140,151,162,173],
 [30,45,61,72,87,96,101,103,103],
 [30,45,61,72,87,96,104,111,119,126,134,141,149,156],
 [30,45,61,72,87,99,109,119,129,139,149,159,169,179],
 [30,45,61,72,87,99,112,124,137,149,162,174],
 [30,45,61,72,87,102,120,140,160,186,216,249,287],
 [30,45,61,72,87,102,123,148,176,212,255,306],
 [30,45,61,72,88,100,111,120,128,135,143,150,158],
 [30,45,61,72,88,101,112,120,126,132,138,144,150,156,162,168 
  ],[30,45,61,72,88,101,116,132,151,172,195],
 [30,45,61,72,88,103,120,144,174,215,269,340],
 [30,45,61,72,88,106,127,153,185,228,280,340],
 [30,45,61,72,88,107,134,169,217,279],
 [30,45,61,75,87,93,95,95],
 [30,45,61,75,87,96,103,108,113,118,123,128,133,138,143],
 [30,45,61,75,88,100,107,109,109],
 [30,45,61,75,88,103,118,133,148,163,178,193],
 [30,45,61,75,90,104,116,123,128,130,130],
 [30,45,61,75,90,104,119,134,152,169,187,204,222],
 [30,45,61,75,90,107,126,145,167,191,217,243,272],
 [30,45,61,75,90,107,126,153,187,233,294,374],
 [30,45,61,75,90,110,132,160,195,237,289,351],
 [30,45,62,82,94,105,113,123,129,137,143,151,157,165],
 [30,45,62,82,94,105,113,123,130,138,144,152,158,166],
 [30,45,62,82,102,125,144,160,173,180,182,184,187,190,191,
   191],[30,45,62,82,102,129,161,194,235,280,328,375,430],
 [30,45,62,82,102,129,161,194,235,283,331,378,433],
 [30,45,62,84,98,115,131,141,148,153,155,155],
 [30,45,62,84,106,134,155,170,186,202,226,244,252,264,280,
   304,322],[30,45,62,84,106,134,156,177,204,228,254,282],
 [30,45,62,84,110,149,197,257,333,454],
 [30,45,62,86,100,128,166,190,231,281,313,366,428],
 [30,45,62,86,114,167,242,344,517],
 [30,45,63,73,76,79,81,81],
 [30,45,63,73,78,83,87,89,93,93],
 [30,45,63,73,78,83,87,89,93,95,97,97],
 [30,45,63,73,78,84,88,94,96,96],
 [30,45,63,73,79,81,83,87,89,89],
 [30,45,63,73,79,81,83,87,91,91],
 [30,45,63,73,79,85,88,91,97,101,105,108,111,117,121,125,
   128,131,137,141,145,148,151,157,161,165,168,171,177,181,
   185,188,191,197,201],[30,45,63,73,79,85,89,89],
 [30,45,63,73,81,91,99,105,109,115,119,125,129,135,139,145,
   149,155,159],
 [30,45,63,73,81,92,98,107,111,118,122,129,133,140,144,151,
   155,162,166],
 [30,45,63,73,81,93,99,105,109,115,119,125,129,135,139,145,
   149,155,159],
 [30,45,63,73,82,89,92,95,101,108,113,116,119,125,132,137,
   140,143,149,156,161,164,167,173,180,185,188,191,197,204,
   209,212,215,221],[30,45,63,73,82,90,94,94],
 [30,45,63,73,85,99,121,142,164,188,220,249,277,309,351,388]
  ,[30,45,63,75,82,97,115,128,149,173,190,217,247,268],
 [30,45,63,75,82,97,115,128,151,179,198,229,263,286],
 [30,45,63,75,82,97,115,128,153,179,198,231,263,286],
 [30,45,63,75,89,112,137,163,196,231,265,308,353,395],
 [30,45,63,75,89,112,137,163,198,235,269,314,361,403],
 [30,45,63,75,94,131,183,267,412],
 [30,45,66,90,120,156,204,261,339,435],
 [30,45,66,90,121,157,201,251,308,375],
 [30,45,66,90,121,157,201,252,312,382],
 [30,45,66,90,121,157,201,252,313,386],
 [30,45,66,90,121,157,201,252,315,394],
 [30,45,66,90,121,157,202,256,323,407],
 [30,45,66,90,121,159,209,271,354,459],
 [30,45,66,90,121,159,211,276,360,468],
 [30,45,66,90,122,161,208,262,326,401],
 [30,45,66,90,122,161,211,274,352,454],
 [30,45,66,90,122,162,212,273,352,449],
 [30,45,66,90,122,163,218,291,393,533],
 [30,45,66,90,122,164,223,306,429],
 [30,45,66,95,128,177,234,315,416],
 [30,45,66,95,130,174,230,300,389,501],
 [30,45,66,95,130,178,238,317,422],
 [30,45,66,95,130,178,240,322,430],
 [30,45,66,95,132,181,239,313,410],
 [30,45,66,95,132,181,241,318,416],
 [30,45,66,95,132,187,258,365,508],
 [30,45,66,95,132,187,260,372,529],
 [30,45,67,95,125,160,201,252,315,398],
 [30,45,67,95,126,167,222,288,375,481],
 [30,45,67,95,127,163,203,254,304,364],
 [30,45,67,95,128,169,223,293,380,488],
 [30,45,67,95,130,172,229,298,384,487],
 [30,45,67,95,130,175,238,316,423],
 [30,45,67,95,131,171,221,274,339,407],
 [30,45,67,95,132,177,235,309,398,510],
 [30,45,67,95,132,182,254,361,495],
 [30,45,67,97,129,176,236,302,383,484],
 [30,45,67,97,140,207,317,477],
 [30,45,67,98,136,184,232,295,356,434],
 [30,45,67,98,139,205,289,408],[30,45,67,100,159,248,407],
 [30,50,70,94,126,162,202,246,298],
 [30,50,70,94,130,182,252,342,462],
 [30,50,70,98,142,202,282,386,530],
 [30,50,74,102,134,170,210,258,314],
 [30,50,74,102,136,178,236,316,422],
 [30,50,74,102,136,180,232,298,380],
 [30,50,74,106,150,208,282,378,504],
 [30,50,74,106,150,212,300,426],
 [30,50,74,106,152,208,280,374,496],
 [30,50,74,106,154,220,312,442],
 [30,50,78,114,158,218,294,394,526],
 [30,50,78,114,160,218,290,386,508],
 [30,50,78,114,160,218,292,390,516],
 [30,50,78,114,162,222,302,410],
 [30,50,78,114,162,226,310,422],
 [30,50,78,114,162,226,312,432],
 [30,50,78,114,162,226,314,442],
 [30,50,78,114,162,228,318,446],
 [30,50,78,114,162,228,318,448],[30,55,104,175,293,482],
 [30,55,104,175,297,481],[30,55,104,175,297,490],
 [30,55,104,175,299,496],[30,55,104,175,299,499],
 [30,55,104,175,299,503],[30,55,104,175,301,508],
 [30,55,104,175,301,517],[30,55,104,175,305,514],
 [30,55,104,175,305,532],[30,55,104,175,305,536],
 [30,55,104,175,307,531],[30,55,104,175,307,534],
 [30,55,104,175,309,520],[30,55,108,168,272,397,610],
 [30,55,108,168,272,419],[30,55,108,168,276,414],
 [30,55,108,168,277,409],[30,55,108,168,278,417],
 [30,55,108,168,278,427],[30,55,108,168,278,433],
 [30,55,108,168,278,441],[30,55,108,168,281,440],
 [30,55,108,168,282,424],[30,55,108,168,282,428],
 [30,55,108,168,282,434],[30,55,108,168,283,424],
 [30,55,108,168,283,444],[30,55,108,168,285,425],
 [30,55,108,168,285,453],[30,55,108,168,285,455],
 [30,55,108,168,287,447],[30,55,108,173,289,469],
 [30,55,108,173,295,471],[30,55,108,173,297,482],
 [30,55,108,173,297,491],[30,55,108,173,299,468],
 [30,55,108,173,299,501],[30,55,108,173,301,475],
 [30,55,108,173,301,491],[30,55,108,173,305,493],[35,35],
 [35,40,40],[35,45,45],
 [35,48,56,64,68,72,76,78,80,82,82],
 [35,48,56,64,68,72,76,78,80,82,84,86,88,90,92,94,96,98,
   100,102,104,106,108,110],
 [35,48,56,68,74,80,84,86,88,88],
 [35,48,56,68,74,80,84,88,92,96,100,104,108,112,116,120,
   124,128,132,136,140,144],
 [35,48,56,68,74,84,92,102,110,120,128,138,146,156,164,174,
   182],[35,48,56,68,76,84,94,102,112,120,128,138,146,156,
   164,172,182,190,200],
 [35,48,56,68,76,84,94,102,112,122,130,142,150,160,170,178,
   190,198,208],
 [35,48,56,68,76,88,98,110,120,132,142,154,164,176,186,198],
 [35,48,56,68,76,88,98,110,120,134,144,158,168,182,192,206],
 [35,51,57,59,63,65,66,68,69,69],[35,51,57,61,63,65,65],
 [35,51,57,61,63,65,66,66],
 [35,51,57,61,63,65,67,68,69,70,70],
 [35,51,57,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,
   91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,
   121],
 [35,51,57,61,67,69,70,72,73,74,76,77,78,80,81,82,84,85,
   86,88,89,90,92,93,94,96,97,98,100,101,102,104,105,106],
 [35,51,57,62,67,69,72,74,75,75],
 [35,51,57,62,68,74,80,88,96,104,113,121,129,138,146,154,
   163,171,179,188,196,204,213],
 [35,51,57,64,68,71,72,73,73],
 [35,51,57,64,68,71,73,74,75,75],
 [35,51,57,64,68,71,73,75,77,79,81,83,85,87,89,91,93,95,
   97,99,101,103,105,107,109,111,113,115,117,119,121,123],
 [35,51,57,64,68,71,73,75,77,79,81,83,85,87,89,91,93,95,
   97,99,101,103,105,107,109,111,113,115,117,119,121,123,125 
  ],[35,51,57,64,68,74,78,84,88,94,98,104,108,114,118,
   124,128,134,138,144,148,154,158,164],
 [35,51,57,64,68,74,79,85,90,96,101,107,112,118,123,129,
   134,140,145,151,156,162,167,173],
 [35,51,57,64,69,73,77,80,83,85,87,88,89,90,90],
 [35,51,57,64,69,73,78,82,87,91,95,99,103,107,111,115,119,
   123,127,131,135,139,143,147,151,155,159,163,167,171,175],
 [35,51,57,64,69,76,81,87,92,98,103,109,114,120,125,131,
   136,142,147,153,158,164,169,175],
 [35,51,57,64,69,76,81,88,94,101,106,113,119,126,131,138,
   144,151,156,163,169,176,181],
 [35,51,57,64,69,76,81,88,94,101,106,113,119,126,131,138,
   144,151,156,163,169,176,181,188],
 [35,51,57,64,69,76,82,89,95,103,109,117,123,131,137,145,
   151,159,165,173,179,187,193],
 [35,51,57,64,69,76,82,89,95,103,109,117,123,131,137,145,
   151,159,165,173,179,187,193,201],
 [35,51,57,64,72,78,84,90,96,102,108,114,120,126,132,138,
   144,150,156,162,168,174,180],
 [35,51,57,64,72,78,84,90,96,102,108,114,120,126,132,138,
   144,150,156,162,168,174,180,186],
 [35,51,57,64,72,78,85,92,99,106,113,120,127,134,141,148,
   155,162,169,176,183,190,197],
 [35,51,57,64,72,78,85,92,99,106,113,120,127,134,141,148,
   155,162,169,176,183,190,197,204],
 [35,51,57,64,73,77,83,88,92,97,99,101,103,104,105,105],
 [35,51,57,64,73,77,84,90,94,99,102,104,107,110,112,115,
   118,120,123,126,128,131,134,136,139,142,144,147,150,152,
   155,158],[35,60,105,155,239,339,515],
 [35,60,105,155,239,341,534],[35,60,105,155,239,344,534],
 [35,60,105,155,239,348,556],[35,60,105,161,256,378,625],
 [35,60,105,161,267,423],[35,60,105,161,269,419],
 [35,60,105,161,269,420],[35,60,105,162,255,412],
 [35,60,105,162,255,414],[35,60,105,162,255,420],
 [35,60,105,162,255,422],[35,60,105,162,255,426],
 [35,60,105,163,269,396,670],[35,60,105,163,270,414],
 [35,60,105,163,275,397,613],[35,60,105,163,275,414],
 [35,60,105,163,277,407],[35,60,105,169,292,439],
 [35,60,105,169,294,447],[35,60,105,169,297,450],
 [35,60,105,169,297,458],[35,60,105,169,297,461],
 [35,60,105,169,297,484],[35,60,105,169,298,466],
 [35,60,105,169,299,466],[35,60,105,169,301,478],
 [35,60,105,169,303,491],[35,60,105,169,305,482],
 [35,60,105,169,307,487],[35,60,105,176,286,477],
 [35,60,105,176,286,479],[35,60,105,176,288,489],
 [35,60,105,176,292,499],[35,60,105,176,293,504],
 [35,60,105,176,294,507],[35,60,105,176,294,517],
 [35,60,105,176,294,519],[35,60,105,176,296,529],
 [35,60,105,176,299,536],[35,60,105,176,301,538],
 [40,45,45],[40,45,47,47],[40,50,50],[40,50,54,54],
 [40,50,60,64,64],
 [40,50,60,74,92,118,148,188,236,300,378,478],
 [40,50,60,74,92,120,154,200,258,334,436],
 [40,50,60,74,92,120,154,202,268,354,474],
 [40,50,60,74,92,120,156,204,268,352,460],
 [40,50,64,72,80,90,96,102,110,114,118,124,126,128,132,134,
   136,140,142,144,148,150],
 [40,50,64,72,80,90,96,102,110,114,118,124,126,128,132,134,
   136,140,142,144,148,150,152],
 [40,50,64,72,80,92,98,104,112,116,120,124,126,128,130,132,
   134,136,138,140,142,144,146],
 [40,50,64,72,82,90,92,94,96,96],
 [40,50,64,72,82,92,94,98,100,100],
 [40,50,64,72,82,92,98,104,112,118,124,132,138,144,152,158,
   164,172,178,184,192,198],
 [40,50,64,72,82,92,98,106,112,118,124,130,136,142,148,154,
   160,166,172,178,184,190],
 [40,50,64,72,82,92,100,108,118,126,134,144,152,160,170,178,
   186,196,204,212,222],
 [40,50,64,72,82,92,100,108,118,126,134,144,152,160,170,178,
   186,196,204,212,222,230],
 [40,50,64,72,82,94,100,108,118,124,132,142,148,156,166,172,
   180,190,196,204,214,220],
 [40,50,64,72,82,94,100,110,122,128,140,152,158,170,182,188,
   200,212,218,230,242],
 [40,50,64,72,82,94,104,114,126,134,142,154,164,174,186,194,
   202,214,224,234,246],
 [40,50,64,82,96,114,128,146,160,178,192,210,224,242,256],
 [40,50,64,82,96,114,128,146,160,178,192,210,224,242,256,274 
  ],[40,50,64,82,98,118,136,158,178,202,226,256,282,316,
   344],
 [40,50,64,82,98,118,136,158,180,206,234,268,300,340,378],
 [40,50,64,82,98,118,136,158,180,208,232,262,288,322,350],
 [40,50,64,82,98,118,136,160,180,208,230,262,286,322,348],
 [40,50,64,82,98,118,138,162,188,220,252,290,330,380,430],
 [40,54,54],[40,54,68,74,80,82,84,84],
 [40,54,68,76,84,92,104,116,134,146,162,174,190,202,218,230]
  ,[40,54,68,76,86,90,94,96,98,98],
 [40,54,68,76,86,92,100,104,108,112,116,120,124,128,132,136,
   140],
 [40,54,68,76,86,94,102,108,112,116,120,124,128,132,136,140,
   144],[40,54,68,76,88,90,92,92],
 [40,54,68,76,88,92,98,100,104,104],
 [40,54,68,76,88,94,102,106,112,114,116,118,122,122],
 [40,54,68,78,90,98,106,114,122,130,138,146,154,162,170,178]
  ,[40,54,68,78,90,98,106,114,122,130,138,146,154,162,170,
   178,186],
 [40,54,68,78,90,98,108,114,122,128,136,142,150,156,164,170]
  ,[40,54,68,78,90,98,108,114,122,128,136,142,150,156,164,
   170,178],
 [40,54,68,78,90,100,108,116,124,132,140,148,156,164,172,
   180,188],[40,54,68,78,92,98,106,108,112,112],
 [40,54,68,78,92,98,106,112,120,126,134,140,148,154,162,168,
   176],
 [40,54,68,78,92,102,118,128,144,154,170,180,196,206,222,232 
  ],[40,54,68,78,92,104,120,132,148,160,176,188,204,216,
   232,244],[40,54,68,78,94,100,108,112,118,120,122,122],
 [40,54,68,78,94,102,114,122,134,142,154,162,174,182,194,202 
  ],[40,54,68,80,92,104,118,132,148,162,178,192,208,222,
   238,252],
 [40,54,68,80,94,106,120,132,146,158,172,184,198,210,224,236 
  ],[40,54,68,82,98,112,128,142,158,172,188,202,218,232,
   248],
 [40,54,68,82,98,112,128,142,158,172,188,202,218,232,248,262 
  ],[40,54,68,82,98,114,130,146,162,178,194,210,226,242,
   258],
 [40,54,68,82,98,114,130,146,162,178,194,210,226,242,258,274 
  ],[40,54,68,82,100,114,130,144,160,176,194,208,226,240,
   256],
 [40,54,68,82,100,114,130,144,160,176,194,208,226,240,256,
   270],
 [40,54,68,82,100,118,140,162,190,218,252,286,330,374,428],
 [40,54,68,82,102,120,144,170,204,238,284,330,392,454],
 [40,54,68,82,102,120,146,168,200,230,274,312,370,422],
 [40,54,68,84,106,126,154,180,216,252,300,350,416],
 [40,54,68,84,106,126,154,182,220,258,310,360,430],
 [40,54,68,84,106,128,158,188,232,272,330,382,460],
 [40,54,68,84,106,128,158,192,236,282,340,400],
 [40,54,68,84,108,130,160,186,222,258,306,352,414],
 [40,54,68,84,108,130,160,192,234,274,332,386,462],
 [40,54,68,84,108,132,164,198,248,300,370,444],[40,55,55],
 [40,55,69,83,92,93,93],[40,55,69,83,93,95,95],
 [40,55,69,83,97,101,101],
 [40,55,69,83,100,107,114,121,124,124],
 [40,55,69,85,95,102,109,112,112],
 [40,55,69,85,98,106,113,119,120,120],
 [40,55,69,85,99,108,115,122,124,124],
 [40,55,69,85,112,130,152,176,206,230,260,292,330,362,400],
 [40,55,69,87,101,123,149,171,201,235,265,303,345,383],
 [40,55,69,87,110,135,161,196,229,263,310,351,393,452],
 [40,57,71,81,83,83],[40,57,71,91,99,106,114,115,115],
 [40,57,71,91,105,116,132,145,160,180,197,216,240],
 [40,57,71,91,105,116,132,145,160,180,197,216,240,261],
 [40,57,71,95,115,137,169,197,227,267,303,341,389],
 [40,57,73,93,110,128,156,182,211,254,288,325],
 [40,57,73,99,110,118,121,121],
 [40,57,73,103,126,151,180,208,241,278,314,355],
 [40,57,73,103,126,155,196,229,283,322,367],
 [40,57,75,109,151,243,405],
 [40,57,75,115,143,199,235,307,351,439],
 [40,57,75,115,147,203,243,315,363,451],[40,63,77,86,86],
 [40,63,77,86,88,88],[40,63,77,86,88,90,90],
 [40,63,77,86,90,92,92],[40,63,79,94,103,109,111,111],
 [40,63,79,94,103,111,113,115,115],
 [40,63,79,96,105,111,111],
 [40,63,79,96,107,115,117,119,119],
 [40,63,79,98,107,110,110],[40,63,79,98,107,112,112],
 [40,63,79,98,109,112,114,114],
 [40,63,81,110,138,179,215,268,312,377],
 [40,63,81,110,138,181,217,272,316,383],
 [40,63,81,112,142,185,223,278,324,391],
 [40,65,110,167,274,471],[40,65,110,167,276,474],
 [40,65,110,167,276,478],[40,65,120,191,304,458],
 [40,65,120,191,304,459],[40,65,120,191,304,463],
 [40,65,120,191,304,464],[40,65,120,191,306,463],
 [40,65,120,191,306,468],[40,65,120,191,306,469],
 [40,65,120,191,306,481],[40,65,120,191,308,473],
 [40,65,120,191,308,486],[40,69,119,178,259,361,505],
 [40,69,119,178,266,381,580],[40,69,119,184,285,397,557],
 [40,69,119,184,285,397,565],[40,69,119,184,285,399,559],
 [40,69,119,184,285,404],[40,69,119,186,304,455],
 [40,69,119,190,313,466],[40,69,119,190,313,468],
 [40,69,119,190,320,489],[40,69,119,190,320,494],
 [40,69,119,190,322,507],[40,69,119,190,322,512],
 [40,69,119,192,328,504],[40,69,119,192,328,506],
 [40,69,119,192,341,565],[40,90,160,294,546],
 [40,90,160,294,548],[40,90,160,294,554],
 [40,90,160,294,556],[40,90,168,280,432],
 [40,90,168,280,437],[40,90,168,280,439],
 [40,90,168,290,478],[40,90,168,290,484],
 [40,90,168,290,485],[40,90,168,290,494],
 [40,90,168,290,499],[40,90,168,290,506],
 [40,90,168,294,491],[40,90,168,294,496],
 [40,90,168,294,500],[40,90,168,296,517],
 [40,90,168,297,512],[40,90,168,297,527],
 [40,90,168,302,534],[40,90,168,302,543],
 [40,90,168,302,549],[40,90,168,304,558],
 [40,90,168,304,561],[40,90,168,304,569],
 [40,90,168,306,558],[40,90,168,306,569],
 [40,90,168,306,581],[40,90,168,306,586],
 [40,90,168,311,572],[40,90,168,311,583],
 [40,90,168,311,587],[40,90,168,311,593],
 [40,90,168,313,591],[40,90,168,316,590],
 [40,90,168,316,597],[40,90,168,316,598],
 [40,90,168,316,600],[40,90,168,316,610],
 [40,90,168,318,631],[40,90,168,318,632],
 [40,90,176,338,610],[40,90,176,338,619],
 [40,90,176,340,603],[40,90,176,340,611],
 [40,90,176,340,616],[40,90,176,340,620],
 [40,90,176,340,625],[40,90,176,340,627],
 [40,90,176,340,629],[40,90,176,340,636],
 [40,90,176,340,642],[40,90,176,340,651],[45,45],
 [45,50,52,52],[45,50,52,53,53],[45,50,52,53,54,54],
 [45,50,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
   68,69,70,71,72,73],
 [45,50,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
   68,69,70,71,72,73,74],[45,50,52,55,55],
 [45,50,52,55,56,57,57],[45,50,52,55,56,57,58,58],
 [45,50,52,55,57,57],[45,50,52,55,57,59,59],
 [45,50,52,55,57,60,61,61],
 [45,50,52,55,57,60,61,63,64,66,67,69,70,72,73,75,76,78,
   79,81,82,84,85,87],
 [45,50,52,55,57,60,61,63,64,66,67,69,70,72,73,75,76,78,
   79,81,82,84,85,87,88],
 [45,50,52,55,57,60,62,63,64,65,67,69,70,71,72,74,76,77,
   78,79,81,83,84,85,86,88,90,91,92,93,95,97,98,99,100,
   102,104,105,106,107,109,111,112,113,114,116,118,119,120,
   121],
 [45,50,52,55,58,59,60,61,62,63,65,67,68,69,70,71,72,74,
   76,77,78,79,80,81,83,85,86,87,88,89,90,92,94,95,96,97,
   98,99,101,103,104,105,106,107,108,110,112,113,114,115],
 [45,50,52,55,58,60,63,65,68,70,73,75,78,80,83,85,88,90,
   93,95,98,100,103,105],
 [45,50,52,55,58,62,64,66,67,69,70,72,73,75,76,78,79,81,
   82,84,85,87,88,90],[45,50,56,59,62,64,64],
 [45,50,56,59,62,64,65,65],
 [45,50,56,59,63,67,69,71,73,75,77,79,81,83,85,87,89,91,
   93,95,97,99,101,103],
 [45,50,56,63,71,80,89,99,109,121,133,147,161,177,193,211,
   230,252,275,301,328],
 [45,50,56,63,71,80,90,100,111,122,134,146,159,172,186,200,
   215,230,246,262,279],
 [45,50,56,63,71,80,90,100,111,122,134,146,159,172,186,200,
   215,230,246,262,279,296],
 [45,50,56,63,71,80,90,100,112,124,138,152,167,182,198,214,
   232,250,270,290,311],
 [45,50,56,63,71,80,90,102,115,129,144,161,180,201,224,250,
   279,311,346,385],
 [45,50,56,63,71,80,90,102,115,129,144,161,180,201,224,250,
   279,311,346,385,429],
 [45,50,56,63,71,81,91,103,116,131,148,168,190,216,245,278,
   316,359,408],[45,50,57,60,64,65,66,66],
 [45,50,57,60,64,66,68,68],[45,50,57,60,64,66,68,69,69],
 [45,50,57,60,64,66,68,70,71,72,72],
 [45,50,57,60,64,66,68,70,72,75,76,77,78,80,80],
 [45,50,57,60,64,66,69,70,71,71],
 [45,50,57,60,65,66,68,70,73,74,76,78,81,82,84,86,89,90,
   92,94,97,98,100,102,105,106,108,110,113,114,116,118,121,
   122,124,126,129,130,132,134],[45,50,57,60,65,67,68,68],
 [45,50,57,60,65,68,73,76,80,82,86,88,92,94,98,100,104,
   106,110,112,116,118,122],
 [45,50,57,60,65,68,73,76,80,82,86,88,92,94,98,100,104,
   106,110,112,116,118,122,124],
 [45,50,57,60,65,68,73,77,82,86,91,96,100,105,109,114,118,
   123,127,132,136,141,145,150],
 [45,50,57,61,63,65,66,67,68,68],
 [45,50,57,61,63,66,68,69,70,71,71],
 [45,50,57,61,63,66,68,69,70,71,72,73,74,75,76,77,78,79,
   80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96],
 [45,50,57,61,63,67,69,70,72,73,74,76,77,78,80,81,82,84,
   85,86,88,89,90,92,93,94,96,97,98,100,101,102,104,105],
 [45,50,57,61,63,67,69,70,72,73,74,76,77,78,80,81,82,84,
   85,86,88,89,90,92,93,94,96,97,98,100,101,102,104,105,
   106],[45,50,57,61,64,66,66],
 [45,50,57,61,64,66,67,67],
 [45,50,57,61,64,66,68,70,72,74,76,78,80,82,84,86,88,90,
   92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,
   122],[45,50,57,61,64,67,68,69,69],
 [45,50,57,61,64,67,68,69,70,71,71],
 [45,50,57,61,64,67,68,70,72,73,75,77,78,80,82,83,85,87,
   88,90,92,93,95,97,98,100,102,103,105,107,108,110,112,113 
  ],[45,50,57,61,64,67,69,70,72,74,75,77,79,80,82,84,85,
   87,89,90,92,94,95,97,99,100,102,104,105,107,109,110,112,
   114],
 [45,50,57,61,64,67,69,71,74,76,78,81,83,85,88,90,92,95,
   97,99,102,104,106,109,111,113,116,118,120,123,125,127,
   130,132],
 [45,50,57,61,64,67,70,72,75,78,80,83,86,88,91,94,96,99,
   102,104,107,110,112,115,118,120,123,126,128,131,134,136,
   139,142],
 [45,50,57,61,64,68,70,74,78,80,84,88,90,94,98,100,104,
   108,110,114,118,120,124,128,130,134,138,140,144,148,150,
   154,158],[45,50,57,61,64,68,71,73,76,78,79,80,81,81],
 [45,50,57,61,64,68,71,74,76,80,83,85,88,91,94,96,100,103,
   105,108,111,114,116,120,123,125,128,131,134,136,140,143,
   145,148,151,154,156,160],
 [45,50,57,61,64,68,71,74,78,81,84,88,91,94,98,101,104,
   108,111,114,118,121,124,128,131,134,138,141,144,148,151,
   154,158],
 [45,50,57,61,64,68,72,74,76,77,79,80,81,82,84,85,86,87,
   89,90,91,92,94,95,96,97,99,100,101,102,104,105,106,107,
   109,110,111,112,114,115,116,117,119],
 [45,50,57,61,64,68,72,74,77,80,82,85,88,90,93,96,98,101,
   104,106,109,112,114,117,120,122,125,128,130,133,136,138,
   141],
 [45,50,57,61,64,68,72,74,77,80,82,85,88,90,93,96,98,101,
   104,106,109,112,114,117,120,122,125,128,130,133,136,138,
   141,144],[45,50,57,61,65,67,68,69,69],
 [45,50,57,61,65,68,70,72,73,74,75,75],
 [45,50,57,61,65,68,70,72,73,74,76,77,78,80,81,82,84,85,
   86,88,89,90,92,93,94,96,97,98,100,101,102,104,105],
 [45,50,57,61,65,68,70,72,73,74,76,77,78,80,81,82,84,85,
   86,88,89,90,92,93,94,96,97,98,100,101,102,104,105,106],
 [45,50,57,61,65,69,71,72,74,75,76,78,79,80,82,83,84,86,
   87,88,90,91,92,94,95,96,98,99,100,102,103,104,106],
 [45,50,57,61,65,69,71,72,74,75,76,78,79,80,82,83,84,86,
   87,88,90,91,92,94,95,96,98,99,100,102,103,104,106,107],
 [45,50,57,61,66,70,72,74,76,77,78,79,79],
 [45,50,57,61,66,71,73,76,80,82,85,89,91,94,98,100,103,
   107,109,112,116,118,121,125,127,130,134,136,139,143,145,
   148,152],
 [45,50,57,61,66,71,74,77,81,84,88,92,94,96,98,100,102,
   104,106,108,110,112,114,116,118,120,122,124,126,128,130,
   132,134,136],
 [45,50,57,61,66,72,76,79,83,87,90,93,97,100,103,107,111,
   114,117,121,124,127,131,135,138,141,145,148,151,155,159,
   162,165,169,172,175],
 [45,50,57,61,66,72,76,79,83,87,90,93,97,100,103,107,111,
   114,117,121,124,127,131,135,138,141,145,148,151,155,159,
   162,165,169,172,175,179],
 [45,50,57,61,66,72,77,80,82,84,86,87,88,90,92,93,94,96,
   98,99,100,102,104,105,106,108,110,111,112,114,116,117,
   118,120,122,123,124,126,128,129,130,132,134],
 [45,50,57,61,66,72,77,81,85,89,93,97,101,105,109,113,117,
   121,125,129,133,137,141,145,149,153,157,161,165,169,173,
   177,181],
 [45,50,57,62,67,70,73,75,78,81,83,85,88,91,93,95,98,101,
   103,105,108,111,113,115,118,121,123,125,128,131,133,135,
   138,141,143,145,148,151,153,155],
 [45,50,57,62,67,70,73,75,78,81,83,85,88,91,93,95,98,101,
   103,105,108,111,113,115,118,121,123,125,128,131,133,135,
   138,141,143,145,148,151,153,155,158],
 [45,50,57,62,68,71,73,73],
 [45,50,57,62,68,71,74,78,80,84,87,90,93,96,100,103,105,
   109,112,116,118,121,125,128,131,134,137,141,143,147,150,
   153,156,159,163,166,168,172,175,179],
 [45,50,57,62,69,75,82,87,93,99,103,110,115,119,126,131,
   135,142,147,151,158,163,167,174,179,183,190,195,199,206,
   211],
 [45,50,57,62,69,76,84,89,96,104,114,122,130,136,144,150,
   158,164,172,178,186,192],
 [45,50,57,62,69,76,84,89,96,104,114,122,130,136,144,150,
   158,164,172,178,186,192,200],
 [45,50,57,65,70,76,80,86,90,95,99,105,109,114,118,124,128,
   133,137,143,147,152,156,162,166,171,175,181,185,190,194,
   200,204,209,213,219,223],
 [45,50,57,65,70,77,83,90,94,99,104,109,116,121,128,133,
   140,145,151,156,161,168,173,180,185,192,197,203,208,213,
   220,225,232,237,244,249,255,260],
 [45,50,57,65,70,77,83,90,94,99,104,109,116,121,128,133,
   140,145,151,156,161,168,173,180,185,192,197,203,208,213,
   220,225,232,237,244,249,255,260,265],
 [45,50,57,65,71,79,86,94,102,110,119,128,139,149,161,173,
   187,200,214,228,242,257],
 [45,50,57,66,73,82,89,98,105,114,121,130,137,146,153,162,
   169,178,185,194,201,210,217],
 [45,50,57,66,74,83,91,100,108,117,125,134,142,151,159,168,
   176,185,193,202,210,219,227],
 [45,50,57,66,74,84,93,104,114,126,138,152,166,183,199,218,
   236,257,279,304,330,361],
 [45,50,57,66,74,84,93,104,115,129,141,156,169,186,200,218,
   234,255,272,294,312,336],
 [45,50,57,66,74,84,93,105,115,129,140,156,168,186,199,219,
   233,255,270,294,310,336],
 [45,50,57,66,74,84,94,106,118,132,148,167,186,209,234,264,
   294,330,370,418],
 [45,50,57,66,75,84,93,102,111,120,129,138,147,156,165,174,
   183,192,201,210,219,228,237],
 [45,50,57,66,76,87,98,109,120,131,142,153,164,175,186,197,
   208,219,230,241,252,263,274],
 [45,50,57,67,73,78,84,92,99,105,111,117,123,129,135,141,
   147,153,159,165,171,177],
 [45,50,57,67,73,78,84,92,99,105,111,117,123,129,135,141,
   147,153,159,165,171,177,183],
 [45,50,57,67,79,93,107,125,145,171,197,233,273,325,379,453]
  ,[45,50,57,67,79,93,110,129,152,177,208,240,279,317,366,
   414],
 [45,50,57,67,80,93,110,127,148,170,197,226,262,299,345,393,
   452],
 [45,50,57,67,80,95,113,134,159,188,224,265,315,372,441],
 [45,51,53,53],[45,51,55,55],
 [45,51,59,65,70,76,82,86,91,96,101,105,110,114,119,123,
   128,132,137,141,146,150,155,159,164,168,173,177,182,186,
   191,195,200,204,209,213,218],
 [45,51,59,68,75,84,92,104,116,132,149,169,189,213,239,270,
   304,343,389,439],
 [45,51,59,68,76,85,96,104,114,123,132,141,150,158,166,174,
   183,191,199,207,216,224,232,240,249,257,265,273,282,290,
   298,306],
 [45,51,59,68,76,85,96,104,114,123,132,141,150,158,166,174,
   183,191,199,207,216,224,232,240,249,257,265,273,282,290,
   298,306,315],
 [45,51,59,68,76,88,102,116,133,151,172,194,219,245,274,304,
   337,371,408],
 [45,51,61,69,75,81,88,92,96,100,102,105,108,110,112,114,
   115,117,119,120,122,124,125,127,129,130,132,134,135,137,
   139,140,142],
 [45,51,61,72,82,90,98,104,110,112,114,115,115],
 [45,51,61,72,82,92,103,115,127,138,151,163,176,188,201,215,
   228,242,257,271,286,302,317,333,350,366,383,401],
 [45,51,61,72,82,96,109,122,135,151,166,181,198,215,233,250,
   269,288,308,329,349,371],
 [45,51,61,72,82,96,109,125,140,158,175,195,215,235,258,282,
   306,331,359,386,416],[45,54,54],
 [45,54,63,67,71,73,75,75],[45,54,63,67,72,73,74,74],
 [45,54,63,67,72,73,75,75],
 [45,54,63,67,72,75,79,81,83,85,87,88,89,89],
 [45,54,63,67,72,77,83,88,93,96,99,101,103,105,107,109,111,
   113,115,117,119,121,123,125,127],
 [45,54,63,67,73,74,76,76],[45,54,63,67,73,75,76,76],
 [45,54,63,67,74,76,78,78],
 [45,54,63,68,73,76,79,81,83,84,85,85],
 [45,54,63,68,73,77,81,84,87,90,93,96,99,102,105,108,111,
   114,117,120,123,126,129,132],
 [45,54,63,68,73,77,81,84,87,90,93,96,99,102,105,108,111,
   114,117,120,123,126,129,132,135],
 [45,54,63,68,73,77,82,87,93,100,107,115,123,131,139,147,
   155,163,171,179,187,195,203],
 [45,54,63,68,73,77,82,87,93,100,107,115,123,131,139,147,
   155,163,171,179,187,195,203,211],
 [45,54,63,68,73,78,83,88,93,98,103,108,113,118,123,128,
   133,138,143,148,153,158,163,168],
 [45,54,63,68,74,76,78,79,80,80],
 [45,54,63,68,74,77,81,84,88,91,95,98,102,105,109,112,116,
   119,123,126,130,133,137,140],
 [45,54,63,68,74,77,81,84,88,91,95,98,102,105,109,112,116,
   119,123,126,130,133,137,140,144],
 [45,54,63,68,74,78,83,86,89,92,95,98,101,104,107,110,113,
   116,119,122,125,128,131,134],
 [45,54,63,68,74,78,83,86,89,92,95,98,101,104,107,110,113,
   116,119,122,125,128,131,134,137],
 [45,54,63,68,74,78,83,87,92,96,101,105,110,114,119,123,
   128,132,137,141,146,150,155,159],
 [45,54,63,68,74,78,83,88,94,100,106,112,118,124,130,136,
   142,148,154,160,166,172,178,184],
 [45,54,63,68,74,79,86,92,100,106,114,120,128,134,142,148,
   156,162,170,176,184,190,198],
 [45,54,63,68,74,79,86,92,100,107,115,122,130,137,145,152,
   160,167,175,182,190,197,205],[45,54,63,69,76,78,81,81],
 [45,54,63,69,76,79,81,82,83,83],
 [45,54,63,69,76,82,89,95,102,108,115,121,128,134,141,147,
   154,160,167,173,180,186,193],
 [45,54,63,69,76,82,89,95,102,108,115,121,128,134,141,147,
   154,160,167,173,180,186,193,199],
 [45,54,63,69,77,80,82,82],[45,54,63,69,77,80,83,83],
 [45,54,63,69,77,80,84,84],
 [45,54,63,69,77,80,84,85,87,87],
 [45,54,63,69,77,81,87,88,89,89],
 [45,54,63,69,77,82,86,89,94,97,99,102,107,110,112,115,120,
   123,125,128,133,136,138,141,146,149,151,154,159,162,164,
   167,172,175,177],
 [45,54,63,69,77,82,86,89,94,97,99,102,107,110,112,115,120,
   123,125,128,133,136,138,141,146,149,151,154,159,162,164,
   167,172,175,177,180],
 [45,54,63,69,77,82,87,90,94,99,104,107,109,109],
 [45,54,63,69,77,82,87,91,96,100,105,109,114,118,123,127,
   132,136,141,145,150,154,159,163],
 [45,54,63,69,77,82,87,92,97,102,107,112,117,122,127,132,
   137,142,147,152,157,162,167,172],
 [45,54,63,69,77,82,88,92,97,100,104,106,108,108],
 [45,54,63,69,77,82,89,94,101,106,113,118,125,130,137,142,
   149,154,161,166,173,178,185],
 [45,54,63,69,77,82,89,94,101,106,113,118,125,130,137,142,
   149,154,161,166,173,178,185,190],
 [45,54,63,69,77,83,90,97,105,112,120,127,135,142,150,157,
   165,172,180,187,195,202,210],
 [45,54,63,69,77,84,93,98,104,105,106,106],
 [45,54,63,69,77,84,94,100,109,115,122,128,136,142,149,155,
   163,169,176,182,190,196,203,209,217,223,230,236,244,250,
   257,263,271],
 [45,54,63,69,77,85,95,106,120,135,154,174,200,227,261,297,
   343,391,452],
 [45,54,63,69,77,85,96,105,117,129,146,164,189,213,247,281,
   329,376,443],
 [45,54,63,69,77,85,96,105,118,131,149,168,194,220,255,291,
   340,390,458],
 [45,54,63,69,78,83,88,93,98,103,108,113,118,123,128,133,
   138,143,148,153,158,163,168,173],
 [45,54,63,69,78,83,91,95,99,101,101],
 [45,54,63,69,78,84,90,95,102,107,113,118,125,130,136,141,
   148,153,159,164,171,176,182],
 [45,54,63,69,78,84,90,95,102,107,113,118,125,130,136,141,
   148,153,159,164,171,176,182,187],
 [45,54,63,69,78,85,93,100,108,116,126,133,141,149,159,166,
   174,182,192,199,207,215,225],
 [45,54,63,70,79,87,96,104,113,121,130,138,147,155,164,172,
   181,189,198,206,215,223,232],
 [45,54,63,71,80,87,95,102,110,117,125,132,140,147,155,162,
   170,177,185,192,200,207,215],
 [45,54,63,71,80,88,97,105,114,122,131,139,148,156,165,173,
   182,190,199,207,216,224,233],
 [45,54,63,71,80,88,98,107,118,128,139,149,160,170,181,191,
   202,212,223,233,244,254,265],
 [45,54,63,71,80,89,101,114,130,147,168,191,218,247,282,320,
   365,413],
 [45,54,63,71,80,89,101,114,131,148,169,191,219,246,281,316,
   362,407],
 [45,54,63,71,81,88,97,104,113,120,129,136,145,152,161,168,
   177,184,193,200,209,216,225],
 [45,54,63,71,81,89,99,109,122,136,154,172,196,221,253,286,
   330,376,436],
 [45,54,63,71,81,91,103,115,130,145,163,181,204,227,255,283,
   319,355,399,443],
 [45,54,63,71,81,91,103,116,132,148,168,189,216,244,279,316,
   364,413],
 [45,54,63,71,81,92,106,121,140,160,185,211,245,282,331,384,
   454],
 [45,54,63,72,84,94,106,117,131,145,161,176,194,210,229,246,
   267,287,310,331,356,378],
 [45,54,63,72,84,94,106,118,130,141,153,164,177,187,199,211,
   223,234,246,257,270,280],
 [45,54,63,72,84,96,110,124,141,158,179,200,226,252,284,316,
   356,396,446],
 [45,54,63,72,84,96,110,124,141,159,180,201,227,254,286,318,
   358,400],[45,55,57,57],[45,55,59,59],
 [45,55,59,61,61],[45,55,59,61,63,63],
 [45,55,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,
   91,93,95,97,99,101],[45,55,59,63,63],
 [45,55,67,69,69],
 [45,55,67,75,86,94,101,112,120,132,146,159,180,202,227,260,
   295,331,378,428],
 [45,55,67,76,89,99,110,123,135,145,157,169,180,192,203,214,
   226,237,247,259,270,280,293,304,314,327,337],
 [45,55,67,78,89,97,106,115,122,130,136,142,149,155,160,166,
   172,177,183,189,194,200,206,211,217,223,228,234],
 [45,55,67,78,90,98,109,120,133,145,157,173,186,200,216,231,
   250,265,281,300,316,335,354,373,395],
 [45,55,67,78,91,102,115,128,139,150,159,169,178,184,192,
   200,206,214,222,228,236,244,250,258,266,272,280,288],
 [45,55,67,78,91,102,115,128,140,157,174,186,203,214,226,
   240,253,268,286,299,314,326,339,351,365,381],
 [45,55,67,78,91,103,115,130,142,158,170,180,195,206,219,
   230,240,255,266,279,290,300,315,326,339],
 [45,55,67,80,95,112,130,152,175,203,236,274,319,371,433],
 [45,55,67,81,97,115,133,153,173,195,219,247,275,307,341,
   377,415],
 [45,55,67,83,97,115,133,153,173,197,221,247,275,305,339,
   375,413],
 [45,55,67,83,98,117,135,160,184,218,252,297,344,402],
 [45,55,67,83,98,117,136,159,185,216,251,294,344,402],
 [45,55,69,79,85,91,95,97,97],
 [45,55,69,79,85,93,99,105,113,119,125,133,139,145,153,159,
   165,173],
 [45,55,69,79,85,93,99,107,115,121,129,135,143,151,157,165,
   171,179,187],[45,55,69,79,87,91,91],
 [45,55,69,79,87,93,97,99,99],
 [45,55,69,79,87,93,97,101,107,111,115,121,125,129,135,139,
   143,149],[45,55,69,79,87,93,99,103,105,105],
 [45,55,69,79,87,95,103,103],
 [45,55,69,79,87,95,103,111,117,123,127,131,135,139,143,147,
   151,155],[45,55,69,79,89,97,103,109,111,111],
 [45,55,69,79,89,97,105,111,119,125,133,139,147,153,161,167,
   175,181,189,195,203],
 [45,55,69,79,89,97,105,113,119,123,125,127,129,129],
 [45,55,69,79,89,97,105,113,121,129,137,145,153,161,169,177,
   185,193],[45,55,69,79,89,99,105,109,111,111],
 [45,55,69,79,89,99,111,123,133,143,155,165,175,187,197,207,
   219],
 [45,55,69,79,89,99,111,123,133,143,155,165,175,187,197,207,
   219,229],[45,55,69,79,89,101,109,113,115,115],
 [45,55,69,79,89,101,113,129,143,161,175,193,207,225,239,
   257,271],
 [45,55,69,79,89,103,119,133,149,163,179,193,209,223,239,
   253,269,283,299],
 [45,55,69,79,89,103,119,135,155,179,203,235,271,313,363,423 
  ],[45,55,69,79,91,103,115,125,133,141,149,157,165,173,
   181,189,197,205,213,221],
 [45,55,69,79,91,103,115,131,145,159,173,185,197,209,223,
   241,255,263,275,291,305,319,333,345],
 [45,55,69,79,91,105,121,137,147,151,155,159,163,165,167,
   171,175,179,181,183,187,191,195,197,199,203,207,211,213,
   215,219,223,227,229,231,235],
 [45,55,69,79,91,105,121,137,147,151,155,159,163,165,167,
   171,175,179,181,183,187,191,195,197,199,203,207,211,213,
   215,219,223,227,229,231,235,239],
 [45,55,69,79,93,107,119,133,147,163,181,205,231,251,273,
   299,327,361,401],
 [45,55,69,79,93,113,135,157,185,219,259,309,369,439],
 [45,55,69,89,105,127,145,171,191,219,241,273,297],
 [45,55,69,89,107,129,151,179,203,233,261,297],
 [45,55,69,89,107,131,151,179,201,233,257,293],
 [45,55,69,89,107,133,155,189,215,257,287,337],
 [45,55,69,89,107,133,157,193,227,279,329,407],
 [45,55,69,89,107,133,159,201,235,293,343,433],
 [45,55,69,89,109,133,157,185,213,245,277,313],
 [45,55,69,89,109,135,161,195,231,277,325,385],
 [45,55,69,89,109,135,165,203,247,303,371,457],
 [45,55,69,89,111,137,163,197,235,281,327,389],
 [45,55,69,89,111,139,171,211,253,303,361,431],
 [45,55,69,89,113,147,185,237,297,387,487],
 [45,56,64,68,70,72,72],
 [45,56,64,68,72,76,80,84,88,92,96,100,104,108,112,116,120,
   124,128],
 [45,56,64,71,75,80,84,89,93,98,102,107,111,116,120,125,
   129,134,138,143,147,152,156],[45,56,64,71,76,79,79],
 [45,56,64,71,76,79,80,80],
 [45,56,64,71,77,82,86,91,96,101,105,110,115,120,124,129,
   134,139,143,148,153,158],
 [45,56,64,71,77,82,86,91,96,101,105,110,115,120,124,129,
   134,139,143,148,153,158,162],
 [45,56,64,71,78,82,84,85,85],
 [45,56,65,69,72,75,77,79,81,83,85,87,89,91,93,95,97,99,
   101,103,105,107,109,111,113,115,117,119,121,123,125,127,
   129],
 [45,56,65,70,73,77,81,83,85,88,90,92,95,97,99,102,104,
   106,109,111,113,116,118,120,123,125,127,130,132,134,137,
   139,141],[45,56,65,70,75,80,84,85,85],
 [45,56,65,71,76,82,86,89,92,94,97,99,101,104,106,109,111,
   113,116,118,121,123,125,128,130,133,135,137],
 [45,56,65,71,77,86,93,100,106,113,119,124,130,137,143,148,
   154,161,167,172,178,185],
 [45,56,65,71,77,86,93,100,106,113,119,124,130,137,143,148,
   154,161,167,172,178,185,191],
 [45,56,65,71,78,86,95,106,117,132,149,169,191,218,248,284,
   325,372,428],[45,56,65,72,74,76,78,81,82,82],
 [45,56,65,72,76,81,85,89,92,94,95,96,97,98,98],
 [45,56,65,74,80,86,91,95,98,101,104,107,110,113,116,119,
   122,125,128,131,134,137,140,143,146,149],
 [45,56,65,74,83,91,99,108,116,123,130,137,146,153,160,169,
   178,186,193,200,207,216,223,230],
 [45,56,65,74,84,93,103,112,122,131,141,150,160,169,179,188,
   198,207,217,226,236,245],
 [45,56,65,74,84,97,112,130,149,170,193,217,244,271,302,332,
   367,400],
 [45,56,65,75,84,94,103,113,122,132,141,151,160,170,179,189,
   198,208,217,227,236,246],
 [45,56,65,75,84,94,104,114,123,133,142,152,161,171,180,190,
   199,209,218,228,237,247],
 [45,56,65,75,84,94,105,118,133,152,174,200,230,266,307,354,
   410],
 [45,56,65,75,85,95,105,115,125,135,145,155,165,175,185,195,
   205,215,225,235,245,255],
 [45,56,65,76,85,94,102,110,118,126,134,142,150,158,166,174,
   182,190,198,206,214,222],
 [45,56,65,76,85,94,102,111,119,128,136,145,153,162,170,179,
   187,196,204,213,221,230],
 [45,56,65,76,86,95,105,114,124,133,143,152,162,171,181,190,
   200,209,219,228,238,247],
 [45,56,65,76,87,98,110,122,136,149,165,179,197,212,232,248,
   270,287,311,329,355],
 [45,56,66,76,82,87,92,96,98,99,100,101,102,103,104,105,
   106,107,108,109,110,111,112,113,114,115,116,117,118,119,
   120,121,122,123,124,125,126,127,128,129,130,131,132],
 [45,56,66,76,85,96,108,121,137,156,178,204,234,270,312,361,
   419],
 [45,56,66,78,87,95,104,115,125,136,146,157,167,178,188,199,
   209,220,230,241,251,262],
 [45,56,66,78,88,99,110,123,137,153,171,190,212,236,265,297,
   335,378,428],[45,56,66,79,90,99,107,113,116,118,119,119 
  ],[45,56,66,79,91,101,112,123,134,145,156,167,178,189,
   200,211,222,233,244,255,266],
 [45,56,66,79,91,103,111,121,130,137,143,151,160,168,175,
   184,194,203,211,221,232,242,251,262,274],
 [45,56,66,79,92,107,122,138,154,170,186,202,218,234,250,
   266,282,298,314,330],
 [45,56,66,79,93,108,124,142,160,178,196,213,230,247,264,
   281,298],[45,56,67,72,76,78,78],
 [45,56,67,72,78,82,84,85,86,87,88,90,91,92,92],
 [45,56,67,72,78,82,88,92,98,102,108,112,118,122,128,132,
   138,142,148,152,158,162,168],[45,56,67,73,77,77],
 [45,56,67,73,78,80,81,81],
 [45,56,67,73,79,85,92,96,101,106,112,116,121,126,132,136,
   141,146,152,156,161,166,172],
 [45,56,67,73,80,86,94,101,110,118,128,136,146,154,164,172,
   182,190,200,208,218,226],
 [45,56,67,74,80,85,89,95,99,104,109,113,119,123,128,133,
   137,143,147,152],
 [45,56,67,74,80,85,92,98,107,115,127,136,148,157,169,178,
   190,199,211,220,232,241],
 [45,56,67,74,80,86,89,92,94,94],
 [45,56,67,74,81,86,90,92,93,94,94],
 [45,56,67,74,83,88,94,99,102,106,109,111,112,114,116,118,
   121,124,126,127,129,131,133,136,139,141,142,144,146,148,
   151,154,156,157,159,161,163,166,169,171,172,174,176,178,
   181,184,186,187,189],[45,56,67,75,82,86,86],
 [45,56,67,75,83,91,100,107,113,120,128,135,141,148,156,163,
   169,176,184,191,197],
 [45,56,67,75,83,91,100,107,113,120,128,135,141,148,156,163,
   169,176,184,191,197,204],
 [45,56,67,75,84,91,98,104,110,116,122,128,134,140,146,152,
   158,164],
 [45,56,67,75,84,91,98,104,110,116,122,128,134,140,146,152,
   158,164,170],
 [45,56,67,75,84,92,97,102,106,109,112,115,118,121,124,127,
   130,133,136,139,142,145,148],
 [45,56,67,75,84,92,97,102,106,109,112,115,118,121,124,127,
   130,133,136,139,142,145,148,151],
 [45,56,67,75,84,92,101,108,117,125,133,141,150,157,166,174,
   182,190],
 [45,56,67,75,87,98,112,126,142,159,177,197,217,240,262,288,
   312,341,367],
 [45,56,67,75,87,98,112,126,142,159,177,197,217,240,262,288,
   312,341,367,399],
 [45,56,67,77,85,97,105,115,123,134,142,153,161,172,180,191,
   199,210,218,229,237,248],
 [45,56,67,77,87,98,106,115,124,133,142,151,160,169,178,187,
   196,205,214,223,232,241],
 [45,56,67,77,87,98,108,119,131,141,152,164,174,185,197,207,
   218,230],
 [45,56,67,77,88,101,113,126,143,163,185,209,238,270,303,
   339,384,435],
 [45,56,67,78,87,96,102,107,111,114,116,117,118,118],
 [45,56,67,78,89,103,115,130,145,162,179,197,216,238,260,
   283,307,334,361,389],
 [45,56,67,78,89,103,115,130,145,162,179,197,216,238,260,
   283,307,334,361,389,418],[45,57,57],
 [45,57,69,79,91,100,112,123,137,148,161,171,184,195,209,
   220,234,244,257,268,282,294],
 [45,57,69,79,92,99,109,114,120,123,127,129,132,133,135,135]
  ,[45,57,69,79,92,100,111,118,128,135,145,152,162,169,179,
   186,196,203,213,220,230,237,247],
 [45,57,69,79,93,99,110,113,119,120,122,122],
 [45,57,69,80,94,103,114,122,131,139,148,156,165,173,182,
   190,199,207,216,224,233,241,250],
 [45,57,69,80,95,104,117,125,137,144,156,163,175,182,193,
   200,212,219,231,238,249,256,268],
 [45,57,69,80,95,107,121,137,159,182,215,248,292,334,390,445 
  ],[45,57,69,80,96,110,125,138,155,170,186,201,219,236,
   257,274,293,309,329,349,372,390],
 [45,57,69,81,95,107,121,133,147,159,173,185,199,211,225,
   237,251,263,277,289,303,315],
 [45,57,69,81,97,113,135,157,189,223,271,325,399,481],
 [45,57,69,81,99,116,136,155,179,202,228,250,277,301,331,
   357,389,419],
 [45,57,69,82,98,112,130,145,165,181,203,220,244,262,288,
   307,335,355,385,406],
 [45,57,69,82,98,113,131,148,169,189,213,236,265,293,327,
   360,402],
 [45,57,69,82,99,116,137,160,191,228,280,339,423],
 [45,57,69,82,99,116,138,162,193,227,270,316,377,442],
 [45,59,63,65,68,69,69],[45,59,63,66,66],
 [45,59,63,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,
   81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96],
 [45,59,63,66,68,69,69],[45,59,63,66,68,70,72,73,73],
 [45,59,63,66,68,71,73,75,77,80,82,84,86,89,91,93,95,98,
   100,102,104,107,109,111,113,116,118,120,122,125,127,129,
   131],[45,59,63,66,70,71,72,73,73],
 [45,59,63,66,70,72,73,74,75,75],
 [45,59,63,66,70,72,73,75,77,78,80,82,83,85,87,88,90,92,
   93,95,97,98,100,102,103,105,107,108,110,112,113,115,117],
 [45,59,63,67,68,69,70,72,72],[45,59,63,67,69,69],
 [45,59,63,67,69,70,72,72],[45,59,63,67,69,71,71],
 [45,59,63,67,70,70],[45,59,63,67,70,71,72,72],
 [45,59,63,67,70,73,76,79,82,85,88,91,94,97,100,103,106,
   109,112,115,118,121,124,127],
 [45,59,63,67,71,74,77,80,83,86,89,92,95,98,101,104,107,
   110,113,116,119,122,125,128],
 [45,59,76,84,91,96,102,106,112,118,125,132,140,148,157,166,
   177,187,200,212,227],
 [45,59,76,84,93,99,105,106,108,108],
 [45,59,76,84,93,100,105,109,111,114,117,120,123,125,128,
   131,134,137,139,142,145,148,151,153,156,159,162,165,167,
   170,173,176,179,181,184,187,190,193,195,198,201],
 [45,59,76,84,93,105,118,128,136,150,164,175,186,201,216,
   227,238,253,268],[45,59,76,85,94,99,106,107,108,108],
 [45,59,76,85,95,104,112,115,118,118],
 [45,59,76,85,96,105,116,125,137,146,155,167,176,185,197,
   206,215],
 [45,59,76,85,96,106,116,122,128,136,146,152,158,166,176,
   182,188,196,206,212],
 [45,59,76,85,97,105,115,123,133,141,151,159,169,177,187,195 
  ],[45,59,76,85,97,105,115,123,133,141,151,159,169,177,
   187,195,205],
 [45,59,76,85,97,108,117,127,136,146,155,165,174,184,193,
   203,212,222,231,241],
 [45,59,76,85,97,108,117,127,136,146,155,165,174,184,193,
   203,212,222,231,241,250],
 [45,59,76,86,96,101,108,114,123,133,145,156,168,179,191,
   202,214,225,237,248,260],
 [45,59,76,86,96,106,113,117,121,124,126,126],
 [45,59,76,86,97,103,109,111,113,115,117,119,121,125,127,
   129,131,133,135,137,141,143,145,147,149,151,153,157,159,
   161,163,165,167,169,173,175,177,179,181,183,185,189,191,
   193,195,197,199],
 [45,59,76,86,97,103,109,111,113,115,117,119,121,125,127,
   129,131,133,135,137,141,143,145,147,149,151,153,157,159,
   161,163,165,167,169,173,175,177,179,181,183,185,189,191,
   193,195,197,199,201],
 [45,59,76,86,97,105,113,118,125,130,136,142,147,152,157,
   163,169,177,182,189,194,200,206,211,216,221],
 [45,59,76,86,97,105,113,118,125,130,136,142,147,152,157,
   163,169,177,182,189,194,200,206,211,216,221,227,233],
 [45,59,76,86,97,107,116,125,133,141,146,151,153,155,155],
 [45,59,76,86,97,108,122,135,149,163,177,194,210,231,249,
   270,288,309,327,348],
 [45,59,76,86,99,111,124,134,144,152,161,169,178,186,195,
   203,212,220,229,237],
 [45,59,76,86,99,112,123,135,145,153,161,171,181,190,198,
   206,216,226,235,243,251,261,271,280,288,296,306,316,325,
   333,341],
 [45,59,76,86,100,115,129,146,164,188,213,243,274,310,347,
   389,432],
 [45,59,76,87,100,114,130,146,160,178,196,216,232,254,274],
 [45,59,76,87,101,113,124,131,139,141,141],
 [45,59,76,87,101,113,129,141,159,173,187,196,210,222,236,
   245,259,271],
 [45,59,76,91,109,124,142,160,179,196,214,231,249],
 [45,59,76,92,112,130,153,174,198,220,246,269],
 [45,59,76,92,112,130,153,174,198,220,246,269,293],
 [45,59,76,93,113,131,153,173,196,217,242,265],
 [45,59,76,93,113,131,153,173,196,217,242,265,291],
 [45,59,76,93,114,137,166,199,241,292,353,423],
 [45,59,76,93,115,137,164,194,230,270,314,364],
 [45,59,76,93,118,148,187,236,300,383,491],
 [45,59,76,93,119,147,190,240,311,400],
 [45,59,76,94,117,140,168,200,237,280,329,387],
 [45,59,76,95,119,145,175,209,250,295,348,408],
 [45,59,77,86,96,99,99],[45,59,77,87,94,96,97,97],
 [45,59,77,87,97,104,114,127,145,165,186,209,237,266,295,
   326,362,399,436],
 [45,59,77,87,101,112,125,137,148,162,173,186,199,211,223,
   235,249],
 [45,59,77,88,100,111,120,131,142,153,164,175,186,197,208,
   219],
 [45,59,77,88,101,113,129,143,160,180,200,221,244,269,297,
   327],
 [45,59,77,88,102,115,130,147,165,181,200,218,236,256,277,
   296,319],[45,59,77,88,103,119,144,178,217,270,344,441],
 [45,59,77,90,102,113,124,134,143,156,170,183,196,212,229,
   247,263,281,299],
 [45,59,77,90,105,119,132,143,151,159,166,172,178,184,190,
   196,202,208,214,220,226,232,238,244,250,256,262],
 [45,59,77,90,105,119,132,143,151,159,166,172,178,184,190,
   196,202,208,214,220,226,232,238,244,250,256,262,268,274],
 [45,59,77,90,105,121,136,153,171,192,213,237,264,293,323],
 [45,59,77,90,106,121,137,154,171,191,211,232,254,276,297,
   319,341],
 [45,59,77,90,106,122,138,152,162,170,177,188,196,206,214,
   221,232,240,250,258,265,276,284,294],
 [45,59,77,90,106,122,138,152,162,170,177,188,196,206,214,
   221,232,240,250,258,265,276,284,294,302,309],
 [45,59,77,95,120,145,179,218,267,325,394,481],
 [45,59,77,95,122,148,185,227,280,345,425],
 [45,59,77,95,123,152,192,241,302,381,481],
 [45,59,77,97,123,152,190,231,283,341,417],
 [45,59,77,98,125,157,200,253,321,403],
 [45,60,66,69,71,71],
 [45,60,66,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,
   99],[45,60,66,69,72,72],
 [45,60,66,69,72,75,78,81,84,87,90,93,96],
 [45,60,66,69,73,79,79],[45,60,66,69,74,76,76],
 [45,60,66,69,74,81,86,93,102,109,118,129],
 [45,60,66,71,73,75,75],
 [45,60,66,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,
   101],[45,60,66,71,74,77,77],
 [45,60,66,71,74,78,81,85,88,92,95,99],
 [45,60,66,71,74,78,81,85,88,92,95,99,102],
 [45,60,66,71,75,75],[45,60,66,71,75,76,77,77],
 [45,60,66,71,75,77,78,78],[45,60,66,71,76,77,77],
 [45,60,66,71,76,79,81,82,82],[45,60,66,71,76,80,80],
 [45,60,66,71,77,79,82,83,85,85],
 [45,60,66,71,77,81,85,91,97,103,109,115,121,127,133,139,
   145],[45,60,66,71,77,84,91,103,112,126,140,156],
 [45,60,70,77,80,80],[45,60,70,77,80,81,81],
 [45,60,70,77,80,82,82],[45,60,70,77,83,84,84],
 [45,60,70,77,83,84,85,85],[45,60,70,77,83,85,85],
 [45,60,70,77,83,86,86],[45,60,70,77,83,87,87],
 [45,60,70,77,83,87,88,88],[45,60,70,77,83,89,89],
 [45,60,70,77,84,86,86],[45,60,70,77,84,86,88,88],
 [45,60,70,77,84,87,87],[45,60,70,77,84,88,88],
 [45,60,70,77,91,99,110,121,139,151,166,181,203,219,238,257,
   283],
 [45,60,70,77,91,100,111,122,140,153,168,183,205,222,241,
   260,286],
 [45,60,70,77,91,104,115,126,146,165,180,195,221,246,265,
   284,316],
 [45,60,70,79,86,97,110,121,136,153,168,187,208,227],
 [45,60,70,79,95,109,122,146,164,181,213,235,256,296],
 [45,60,70,79,95,109,125,149,167,187,219,241,265,305],
 [45,60,70,79,95,114,127,151,178,195,227,262,283,323],
 [45,60,71,76,78,78],[45,60,71,76,78,79,80,80],
 [45,60,71,76,79,79],[45,60,71,76,79,80,80],
 [45,60,71,76,79,80,82,83,85,86,88,89,91,92,94,95,97,98,
   100,101,103],
 [45,60,71,76,79,81,83,85,87,89,91,93,95,97,99,101,103,
   105,107,109,111],[45,60,71,76,80,83,84,84],
 [45,60,71,76,80,84,86,87,88,88],
 [45,60,71,76,80,85,89,90,90],
 [45,60,71,76,80,85,91,93,93],[45,60,71,76,81,84,85,85],
 [45,60,71,76,81,85,86,86],
 [45,60,71,76,81,87,95,100,107,112,119,124,131,136,143,148,
   155],[45,60,71,76,81,88,98,109,120,133,149,166,183,202]
  ,[45,60,71,78,80,80],[45,60,71,78,81,82,82],
 [45,60,71,78,81,83,83],[45,60,71,78,82,83,84,84],
 [45,60,71,78,82,85,88,91,94,97,100,103,106,109,112,115,
   118,121,124,127],
 [45,60,71,78,82,85,88,91,94,97,100,103,106,109,112,115,
   118,121,124,127,130],
 [45,60,71,78,82,86,90,94,98,102,106,110,114,118,122,126,
   130,134,138,142],[45,60,71,78,83,88,92,96,98,99,99],
 [45,60,71,78,83,88,95,103,111,119,127,135,143,151,159,167,
   175],[45,60,71,78,84,87,87],
 [45,60,76,91,111,129,155,179,211,245,287,335],
 [45,60,76,91,111,129,155,181,215,249,295,341],
 [45,60,76,91,111,129,155,183,217,257,303,355],
 [45,60,76,91,112,134,158,186,218,258,302,352],
 [45,60,76,91,112,135,164,199,240,289],
 [45,60,76,93,111,128,147,164,182,199,218,236],
 [45,60,76,93,112,129,148,164,183,200,220,238],
 [45,60,76,93,112,129,148,165,184,201,221,239],
 [45,60,76,93,112,129,149,165,183,200,218,236],
 [45,60,76,93,112,132,154,176,201,226,254,285],
 [45,60,76,93,112,132,157,184,217,253],
 [45,60,76,93,114,134,157,181,207,235,264,296],
 [45,60,76,93,114,135,162,191,227,268],
 [45,60,81,93,102,113,120,122,122],
 [45,60,81,93,102,113,122,127,130,133,136,139,142,145,148,
   151,154,157],
 [45,60,81,93,102,113,122,129,135,141,143,143],
 [45,60,81,93,102,113,123,133,143,154,164,173,184,194,203,
   214,224],[45,60,81,93,102,116,125,129,134,136,136],
 [45,60,81,93,103,115,123,129,137,142,143,143],
 [45,60,81,93,103,116,129,143,159,177,197,219],
 [45,60,81,93,103,117,124,125,125],
 [45,60,81,93,103,118,130,138,145,149,150,150],
 [45,60,81,93,103,118,131,144,162,180,199,223],
 [45,60,81,93,103,119,134,147,162,174,184,194,204],
 [45,60,81,95,103,108,111,112,112],
 [45,60,81,95,103,108,113,117,119,120,120],
 [45,60,81,95,103,108,114,119,123,128,134,139,143,148,154,
   159,163],
 [45,60,81,95,103,111,119,126,132,138,146,154,161,167,173,
   181,189,196,202],
 [45,60,81,95,104,114,127,142,158,174,190,206,222,238,254,
   270],[45,65,79,85,88,88],[45,65,79,87,88,88],
 [45,65,79,87,94,94],[45,65,79,89,94,94],
 [45,65,79,93,104,107,108,109,109],
 [45,65,79,93,104,111,115,117,118,119,119],
 [45,65,79,93,107,111,111],[45,65,79,93,109,114,115,115],
 [45,65,79,95,104,104],[45,65,79,95,104,111,115,116,116],
 [45,65,79,95,106,117,133,147,162,182,200,219,243],
 [45,65,79,95,124,155,180,220,272,311,366,434],
 [45,65,79,97,113,136,163,188,219,254,287,326,369],
 [45,65,79,97,113,136,163,188,219,254,287,326,369,410],
 [45,65,79,99,112,119,127,133,133],
 [45,65,79,99,112,123,139,152,167,187,204,223,247],
 [45,65,79,103,130,152,188,227,257,305,356,394],
 [45,65,81,89,90,91,92,93,94,94],
 [45,65,81,93,101,103,103],
 [45,65,81,93,101,105,109,111,113,115,115],
 [45,65,81,93,115,129,149,167,197,219,247,273],
 [45,65,81,96,105,109,110,110],
 [45,65,81,96,108,112,115,115],
 [45,65,81,96,114,132,157,188,212,245,286,316],
 [45,65,81,97,101,103,105,105],[45,65,81,97,103,105,105],
 [45,65,81,97,103,105,107,109,111,113,115,117,119,121,123,
   125,127],
 [45,65,81,97,103,105,107,109,111,113,115,117,119,121,123,
   125,127,129],[45,65,81,97,103,107,109,111,113,113],
 [45,65,81,97,107,109,109],[45,65,81,97,107,115,115],
 [45,65,81,97,109,115,119,123,127,131,135,139,143,147,151,
   155],
 [45,65,81,97,109,115,121,125,129,133,137,141,145,149,153,
   157],
 [45,65,81,97,109,115,121,125,129,133,137,141,145,149,153,
   157,161],
 [45,65,81,97,109,121,127,131,135,139,143,147,151,155,159,
   163],
 [45,65,81,97,109,121,127,131,135,139,143,147,151,155,159,
   163,167],[45,65,81,97,123,147,171,215,249,281,341],
 [45,65,81,98,110,118,123,124,126,127,127],
 [45,65,81,100,110,118,121,121],
 [45,65,81,100,118,132,155,179,202,233,265,296],
 [45,65,81,101,113,133,157,177,205,237,265],
 [45,65,81,101,115,137,161,181,209,241,269],
 [45,65,81,102,112,116,117,117],
 [45,65,81,105,125,139,143,145,147,147],
 [45,65,81,105,129,157,179,209,247,287,331],
 [45,65,81,105,139,171,209,247,297,345,399],
 [45,65,81,105,139,181,219,267,325,387,441],
 [45,65,81,106,124,132,137,137],
 [45,65,81,106,125,133,136,136],
 [45,65,81,110,134,163,203,237,290,330,375],
 [45,65,81,110,142,173,219,261,318,378,429],
 [45,65,81,114,153,197,271,347,431],
 [45,65,83,98,109,116,120,122,124,125,126,126],
 [45,65,83,103,116,129,145,158,173,193,210,229,253],
 [45,65,83,107,135,167,203,243,287,335],
 [45,65,83,109,137,171,207,249,293,343],
 [45,65,83,109,139,173,211,253,299,349],
 [45,65,83,113,145,187,231,285,341,407],
 [45,65,83,115,143,187,223,279,323,391],
 [45,65,83,121,151,205,243,313,359,445],
 [45,65,83,121,159,213,267,337,407],
 [45,65,83,125,177,260,369,516],
 [45,65,85,111,141,177,217,263,315,371],
 [45,65,85,114,140,169,209,245,298,340,385],
 [45,65,87,125,159,213,255,325,375,461],
 [45,65,89,107,111,113,115,119,119],
 [45,65,89,107,111,115,115],
 [45,65,89,107,111,115,117,121,121],
 [45,65,89,107,111,115,117,121,123,125,125],
 [45,65,89,107,115,119,123,123],
 [45,65,89,107,115,121,123,125,125],
 [45,65,89,107,115,121,125,129,129],
 [45,65,89,107,115,121,125,129,131,131],
 [45,65,89,107,117,121,121],[45,65,89,107,117,121,123,123],
 [45,65,89,107,121,137,147,159,167,179,187,199,207,219,227],
 [45,65,89,107,121,137,147,161,169,181,189,201,209,221,229],
 [45,65,89,107,121,139,153,167,175,189,197,211,219,233,241],
 [45,65,89,107,123,129,129],[45,65,89,107,123,135,141,141],
 [45,65,89,107,129,143,169,199,233,255,293,335],
 [45,65,89,107,129,153,189,219,257,297,349,391],
 [45,65,89,107,135,171,231,319,445],
 [45,65,89,111,123,149,183,205,245,291,321],
 [45,65,89,111,123,149,183,205,245,295,329],
 [45,65,89,111,123,149,183,205,247,293,323],
 [45,65,89,111,129,155,195,227,267,325],
 [45,65,89,111,129,155,195,227,267,325,371],
 [45,65,89,111,129,155,195,227,269,327],
 [45,65,89,111,129,155,195,227,269,327,371],
 [45,65,89,111,137,167,201,243,285,331],
 [45,65,89,111,147,205,295,449],
 [45,65,89,111,147,215,315,479],
 [45,65,99,130,166,207,262,338,437],
 [45,65,101,143,196,272,369,498],
 [45,65,101,145,216,317,509],[45,65,103,160,250,425],
 [45,65,105,143,187,236,274,307,333,348,355,358,358],
 [45,65,105,149,214,313,454],
 [45,65,107,146,194,238,280,311,334,348,355,358,358],
 [45,65,107,152,213,278,344,426],
 [45,65,109,165,255,382,573],[45,68,82,88,88],
 [45,68,82,88,89,89],[45,68,82,88,89,90,90],
 [45,68,82,88,90,91,91],[45,68,82,92,92],
 [45,68,82,92,93,93],[45,68,82,92,94,95,95],
 [45,68,82,92,96,102,106,108,108],[45,68,82,96,97,98,98],
 [45,68,82,96,98,99,99],[45,68,84,96,104,107,108,108],
 [45,68,84,96,104,108,109,110,110],
 [45,68,84,97,105,108,108],[45,68,84,97,105,109,109],
 [45,68,84,97,106,109,110,110],[45,68,84,97,106,111,111],
 [45,68,84,97,106,112,114,115,115],
 [45,68,84,100,107,114,115,116,117,119,119],
 [45,68,84,100,108,115,116,116],[45,68,84,101,109,116,116],
 [45,68,84,102,109,112,113,114,115,116,116],
 [45,68,84,103,111,114,114],
 [45,68,84,103,120,140,152,159,166,169,169],
 [45,68,84,103,122,149,176,216,253,298,335,391,442],
 [45,68,84,107,115,123,123],[45,68,84,107,116,123,124,124],
 [45,68,84,109,134,159,180,208,237,268,297,333,370],
 [45,68,84,109,134,161,182,212,241,280,309,349,386],
 [45,68,86,109,136,167,202,241,284,331],
 [45,68,86,109,137,170,207,248,293,342],
 [45,68,86,109,137,170,208,252,300,352],
 [45,68,86,110,138,171,207,248,292,341],
 [45,68,86,115,142,183,218,271,314,379],
 [45,68,86,116,144,187,223,278,322,389],
 [45,68,86,117,159,232,328,481],
 [45,68,86,122,150,203,239,308,352,437],
 [45,68,86,123,173,260,382,612],[45,70,87,96,97,97],
 [45,70,87,100,102,104,107,108,110,110],
 [45,70,87,101,104,106,107,108,108],
 [45,70,87,101,108,115,126,133,144,151,162,169,180,187,198,
   205],[45,70,88,104,107,108,108],
 [45,70,89,96,98,99,99],[45,70,89,96,99,100,100],
 [45,70,89,101,107,112,115,116,117,117],
 [45,70,89,101,108,114,120,124,128,134,138,142,148,152,156],
 [45,70,89,101,113,115,117,119,119],
 [45,70,89,101,114,121,129,137,144,151,158,165,172,179,186,
   193],[45,70,89,104,113,118,118],
 [45,70,89,109,117,126,129,131,133,135,137,138,139,139],
 [45,70,89,110,124,134,139,139],
 [45,70,89,111,121,128,131,133,134,134],
 [45,70,90,108,117,122,122],
 [45,70,90,115,133,148,165,175,192,202,219,229,246],
 [45,70,91,103,114,119,123,125,126,126],
 [45,70,91,104,115,120,123,123],
 [45,70,91,109,124,134,141,142,142],
 [45,70,91,109,129,147,170,192,216,244,274],
 [45,70,91,110,127,132,136,137,138,138],
 [45,70,91,111,135,146,150,150],
 [45,70,91,117,145,179,215,257,301,351],
 [45,70,91,120,138,161,191,217,248,286],
 [45,70,91,124,153,197,233,289,333,401],
 [45,70,91,124,160,205,252,309,367],
 [45,70,91,124,160,205,252,309,367,435],
 [45,70,92,120,148,184,220,264,308,360],
 [45,70,93,113,122,127,129,132,133,134,135,135],
 [45,70,93,114,124,129,130,131,132,133,133],
 [45,70,93,115,126,132,134,135,135],
 [45,70,93,116,145,178,215,256,301,350],
 [45,70,93,117,133,143,151,156,160,165,169,172,175],
 [45,70,93,118,138,152,162,166,166],
 [45,70,93,119,136,149,165,175,184,197,205,213],
 [45,70,93,119,136,149,165,175,184,197,205,213,225],
 [45,70,93,122,150,178,211,240,274,319],
 [45,70,93,122,157,201,250,306,367,435],
 [45,70,93,123,158,202,249,305,364,432],
 [45,70,93,128,157,183,199,202,202],
 [45,70,93,132,167,197,215,215],
 [45,70,93,132,168,210,265,312,386],
 [45,70,94,129,159,188,216,251,303,351,396],
 [45,70,95,128,169,211,256,305,370,427],
 [45,70,95,134,178,231,289,357,430],
 [45,70,95,143,196,276,358,468],
 [45,70,96,146,192,264,324,418],
 [45,70,97,130,149,166,183,191,195,200,203,203],
 [45,70,97,130,170,224,288,357,435],
 [45,70,97,133,189,278,418],
 [45,70,97,137,183,236,292,359,429],
 [45,70,97,142,183,227,281,333,398],
 [45,70,97,142,206,296,408],
 [45,70,98,139,171,199,223,238,250,254,254],
 [45,70,99,138,174,222,270,318,377,447],
 [45,70,99,141,182,225,251,262,266,266],
 [45,70,99,141,190,256,323,422],
 [45,70,99,144,194,247,280,291,293,293],
 [45,70,99,146,212,305,415],[45,70,99,149,203,289,384,540],
 [45,70,99,154,244,397,637],[45,70,99,163,262,445],
 [45,70,99,163,264,457],[45,70,100,156,221,305,407],
 [45,70,103,124,141,158,171,179,189,196,202,210,216,222,230,
   236],[45,70,103,145,187,251,315,403],
 [45,70,103,148,196,267,341,429],
 [45,70,105,131,150,172,187,200,205,207,209,212,215,217,217],
 [45,70,105,131,153,161,165,167,168,168],
 [45,70,105,131,155,167,177,186,195,204,213,222,231,240,249],
 [45,70,105,131,155,168,174,175,175],
 [45,70,105,131,158,181,197,213,228,243,258,273,288,303],
 [45,70,105,134,169,206,239,293,346,401],
 [45,70,105,136,160,201,246,287,349,412],
 [45,70,105,136,169,223,285,356,471],
 [45,70,105,137,168,195,223,242,261,287,305,323],
 [45,70,105,137,173,198,210,218,224,226,227,227],
 [45,70,105,137,173,204,228,248,254,259,263,263],
 [45,70,105,137,173,204,234,251,262,269,269],
 [45,70,105,147,196,266,360,477],
 [45,70,105,150,202,268,352,451],
 [45,70,105,154,232,345,519],[45,70,105,156,227,337,510],
 [45,70,105,158,218,295,377,473],
 [45,70,105,160,222,320,425],[45,70,105,161,224,315,425],
 [45,70,106,153,198,260,337,434],
 [45,70,107,144,197,252,331,405],
 [45,70,107,147,198,273,352,464],
 [45,70,107,147,201,252,326,389,479],
 [45,70,107,147,204,280,377,488],
 [45,70,107,148,208,276,373,466],
 [45,70,107,151,221,320,458],[45,70,107,151,221,321,466],
 [45,70,107,151,239,343,516],[45,70,107,164,253,372,543],
 [45,70,107,170,274,423],[45,70,107,171,272,427],
 [45,70,107,175,302,543],[45,70,107,177,281,473],
 [45,70,108,164,236,327,446],[45,70,125,182,281,404],
 [45,70,125,182,281,406],[45,70,125,182,281,408],
 [45,70,125,182,281,410],[45,70,125,182,281,412],
 [45,70,125,182,281,414],[45,70,125,196,309,463],
 [45,70,125,196,309,464],[45,70,125,196,309,468],
 [45,70,125,196,309,469],[45,70,125,196,309,470],
 [45,70,125,196,311,468],[45,70,125,196,311,473],
 [45,70,125,196,311,474],[45,70,125,196,311,486],
 [45,70,125,196,311,487],[45,70,125,196,313,478],
 [45,70,125,196,313,491],[45,70,125,196,313,504],
 [45,71,85,93,96,101,101],[45,71,85,101,102,102],
 [45,71,87,102,112,118,119,120,120],
 [45,71,87,111,120,128,129,129],
 [45,71,89,115,145,181,219,263,309,361],
 [45,71,89,125,153,205,241,309,353,437],
 [45,73,91,98,99,99],[45,73,91,99,101,102,102],
 [45,73,91,103,104,105,105],[45,73,91,103,104,106,106],
 [45,73,91,104,106,108,109,110,110],
 [45,73,91,104,106,109,112,115,118,121,124,127,130,133,136,
   139,142],[45,73,91,104,108,112,112],
 [45,73,91,104,110,118,118],[45,73,92,105,113,117,117],
 [45,73,92,105,115,120,123,125,126,127,127],
 [45,73,92,109,119,129,133,138,144,149,154,159,164,169],
 [45,73,92,109,123,133,140,144,146,148,149,149],
 [45,73,92,112,124,131,137,142,146,150,153,156,159,162],
 [45,73,92,112,127,137,144,146,146],
 [45,73,93,106,115,118,118],
 [45,73,93,107,117,121,122,123,123],
 [45,73,93,111,123,135,141,146,148,149,150,150],
 [45,73,93,112,122,130,131,132,132],
 [45,73,93,114,124,129,130,132,132],
 [45,73,94,116,145,176,214,253,299,346],
 [45,73,94,118,147,179,216,256,301,349],
 [45,73,94,122,151,192,230,283,329,394],
 [45,73,94,122,157,198,246,300,360,426],
 [45,73,94,123,153,196,236,293,342,412],
 [45,73,94,123,158,206,254,318,378],
 [45,73,94,123,158,206,254,318,378,458],
 [45,73,105,117,127,132,135,135],
 [45,73,105,117,127,133,139,142,142],
 [45,73,105,120,131,139,149,160,169,179,189,197,207,217],
 [45,73,105,120,132,137,137],
 [45,73,105,120,133,143,147,148,149,149],
 [45,73,105,120,134,145,154,161,166,166],
 [45,73,105,120,134,145,161,177,193,209,225],
 [45,73,105,120,136,144,150,150],
 [45,73,105,120,136,145,146,147,147],
 [45,73,105,120,136,147,153,159,165,171,177,183,189,195,201,
   207],[45,73,105,127,139,147,155,159,163,167,171,175,179,
   183,187,191],[45,73,105,127,141,146,146],
 [45,73,105,127,142,150,156,156],
 [45,73,106,122,143,150,157,163,169,175,181,187,193],
 [45,73,106,123,144,152,161,170,178,186,194,202],
 [45,73,106,125,149,163,169,173,173],
 [45,73,106,126,147,158,164,169,170,170],
 [45,73,106,132,151,162,169,175,181,187,193,199,205],
 [45,73,106,135,160,180,196,215,220,220],
 [45,73,106,135,161,179,196,203,209,210,211,211],
 [45,73,106,135,163,179,185,189,189],
 [45,73,107,127,152,166,176,184,184],
 [45,73,107,127,154,175,197,225,253,283],
 [45,73,107,133,163,183,197,203,203],
 [45,73,107,133,166,201,239,293,345,410],
 [45,73,107,136,161,179,194,206,212,218,218],
 [45,73,107,142,173,202,222,224,224],
 [45,73,107,142,173,209,251,310,373,457],
 [45,73,108,137,195,266,385,542],
 [45,73,108,139,196,249,328,396,499],
 [45,73,108,142,202,263,350,430],
 [45,73,108,143,202,265,349,432],
 [45,73,108,143,203,271,358,453],
 [45,73,108,148,207,280,384,526],
 [45,73,108,148,207,290,408],[45,73,108,148,207,292,421],
 [45,73,108,151,206,279,364,461],
 [45,73,108,154,218,315,453],[45,74,119,173,265,387,587],
 [45,74,119,173,265,389,589],[45,74,119,173,265,389,606],
 [45,74,119,173,267,408],[45,74,125,191,291,404],
 [45,74,125,191,291,406],[45,74,125,191,291,412],
 [45,74,125,191,303,475],[45,74,125,191,303,477],
 [45,74,125,191,303,479],[45,74,125,193,311,463],
 [45,74,125,193,321,541],[45,74,131,209,327,476],
 [45,74,131,209,327,491],[45,74,131,209,329,483],
 [45,74,131,209,335,495],[45,74,131,209,335,503],
 [45,74,131,209,337,509],[45,74,131,211,345,515],
 [45,74,131,211,345,523],[45,74,131,211,355,556],
 [45,74,131,211,357,582],[45,75,130,200,321,494],
 [45,75,130,200,321,502],[45,75,130,200,323,499],
 [45,75,130,200,323,520],[45,75,130,214,343,535],
 [45,75,130,214,345,537],[45,75,130,214,345,545],
 [45,75,130,214,347,541],[45,75,130,214,347,549],
 [45,77,128,198,300,418],[45,77,128,198,300,420],
 [45,77,128,198,300,426],[45,77,128,200,320,476],
 [45,77,134,230,376,602],[45,77,134,230,376,628],
 [45,77,134,230,380,616],[45,77,134,232,390,652],
 [45,77,134,232,400],[45,85,179,301,523],
 [45,85,179,301,525],[45,85,179,301,533],
 [45,85,179,301,539],[45,85,179,301,543],
 [45,85,179,301,545],[45,85,179,315,545],
 [45,85,179,315,547],[45,85,179,315,549],
 [45,85,179,315,557],[45,85,179,315,563],
 [45,85,179,315,567],[45,89,190,339,607],
 [45,89,190,344,622],[45,89,190,345,620],
 [45,89,190,346,623],[45,89,190,350,672],
 [45,89,190,351,664],[45,89,190,353,673],
 [45,89,190,353,678],[45,89,190,354,665],
 [45,89,190,354,678],[45,89,190,355,696],
 [45,89,190,356,713],[45,89,190,357,709],
 [45,89,190,360,701],[45,89,190,365,711],
 [45,89,198,337,612],[45,89,198,338,620],
 [45,89,198,339,633],[45,89,198,342,623],
 [45,89,198,342,665],[45,89,198,344,655],
 [45,89,198,345,657],[45,89,198,346,687],
 [45,89,198,350,666],[45,89,198,351,693],
 [45,89,198,352,687],[45,89,198,356,721],
 [45,100,175,291,496],[45,100,175,291,499],
 [45,100,175,291,501],[45,100,175,291,507],
 [45,100,175,293,493],[45,100,175,293,499],
 [45,100,175,293,513],[45,100,175,305,548],
 [45,100,175,305,549],[45,100,175,305,555],
 [45,100,185,315,520],[45,100,185,315,529],
 [45,100,185,315,535],[45,100,185,315,541],
 [45,100,185,317,551],[45,100,185,319,529],
 [45,100,185,319,533],[45,100,185,319,534],
 [45,100,185,319,535],[45,100,185,321,551],
 [45,100,185,323,561],[45,100,185,323,567],
 [45,100,185,323,575],[45,100,185,325,563],
 [45,100,185,327,587],[45,100,185,329,579],
 [45,100,185,329,581],[45,100,185,329,583],
 [45,100,185,329,585],[45,100,185,329,586],
 [45,100,185,329,589],[45,100,185,329,591],
 [45,100,185,329,597],[45,100,185,331,582],
 [45,100,185,331,583],[45,100,185,331,586],
 [45,100,185,331,589],[45,100,185,331,592],
 [45,100,185,331,605],[45,100,185,333,605],
 [45,100,195,342,553],[45,100,195,342,559],
 [45,100,195,342,561],[45,100,195,342,567],
 [45,100,195,355,610],[45,100,195,355,613],
 [45,100,195,355,616],[45,100,195,355,619],
 [45,100,195,355,620],[45,100,195,355,621],
 [45,100,195,355,623],[45,100,195,355,627],
 [45,100,195,355,629],[45,100,195,355,631],
 [45,100,195,355,633],[45,100,195,357,635],
 [45,100,195,357,643],[45,100,195,357,645],
 [45,100,195,357,647],[45,100,195,357,649],
 [45,100,195,357,650],[45,100,195,357,665],
 [45,100,195,368,653],[45,100,195,368,663],
 [45,100,195,368,671],[45,100,195,370,648],
 [45,100,195,370,652],[45,100,195,370,654],
 [45,100,195,370,656],[45,100,195,370,662],
 [45,100,195,370,664],[45,100,195,370,666],
 [45,100,195,370,674],[60,60],[60,70,77,77],
 [60,70,78,82,83,84,84],
 [60,70,78,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,
   97,98,99,100,101,102,103,104,105,106,107,108,109,110,111]
  ,[60,70,78,82,83,85,86,86],[60,70,78,82,85,85],
 [60,70,78,82,85,86,86],
 [60,70,78,82,85,88,92,95,100,103,106,110,113,118,121,124,
   128,131,136,139,142,146,149,154,157,160,164],
 [60,70,78,82,85,90,92,96,98,102,104,108,110,114,116,120,
   122,126,128,132,134,138,140],
 [60,70,78,82,85,90,92,96,98,102,104,108,110,114,116,120,
   122,126,128,132,134,138,140,144],
 [60,70,78,82,87,89,93,95,99,101,105,107,111,113,117,119,
   123,125,129,131,135,137,141],
 [60,70,78,82,87,89,93,95,99,101,105,107,111,113,117,119,
   123,125,129,131,135,137,141,143],
 [60,70,78,86,89,92,94,95,96,96],
 [60,70,78,86,89,92,95,97,100,102,104,107,109,112,114,116,
   119,121,124,126,128,131,133,136,138,140,143],
 [60,70,78,86,89,92,95,97,100,102,104,107,109,112,114,116,
   119,121,124,126,128,131,133,136,138,140,143,145],
 [60,70,78,86,90,94,98,102,106,110,114,118,122,126,130,134,
   138,142,146,150,154,158,162,166,170],
 [60,70,78,86,90,94,98,102,106,110,114,118,122,126,130,134,
   138,142,146,150,154,158,162,166,170,174],
 [60,70,78,86,90,95,99,103,106,108,110,112,114,116,118,120,
   122,124,126,128,130,132,134],
 [60,70,78,86,90,95,99,103,106,108,110,112,114,116,118,120,
   122,124,126,128,130,132,134,136],
 [60,70,78,86,94,101,108,116,124,131,138,145,152,159,166,
   174,182,189,196,203,210,217],
 [60,70,78,86,94,101,109,116,123,131,138,145,152,159,167,
   174,181,189,196,203,210,217],
 [60,70,78,86,94,102,110,118,126,134,142,150,158,166,174,
   182,190,198,206,214,222,230],
 [60,70,78,86,94,103,111,119,128,136,144,152,160,169,177,
   185,194,202,210,218,226,235],
 [60,70,78,86,95,102,109,116,123,130,137,144,152,159,166,
   173,180,187,194,201,209,216],
 [60,70,79,83,86,88,89,90,90],
 [60,70,79,83,86,88,90,91,92,93,93],
 [60,70,79,83,86,88,90,92,94,96,98,100,102,104,106,108,110,
   112,114,116,118,120,122,124,126,128,130,132,134,136,138,
   140],
 [60,70,79,83,86,88,90,92,94,96,98,100,102,104,106,108,110,
   112,114,116,118,120,122,124,126,128,130,132,134,136,138,
   140,142],[60,70,79,83,86,88,91,92,92],
 [60,70,79,83,86,89,90,90],
 [60,70,79,83,86,90,91,92,93,93],
 [60,70,79,83,86,90,91,92,93,94,94],
 [60,70,79,83,86,90,92,93,94,95,95],
 [60,70,79,83,86,90,93,95,98,100,101,103,104,105,107,108,
   109,111,112,113,115,116,117,119,120,121,123,124,125,127,
   128,129],
 [60,70,79,83,86,90,93,95,98,100,101,103,104,105,107,108,
   109,111,112,113,115,116,117,119,120,121,123,124,125,127,
   128,129,131],[60,70,79,85,87,89,91,92,93,94,94],
 [60,70,79,85,87,90,91,91],[60,70,79,85,87,91,92,92],
 [60,70,79,85,88,90,91,92,93,93],
 [60,70,79,85,88,90,92,94,95,96,97,98,99,100,101,102,103,
   104,105,106,107,108,109,110,111,112,113,114,115,116,117,
   118,119],[60,70,79,85,88,91,93,95,96,97,98,98],
 [60,70,79,85,88,91,93,95,97,98,98],
 [60,70,79,85,88,91,94,96,98,100,101,103,105,106,108,110,
   111,113,115,116,118,120,121,123,125,126,128,130,131,133,
   135],
 [60,70,79,85,88,91,94,96,98,100,101,103,105,106,108,110,
   111,113,115,116,118,120,121,123,125,126,128,130,131,133,
   135,136],[60,70,79,85,88,91,94,97,98,98],
 [60,70,79,85,88,92,94,95,96,97,98,99,100,101,102,103,104,
   105,106,107,108,109,110,111,112,113,114,115,116,117,118,
   119,120],
 [60,70,79,85,88,92,94,96,98,99,101,103,104,106,108,109,
   111,113,114,116,118,119,121,123,124,126,128,129,131,133,
   134,136],
 [60,70,79,85,88,92,94,96,98,99,101,103,104,106,108,109,
   111,113,114,116,118,119,121,123,124,126,128,129,131,133,
   134,136,138],[60,70,79,85,89,89],
 [60,70,79,85,89,92,95,98,100,102,102],
 [60,70,79,85,89,92,95,99,101,103,105,105],
 [60,70,79,85,89,93,96,98,100,101,102,103,104,105,106,107,
   108,109,110,111,112,113,114,115,116,117,118,119,120,121,
   122,123],
 [60,70,79,85,89,93,96,98,100,101,102,103,104,105,106,107,
   108,109,110,111,112,113,114,115,116,117,118,119,120,121,
   122,123,124],
 [60,70,79,85,89,94,97,102,105,108,112,115,120,123,126,130,
   133,138,141,144,148,151,156,159,162,166,169],
 [60,70,79,85,89,95,98,103,106,111,114,119,122,127,130,135,
   138,143,146,151,154,159,162],[60,70,79,85,90,90],
 [60,70,79,85,90,91,92,92],
 [60,70,79,85,90,91,93,94,95,95],
 [60,70,79,85,90,92,95,98,100,103,106,108,111,114,116,119,
   122,124,127,130,132,135,138,140,143,146,148,151,154,156,
   159],[60,70,79,85,90,93,94,94],
 [60,70,79,85,90,93,95,98,100,102,105,107,109,112,114,116,
   119,121,123,126,128,130,133,135,137,140,142,144,147,149,
   151],[60,70,79,85,90,94,99,102,104,106,106],
 [60,70,79,85,90,95,95],
 [60,70,79,85,90,96,99,102,105,109,111,115,115],
 [60,70,79,85,90,96,100,104,109,112,115,118,121,124,127,130,
   133,136,139,142,145,148,151],
 [60,70,79,85,90,96,102,106,109,113,116,120,125,129,132,136,
   139,143,148,152,155,159,162,166,171,175,178,182,185,189],
 [60,70,79,85,90,96,102,106,109,113,116,120,125,129,132,136,
   139,143,148,152,155,159,162,166,171,175,178,182,185,189,
   194],
 [60,70,79,85,90,98,104,111,117,125,132,140,147,155,162,170,
   177,185,192,200,207,215],
 [60,70,79,85,90,98,105,112,118,126,133,141,148,156,163,171,
   178,186,193,201,208,216],[60,70,79,85,91,92,94,96,96],
 [60,70,79,85,91,93,94,95,97,98,99,100,102,103,104,105,107,
   108,109,110,112,113,114,115,117,118,119,120,122,123,124,
   125,127,128,129,130,132,133,134,135,137],
 [60,70,79,85,91,93,97,99,103,105,109,111,115,117,121,123,
   127,129,133,135,139,141,145],
 [60,70,79,85,91,94,100,103,107,109,109],
 [60,70,79,85,91,97,103,108,112,116,120,123,126,129,132,135,
   138,141,144,147,150,153,156],
 [60,70,79,85,92,94,95,96,97,97],
 [60,70,79,85,92,95,98,100,102,102],
 [60,70,79,85,92,95,101,107,112,116,121,125,130,134,139,143,
   148,152,157,161,166,170,175],
 [60,70,79,85,92,96,101,107,110,111,112,113,113],
 [60,70,79,85,92,96,104,110,115,119,124,128,133,137,142,146,
   151,155,160,164,169,173,178],
 [60,70,79,85,92,97,100,104,108,112,116,119,123,128,131,134,
   139,143,146,150,154,158,162,165,169,174,177,180,185,189,
   192],
 [60,70,79,85,92,97,102,109,117,122,125,126,128,130,131,132,
   132],
 [60,70,79,85,92,98,102,106,112,115,118,122,124,126,129,131,
   133,136,138,140,143,145,147,150,152,154,157,159,161,164,
   166],
 [60,70,79,85,92,98,102,106,112,115,118,122,124,126,129,131,
   133,136,138,140,143,145,147,150,152,154,157,159,161,164,
   166,168],
 [60,70,79,85,92,98,104,111,117,123,129,135,141,147,153,159,
   165,171,177,183,189,195],
 [60,70,79,85,92,100,107,114,119,122,125,128,131,134,137,
   140,143,146,149,152,155,158,161],
 [60,70,79,85,93,97,99,101,104,105,105],
 [60,70,79,85,93,100,108,116,124,133,142,151,160,169,178,
   187,196,205,214,223,232,241],
 [60,70,79,85,94,100,107,114,117,121,123,125,126,128,130,
   132,133,135,137,139,140,142,144,146,147,149,151,153,154,
   156,158,160,161,163,165,167,168,170,172],
 [60,70,79,85,94,100,107,114,117,121,123,125,126,128,130,
   132,133,135,137,139,140,142,144,146,147,149,151,153,154,
   156,158,160,161,163,165,167,168,170,172,174],
 [60,70,79,85,94,104,116,127,139,151,164,176,191,205,222,
   237,254,271,290,309,329],
 [60,70,79,88,93,96,99,101,103,104,105,106,106],
 [60,70,79,88,93,97,99,99],
 [60,70,79,88,93,97,100,102,104,105,105],
 [60,70,79,88,93,97,101,104,105,107,110,111,113,116,117,119,
   122,123,125,128,129,131,134,135,137,140,141,143,146,147,
   149],
 [60,70,79,88,93,97,101,104,106,108,110,111,113,115,116,118,
   120,121,123,125,126,128,130,131,133,135,136,138,140,141,
   143],
 [60,70,79,88,98,106,116,124,134,142,152,160,170,178,188,
   196,206,214,224,232,242,250],
 [60,70,79,88,98,107,117,126,136,145,155,164,174,183,193,
   202,212,221,231,240,250],
 [60,70,79,88,98,107,117,126,136,145,155,164,174,183,193,
   202,212,221,231,240,250,259],
 [60,70,79,88,98,107,118,127,138,147,158,167,178,187,198,
   207,218,227,238,247,258],
 [60,70,79,88,98,107,118,127,138,147,158,167,178,187,198,
   207,218,227,238,247,258,267],
 [60,70,79,90,94,99,100,101,101],
 [60,70,79,90,94,101,102,104,104],
 [60,70,79,90,94,101,104,108,109,110,110],
 [60,70,79,90,96,101,105,110,115,119,123,128,133,137,141,
   146,151,155,159,164,169,173],
 [60,70,79,90,96,101,105,110,115,119,123,128,133,137,141,
   146,151,155,159,164,169,173,177],
 [60,70,79,90,96,103,109,115,121,127,133,139,145,151,157,
   163,169,175,181,187,193,199],
 [60,70,79,90,96,103,109,115,121,127,133,139,145,151,157,
   163,169,175,181,187,193,199,205],
 [60,70,79,90,97,103,108,113,116,118,121,126,128,131,134,
   138,141,143,147,151,153,156,159,164,166,168,172,176,179,
   181,184,189,191,194,197,201,204],
 [60,70,79,90,97,105,111,118,127,134,145,152,162,168,175,
   183,190,201,208,218,224,231,239,246,257,264,274,280,287],
 [60,70,79,90,97,105,111,118,127,134,145,152,162,168,175,
   183,190,201,208,218,224,231,239,246,257,264,274,280,287,
   295],
 [60,70,79,90,97,105,112,120,127,135,142,150,157,165,172,
   180,187,195,202,210,217,225],
 [60,70,79,90,99,109,117,126,134,143,151,160,168,177,185,
   194,202,211,219,228,236,245],
 [60,70,79,90,99,109,122,136,151,165,181,197,214,230,246,
   262,278,294,310,326],
 [60,70,79,90,99,109,122,136,151,165,181,197,214,230,246,
   262,278,294,310,326,342],
 [60,70,79,90,99,111,121,135,146,162,174,192,205,225,239,
   261,276,300,316,342],
 [60,70,79,90,99,111,121,135,146,162,174,192,205,225,239,
   261,276,300,316,342,359],
 [60,70,79,90,100,113,125,139,152,166,179,193,206,220,233,
   247,260,274,287,301,314],
 [60,70,79,90,100,113,126,139,152,165,178,191,204,217,230,
   243,256,269,282,295,308],
 [60,70,79,90,102,115,128,141,154,167,180,193,206,219,232,
   245,258,271,284,297,310],
 [60,70,79,90,102,117,132,148,164,181,198,216,234,253,272,
   292,312,333,354,376],
 [60,70,79,90,102,117,132,148,164,181,198,216,234,253,272,
   292,312,333,354,376,398],[60,150,294,528],
 [60,150,294,532],[60,150,294,536],[60,150,294,546],
 [60,150,294,554],[60,150,310,568],[60,150,310,576],
 [60,150,310,580],[60,150,310,592],[60,150,310,594],
 [60,150,310,600],[60,150,310,618],[60,150,310,622],
 [60,150,312,622],[60,150,312,624],[60,150,312,626],
 [60,150,314,584],[60,150,314,590],[60,150,314,600],
 [60,150,314,608],[60,150,314,621],[60,150,314,622],
 [60,150,314,624],[60,150,330,640],[60,150,330,644],
 [60,150,330,648],[60,150,330,660],[60,150,330,661],
 [60,150,330,665],[60,150,330,670],[60,150,330,673],
 [60,150,330,676],[60,150,330,678],[60,150,330,690],
 [60,150,348,714],[60,150,348,718],[60,150,348,722],
 [60,150,348,726],[60,150,348,734],[60,150,348,738],
 [60,150,348,750]];

refinementseqlngspos :=
[116,116,1648,1648,714,800,1648,714,798,1648,797,800,3291,3291,
 3291,3291,3291,3291,3291,3291,3291,3291,116,116,116,116,116,
 116,133,121,116,116,116,143,116,143,125,121,197,168,116,116,
 133,116,177,116,125,116,147,147,118,118,197,177,168,1216,
 1278,1236,1216,1278,1278,1216,1236,1236,1278,1236,1216,116,
 1648,1648,714,797,1648,714,800,1648,800,798,3291,3291,3291,
 3291,3291,3291,3291,3291,3291,3291,116,116,116,116,116,116,
 147,147,116,116,116,118,116,125,143,133,177,197,116,116,121,
 116,168,116,118,116,121,133,143,125,168,197,177,1278,1236,
 1278,1236,1216,1236,1278,1216,1216,1216,1278,1236,1648,1648,
 714,808,1648,714,807,1648,808,807,3291,3291,3291,3291,3291,
 3291,3291,3291,3291,3291,116,116,116,116,116,116,150,136,116,
 116,116,129,116,144,144,145,198,181,116,116,145,116,195,116,
 146,116,136,150,129,146,181,198,195,1240,1263,1263,1259,1240,
 1263,1240,1259,1259,1240,1263,1259,4,4,7,4,4,7,4,7,7,2515,
 2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,412,
 1648,412,1648,1683,1683,1648,412,1648,1676,412,1676,1676,1683,
 413,413,1648,412,1683,1648,413,412,1676,1648,1683,1683,1676,
 1676,413,413,413,460,460,460,460,460,460,460,460,460,460,460,
 460,4,18,4,4,12,4,18,12,2515,2515,2515,2515,2515,2515,2515,
 2515,2515,2515,1648,1648,412,1648,412,1648,1733,1740,1648,412,
 1648,1725,412,1725,1725,1733,415,414,1648,412,1733,1648,414,
 412,1725,1648,1740,1733,1725,1725,414,415,414,466,466,470,470,
 470,470,470,470,466,466,466,466,14,4,4,14,4,2,2,2498,2498,
 2498,2498,2498,2498,2498,2498,2498,2498,714,714,369,714,89,
 714,925,909,714,369,714,922,369,905,922,925,93,93,714,89,
 908,714,93,89,905,714,924,908,905,922,373,373,373,102,102,
 468,468,468,102,102,102,102,468,468,468,7,2,3,12,29,22,
 2502,2503,2511,2506,2513,2507,2501,2514,2508,2500,781,797,91,
 781,371,798,963,940,800,92,782,978,90,940,973,960,381,374,
 780,372,952,800,378,370,944,783,976,950,941,972,99,105,94,
 476,490,101,94,100,509,507,509,485,108,108,106,4,7,4,7,7,
 2515,2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,
 412,1648,412,1648,1683,1683,1648,412,1648,1676,412,1676,1676,
 1683,413,413,1648,412,1683,1648,413,412,1676,1648,1683,1683,
 1676,1676,413,413,413,460,460,460,460,460,460,460,460,460,
 460,460,460,2,4,14,14,2498,2498,2498,2498,2498,2498,2498,
 2498,2498,2498,714,714,89,714,369,714,908,924,714,89,714,905,
 89,922,905,908,373,373,714,369,925,714,373,369,922,714,909,
 925,922,905,93,93,93,468,468,102,102,102,468,468,468,468,
 102,102,102,18,22,29,2506,2501,2514,2504,2510,2509,2502,2512,
 2505,2499,781,800,92,781,372,800,976,950,798,91,783,959,90,
 942,965,975,381,378,781,371,940,797,374,370,943,782,960,948,
 945,964,94,105,99,509,509,108,108,106,490,485,476,507,94,
 101,100,12,18,2515,2515,2515,2515,2515,2515,2515,2515,2515,
 2515,1648,1648,412,1648,412,1648,1739,1734,1648,412,1648,1705,
 412,1705,1705,1739,415,414,1648,412,1739,1648,414,412,1705,
 1648,1734,1739,1705,1705,414,415,414,470,470,466,466,466,466,
 466,466,470,470,470,470,3,2501,2506,2514,2503,2513,2508,2502,
 2511,2507,2500,781,800,372,781,92,800,950,976,797,371,782,
 941,370,973,940,952,105,99,781,91,960,798,94,90,972,783,940,
 963,978,944,374,381,378,108,108,509,509,507,101,100,94,106,
 476,490,485,2502,2504,2512,2501,2510,2505,2506,2514,2509,2499,
 780,798,371,780,91,797,948,960,800,372,783,945,370,965,942,
 940,105,94,780,92,975,800,99,90,964,782,950,976,959,943,378,
 381,374,94,101,490,476,485,108,106,108,100,509,509,507,1647,
 1647,1647,1647,1647,1647,1647,1647,1647,3291,3291,2750,3291,
 2750,3291,3368,3370,3291,2750,3291,3356,2750,3354,3354,3370,
 2753,2752,3291,2750,3369,3291,2751,2750,3356,3291,3366,3366,
 3355,3357,2755,2754,2752,3282,3281,3281,3282,3280,3280,3281,
 3280,3280,3280,3280,3281,1647,1647,1647,1647,1647,1647,1647,
 1647,3291,3291,2750,3291,2750,3291,3370,3368,3291,2750,3291,
 3354,2750,3355,3357,3367,2751,2753,3291,2750,3366,3291,2755,
 2750,3354,3291,3369,3367,3357,3355,2751,2755,2754,3281,3282,
 3282,3281,3281,3281,3282,3280,3281,3280,3281,3282,1647,1647,
 1647,1647,1647,1647,1647,3291,3291,2750,3291,2750,3291,3418,
 3418,3291,2750,3291,3383,2750,3384,3385,3413,2756,2757,3291,
 2750,3416,3291,2760,2750,3387,3291,3416,3415,3386,3386,2760,
 2758,2759,3289,3289,3289,3289,3289,3289,3289,3290,3289,3290,
 3289,3289,1647,1647,1647,1647,1647,1647,3291,3291,2750,3291,
 2750,3291,3367,3369,3291,2750,3291,3357,2750,3357,3355,3366,
 2755,2751,3291,2750,3367,3291,2754,2750,3355,3291,3368,3370,
 3354,3354,2753,2751,2755,3280,3281,3281,3280,3282,3282,3281,
 3281,3282,3281,3282,3281,1647,1647,1647,1647,1647,3291,3291,
 2750,3291,2750,3291,3413,3414,3291,2750,3291,3385,2750,3386,
 3386,3415,2760,2756,3291,2750,3415,3291,2758,2750,3384,3291,
 3414,3413,3385,3384,2756,2760,2758,3289,3289,3289,3289,3289,
 3289,3289,3289,3289,3289,3289,3289,1647,1647,1647,1647,3291,
 3291,2750,3291,2750,3291,3412,3408,3291,2750,3291,3380,2750,
 3381,3382,3411,2765,2767,3291,2750,3410,3291,2766,2750,3379,
 3291,3409,3411,3382,3381,2765,2766,2764,3287,3288,3288,3286,
 3287,3286,3288,3284,3286,3285,3287,3288,1647,1647,1647,3291,
 3291,2750,3291,2750,3291,3366,3366,3291,2750,3291,3355,2750,
 3354,3354,3369,2754,2755,3291,2750,3370,3291,2752,2750,3357,
 3291,3370,3368,3356,3356,2752,2753,2751,3280,3280,3280,3280,
 3281,3281,3280,3282,3281,3282,3281,3280,1647,1647,3291,3291,
 2750,3291,2750,3291,3415,3416,3291,2750,3291,3386,2750,3385,
 3384,3416,2758,2760,3291,2750,3413,3291,2759,2750,3386,3291,
 3418,3418,3383,3387,2757,2756,2760,3290,3289,3289,3290,3289,
 3289,3289,3289,3289,3289,3289,3289,1647,3291,3291,2750,3291,
 2750,3291,3411,3409,3291,2750,3291,3382,2750,3382,3381,3410,
 2766,2765,3291,2750,3411,3291,2764,2750,3381,3291,3408,3412,
 3380,3379,2767,2765,2766,3285,3287,3286,3284,3288,3288,3287,
 3286,3288,3287,3288,3286,3291,3291,2750,3291,2750,3291,3420,
 3419,3291,2750,3291,3390,2750,3389,3389,3417,2763,2761,3291,
 2750,3417,3291,2762,2750,3388,3291,3419,3420,3390,3388,2761,
 2763,2762,3283,3283,3283,3283,3283,3283,3283,3283,3283,3283,
 3283,3283,116,116,116,116,116,121,121,116,116,116,118,116,
 118,118,121,168,168,116,116,121,116,168,116,118,116,121,121,
 118,118,168,168,168,1210,1210,1210,1210,1210,1210,1210,1210,
 1210,1210,1210,1210,116,116,116,116,147,147,116,116,116,118,
 116,125,143,133,177,197,116,116,121,116,168,116,118,116,121,
 133,143,125,168,197,177,1278,1236,1278,1236,1216,1236,1278,
 1216,1216,1216,1278,1236,116,116,116,149,134,116,19,116,118,
 19,124,140,143,180,180,116,116,121,116,168,116,118,116,121,
 133,125,143,23,24,24,1239,1239,104,104,96,1239,1239,1221,
 1221,96,104,104,116,116,121,121,116,116,116,118,116,118,118,
 121,168,168,116,116,121,116,168,116,118,116,121,121,118,118,
 168,168,168,1210,1210,1210,1210,1210,1210,1210,1210,1210,1210,
 1210,1210,116,134,149,116,116,116,118,116,143,125,133,24,24,
 116,19,121,116,23,19,118,116,121,143,140,124,168,180,180,
 104,104,1239,1239,1221,104,104,96,96,1221,1239,1239,137,137,
 116,116,116,118,116,140,124,143,197,177,116,116,121,116,168,
 116,118,116,121,143,124,140,168,177,197,1236,1278,1236,1278,
 1216,1278,1236,1216,1216,1216,1236,1278,179,133,143,121,172,
 121,158,128,187,264,236,121,133,172,143,231,121,172,121,187,
 183,188,196,220,319,241,1316,1354,1474,1350,1305,1356,1318,
 1306,1307,1320,1478,1361,121,121,143,172,133,196,188,166,241,
 318,121,121,186,121,220,143,172,133,172,186,130,159,231,236,
 261,1474,1350,1316,1354,1308,1362,1479,1320,1304,1306,1319,
 1355,116,116,143,116,143,125,121,197,168,116,116,133,116,177,
 116,125,116,147,147,118,118,197,177,168,1216,1278,1236,1216,
 1278,1278,1216,1236,1236,1278,1236,1216,116,140,19,125,143,
 121,180,168,116,116,133,116,180,116,124,116,149,134,118,118,
 24,24,23,1221,1239,104,96,104,1239,1221,1239,1239,104,104,96,
 140,116,118,118,137,168,197,116,116,137,116,177,116,124,116,
 143,121,140,124,197,168,177,1275,1212,1212,1228,1275,1212,
 1275,1228,1228,1275,1212,1228,143,192,184,196,243,233,118,125,
 158,124,256,124,151,125,130,188,172,184,329,223,239,1315,
 1346,1325,1360,1490,1351,1312,1357,1358,1486,1311,1347,118,118,
 149,168,180,116,116,134,116,180,116,125,116,143,121,124,140,
 24,23,24,1232,1214,95,103,103,1214,1232,1232,1232,103,95,103,
 151,172,331,239,118,140,172,124,223,118,184,118,188,128,184,
 172,243,257,233,1346,1486,1357,1310,1351,1490,1359,1325,1311,
 1346,1358,1314,172,257,243,118,124,172,140,233,118,172,118,
 196,158,192,184,239,331,223,1346,1358,1490,1325,1359,1357,
 1351,1310,1314,1346,1486,1311,231,261,121,121,179,121,236,134,
 188,147,187,172,158,128,241,220,318,1354,1307,1305,1474,1349,
 1306,1356,1319,1317,1362,1320,1478,28,168,24,220,177,28,23,
 239,168,236,319,223,233,293,277,293,114,98,1519,1560,1560,98,
 114,114,114,1560,1519,1560,168,23,241,168,28,24,223,177,231,
 220,329,255,293,293,277,94,110,1554,1493,1554,112,97,112,109,
 1555,1555,1512,116,121,116,168,116,118,116,121,121,118,118,
 168,168,168,1210,1210,1210,1210,1210,1210,1210,1210,1210,1210,
 1210,1210,143,116,24,19,143,116,134,149,118,118,180,180,168,
 96,104,1239,1221,1239,104,96,104,104,1239,1239,1221,143,318,
 149,128,147,166,186,196,188,261,231,236,1362,1320,1306,1319,
 1356,1305,1349,1474,1478,1354,1307,1317,197,116,140,116,137,
 137,118,118,177,197,168,1216,1236,1278,1216,1236,1236,1216,
 1278,1278,1236,1278,1216,24,330,197,261,241,239,243,277,293,
 293,112,112,1555,1555,1512,110,109,94,97,1493,1554,1554,140,
 116,133,121,143,125,180,168,180,103,95,1214,1232,1232,95,103,
 103,103,1232,1214,1232,143,159,196,184,192,255,233,243,1313,
 1346,1310,1352,1357,1359,1326,1490,1486,1358,1314,1348,133,121,
 125,143,177,168,197,1228,1212,1212,1275,1228,1212,1228,1275,
 1275,1228,1212,1275,179,172,172,318,241,220,1306,1319,1362,
 1320,1479,1316,1308,1354,1355,1474,1350,1304,172,172,236,264,
 231,1320,1478,1356,1306,1318,1474,1305,1350,1361,1316,1354,
 1307,151,233,243,256,1486,1311,1351,1357,1312,1325,1490,1360,
 1347,1315,1346,1358,223,239,330,1358,1314,1359,1490,1326,1310,
 1357,1352,1348,1313,1346,1486,28,28,1555,1555,112,112,97,1554,
 1554,1493,1512,94,110,109,28,1560,1519,98,114,114,1519,1560,
 1560,1560,114,98,114,1493,1554,110,94,109,1555,1512,1555,1554,
 112,112,97,113,2367,2319,2361,115,107,115,111,2378,2378,2360,
 2319,2367,2367,107,115,115,113,2378,2360,2378,113,113,2360,
 2378,2378,2367,115,107,115,111,2378,2360,2378,2361,115,115,
 107,2378,2378,2360,2319,107,115,115,113,113,115,2367,2319,
 2367,111,115,2361,2367,2319,107,2319,2367,2361,2360,2378,2378,
 113,111,113,1,1648,1648,714,796,1648,714,796,1648,796,796,
 2436,2436,2436,2436,2436,2436,2436,2436,2436,2436,32,32,116,
 32,116,6,9,21,32,116,19,21,116,16,16,16,175,194,32,116,16,
 6,175,116,9,32,21,9,21,9,194,175,175,1276,1234,1234,1234,
 1276,1234,1276,1234,1234,1276,1234,1234,1648,1648,576,688,1648,
 576,685,1648,685,688,2436,2436,2436,2436,2436,2436,2436,2436,
 2436,2436,32,32,116,32,116,19,16,16,32,116,6,16,116,21,9,
 21,191,178,32,116,9,6,170,116,16,32,9,21,9,20,178,170,191,
 1141,1168,982,1168,1141,1168,1141,982,982,1141,982,1168,1648,
 1648,1776,1648,1648,1762,1648,1761,1776,5023,5023,5023,5023,
 5023,5023,5023,5023,5023,5023,1648,1648,1648,1648,1648,1648,
 1669,1683,1648,1648,1648,1716,1648,1723,1656,1683,1867,1838,
 1648,1648,1664,1648,1817,1648,1651,1648,1706,1706,1676,1676,
 1869,1813,1838,2042,2055,2036,2042,2055,2043,2032,1998,2036,
 2043,1998,2032,1648,1776,1648,1648,1761,1648,1775,1763,5023,
 5023,5023,5023,5023,5023,5023,5023,5023,5023,1648,1648,1648,
 1648,1648,1648,1656,1723,1648,1648,1648,1683,1648,1683,1669,
 1715,1838,1867,1648,1648,1656,1648,1813,1648,1669,1648,1676,
 1676,1711,1711,1838,1817,1867,2043,2032,2036,2055,2042,2042,
 2055,2036,1998,2032,1998,2043,1767,1648,1648,1755,1648,642,650,
 4356,4356,4232,4356,4232,4356,4356,4232,4356,4232,575,575,575,
 575,575,575,747,749,575,575,575,802,575,749,747,802,1083,
 1083,714,576,893,714,1182,576,893,714,732,717,726,737,1205,
 1192,1206,1135,1134,2035,2047,2047,1135,1134,892,892,2050,2001,
 2050,1763,650,703,1765,1971,1964,4369,4365,4250,4369,4250,4366,
 4368,4249,4371,4246,621,780,678,781,653,646,955,789,621,678,
 646,845,636,789,955,845,1219,1219,627,639,826,780,1220,640,
 785,628,768,744,792,829,1109,1199,1102,2197,2208,947,1120,
 1120,2197,2208,2200,2198,1158,932,1157,1648,1775,1648,1773,
 1763,5023,5023,5023,5023,5023,5023,5023,5023,5023,5023,1648,
 1648,1648,1648,1648,1648,1664,1683,1648,1648,1648,1723,1648,
 1716,1651,1683,1867,1838,1648,1648,1669,1648,1817,1648,1657,
 1648,1711,1711,1676,1676,1869,1813,1838,2032,2043,1998,2032,
 2043,2055,2042,2036,1998,2055,2036,2042,642,1648,1766,1756,
 4356,4356,4232,4356,4232,4356,4356,4232,4356,4232,575,714,576,
 714,575,575,893,784,575,576,575,749,575,802,893,750,1206,
 1206,575,575,747,714,1192,575,747,575,726,737,737,726,1083,
 1182,1083,2050,2050,892,1134,1135,2047,2047,2035,2001,1134,892,
 1135,1778,1956,1963,4361,4358,4242,4362,4241,4357,4359,4243,
 4363,4240,595,780,667,780,613,627,958,866,595,669,599,860,
 604,780,962,867,1264,1260,634,637,733,781,1238,626,738,628,
 832,787,839,840,1149,1201,1140,2217,2215,934,1177,1181,2218,
 2212,2204,2201,1164,953,1165,1764,1777,5023,5023,5023,5023,
 5023,5023,5023,5023,5023,5023,1648,1648,1648,1648,1648,1648,
 1649,1722,1648,1648,1648,1735,1648,1735,1649,1730,1874,1868,
 1648,1648,1649,1648,1790,1648,1649,1648,1695,1695,1689,1689,
 1873,1799,1868,2056,2051,1995,2044,2045,2045,2044,1995,2033,
 2051,2033,2056,703,4362,4359,4243,4360,4245,4367,4361,4244,
 4364,4239,595,634,637,627,607,629,738,860,595,623,603,851,
 625,869,733,780,1140,1147,781,667,962,780,1201,669,958,781,
 778,827,832,787,1262,1238,1264,1181,1177,2204,2218,2213,1166,
 1164,953,934,2217,2202,2214,4369,4368,4249,4368,4248,4370,4369,
 4249,4370,4247,621,627,639,627,621,621,785,845,621,639,621,
 794,621,872,826,789,1108,1102,781,679,955,781,1199,679,955,
 781,744,768,768,744,1223,1220,1219,1120,1122,2200,2197,2207,
 1158,1158,932,947,2197,2200,2207,2436,2436,2436,2436,2436,2436,
 2436,2436,2436,2787,2832,3291,2832,3291,2703,2562,2728,2787,
 3291,2703,2728,3291,2728,2563,2728,3484,3486,2832,3291,2559,
 2531,3461,3291,2559,2832,2715,2715,2707,2719,3486,3460,3485,
 4905,4902,4802,4905,4903,4902,4904,4804,4804,4902,4804,4902,
 2436,2436,2436,2436,2436,2436,2436,2436,2787,2832,3291,2832,
 3291,2703,2567,2728,2787,3291,2703,2728,3291,2728,2567,2728,
 3483,3483,2832,3291,2559,2531,3462,3291,2559,2832,2704,2704,
 2719,2707,3483,3462,3487,4902,4905,4806,4904,4904,4902,4905,
 4804,4802,4903,4802,4905,2436,2436,2436,2436,2436,2436,2436,
 2787,2832,3291,2832,3291,2703,2565,2744,2787,3291,2703,2739,
 3291,2738,2561,2732,3515,3521,2832,3291,2566,2531,3437,3291,
 2566,2832,2716,2705,2722,2721,3521,3438,3519,4900,4900,4553,
 4901,4899,4898,4901,4547,4545,4897,4545,4900,2436,2436,2436,
 2436,2436,2436,2787,2832,3291,2832,3291,2703,2563,2728,2787,
 3291,2703,2728,3291,2728,2562,2728,3486,3484,2832,3291,2563,
 2531,3460,3291,2562,2832,2707,2719,2704,2704,3484,3461,3488,
 4902,4904,4802,4903,4905,4905,4902,4802,4806,4904,4806,4904,
 2436,2436,2436,2436,2436,2787,2832,3291,2832,3291,2703,2561,
 2738,2787,3291,2703,2732,3291,2744,2565,2739,3521,3515,2832,
 3291,2559,2531,3438,3291,2559,2832,2714,2713,2713,2714,3515,
 3437,3520,4898,4901,4554,4899,4901,4900,4900,4545,4553,4899,
 4553,4901,2436,2436,2436,2436,2786,2832,3291,2832,3291,2642,
 2515,2674,2786,3291,2642,2677,3291,2674,2515,2677,3533,3533,
 2832,3291,2515,2515,3432,3291,2515,2832,2642,2642,2642,2642,
 3533,3432,3529,4909,4910,4805,4908,4908,4909,4910,4801,4803,
 4906,4803,4910,2436,2436,2436,2787,2832,3291,2832,3291,2703,
 2559,2728,2787,3291,2703,2728,3291,2728,2559,2728,3487,3488,
 2832,3291,2567,2531,3462,3291,2567,2832,2719,2706,2715,2715,
 3488,3461,3484,4903,4903,4804,4902,4902,4904,4902,4806,4802,
 4905,4802,4903,2436,2436,2787,2832,3291,2832,3291,2703,2559,
 2740,2787,3291,2703,2744,3291,2732,2559,2740,3519,3516,2832,
 3291,2561,2531,3438,3291,2565,2832,2722,2722,2705,2716,3516,
 3437,3516,4897,4899,4545,4897,4900,4901,4898,4554,4553,4901,
 4553,4899,2436,2786,2832,3291,2832,3291,2642,2515,2676,2786,
 3291,2642,2678,3291,2678,2515,2675,3532,3530,2832,3291,2515,
 2515,3431,3291,2515,2832,2642,2642,2642,2642,3530,3433,3531,
 4907,4908,4803,4906,4910,4910,4909,4803,4805,4908,4805,4908,
 2787,2832,3291,2832,3291,2703,2525,2735,2787,3291,2703,2745,
 3291,2742,2523,2734,3517,3518,2832,3291,2517,2516,3440,3291,
 2517,2832,2711,2723,2723,2710,3518,3439,3514,4894,4896,4552,
 4893,4896,4895,4895,4548,4552,4893,4552,4896,116,116,116,116,
 31,117,35,31,116,31,35,116,35,117,35,168,168,116,116,117,
 116,151,116,117,116,31,31,31,31,168,151,168,1116,1116,892,
 1115,1116,1115,1116,892,892,1115,892,1115,116,116,116,116,40,
 44,116,116,32,36,116,121,58,132,168,194,32,116,54,32,151,
 116,33,116,55,118,61,123,168,175,175,1179,1121,1225,1225,
 1210,1121,1179,892,892,1210,1225,1225,116,116,116,132,132,116,
 116,116,121,116,121,123,142,168,178,116,116,117,116,151,116,
 117,116,118,118,123,142,168,170,191,1132,1123,981,1167,1138,
 1123,1132,892,892,1138,981,1167,116,32,58,121,116,116,116,
 132,116,44,40,36,194,168,116,116,33,32,151,116,54,32,123,
 61,118,55,175,175,168,1121,1179,1225,1210,1225,1179,1121,892,
 892,1225,1225,1210,116,117,149,116,116,116,134,116,149,117,
 134,193,193,116,116,117,116,151,116,117,116,120,139,139,120,
 180,151,180,1159,1159,892,1133,1133,1159,1159,892,892,1133,
 892,1133,54,47,31,116,31,47,116,13,33,13,197,177,116,116,
 33,32,151,116,54,32,31,5,31,5,177,151,197,1125,1178,892,
 1180,1131,1178,1125,892,892,1131,892,1180,51,117,123,33,51,
 117,58,4,58,240,225,33,117,4,4,200,117,4,54,64,77,64,77,
 213,320,228,1225,1255,1475,1345,1309,1253,1227,999,998,1309,
 1475,1345,35,121,13,17,134,74,58,62,241,316,36,121,58,36,
 204,142,51,132,7,35,11,43,236,208,260,1433,1266,1005,1269,
 1243,1274,1443,1002,1003,1246,1013,1270,116,31,35,116,35,117,
 35,168,168,116,116,117,116,151,116,117,116,31,31,31,31,168,
 151,168,1116,1116,892,1116,1116,1115,1116,892,892,1115,892,
 1116,116,141,116,132,132,121,178,168,116,116,117,116,151,116,
 117,116,142,123,118,118,191,170,168,1123,1132,981,1138,1167,
 1132,1123,892,892,1167,981,1138,13,116,47,54,47,177,197,32,
 116,54,32,151,116,33,116,5,31,5,31,197,151,177,1178,1125,
 892,1131,1180,1125,1178,892,892,1180,892,1131,149,62,58,74,
 260,236,44,132,58,36,208,121,51,121,11,43,7,35,317,204,241,
 1246,1271,1004,1267,1433,1269,1244,1005,1013,1443,1002,1273,
 134,117,149,180,180,116,116,117,116,151,116,117,116,139,120,
 120,139,193,151,193,1127,1127,892,1160,1160,1127,1127,892,892,
 1160,892,1160,51,17,316,241,132,142,51,36,204,121,58,36,43,
 11,35,7,263,208,236,1274,1443,1005,1243,1269,1433,1266,1004,
 1002,1271,1013,1245,50,225,240,54,117,4,4,200,117,4,33,77,
 64,77,64,228,320,213,1253,1227,1475,1309,1345,1225,1255,998,
 999,1345,1475,1309,236,260,121,121,51,36,208,132,58,44,35,7,
 43,11,241,204,316,1269,1244,1003,1433,1267,1246,1271,1013,
 1005,1274,1002,1444,282,176,191,213,168,270,168,228,168,253,
 327,219,229,283,290,293,1464,1128,1526,1558,1502,1115,1461,
 1286,1287,1514,1527,1558,168,168,228,168,270,191,213,176,229,
 219,326,252,293,290,277,1116,1461,1526,1502,1558,1464,1128,
 1287,1287,1558,1527,1513,116,58,32,175,116,40,116,61,123,55,
 118,194,151,168,1210,1225,892,1121,1179,1225,1210,1225,1225,
 1179,892,1121,123,116,170,116,132,116,123,142,118,118,178,
 151,168,1138,1167,892,1123,1132,1167,1138,981,981,1132,892,
 1123,4,320,132,4,40,77,64,77,64,240,200,225,1345,1309,999,
 1230,1253,1309,1345,1475,1475,1255,998,1226,168,116,4,32,55,
 55,55,55,168,168,168,1210,1210,1210,1210,1210,1210,1210,1210,
 1210,1210,1210,1210,170,320,175,232,219,219,232,290,277,290,
 1491,1491,1501,1541,1542,1491,1491,1187,1187,1542,1500,1539,
 123,116,118,118,141,123,168,151,178,1167,1138,892,1126,1118,
 1138,1167,981,981,1118,892,1126,58,64,77,64,77,225,200,240,
 1309,1345,998,1256,1225,1345,1309,1475,1475,1227,999,1254,118,
 55,123,61,168,151,194,1225,1210,892,1176,1117,1210,1225,1225,
 1225,1117,892,1176,31,5,31,328,219,219,1207,1247,1015,1207,
 1441,1272,1242,1018,1025,1450,1012,1241,31,5,254,232,229,1207,
 1440,1025,1207,1248,1450,1241,1012,1015,1272,1018,1242,31,229,
 232,253,1441,1208,1018,1272,1242,1241,1450,1012,1015,1207,1025,
 1248,219,219,327,1248,1209,1012,1450,1241,1242,1272,1018,1025,
 1207,1015,1441,270,282,1557,1508,1287,1466,1136,1518,1556,1530,
 1531,1137,1287,1466,270,1542,1541,1187,1491,1491,1540,1542,
 1499,1501,1491,1187,1491,1502,1558,1287,1116,1462,1558,1514,
 1527,1525,1464,1287,1129,1463,2349,2330,2373,1476,1169,1295,
 1300,2373,2366,2350,2364,2375,2350,1169,1476,1295,1300,2333,
 2346,2374,1300,1300,2349,2364,2331,2332,1295,892,1295,1465,
 2373,2350,2366,2347,1476,1295,1169,2330,2375,2349,2364,1169,
 1295,1476,1463,1300,1295,2350,2364,2375,1300,1295,2373,2349,
 2330,892,2364,2332,2347,2346,2332,2365,1300,1465,1300,1648,
 1648,576,685,1648,576,688,1648,688,685,2436,2436,2436,2436,
 2436,2436,2436,2436,2436,2436,32,32,116,32,116,6,21,9,32,
 116,6,9,116,9,21,9,170,178,32,116,21,19,191,116,21,32,16,
 16,16,15,178,191,170,1141,982,1168,982,1141,982,1141,1168,
 1168,1141,1168,982,1648,1648,1773,1648,1648,1763,1648,1763,
 1775,5023,5023,5023,5023,5023,5023,5023,5023,5023,5023,1648,
 1648,1648,1648,1648,1648,1711,1711,1648,1648,1648,1676,1648,
 1651,1716,1669,1813,1869,1648,1648,1683,1648,1838,1648,1676,
 1648,1683,1664,1724,1656,1838,1867,1817,2055,2036,2055,2036,
 2042,1998,2043,2032,2042,2032,2043,1998,1648,1775,1648,1648,
 1763,1648,1776,1761,5023,5023,5023,5023,5023,5023,5023,5023,
 5023,5023,1648,1648,1648,1648,1648,1648,1676,1676,1648,1648,
 1648,1711,1648,1669,1683,1656,1817,1838,1648,1648,1716,1648,
 1867,1648,1711,1648,1724,1656,1683,1669,1867,1838,1813,2032,
 1998,2042,2036,2055,2036,2042,2055,2043,2043,2032,1998,1766,
 1648,1648,1756,1648,650,642,4356,4356,4232,4356,4232,4356,4356,
 4232,4356,4232,575,575,575,714,576,714,737,726,714,575,575,
 737,575,893,802,747,1182,1083,575,576,750,575,1083,575,726,
 575,784,893,749,747,1206,1206,1192,1134,892,2047,2035,2047,
 892,1135,1134,1135,2050,2050,2001,1761,642,703,1764,1971,1956,
 4361,4360,4244,4359,4245,4364,4362,4243,4367,4239,780,595,667,
 627,623,780,827,778,634,607,603,832,669,733,869,962,1238,
 1262,595,637,780,629,1264,625,787,781,860,738,851,958,1147,
 1140,1201,2217,2202,1166,953,1164,2204,2213,2218,2214,1181,
 1177,934,1648,1776,1648,1776,1762,5023,5023,5023,5023,5023,
 5023,5023,5023,5023,5023,1648,1648,1648,1648,1648,1648,1706,
 1706,1648,1648,1648,1676,1648,1657,1724,1664,1813,1869,1648,
 1648,1683,1648,1838,1648,1676,1648,1683,1669,1716,1651,1838,
 1867,1817,2043,1998,2043,1998,2032,2036,2055,2042,2032,2042,
 2055,2036,650,1648,1767,1755,4356,4356,4232,4356,4232,4356,
 4356,4232,4356,4232,714,575,576,575,575,714,717,732,575,575,
 575,726,576,747,749,893,1192,1205,575,575,802,575,1206,575,
 737,714,749,747,802,893,1083,1083,1182,2050,2001,1135,892,
 1134,2035,2047,2047,2050,1135,1134,892,1777,1964,1963,4369,
 4368,4249,4368,4248,4370,4369,4249,4370,4247,781,621,679,627,
 639,781,768,744,627,621,621,768,679,826,872,955,1220,1223,
 621,639,789,621,1219,621,744,781,845,785,794,955,1102,1108,
 1199,2197,2200,1158,932,1158,2200,2207,2197,2207,1120,1122,947,
 1765,1778,5023,5023,5023,5023,5023,5023,5023,5023,5023,5023,
 1648,1648,1648,1648,1648,1648,1695,1695,1648,1648,1648,1689,
 1648,1649,1735,1649,1799,1873,1648,1648,1730,1648,1868,1648,
 1689,1648,1722,1649,1735,1649,1868,1874,1790,2051,2033,2045,
 1995,2044,1995,2045,2044,2056,2056,2051,2033,703,4368,4369,
 4249,4365,4250,4371,4369,4250,4366,4246,627,621,639,780,679,
 781,744,768,781,653,646,792,641,955,790,826,1199,1109,621,
 679,845,646,1102,636,829,629,789,955,845,785,1219,1219,1220,
 1158,932,2197,2200,2208,947,1120,1120,1157,2197,2208,2198,4359,
 4362,4243,4358,4241,4363,4361,4242,4357,4240,634,595,637,781,
 669,781,787,832,781,613,599,839,626,962,780,733,1201,1149,
 595,667,867,627,1140,605,840,629,866,958,860,738,1260,1264,
 1238,1164,953,2218,2204,2212,934,1181,1177,1165,2217,2215,2201,
 2436,2436,2436,2436,2436,2436,2436,2436,2436,2832,2787,3291,
 2832,3291,2531,2706,2719,2832,3291,2703,2715,3291,2559,2728,
 2567,3461,3488,2787,3291,2728,2703,3484,3291,2715,2832,2728,
 2559,2728,2567,3488,3487,3462,4905,4802,4904,4806,4902,4804,
 4902,4902,4903,4903,4903,4802,2436,2436,2436,2436,2436,2436,
 2436,2436,2832,2787,3291,2832,3291,2531,2719,2706,2832,3291,
 2703,2704,3291,2562,2728,2563,3461,3484,2787,3291,2728,2703,
 3488,3291,2704,2832,2728,2563,2728,2562,3484,3486,3460,4904,
 4806,4905,4802,4902,4802,4905,4903,4904,4902,4904,4806,2436,
 2436,2436,2436,2436,2436,2436,2832,2787,3291,2832,3291,2531,
 2722,2722,2832,3291,2703,2705,3291,2559,2732,2561,3437,3516,
 2787,3291,2740,2703,3516,3291,2716,2832,2740,2559,2744,2564,
 3516,3519,3438,4901,4554,4901,4554,4898,4545,4900,4897,4899,
 4897,4899,4553,2436,2436,2436,2436,2436,2436,2832,2787,3291,
 2832,3291,2531,2704,2704,2832,3291,2703,2719,3291,2567,2728,
 2559,3462,3483,2787,3291,2728,2703,3487,3291,2706,2832,2728,
 2567,2728,2559,3483,3483,3462,4903,4802,4902,4804,4905,4806,
 4904,4904,4905,4902,4905,4802,2436,2436,2436,2436,2436,2832,
 2787,3291,2832,3291,2531,2713,2714,2832,3291,2703,2713,3291,
 2565,2744,2559,3437,3515,2787,3291,2739,2703,3520,3291,2714,
 2832,2738,2561,2732,2559,3515,3521,3438,4899,4553,4900,4545,
 4900,4553,4901,4899,4901,4898,4901,4554,2436,2436,2436,2436,
 2832,2786,3291,2832,3291,2515,2642,2642,2832,3291,2642,2642,
 3291,2515,2678,2515,3433,3530,2786,3291,2675,2642,3531,3291,
 2642,2832,2676,2515,2678,2515,3530,3532,3431,4908,4805,4910,
 4803,4909,4803,4910,4906,4908,4907,4908,4805,2436,2436,2436,
 2832,2787,3291,2832,3291,2531,2715,2715,2832,3291,2703,2707,
 3291,2563,2728,2559,3460,3486,2787,3291,2728,2703,3486,3291,
 2719,2832,2728,2562,2728,2559,3486,3484,3461,4902,4804,4902,
 4804,4904,4802,4903,4905,4902,4905,4902,4804,2436,2436,2832,
 2787,3291,2832,3291,2531,2705,2716,2832,3291,2703,2722,3291,
 2561,2738,2566,3438,3521,2787,3291,2732,2703,3519,3291,2722,
 2832,2744,2564,2739,2566,3521,3515,3437,4897,4545,4898,4547,
 4901,4553,4899,4901,4900,4900,4900,4545,2436,2832,2786,3291,
 2832,3291,2515,2642,2642,2832,3291,2642,2642,3291,2515,2674,
 2515,3432,3533,2786,3291,2677,2642,3529,3291,2642,2832,2674,
 2515,2677,2515,3533,3533,3432,4906,4803,4909,4801,4910,4805,
 4908,4908,4910,4909,4910,4803,2832,2787,3291,2832,3291,2516,
 2723,2711,2832,3291,2703,2723,3291,2523,2742,2517,3439,3518,
 2787,3291,2734,2703,3514,3291,2711,2832,2735,2525,2745,2517,
 3518,3517,3440,4893,4552,4895,4548,4895,4552,4896,4893,4896,
 4894,4896,4552,116,116,116,116,32,123,61,32,116,32,55,116,
 54,132,58,151,194,116,116,121,116,168,116,118,116,36,33,44,
 40,168,175,175,1179,892,1225,1225,1210,892,1179,1121,1121,
 1210,1225,1225,116,116,116,116,31,31,116,116,31,31,116,117,
 35,117,151,168,31,116,35,31,168,116,31,116,35,117,35,117,
 168,168,151,1115,892,1116,892,1116,892,1116,1115,1116,1115,
 1116,892,116,116,116,141,123,116,116,116,118,116,117,142,123,
 151,178,116,116,121,116,168,116,118,116,121,117,131,132,168,
 191,170,1132,892,1167,981,1138,892,1132,1123,1123,1138,1167,
 981,116,32,60,123,116,116,116,118,116,40,44,33,175,175,116,
 116,36,32,167,116,55,32,121,57,131,54,168,194,151,1225,1225,
 1179,892,1121,1225,1225,1210,1210,1121,1179,892,116,123,142,
 116,116,116,118,116,131,131,117,170,191,116,116,121,116,167,
 116,118,116,121,122,141,117,168,178,151,1167,981,1132,892,
 1123,981,1167,1138,1138,1123,1132,892,55,55,32,116,32,55,116,
 4,36,4,167,168,116,116,36,32,168,116,55,32,36,4,36,4,168,
 168,168,1210,1210,1210,1210,1210,1210,1210,1210,1210,1210,1210,
 1210,31,118,139,31,31,118,64,11,64,232,254,31,118,7,5,229,
 120,5,55,35,77,43,77,219,327,219,1272,1018,1450,1012,1241,
 1025,1248,1207,1242,1207,1440,1015,55,120,5,5,118,77,43,77,
 219,328,31,118,35,31,219,139,31,118,7,64,10,64,229,253,232,
 1450,1012,1272,1018,1242,1015,1441,1207,1241,1207,1247,1025,
 116,32,61,116,58,121,54,175,168,116,116,132,116,175,116,123,
 116,44,40,36,33,194,168,151,1210,1225,1121,892,1179,1225,
 1210,1225,1225,1179,1121,892,116,139,116,117,149,117,151,180,
 116,116,134,116,180,116,120,116,149,117,134,117,193,193,151,
 1133,892,1159,892,1159,892,1133,1133,1133,1159,1159,892,5,116,
 54,47,54,151,197,31,116,47,31,177,116,31,116,13,33,13,33,
 197,177,151,1180,892,1125,892,1178,892,1180,1131,1131,1178,
 1125,892,142,77,35,77,232,229,31,123,43,31,253,120,31,123,
 11,64,7,64,326,219,219,1207,1025,1241,1012,1450,1017,1242,
 1272,1248,1441,1208,1015,117,121,131,151,168,116,116,132,116,
 178,116,123,116,142,117,121,123,191,168,170,1118,892,1138,
 981,1167,892,1118,1126,1126,1167,1138,981,51,4,320,228,117,
 123,51,33,213,117,64,33,57,4,57,4,240,225,200,1345,1475,
 1225,998,1255,1475,1345,1309,1309,1253,1227,999,51,208,263,35,
 121,17,13,236,134,7,36,74,58,62,58,241,316,204,1271,1013,
 1433,1004,1266,1006,1269,1243,1245,1274,1443,1002,200,240,117,
 117,51,33,225,117,64,40,58,4,58,4,228,213,320,1255,998,
 1309,1475,1345,999,1253,1230,1226,1345,1309,1475,270,151,170,
 204,151,270,151,219,151,208,320,204,200,290,290,277,1491,
 1187,1540,1499,1542,1187,1491,1491,1491,1542,1541,1501,168,168,
 241,177,282,193,219,168,236,213,317,225,293,283,290,1137,
 1286,1518,1530,1556,1287,1136,1466,1466,1557,1508,1531,116,35,
 31,168,116,31,116,35,117,35,117,168,168,151,1115,892,1115,
 892,1116,892,1116,1116,1116,1115,1115,892,142,116,191,116,142,
 116,131,131,121,117,178,168,151,1138,981,1123,892,1132,981,
 1138,1167,1167,1132,1123,892,13,316,149,11,44,62,58,74,58,
 260,236,208,1274,1002,1246,1013,1271,1003,1267,1433,1444,1269,
 1244,1005,197,116,5,32,47,54,47,54,177,197,151,1131,892,
 1178,892,1125,892,1131,1180,1180,1125,1178,892,193,327,194,
 260,228,241,240,277,293,290,1464,1286,1558,1527,1514,1286,
 1462,1115,1129,1502,1558,1525,139,116,134,117,149,117,180,180,
 151,1160,892,1127,892,1127,892,1160,1160,1160,1127,1127,892,
 61,42,77,35,77,252,229,232,1207,1015,1242,1017,1272,1012,
 1241,1450,1441,1248,1209,1025,132,54,121,58,175,168,175,1117,
 892,1210,1225,1225,892,1117,1176,1176,1225,1210,1225,51,17,50,
 316,241,204,1246,1013,1274,1002,1443,1005,1243,1269,1270,1433,
 1266,1004,51,4,225,240,200,1309,1475,1253,999,1227,1475,1309,
 1345,1345,1225,1255,998,50,236,260,208,1443,1002,1269,1005,
 1244,1004,1433,1267,1273,1246,1271,1013,213,228,320,1227,999,
 1345,1475,1309,998,1225,1256,1254,1309,1345,1475,282,270,1558,
 1527,1464,1287,1128,1526,1558,1502,1513,1115,1461,1286,270,
 1514,1527,1115,1287,1461,1526,1502,1558,1558,1464,1128,1287,
 1542,1500,1491,1187,1491,1501,1542,1541,1539,1491,1491,1187,
 1300,2350,2364,2373,1295,1169,1476,1465,2373,2333,2346,2364,
 2332,2349,892,1295,1295,1300,2366,2346,2332,1300,1463,2349,
 2330,2373,2375,1476,1169,1295,1300,2331,2349,2366,2347,1295,
 1295,892,2364,2375,2350,2330,1169,1476,1295,1300,1300,1295,
 2349,2364,2332,1465,1476,2373,2350,2364,1169,2330,2375,2347,
 2350,2374,2365,1463,1300,1300,1648,1648,1779,1648,1648,1757,
 1648,1758,1781,5023,5023,5023,5023,5023,5023,5023,5023,5023,
 5023,1648,1648,1648,1648,1648,1648,1742,1669,1648,1648,1648,
 1651,1648,1698,1697,1709,1860,1821,1648,1648,1700,1648,1857,
 1648,1720,1648,1664,1743,1656,1727,1821,1860,1857,2041,2053,
 2053,2052,2041,2031,2003,2007,2052,2003,2031,2007,1648,1781,
 1648,1648,1758,1648,1781,1758,5023,5023,5023,5023,5023,5023,
 5023,5023,5023,5023,1648,1648,1648,1648,1648,1648,1727,1656,
 1648,1648,1648,1669,1648,1709,1709,1697,1857,1816,1648,1648,
 1697,1648,1860,1648,1742,1648,1656,1727,1669,1742,1816,1857,
 1860,2003,2007,2052,2053,2041,2052,2041,2053,2031,2003,2007,
 2031,1754,1648,1648,1754,1648,518,518,4154,4154,4055,4154,4055,
 4153,4154,4055,4153,4055,519,519,518,520,518,520,524,575,520,
 518,519,551,518,593,570,570,1029,996,520,518,593,520,1029,
 518,620,520,540,620,575,524,1188,1196,1196,575,593,2006,2006,
 2000,593,575,593,593,2000,2006,2006,1758,518,518,1759,1983,
 1984,4163,4160,4055,4164,4055,4155,4162,4055,4157,4055,567,564,
 518,564,518,557,712,519,547,518,521,648,518,529,704,708,1277,
 1235,528,518,557,572,1279,518,546,563,617,561,519,710,1034,
 1058,1057,2209,2219,712,710,649,2219,2209,2220,2220,618,705,
 697,1648,1781,1648,1779,1757,5023,5023,5023,5023,5023,5023,
 5023,5023,5023,5023,1648,1648,1648,1648,1648,1648,1743,1664,
 1648,1648,1648,1656,1648,1697,1698,1700,1860,1821,1648,1648,
 1709,1648,1857,1648,1727,1648,1669,1742,1651,1720,1821,1860,
 1857,2003,2031,2031,2007,2003,2053,2041,2052,2007,2041,2053,
 2052,518,1648,1754,1754,4154,4154,4055,4154,4055,4153,4154,
 4055,4153,4055,520,520,518,520,518,520,620,540,519,518,519,
 575,518,570,593,593,1196,1188,519,518,570,520,1196,518,524,
 520,575,524,551,620,996,1029,1029,2000,2006,593,593,575,2006,
 2000,2006,2006,575,593,593,1780,1984,1983,4163,4161,4055,4162,
 4055,4156,4164,4055,4159,4055,564,567,518,563,518,572,710,537,
 528,518,521,617,518,557,708,704,1279,1235,546,518,529,557,
 1277,518,560,564,648,545,543,712,1034,1057,1058,2209,2220,697,
 705,618,2220,2209,2219,2219,649,710,712,1760,1780,5023,5023,
 5023,5023,5023,5023,5023,5023,5023,5023,1648,1648,1648,1648,
 1648,1648,1738,1649,1648,1648,1648,1649,1648,1695,1695,1695,
 1863,1790,1648,1648,1695,1648,1862,1648,1741,1648,1649,1738,
 1649,1741,1790,1863,1862,2038,2054,2034,2034,1997,2034,1997,
 2034,2054,2038,2054,2054,518,4162,4164,4055,4160,4055,4158,
 4163,4055,4155,4055,528,546,518,564,518,572,561,617,564,518,
 521,519,518,704,529,557,1058,1034,567,518,708,557,1057,518,
 710,563,519,712,648,546,1235,1277,1279,618,705,2219,2220,2209,
 712,649,710,697,2209,2219,2220,4164,4162,4055,4161,4055,4159,
 4163,4055,4156,4055,547,528,518,563,518,557,546,648,567,518,
 521,543,518,708,557,529,1057,1034,564,518,704,572,1058,518,
 712,564,537,710,617,560,1235,1279,1277,649,710,2220,2219,2209,
 697,618,705,712,2209,2220,2219,2436,2436,2436,2436,2436,2436,
 2436,2436,2436,2832,2832,3291,2787,3291,2703,2733,2565,2832,
 3291,2531,2559,3291,2712,2718,2720,3498,3467,2832,3291,2712,
 2703,3498,3291,2737,2787,2559,2737,2561,2743,3467,3493,3496,
 4605,4638,4639,4642,4604,4641,4594,4641,4640,4604,4640,4638,
 2436,2436,2436,2436,2436,2436,2436,2436,2832,2832,3291,2787,
 3291,2703,2743,2561,2832,3291,2531,2563,3291,2709,2720,2718,
 3497,3469,2832,3291,2709,2703,3500,3291,2736,2787,2562,2741,
 2564,2733,3469,3496,3493,4594,4642,4642,4639,4594,4638,4605,
 4640,4639,4604,4639,4642,2436,2436,2436,2436,2436,2436,2436,
 2832,2832,3291,2787,3291,2703,2728,2567,2832,3291,2531,2562,
 3291,2704,2715,2715,3482,3431,2832,3291,2704,2703,3482,3291,
 2728,2787,2563,2728,2567,2728,3431,3482,3482,4237,4238,4238,
 4238,4237,4238,4237,4238,4238,4237,4238,4238,2436,2436,2436,
 2436,2436,2436,2832,2832,3291,2787,3291,2703,2741,2562,2832,
 3291,2531,2565,3291,2720,2709,2709,3496,3469,2832,3291,2718,
 2703,3493,3291,2733,2787,2561,2743,2563,2736,3469,3497,3500,
 4604,4639,4638,4640,4605,4642,4594,4639,4642,4594,4642,4639,
 2436,2436,2436,2436,2436,2832,2832,3291,2787,3291,2703,2728,
 2559,2832,3291,2531,2559,3291,2719,2719,2706,3482,3431,2832,
 3291,2706,2703,3482,3291,2728,2787,2559,2728,2559,2728,3431,
 3482,3482,4237,4238,4238,4238,4237,4238,4237,4238,4238,4237,
 4238,4238,2436,2436,2436,2436,2832,2832,3291,2786,3291,2642,
 2670,2515,2832,3291,2515,2515,3291,2642,2642,2642,3499,3433,
 2832,3291,2642,2642,3501,3291,2672,2786,2515,2673,2515,2671,
 3433,3495,3494,4593,4637,4637,4636,4593,4635,4603,4634,4636,
 4558,4636,4637,2436,2436,2436,2832,2832,3291,2787,3291,2703,
 2737,2559,2832,3291,2531,2561,3291,2718,2712,2712,3493,3467,
 2832,3291,2720,2703,3496,3291,2743,2787,2565,2733,2559,2737,
 3467,3498,3498,4604,4640,4641,4641,4594,4639,4604,4642,4638,
 4605,4638,4640,2436,2436,2832,2832,3291,2787,3291,2703,2728,
 2563,2832,3291,2531,2567,3291,2715,2704,2704,3482,3431,2832,
 3291,2715,2703,3482,3291,2728,2787,2567,2728,2562,2728,3431,
 3482,3482,4237,4238,4238,4238,4237,4238,4237,4238,4238,4237,
 4238,4238,2436,2832,2832,3291,2786,3291,2642,2673,2515,2832,
 3291,2515,2515,3291,2642,2642,2642,3495,3433,2832,3291,2642,
 2642,3494,3291,2671,2786,2515,2670,2515,2672,3433,3499,3501,
 4558,4636,4635,4634,4603,4637,4593,4636,4637,4593,4637,4636,
 2832,2832,3291,2787,3291,2703,2730,2560,2832,3291,2531,2564,
 3291,2717,2717,2708,3482,3431,2832,3291,2708,2703,3482,3291,
 2729,2787,2560,2730,2564,2729,3431,3482,3482,4237,4238,4238,
 4238,4237,4238,4237,4238,4238,4237,4238,4238,116,116,116,116,
 32,131,57,32,116,32,54,116,55,123,61,162,178,116,116,118,
 116,162,116,121,116,33,36,40,43,151,170,191,1054,731,881,
 1064,715,731,1054,731,731,715,881,1064,116,116,116,116,43,39,
 116,116,32,33,116,118,60,123,162,178,32,116,55,32,162,116,
 36,116,54,121,57,131,151,191,170,1054,731,1064,881,715,731,
 1054,731,731,715,1064,881,116,116,116,121,117,116,116,116,
 117,116,118,118,118,162,151,116,116,118,116,162,116,121,116,
 117,121,117,121,151,162,162,575,593,593,593,575,593,575,593,
 593,575,593,593,116,31,53,117,116,116,116,117,116,31,31,31,
 193,151,116,116,31,31,173,116,45,31,117,53,117,45,151,193,
 173,715,1065,1065,885,715,1065,715,885,885,715,1065,885,116,
 121,131,116,116,116,117,116,141,118,118,190,165,116,116,122,
 116,165,116,131,116,117,141,122,121,151,162,162,608,695,593,
 593,575,695,608,608,608,575,593,593,47,54,32,116,32,54,116,
 5,31,5,193,151,116,116,31,31,173,116,47,31,33,13,33,13,
 151,173,193,715,1065,885,1065,715,1065,715,885,885,715,885,
 1065,50,121,141,36,51,132,35,11,42,244,212,36,121,7,13,234,
 121,17,45,57,74,58,62,202,322,248,729,871,1406,994,904,877,
 735,841,799,904,1404,993,54,117,4,4,117,77,64,77,226,314,
 33,117,64,33,209,123,51,117,4,58,4,58,200,219,238,1377,926,
 741,819,714,926,1377,900,900,715,769,856,116,32,58,116,61,
 118,55,191,151,116,116,123,116,170,116,132,116,40,44,33,36,
 178,162,162,715,1064,731,731,1054,1064,715,881,881,1054,731,
 731,116,123,116,118,142,123,162,151,116,116,118,116,162,116,
 121,116,132,121,117,131,165,190,165,575,593,695,608,608,593,
 575,593,593,608,695,608,4,116,55,55,55,162,168,32,116,55,
 32,162,116,36,116,4,36,4,36,168,162,162,1047,731,731,731,
 1047,731,1047,731,731,1048,731,731,132,77,64,77,238,200,40,
 117,64,33,219,117,51,117,4,58,4,58,314,209,226,715,856,900,
 926,1377,819,714,741,769,1377,900,926,118,123,142,162,151,
 116,116,118,116,162,116,121,116,123,121,117,142,165,165,190,
 575,593,608,695,608,593,575,593,593,608,608,695,31,5,333,
 215,123,118,31,31,246,123,43,31,64,11,64,7,235,227,227,927,
 1409,758,758,801,1409,927,990,990,823,814,814,31,227,235,55,
 118,5,5,227,118,7,31,77,35,77,43,215,333,246,823,814,1409,
 990,927,758,801,758,814,927,1409,990,227,235,118,118,31,31,
 227,118,35,31,64,7,64,11,215,246,333,801,758,990,1409,927,
 814,823,814,758,927,990,1409,267,170,162,246,173,265,165,248,
 173,219,322,209,234,289,293,293,1195,1040,1559,1559,1544,1041,
 1195,1185,1184,1544,1559,1559,151,151,215,151,267,165,202,151,
 200,202,314,212,277,289,289,1020,1183,1528,1528,1504,1183,
 1021,1183,1183,1504,1528,1528,116,61,32,191,116,44,116,57,
 131,54,121,178,162,162,715,881,731,731,1054,881,715,1064,
 1064,1054,731,731,118,116,162,116,121,116,117,121,117,121,
 151,162,162,575,593,593,593,575,593,575,593,593,575,593,593,
 5,333,142,11,31,77,43,77,35,235,227,227,927,990,814,814,
 823,990,927,1409,1409,801,758,758,193,116,13,31,54,47,54,47,
 151,193,173,715,885,1065,885,715,885,715,1065,1065,715,1065,
 885,190,322,193,238,248,226,244,289,293,293,1195,1184,1559,
 1559,1544,1185,1195,1041,1040,1544,1559,1559,142,116,117,132,
 132,121,151,162,162,608,608,593,593,575,608,608,695,695,575,
 593,593,53,57,62,58,74,212,234,244,904,995,799,871,729,994,
 904,1406,1407,734,841,877,117,45,117,53,151,173,193,715,885,
 885,1065,715,885,715,1065,1065,715,885,1065,51,4,50,314,226,
 209,715,769,926,900,1377,741,714,819,856,1377,926,900,51,17,
 212,244,234,904,1404,877,841,734,1406,904,994,993,728,871,
 799,51,200,238,219,1377,900,819,741,714,900,1377,926,926,715,
 856,769,202,248,322,735,841,994,1406,904,799,729,871,877,904,
 995,1407,267,267,1504,1528,1183,1183,1021,1528,1504,1528,1528,
 1020,1183,1183,265,1544,1559,1041,1185,1195,1559,1544,1559,
 1559,1195,1040,1184,1544,1559,1185,1041,1195,1559,1544,1559,
 1559,1195,1184,1040,898,2370,2370,2334,898,575,898,898,2334,
 2370,2370,2377,2377,2370,593,898,892,892,2370,2377,2377,892,
 898,2377,2370,2377,2377,898,593,892,898,2377,2370,2377,2377,
 898,892,593,2370,2334,2370,2370,575,898,898,898,892,892,2370,
 2377,2377,898,898,2334,2370,2370,593,2370,2377,2377,2370,2377,
 2377,898,898,892,4,17,4,4,5,4,11,11,2515,2515,2515,2515,
 2515,2515,2515,2515,2515,2515,1648,1648,392,1648,412,1648,1687,
 1681,1648,392,1648,1687,392,1681,1687,1687,413,413,1648,412,
 1677,1648,413,412,1681,1648,1686,1677,1681,1687,397,397,397,
 463,463,442,442,442,463,463,463,463,406,406,406,13,4,4,5,4,
 8,16,2515,2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,
 1648,392,1648,393,1648,1717,1669,1648,392,1648,1711,392,1656,
 1711,1718,402,404,1648,393,1664,1648,404,393,1656,1648,1717,
 1664,1657,1711,398,396,398,440,440,434,434,434,411,411,411,
 440,406,406,406,7,16,21,11,27,22,2682,2680,2698,2686,2699,
 2690,2681,2701,2689,2667,1768,1773,418,1769,457,1775,1900,1832,
 1776,419,1770,1904,417,1832,1893,1898,469,460,1769,457,1853,
 1776,462,453,1846,1771,1894,1842,1847,1889,424,425,422,476,
 489,435,427,432,496,493,496,483,446,446,446,4,7,4,7,7,2515,
 2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,412,
 1648,412,1648,1683,1683,1648,412,1648,1676,412,1676,1676,1683,
 413,413,1648,412,1683,1648,413,412,1676,1648,1683,1683,1676,
 1676,413,413,413,460,460,460,460,460,460,460,460,460,460,460,
 460,8,4,5,13,2515,2515,2515,2515,2515,2515,2515,2515,2515,
 2515,1648,1648,393,1648,392,1648,1669,1717,1648,393,1648,1650,
 393,1699,1650,1669,396,398,1648,392,1718,1648,398,392,1699,
 1648,1664,1717,1699,1650,404,401,404,434,434,440,440,440,406,
 406,406,434,411,411,411,11,22,27,2658,2654,2648,2657,2648,
 2658,2655,2647,2656,2642,1744,1752,449,1744,452,1752,1881,1810,
 1747,449,1744,1876,449,1792,1879,1881,467,461,1746,451,1791,
 1747,460,449,1789,1744,1882,1811,1797,1876,458,459,458,500,
 500,475,475,475,477,477,476,499,455,455,455,5,17,2515,2515,
 2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,412,1648,392,
 1648,1681,1688,1648,412,1648,1676,412,1682,1676,1681,397,397,
 1648,392,1685,1648,397,392,1682,1648,1677,1685,1682,1676,413,
 413,413,442,442,463,463,463,406,406,406,442,463,463,463,21,
 2654,2658,2648,2653,2647,2657,2656,2646,2653,2642,1744,1752,
 452,1744,449,1752,1810,1881,1747,451,1744,1803,449,1877,1791,
 1809,459,458,1746,449,1882,1747,458,449,1877,1744,1791,1878,
 1883,1801,460,467,461,475,475,500,500,499,455,455,455,475,
 476,477,477,2682,2683,2696,2681,2695,2685,2686,2701,2693,2666,
 1769,1775,457,1769,418,1773,1848,1898,1776,457,1771,1854,453,
 1902,1839,1832,425,422,1768,419,1897,1776,424,417,1901,1770,
 1842,1894,1888,1852,462,469,460,427,435,489,476,483,446,446,
 446,432,496,496,493,2515,2515,2515,2515,2515,2515,2515,2515,
 2515,5023,5023,3898,5023,3898,5023,5045,5044,5023,3898,5023,
 5027,3898,5029,5029,5044,3901,3921,5023,3898,5037,5023,3925,
 3898,5030,5023,5035,5035,5028,5031,3926,3904,3921,3992,3989,
 3991,3992,3990,3967,3960,3963,3988,3967,3963,3959,2515,2515,
 2515,2515,2515,2515,2515,2515,5023,5023,3898,5023,3898,5023,
 5044,5045,5023,3898,5023,5029,3898,5028,5031,5046,3908,3921,
 5023,3898,5035,5023,3926,3898,5029,5023,5037,5039,5034,5026,
 3925,3914,3919,3991,3992,3992,3989,3991,3960,3970,3967,3989,
 3963,3959,3970,2515,2515,2515,2515,2515,2515,2515,5023,5023,
 3873,5023,3873,5023,5138,5138,5023,3873,5023,5071,3873,5059,
 5075,5133,3880,3895,5023,3873,5127,5023,3894,3873,5076,5023,
 5127,5124,5077,5094,3894,3885,3896,3984,3980,3984,3980,3981,
 3943,3945,3939,3976,3939,3938,3941,2515,2515,2515,2515,2515,
 2515,5023,5023,3898,5023,3898,5023,5046,5042,5023,3898,5023,
 5031,3898,5033,5026,5043,3914,3925,5023,3898,5039,5023,3919,
 3898,5028,5023,5035,5040,5028,5025,3921,3908,3926,3990,3991,
 3989,3988,3992,3970,3959,3960,3992,3959,3970,3960,2515,2515,
 2515,2515,2515,5023,5023,3873,5023,3873,5023,5133,5133,5023,
 3873,5023,5075,3873,5077,5094,5133,3887,3892,5023,3873,5124,
 5023,3893,3873,5059,5023,5125,5123,5060,5072,3892,3887,3893,
 3981,3984,3980,3976,3984,3945,3941,3943,3980,3938,3941,3945,
 2515,2515,2515,2515,5023,5023,3898,5023,3898,5023,5120,5118,
 5023,3898,5023,5055,3898,5050,5057,5120,3910,3932,5023,3898,
 5115,5023,3929,3898,5051,5023,5114,5116,5048,5053,3935,3916,
 3928,3999,4001,4001,3998,3999,3965,3972,3961,3998,3962,3969,
 3972,2515,2515,2515,5023,5023,3898,5023,3898,5023,5043,5043,
 5023,3898,5023,5026,3898,5028,5025,5042,3904,3926,5023,3898,
 5041,5023,3921,3898,5034,5023,5041,5035,5030,5027,3921,3901,
 3925,3988,3990,3988,3990,3989,3959,3963,3970,3991,3970,3960,
 3967,2515,2515,5023,5023,3873,5023,3873,5023,5133,5134,5023,
 3873,5023,5094,3873,5060,5072,5134,3885,3894,5023,3873,5123,
 5023,3896,3873,5077,5023,5129,5129,5058,5092,3895,3880,3894,
 3978,3981,3976,3978,3980,3941,3938,3945,3984,3941,3945,3943,
 2515,5023,5023,3898,5023,3898,5023,5120,5122,5023,3898,5023,
 5057,3898,5048,5053,5122,3916,3935,5023,3898,5116,5023,3928,
 3898,5049,5023,5113,5117,5047,5054,3932,3910,3929,3995,3999,
 3998,3994,4001,3972,3969,3965,4001,3969,3972,3965,5023,5023,
 3872,5023,3872,5023,5142,5139,5023,3872,5023,5112,3872,5105,
 5111,5140,3874,3876,5023,3872,5130,5023,3878,3872,5089,5023,
 5132,5136,5107,5100,3876,3874,3878,3974,3975,3975,3974,3975,
 3936,3936,3936,3975,3936,3936,3936,1648,1648,1648,1648,1648,
 1654,1683,1648,1648,1648,1649,1648,1649,1649,1683,1790,1838,
 1648,1648,1650,1648,1799,1648,1649,1648,1650,1650,1676,1676,
 1799,1790,1838,2037,2017,2017,2037,2017,1989,2017,1989,2017,
 1989,1989,2017,1648,1648,1648,1648,1711,1711,1648,1648,1648,
 1649,1648,1651,1716,1669,1813,1869,1648,1648,1650,1648,1799,
 1648,1649,1648,1650,1664,1723,1657,1799,1867,1817,2055,2036,
 2055,2036,2032,1993,2040,1990,2032,1990,2040,1993,1648,1648,
 1648,1732,1669,1648,392,1648,1649,392,1650,1691,1701,1816,1821,
 1648,1648,1650,1648,1799,1648,1649,1648,1650,1664,1656,1724,
 395,396,398,2039,2039,433,433,429,2002,2002,1996,2037,406,406,
 406,1648,1648,1683,1654,1648,1648,1648,1649,1648,1676,1676,
 1654,1838,1799,1648,1648,1650,1648,1799,1648,1649,1648,1650,
 1683,1649,1649,1799,1838,1799,2017,2037,2037,2017,2017,2017,
 1989,1989,2017,1989,2017,1989,1648,1669,1732,1648,1648,1648,
 1649,1648,1716,1651,1669,396,398,1648,392,1650,1648,395,392,
 1649,1648,1650,1696,1692,1650,1799,1816,1821,433,433,2039,2039,
 2037,406,406,406,429,1996,2002,2002,1671,1671,1648,1648,1648,
 1649,1648,1691,1650,1701,1867,1817,1648,1648,1650,1648,1799,
 1648,1649,1648,1650,1696,1650,1692,1799,1813,1869,2036,2055,
 2036,2055,2032,2040,1993,1990,2032,1990,1993,2040,1818,1669,
 1701,1654,1796,1654,1805,1662,1829,1958,1931,1654,1669,1794,
 1701,1923,1654,1796,1654,1835,1855,1843,1864,1911,2176,1940,
 2106,2092,2286,2162,2148,2077,2067,2059,2097,2135,2281,2139,
 1654,1654,1702,1802,1671,1858,1828,1836,1939,2174,1654,1654,
 1835,1654,1912,1702,1802,1671,1793,1826,1662,1807,1922,1929,
 1965,2286,2162,2106,2092,2093,2139,2281,2135,2145,2059,2068,
 2082,1648,1648,1716,1648,1723,1656,1653,1867,1799,1648,1648,
 1664,1648,1817,1648,1651,1648,1706,1706,1649,1649,1869,1813,
 1799,2032,2055,2036,2032,2055,2040,1990,1993,2036,2040,1993,
 1990,1648,1691,392,1656,1723,1654,1815,1799,1648,1648,1664,
 1648,1821,1648,1650,1648,1736,1664,1649,1649,398,396,395,2037,
 2039,433,429,433,2002,1996,2002,2039,406,406,406,1693,1648,
 1649,1649,1674,1790,1870,1648,1648,1670,1648,1822,1648,1658,
 1648,1695,1650,1690,1652,1870,1790,1822,2049,2018,2018,2029,
 2049,1989,2038,1992,2029,2038,1989,1992,1726,1859,1831,1864,
 1976,1928,1676,1651,1789,1650,1974,1658,1782,1661,1651,1827,
 1792,1831,2183,1913,1943,2109,2121,2149,2168,2307,2078,2063,
 2098,2118,2298,2133,2141,1649,1649,1731,1790,1823,1648,1648,
 1666,1648,1823,1648,1661,1648,1695,1650,1652,1690,399,393,399,
 2030,2019,428,431,431,1987,1988,1988,2030,406,406,406,1782,
 1796,2184,1938,1649,1692,1791,1650,1916,1649,1825,1649,1844,
 1651,1825,1792,1980,1950,1927,2159,2308,2111,2103,2125,2299,
 2137,2136,2152,2075,2079,2064,1796,1966,1975,1649,1650,1791,
 1692,1928,1649,1792,1649,1872,1789,1859,1831,1943,2185,1915,
 2121,2118,2307,2149,2166,2098,2078,2063,2107,2141,2298,2133,
 1920,1965,1654,1654,1818,1654,1931,1673,1843,1712,1826,1793,
 1804,1662,1940,1909,2174,2092,2097,2148,2286,2160,2059,2077,
 2068,2104,2138,2135,2281,403,1790,396,1908,1813,403,393,1937,
 1790,1930,2175,1914,1925,2114,2086,2114,441,436,2270,2303,2303,
 409,407,407,441,2257,2227,2257,1799,395,1946,1799,405,399,
 1916,1822,1921,1910,2186,1972,2115,2114,2086,429,438,2277,2221,
 2276,408,410,408,437,2250,2250,2223,1648,1683,1648,1838,1648,
 1676,1648,1683,1650,1649,1649,1838,1790,1799,2017,2017,2017,
 2017,2037,1989,1989,2017,2037,2017,1989,1989,1696,1648,398,392,
 1715,1648,1664,1736,1649,1649,1821,1816,1799,429,433,2039,2037,
 2039,406,406,406,433,2002,2002,1996,1696,2173,1737,1651,1703,
 1836,1834,1865,1827,1986,1919,1932,2169,2144,2095,2110,2130,
 2132,2142,2280,2287,2126,2060,2070,1869,1648,1691,1648,1668,
 1668,1649,1649,1817,1867,1799,2032,2036,2055,2032,2036,1993,
 1990,2040,2055,1993,2040,1990,399,2187,1870,1986,1945,1938,
 1975,2086,2114,2115,439,439,2278,2278,2226,408,408,410,430,
 2221,2250,2250,1694,1648,1665,1650,1714,1659,1823,1790,1823,
 431,428,2019,2030,2030,406,406,406,431,1988,1987,1988,1726,
 1789,1865,1825,1859,1961,1924,1980,2153,2159,2103,2127,2111,
 2137,2136,2299,2308,2079,2064,2076,1665,1650,1659,1714,1822,
 1790,1870,2029,2018,2018,2049,2029,1989,1992,2038,2049,1992,
 1989,2038,1818,1790,1790,2173,1944,1910,2095,2110,2169,2144,
 2288,2069,2062,2126,2129,2280,2142,2132,1791,1791,1932,1985,
 1921,2144,2287,2130,2095,2108,2280,2132,2142,2167,2069,2126,
 2060,1782,1926,1979,1960,2308,2152,2125,2111,2105,2136,2299,
 2137,2161,2065,2075,2079,1915,1942,2182,2118,2107,2166,2307,
 2150,2063,2098,2078,2122,2133,2141,2298,403,405,2278,2278,439,
 439,430,2250,2250,2221,2226,410,408,408,403,2303,2270,436,441,
 441,2227,2257,2257,2303,407,409,407,2221,2277,438,429,437,
 2250,2223,2250,2276,408,408,410,444,2354,2319,2351,447,448,
 447,443,2369,2369,2337,2319,2354,2354,448,447,447,444,2369,
 2337,2369,444,444,2337,2369,2369,2354,447,448,447,443,2369,
 2337,2369,2351,447,447,448,2369,2369,2337,2319,448,447,447,
 406,406,447,2334,2319,2334,406,447,2334,2334,2319,448,2319,
 2334,2334,2337,2369,2369,406,406,406,13,4,4,5,4,16,8,2515,
 2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,392,
 1648,393,1648,1711,1656,1648,392,1648,1717,392,1669,1718,1711,
 404,401,1648,393,1651,1648,401,393,1669,1648,1706,1651,1669,
 1718,396,398,396,411,411,434,434,434,440,440,440,411,406,406,
 406,11,16,21,7,25,27,2686,2680,2699,2682,2698,2690,2683,2696,
 2688,2668,1776,1768,419,1773,457,1770,1893,1832,1768,418,1775,
 1898,417,1832,1900,1904,460,469,1775,457,1839,1772,469,454,
 1848,1774,1888,1852,1849,1896,426,423,425,496,493,435,432,427,
 476,489,489,496,446,446,446,4,11,4,17,5,2515,2515,2515,2515,
 2515,2515,2515,2515,2515,2515,1648,1648,412,1648,392,1648,1677,
 1686,1648,412,1648,1681,412,1687,1681,1677,397,397,1648,392,
 1687,1648,397,392,1687,1648,1681,1687,1687,1681,413,413,413,
 406,406,463,463,463,442,442,442,406,463,463,463,8,4,13,5,
 2515,2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,
 393,1648,392,1648,1651,1706,1648,393,1648,1669,393,1718,1669,
 1651,398,396,1648,392,1711,1648,396,392,1717,1648,1656,1711,
 1718,1669,402,404,402,406,406,440,440,440,434,434,434,406,
 411,411,411,7,27,22,2655,2657,2647,2654,2648,2655,2658,2648,
 2658,2642,1747,1746,449,1747,451,1746,1876,1789,1744,449,1747,
 1881,449,1809,1884,1876,461,464,1752,452,1791,1744,467,449,
 1810,1749,1883,1801,1812,1881,459,458,459,476,477,475,475,475,
 500,499,500,477,455,455,455,7,7,2515,2515,2515,2515,2515,
 2515,2515,2515,2515,2515,1648,1648,412,1648,412,1648,1676,1676,
 1648,412,1648,1680,412,1680,1680,1676,413,413,1648,412,1676,
 1648,413,412,1680,1648,1676,1676,1680,1679,413,413,413,460,
 460,460,460,460,460,460,460,460,460,460,460,21,2683,2682,
 2696,2679,2698,2688,2686,2699,2690,2668,1775,1768,457,1773,418,
 1772,1852,1888,1768,457,1775,1849,454,1900,1832,1839,423,426,
 1776,419,1904,1770,425,417,1896,1774,1832,1893,1898,1848,469,
 460,469,446,446,476,489,489,435,427,432,446,496,493,496,2658,
 2654,2648,2657,2648,2658,2655,2647,2656,2642,1752,1744,452,
 1747,449,1744,1801,1883,1746,451,1747,1812,449,1884,1809,1791,
 458,459,1747,449,1876,1745,459,449,1881,1749,1789,1876,1881,
 1810,464,461,467,455,455,500,500,499,475,475,475,455,476,477,
 477,2515,2515,2515,2515,2515,2515,2515,2515,2515,5023,5023,
 3898,5023,3898,5023,5026,5033,5023,3898,5023,5043,3898,5042,
 5046,5032,3925,3914,5023,3898,5025,5023,3901,3898,5043,5023,
 5030,5027,5045,5044,3902,3919,3914,3970,3959,3989,3992,3988,
 3990,3991,3988,3963,3963,3967,3960,2515,2515,2515,2515,2515,
 2515,2515,2515,5023,5023,3898,5023,3898,5023,5031,5028,5023,
 3898,5023,5046,3898,5045,5044,5029,3921,3908,5023,3898,5027,
 5023,3902,3898,5042,5023,5029,5029,5044,5045,3901,3921,3904,
 3960,3970,3992,3991,3989,3991,3992,3990,3959,3967,3960,3970,
 2515,2515,2515,2515,2515,2515,2515,5023,5023,3873,5023,3873,
 5023,5094,5077,5023,3873,5023,5133,3873,5133,5133,5075,3891,
 3887,5023,3873,5092,5023,3883,3873,5134,5023,5076,5071,5138,
 5138,3883,3896,3885,3945,3941,3980,3984,3976,3981,3984,3978,
 3938,3939,3943,3945,2515,2515,2515,2515,2515,2515,5023,5023,
 3898,5023,3898,5023,5029,5029,5023,3898,5023,5044,3898,5044,
 5045,5027,3921,3901,5023,3898,5029,5023,3904,3898,5045,5023,
 5028,5031,5046,5042,3908,3921,3902,3967,3960,3991,3990,3992,
 3992,3989,3991,3970,3960,3970,3959,2515,2515,2515,2515,2515,
 5023,5023,3873,5023,3873,5023,5075,5059,5023,3873,5023,5133,
 3873,5138,5138,5071,3895,3879,5023,3873,5071,5023,3882,3873,
 5133,5023,5059,5075,5133,5133,3880,3895,3882,3943,3945,3984,
 3981,3980,3984,3980,3981,3941,3943,3945,3941,2515,2515,2515,
 2515,5023,5023,3898,5023,3898,5023,5057,5049,5023,3898,5023,
 5120,3898,5118,5120,5055,3932,3910,5023,3898,5052,5023,3915,
 3898,5122,5023,5051,5055,5120,5118,3917,3934,3905,3965,3972,
 4001,3999,3998,3999,4001,3995,3969,3961,3965,3972,2515,2515,
 2515,5023,5023,3898,5023,3898,5023,5027,5030,5023,3898,5023,
 5045,3898,5046,5042,5025,3919,3902,5023,3898,5031,5023,3914,
 3898,5044,5023,5033,5026,5043,5043,3914,3925,3901,3963,3967,
 3990,3988,3991,3989,3988,3992,3960,3970,3959,3963,2515,2515,
 5023,5023,3873,5023,3873,5023,5071,5076,5023,3873,5023,5138,
 3873,5133,5133,5092,3896,3883,5023,3873,5075,5023,3885,3873,
 5138,5023,5077,5094,5133,5134,3886,3892,3883,3939,3943,3981,
 3978,3984,3980,3976,3984,3945,3945,3941,3938,2515,5023,5023,
 3898,5023,3898,5023,5055,5051,5023,3898,5023,5120,3898,5120,
 5118,5052,3934,3917,5023,3898,5055,5023,3905,3898,5118,5023,
 5049,5057,5120,5122,3910,3932,3915,3961,3965,3999,3995,4001,
 4001,3998,3999,3972,3965,3972,3969,5023,5023,3872,5023,3872,
 5023,5112,5089,5023,3872,5023,5142,3872,5141,5141,5103,3877,
 3874,5023,3872,5103,5023,3874,3872,5139,5023,5089,5112,5143,
 5139,3874,3877,3874,3936,3936,3975,3974,3975,3975,3975,3974,
 3936,3936,3936,3936,1648,1648,1648,1648,1648,1656,1723,1648,
 1648,1648,1654,1648,1654,1669,1716,1799,1867,1648,1648,1656,
 1648,1813,1648,1669,1648,1649,1649,1711,1711,1790,1817,1867,
 2040,1990,2036,2055,2032,2032,2055,2036,1993,1990,1993,2040,
 1648,1648,1648,1648,1676,1676,1648,1648,1648,1654,1648,1654,
 1683,1649,1799,1838,1648,1648,1649,1648,1790,1648,1654,1648,
 1649,1649,1683,1653,1790,1838,1790,2017,1989,2037,2017,2017,
 2017,2037,2017,1989,1989,2017,1989,1648,1648,1648,1723,1656,
 1648,392,1648,1654,392,1653,1701,1691,1799,1816,1648,1648,1650,
 1648,1816,1648,1669,1648,1649,1649,1669,1732,393,398,396,2002,
 1996,433,433,429,2037,2039,2039,2002,406,406,406,1648,1648,
 1716,1651,1648,1648,1648,1669,1648,1711,1711,1649,1869,1813,
 1648,1648,1649,1648,1790,1648,1654,1648,1651,1716,1669,1654,
 1813,1869,1790,1993,2040,2055,2032,2036,2055,2036,2032,1990,
 1993,2040,1990,1648,1651,1715,1648,1648,1648,1669,1648,1732,
 1669,1649,398,396,1648,392,1649,1648,393,392,1654,1648,1650,
 1691,1701,1654,1815,1821,1790,406,406,2039,2037,2039,433,433,
 429,406,2002,2002,1996,1649,1649,1648,1648,1648,1675,1648,1702,
 1653,1693,1870,1790,1648,1648,1652,1648,1814,1648,1675,1648,
 1658,1694,1654,1702,1814,1799,1866,1989,2038,2018,2049,2029,
 2049,2018,2029,1992,1992,1989,2038,1782,1649,1691,1650,1796,
 1649,1828,1662,1831,1975,1967,1649,1649,1802,1694,1925,1658,
 1802,1649,1824,1856,1806,1864,1913,2182,1942,2098,2078,2307,
 2166,2149,2121,2118,2109,2063,2133,2298,2141,1649,1650,1691,
 1796,1649,1858,1805,1859,1938,2184,1649,1649,1833,1658,1914,
 1693,1802,1649,1790,1824,1662,1843,1924,1960,1979,2299,2137,
 2111,2125,2103,2159,2308,2153,2136,2065,2085,2076,1648,1648,
 1683,1648,1683,1654,1649,1838,1790,1648,1648,1649,1648,1790,
 1648,1654,1648,1676,1676,1654,1654,1838,1799,1790,1989,2017,
 2017,2017,2037,2037,2017,2017,1989,2017,1989,1989,1648,1701,
 392,1669,1732,1649,1821,1816,1648,1648,1649,1648,1790,1648,
 1654,1648,1716,1651,1669,1654,396,398,393,2002,2002,433,429,
 433,2039,2039,2037,1996,406,406,406,1701,1648,1671,1671,1649,
 1817,1867,1648,1648,1649,1648,1790,1648,1654,1648,1691,1650,
 1701,1653,1867,1817,1790,2040,1993,2036,2032,2055,2036,2055,
 2032,1990,2040,1993,1990,1731,1836,1829,1864,1965,1920,1711,
 1669,1828,1654,1929,1654,1818,1653,1662,1807,1802,1829,2176,
 1912,1939,2059,2077,2148,2160,2286,2092,2097,2106,2067,2281,
 2135,2139,1671,1654,1726,1823,1790,1648,1648,1659,1648,1820,
 1648,1673,1648,1693,1658,1653,1702,394,395,394,1987,1988,428,
 431,431,2030,2019,2030,1988,406,406,406,1819,1802,2174,1939,
 1669,1701,1796,1654,1909,1654,1829,1653,1804,1662,1829,1802,
 1957,1931,1920,2138,2281,2106,2093,2092,2286,2162,2147,2134,
 2077,2067,2061,1796,1931,1958,1654,1654,1802,1702,1920,1671,
 1802,1654,1858,1828,1836,1829,1939,2174,1909,2077,2066,2286,
 2147,2162,2106,2092,2093,2061,2139,2281,2135,1928,1976,1656,
 1650,1782,1652,1968,1659,1808,1676,1833,1802,1828,1662,1942,
 1915,2185,2078,2063,2149,2307,2168,2109,2120,2116,2099,2141,
 2133,2298,403,1817,398,1915,1799,403,395,1940,1799,1960,2182,
 1912,1922,2088,2115,2114,408,410,2277,2276,2221,429,438,438,
 408,2223,2250,2250,1790,393,1942,1814,400,394,1909,1790,1924,
 1913,2176,1929,2113,2088,2113,409,407,2270,2303,2303,441,436,
 441,407,2257,2225,2257,1648,1716,1648,1867,1648,1711,1648,1723,
 1656,1653,1669,1867,1799,1813,1990,1993,2032,2036,2055,2036,
 2032,2055,2040,2040,1990,1993,1691,1648,396,392,1732,1648,1656,
 1723,1654,1669,1816,1799,1816,406,406,2037,2039,2039,433,429,
 433,406,2002,1996,2002,1693,2185,1726,1662,1676,1859,1831,1864,
 1808,1976,1928,1968,2141,2133,2109,2116,2121,2149,2168,2307,
 2298,2078,2063,2099,1866,1648,1702,1648,1649,1649,1675,1675,
 1790,1870,1814,1992,1989,2049,2029,2018,2018,2029,2049,2038,
 1989,2038,1992,394,2176,1845,1979,1942,1939,1959,2113,2114,
 2087,407,407,2303,2261,2303,441,441,436,409,2257,2257,2227,
 1702,1648,1649,1649,1731,1673,1790,1823,1820,406,406,2030,2030,
 2019,428,431,431,406,1987,1988,1988,1684,1843,1864,1829,1850,
 1929,1923,1959,2135,2139,2093,2102,2106,2162,2145,2286,2281,
 2067,2061,2083,1649,1649,1654,1684,1790,1799,1845,1991,1991,
 2032,2048,2032,2032,2032,2048,2028,1991,1991,2028,1782,1796,
 1802,2184,1938,1914,2065,2085,2159,2153,2308,2111,2103,2125,
 2076,2299,2137,2136,1796,1802,1967,1975,1925,2133,2298,2121,
 2109,2118,2307,2149,2166,2141,2098,2078,2063,1819,1920,1965,
 1929,2281,2135,2092,2106,2097,2148,2286,2160,2139,2059,2077,
 2067,1909,1940,2176,2067,2061,2162,2286,2145,2093,2106,2102,
 2083,2135,2138,2281,403,400,2257,2225,441,441,436,2270,2303,
 2303,2257,409,407,407,403,2223,2250,429,438,438,2277,2221,
 2276,2250,408,410,408,2257,2257,441,436,441,2303,2303,2261,
 2227,407,407,409,406,2337,2369,2369,447,448,447,406,2334,2323,
 2334,2369,2369,2337,448,447,447,406,2323,2334,2334,444,444,
 2354,2319,2351,2369,447,448,447,443,2351,2354,2328,2335,447,
 447,448,2319,2354,2354,2369,448,447,447,444,444,447,2337,2369,
 2369,443,447,2369,2337,2369,448,2369,2369,2335,2334,2334,2323,
 406,406,406,5,6,19,5,26,26,2664,2659,2643,2664,2643,2644,
 2660,2643,2645,2642,1753,1751,416,1750,450,1751,1886,1783,1753,
 416,1751,1898,416,1783,1886,1898,465,465,1748,450,1785,1753,
 465,449,1783,1751,1887,1784,1783,1885,421,421,421,494,494,420,
 420,420,494,494,494,494,445,445,445,4,13,4,16,8,2515,2515,
 2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,392,1648,393,
 1648,1718,1664,1648,392,1648,1699,392,1650,1699,1718,402,404,
 1648,393,1669,1648,404,393,1650,1648,1718,1669,1650,1699,398,
 396,398,411,411,406,406,406,440,440,440,411,434,434,434,6,4,
 6,6,2515,2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,
 1648,385,1648,385,1648,1679,1678,1648,385,1648,1679,385,1679,
 1679,1679,385,385,1648,385,1680,1648,385,385,1679,1648,1678,
 1679,1680,1680,385,385,385,387,387,387,387,387,387,387,387,
 387,387,387,387,13,26,26,2661,2665,2643,2665,2643,2662,2661,
 2643,2663,2642,1748,1753,416,1751,450,1753,1885,1787,1750,416,
 1751,1885,416,1786,1898,1886,465,465,1753,450,1783,1751,465,
 449,1787,1751,1899,1783,1788,1886,421,421,421,494,494,445,445,
 445,494,494,494,494,420,420,420,8,16,2515,2515,2515,2515,
 2515,2515,2515,2515,2515,2515,1648,1648,392,1648,393,1648,1707,
 1651,1648,392,1648,1701,392,1650,1701,1708,404,402,1648,393,
 1656,1648,401,393,1650,1648,1710,1656,1650,1701,396,398,396,
 440,440,406,406,406,411,411,411,440,434,434,434,1,2451,2454,
 2436,2444,2436,2451,2453,2436,2446,2436,528,546,368,521,59,
 547,561,617,528,368,521,552,368,617,545,560,80,80,546,59,
 648,528,80,59,608,521,521,608,648,546,380,380,380,65,65,501,
 501,501,72,72,72,65,501,501,501,2454,2451,2436,2449,2436,
 2454,2453,2436,2450,2436,547,528,368,521,59,528,545,648,546,
 368,521,568,368,648,560,545,80,80,528,59,617,546,80,59,608,
 521,554,608,617,561,380,380,380,72,72,501,501,501,65,65,65,
 72,501,501,501,2484,2438,2493,2438,2484,2493,2437,2484,2438,
 4165,4165,3792,4165,3024,4165,4311,4388,4165,3792,4165,4314,
 3792,4383,4316,4317,3118,3120,4165,3024,4381,4165,3118,3017,
 4385,4165,4301,4382,4374,4317,3797,3794,3797,3084,3045,3949,
 3957,3955,3063,3061,3070,3070,3953,3953,3951,2438,2484,2438,
 2493,2493,2438,2484,2437,4165,4165,3792,4165,3024,4165,4317,
 4374,4165,3792,4165,4316,3792,4374,4317,4316,3119,3119,4165,
 3024,4382,4165,3121,3017,4383,4165,4300,4384,4388,4311,3798,
 3797,3794,3061,3084,3957,3949,3950,3061,3084,3063,3045,3953,
 3951,3957,2438,2436,2438,2437,2436,2437,2436,4056,4056,3790,
 4056,2786,4056,4082,4236,4056,3790,4056,4079,3790,4234,4078,
 4078,2833,2833,4056,2786,4235,4056,2833,2786,4235,4056,4074,
 4234,4236,4082,3791,3791,3791,2786,2786,3871,3871,3871,2786,
 2786,2786,2786,3871,3871,3871,2438,2484,2484,2438,2493,2437,
 4165,4165,3792,4165,3024,4165,4316,4383,4165,3792,4165,4317,
 3792,4388,4311,4314,3120,3118,4165,3024,4384,4165,3117,3017,
 4374,4165,4299,4387,4386,4315,3799,3799,3797,3063,3061,3949,
 3955,3957,3084,3045,3061,3084,3951,3957,3951,2438,2438,2436,
 2438,2436,4056,4056,3790,4056,2786,4056,4077,4234,4056,3790,
 4056,4077,3790,4236,4082,4079,2833,2833,4056,2786,4234,4056,
 2833,2786,4234,4056,4073,4234,4234,4081,3791,3791,3791,2786,
 2786,3871,3871,3871,2786,2786,2786,2786,3871,3871,3871,2484,
 2437,2493,2438,4165,4165,3792,4165,3010,4165,4313,4372,4165,
 3792,4165,4313,3792,4372,4313,4313,3106,3106,4165,3010,4375,
 4165,3108,3015,4379,4165,4298,4377,4380,4308,3801,3795,3793,
 3048,3067,3956,3952,3952,3048,3067,3027,3035,3948,3954,3958,
 2438,2484,2438,4165,4165,3792,4165,3024,4165,4314,4385,4165,
 3792,4165,4311,3792,4386,4315,4315,3117,3121,4165,3024,4387,
 4165,3120,3017,4388,4165,4303,4373,4385,4314,3797,3798,3798,
 3070,3063,3955,3955,3949,3045,3070,3084,3061,3957,3951,3953,
 2438,2436,4056,4056,3790,4056,2786,4056,4079,4235,4056,3790,
 4056,4082,3790,4234,4080,4076,2833,2833,4056,2786,4234,4056,
 2833,2786,4236,4056,4075,4236,4234,4076,3791,3791,3791,2786,
 2786,3871,3871,3871,2786,2786,2786,2786,3871,3871,3871,2438,
 4165,4165,3792,4165,3010,4165,4313,4379,4165,3792,4165,4313,
 3792,4380,4308,4310,3107,3106,4165,3010,4377,4165,3105,3015,
 4372,4165,4297,4376,4378,4313,3800,3800,3796,3027,3048,3952,
 3947,3956,3067,3035,3048,3067,3954,3958,3954,4056,4056,3790,
 4056,2786,4056,4152,4234,4056,3790,4056,4152,3790,4235,4151,
 4150,2833,2833,4056,2786,4234,4056,2833,2786,4234,4056,4132,
 4236,4236,4149,3791,3791,3791,2786,2786,3870,3870,3870,2786,
 2786,2786,2786,3870,3870,3870,519,519,575,520,575,591,591,575,
 519,519,591,519,715,620,690,1069,1028,575,519,715,575,1069,
 520,714,575,577,714,582,601,1189,1191,1204,1055,714,2005,2046,
 1999,714,1055,714,714,2005,1999,2046,519,575,520,575,602,583,
 575,519,519,580,519,715,690,620,1069,1028,575,519,715,575,
 1069,520,714,575,576,714,591,591,1191,1204,1191,1055,714,2046,
 2005,1999,714,1055,714,714,2005,2046,1999,519,518,519,524,575,
 519,366,519,550,366,575,570,570,996,996,519,518,575,519,996,
 518,575,519,538,575,575,524,367,367,367,575,575,386,386,386,
 575,575,575,575,386,386,386,520,519,690,715,519,519,575,620,
 519,583,601,580,1028,1069,575,520,714,575,1069,519,715,575,
 576,591,714,591,1189,1204,1189,714,1055,2046,1999,2005,1055,
 714,714,714,1999,2046,2005,520,524,620,520,518,520,524,518,
 620,524,524,33,33,519,31,575,519,32,31,575,519,520,593,593,
 524,1188,1188,1188,31,31,2000,2000,2000,31,31,31,31,2000,
 2000,2000,638,715,519,519,575,638,519,582,580,601,1028,1069,
 575,520,714,575,1069,519,715,575,577,582,714,601,1191,1189,
 1204,714,1055,1999,2046,2005,1055,714,714,714,1999,2005,2046,
 730,620,570,580,654,553,776,700,689,1100,1072,580,524,720,
 601,1072,524,730,591,684,850,736,614,1294,1473,1301,729,811,
 2301,2155,2163,837,735,734,729,2163,2300,2155,715,575,583,730,
 575,937,776,850,1195,1331,714,575,898,714,1182,593,892,714,
 716,898,575,736,1289,1289,1302,1377,898,2072,2091,2071,898,
 1377,892,892,2073,2073,2089,519,575,690,519,591,591,591,1028,
 1069,575,520,714,575,1069,519,715,575,593,577,714,580,1204,
 1189,1191,714,1055,2005,1999,2046,1055,714,714,714,2046,1999,
 2005,519,570,366,575,524,550,996,996,519,518,575,519,996,518,
 575,519,565,575,575,550,367,367,367,575,575,386,386,386,575,
 575,575,575,386,386,386,601,519,715,638,638,1069,1028,575,
 519,715,575,1069,520,714,575,593,714,577,580,1204,1190,1189,
 1055,714,1999,2005,2046,714,1055,714,714,2046,2005,1999,574,
 850,690,656,1100,1072,601,524,736,580,1072,524,730,592,541,
 776,721,690,1472,1294,1301,735,837,2163,2155,2301,810,728,728,
 734,2301,2163,2155,575,553,574,996,996,519,518,575,519,996,
 518,575,519,569,575,575,571,367,367,367,575,575,386,386,386,
 575,575,575,575,386,386,386,730,730,1331,1195,714,593,892,
 714,1182,575,898,714,731,731,898,721,1302,1288,1288,898,1377,
 2072,2071,2091,1377,898,892,892,2089,2074,2074,654,1072,1100,
 591,524,730,601,1072,524,720,580,713,736,850,690,1301,1473,
 1294,837,734,2301,2163,2155,728,810,728,734,2155,2301,2163,
 1072,1100,591,524,730,580,1072,524,736,601,589,721,776,701,
 1301,1294,1473,811,728,2163,2301,2155,734,837,734,728,2155,
 2163,2300,54,1069,33,1182,1069,54,32,1195,1069,1071,1331,1182,
 1072,1492,1492,1492,32,46,2258,2258,2258,46,32,32,32,2258,
 2258,2258,1069,32,1195,1069,54,33,1182,1069,1071,1182,1331,
 1072,1492,1492,1492,46,32,2258,2258,2258,32,46,32,32,2258,
 2258,2258,520,591,519,1028,520,582,519,682,715,715,620,1204,
 1191,1189,714,714,1999,2005,2046,714,714,1055,1055,2046,2005,
 1999,593,520,33,31,620,520,520,620,575,524,1188,1188,1188,31,
 31,2000,2000,2000,31,31,31,31,2000,2000,2000,583,1331,620,
 731,582,847,898,937,776,1302,1289,1290,898,892,2074,2074,2089,
 892,898,1377,1377,2091,2072,2071,1028,520,583,519,604,715,715,
 638,1191,1204,1191,714,714,2046,2005,1999,714,714,1055,1055,
 2005,2046,1999,33,1331,1028,1099,1195,1195,1100,1492,1492,1492,
 32,32,2258,2258,2258,32,32,46,46,2258,2258,2258,593,520,520,
 575,620,524,1188,1188,1188,31,31,1994,1994,1994,31,31,31,31,
 1994,1994,1994,592,777,937,898,850,1289,1289,1302,892,898,
 2071,2091,2072,898,892,1377,1377,2074,2074,2089,622,715,715,
 690,1189,1191,1204,714,714,2005,2046,1999,714,714,1055,1055,
 2005,1999,2046,715,715,643,1471,1332,1303,731,731,2172,2158,
 2302,716,716,803,831,2302,2172,2156,892,730,1289,1302,1288,
 892,1377,2089,2074,2073,1377,892,898,898,2072,2091,2072,730,
 1288,1302,1289,1377,892,2091,2072,2072,892,1377,898,898,2073,
 2089,2074,1294,1301,1473,735,735,2155,2301,2163,729,729,811,
 837,2163,2155,2301,367,367,1545,1545,388,389,390,1545,1545,
 1545,1545,391,389,388,367,1545,1545,391,389,388,1545,1545,
 1545,1545,389,391,388,1545,1545,389,391,388,1545,1545,1545,
 1545,389,388,391,31,2368,2368,2368,31,31,31,31,2368,2368,
 2368,2368,2368,2368,31,31,31,31,2368,2368,2368,386,386,2368,
 2368,2368,2368,392,392,392,386,2368,2368,2368,2368,392,392,
 392,2368,2368,2368,2368,392,392,392,31,31,31,2368,2368,2368,
 31,31,2368,2368,2368,31,2368,2368,2368,2368,2368,2368,386,386,
 386,8,21,5,27,22,2655,2653,2646,2658,2647,2653,2654,2648,
 2657,2642,1746,1747,449,1744,451,1747,1878,1791,1752,449,1744,
 1883,449,1791,1877,1882,467,460,1744,452,1809,1752,461,449,
 1801,1744,1880,1810,1803,1877,458,459,458,476,477,455,455,455,
 500,499,500,477,475,475,475,1,8,26,26,2453,2444,2436,2454,
 2436,2446,2451,2436,2452,2436,547,528,59,521,368,528,608,521,
 546,59,521,648,59,545,617,648,380,380,527,368,560,547,380,
 368,546,521,617,560,552,608,80,80,80,501,501,72,72,72,501,
 501,501,501,65,65,65,21,30,30,2483,2480,2436,2483,2436,2481,
 2483,2436,2483,2436,561,562,85,554,368,562,695,521,561,85,
 554,699,85,527,699,699,382,382,561,368,527,561,382,368,527,
 554,699,527,549,695,88,88,88,516,516,86,86,86,516,516,516,
 516,86,86,86,22,27,2658,2653,2649,2655,2651,2653,2657,2650,
 2654,2642,1752,1744,449,1747,452,1744,1877,1801,1746,449,1749,
 1879,449,1800,1876,1883,461,467,1747,451,1795,1745,464,449,
 1798,1747,1876,1791,1791,1876,459,458,459,500,500,455,455,455,
 477,477,476,499,475,475,475,30,2779,2777,2784,2777,2783,2775,
 2779,2784,2775,2770,1955,1936,473,1952,473,1934,2020,2010,1936,
 473,1952,2026,471,2011,2011,2016,488,504,1955,473,2016,1934,
 504,471,2022,1953,2010,2020,2026,2022,504,488,504,515,515,497,
 486,482,497,482,486,515,515,515,515,2771,2772,2785,2773,2781,
 2777,2773,2782,2779,2769,1933,1954,474,1933,474,1954,2021,2008,
 1964,474,1935,2027,472,2009,2012,2009,502,476,1933,474,2021,
 1964,481,472,2021,1935,2013,2013,2023,2023,481,502,476,476,
 495,495,476,480,513,512,513,480,513,513,512,2490,2464,2497,
 2479,2488,2495,2441,2492,2462,4219,4191,3185,4176,3821,4205,
 4396,4291,4225,3185,4212,4420,3173,4291,4432,4418,3842,3844,
 4184,3818,4340,4230,3855,3826,4323,4211,4395,4343,4321,4437,
 3272,3252,3248,4018,4021,3220,3223,3233,4015,4022,4032,4027,
 3199,3203,3195,2458,2490,2458,2497,2496,2455,2485,2442,4192,
 4168,3180,4168,3803,4172,4430,4289,4192,3180,4172,4415,3164,
 4289,4430,4415,3845,3845,4171,3805,4331,4217,3853,3807,4318,
 4170,4394,4330,4319,4429,3261,3251,3245,4016,4023,3235,3211,
 3211,4016,4023,4040,4024,3197,3191,3207,2479,2436,2459,2443,
 2436,2440,2436,4142,4107,2954,4099,3792,4100,4269,4067,4143,
 2954,4101,4280,2954,4062,4256,4282,3863,3861,4102,3792,4089,
 4141,3860,3792,4070,4108,4263,4087,4071,4261,3102,3100,3104,
 4045,4046,2979,2976,2974,4048,4046,4050,4048,2963,2962,2957,
 2464,2488,2488,2469,2495,2448,4225,4176,3185,4192,3822,4212,
 4432,4291,4219,3185,4205,4419,3173,4291,4396,4420,3844,3842,
 4192,3820,4346,4221,3851,3826,4320,4188,4409,4348,4325,4392,
 3259,3269,3267,4015,4022,3220,3233,3223,4018,4021,4038,4030,
 3193,3210,3196,2459,2463,2436,2472,2436,4143,4099,2954,4107,
 3792,4101,4256,4062,4142,2954,4100,4282,2954,4068,4269,4280,
 3861,3863,4099,3792,4085,4144,3859,3792,4064,4106,4258,4083,
 4064,4255,3095,3098,3104,4048,4046,2979,2974,2976,4045,4046,
 4047,4045,2961,2955,2957,2486,2439,2496,2456,4217,4173,3163,
 4173,3806,4169,4391,4290,4217,3163,4169,4441,3181,4290,4391,
 4441,3857,3857,4167,3804,4328,4209,3831,3802,4305,4166,4427,
 4327,4304,4426,3253,3255,3246,4034,4029,3230,3218,3218,4034,
 4029,4006,4009,3191,3198,3206,2478,2490,2466,4218,4196,3188,
 4174,3810,4203,4407,4293,4223,3186,4193,4417,3166,4292,4431,
 4421,3846,3843,4182,3813,4344,4229,3858,3828,4326,4208,4397,
 4334,4324,4440,3264,3273,3250,4016,4019,3219,3224,3214,4017,
 4020,4041,4026,3209,3194,3202,2465,2436,4140,4103,2954,4100,
 3792,4110,4254,4065,4140,2954,4104,4285,2954,4063,4259,4283,
 3867,3865,4114,3792,4086,4140,3867,3792,4072,4111,4268,4092,
 4069,4264,3103,3094,3104,4054,4053,2980,2975,2973,4049,4053,
 4051,4049,2957,2956,2959,2471,4228,4213,3169,4194,3817,4174,
 4410,4296,4218,3170,4197,4424,3189,4296,4390,4442,3854,3848,
 4189,3816,4338,4224,3830,3808,4307,4200,4393,4337,4306,4404,
 3258,3256,3262,4036,4028,3212,3231,3225,4035,4025,4006,4011,
 3205,3208,3201,4146,4122,2953,4124,3792,4121,4276,4057,4146,
 2953,4127,4288,2953,4058,4275,4287,3841,3839,4123,3792,4131,
 4146,3840,3792,4057,4126,4272,4133,4060,4274,3090,3091,3092,
 4004,4005,2970,2968,2969,4004,4005,4004,4004,2953,2953,2953,
 621,566,598,547,535,817,620,621,525,621,838,566,592,767,614,
 1218,1210,598,525,620,621,1213,548,621,539,763,598,645,675,
 1088,1088,1037,2188,2191,788,1047,788,2197,2206,2197,2189,761,
 761,1059,559,520,520,595,657,594,598,555,593,766,520,576,666,
 786,1210,1261,595,521,575,539,1237,534,584,621,815,659,693,
 843,1087,1050,1089,2216,2196,1062,805,774,2188,2211,2194,2203,
 756,1064,765,555,518,555,707,519,525,54,520,614,54,519,698,
 706,1215,1233,520,518,529,566,1233,518,519,559,593,520,519,
 709,75,78,78,2205,2199,67,67,63,2199,2205,2205,2205,54,54,
 54,520,593,666,576,621,559,595,786,520,594,657,766,1261,1210,
 621,528,575,536,1229,522,578,595,843,709,608,815,1089,1049,
 1087,2188,2211,1062,774,805,2216,2196,2203,2193,765,1064,756,
 528,593,545,546,518,528,648,518,545,593,648,379,379,521,368,
 520,525,376,368,519,521,608,554,521,608,1034,1032,1034,498,
 498,615,649,649,498,498,492,491,618,593,618,814,576,621,520,
 621,849,559,617,758,673,1258,1237,595,520,595,598,1217,522,
 594,520,765,658,579,658,1089,1087,1049,2203,2216,774,1061,805,
 2211,2193,2188,2196,765,756,1064,731,767,698,758,937,593,757,
 857,971,1370,1328,775,617,716,674,1381,624,745,828,974,879,
 834,985,1200,1394,1250,2245,2263,1413,977,949,2260,2248,2295,
 2294,929,1409,967,591,519,617,752,519,614,757,772,1337,1469,
 577,519,594,581,1295,520,575,576,738,593,519,731,1091,1087,
 1087,2309,2251,740,740,753,2251,2309,2222,2222,773,757,757,
 566,536,614,566,620,817,838,1210,1218,535,546,663,621,1218,
 525,591,597,600,586,581,762,1039,1088,1088,2197,2206,788,788,
 1047,2188,2191,2191,2197,1059,761,761,555,706,54,519,707,614,
 1233,1215,559,518,532,566,1233,518,519,520,709,533,519,593,
 78,78,75,2199,2205,67,63,67,2205,2199,2205,2205,54,54,54,
 673,559,576,814,849,1237,1258,520,521,657,597,1210,520,577,
 595,657,575,594,765,1050,1087,1089,2211,2193,774,805,1061,
 2203,2216,2196,2190,1064,756,765,713,772,971,988,1380,1336,
 673,648,858,772,1334,614,752,820,633,748,739,971,1378,1198,
 1251,2249,2268,946,980,1374,2266,2247,2244,2243,1400,931,970,
 519,593,713,1231,1231,555,518,520,525,1211,518,519,555,696,
 522,519,696,78,75,78,2195,2195,63,67,67,2195,2195,2192,2192,
 54,54,54,731,752,1469,1337,576,521,576,581,1295,519,576,577,
 731,596,576,738,1087,1087,1091,2251,2309,740,753,740,2309,
 2251,2222,2222,757,757,773,937,1328,1370,828,608,727,606,1391,
 632,743,775,985,862,873,974,1249,1388,1200,2260,2248,1413,949,
 977,2245,2263,2274,2272,967,1409,929,1336,1380,820,614,786,
 772,1324,651,836,680,971,772,806,865,1251,1198,1353,2266,2246,
 946,1374,980,2249,2268,2230,2232,970,930,1400,384,1237,379,
 1298,1213,384,375,1338,1217,1383,1482,1296,1322,1516,1548,1553,
 511,503,1552,1551,1493,476,508,508,511,1547,1562,1562,1210,
 376,1341,1218,383,377,1299,1229,1333,1295,1481,1389,1549,1553,
 1493,476,508,1552,1493,1551,511,503,511,505,1562,1562,1547,
 528,702,621,1258,520,617,593,661,575,576,756,1050,1089,1087,
 2188,2194,805,774,1061,2203,2196,2216,2210,1064,765,756,554,
 547,379,368,546,520,617,560,519,593,1034,1034,1032,492,498,
 649,615,649,498,492,498,498,618,618,593,588,1485,565,668,672,
 876,676,692,842,1146,1084,1096,2282,2239,888,848,874,2224,
 2253,2314,2317,859,882,765,1222,548,644,621,825,670,638,825,
 1088,1038,1088,2197,2197,1051,788,788,2191,2189,2188,2206,761,
 1059,761,377,1484,1257,1372,1343,1339,1371,1548,1506,1549,508,
 505,1509,1550,1551,511,511,503,484,1562,1546,1562,520,534,593,
 520,524,635,1032,1035,1035,487,479,655,655,615,479,487,487,
 487,593,612,612,687,772,677,576,870,1091,1090,1142,2241,2259,
 754,853,753,2259,2241,2318,2318,773,771,863,756,593,585,662,
 1087,1089,1050,2194,2188,805,1060,774,2196,2203,2216,2211,756,
 765,1064,725,731,926,1393,1252,1197,2228,2293,979,937,1402,
 2292,2229,2269,2264,1408,969,926,576,756,1086,1148,1094,2222,
 2313,878,822,887,2315,2233,2284,2255,884,864,756,746,1087,
 1144,1092,2316,2235,855,755,740,2235,2316,2262,2262,757,868,
 779,1197,1252,1393,2293,2228,979,1403,937,2231,2292,2289,2279,
 926,969,1408,87,87,2359,2324,81,81,83,2353,2376,2376,2359,79,
 75,75,87,2376,2376,84,81,81,2355,2359,2329,2353,75,79,75,
 2319,2359,81,82,81,2376,2353,2376,2355,75,75,79,510,2372,
 2319,2358,517,514,517,506,2427,2427,2425,2372,2357,2326,514,
 517,517,510,2424,2427,2427,73,73,2372,2372,2338,2336,63,66,
 63,73,2358,2326,2358,2356,63,63,66,2319,2357,2357,2358,66,63,
 63,510,510,517,2425,2427,2427,506,517,2427,2427,2425,514,2427,
 2425,2427,2427,2425,2427,54,54,54,16,4,13,5,2515,2515,2515,
 2515,2515,2515,2515,2515,2515,2515,1648,1648,393,1648,392,1648,
 1664,1718,1648,393,1648,1656,393,1711,1656,1664,396,398,1648,
 392,1718,1648,398,392,1711,1648,1669,1718,1711,1656,404,402,
 404,406,406,411,411,411,434,434,434,406,440,440,440,17,22,
 27,2686,2681,2701,2683,2695,2693,2682,2696,2685,2666,1768,1776,
 419,1769,457,1776,1894,1842,1775,418,1771,1888,417,1839,1902,
 1897,469,462,1768,457,1832,1773,460,453,1852,1770,1898,1848,
 1854,1901,422,425,424,496,496,446,446,446,489,483,476,493,
 427,435,432,11,11,2515,2515,2515,2515,2515,2515,2515,2515,
 2515,2515,1648,1648,392,1648,412,1648,1685,1677,1648,392,1648,
 1682,392,1676,1682,1685,413,413,1648,412,1681,1648,413,412,
 1676,1648,1688,1681,1676,1682,397,397,397,463,463,406,406,406,
 463,463,463,463,442,442,442,21,2681,2686,2701,2680,2699,2689,
 2682,2698,2690,2667,1768,1776,457,1769,419,1776,1842,1894,1773,
 457,1770,1847,453,1893,1832,1853,425,424,1768,418,1898,1775,
 422,417,1889,1771,1832,1900,1904,1846,460,469,462,446,446,496,
 496,493,435,432,427,446,476,489,483,2656,2657,2647,2654,2648,
 2656,2658,2648,2658,2642,1746,1747,451,1744,449,1747,1811,1882,
 1752,452,1744,1797,449,1879,1792,1791,459,458,1744,449,1881,
 1752,458,449,1876,1744,1810,1880,1876,1789,461,467,460,455,
 455,477,476,477,475,475,475,455,500,500,499,2515,2515,2515,
 2515,2515,2515,2515,2515,2515,5023,5023,3898,5023,3898,5023,
 5035,5040,5023,3898,5023,5030,3898,5025,5028,5041,3901,3921,
 5023,3898,5042,5023,3925,3898,5027,5023,5043,5043,5026,5034,
 3926,3904,3921,3970,3960,3959,3970,3963,3988,3989,3990,3967,
 3988,3990,3991,2515,2515,2515,2515,2515,2515,2515,2515,5023,
 5023,3898,5023,3898,5023,5041,5035,5023,3898,5023,5028,3898,
 5026,5034,5039,3908,3921,5023,3898,5043,5023,3926,3898,5025,
 5023,5042,5046,5031,5028,3924,3914,3919,3959,3970,3970,3960,
 3959,3989,3992,3988,3960,3990,3991,3992,2515,2515,2515,2515,
 2515,2515,2515,5023,5023,3873,5023,3873,5023,5128,5128,5023,
 3873,5023,5058,3873,5072,5060,5123,3879,3895,5023,3873,5134,
 5023,3894,3873,5092,5023,5134,5133,5094,5077,3894,3885,3896,
 3941,3945,3941,3945,3938,3976,3980,3978,3943,3978,3981,3984,
 2515,2515,2515,2515,2515,2515,5023,5023,3898,5023,3898,5023,
 5038,5037,5023,3898,5023,5033,3898,5031,5028,5035,3914,3924,
 5023,3898,5046,5023,3919,3898,5026,5023,5045,5044,5029,5029,
 3921,3907,3926,3963,3959,3960,3967,3970,3992,3991,3989,3970,
 3991,3992,3989,2515,2515,2515,2515,2515,5023,5023,3873,5023,
 3873,5023,5123,5125,5023,3873,5023,5060,3873,5094,5077,5124,
 3886,3891,5023,3873,5133,5023,3893,3873,5072,5023,5133,5133,
 5075,5059,3891,3886,3893,3938,3941,3945,3943,3941,3980,3984,
 3976,3945,3981,3984,3980,2515,2515,2515,2515,5023,5023,3898,
 5023,3898,5023,5117,5113,5023,3898,5023,5047,3898,5053,5048,
 5116,3910,3932,5023,3898,5122,5023,3929,3898,5054,5023,5121,
 5119,5056,5049,3935,3916,3928,3969,3972,3972,3965,3969,3998,
 4001,3994,3965,3995,3999,4001,2515,2515,2515,5023,5023,3898,
 5023,3898,5023,5035,5035,5023,3898,5023,5028,3898,5029,5029,
 5036,3904,3926,5023,3898,5044,5023,3920,3898,5031,5023,5044,
 5045,5027,5030,3920,3901,3924,3967,3963,3967,3963,3960,3991,
 3990,3992,3959,3992,3989,3988,2515,2515,5023,5023,3873,5023,
 3873,5023,5124,5126,5023,3873,5023,5077,3873,5074,5059,5126,
 3885,3894,5023,3873,5133,5023,3896,3873,5094,5023,5137,5137,
 5071,5076,3895,3879,3894,3939,3938,3943,3939,3945,3984,3981,
 3980,3941,3984,3980,3976,2515,5023,5023,3898,5023,3898,5023,
 5116,5114,5023,3898,5023,5048,3898,5056,5049,5115,3916,3935,
 5023,3898,5119,5023,3928,3898,5053,5023,5118,5119,5055,5051,
 3932,3909,3929,3962,3969,3965,3961,3972,4001,3999,3998,3972,
 3999,4001,3998,5023,5023,3872,5023,3872,5023,5135,5131,5023,
 3872,5023,5107,3872,5110,5104,5130,3874,3876,5023,3872,5140,
 5023,3878,3872,5100,5023,5139,5143,5112,5088,3876,3874,3878,
 3936,3936,3936,3936,3936,3975,3975,3974,3936,3974,3975,3975,
 1648,1648,1648,1648,1648,1650,1683,1648,1648,1648,1649,1648,
 1649,1649,1683,1790,1837,1648,1648,1653,1648,1799,1648,1649,
 1648,1653,1653,1676,1676,1799,1790,1837,2017,1989,1989,2017,
 1989,2017,2037,2017,1989,2017,2017,2037,1648,1648,1648,1648,
 1706,1706,1648,1648,1648,1649,1648,1655,1723,1664,1813,1869,
 1648,1648,1653,1648,1799,1648,1649,1648,1653,1669,1715,1651,
 1799,1867,1817,2040,1993,2040,1993,1990,2036,2055,2032,1990,
 2032,2055,2036,1648,1648,1648,1736,1664,1648,392,1648,1649,392,
 1650,1692,1696,1815,1821,1648,1648,1654,1648,1799,1648,1649,
 1648,1654,1669,1651,1715,395,396,398,2002,2002,406,406,406,
 2039,2039,2037,1996,429,433,433,1648,1648,1683,1650,1648,1648,
 1648,1649,1648,1676,1676,1650,1838,1799,1648,1648,1653,1648,
 1799,1648,1649,1648,1653,1683,1649,1649,1799,1838,1799,1989,
 2017,2017,1989,1989,2037,2017,2017,1989,2017,2037,2017,1648,
 1664,1736,1648,1648,1648,1649,1648,1723,1656,1664,396,398,1648,
 392,1654,1648,395,392,1649,1648,1653,1701,1691,1650,1799,1815,
 1821,406,406,2002,2002,1996,433,433,429,406,2037,2039,2039,
 1668,1667,1648,1648,1648,1649,1648,1692,1650,1696,1867,1817,
 1648,1648,1654,1648,1799,1648,1649,1648,1653,1701,1650,1691,
 1799,1813,1869,1993,2040,1993,2040,1990,2055,2036,2032,1990,
 2032,2036,2055,1818,1664,1696,1650,1791,1650,1789,1651,1834,
 1985,1932,1650,1664,1793,1696,1921,1650,1791,1650,1826,1855,
 1827,1865,1910,2175,1946,2069,2126,2280,2142,2132,2130,2108,
 2095,2060,2144,2287,2167,1650,1650,1695,1790,1665,1872,1844,
 1836,1944,2173,1650,1650,1826,1650,1910,1695,1790,1665,1793,
 1835,1651,1789,1921,1930,1986,2280,2142,2069,2126,2062,2169,
 2288,2144,2132,2095,2110,2129,1648,1648,1723,1648,1715,1651,
 1650,1867,1799,1648,1648,1669,1648,1817,1648,1656,1648,1711,
 1711,1649,1649,1869,1813,1799,1990,2040,1993,1990,2040,2055,
 2032,2036,1993,2055,2036,2032,1648,1692,392,1651,1716,1650,
 1816,1799,1648,1648,1669,1648,1821,1648,1650,1648,1732,1669,
 1649,1649,398,396,395,1996,2002,406,406,406,2039,2037,2039,
 2002,433,433,429,1690,1648,1649,1649,1670,1790,1870,1648,1648,
 1675,1648,1822,1648,1652,1648,1702,1654,1694,1658,1870,1790,
 1822,2038,1989,1989,1992,2038,2018,2049,2029,1992,2049,2018,
 2029,1714,1859,1825,1865,1979,1927,1676,1657,1805,1650,1960,
 1652,1782,1659,1662,1843,1792,1825,2186,1914,1938,2065,2075,
 2136,2137,2299,2125,2105,2111,2079,2308,2152,2161,1649,1649,
 1737,1790,1823,1648,1648,1672,1648,1823,1648,1659,1648,1702,
 1654,1658,1694,399,393,399,1988,1987,406,406,406,2019,2030,
 2030,1988,431,428,431,1782,1791,2185,1943,1649,1691,1796,1650,
 1915,1649,1831,1649,1828,1662,1831,1792,1975,1967,1928,2141,
 2298,2098,2063,2078,2307,2166,2149,2133,2121,2118,2107,1791,
 1950,1980,1649,1650,1796,1691,1927,1649,1792,1649,1858,1805,
 1859,1825,1938,2184,1916,2075,2079,2299,2136,2137,2111,2125,
 2103,2064,2159,2308,2152,1919,1986,1650,1650,1819,1650,1932,
 1666,1827,1704,1835,1793,1789,1651,1946,1908,2173,2126,2060,
 2132,2280,2142,2095,2130,2110,2070,2169,2144,2287,403,1790,396,
 1909,1813,403,393,1942,1790,1929,2176,1913,1924,2114,2086,2114,
 407,409,2227,2257,2257,436,441,441,407,2303,2270,2303,1799,
 395,1940,1799,405,399,1915,1822,1922,1912,2183,1961,2115,2114,
 2086,410,408,2250,2221,2250,439,430,439,408,2278,2278,2226,
 1648,1683,1648,1838,1648,1676,1648,1683,1653,1649,1649,1838,
 1790,1799,1989,1989,1989,1989,2017,2017,2017,2037,2017,2037,
 2017,2017,1701,1648,398,392,1724,1648,1669,1732,1649,1649,1821,
 1815,1799,406,406,2002,1996,2002,433,429,433,406,2039,2039,
 2037,1701,2174,1731,1662,1713,1836,1829,1864,1843,1965,1920,
 1931,2139,2135,2059,2068,2077,2148,2160,2286,2281,2092,2097,
 2104,1869,1648,1692,1648,1671,1671,1649,1649,1817,1867,1799,
 1990,1993,2040,1990,1993,2036,2032,2055,2040,2036,2055,2032,
 399,2182,1870,1965,1940,1943,1980,2086,2114,2115,408,408,2250,
 2250,2223,438,437,429,410,2221,2277,2276,1690,1648,1671,1654,
 1726,1661,1823,1790,1823,406,406,1987,1988,1988,428,431,431,
 406,2030,2019,2030,1714,1807,1864,1831,1859,1972,1925,1975,
 2133,2141,2063,2078,2098,2166,2151,2307,2298,2118,2107,2122,
 1671,1654,1661,1726,1822,1790,1870,1992,1989,1989,2038,1992,
 2018,2029,2049,2038,2029,2018,2049,1818,1802,1802,2174,1939,
 1912,2059,2068,2138,2135,2281,2106,2093,2092,2082,2286,2162,
 2145,1796,1796,1931,1958,1922,2135,2281,2077,2059,2067,2286,
 2148,2162,2139,2106,2092,2097,1782,1928,1976,1974,2298,2133,
 2078,2098,2063,2149,2307,2168,2141,2109,2121,2118,1916,1937,
 2187,2079,2064,2137,2299,2136,2103,2111,2127,2076,2153,2159,
 2308,403,405,2250,2250,408,408,410,2277,2276,2221,2223,429,
 438,437,403,2257,2227,409,407,407,2270,2303,2303,2257,441,436,
 441,2221,2250,408,410,408,2278,2226,2278,2250,439,439,430,406,
 2334,2319,2334,447,448,447,406,2369,2369,2337,2319,2334,2334,
 448,447,447,406,2369,2337,2369,406,406,2337,2369,2369,2334,
 447,448,447,406,2369,2337,2369,2334,447,447,448,2369,2369,
 2337,2319,448,447,447,444,444,447,2354,2319,2354,443,447,2351,
 2354,2319,448,2319,2354,2351,2337,2369,2369,444,443,444,16,26,
 26,2453,2449,2436,2452,2436,2450,2454,2436,2454,2436,528,546,
 59,521,368,546,608,554,528,59,521,617,59,560,648,617,380,
 380,546,368,545,528,380,368,560,521,648,545,568,608,80,80,
 80,501,501,65,65,65,501,501,501,501,72,72,72,5,13,2515,
 2515,2515,2515,2515,2515,2515,2515,2515,2515,1648,1648,393,
 1648,392,1648,1656,1710,1648,393,1648,1650,393,1701,1650,1656,
 398,396,1648,392,1708,1648,396,392,1701,1648,1651,1708,1701,
 1650,402,404,402,434,434,411,411,411,406,406,406,434,440,440,
 440,19,2660,2664,2643,2659,2643,2645,2664,2643,2644,2642,1748,
 1753,450,1751,416,1753,1784,1887,1751,450,1751,1783,449,1886,
 1783,1785,421,421,1753,416,1898,1751,421,416,1885,1751,1783,
 1886,1898,1783,465,465,465,445,445,494,494,494,420,420,420,
 445,494,494,494,2661,2665,2643,2665,2643,2662,2661,2643,2662,
 2642,1753,1751,450,1751,416,1751,1783,1899,1753,450,1751,1788,
 449,1898,1786,1783,421,421,1748,416,1886,1753,421,416,1886,
 1751,1787,1885,1885,1787,465,465,465,420,420,494,494,494,445,
 445,445,420,494,494,494,2484,2438,2493,2438,2484,2493,2437,
 2484,2438,4165,4165,3024,4165,3792,4165,4373,4303,4165,3024,
 4165,4385,3017,4315,4386,4387,3798,3797,4165,3792,4315,4165,
 3798,3792,4314,4165,4385,4314,4311,4388,3121,3117,3120,3957,
 3951,3045,3084,3070,3955,3949,3955,3953,3070,3063,3061,2438,
 2484,2438,2493,2493,2438,2484,2437,4165,4165,3024,4165,3792,
 4165,4387,4299,4165,3024,4165,4386,3017,4311,4388,4384,3799,
 3799,4165,3792,4314,4165,3797,3792,4315,4165,4383,4316,4317,
 4374,3118,3120,3117,3951,3957,3084,3062,3045,3949,3957,3955,
 3951,3063,3061,3084,2438,2436,2438,2437,2436,2437,2436,4056,
 4056,2786,4056,3790,4056,4236,4075,4056,2786,4056,4234,2786,
 4081,4234,4234,3791,3791,4056,3790,4076,4056,3791,3790,4076,
 4056,4235,4079,4082,4236,2833,2833,2833,3871,3871,2786,2786,
 2786,3871,3871,3871,3871,2786,2786,2786,2438,2484,2484,2438,
 2493,2437,4165,4165,3024,4165,3792,4165,4384,4300,4165,3024,
 4165,4388,3017,4317,4374,4382,3797,3798,4165,3792,4316,4165,
 3794,3792,4311,4165,4374,4317,4316,4383,3119,3119,3121,3953,
 3951,3061,3063,3084,3957,3950,3949,3957,3061,3084,3045,2438,
 2438,2436,2438,2436,4056,4056,2786,4056,3790,4056,4234,4073,
 4056,2786,4056,4234,2786,4082,4236,4234,3791,3791,4056,3790,
 4079,4056,3791,3790,4081,4056,4234,4078,4078,4234,2833,2833,
 2833,3871,3871,2786,2786,2786,3871,3871,3871,3871,2786,2786,
 2786,2484,2437,2493,2438,4165,4165,3010,4165,3792,4165,4376,
 4297,4165,3010,4165,4378,3015,4308,4380,4377,3800,3800,4165,
 3792,4310,4165,3796,3792,4313,4165,4379,4313,4313,4372,3106,
 3107,3105,3954,3958,3067,3048,3035,3952,3956,3947,3954,3027,
 3048,3067,2438,2484,2438,4165,4165,3024,4165,3792,4165,4382,
 4302,4165,3024,4165,4374,3017,4316,4383,4381,3794,3797,4165,
 3792,4317,4165,3797,3792,4317,4165,4388,4311,4314,4385,3120,
 3118,3118,3953,3953,3063,3070,3061,3949,3955,3957,3951,3084,
 3045,3070,2438,2436,4056,4056,2786,4056,3790,4056,4234,4074,
 4056,2786,4056,4236,2786,4078,4234,4235,3791,3791,4056,3790,
 4078,4056,3791,3790,4082,4056,4236,4082,4079,4235,2833,2833,
 2833,3871,3871,2786,2786,2786,3871,3871,3871,3871,2786,2786,
 2786,2438,4165,4165,3010,4165,3792,4165,4377,4298,4165,3010,
 4165,4380,3015,4313,4372,4375,3795,3801,4165,3792,4313,4165,
 3793,3792,4308,4165,4372,4313,4313,4379,3106,3106,3108,3948,
 3954,3048,3027,3067,3956,3952,3952,3958,3048,3067,3035,4056,
 4056,2786,4056,3790,4056,4236,4132,4056,2786,4056,4236,2786,
 4151,4235,4234,3791,3791,4056,3790,4150,4056,3791,3790,4149,
 4056,4234,4152,4152,4234,2833,2833,2833,3870,3870,2786,2786,
 2786,3870,3870,3870,3870,2786,2786,2786,575,520,575,519,519,
 715,682,575,519,575,715,520,591,714,591,1191,1204,575,519,
 592,575,1189,519,620,519,714,580,601,583,1069,1069,1028,2046,
 2005,714,1055,714,1999,2046,2005,1999,714,714,1055,520,519,
 519,575,577,593,575,520,575,714,519,592,591,714,1189,1204,
 575,519,591,519,1191,519,580,575,715,620,690,715,1069,1028,
 1069,2046,1999,1055,714,714,2005,2046,1999,2005,714,1055,714,
 520,518,520,620,520,519,31,519,575,31,524,593,593,1188,1188,
 519,518,524,520,1188,518,524,520,575,524,524,620,32,33,33,
 2000,2000,31,31,31,2000,2000,2000,2000,31,31,31,519,575,591,
 576,575,520,575,714,519,602,583,714,1204,1189,575,519,580,
 519,1189,519,591,575,715,690,620,715,1069,1028,1069,1999,2046,
 1055,714,714,2046,2005,1999,2005,714,1055,714,519,575,565,519,
 518,519,575,518,524,575,575,367,367,519,366,550,519,367,366,
 550,519,575,570,570,575,996,996,996,386,386,575,575,575,386,
 386,386,386,575,575,575,715,604,575,519,575,715,520,601,714,
 583,1204,1191,575,519,580,575,1191,519,638,519,714,602,580,
 583,1069,1069,1028,2005,2046,714,1055,714,2046,1999,2005,1999,
 714,714,1055,715,714,593,714,892,575,737,731,898,1302,1290,
 714,575,721,583,1288,575,730,715,898,850,776,937,1182,1331,
 1195,2072,2091,1377,898,892,2089,2073,2074,2072,892,1377,898,
 576,520,593,715,520,713,731,847,1332,1471,577,538,589,577,
 1303,569,643,623,716,684,541,777,1071,1071,1099,2302,2172,716,
 803,716,2172,2302,2158,2157,731,731,830,520,519,592,520,690,
 715,715,1204,1191,519,519,620,575,1191,519,592,575,583,601,
 580,714,1028,1069,1069,2005,2046,714,714,1055,2046,1999,2005,
 1999,1055,714,714,520,593,31,524,620,575,1188,1188,520,518,
 524,520,1188,518,524,519,620,524,524,575,33,33,32,2000,2000,
 31,31,31,2000,2000,2000,2000,31,31,31,577,520,638,715,715,
 1191,1204,519,519,638,575,1189,519,580,575,582,580,601,714,
 1028,1069,1069,2046,2005,714,714,1055,1999,2046,2005,1999,1055,
 714,714,620,850,898,937,1302,1288,583,575,776,714,1289,575,
 730,715,575,737,721,898,1331,1182,1195,2073,2089,892,898,1377,
 2091,2072,2072,2074,1377,892,898,524,575,620,1188,1188,520,
 518,524,519,1188,518,524,520,593,524,524,593,33,32,33,1994,
 1994,31,31,31,1994,1994,1994,1994,31,31,31,730,730,1473,1301,
 620,570,654,580,1294,553,690,580,776,701,690,721,1100,1072,
 1072,2155,2301,729,729,811,2301,2155,2163,2163,837,735,735,
 892,1288,1302,715,575,730,583,1288,575,721,714,937,776,850,
 898,1195,1331,1182,2089,2074,1377,892,898,2072,2091,2071,2074,
 898,1377,892,1289,1302,715,575,730,714,1289,575,776,583,898,
 721,736,731,1195,1182,1331,2091,2072,892,1377,898,2074,2089,
 2074,2071,898,892,1377,367,1191,367,1294,1189,367,367,1301,
 1191,1289,1473,1294,1290,1492,1492,1492,389,391,1545,1545,1545,
 391,388,389,388,1545,1545,1545,1189,367,1301,1191,367,367,
 1294,1189,1290,1294,1472,1289,1492,1492,1492,391,389,1545,1545,
 1545,388,391,389,388,1545,1545,1545,519,690,575,1204,519,602,
 575,591,592,591,714,1028,1069,1069,2005,1999,714,714,1055,
 2005,1999,2046,2046,1055,714,714,570,519,367,366,524,519,575,
 524,550,575,996,996,996,386,386,575,575,575,386,386,386,386,
 575,575,575,601,1473,574,700,601,850,689,656,736,1100,1072,
 1072,2155,2163,734,734,837,2163,2155,2301,2300,810,728,728,
 1204,519,601,575,715,638,638,715,1069,1028,1069,1999,2005,
 1055,714,714,1999,2005,2046,2046,714,1055,714,367,1473,1204,
 1302,1301,1301,1302,1492,1492,1492,389,388,1545,1545,1545,389,
 388,390,390,1545,1545,1545,571,519,575,553,574,575,996,996,
 996,386,386,575,575,575,386,386,386,386,575,575,575,690,736,
 614,690,850,1072,1072,1100,2163,2155,729,810,728,2155,2163,
 2301,2301,734,734,837,714,591,591,591,1069,1069,1028,2004,
 1999,714,1055,714,2004,1999,2046,2046,714,714,1055,730,730,
 892,1331,1195,1182,2073,2073,898,892,1377,2072,2071,2090,2089,
 1377,898,892,654,730,1072,1100,1072,2163,2300,837,734,734,
 2301,2163,2155,2155,728,810,728,730,1072,1100,1072,2301,2163,
 810,728,728,2163,2301,2155,2154,734,837,734,1182,1195,1331,
 2074,2074,898,1377,892,2071,2072,2090,2089,892,898,1377,54,54,
 2258,2258,32,32,46,2258,2258,2258,2258,46,32,32,54,2258,2258,
 46,32,32,2258,2258,2258,2258,32,46,32,2258,2258,32,46,32,
 2258,2258,2258,2258,32,32,46,386,2368,2368,2368,392,392,392,
 386,2368,2368,2368,2368,2368,2368,392,392,392,386,2368,2368,
 2368,31,31,2368,2368,2368,2368,31,31,31,31,2368,2368,2368,
 2368,31,31,31,2368,2368,2368,2368,31,31,31,386,386,392,2368,
 2368,2368,386,392,2368,2368,2368,392,2368,2368,2368,2368,2368,
 2368,31,31,31,27,25,2691,2684,2697,2687,2694,2682,2692,2700,
 2686,2669,1775,1772,418,1773,456,1768,1892,1851,1770,419,1774,
 1895,417,1852,1903,1890,460,469,1776,456,1832,1768,469,454,
 1841,1775,1903,1846,1840,1891,425,423,426,489,476,446,446,446,
 493,496,496,489,432,435,427,30,2773,2773,2782,2772,2781,2779,
 2771,2785,2777,2769,1933,1964,474,1933,474,1964,2013,2013,1954,
 474,1935,2023,472,2012,2008,2021,502,481,1933,474,2008,1954,
 476,472,2023,1935,2008,2021,2027,2021,476,502,481,513,513,513,
 513,512,495,480,476,512,476,495,480,2774,2776,2783,2776,2780,
 2778,2774,2783,2778,2768,1955,1934,473,1952,473,1936,2022,2025,
 1934,473,1952,2015,471,2024,2024,2011,488,504,1955,473,2011,
 1936,504,471,2014,1952,2025,2022,2015,2014,504,488,504,486,
 497,515,515,515,515,515,515,482,486,497,482,2488,2469,2494,
 2473,2489,2497,2441,2492,2474,4191,4219,3184,4191,3819,4221,
 4409,4347,4183,3183,4214,4395,3177,4340,4445,4412,3855,3834,
 4225,3818,4291,4202,3842,3823,4342,4206,4420,4323,4349,4433,
 3267,3257,3260,4018,4038,3192,3210,3199,4032,4013,4015,4010,
 3233,3213,3221,2478,2487,2457,2494,2494,2467,2489,2447,4174,
 4223,3186,4181,3813,4229,4397,4334,4195,3187,4190,4402,3165,
 4336,4422,4435,3856,3835,4218,3811,4293,4180,3843,3827,4339,
 4207,4421,4322,4350,4405,3250,3265,3266,4017,4041,3209,3194,
 3194,4033,4014,4016,4012,3224,3228,3227,2467,2436,2460,2441,
 2436,2445,2436,4100,4140,2954,4113,3792,4140,4268,4092,4100,
 2954,4109,4254,2954,4084,4278,4257,3868,3866,4140,3792,4065,
 4105,3865,3792,4090,4112,4283,4066,4138,4270,3104,3099,3101,
 4049,4051,2957,2956,2958,4052,4051,4054,4052,2975,2977,2978,
 2457,2490,2488,2478,2494,2447,4196,4218,3188,4195,3811,4220,
 4402,4339,4182,3187,4180,4397,3167,4344,4444,4413,3858,3836,
 4223,3813,4292,4190,3846,3827,4334,4198,4417,4326,4353,4438,
 3249,3263,3274,4016,4033,3194,3204,3209,4041,4012,4017,4014,
 3214,3222,3232,2470,2473,2436,2470,2436,4096,4139,2954,4094,
 3792,4139,4253,4088,4094,2954,4098,4253,2954,4093,4281,4252,
 3864,3869,4139,3792,4061,4097,3862,3792,4088,4095,4277,4062,
 4135,4251,3093,3096,3097,4044,4043,2956,2960,2956,4043,4043,
 4044,4043,2971,2972,2972,2491,2445,2497,2477,4185,4222,3171,
 4201,3815,4226,4401,4332,4177,3179,4192,4428,3185,4329,4443,
 4389,3829,3850,4231,3814,4294,4179,3852,3809,4335,4187,4443,
 4312,4351,4399,3275,3271,3247,4039,4008,3210,3200,3203,4007,
 4042,4037,4031,3221,3234,3216,2469,2489,2474,4175,4225,3184,
 4183,3818,4230,4395,4342,4191,3182,4202,4409,3175,4346,4425,
 4434,3851,3833,4219,3819,4291,4214,3844,3823,4347,4210,4419,
 4320,4354,4414,3248,3276,3270,4015,4032,3199,3203,3192,4038,
 4010,4018,4013,3223,3215,3217,2460,2436,4103,4140,2954,4100,
 3792,4140,4254,4090,4113,2954,4105,4268,2954,4086,4279,4267,
 3867,3866,4140,3792,4063,4109,3867,3792,4091,4111,4285,4072,
 4136,4260,3104,3094,3103,4054,4052,2958,2964,2957,4051,4052,
 4049,4051,2973,2978,2977,2476,4186,4231,3174,4177,3814,4227,
 4428,4335,4201,3179,4179,4401,3183,4333,4423,4408,3832,3847,
 4222,3815,4294,4191,3849,3809,4332,4216,4423,4309,4352,4411,
 3268,3260,3254,4037,4007,3203,3192,3210,4008,4031,4039,4042,
 3217,3226,3229,4115,4145,2953,4120,3792,4145,4271,4128,4119,
 2953,4118,4271,2953,4130,4286,4265,3837,3838,4145,3792,4057,
 4117,3838,3792,4128,4116,4284,4059,4147,4262,3089,3087,3088,
 4002,4003,2953,2953,2953,4003,4003,4002,4003,2966,2967,2967,
 621,558,621,527,535,843,709,595,520,593,815,555,575,786,661,
 1237,1258,597,521,576,595,1210,520,659,520,766,584,665,660,
 1087,1089,1050,2216,2203,765,1064,756,2194,2210,2188,2196,773,
 804,1061,566,535,546,621,600,586,597,566,621,762,525,620,694,
 767,1213,1222,621,524,591,539,1218,548,597,597,838,621,647,
 817,1088,1038,1088,2188,2191,1059,760,760,2197,2206,2197,2189,
 788,1051,788,558,518,566,709,533,520,54,520,593,54,529,706,
 698,1233,1233,524,518,519,555,1215,518,520,555,614,519,542,
 707,75,78,78,2205,2205,54,54,54,2205,2205,2199,2199,63,67,
 67,527,621,661,575,593,555,595,756,520,671,680,775,1261,1229,
 597,520,577,520,1210,522,593,595,820,686,576,828,1087,1049,
 1089,2203,2216,1064,765,756,2211,2193,2188,2196,773,1062,805,
 546,616,560,520,518,520,593,518,560,648,616,379,379,524,368,
 519,521,376,368,520,521,614,531,556,608,1032,1034,1034,498,
 498,618,618,593,498,498,491,492,615,649,649,824,670,621,524,
 597,824,566,586,772,600,1210,1218,621,546,580,597,1218,524,
 670,535,772,644,610,674,1088,1088,1039,2191,2188,760,1059,760,
 2206,2197,2197,2191,788,788,1047,724,756,696,765,926,593,842,
 865,974,1364,1390,762,593,738,658,1333,612,756,815,971,870,
 758,985,1197,1385,1252,2292,2269,1408,969,926,2279,2271,2228,
 2242,937,1412,979,593,522,658,756,520,711,751,879,1344,1480,
 597,520,593,575,1295,555,593,659,772,630,530,861,1093,1085,
 1148,2315,2284,884,864,756,2256,2312,2222,2233,822,889,878,
 555,520,661,559,702,820,828,1258,1217,535,527,576,595,1237,
 522,575,621,673,617,609,775,1049,1087,1089,2188,2211,756,765,
 1064,2216,2196,2203,2193,1061,774,804,559,696,54,520,713,593,
 1215,1233,566,518,519,559,1233,518,522,520,713,519,544,593,
 78,78,75,2205,2199,54,54,54,2199,2205,2205,2205,67,67,63,
 658,555,657,849,814,1217,1257,539,521,576,621,1229,534,575,
 595,683,577,681,758,1050,1089,1087,2216,2196,765,756,1064,
 2188,2211,2194,2203,1060,805,774,709,875,971,985,1372,1321,
 601,617,731,765,1383,612,725,843,633,772,770,974,1386,1197,
 1252,2228,2279,926,969,1408,2269,2242,2292,2271,1402,937,979,
 532,614,707,1231,1211,566,518,519,520,1231,518,533,559,706,
 519,521,698,78,75,78,2192,2195,54,54,54,2195,2192,2195,2195,
 67,63,67,786,725,1485,1340,663,554,576,595,1298,520,676,575,
 858,668,665,718,1146,1096,1084,2282,2317,765,883,859,2314,
 2252,2224,2239,874,848,886,937,1334,1382,838,614,752,673,1329,
 652,772,766,988,836,854,971,1251,1379,1198,2291,2230,1401,931,
 970,2244,2267,2237,2249,980,1396,946,1384,1370,817,608,731,
 758,1335,593,862,657,971,743,816,857,1250,1200,1394,2265,2294,
 929,1409,967,2273,2275,2248,2236,977,949,1405,384,1218,379,
 1295,1210,384,375,1343,1237,1334,1484,1295,1392,1553,1548,1516,
 508,476,1562,1547,1562,503,511,511,508,1551,1552,1493,1213,
 376,1337,1237,383,377,1297,1210,1330,1299,1470,1327,1549,1506,
 1548,503,511,1546,1562,1562,505,484,508,511,1550,1509,1551,
 546,620,621,1210,548,587,621,614,591,638,767,1037,1088,1088,
 2197,2197,761,761,1059,2191,2189,2188,2206,1047,788,788,521,
 520,379,368,560,528,648,546,521,617,1034,1032,1034,492,498,
 593,618,618,498,492,498,498,649,615,649,617,1469,524,596,594,
 772,576,691,757,1087,1091,1087,2251,2222,773,757,757,2222,
 2251,2309,2309,740,753,740,1261,534,658,593,849,594,576,814,
 1089,1050,1087,2194,2188,1064,756,765,2196,2203,2216,2211,805,
 1062,774,377,1482,1258,1380,1338,1342,1363,1493,1553,1549,511,
 511,1562,1562,1547,508,505,476,503,1493,1552,1551,555,520,652,
 519,573,593,1035,1035,1032,487,479,612,593,612,479,487,487,
 487,655,655,615,709,748,677,664,879,1085,1094,1148,2222,2256,
 756,864,884,2284,2233,2315,2312,887,822,878,786,578,594,666,
 1089,1087,1050,2196,2203,756,1064,765,2193,2190,2211,2216,805,
 774,1061,752,812,937,1353,1251,1198,2249,2230,970,930,1400,
 2244,2238,2266,2290,1374,980,946,590,745,1091,1142,1090,2241,
 2318,863,771,773,2318,2241,2259,2259,753,853,754,764,1097,
 1139,1095,2310,2222,890,759,779,2234,2311,2283,2254,852,891,
 835,1200,1250,1387,2240,2295,967,1409,929,2274,2245,2285,2260,
 949,977,1407,87,87,2376,2376,75,75,79,2359,2355,2319,2353,82,
 81,81,87,2329,2355,79,75,75,2376,2353,2376,2359,81,84,81,
 2376,2353,75,79,75,2324,2359,2359,2376,81,81,83,510,2425,
 2427,2427,517,514,517,506,2358,2338,2357,2427,2425,2427,514,
 517,517,510,2358,2372,2319,54,54,2427,2425,2427,2427,63,66,
 63,54,2424,2427,2427,2427,63,63,66,2427,2427,2425,2425,66,63,
 63,510,510,517,2357,2372,2326,506,517,2356,2336,2358,514,2319,
 2372,2358,2326,2372,2357,73,73,73,21,2657,2656,2650,2653,2652,
 2654,2658,2649,2653,2642,1747,1746,451,1747,449,1746,1791,1876,
 1744,452,1749,1791,449,1876,1801,1795,458,459,1752,449,1883,
 1744,459,449,1876,1747,1801,1877,1879,1798,467,461,464,475,
 475,477,476,477,455,455,455,475,500,500,499,2692,2687,2700,
 2684,2694,2686,2691,2697,2682,2669,1776,1770,457,1773,419,1769,
 1846,1903,1772,457,1774,1840,454,1903,1852,1832,423,425,1775,
 418,1890,1768,426,417,1891,1775,1851,1892,1895,1841,469,460,
 469,432,435,493,496,496,446,446,446,427,489,476,489,2515,
 2515,2515,2515,2515,2515,2515,2515,2515,5023,5023,3898,5023,
 3898,5023,5080,5090,5023,3898,5023,5061,3898,5062,5085,5101,
 3933,3915,5023,3898,5082,5023,3917,3898,5061,5023,5070,5084,
 5066,5087,3913,3927,3915,4001,3993,3962,3972,3967,3966,3960,
 3967,3997,3997,4000,3996,2515,2515,2515,2515,2515,2515,2515,
 2515,5023,5023,3898,5023,3898,5023,5101,5063,5023,3898,5023,
 5085,3898,5066,5087,5102,3930,3912,5023,3898,5084,5023,3913,
 3898,5062,5023,5064,5102,5087,5066,3917,3931,3906,3996,4001,
 3972,3960,3962,3960,3972,3966,3993,4000,3996,4001,2515,2515,
 2515,2515,2515,2515,2515,5023,5023,3873,5023,3873,5023,5091,
 5106,5023,3873,5023,5078,3873,5079,5083,5067,3892,3884,5023,
 3873,5086,5023,3889,3873,5098,5023,5097,5068,5099,5099,3889,
 3897,3890,3982,3977,3937,3942,3940,3946,3942,3944,3979,3983,
 3985,3982,2515,2515,2515,2515,2515,2515,5023,5023,3898,5023,
 3898,5023,5102,5064,5023,3898,5023,5087,3898,5087,5066,5084,
 3931,3917,5023,3898,5102,5023,3906,3898,5066,5023,5063,5101,
 5085,5062,3912,3930,3913,4000,3996,3960,3966,3972,3972,3962,
 3960,4001,3996,4001,3993,2515,2515,2515,2515,2515,5023,5023,
 3873,5023,3873,5023,5067,5081,5023,3873,5023,5083,3873,5099,
 5099,5068,3896,3881,5023,3873,5068,5023,3888,3873,5079,5023,
 5081,5067,5083,5079,3881,3896,3888,3985,3982,3942,3946,3937,
 3942,3937,3946,3977,3985,3982,3977,2515,2515,2515,2515,5023,
 5023,3898,5023,3898,5023,5024,5024,5023,3898,5023,5024,3898,
 5024,5024,5024,3923,3900,5023,3898,5024,5023,3911,3898,5024,
 5023,5024,5024,5024,5024,3903,3918,3899,3986,3987,3971,3968,
 3964,3968,3971,3959,3986,3986,3986,3987,2515,2515,2515,5023,
 5023,3898,5023,3898,5023,5084,5069,5023,3898,5023,5065,3898,
 5085,5062,5082,3927,3913,5023,3898,5101,5023,3915,3898,5087,
 5023,5090,5080,5061,5061,3915,3933,3917,3997,4000,3966,3967,
 3960,3962,3967,3972,3996,4001,3993,3997,2515,2515,5023,5023,
 3873,5023,3873,5023,5068,5097,5023,3873,5023,5099,3873,5083,
 5079,5086,3897,3889,5023,3873,5067,5023,3890,3873,5099,5023,
 5106,5091,5078,5098,3884,3892,3889,3983,3985,3946,3944,3942,
 3937,3940,3942,3982,3982,3977,3979,2515,5023,5023,3898,5023,
 3898,5023,5024,5024,5023,3898,5023,5024,3898,5024,5024,5024,
 3918,3903,5023,3898,5024,5023,3899,3898,5024,5023,5024,5024,
 5024,5024,3900,3922,3911,3986,3986,3968,3959,3971,3971,3964,
 3968,3987,3986,3987,3986,5023,5023,3872,5023,3872,5023,5096,
 5093,5023,3872,5023,5109,3872,5108,5108,5073,3875,3874,5023,
 3872,5073,5023,3874,3872,5095,5023,5093,5096,5109,5095,3874,
 3875,3874,3973,3973,3936,3936,3936,3936,3936,3936,3973,3973,
 3973,3973,1648,1648,1648,1648,1648,1649,1721,1648,1648,1648,
 1656,1648,1656,1649,1728,1817,1867,1648,1648,1649,1648,1790,
 1648,1649,1648,1650,1650,1689,1689,1813,1799,1867,2055,2036,
 1990,2040,1993,1993,2040,1990,2032,2036,2032,2055,1648,1648,
 1648,1648,1689,1689,1648,1648,1648,1651,1648,1649,1719,1649,
 1799,1866,1648,1648,1660,1648,1814,1648,1651,1648,1663,1649,
 1719,1649,1814,1870,1790,2049,2018,2038,1989,1992,1989,2038,
 1992,2029,2029,2049,2018,1648,1648,1648,1721,1649,1648,392,
 1648,1649,392,1650,1689,1689,1821,1790,1648,1648,1650,1648,
 1816,1648,1651,1648,1649,1656,1649,1728,393,398,396,2037,2039,
 406,406,406,2002,1996,2002,2039,429,433,433,1648,1648,1728,
 1649,1648,1648,1648,1649,1648,1689,1689,1650,1869,1790,1648,
 1648,1650,1648,1813,1648,1656,1648,1649,1728,1649,1656,1790,
 1869,1813,2032,2055,2040,1993,1990,2040,1990,1993,2036,2032,
 2055,2036,1648,1649,1728,1648,1648,1648,1651,1648,1728,1649,
 1656,398,396,1648,392,1649,1648,393,392,1649,1648,1650,1689,
 1689,1650,1816,1799,1816,433,433,1996,2002,2002,406,406,406,
 429,2039,2037,2039,1649,1649,1648,1648,1648,1649,1648,1676,
 1649,1676,1838,1790,1648,1648,1649,1648,1790,1648,1649,1648,
 1649,1676,1649,1676,1790,1799,1838,2017,2037,1989,2017,1989,
 2017,1989,1989,2017,2017,2017,2037,1789,1649,1689,1649,1789,
 1649,1830,1649,1824,1982,1917,1650,1656,1782,1676,1951,1651,
 1782,1651,1830,1875,1824,1871,1905,2181,1941,2096,2128,2297,
 2140,2132,2081,2058,2080,2112,2144,2306,2164,1663,1650,1676,
 1782,1660,1875,1824,1871,1948,2179,1650,1649,1824,1649,1905,
 1689,1789,1649,1782,1830,1649,1824,1969,1918,1978,2305,2171,
 2057,2084,2101,2143,2296,2131,2144,2119,2094,2124,1648,1648,
 1719,1648,1719,1649,1660,1870,1814,1648,1648,1649,1648,1790,
 1648,1649,1648,1689,1689,1651,1651,1866,1799,1814,2029,2049,
 1989,1992,2038,2038,1992,1989,2018,2049,2018,2029,1648,1689,
 392,1649,1728,1649,1799,1816,1648,1648,1656,1648,1815,1648,
 1650,1648,1728,1649,1651,1649,396,398,393,2039,2037,406,406,
 406,1996,2002,2002,2039,433,433,429,1676,1648,1649,1649,1649,
 1799,1845,1648,1648,1649,1648,1790,1648,1649,1648,1676,1649,
 1676,1649,1845,1799,1790,2048,2032,1991,1991,2028,1991,2028,
 1991,2032,2048,2032,2032,1729,1861,1830,1871,1977,1969,1689,
 1649,1830,1649,1917,1651,1789,1649,1649,1824,1782,1830,2180,
 1906,1947,2117,2124,2131,2143,2296,2084,2100,2057,2094,2304,
 2144,2171,1660,1649,1719,1823,1820,1648,1648,1649,1648,1790,
 1648,1649,1648,1689,1651,1651,1689,394,395,394,2030,2030,406,
 406,406,1988,1988,1987,2019,431,428,431,1789,1782,2177,1947,
 1649,1689,1789,1649,1905,1649,1830,1650,1824,1649,1830,1782,
 1978,1918,1970,2170,2304,2057,2101,2084,2296,2143,2131,2144,
 2124,2094,2119,1789,1918,1978,1656,1650,1782,1676,1970,1660,
 1782,1650,1875,1830,1861,1830,1947,2177,1905,2124,2094,2296,
 2131,2143,2057,2084,2101,2119,2170,2304,2144,1962,1981,1649,
 1650,1789,1649,1917,1649,1824,1689,1824,1782,1830,1649,1941,
 1906,2178,2128,2112,2132,2297,2140,2080,2081,2057,2092,2165,
 2144,2306,403,1799,398,1907,1799,403,395,1949,1817,1918,2181,
 1906,1973,2114,2115,2088,438,429,2250,2223,2250,410,408,408,
 438,2276,2277,2221,1813,393,1941,1790,400,394,1905,1790,1969,
 1905,2180,1917,2087,2114,2113,436,441,2257,2257,2227,407,409,
 407,441,2261,2303,2303,1648,1728,1648,1867,1648,1689,1648,1721,
 1649,1656,1649,1867,1817,1790,2036,2032,1993,1990,2040,1990,
 1993,2040,2055,2055,2036,2032,1689,1648,396,392,1728,1648,1649,
 1721,1649,1651,1790,1821,1816,429,433,2002,2002,1996,406,406,
 406,433,2037,2039,2039,1676,2178,1719,1649,1689,1871,1824,1871,
 1824,1981,1962,1917,2165,2144,2080,2057,2081,2132,2140,2297,
 2306,2128,2112,2092,1838,1648,1676,1648,1649,1649,1649,1649,
 1790,1838,1790,2017,2017,2017,1989,1989,1989,1989,2017,2037,
 2017,2037,2017,394,2180,1867,1978,1941,1947,1978,2113,2088,
 2113,441,441,2225,2257,2257,407,407,409,436,2303,2270,2303,
 1689,1648,1660,1649,1729,1649,1820,1823,1790,431,428,1988,1987,
 1988,406,406,406,431,2030,2030,2019,1721,1824,1871,1830,1861,
 1917,1973,1978,2146,2170,2101,2084,2057,2143,2131,2296,2304,
 2094,2119,2123,1649,1651,1649,1721,1790,1817,1867,2032,2036,
 1993,2040,1990,1993,1990,2040,2055,2032,2036,2055,1789,1782,
 1789,2179,1948,1905,2119,2094,2143,2131,2296,2057,2101,2084,
 2124,2305,2171,2144,1789,1782,1917,1982,1951,2144,2306,2081,
 2080,2058,2297,2132,2140,2164,2096,2128,2112,1789,1969,1977,
 1917,2304,2144,2084,2057,2100,2131,2296,2143,2171,2117,2124,
 2094,1905,1948,2180,2094,2119,2143,2296,2131,2101,2057,2084,
 2123,2146,2170,2304,403,400,2261,2303,407,407,409,2257,2227,
 2257,2303,436,441,441,403,2276,2277,410,408,408,2250,2250,
 2223,2221,438,429,438,2303,2270,407,409,407,2225,2257,2257,
 2303,441,441,436,444,2369,2369,2335,447,448,447,443,2328,2351,
 2354,2369,2337,2369,448,447,447,444,2351,2354,2319,406,406,
 2334,2334,2323,2337,447,448,447,406,2323,2334,2334,2369,447,
 447,448,2334,2323,2334,2369,448,447,447,406,406,447,2369,2369,
 2337,406,447,2335,2369,2369,448,2369,2337,2369,2354,2319,2354,
 444,443,444,2483,2483,2436,2480,2436,2483,2482,2436,2481,2436,
 561,561,368,554,85,561,526,699,561,368,554,549,368,699,526,
 526,88,88,561,85,699,561,88,85,695,554,521,695,699,526,382,
 382,382,86,86,516,516,516,86,86,86,86,516,516,516,2488,2478,
 2496,2463,2489,2494,2443,2486,2466,4181,4223,3812,4174,3186,
 4229,4334,4397,4196,3810,4193,4324,3828,4431,4292,4344,3273,
 3264,4218,3188,4421,4203,3250,3166,4439,4208,4293,4407,4416,
 4326,3843,3846,3858,3209,3194,4017,4041,4020,3219,3214,3224,
 3202,4016,4019,4026,2469,2490,2464,2495,2497,2479,2488,2448,
 4191,4219,3819,4191,3184,4221,4347,4409,4175,3821,4204,4325,
 3825,4396,4291,4346,3269,3259,4225,3184,4420,4212,3267,3173,
 4392,4188,4291,4432,4418,4320,3842,3844,3851,3192,3210,4018,
 4038,4021,3220,3223,3233,3196,4015,4022,4030,2455,2436,2465,
 2441,2436,2439,2436,4114,4140,3792,4100,2954,4140,4092,4268,
 4103,3792,4104,4069,3792,4259,4063,4086,3094,3103,4140,2954,
 4283,4110,3104,2954,4264,4111,4065,4254,4285,4072,3865,3867,
 3867,2957,2956,4049,4051,4053,2980,2973,2975,2959,4054,4053,
 4049,2458,2485,2490,2458,2497,2442,4171,4192,3805,4168,3180,
 4217,4330,4394,4168,3803,4172,4319,3807,4430,4289,4331,3251,
 3261,4191,3180,4415,4172,3245,3164,4429,4170,4289,4430,4415,
 4318,3845,3845,3853,3197,3191,4016,4040,4023,3235,3211,3211,
 3207,4016,4023,4024,2472,2479,2436,2459,2436,4099,4142,3792,
 4107,2954,4144,4083,4258,4099,3792,4100,4064,3792,4269,4068,
 4085,3098,3095,4143,2954,4280,4101,3104,2954,4255,4106,4062,
 4256,4282,4064,3863,3861,3859,2961,2955,4045,4047,4046,2979,
 2976,2974,2957,4048,4046,4045,2492,2440,2496,2471,4189,4218,
 3816,4194,3170,4224,4337,4393,4213,3817,4197,4306,3808,4390,
 4296,4338,3256,3258,4228,3169,4442,4174,3262,3190,4403,4200,
 4296,4410,4424,4307,3848,3854,3830,3205,3208,4035,4006,4025,
 3212,3225,3231,3201,4036,4028,4011,2464,2488,2462,4184,4225,
 3818,4176,3184,4230,4343,4395,4192,3822,4212,4321,3825,4432,
 4291,4340,3252,3272,4219,3184,4419,4205,3248,3173,4437,4211,
 4291,4396,4420,4323,3844,3842,3855,3199,3203,4015,4032,4022,
 3220,3233,3223,3195,4018,4021,4027,2459,2436,4102,4143,3792,
 4099,2954,4141,4087,4263,4107,3792,4101,4071,3792,4256,4062,
 4089,3100,3102,4142,2954,4282,4100,3104,2954,4261,4108,4067,
 4269,4280,4070,3861,3863,3860,2963,2962,4048,4050,4046,2979,
 2974,2976,2957,4045,4046,4048,2456,4167,4217,3804,4173,3163,
 4209,4327,4427,4173,3806,4169,4304,3802,4391,4290,4328,3255,
 3253,4217,3163,4441,4169,3246,3181,4426,4166,4290,4391,4441,
 4305,3857,3857,3831,3191,3198,4034,4006,4029,3230,3218,3218,
 3206,4034,4029,4009,4123,4146,3792,4125,2953,4146,4134,4272,
 4122,3792,4127,4060,3792,4275,4058,4131,3091,3090,4146,2953,
 4287,4121,3092,2953,4273,4126,4057,4276,4288,4057,3839,3841,
 3840,2953,2953,4004,4004,4005,2970,2969,2968,2953,4004,4005,
 4004,535,528,621,559,621,575,661,595,521,520,576,520,828,576,
 702,1089,1050,598,520,820,595,1087,555,756,593,577,775,673,
 617,1210,1237,1258,1064,765,2203,2216,2196,805,1061,774,756,
 2188,2194,2210,547,621,566,621,587,600,598,546,535,581,525,
 817,620,663,1088,1039,621,525,838,621,1088,566,762,598,592,
 767,614,591,1218,1210,1218,1059,761,2188,2191,2191,788,1047,
 788,761,2197,2206,2197,528,518,546,560,617,521,368,521,519,
 368,608,521,554,1034,1034,525,518,614,520,1032,518,593,520,
 519,617,648,545,376,379,379,619,618,498,498,492,649,649,615,
 593,492,498,498,559,536,709,843,520,520,595,608,522,657,594,
 575,1049,1089,598,555,766,593,1087,520,815,595,576,666,786,
 578,1210,1261,1229,765,1064,2216,2203,2196,1062,805,774,756,
 2188,2211,2193,566,533,709,555,518,555,519,518,707,519,532,
 78,78,525,54,614,520,75,54,593,520,519,698,706,519,1215,
 1233,1233,54,54,2205,2205,2199,67,67,63,54,2199,2205,2205,
 670,825,539,525,598,638,548,606,581,588,1038,1088,621,566,
 772,598,1088,525,825,621,581,674,772,644,1218,1213,1222,761,
 1059,2191,2188,2189,1051,788,788,761,2197,2197,2206,725,659,
 554,575,576,520,862,596,676,1148,1086,598,520,772,658,1094,
 522,756,593,593,879,748,677,1295,1482,1343,884,864,2315,2284,
 2233,878,887,821,756,2222,2313,2255,815,608,657,731,593,985,
 731,876,1252,1393,762,593,971,765,1197,696,926,756,738,974,
 633,772,1333,1383,1372,1408,969,2292,2269,2229,979,1402,937,
 926,2228,2293,2264,520,593,693,534,666,576,575,1050,1087,621,
 559,786,595,1089,520,843,621,594,657,766,584,1261,1210,1237,
 756,1064,2188,2194,2211,1062,774,805,765,2216,2196,2203,528,
 521,368,593,545,520,1032,1034,546,518,648,528,1034,518,608,
 521,545,593,648,519,379,379,376,618,593,498,492,498,615,649,
 649,619,498,498,492,594,520,814,576,657,1087,1050,621,520,
 849,621,1089,559,765,595,617,758,673,577,1258,1237,1210,1064,
 756,2203,2196,2216,774,1061,805,765,2211,2193,2190,523,873,
 576,692,1144,1087,645,519,806,579,1092,519,746,585,519,834,
 739,576,1481,1296,1339,757,868,2235,2262,2316,855,740,755,779,
 2316,2235,2262,632,519,565,1035,1032,548,518,651,522,1035,518,
 635,534,520,624,614,520,377,375,377,593,612,478,487,487,655,
 615,655,612,487,478,487,731,727,1388,1250,767,698,937,758,
 1200,593,974,775,757,857,971,743,1370,1328,1391,967,1409,2245,
 2274,2263,1413,977,949,929,2260,2248,2272,576,1087,1087,592,
 519,752,617,1091,519,738,577,614,757,772,576,1337,1469,1295,
 757,757,2309,2222,2251,740,740,753,773,2251,2309,2222,1084,
 1146,620,529,786,595,1096,520,842,672,594,716,858,668,1341,
 1298,1485,859,882,2224,2314,2253,888,874,848,765,2282,2239,
 2317,87,1088,78,1198,1087,87,75,1252,1089,1087,1394,1198,1090,
 1553,1548,1506,76,79,2355,2329,2359,84,81,81,75,2376,2376,
 2353,1088,75,1251,1089,87,78,1197,1087,1091,1200,1378,1091,
 1549,1516,1548,79,75,2353,2376,2376,81,83,81,75,2359,2324,
 2359,566,614,536,1037,566,675,539,620,817,838,621,1210,1218,
 1213,761,761,2197,2197,2206,788,788,1047,1059,2188,2191,2189,
 706,555,78,54,709,559,519,707,614,519,1233,1215,1233,54,54,
 2199,2205,2205,67,63,67,54,2205,2199,2205,673,1353,713,865,
 680,772,971,988,836,1380,1336,1324,970,930,2249,2230,2268,946,
 980,1374,1400,2266,2247,2232,1049,559,658,520,576,814,849,594,
 1237,1258,1217,765,756,2211,2188,2193,774,805,1061,1064,2203,
 2216,2196,78,1393,1050,1087,1250,1251,1142,1493,1553,1549,75,
 75,2376,2376,2353,81,81,82,79,2319,2359,2355,696,555,519,593,
 713,519,1231,1231,1211,54,54,2195,2192,2195,63,67,67,54,2195,
 2195,2192,662,731,985,971,870,1389,1323,1371,926,969,2231,
 2289,2292,979,938,1403,1408,2293,2228,2279,576,828,820,687,
 1229,1217,1257,756,765,2196,2216,2203,805,774,1060,1064,2194,
 2188,2211,731,752,575,1469,1337,1295,773,757,2251,2222,2309,
 740,753,740,757,2309,2251,2222,937,745,1328,1370,1381,929,
 1409,2260,2295,2248,1413,949,977,967,2245,2263,2294,752,1336,
 1380,1334,1400,931,2266,2244,2247,946,1374,980,970,2249,2268,
 2243,1299,1338,1484,773,771,2259,2318,2241,754,753,853,863,
 2241,2259,2318,384,383,1562,1562,511,511,503,1552,1551,1493,
 1547,476,508,505,384,1547,1562,476,508,508,1552,1493,1551,
 1562,511,503,511,1562,1546,511,503,511,1509,1551,1550,1562,
 508,505,484,54,2425,2427,2427,63,66,63,54,2427,2424,2427,
 2427,2425,2427,66,63,63,54,2427,2427,2425,510,510,2372,2319,
 2358,2427,517,514,517,506,2338,2357,2358,2427,517,517,514,
 2372,2357,2326,2425,514,517,517,73,73,63,2372,2372,2336,73,
 63,2358,2326,2358,66,2319,2357,2356,2425,2427,2427,510,506,
 510,2488,2469,2494,2473,2490,2497,2441,2492,2475,4219,4191,
 3820,4184,3183,4215,4320,4419,4225,3818,4202,4355,3824,4425,
 4346,4291,3276,3248,4176,3185,4434,4230,3270,3176,4414,4210,
 4343,4395,4409,4348,3833,3851,3844,3223,3215,4038,4018,4010,
 3199,3193,3203,3217,4015,4032,4013,2478,2487,2457,2495,2495,
 2468,2490,2447,4223,4181,3813,4195,3187,4190,4326,4417,4218,
 3811,4180,4353,3827,4444,4345,4292,3263,3249,4196,3188,4413,
 4220,3274,3168,4438,4199,4339,4402,4397,4334,3836,3858,3846,
 3214,3222,4041,4017,4012,3194,3209,3204,3232,4016,4033,4014,
 2468,2436,2461,2441,2436,2445,2436,4140,4114,3792,4100,2954,
 4109,4072,4285,4140,3792,4105,4137,3792,4279,4086,4063,3094,
 3104,4103,2954,4267,4140,3103,2954,4260,4111,4090,4254,4268,
 4092,3866,3867,3867,2973,2978,4051,4049,4052,2958,2957,2965,
 2977,4054,4052,4051,2457,2490,2488,2478,2495,2447,4218,4195,
 3811,4182,3187,4180,4322,4421,4223,3813,4190,4350,3827,4422,
 4336,4293,3265,3250,4174,3186,4436,4229,3266,3165,4406,4207,
 4334,4398,4402,4339,3835,3856,3843,3224,3228,4033,4016,4014,
 3209,3194,3194,3227,4017,4041,4012,2470,2473,2436,2470,2436,
 4139,4094,3792,4094,2954,4097,4062,4277,4139,3792,4097,4135,
 3792,4281,4093,4061,3096,3093,4096,2954,4252,4139,3097,2954,
 4251,4095,4088,4253,4253,4088,3869,3864,3862,2971,2972,4043,
 4044,4043,2956,2956,2960,2972,4044,4043,4043,2492,2445,2497,
 2477,4222,4201,3815,4177,3179,4192,4309,4423,4231,3814,4179,
 4352,3809,4423,4333,4295,3260,3268,4186,3174,4408,4227,3254,
 3183,4411,4216,4335,4428,4401,4332,3847,3832,3849,3217,3226,
 4008,4039,4031,3203,3210,3193,3229,4037,4007,4042,2469,2489,
 2475,4225,4184,3818,4192,3183,4202,4323,4420,4219,3820,4215,
 4349,3824,4445,4341,4291,3257,3267,4192,3185,4412,4221,3260,
 3178,4433,4206,4348,4409,4395,4343,3834,3855,3842,3233,3213,
 4032,4015,4013,3193,3199,3210,3221,4018,4038,4010,2461,2436,
 4140,4100,3792,4114,2954,4105,4066,4283,4140,3792,4109,4138,
 3792,4278,4084,4065,3099,3104,4100,2954,4257,4140,3101,2954,
 4270,4112,4092,4268,4254,4090,3866,3868,3865,2975,2977,4052,
 4054,4051,2957,2958,2956,2978,4049,4051,4052,2477,4231,4178,
 3814,4201,3179,4179,4312,4443,4222,3815,4191,4351,3809,4443,
 4329,4294,3271,3275,4185,3172,4389,4226,3247,3185,4400,4187,
 4332,4401,4428,4335,3850,3829,3852,3221,3234,4007,4037,4042,
 3210,3203,3200,3216,4039,4008,4031,4145,4120,3792,4120,2953,
 4118,4060,4284,4145,3792,4118,4148,3792,4286,4130,4057,3087,
 3089,4115,2953,4266,4145,3088,2953,4262,4116,4129,4271,4271,
 4129,3838,3837,3838,2966,2967,4003,4002,4003,2953,2953,2953,
 2967,4002,4003,4003,536,547,598,566,621,591,614,621,525,539,
 638,548,838,663,620,1088,1037,598,525,817,621,1088,566,767,
 621,598,763,601,587,1213,1218,1210,1047,788,2191,2188,2189,
 761,1059,761,788,2197,2197,2206,528,593,555,595,617,673,598,
 520,520,609,522,820,702,576,1087,1049,595,520,828,621,1089,
 559,775,621,593,756,661,575,1217,1258,1237,1061,774,2216,2203,
 2196,756,1064,765,805,2188,2211,2193,520,518,520,546,648,525,
 368,521,521,368,614,554,521,1032,1034,521,518,608,546,1034,
 518,617,528,520,593,617,561,376,379,379,649,615,498,498,492,
 593,618,618,649,492,498,498,555,520,687,820,535,528,595,576,
 522,680,672,577,1049,1087,621,559,775,621,1089,520,828,595,
 575,661,756,593,1229,1261,1210,774,1062,2211,2188,2193,1064,
 756,765,805,2203,2216,2196,559,519,713,566,518,559,544,518,
 713,520,519,78,78,520,54,593,525,75,54,593,520,522,696,696,
 522,1233,1215,1233,67,67,2199,2205,2205,54,54,54,63,2205,
 2199,2205,594,849,539,521,621,576,534,673,595,617,1050,1089,
 595,555,758,598,1087,520,814,593,575,658,765,658,1237,1210,
 1261,804,1062,2196,2216,2203,1064,765,756,774,2194,2188,2211,
 752,621,531,577,590,519,836,668,576,1142,1091,584,519,743,
 644,1090,519,745,578,631,870,772,677,1299,1484,1338,753,853,
 2318,2259,2241,863,773,771,754,2241,2318,2259,838,614,683,812,
 652,988,858,772,1251,1353,766,614,971,772,1198,706,937,786,
 772,971,633,748,1330,1334,1380,1374,980,2244,2266,2238,970,
 1400,931,946,2249,2230,2290,547,621,647,548,694,620,591,1038,
 1088,621,566,767,621,1088,525,817,598,586,601,763,598,1222,
 1213,1218,788,1051,2197,2197,2206,1059,761,761,788,2188,2191,
 2189,520,556,368,648,561,519,1034,1032,528,518,617,547,1034,
 518,608,521,561,617,593,520,379,379,376,615,649,498,492,498,
 618,593,618,649,498,498,492,681,534,849,657,576,1089,1050,
 593,520,814,598,1087,555,758,595,658,765,658,575,1257,1217,
 1229,1060,805,2188,2194,2211,765,1064,756,774,2216,2196,2203,
 573,854,665,691,1139,1098,665,542,816,611,1095,521,764,594,
 530,758,770,664,1470,1295,1342,852,891,2234,2283,2311,890,779,
 759,835,2310,2222,2254,652,520,524,1035,1035,520,518,593,525,
 1032,518,593,520,555,612,612,555,377,375,377,655,655,479,487,
 487,612,612,593,615,487,479,487,786,752,1379,1251,786,706,
 937,772,1198,614,971,766,751,865,971,772,1382,1334,1329,980,
 1396,2244,2237,2267,1401,970,930,946,2291,2230,2249,576,1096,
 1146,575,529,725,587,1084,532,718,575,711,842,876,676,1340,
 1485,1298,874,848,2314,2224,2252,765,859,883,886,2282,2317,
 2239,1091,1087,576,519,731,581,1087,519,757,594,593,738,731,
 596,1337,1295,1469,740,753,2222,2309,2251,773,757,757,740,
 2251,2222,2309,87,1089,78,1200,1088,87,76,1250,1087,1085,1385,
 1197,1094,1506,1548,1553,81,84,2376,2376,2353,79,75,75,81,
 2329,2355,2359,1087,75,1250,1088,87,78,1200,1089,1094,1197,
 1386,1085,1549,1553,1493,82,81,2359,2319,2355,76,79,75,81,
 2376,2376,2353,559,662,536,1050,555,660,520,709,843,815,659,
 1258,1237,1210,774,805,2194,2188,2210,765,756,1064,1061,2216,
 2203,2196,698,566,78,54,707,555,533,709,593,520,1233,1233,
 1215,63,67,2205,2199,2205,54,54,54,67,2205,2205,2199,601,
 1394,707,857,657,879,974,985,862,1370,1384,1335,977,949,2273,
 2248,2275,929,967,1409,1405,2265,2294,2236,1039,566,674,536,
 670,825,825,670,1218,1210,1218,788,788,2206,2197,2197,761,761,
 1059,1047,2191,2188,2191,78,1387,1050,1148,1252,1252,1148,1548,
 1516,1549,81,81,2324,2359,2359,75,75,79,83,2376,2353,2376,
 698,559,520,593,709,533,1211,1231,1231,67,63,2195,2195,2192,
 54,54,54,67,2192,2195,2195,666,862,985,974,879,1327,1392,
 1363,949,977,2274,2285,2245,967,929,1409,1407,2240,2295,2260,
 659,815,843,709,1210,1237,1258,805,774,2193,2211,2190,756,765,
 1064,1061,2196,2203,2216,725,756,593,1480,1344,1295,822,889,
 2256,2222,2312,884,756,864,878,2315,2284,2233,926,756,1390,
 1364,1333,937,1412,2279,2228,2271,1408,926,969,979,2292,2269,
 2242,725,1321,1372,1383,1402,937,2269,2292,2242,926,1408,969,
 979,2228,2279,2271,1297,1343,1482,887,822,2284,2315,2233,756,
 884,864,878,2222,2256,2312,384,383,1550,1509,505,508,484,1546,
 1562,1562,1551,503,511,511,384,1551,1552,503,511,511,1562,
 1562,1547,1493,508,476,508,1493,1552,508,476,505,1562,1547,
 1562,1551,511,511,503,73,2357,2319,2356,63,66,63,73,2358,
 2358,2326,2372,2372,2336,66,63,63,73,2338,2372,2372,510,510,
 2427,2427,2424,2326,517,514,517,506,2427,2425,2427,2358,517,
 517,514,2425,2427,2427,2358,514,517,517,54,54,63,2425,2427,
 2427,54,63,2427,2427,2425,66,2427,2425,2427,2357,2319,2357,
 510,506,510,31,31,31,31,31,31,31,31,2830,2830,2702,2830,
 2702,2579,2601,2601,2830,2702,2579,2598,2702,2597,2604,2604,
 2725,2731,2830,2702,2593,2579,2731,2702,2593,2830,2593,2598,
 2601,2601,2731,2727,2727,3240,3240,3240,3240,3236,3236,3240,
 3244,3236,3244,3236,3240,31,31,31,31,31,31,31,2830,2830,2579,
 2830,2579,2579,2596,2610,2830,2579,2579,2588,2579,2594,2600,
 2602,2619,2622,2830,2579,2595,2579,2628,2579,2610,2830,2610,
 2588,2596,2610,2622,2621,2637,3077,3056,3056,3077,3059,3059,
 3056,3076,3059,3076,3059,3056,31,31,31,31,31,31,2831,2831,
 2746,2831,2746,2578,2580,2585,2831,2746,2578,2582,2746,2585,
 2580,2582,2747,2747,2831,2746,2583,2578,2748,2746,2583,2831,
 2583,2582,2580,2585,2747,2748,2749,3278,3279,3279,3278,3278,
 3278,3279,3277,3278,3277,3278,3279,31,31,31,31,31,2830,2830,
 2579,2830,2579,2568,2569,2575,2830,2579,2568,2574,2579,2571,
 2576,2570,2635,2631,2830,2579,2574,2568,2632,2579,2569,2830,
 2569,2574,2569,2575,2631,2618,2625,3083,3057,3056,3083,3054,
 3054,3056,3059,3054,3059,3054,3056,31,31,31,31,2788,2788,2702,
 2788,2702,2517,2531,2546,2788,2702,2517,2539,2702,2536,2556,
 2544,2727,2731,2788,2702,2543,2517,2731,2702,2531,2788,2531,
 2539,2531,2546,2731,2724,2731,3243,3240,3240,3243,3238,3238,
 3240,3236,3238,3236,3238,3240,31,31,31,2831,2831,2746,2831,
 2746,2578,2583,2582,2831,2746,2578,2583,2746,2583,2583,2585,
 2748,2749,2831,2746,2585,2578,2747,2746,2582,2831,2582,2583,
 2583,2582,2749,2748,2747,3278,3277,3277,3278,3277,3277,3277,
 3278,3277,3278,3277,3277,31,31,2831,2831,2578,2831,2578,2578,
 2583,2585,2831,2578,2578,2585,2578,2581,2580,2585,2591,2608,
 2831,2578,2581,2578,2591,2578,2585,2831,2584,2585,2583,2584,
 2608,2605,2608,3039,3011,3011,3039,3021,3021,3011,3021,3021,
 3021,3021,3011,31,2788,2788,2702,2788,2702,2517,2548,2544,2788,
 2702,2517,2536,2702,2534,2533,2550,2731,2731,2788,2702,2531,
 2517,2724,2702,2532,2788,2532,2537,2548,2544,2731,2731,2727,
 3241,3237,3237,3241,3242,3242,3237,3238,3242,3238,3242,3237,
 2830,2830,2579,2830,2579,2568,2577,2571,2830,2579,2568,2571,
 2579,2574,2572,2577,2624,2634,2830,2579,2569,2568,2627,2579,
 2573,2830,2573,2570,2576,2571,2634,2620,2629,3079,3032,3032,
 3079,3075,3075,3032,3054,3075,3054,3075,3032,3291,3291,3291,
 3291,2787,3302,2936,2787,3291,2787,2872,3291,2872,3300,2936,
 3432,3486,3291,3291,3300,3291,3446,3291,3299,3291,2791,2791,
 2800,2805,3433,3441,3486,4881,4643,4648,4881,4655,4653,4877,
 4664,4661,4653,4664,4875,3291,3291,3291,3291,2799,2805,3291,
 3291,2787,2791,3291,3300,2936,3307,3446,3488,2787,3291,2872,
 2787,3432,3291,2791,3291,2872,3299,2936,3318,3433,3487,3447,
 4881,4648,4877,4675,4653,4664,4875,4653,4655,4655,4876,4647,
 3291,3291,3291,3400,3341,3291,2578,3291,3293,2578,3299,3376,
 3377,3450,3467,3291,3291,3299,3291,3450,3291,3299,3291,3293,
 3299,3338,3406,2592,2609,2612,4600,4550,3037,3065,3033,4583,
 4556,4583,4579,3033,3038,3028,3291,2787,2936,3318,3291,3291,
 3291,3299,3291,2797,2797,2794,3483,3444,3291,3291,2790,2787,
 3432,3291,2872,2787,3300,2936,3299,2874,3447,3487,3433,4675,
 4877,4875,4671,4664,4876,4647,4655,4653,4661,4875,4644,3291,
 3338,3406,3291,3291,3291,3299,3291,3402,3340,3307,2613,2617,
 3291,2578,3293,3291,2591,2578,3293,3291,3299,3373,3373,3303,
 3457,3463,3457,3065,3036,4556,4599,4583,3038,3028,3033,3033,
 4579,4590,4551,2877,2885,2787,3291,2787,2877,3291,2522,2791,
 2529,3525,3447,3291,3291,2791,2787,3446,3291,2877,2787,2791,
 2522,2789,2529,3447,3441,3527,4676,4883,4648,4891,4663,4887,
 4649,4663,4662,4662,4660,4884,2821,3299,3373,2789,2820,3293,
 2893,2553,2907,3728,3628,2789,3299,2531,2518,3609,3299,2531,
 2872,2899,2993,2913,3004,3543,3756,3646,4727,4760,4926,4862,
 4825,4755,4715,4701,4692,4824,4933,4833,2874,3303,2529,2540,
 3307,3004,2934,2987,3650,3749,2794,3295,2912,2794,3549,3378,
 2829,3322,2535,2915,2555,2927,3619,3626,3722,4930,4839,4704,
 4777,4696,4855,4928,4819,4817,4700,4713,4752,3291,2787,2936,
 3291,2936,3312,2875,3484,3433,3291,3291,3299,3291,3443,3291,
 3300,3291,2810,2810,2789,2794,3485,3441,3433,4671,4875,4647,
 4671,4876,4875,4644,4661,4664,4875,4661,4643,3291,3373,2578,
 3339,3404,3295,3469,3453,3291,3291,3299,3291,3448,3291,3299,
 3291,3403,3336,3299,3295,2612,2609,2592,4599,4556,3028,3064,
 3038,4590,4551,4579,4583,3051,3051,3017,2522,3291,2877,2883,
 2887,3443,3524,2787,3291,2877,2787,3443,3291,2791,3291,2518,
 2791,2518,2794,3527,3441,3447,4891,4648,4649,4676,4887,4660,
 4884,4662,4663,4889,4664,4649,3402,2987,2916,3006,3718,3610,
 2810,3336,2935,2791,3630,3299,2829,3320,2542,2931,2531,2922,
 3762,3539,3644,4719,4749,4814,4863,4929,4778,4684,4720,4714,
 4935,4823,4840,3299,3294,3407,3448,3451,3291,3291,3293,3291,
 3434,3291,3293,3291,3374,3299,3299,3378,2616,2587,2616,4598,
 4546,3015,3053,3041,4578,4544,4564,4564,3029,3025,3019,2817,
 2541,3754,3644,3299,3375,2822,2791,3550,3293,2908,2790,2935,
 2542,2901,2535,3720,3622,3614,4864,4937,4709,4705,4781,4923,
 4837,4818,4820,4769,4729,4688,2825,3639,3726,2873,3301,2532,
 2526,3617,3300,2533,2790,3003,2891,2987,2921,3649,3750,3548,
 4770,4724,4925,4828,4848,4721,4763,4693,4702,4849,4932,4811,
 3618,3722,3318,3303,2828,2794,3635,3298,2933,2816,2915,2535,
 2910,2557,3654,3537,3749,4777,4683,4812,4930,4857,4700,4750,
 4713,4722,4855,4819,4927,2641,3443,2614,3550,3446,2641,2591,
 3645,3432,3630,3758,3542,3621,3737,3735,3745,3155,3144,4970,
 5011,4965,3161,3111,3127,3131,4973,4972,5002,3433,2592,3648,
 3444,2641,2617,3554,3459,3608,3551,3760,3631,3743,3738,3733,
 3147,3115,4978,4969,5003,3129,3157,3125,3129,5007,4962,4984,
 3291,2936,2787,3484,3291,2810,3291,2936,3300,2872,3307,3488,
 3431,3444,4671,4647,4644,4675,4875,4661,4643,4875,4876,4876,
 4655,4648,3375,3291,2615,2578,3403,3291,3336,3403,3293,3307,
 3467,3442,3453,3064,3028,4551,4599,4590,3051,3017,3051,3038,
 4590,4579,4550,2519,3754,3401,2542,2815,2987,2908,3000,2892,
 3716,3604,3623,4864,4813,4687,4730,4769,4818,4836,4923,4931,
 4781,4694,4710,3528,3291,2518,2787,2878,2878,2879,2887,3444,
 3523,3444,4676,4649,4884,4676,4660,4664,4649,4889,4887,4664,
 4889,4648,2613,3758,3489,3718,3645,3643,3729,3734,3741,3739,
 3155,3113,5000,4963,4973,3127,3113,3161,3145,4965,5004,4980,
 3374,3291,3299,3293,3398,3298,3449,3445,3435,3053,3015,4544,
 4595,4578,3025,3019,3029,3041,4580,4580,4541,2939,2931,2999,
 2919,2992,3633,3606,3721,4831,4841,4682,4779,4720,4856,4814,
 4929,4935,4714,4699,4751,3309,2872,3317,2940,3456,3431,3492,
 4677,4643,4643,4879,4666,4659,4650,4880,4882,4665,4658,4878,
 2829,2531,2829,3752,3640,3551,4719,4717,4841,4831,4935,4720,
 4682,4778,4758,4929,4856,4814,2820,2540,3632,3719,3608,4831,
 4924,4749,4719,4714,4929,4814,4856,4854,4720,4778,4684,2821,
 3608,3725,3629,4934,4809,4760,4727,4692,4825,4926,4846,4847,
 4701,4755,4716,3547,3642,3757,4725,4690,4839,4930,4817,4696,
 4704,4762,4775,4819,4855,4928,2639,2641,5010,4960,3116,3156,
 3148,4987,4994,4967,4985,3143,3130,3116,2639,4989,4976,3134,
 3151,3122,4977,4966,5005,5001,3124,3140,3109,4969,4999,3115,
 3147,3125,5007,4984,4962,4971,3129,3125,3138,3071,5156,5162,
 5169,3085,3073,3085,3082,5169,5164,5153,5160,5175,5155,3047,
 3024,3044,3046,5166,5154,5173,3071,3046,5155,5160,5169,5171,
 3044,3047,3024,3082,5169,5156,5164,5150,3085,3085,3073,5160,
 5171,5151,5160,3073,3068,3044,3046,3071,3068,5151,5160,5171,
 3042,3044,5169,5155,5160,3073,5160,5173,5149,5152,5172,5161,
 3071,3042,3046,31,31,31,31,31,31,31,2830,2830,2579,2830,2579,
 2579,2610,2596,2830,2579,2579,2590,2579,2603,2602,2599,2619,
 2628,2830,2579,2610,2579,2622,2579,2595,2830,2595,2590,2610,
 2596,2628,2637,2621,3057,3077,3077,3056,3031,3031,3077,3076,
 3031,3076,3031,3077,31,31,31,31,31,31,2830,2830,2702,2830,
 2702,2579,2604,2597,2830,2702,2579,2604,2702,2601,2601,2598,
 2731,2725,2830,2702,2598,2579,2726,2702,2597,2830,2597,2604,
 2604,2597,2725,2731,2726,3236,3240,3240,3236,3240,3240,3240,
 3236,3240,3236,3240,3240,31,31,31,31,31,2830,2830,2579,2830,
 2579,2579,2602,2603,2830,2579,2579,2599,2579,2596,2610,2590,
 2628,2619,2830,2579,2588,2579,2637,2579,2594,2830,2594,2599,
 2602,2603,2619,2622,2621,3031,3077,3077,3031,3056,3056,3077,
 3059,3056,3059,3056,3077,31,31,31,31,2787,2787,2746,2787,2746,
 2516,2520,2518,2787,2746,2516,2518,2746,2518,2520,2518,2747,
 2747,2787,2746,2518,2516,2747,2746,2517,2787,2517,2518,2520,
 2518,2747,2747,2749,3277,3279,3279,3277,3277,3277,3279,3277,
 3277,3277,3277,3279,31,31,31,2831,2831,2746,2831,2746,2578,
 2582,2583,2831,2746,2578,2580,2746,2580,2585,2583,2748,2747,
 2831,2746,2582,2578,2749,2746,2585,2831,2585,2580,2582,2583,
 2747,2747,2748,3277,3278,3278,3277,3279,3279,3278,3278,3279,
 3278,3279,3278,31,31,2830,2830,2579,2830,2579,2568,2571,2574,
 2830,2579,2568,2577,2579,2569,2575,2572,2632,2635,2830,2579,
 2574,2568,2626,2579,2570,2830,2571,2577,2571,2574,2635,2631,
 2618,3055,3083,3083,3055,3056,3056,3083,3054,3056,3054,3056,
 3083,31,2788,2788,2702,2788,2702,2517,2545,2534,2788,2702,2517,
 2556,2702,2531,2546,2533,2731,2726,2788,2702,2539,2517,2731,
 2702,2537,2788,2537,2556,2545,2534,2727,2731,2724,3239,3243,
 3243,3239,3240,3240,3243,3238,3240,3238,3240,3243,2831,2831,
 2578,2831,2578,2578,2586,2580,2831,2578,2578,2585,2578,2583,
 2584,2583,2606,2606,2831,2578,2580,2578,2592,2578,2580,2831,
 2580,2585,2586,2580,2606,2608,2589,3013,3039,3039,3013,3012,
 3012,3039,3022,3012,3022,3012,3039,3291,3291,3291,3291,2787,
 3318,2936,2787,3291,2787,2873,3291,2872,3307,2936,3432,3483,
 3291,3291,3300,3291,3447,3291,3299,3291,2790,2790,2805,2799,
 3432,3447,3487,4875,4671,4675,4877,4644,4643,4881,4661,4647,
 4655,4648,4881,3291,3291,3291,3291,2805,2799,3291,3291,2787,
 2790,3291,3302,2936,3300,3443,3484,2787,3291,2872,2787,3433,
 3291,2790,3291,2872,3300,2936,3302,3432,3486,3441,4877,4675,
 4881,4648,4643,4648,4881,4655,4644,4653,4877,4675,3291,3291,
 3291,3406,3338,3291,2578,3291,3294,2578,3299,3377,3376,3448,
 3468,3291,3291,3299,3291,3457,3291,3299,3291,3293,3300,3341,
 3399,2591,2612,2609,4556,4599,3065,3036,3017,4550,4600,4579,
 4551,3033,3037,3065,3291,2787,2936,3302,3291,3291,3291,3300,
 3291,2799,2805,2790,3484,3443,3291,3291,2791,2787,3433,3291,
 2872,2787,3300,2936,3307,2872,3446,3488,3431,4648,4881,4881,
 4643,4648,4877,4675,4653,4643,4664,4875,4671,3291,3341,3400,
 3291,3291,3291,3300,3291,3400,3341,3300,2615,2615,3291,2578,
 3293,3291,2592,2578,3293,3291,3299,3376,3377,3299,3450,3467,
 3442,3037,3065,4600,4550,4550,3037,3065,3033,3017,4583,4556,
 4599,2885,2877,2787,3291,2787,2881,3291,2519,2794,2526,3528,
 3446,3291,3291,2791,2787,3447,3291,2877,2787,2791,2526,2794,
 2519,3446,3444,3523,4648,4891,4676,4883,4648,4883,4676,4662,
 4649,4663,4648,4891,2821,3307,3377,2794,2825,3295,2910,2557,
 2921,3723,3634,2794,3307,2535,2529,3619,3303,2541,2875,2912,
 2996,2927,3004,3549,3757,3642,4704,4777,4930,4839,4812,4750,
 4725,4700,4683,4819,4927,4861,2872,3299,2519,2532,3299,3002,
 2910,2987,3643,3751,2789,3293,2899,2789,3543,3372,2818,3306,
 2531,2906,2555,2913,3609,3629,3725,4926,4862,4727,4760,4681,
 4834,4934,4824,4810,4701,4711,4768,3291,2787,2936,3291,2936,
 3318,2873,3483,3432,3291,3291,3299,3291,3444,3291,3300,3291,
 2797,2797,2794,2789,3483,3444,3431,4643,4881,4675,4644,4877,
 4875,4671,4664,4648,4876,4647,4671,3291,3376,2578,3338,3406,
 3294,3469,3448,3291,3291,3299,3291,3453,3291,3299,3291,3402,
 3340,3307,3293,2613,2617,2587,4550,4600,3065,3017,3037,4556,
 4599,4583,4550,3038,3028,3064,2526,3291,2877,2885,2881,3446,
 3528,2787,3291,2877,2787,3444,3291,2791,3291,2522,2791,2529,
 2789,3525,3447,3441,4883,4676,4676,4648,4883,4648,4891,4663,
 4648,4887,4649,4676,3405,2987,2921,3007,3727,3616,2797,3340,
 2891,2791,3637,3301,2817,3335,2553,2894,2546,2900,3761,3545,
 3641,4689,4770,4828,4838,4925,4763,4707,4721,4724,4932,4811,
 4865,3299,3295,3405,3455,3455,3291,3291,3293,3291,3435,3291,
 3293,3291,3372,3301,3303,3372,2611,2592,2607,4546,4598,3050,
 3016,3016,4546,4598,4564,4541,3041,3015,3053,2821,2532,3751,
 3643,3299,3373,2820,2789,3541,3293,2901,2789,2893,2553,2907,
 2531,3728,3628,3605,4834,4934,4727,4681,4760,4926,4862,4825,
 4809,4755,4716,4718,2825,3634,3723,2875,3303,2541,2529,3620,
 3307,2535,2794,3004,2934,2987,2907,3650,3749,3537,4750,4725,
 4930,4812,4839,4704,4777,4696,4690,4855,4928,4830,3616,3727,
 3312,3301,2826,2791,3638,3297,2891,2812,2923,2546,2934,2553,
 3653,3548,3750,4763,4707,4828,4925,4838,4689,4770,4733,4723,
 4849,4811,4936,2641,3446,2613,3553,3443,2641,2591,3645,3432,
 3625,3755,3546,3612,3733,3734,3741,3111,3146,4981,4997,4968,
 3135,3153,3128,3112,4988,4977,5009,3432,2591,3647,3443,2641,
 2613,3552,3458,3607,3544,3759,3636,3744,3737,3735,3135,3153,
 4981,4968,4997,3111,3146,3133,3111,5001,4961,4974,3291,2936,
 2787,3488,3291,2797,3291,2936,3312,2875,3299,3484,3433,3441,
 4644,4675,4671,4647,4875,4647,4671,4876,4877,4875,4644,4675,
 3373,3291,2617,2578,3402,3291,3339,3404,3295,3299,3469,3453,
 3442,3017,3066,4599,4551,4556,3028,3064,3038,3037,4590,4551,
 4599,2522,3752,3402,2542,2811,2987,2916,3006,2928,3718,3611,
 3627,4841,4832,4719,4717,4749,4814,4863,4929,4924,4778,4684,
 4726,3524,3291,2522,2787,2877,2883,2887,2879,3443,3524,3441,
 4648,4676,4891,4649,4648,4649,4676,4887,4883,4660,4884,4676,
 2617,3753,3491,3716,3652,3651,3724,3734,3746,3736,3116,3156,
 5010,4960,4983,3116,3156,3143,3142,4967,4996,4979,3372,3291,
 3299,3294,3407,3293,3448,3451,3431,3016,3050,4598,4541,4546,
 3015,3053,3041,3016,4578,4544,4595,2938,2894,3005,2917,2988,
 3624,3613,3717,4813,4864,4705,4761,4709,4837,4829,4923,4937,
 4729,4688,4771,3308,2873,3333,2937,3454,3433,3490,4650,4672,
 4672,4878,4650,4643,4677,4882,4878,4666,4643,4879,2817,2541,
 2818,3754,3644,3538,4687,4730,4864,4813,4937,4709,4705,4781,
 4754,4923,4837,4829,2825,2532,3639,3726,3615,4811,4936,4770,
 4689,4724,4925,4828,4848,4835,4721,4763,4707,2821,3618,3722,
 3626,4928,4830,4777,4704,4683,4812,4930,4857,4842,4700,4750,
 4725,3540,3646,3756,4716,4718,4862,4926,4810,4681,4727,4776,
 4748,4824,4834,4934,2641,2638,5000,4963,3155,3113,3144,4970,
 5011,4965,4986,3161,3111,3155,2639,4984,4982,3147,3115,3115,
 4978,4969,5003,4999,3129,3157,3154,4966,5006,3151,3134,3110,
 4995,4989,4964,4975,3124,3110,3162,3072,5156,5160,5167,3024,
 3073,3044,3023,5169,5165,5153,5162,5175,5156,3073,3086,3085,
 3072,5164,5153,5177,3072,3071,5156,5162,5169,5175,3085,3073,
 3086,3023,5167,5156,5166,5149,3044,3024,3073,5160,5175,5155,
 5160,3047,3024,3069,3071,3046,3024,5155,5160,5175,3082,3069,
 5169,5156,5162,3047,5160,5171,5150,5154,5173,5163,3046,3082,
 3072,31,31,31,31,31,31,2830,2830,2579,2830,2579,2568,2577,
 2571,2830,2579,2568,2571,2579,2575,2569,2574,2631,2635,2830,
 2579,2572,2568,2618,2579,2574,2830,2574,2571,2577,2571,2635,
 2632,2625,3054,3057,3056,3054,3083,3083,3057,3055,3083,3055,
 3083,3057,31,31,31,31,31,2831,2831,2515,2831,2515,2578,2582,
 2585,2831,2515,2578,2583,2515,2585,2582,2583,2515,2515,2831,
 2515,2580,2578,2515,2515,2583,2831,2583,2583,2582,2585,2515,
 2515,2515,2786,2786,2786,2786,2786,2786,2786,2786,2786,2786,
 2786,2786,31,31,31,31,2788,2788,2579,2788,2579,2517,2549,2545,
 2788,2579,2517,2537,2579,2538,2531,2543,2634,2629,2788,2579,
 2533,2517,2627,2579,2552,2788,2552,2537,2549,2545,2629,2624,
 2620,3054,3077,3077,3054,3078,3078,3077,3055,3078,3055,3078,
 3077,31,31,31,2831,2831,2578,2831,2578,2578,2585,2585,2831,
 2578,2578,2583,2578,2580,2581,2581,2605,2608,2831,2578,2585,
 2578,2608,2578,2585,2831,2585,2583,2585,2585,2608,2591,2591,
 3021,3021,3021,3021,3011,3011,3021,3039,3011,3039,3011,3021,31,
 31,2830,2830,2515,2830,2515,2579,2601,2604,2830,2515,2579,2601,
 2515,2593,2593,2598,2515,2515,2830,2515,2598,2579,2515,2515,
 2604,2830,2604,2601,2601,2604,2515,2515,2515,2786,2786,2786,
 2786,2786,2786,2786,2786,2786,2786,2786,2786,31,2787,2787,2578,
 2787,2578,2516,2520,2520,2787,2578,2516,2517,2578,2518,2518,
 2517,2606,2592,2787,2578,2518,2516,2589,2578,2518,2787,2518,
 2517,2520,2520,2592,2608,2606,3014,3021,3021,3014,3039,3039,
 3021,3018,3039,3018,3039,3021,2830,2830,2515,2830,2515,2579,
 2610,2602,2830,2515,2579,2596,2515,2595,2610,2588,2515,2515,
 2830,2515,2590,2579,2515,2515,2599,2830,2599,2596,2610,2602,
 2515,2515,2515,2786,2786,2786,2786,2786,2786,2786,2786,2786,
 2786,2786,2786,3291,3291,3291,3291,2787,3307,2950,2787,3291,
 2787,2876,3291,2876,3304,2944,3423,3508,3291,3291,3300,3291,
 3422,3291,3319,3291,2791,2789,2813,2813,3425,3425,3504,4793,
 4468,4484,4798,4473,4467,4798,4470,4470,4470,4468,4793,3291,
 3291,3291,3291,2813,2813,3291,3291,2787,2789,3291,3299,2944,
 3304,3422,3512,2787,3291,2877,2787,3422,3291,2791,3291,2877,
 3300,2950,3307,3422,3504,3425,4798,4484,4798,4484,4467,4468,
 4793,4470,4473,4470,4795,4469,3291,3291,3291,3358,3295,3291,
 2515,3291,3339,2515,3293,3347,3346,3421,3421,3291,3291,3294,
 3291,3421,3291,3294,3291,3340,3293,3295,3358,2515,2515,2515,
 4233,4233,2786,2786,2786,4233,4233,4233,4233,2786,2786,2786,
 3291,2787,2950,3307,3291,3291,3291,3300,3291,2804,2807,2791,
 3503,3422,3291,3291,2791,2787,3425,3291,2877,2787,3300,2945,
 3314,2880,3422,3511,3422,4484,4798,4793,4468,4468,4795,4469,
 4470,4467,4470,4789,4484,3291,3295,3358,3291,3291,3291,3293,
 3291,3358,3293,3293,2515,2515,3291,2515,3340,3291,2515,2515,
 3340,3291,3294,3344,3351,3295,3421,3421,3421,2786,2786,4233,
 4233,4233,2786,2786,2786,2786,4233,4233,4233,2885,2885,2787,
 3291,2787,2881,3291,2518,2791,2518,3502,3422,3291,3291,2792,
 2787,3427,3291,2888,2787,2792,2522,2794,2529,3427,3422,3513,
 4469,4794,4469,4794,4485,4799,4467,4482,4478,4482,4484,4788,
 2829,3314,3351,2794,2821,3341,2917,2554,2930,3702,3587,2794,
 3295,2546,2530,3600,3295,2546,2885,2934,3004,2911,2987,3564,
 3778,3685,4457,4522,4921,4617,4568,4534,4492,4501,4465,4572,
 4917,4616,2880,3295,2529,2541,3295,2995,2922,3006,3684,3779,
 2794,3342,2934,2794,3564,3353,2827,3324,2546,2910,2558,2911,
 3600,3589,3707,4921,4617,4457,4522,4466,4618,4921,4572,4574,
 4501,4493,4531,3291,2787,2945,3291,2946,3299,2876,3503,3425,
 3291,3291,3319,3291,3422,3291,3300,3291,2801,2798,2794,2794,
 3508,3423,3422,4468,4793,4469,4484,4795,4789,4484,4470,4468,
 4792,4470,4468,3291,3344,2515,3293,3358,3336,3421,3421,3291,
 3291,3294,3291,3421,3291,3294,3291,3358,3293,3295,3342,2515,
 2515,2515,4233,4233,2786,2786,2786,4233,4233,4233,4233,2786,
 2786,2786,2522,3291,2879,2877,2883,3425,3506,2787,3291,2888,
 2787,3430,3291,2792,3291,2527,2789,2530,2794,3505,3422,3428,
 4794,4469,4467,4479,4799,4484,4788,4482,4485,4797,4471,4477,
 3359,3000,2904,2989,3695,3582,2798,3293,2900,2789,3580,3293,
 2818,3301,2553,2903,2535,2925,3764,3562,3681,4488,4527,4565,
 4609,4920,4520,4454,4459,4489,4917,4570,4607,3293,3336,3361,
 3421,3421,3291,3291,3294,3291,3421,3291,3294,3291,3350,3293,
 3295,3353,2515,2515,2515,4233,4233,2786,2786,2786,4233,4233,
 4233,4233,2786,2786,2786,2824,2531,3769,3689,3300,3343,2817,
 2791,3555,3339,2898,2792,2904,2542,2926,2535,3698,3591,3583,
 4606,4920,4458,4453,4519,4919,4624,4561,4560,4529,4494,4489,
 2829,3590,3696,2876,3293,2532,2519,3583,3293,2533,2791,2994,
 2919,3006,2930,3688,3773,3567,4526,4496,4917,4582,4612,4463,
 4517,4459,4488,4631,4919,4569,3575,3701,3299,3293,2823,2791,
 3594,3293,2916,2806,2891,2531,2922,2555,3678,3567,3773,4517,
 4453,4582,4917,4621,4489,4526,4497,4462,4631,4566,4918,2515,
 3422,2515,3568,3425,2515,2515,3679,3426,3581,3772,3560,3595,
 3741,3741,3741,2834,2861,5012,5012,5013,2860,2836,2838,2835,
 5014,5013,5012,3422,2515,3686,3430,2515,2515,3569,3428,3598,
 3559,3771,3588,3744,3745,3748,2866,2834,5017,5015,5021,2836,
 2867,2846,2841,5022,5021,5017,3291,2947,2787,3512,3291,2801,
 3291,2947,3299,2880,3314,3512,3422,3423,4484,4469,4484,4469,
 4789,4470,4468,4792,4795,4792,4473,4484,3343,3291,2515,2515,
 3358,3291,3294,3358,3342,3295,3421,3421,3421,2786,2786,4233,
 4233,4233,2786,2786,2786,2786,4233,4233,4233,2526,3776,3362,
 2558,2803,3007,2895,2991,2921,3706,3601,3585,4614,4584,4498,
 4490,4532,4586,4629,4922,4919,4523,4464,4455,3506,3291,2527,
 2787,2881,2878,2890,2890,3423,3509,3429,4479,4467,4788,4477,
 4484,4471,4477,4797,4799,4472,4791,4479,2515,3780,3510,3706,
 3675,3694,3705,3743,3748,3745,2835,2834,5015,5017,5020,2842,
 2834,2864,2871,5022,5020,5015,3350,3291,3294,3338,3365,3295,
 3421,3421,3421,2786,2786,4233,4233,4233,2786,2786,2786,2786,
 4233,4233,4233,2949,2909,2987,2897,3008,3584,3597,3703,4584,
 4614,4461,4521,4460,4619,4585,4922,4922,4491,4499,4530,3325,
 2877,3321,2952,3429,3427,3507,4477,4477,4477,4790,4481,4481,
 4477,4800,4796,4486,4480,4790,2818,2546,2827,3776,3687,3570,
 4498,4490,4614,4584,4922,4460,4461,4523,4533,4922,4619,4585,
 2821,2540,3578,3700,3576,4565,4918,4527,4488,4489,4920,4565,
 4615,4626,4459,4520,4454,2829,3603,3707,3589,4921,4567,4522,
 4457,4465,4567,4921,4623,4632,4501,4534,4492,3566,3685,3778,
 4492,4500,4617,4921,4573,4466,4456,4524,4535,4572,4618,4921,
 2515,2515,5015,5017,2835,2834,2863,5021,5017,5022,5021,2864,
 2841,2834,2515,5018,5016,2862,2836,2834,5019,5016,5022,5019,
 2840,2869,2834,5016,5018,2836,2862,2845,5019,5018,5022,5019,
 2841,2834,2870,2786,5178,5179,5179,2786,2786,2786,2786,5181,
 5179,5178,5179,5178,5180,2786,2786,2786,2786,5181,5180,5179,
 2786,2786,5180,5179,5181,5180,2786,2786,2786,2786,5179,5178,
 5181,5179,2786,2786,2786,5182,5180,5183,5182,2786,2786,2786,
 2786,2786,2786,5183,5182,5180,2786,2786,5181,5180,5179,2786,
 5184,5183,5181,5183,5182,5180,2786,2786,2786,31,31,31,31,31,
 2830,2830,2579,2830,2579,2579,2599,2594,2830,2579,2579,2602,
 2579,2610,2596,2588,2622,2619,2830,2579,2590,2579,2621,2579,
 2603,2830,2603,2602,2599,2594,2619,2628,2636,3059,3056,3056,
 3059,3077,3077,3056,3031,3077,3031,3077,3056,31,31,31,31,2788,
 2788,2702,2788,2702,2517,2556,2537,2788,2702,2517,2545,2702,
 2546,2531,2539,2731,2727,2788,2702,2533,2517,2724,2702,2534,
 2788,2534,2545,2556,2537,2727,2731,2731,3238,3240,3240,3238,
 3243,3243,3240,3239,3243,3239,3243,3240,31,31,31,2830,2830,
 2702,2830,2702,2579,2598,2593,2830,2702,2579,2601,2702,2604,
 2597,2593,2727,2731,2830,2702,2604,2579,2727,2702,2601,2830,
 2601,2601,2598,2593,2731,2725,2731,3244,3236,3236,3244,3240,
 3240,3236,3240,3240,3240,3240,3236,31,31,2830,2830,2579,2830,
 2579,2579,2590,2595,2830,2579,2579,2610,2579,2602,2603,2610,
 2637,2628,2830,2579,2600,2579,2621,2579,2596,2830,2596,2610,
 2590,2595,2628,2619,2623,3076,3031,3031,3076,3077,3077,3031,
 3056,3077,3056,3077,3031,31,2787,2787,2746,2787,2746,2516,2518,
 2517,2787,2746,2516,2520,2746,2520,2518,2518,2747,2747,2787,
 2746,2518,2516,2749,2746,2518,2787,2518,2520,2518,2517,2747,
 2747,2747,3277,3277,3277,3277,3279,3279,3277,3277,3279,3277,
 3279,3277,2831,2831,2578,2831,2578,2578,2585,2580,2831,2578,
 2578,2586,2578,2585,2583,2580,2608,2606,2831,2578,2583,2578,
 2589,2578,2580,2831,2580,2586,2585,2580,2606,2606,2592,3022,
 3012,3012,3022,3039,3039,3012,3013,3039,3013,3039,3012,3291,
 3291,3291,3291,2787,3312,2936,2787,3291,2787,2875,3291,2875,
 3299,2936,3433,3484,3291,3291,3312,3291,3441,3291,3299,3291,
 2789,2794,2797,2797,3432,3446,3488,4875,4644,4647,4876,4671,
 4671,4875,4647,4675,4644,4675,4877,3291,3291,3291,3291,2797,
 2797,3291,3291,2787,2794,3291,3318,2936,3299,3444,3483,2787,
 3291,2873,2787,3431,3291,2789,3291,2872,3307,2936,3300,3432,
 3483,3444,4876,4647,4875,4664,4671,4675,4877,4644,4671,4643,
 4881,4648,3291,3291,3291,3404,3339,3291,2578,3291,3295,2578,
 3303,3373,3373,3453,3469,3291,3291,3301,3291,3442,3291,3299,
 3291,3293,3307,3340,3402,2591,2613,2617,4590,4551,3028,3038,
 3064,4599,4556,4551,4599,3017,3065,3036,3291,2787,2936,3300,
 3291,3291,3291,3307,3291,2805,2799,2791,3488,3446,3291,3291,
 2790,2787,3431,3291,2872,2787,3302,2936,3300,2872,3443,3484,
 3433,4664,4875,4877,4653,4675,4881,4648,4643,4671,4648,4881,
 4643,3291,3340,3402,3291,3291,3291,3307,3291,3406,3338,3299,
 2617,2613,3291,2578,3294,3291,2587,2578,3293,3291,3299,3377,
 3376,3299,3448,3469,3453,3038,3028,4556,4583,4599,3066,3037,
 3017,3064,4550,4600,4550,2883,2877,2787,3291,2787,2887,3291,
 2529,2789,2522,3524,3443,3291,3291,2791,2787,3441,3291,2879,
 2787,2789,2529,2791,2522,3443,3443,3524,4660,4884,4649,4887,
 4676,4891,4648,4649,4676,4648,4676,4883,2817,3300,3376,2791,
 2825,3294,2934,2553,2916,3726,3639,2790,3300,2546,2526,3615,
 3301,2532,2873,2906,2996,2894,3005,3544,3755,3652,4721,4763,
 4925,4848,4828,4770,4724,4689,4707,4811,4936,4835,2872,3299,
 2522,2541,3299,3004,2893,2987,3644,3754,2790,3293,2924,2791,
 3538,3372,2818,3308,2531,2912,2553,2894,3607,3625,3716,4923,
 4837,4709,4781,4705,4864,4937,4813,4829,4687,4730,4754,3291,
 2787,2936,3291,2936,3302,2872,3486,3432,3291,3291,3300,3291,
 3441,3291,3302,3291,2800,2805,2790,2790,3484,3443,3433,4653,
 4877,4648,4655,4881,4881,4643,4648,4675,4877,4675,4644,3291,
 3377,2578,3341,3400,3293,3467,3450,3291,3291,3300,3291,3442,
 3291,3299,3291,3399,3341,3300,3293,2615,2615,2592,4583,4556,
 3037,3033,3065,4600,4550,4550,4599,3037,3065,3017,2529,3291,
 2885,2877,2877,3447,3525,2787,3291,2881,2787,3441,3291,2789,
 3291,2519,2794,2526,2791,3528,3446,3444,4887,4649,4648,4663,
 4891,4676,4883,4648,4676,4883,4676,4648,3407,2987,2907,3006,
 3722,3618,2805,3341,2934,2794,3626,3303,2821,3333,2555,2927,
 2546,2917,3759,3546,3651,4700,4750,4812,4857,4930,4777,4683,
 4704,4725,4928,4830,4842,3307,3293,3402,3451,3448,3291,3291,
 3297,3291,3431,3291,3293,3291,3372,3303,3301,3372,2613,2591,
 2617,4578,4544,3015,3041,3053,4598,4546,4541,4595,3016,3050,
 3016,2821,2541,3749,3650,3307,3377,2825,2794,3537,3295,2907,
 2794,2910,2558,2921,2535,3723,3634,3620,4855,4928,4704,4696,
 4777,4930,4839,4812,4830,4750,4725,4690,2820,3628,3728,2872,
 3299,2532,2519,3605,3299,2531,2789,3002,2910,2987,2901,3643,
 3751,3541,4755,4716,4926,4825,4862,4727,4760,4681,4718,4834,
 4934,4809,3610,3718,3300,3299,2826,2791,3627,3293,2929,2811,
 2899,2535,2891,2542,3647,3553,3752,4778,4684,4814,4929,4863,
 4719,4749,4717,4726,4841,4831,4924,2641,3447,2612,3548,3444,
 2639,2592,3646,3433,3629,3757,3545,3613,3737,3734,3746,3129,
 3157,4978,5003,4969,3147,3115,3115,3154,4984,4982,4999,3432,
 2591,3653,3446,2638,2611,3540,3454,3609,3549,3761,3624,3744,
 3733,3734,3161,3111,4970,4965,5011,3155,3144,3113,3155,5000,
 4963,4986,3291,2936,2787,3487,3291,2799,3291,2936,3318,2873,
 3299,3483,3432,3447,4655,4648,4643,4661,4881,4675,4644,4877,
 4881,4875,4671,4647,3376,3291,2609,2578,3400,3291,3338,3406,
 3294,3299,3469,3448,3457,3033,3036,4550,4579,4600,3065,3017,
 3037,3065,4556,4599,4551,2526,3750,3405,2553,2812,2987,2921,
 3007,2891,3727,3616,3638,4849,4811,4689,4733,4770,4828,4838,
 4925,4936,4763,4707,4723,3523,3291,2519,2787,2877,2885,2881,
 2877,3446,3528,3447,4663,4648,4883,4662,4676,4676,4648,4883,
 4891,4648,4891,4649,2607,3756,3490,3725,3642,3641,3717,3735,
 3741,3736,3124,3110,4995,4964,4989,3151,3110,3134,3162,4966,
 5006,4975,3372,3291,3299,3295,3405,3293,3455,3455,3436,3041,
 3015,4546,4564,4598,3050,3016,3016,3053,4546,4598,4541,2937,
 2914,3004,2900,2988,3636,3612,3724,4824,4834,4681,4776,4727,
 4862,4810,4926,4934,4716,4718,4748,3306,2875,3335,2938,3458,
 3432,3491,4666,4643,4643,4882,4677,4672,4650,4878,4879,4650,
 4672,4878,2821,2532,2818,3751,3643,3543,4701,4711,4834,4824,
 4934,4727,4681,4760,4768,4926,4862,4810,2825,2541,3634,3723,
 3619,4819,4927,4750,4700,4725,4930,4812,4839,4861,4704,4777,
 4683,2817,3616,3727,3637,4932,4811,4763,4721,4706,4828,4925,
 4838,4865,4689,4770,4724,3552,3645,3753,4729,4688,4837,4923,
 4829,4705,4709,4761,4771,4813,4864,4937,2641,2641,5001,4961,
 3111,3133,3146,4981,4997,4968,4974,3135,3153,3111,2641,4988,
 4977,3135,3128,3153,4981,4968,4997,5009,3111,3146,3112,4967,
 4996,3116,3143,3156,5010,4983,4960,4979,3116,3156,3142,3046,
 5155,5160,5169,3085,3047,3044,3082,5169,5164,5154,5160,5171,
 5156,3073,3024,3024,3072,5165,5153,5173,3046,3071,5156,5160,
 5167,5175,3024,3073,3024,3082,5169,5155,5166,5150,3044,3085,
 3047,5162,5175,5156,5162,3073,3086,3069,3071,3071,3086,5156,
 5162,5175,3023,3069,5167,5156,5160,3073,5160,5175,5149,5153,
 5177,5163,3071,3023,3071,31,31,31,31,2788,2788,2579,2788,2579,
 2517,2531,2538,2788,2579,2517,2543,2579,2545,2549,2537,2629,
 2633,2788,2579,2539,2517,2624,2579,2531,2788,2531,2543,2531,
 2538,2633,2627,2620,3078,3077,3077,3078,3054,3054,3077,3031,
 3054,3031,3054,3077,31,31,31,2830,2830,2579,2830,2579,2568,
 2574,2569,2830,2579,2568,2569,2579,2577,2571,2574,2618,2631,
 2830,2579,2571,2568,2625,2579,2575,2830,2575,2569,2574,2569,
 2631,2635,2632,3059,3054,3054,3059,3057,3056,3054,3083,3056,
 3083,3056,3054,31,31,2831,2831,2515,2831,2515,2578,2583,2583,
 2831,2515,2578,2582,2515,2582,2585,2580,2515,2515,2831,2515,
 2583,2578,2515,2515,2585,2831,2585,2582,2583,2583,2515,2515,
 2515,2786,2786,2786,2786,2786,2786,2786,2786,2786,2786,2786,
 2786,31,2788,2788,2579,2788,2579,2517,2543,2531,2788,2579,2517,
 2531,2579,2549,2545,2539,2627,2634,2788,2579,2537,2517,2620,
 2579,2538,2788,2538,2531,2543,2531,2634,2629,2624,3031,3054,
 3054,3031,3077,3077,3054,3078,3077,3078,3077,3054,2831,2831,
 2515,2831,2515,2578,2585,2581,2831,2515,2578,2585,2515,2585,
 2585,2583,2515,2515,2831,2515,2583,2578,2515,2515,2581,2831,
 2581,2585,2585,2581,2515,2515,2515,2786,2786,2786,2786,2786,
 2786,2786,2786,2786,2786,2786,2786,3291,3291,3291,3291,2787,
 3299,2946,2787,3291,2787,2876,3291,2880,3314,2945,3425,3503,
 3291,3291,3299,3291,3425,3291,3300,3291,2791,2791,2807,2804,
 3423,3422,3511,4789,4484,4469,4795,4484,4468,4793,4470,4469,
 4473,4484,4798,3291,3291,3291,3291,2807,2804,3291,3291,2787,
 2791,3291,3307,2950,3300,3422,3503,2787,3291,2876,2787,3422,
 3291,2791,3291,2876,3304,2944,3299,3423,3508,3423,4795,4469,
 4793,4468,4468,4484,4798,4473,4484,4467,4798,4484,3291,3291,
 3291,3358,3293,3291,2515,3291,3336,2515,3295,3351,3344,3421,
 3421,3291,3291,3293,3291,3421,3291,3293,3291,3336,3293,3293,
 3358,2515,2515,2515,4233,4233,2786,2786,2786,4233,4233,4233,
 4233,2786,2786,2786,3291,2787,2944,3299,3291,3291,3291,3304,
 3291,2813,2813,2789,3512,3422,3291,3291,2789,2787,3422,3291,
 2876,2787,3299,2944,3304,2876,3422,3512,3422,4468,4793,4798,
 4467,4484,4798,4484,4467,4468,4468,4793,4468,3291,3293,3358,
 3291,3291,3291,3293,3291,3358,3295,3293,2515,2515,3291,2515,
 3339,3291,2515,2515,3336,3291,3293,3347,3346,3293,3421,3421,
 3421,2786,2786,4233,4233,4233,2786,2786,2786,2786,4233,4233,
 4233,2877,2879,2787,3291,2787,2883,3291,2529,2794,2522,3506,
 3425,3291,3291,2789,2787,3428,3291,2882,2787,2796,2518,2791,
 2518,3426,3423,3509,4484,4788,4467,4799,4479,4794,4469,4478,
 4477,4485,4469,4794,2824,3304,3346,2791,2829,3336,2922,2555,
 2904,3696,3590,2791,3293,2531,2518,3577,3293,2531,2877,2935,
 2999,2920,2987,3561,3768,3692,4463,4517,4917,4612,4582,4526,
 4496,4489,4453,4566,4918,4611,2876,3293,2518,2531,3293,2995,
 2917,3000,3689,3769,2791,3336,2894,2796,3557,3348,2817,3316,
 2531,2935,2542,2905,3574,3593,3701,4919,4624,4458,4519,4453,
 4606,4920,4577,4559,4488,4495,4528,3291,2787,2944,3291,2950,
 3307,2876,3508,3423,3291,3291,3300,3291,3423,3291,3299,3291,
 2804,2807,2791,2791,3503,3422,3422,4467,4798,4484,4473,4798,
 4793,4468,4468,4484,4795,4469,4484,3291,3347,2515,3296,3358,
 3339,3421,3421,3291,3291,3293,3291,3421,3291,3293,3291,3358,
 3293,3293,3336,2515,2515,2515,4233,4233,2786,2786,2786,4233,
 4233,4233,4233,2786,2786,2786,2518,3291,2884,2885,2881,3422,
 3502,2787,3291,2881,2787,3429,3291,2796,3291,2518,2791,2518,
 2796,3502,3422,3429,4799,4467,4469,4485,4794,4469,4794,4485,
 4479,4799,4467,4479,3361,3006,2930,2989,3701,3575,2807,3293,
 2919,2791,3596,3293,2824,3305,2542,2920,2531,2896,3765,3561,
 3676,4489,4526,4582,4621,4917,4517,4453,4463,4496,4919,4569,
 4610,3296,3341,3359,3421,3421,3291,3291,3293,3291,3421,3291,
 3293,3291,3348,3293,3293,3348,2515,2515,2515,4233,4233,2786,
 2786,2786,4233,4233,4233,4233,2786,2786,2786,2829,2541,3779,
 3684,3314,3351,2821,2794,3565,3341,2926,2794,2917,2554,2930,
 2535,3702,3587,3602,4618,4921,4457,4466,4522,4921,4617,4568,
 4567,4534,4492,4500,2821,3587,3702,2880,3295,2541,2529,3602,
 3295,2535,2794,2995,2922,3006,2926,3684,3779,3565,4534,4492,
 4921,4568,4617,4457,4522,4466,4500,4618,4921,4567,3582,3695,
 3299,3293,2817,2789,3576,3293,2901,2797,2894,2531,2919,2542,
 3691,3563,3773,4520,4454,4565,4920,4609,4488,4527,4488,4454,
 4614,4565,4918,2515,3422,2515,3563,3423,2515,2515,3682,3428,
 3593,3768,3561,3577,3741,3743,3748,2836,2867,5017,5021,5015,
 2866,2834,2834,2834,5020,5015,5017,3423,2515,3691,3426,2515,
 2515,3556,3426,3574,3561,3765,3586,3740,3741,3741,2860,2836,
 5012,5013,5012,2834,2861,2838,2836,5013,5012,5012,3291,2945,
 2787,3511,3291,2804,3291,2946,3299,2876,3300,3503,3425,3425,
 4473,4484,4468,4470,4793,4469,4484,4795,4798,4789,4484,4469,
 3344,3291,2515,2515,3358,3291,3293,3358,3336,3293,3421,3421,
 3421,2786,2786,4233,4233,4233,2786,2786,2786,2786,4233,4233,
 4233,2522,3773,3359,2542,2797,3000,2904,2989,2901,3695,3582,
 3576,4614,4565,4488,4488,4527,4565,4609,4920,4918,4520,4454,
 4454,3509,3291,2518,2787,2879,2877,2883,2882,3425,3506,3428,
 4485,4469,4794,4478,4469,4467,4479,4799,4794,4484,4788,4477,
 2515,3770,3507,3701,3692,3676,3697,3741,3748,3744,2839,2835,
 5016,5019,5018,2834,2834,2865,2870,5019,5018,5016,3348,3291,
 3293,3336,3361,3293,3421,3421,3421,2786,2786,4233,4233,4233,
 2786,2786,2786,2786,4233,4233,4233,2943,2905,2987,2896,2998,
 3586,3577,3697,4577,4606,4453,4518,4458,4624,4559,4919,4920,
 4494,4489,4525,3316,2877,3305,2943,3426,3428,3507,4481,4477,
 4477,4796,4477,4477,4477,4796,4790,4481,4477,4790,2824,2531,
 2817,3769,3689,3557,4488,4495,4606,4577,4920,4458,4453,4519,
 4528,4919,4624,4559,2829,2531,3590,3696,3577,4566,4918,4526,
 4489,4496,4917,4582,4612,4611,4463,4517,4453,2824,3575,3701,
 3596,4919,4569,4517,4463,4453,4582,4917,4621,4610,4489,4526,
 4496,3556,3682,3770,4494,4489,4624,4919,4559,4453,4458,4518,
 4525,4577,4606,4920,2515,2515,5013,5012,2834,2838,2861,5012,
 5012,5013,5012,2860,2836,2837,2515,5020,5015,2866,2834,2834,
 5017,5015,5021,5017,2836,2867,2834,5019,5018,2834,2865,2834,
 5016,5018,5019,5016,2839,2835,2870,2786,5180,5182,5179,2786,
 2786,2786,2786,5181,5179,5180,5179,5180,5178,2786,2786,2786,
 2786,5179,5178,5179,2786,2786,5178,5179,5179,5178,2786,2786,
 2786,2786,5179,5180,5181,5179,2786,2786,2786,5179,5178,5180,
 5179,2786,2786,2786,2786,2786,2786,5180,5179,5178,2786,2786,
 5179,5178,5179,2786,5182,5180,5179,5180,5179,5178,2786,2786,
 2786,31,31,31,2788,2788,2702,2788,2702,2517,2537,2532,2788,
 2702,2517,2548,2702,2533,2534,2531,2731,2731,2788,2702,2551,
 2517,2726,2702,2545,2788,2545,2548,2537,2532,2731,2731,2724,
 3238,3242,3242,3238,3237,3237,3242,3241,3237,3241,3237,3242,31,
 31,2787,2787,2578,2787,2578,2516,2517,2518,2787,2578,2516,2520,
 2578,2518,2518,2518,2608,2592,2787,2578,2517,2516,2606,2578,
 2520,2787,2520,2520,2517,2518,2592,2606,2589,3018,3039,3039,
 3018,3021,3021,3039,3014,3021,3014,3021,3039,31,2786,2786,2746,
 2786,2746,2515,2515,2515,2786,2746,2515,2515,2746,2515,2515,
 2515,2747,2749,2786,2746,2515,2515,2748,2746,2515,2786,2515,
 2515,2515,2515,2749,2747,2748,3277,3278,3278,3277,3278,3278,
 3278,3277,3278,3277,3278,3278,2788,2788,2579,2788,2579,2517,
 2545,2532,2788,2579,2517,2551,2579,2533,2552,2531,2625,2631,
 2788,2579,2548,2517,2635,2579,2537,2788,2537,2551,2544,2532,
 2631,2632,2618,3054,3080,3080,3054,3060,3060,3080,3058,3060,
 3058,3060,3080,3291,3291,3291,3291,2786,3292,2861,2786,3291,
 2786,2849,3291,2850,3292,2867,3462,3527,3291,3291,3292,3291,
 3432,3291,3292,3291,2786,2786,2786,2786,3462,3432,3523,4890,
 4678,4674,4886,4667,4668,4891,4646,4657,4651,4656,4891,3291,
 3291,3291,3291,2786,2786,3291,3291,2786,2786,3291,3292,2870,
 3292,3433,3524,2786,3291,2848,2786,3461,3291,2786,3291,2849,
 3292,2870,3292,3462,3528,3431,4886,4674,4891,4656,4668,4656,
 4891,4651,4667,4652,4886,4674,3291,3291,3291,3394,3292,3291,
 2578,3291,3292,2578,3300,3371,3371,3477,3433,3291,3291,3300,
 3291,3475,3291,3323,3291,3292,3331,3292,3391,2592,2611,2607,
 4562,4602,3052,3040,3026,4592,4596,4549,4589,3015,3040,3052,
 3291,2786,2870,3292,3291,3291,3291,3292,3291,2786,2786,2786,
 3524,3433,3291,3291,2786,2786,3461,3291,2849,2786,3292,2867,
 3292,2850,3433,3525,3460,4656,4891,4891,4668,4656,4886,4674,
 4652,4668,4645,4890,4678,3291,3292,3391,3291,3291,3291,3332,
 3291,3391,3292,3331,2616,2616,3291,2578,3292,3291,2591,2578,
 3292,3291,3300,3371,3371,3300,3474,3432,3465,3040,3052,4596,
 4592,4592,3040,3052,3015,3026,4555,4562,4602,2833,2833,2786,
 3291,2786,2833,3291,2515,2786,2515,3478,3433,3291,3291,2786,
 2786,3432,3291,2833,2786,2786,2515,2786,2515,3433,3432,3480,
 4655,4874,4671,4872,4655,4872,4671,4645,4654,4643,4655,4874,
 2786,3292,3371,2786,2786,3292,2833,2515,2833,3713,3573,2786,
 3328,2515,2515,3667,3299,2515,2851,2833,2986,2833,2982,3536,
 3787,3655,4691,4780,4949,4859,4815,4756,4712,4735,4740,4808,
 4943,4868,2850,3300,2515,2515,3315,2981,2833,2982,3658,3785,
 2786,3292,2833,2786,3535,3371,2786,3292,2515,2833,2515,2833,
 3665,3572,3708,4947,4869,4708,4765,4732,4850,4942,4807,4822,
 4728,4697,4772,3291,2786,2867,3291,2861,3292,2849,3527,3462,
 3291,3291,3292,3291,3432,3291,3292,3291,2786,2786,2786,2786,
 3527,3432,3460,4668,4891,4674,4667,4886,4890,4678,4645,4656,
 4883,4657,4678,3291,3371,2578,3292,3394,3292,3433,3477,3291,
 3291,3326,3291,3476,3291,3300,3291,3397,3292,3328,3292,2617,
 2613,2587,4592,4596,3052,3026,3040,4562,4602,4555,4592,3020,
 3030,3049,2515,3291,2833,2833,2833,3433,3478,2786,3291,2833,
 2786,3432,3291,2786,3291,2515,2786,2515,2786,3481,3432,3431,
 4872,4671,4671,4655,4872,4655,4874,4643,4655,4873,4654,4671,
 3395,2982,2833,2984,3715,3671,2786,3292,2833,2786,3572,3299,
 2786,3292,2515,2833,2515,2833,3788,3535,3656,4739,4774,4827,
 4851,4948,4764,4742,4680,4698,4938,4816,4866,3315,3292,3395,
 3471,3471,3291,3291,3292,3291,3432,3291,3292,3291,3371,3299,
 3299,3371,2612,2591,2609,4591,4601,3064,3051,3051,4591,4601,
 4543,4563,3036,3033,3065,2786,2515,3785,3658,3292,3371,2786,
 2786,3535,3292,2833,2786,2833,2515,2833,2515,3710,3572,3673,
 4850,4942,4708,4732,4765,4947,4869,4807,4822,4745,4697,4731,
 2786,3573,3713,2850,3300,2515,2515,3670,3313,2515,2786,2984,
 2833,2983,2833,3662,3784,3534,4756,4712,4949,4815,4859,4691,
 4780,4734,4736,4845,4940,4826,3671,3715,3292,3300,2786,2786,
 3572,3292,2833,2786,2833,2515,2833,2515,3663,3535,3781,4764,
 4742,4827,4948,4851,4739,4774,4685,4695,4844,4821,4945,2641,
 3433,2617,3536,3433,2640,2592,3660,3473,3573,3782,3536,3664,
 3746,3747,3731,3125,3147,5009,4959,5003,3149,3154,3115,3129,
 4999,5003,4955,3462,2592,3663,3433,2641,2617,3536,3433,3672,
 3536,3782,3573,3732,3745,3742,3149,3154,5009,5003,4959,3125,
 3147,3115,3125,4951,5007,5009,3291,2866,2786,3525,3291,2786,
 3291,2862,3292,2850,3292,3524,3461,3431,4667,4674,4678,4657,
 4890,4657,4678,4883,4886,4884,4667,4674,3371,3291,2613,2578,
 3397,3291,3292,3393,3292,3327,3433,3476,3465,3026,3052,4602,
 4589,4562,3030,3049,3020,3040,4542,4589,4602,2515,3786,3396,
 2515,2786,2986,2833,2985,2833,3715,3666,3571,4860,4827,4741,
 4698,4757,4821,4867,4941,4946,4747,4744,4703,3479,3291,2515,
 2786,2833,2833,2833,2833,3433,3479,3431,4655,4671,4874,4654,
 4655,4654,4671,4873,4872,4643,4871,4671,2613,3786,3526,3714,
 3659,3661,3711,3747,3730,3741,3133,3153,4953,5001,5008,3128,
 3152,3139,3137,4997,4956,5009,3371,3291,3315,3292,3392,3292,
 3470,3466,3431,3051,3064,4601,4563,4591,3033,3065,3037,3051,
 4557,4588,4597,2868,2833,2985,2833,2982,3573,3668,3709,4815,
 4870,4743,4766,4691,4853,4826,4939,4944,4686,4738,4773,3292,
 2852,3292,2859,3433,3472,3522,4658,4679,4679,4888,4658,4669,
 4673,4885,4888,4643,4670,4892,2786,2515,2786,3789,3661,3534,
 4737,4712,4870,4815,4944,4691,4743,4767,4759,4939,4853,4826,
 2786,2515,3573,3712,3669,4821,4945,4774,4739,4698,4948,4827,
 4843,4852,4680,4764,4742,2786,3674,3714,3571,4940,4826,4780,
 4691,4740,4815,4949,4843,4858,4735,4756,4712,3536,3657,3783,
 4697,4731,4869,4947,4822,4732,4708,4746,4753,4807,4850,4942,
 2641,2639,4950,5010,3156,3130,3141,4998,4957,4994,4998,3158,
 3126,3156,2638,5004,5011,3150,3127,3131,5008,5011,4958,4954,
 3113,3160,3155,5005,4956,3151,3136,3123,4952,5006,4995,5001,
 3110,3122,3159,3081,5170,5172,5144,3069,3074,3044,3072,5147,
 5167,5176,5177,5148,5170,3074,3086,3069,3081,5169,5176,5146,
 3081,3081,5170,5177,5147,5148,3069,3074,3086,3072,5144,5170,
 5169,5173,3044,3069,3074,5172,5148,5168,5172,3034,3068,3085,
 3081,3043,3068,5168,5172,5148,3072,3085,5147,5170,5177,3034,
 5173,5148,5175,5171,5145,5174,3043,3071,3081,31,31,2830,2830,
 2579,2830,2579,2579,2588,2610,2830,2579,2579,2596,2579,2599,
 2594,2595,2621,2622,2830,2579,2602,2579,2637,2579,2610,2830,
 2610,2596,2588,2610,2623,2619,2628,3076,3059,3059,3076,3056,
 3056,3059,3077,3056,3077,3056,3059,31,2788,2788,2702,2788,2702,
 2517,2539,2531,2788,2702,2517,2531,2702,2556,2537,2543,2724,
 2731,2788,2702,2545,2517,2731,2702,2546,2788,2546,2531,2539,
 2531,2731,2726,2731,3236,3238,3238,3236,3240,3240,3238,3243,
 3240,3243,3240,3238,2830,2830,2579,2830,2579,2568,2570,2573,
 2830,2579,2568,2576,2579,2572,2574,2569,2620,2634,2830,2579,
 2576,2568,2629,2579,2571,2830,2571,2576,2570,2573,2633,2624,
 2627,3054,3075,3075,3054,3032,3032,3075,3079,3032,3079,3032,
 3075,3291,3291,3291,3291,2787,3300,2936,2787,3291,2787,2872,
 3291,2873,3299,2936,3431,3488,3291,3291,3318,3291,3444,3291,
 3307,3291,2794,2789,2810,2810,3433,3443,3484,4876,4655,4661,
 4875,4643,4644,4875,4675,4648,4671,4647,4876,3291,3291,3291,
 3291,2810,2810,3291,3291,2787,2789,3291,3312,2936,3299,3441,
 3486,2787,3291,2875,2787,3433,3291,2794,3291,2875,3299,2936,
 3300,3433,3484,3443,4875,4661,4875,4661,4644,4647,4876,4671,
 4643,4671,4875,4664,3291,3291,3291,3403,3336,3291,2578,3291,
 3293,2578,3301,3375,3375,3442,3467,3291,3291,3303,3291,3452,
 3291,3307,3291,3295,3299,3336,3403,2592,2615,2615,4590,4579,
 3051,3051,3017,4551,4590,4599,4550,3064,3028,3038,3291,2787,
 2936,3300,3291,3291,3291,3299,3291,2797,2797,2790,3487,3447,
 3291,3291,2794,2787,3433,3291,2875,2787,3318,2936,3299,2872,
 3444,3483,3432,4661,4875,4876,4655,4647,4875,4664,4671,4644,
 4675,4877,4653,3291,3336,3403,3291,3291,3291,3299,3291,3404,
 3339,3299,2609,2612,3291,2578,3295,3291,2592,2578,3295,3291,
 3303,3373,3373,3299,3453,3469,3448,3051,3051,4590,4579,4551,
 3028,3038,3064,3017,4599,4556,4583,2878,2878,2787,3291,2787,
 2879,3291,2526,2791,2519,3523,3444,3291,3291,2794,2787,3444,
 3291,2887,2787,2794,2518,2791,2518,3444,3446,3528,4664,4889,
 4664,4889,4649,4884,4660,4676,4648,4676,4649,4887,2829,3299,
 3373,2791,2820,3293,2891,2542,2908,3719,3632,2791,3299,2535,
 2521,3608,3299,2541,2872,2915,2993,2931,2999,3551,3758,3645,
 4720,4778,4929,4856,4814,4749,4714,4719,4684,4831,4924,4854,
 2872,3299,2518,2531,3299,3003,2935,2987,3640,3752,2791,3293,
 2915,2791,3551,3374,2829,3310,2535,2899,2542,2931,3608,3630,
 3718,4929,4856,4720,4778,4682,4841,4935,4831,4814,4719,4717,
 4758,3291,2787,2936,3291,2936,3300,2872,3487,3433,3291,3291,
 3307,3291,3447,3291,3318,3291,2805,2799,2791,2791,3488,3446,
 3432,4655,4876,4664,4653,4875,4877,4653,4675,4647,4881,4648,
 4655,3291,3373,2578,3340,3402,3293,3464,3457,3291,3291,3307,
 3291,3457,3291,3303,3291,3406,3338,3299,3293,2617,2613,2591,
 4579,4590,3038,3033,3028,4556,4583,4599,4551,3066,3037,3033,
 2518,3291,2883,2877,2877,3441,3527,2787,3291,2887,2787,3447,
 3291,2794,3291,2528,2789,2522,2791,3524,3443,3443,4889,4664,
 4660,4662,4884,4649,4887,4676,4649,4891,4648,4663,3398,2987,
 2901,3000,3725,3608,2799,3338,2910,2789,3629,3299,2821,3317,
 2555,2913,2531,2918,3760,3542,3643,4701,4755,4825,4846,4926,
 4760,4692,4727,4716,4934,4809,4847,3300,3293,3401,3445,3449,
 3291,3291,3298,3291,3435,3291,3298,3291,3378,3299,3299,3374,
 2617,2591,2613,4580,4580,3025,3029,3019,4544,4578,4595,4541,
 3053,3015,3041,2817,2532,3750,3649,3300,3376,2825,2791,3548,
 3294,2921,2790,2934,2553,2916,2533,3726,3639,3617,4849,4932,
 4721,4693,4763,4925,4848,4828,4811,4770,4724,4702,2822,3622,
 3720,2872,3299,2540,2522,3614,3299,2535,2790,3004,2893,2987,
 2908,3644,3754,3550,4769,4729,4923,4818,4837,4709,4781,4705,
 4688,4864,4937,4820,3604,3716,3300,3299,2828,2791,3623,3293,
 2892,2815,2912,2531,2935,2542,3648,3550,3754,4781,4694,4818,
 4923,4836,4687,4769,4730,4710,4864,4813,4931,2639,3441,2609,
 3537,3441,2639,2587,3642,3431,3626,3756,3539,3606,3738,3735,
 3741,3124,3140,4977,5005,4966,3134,3122,3151,3109,4989,4976,
 5001,3433,2592,3654,3447,2641,2616,3547,3456,3619,3543,3762,
 3633,3743,3737,3734,3143,3130,4987,4967,4994,3116,3148,3156,
 3116,5010,4960,4985,3291,2936,2787,3486,3291,2805,3291,2936,
 3302,2872,3299,3486,3432,3446,4653,4664,4653,4664,4877,4648,
 4655,4881,4875,4881,4643,4661,3377,3291,2612,2578,3406,3291,
 3341,3400,3293,3299,3467,3450,3450,3033,3038,4583,4583,4556,
 3036,3033,3065,3028,4600,4550,4579,2529,3749,3407,2558,2816,
 2987,2907,3006,2933,3722,3618,3635,4855,4819,4700,4713,4750,
 4812,4857,4930,4927,4777,4683,4722,3527,3291,2529,2787,2885,
 2877,2877,2877,3447,3525,3446,4662,4660,4887,4663,4649,4648,
 4663,4891,4884,4676,4883,4662,2616,3757,3492,3722,3646,3644,
 3721,3733,3745,3739,3129,3125,5007,4962,4984,3115,3125,3147,
 3138,4969,4999,4971,3378,3291,3307,3293,3402,3293,3451,3448,
 3434,3029,3025,4578,4564,4544,3015,3041,3053,3019,4598,4546,
 4564,2940,2927,3004,2922,2992,3631,3621,3729,4819,4855,4696,
 4762,4704,4839,4817,4930,4928,4725,4690,4775,3322,2872,3320,
 2939,3459,3432,3489,4665,4658,4659,4880,4650,4643,4666,4879,
 4878,4677,4643,4882,2821,2541,2829,3749,3650,3549,4700,4713,
 4855,4819,4928,4704,4696,4777,4752,4930,4839,4817,2820,2531,
 3628,3728,3609,4824,4933,4755,4701,4716,4926,4825,4862,4833,
 4727,4760,4692,2829,3611,3718,3630,4935,4823,4778,4720,4684,
 4814,4929,4863,4840,4719,4749,4714,3554,3645,3758,4714,4699,
 4856,4929,4814,4682,4720,4779,4751,4832,4841,4935,2641,2641,
 5007,4962,3129,3125,3157,4978,5003,4969,4984,3147,3115,3129,
 2640,4973,4972,3161,3127,3111,4970,4965,5011,5002,3155,3144,
 3131,4965,5004,3127,3161,3113,5000,4973,4963,4980,3155,3113,
 3145,3071,5151,5160,5169,3044,3073,3085,3042,5169,5166,5152,
 5160,5173,5155,3047,3068,3085,3046,5164,5154,5172,3071,3046,
 5155,5160,5169,5171,3085,3047,3068,3042,5169,5151,5164,5149,
 3085,3044,3073,5160,5171,5156,5160,3073,3024,3044,3046,3071,
 3024,5156,5160,5171,3082,3044,5169,5155,5160,3073,5162,5175,
 5150,5153,5173,5161,3072,3082,3046,31,2788,2788,2579,2788,2579,
 2517,2537,2552,2788,2579,2517,2549,2579,2531,2538,2533,2624,
 2629,2788,2579,2543,2517,2620,2579,2545,2788,2545,2549,2537,
 2552,2629,2634,2627,3055,3078,3078,3055,3077,3077,3078,3054,
 3077,3054,3077,3078,2830,2830,2515,2830,2515,2579,2596,2599,
 2830,2515,2579,2610,2515,2610,2595,2590,2515,2515,2830,2515,
 2588,2579,2515,2515,2602,2830,2602,2610,2596,2599,2515,2515,
 2515,2786,2786,2786,2786,2786,2786,2786,2786,2786,2786,2786,
 2786,3291,3291,3291,3291,2787,3299,2947,2787,3291,2787,2880,
 3291,2876,3300,2947,3422,3512,3291,3291,3299,3291,3423,3291,
 3314,3291,2794,2794,2798,2801,3422,3422,3512,4792,4473,4470,
 4792,4468,4484,4789,4469,4484,4484,4469,4795,3291,3291,3291,
 3291,2798,2801,3291,3291,2787,2794,3291,3299,2946,3319,3423,
 3508,2787,3291,2876,2787,3422,3291,2794,3291,2880,3314,2945,
 3300,3425,3503,3422,4792,4470,4789,4470,4484,4469,4795,4484,
 4468,4468,4793,4468,3291,3291,3291,3358,3294,3291,2515,3291,
 3342,2515,3293,3343,3343,3421,3421,3291,3291,3293,3291,3421,
 3291,3296,3291,3342,3295,3293,3358,2515,2515,2515,4233,4233,
 2786,2786,2786,4233,4233,4233,4233,2786,2786,2786,3291,2787,
 2945,3300,3291,3291,3291,3314,3291,2807,2804,2791,3511,3422,
 3291,3291,2791,2787,3422,3291,2880,2787,3307,2950,3300,2877,
 3422,3503,3425,4470,4789,4795,4470,4469,4793,4468,4468,4484,
 4484,4798,4467,3291,3293,3358,3291,3291,3291,3295,3291,3358,
 3293,3294,2515,2515,3291,2515,3336,3291,2515,2515,3342,3291,
 3295,3351,3344,3294,3421,3421,3421,2786,2786,4233,4233,4233,
 2786,2786,2786,2786,4233,4233,4233,2878,2881,2787,3291,2787,
 2889,3291,2519,2791,2526,3509,3423,3291,3291,2791,2787,3429,
 3291,2890,2787,2794,2530,2789,2527,3430,3425,3506,4472,4791,
 4471,4797,4477,4788,4484,4477,4479,4479,4467,4799,2818,3300,
 3344,2789,2821,3338,2919,2542,2895,3700,3578,2789,3293,2531,
 2522,3576,3293,2541,2877,2910,3004,2902,2987,3559,3772,3675,
 4459,4520,4920,4615,4565,4527,4489,4488,4454,4565,4918,4626,
 2877,3294,2527,2546,3294,2994,2904,3007,3687,3776,2791,3340,
 2891,2792,3570,3350,2827,3325,2546,2934,2553,2909,3598,3581,
 3706,4922,4619,4460,4523,4461,4614,4922,4584,4585,4498,4490,
 4533,3291,2787,2950,3291,2944,3299,2877,3504,3422,3291,3291,
 3304,3291,3425,3291,3307,3291,2813,2813,2789,2791,3512,3422,
 3422,4470,4795,4468,4470,4793,4798,4467,4484,4469,4798,4484,
 4473,3291,3351,2515,3293,3358,3340,3421,3421,3291,3291,3293,
 3291,3421,3291,3295,3291,3358,3295,3293,3340,2515,2515,2515,
 4233,4233,2786,2786,2786,4233,4233,4233,4233,2786,2786,2786,
 2530,3291,2877,2879,2888,3422,3505,2787,3291,2883,2787,3428,
 3291,2794,3291,2529,2794,2522,2792,3506,3425,3430,4797,4471,
 4484,4482,4788,4467,4799,4479,4477,4794,4469,4485,3365,3006,
 2926,2991,3707,3603,2813,3295,2922,2794,3589,3295,2829,3321,
 2558,2911,2535,2897,3771,3560,3694,4501,4534,4567,4623,4921,
 4522,4465,4457,4492,4921,4567,4632,3293,3339,3362,3421,3421,
 3291,3291,3293,3291,3421,3291,3295,3291,3353,3295,3293,3350,
 2515,2515,2515,4233,4233,2786,2786,2786,4233,4233,4233,4233,
 2786,2786,2786,2824,2532,3773,3688,3304,3346,2829,2791,3567,
 3336,2930,2791,2922,2554,2904,2533,3696,3590,3583,4631,4919,
 4463,4459,4517,4917,4612,4582,4569,4526,4496,4488,2817,3591,
 3698,2876,3293,2531,2518,3583,3293,2535,2792,2995,2917,3000,
 2898,3689,3769,3555,4529,4494,4919,4561,4624,4458,4519,4453,
 4489,4606,4920,4560,3601,3706,3300,3294,2823,2792,3585,3294,
 2921,2803,2934,2546,2900,2558,3686,3568,3776,4523,4464,4586,
 4922,4630,4498,4532,4490,4455,4614,4584,4919,2515,3425,2515,
 3567,3422,2515,2515,3685,3427,3589,3778,3562,3597,3745,3741,
 3748,2841,2869,5019,5022,5016,2862,2834,2836,2834,5018,5016,
 5019,3425,2515,3678,3427,2515,2515,3566,3429,3600,3564,3764,
 3584,3744,3741,3743,2864,2841,5021,5022,5017,2835,2863,2834,
 2834,5015,5017,5021,3291,2944,2787,3504,3291,2813,3291,2950,
 3307,2876,3319,3508,3423,3422,4470,4468,4467,4470,4798,4484,
 4473,4798,4793,4793,4468,4470,3346,3291,2515,2515,3358,3291,
 3295,3358,3339,3294,3421,3421,3421,2786,2786,4233,4233,4233,
 2786,2786,2786,2786,4233,4233,4233,2518,3773,3361,2554,2806,
 3006,2930,2989,2916,3701,3575,3594,4631,4566,4489,4497,4526,
 4582,4621,4917,4918,4517,4453,4462,3513,3291,2529,2787,2885,
 2885,2881,2888,3422,3502,3427,4482,4484,4799,4482,4467,4469,
 4485,4794,4788,4469,4794,4478,2515,3778,3507,3707,3685,3681,
 3703,3748,3741,3745,2841,2834,5019,5022,5018,2836,2846,2862,
 2870,5016,5018,5019,3353,3291,3296,3341,3359,3294,3421,3421,
 3421,2786,2786,4233,4233,4233,2786,2786,2786,2786,4233,4233,
 4233,2952,2911,2987,2925,3008,3588,3595,3705,4572,4618,4466,
 4524,4457,4617,4574,4921,4921,4492,4500,4535,3324,2885,3301,
 2949,3428,3426,3510,4486,4480,4481,4800,4477,4477,4481,4790,
 4790,4477,4477,4796,2829,2541,2827,3779,3684,3564,4501,4493,
 4618,4572,4921,4457,4466,4522,4531,4921,4617,4574,2821,2546,
 3587,3702,3600,4572,4917,4534,4501,4492,4921,4567,4617,4616,
 4457,4522,4465,2818,3582,3695,3580,4917,4570,4520,4459,4454,
 4565,4920,4609,4607,4488,4527,4489,3569,3679,3780,4491,4499,
 4619,4922,4585,4461,4460,4521,4530,4584,4614,4922,2515,2515,
 5022,5021,2836,2846,2867,5017,5021,5015,5017,2866,2834,2841,
 2515,5014,5013,2860,2838,2836,5012,5013,5012,5012,2834,2861,
 2835,5022,5020,2842,2864,2834,5015,5020,5017,5015,2835,2834,
 2871,2786,5183,5184,5181,2786,2786,2786,2786,5181,5181,5183,
 5182,5183,5180,2786,2786,2786,2786,5179,5180,5182,2786,2786,
 5180,5182,5179,5180,2786,2786,2786,2786,5181,5183,5181,5181,
 2786,2786,2786,5179,5180,5178,5179,2786,2786,2786,2786,2786,
 2786,5178,5179,5180,2786,2786,5179,5180,5182,2786,5179,5178,
 5179,5178,5179,5180,2786,2786,2786,2788,2788,2579,2788,2579,
 2517,2551,2537,2788,2579,2517,2544,2579,2552,2533,2547,2632,
 2630,2788,2579,2531,2517,2618,2579,2532,2788,2532,2545,2551,
 2537,2631,2625,2635,3058,3060,3060,3058,3080,3080,3060,3054,
 3080,3054,3080,3060,3291,3291,3291,3291,2786,3292,2862,2786,
 3291,2786,2850,3291,2850,3292,2866,3461,3524,3291,3291,3292,
 3291,3431,3291,3292,3291,2786,2786,2786,2786,3462,3433,3525,
 4884,4667,4657,4883,4678,4678,4890,4657,4674,4667,4674,4886,
 3291,3291,3291,3291,2786,2786,3291,3291,2786,2786,3291,3292,
 2861,3292,3432,3527,2786,3291,2849,2786,3460,3291,2786,3291,
 2850,3292,2867,3292,3462,3527,3432,4883,4657,4890,4645,4678,
 4674,4886,4667,4678,4668,4891,4656,3291,3291,3291,3393,3292,
 3291,2578,3291,3292,2578,3300,3371,3371,3476,3433,3291,3291,
 3300,3291,3465,3291,3327,3291,3292,3328,3292,3397,2592,2617,
 2613,4542,4589,3030,3020,3049,4602,4562,4589,4602,3026,3052,
 3040,3291,2786,2867,3292,3291,3291,3291,3292,3291,2786,2786,
 2786,3525,3433,3291,3291,2786,2786,3460,3291,2850,2786,3292,
 2870,3292,2849,3433,3524,3461,4645,4890,4886,4652,4674,4891,
 4656,4668,4678,4656,4891,4668,3291,3292,3397,3291,3291,3291,
 3328,3291,3394,3292,3326,2613,2617,3291,2578,3292,3291,2587,
 2578,3292,3291,3300,3371,3371,3300,3477,3433,3476,3020,3030,
 4562,4555,4602,3052,3040,3026,3049,4592,4596,4592,2833,2833,
 2786,3291,2786,2833,3291,2515,2786,2515,3479,3433,3291,3291,
 2786,2786,3431,3291,2833,2786,2786,2515,2786,2515,3433,3433,
 3479,4643,4871,4654,4873,4671,4874,4655,4654,4671,4655,4671,
 4872,2786,3292,3371,2786,2786,3292,2833,2515,2833,3712,3573,
 2786,3331,2515,2515,3669,3299,2515,2852,2833,2986,2833,2985,
 3536,3782,3659,4680,4764,4948,4843,4827,4774,4698,4739,4742,
 4821,4945,4852,2849,3300,2515,2515,3315,2984,2833,2986,3661,
 3789,2786,3292,2833,2786,3534,3371,2786,3292,2515,2833,2515,
 2833,3672,3573,3714,4939,4853,4691,4767,4743,4870,4944,4815,
 4826,4737,4712,4759,3291,2786,2870,3291,2870,3292,2848,3528,
 3462,3291,3291,3292,3291,3431,3291,3292,3291,2786,2786,2786,
 2786,3524,3433,3461,4652,4886,4656,4651,4891,4891,4668,4656,
 4674,4886,4674,4667,3291,3371,2578,3292,3391,3292,3432,3474,
 3291,3291,3331,3291,3465,3291,3300,3291,3391,3292,3331,3292,
 2616,2616,2591,4555,4562,3040,3015,3052,4596,4592,4592,4602,
 3040,3052,3026,2515,3291,2833,2833,2833,3432,3481,2786,3291,
 2833,2786,3431,3291,2786,3291,2515,2786,2515,2786,3478,3433,
 3432,4873,4654,4655,4643,4874,4671,4872,4655,4671,4872,4671,
 4655,3392,2983,2833,2985,3714,3674,2786,3292,2833,2786,3571,
 3299,2786,3292,2515,2833,2515,2833,3782,3536,3661,4735,4756,
 4815,4843,4949,4780,4740,4691,4712,4940,4826,4858,3313,3292,
 3396,3466,3470,3291,3291,3292,3291,3431,3291,3292,3291,3371,
 3299,3299,3371,2617,2592,2613,4557,4588,3033,3037,3065,4601,
 4591,4563,4597,3051,3064,3051,2786,2515,3784,3662,3292,3371,
 2786,2786,3534,3292,2833,2786,2833,2515,2833,2515,3713,3573,
 3670,4845,4940,4691,4734,4780,4949,4859,4815,4826,4756,4712,
 4736,2786,3572,3710,2850,3300,2515,2515,3673,3315,2515,2786,
 2981,2833,2982,2833,3658,3785,3535,4745,4697,4947,4807,4869,
 4708,4765,4732,4731,4850,4942,4822,3666,3715,3292,3300,2786,
 2786,3571,3292,2833,2786,2833,2515,2833,2515,3663,3536,3786,
 4747,4744,4821,4941,4867,4741,4757,4698,4703,4860,4827,4946,
 2640,3432,2611,3535,3432,2638,2591,3657,3472,3572,3787,3535,
 3668,3745,3747,3730,3113,3160,5008,4958,5011,3150,3131,3127,
 3155,5004,5011,4954,3462,2592,3663,3433,2639,2612,3536,3433,
 3665,3536,3788,3573,3732,3746,3747,3158,3126,4998,4994,4957,
 3156,3141,3130,3156,4950,5010,4998,3291,2867,2786,3523,3291,
 2786,3291,2861,3292,2849,3292,3527,3462,3432,4651,4656,4668,
 4646,4891,4674,4667,4886,4891,4890,4678,4657,3371,3291,2607,
 2578,3391,3291,3292,3394,3292,3323,3433,3477,3475,3015,3040,
 4592,4549,4596,3052,3026,3040,3052,4562,4602,4589,2515,3781,
 3395,2515,2786,2982,2833,2984,2833,3715,3671,3572,4844,4821,
 4739,4685,4774,4827,4851,4948,4945,4764,4742,4695,3480,3291,
 2515,2786,2833,2833,2833,2833,3433,3478,3432,4643,4655,4872,
 4645,4671,4671,4655,4872,4874,4655,4874,4654,2609,3783,3522,
 3708,3655,3656,3709,3742,3731,3741,3110,3122,4952,4995,5006,
 3151,3123,3136,3159,5005,4956,5001,3371,3291,3315,3292,3395,
 3292,3471,3471,3432,3037,3033,4591,4543,4601,3064,3051,3051,
 3065,4591,4601,4563,2859,2833,2982,2833,2982,3573,3664,3711,
 4807,4850,4732,4746,4708,4869,4822,4947,4942,4697,4731,4753,
 3292,2851,3292,2868,3433,3473,3526,4643,4670,4669,4885,4673,
 4679,4658,4888,4892,4658,4679,4888,2786,2515,2786,3785,3658,
 3535,4728,4697,4850,4807,4942,4708,4732,4765,4772,4947,4869,
 4822,2786,2515,3573,3713,3667,4808,4943,4756,4735,4712,4949,
 4815,4859,4868,4691,4780,4740,2786,3671,3715,3572,4938,4816,
 4764,4680,4742,4827,4948,4851,4866,4739,4774,4698,3536,3660,
 3786,4686,4738,4853,4939,4826,4743,4691,4766,4773,4815,4870,
 4944,2640,2640,4951,5007,3125,3115,3147,5009,4959,5003,5009,
 3149,3154,3125,2640,4999,5003,3149,3114,3154,5009,5003,4959,
 4955,3125,3147,3129,4997,4956,3128,3139,3152,4953,5008,5001,
 5009,3132,3153,3137,3043,5168,5173,5147,3069,3034,3044,3071,
 5147,5169,5171,5172,5148,5170,3074,3068,3069,3081,5167,5176,
 5145,3043,3081,5170,5172,5144,5148,3069,3074,3068,3071,5147,
 5168,5169,5175,3044,3069,3034,5177,5148,5170,5177,3074,3086,
 3085,3081,3081,3086,5170,5177,5148,3071,3085,5144,5170,5172,
 3074,5172,5148,5173,5176,5146,5174,3081,3071,3081,3291,3291,
 3291,3291,2787,3318,2945,2787,3291,2787,2880,3291,2877,3334,
 2942,3422,3502,3291,3291,3300,3291,3427,3291,3311,3291,2791,
 2793,2814,2808,3425,3429,3506,4783,4484,4478,4782,4484,4475,
 4785,4479,4478,4467,4487,4787,3291,3291,3291,3291,2814,2808,
 3291,3291,2787,2794,3291,3311,2948,3311,3428,3502,2787,3291,
 2876,2787,3422,3291,2791,3291,2876,3329,2951,3300,3424,3509,
 3430,4782,4478,4785,4477,4475,4487,4787,4467,4484,4469,4787,
 4487,3291,3291,3291,3364,3293,3291,2515,3291,3341,2515,3294,
 3349,3345,3421,3421,3291,3291,3293,3291,3421,3291,3293,3291,
 3338,3295,3295,3360,2515,2515,2515,4233,4233,2786,2786,2786,
 4233,4233,4233,4233,2786,2786,2786,3291,2787,2951,3300,3291,
 3291,3291,3329,3291,2802,2802,2789,3513,3426,3291,3291,2789,
 2787,3423,3291,2876,2787,3300,2951,3330,2876,3426,3513,3423,
 4477,4785,4787,4469,4487,4787,4487,4469,4475,4477,4785,4475,
 3291,3295,3360,3291,3291,3291,3295,3291,3363,3294,3293,2515,
 2515,3291,2515,3336,3291,2515,2515,3337,3291,3293,3352,3352,
 3293,3421,3421,3421,2786,2786,4233,4233,4233,2786,2786,2786,
 2786,4233,4233,4233,2884,2878,2787,3291,2787,2886,3291,2526,
 2791,2519,3511,3422,3291,3291,2789,2787,3422,3291,2877,2787,
 2791,2528,2793,2521,3423,3424,3508,4484,4786,4468,4784,4467,
 4785,4474,4468,4476,4484,4474,4785,2829,3329,3352,2794,2829,
 3342,2921,2524,2910,3704,3579,2794,3295,2535,2529,3603,3295,
 2541,2885,2932,3009,2911,2997,3560,3766,3694,4449,4516,4916,
 4617,4575,4540,4506,4510,4452,4567,4914,4633,2876,3293,2522,
 2540,3293,2990,2916,3001,3693,3774,2791,3338,2928,2791,3561,
 3346,2829,3312,2531,2932,2555,2920,3575,3592,3701,4912,4613,
 4450,4512,4447,4622,4911,4569,4566,4502,4509,4537,3291,2787,
 2951,3291,2948,3311,2876,3509,3425,3291,3291,3311,3291,3430,
 3291,3300,3291,2809,2814,2794,2791,3502,3428,3422,4469,4787,
 4487,4467,4787,4785,4475,4477,4487,4782,4478,4484,3291,3352,
 2515,3294,3363,3336,3421,3421,3291,3291,3293,3291,3421,3291,
 3293,3291,3360,3295,3295,3338,2515,2515,2515,4233,4233,2786,
 2786,2786,4233,4233,4233,4233,2786,2786,2786,2529,3291,2883,
 2883,2879,3423,3503,2787,3291,2879,2787,3425,3291,2791,3291,
 2522,2794,2529,2791,3503,3423,3425,4784,4468,4474,4484,4785,
 4474,4785,4484,4467,4784,4468,4467,3358,3008,2934,2995,3707,
 3595,2814,3295,2907,2794,3588,3295,2829,3321,2554,2911,2546,
 2930,3777,3565,3683,4510,4540,4576,4616,4916,4516,4452,4449,
 4507,4913,4567,4618,3294,3340,3358,3421,3421,3291,3291,3293,
 3291,3421,3291,3293,3291,3346,3296,3296,3347,2515,2515,2515,
 4233,4233,2786,2786,2786,4233,4233,4233,4233,2786,2786,2786,
 2822,2532,3775,3680,3334,3349,2819,2791,3569,3340,2891,2795,
 2916,2524,2934,2533,3699,3585,3599,4628,4912,4448,4451,4515,
 4915,4620,4585,4587,4539,4505,4511,2819,3585,3699,2877,3294,
 2532,2526,3599,3294,2533,2796,2990,2921,3008,2891,3680,3775,
 3569,4539,4505,4915,4585,4620,4448,4515,4451,4511,4627,4912,
 4587,3577,3695,3300,3293,2817,2789,3580,3293,2899,2797,2928,
 2535,2907,2517,3690,3558,3767,4514,4446,4581,4912,4625,4504,
 4536,4502,4446,4608,4571,4913,2515,3429,2515,3558,3425,2515,
 2515,3677,3427,3592,3766,3565,3576,3741,3744,3745,2835,2856,
 4993,4992,4993,2857,2847,2836,2843,4992,4993,4993,3425,2515,
 3690,3423,2515,2515,3561,3426,3575,3560,3777,3590,3740,3741,
 3741,2853,2835,4991,4990,4991,2842,2854,2836,2835,4990,4991,
 4991,3291,2942,2787,3506,3291,2809,3291,2945,3318,2880,3311,
 3502,3422,3427,4467,4487,4475,4479,4785,4478,4484,4782,4787,
 4783,4484,4478,3345,3291,2515,2515,3360,3291,3293,3364,3341,
 3293,3421,3421,3421,2786,2786,4233,4233,4233,2786,2786,2786,
 2786,4233,4233,4233,2519,3767,3358,2517,2797,3001,2910,2995,
 2899,3695,3577,3580,4608,4571,4504,4502,4536,4581,4625,4912,
 4913,4514,4446,4446,3508,3291,2522,2787,2878,2885,2886,2877,
 3422,3511,3422,4484,4474,4785,4468,4474,4468,4467,4784,4785,
 4484,4786,4476,2515,3763,3510,3701,3694,3683,3696,3741,3745,
 3743,2834,2844,4993,4992,4993,2834,2836,2855,2858,4992,4993,
 4993,3346,3291,3293,3342,3358,3293,3421,3421,3421,2786,2786,
 4233,4233,4233,2786,2786,2786,2786,4233,4233,4233,2941,2920,
 2997,2930,2999,3590,3576,3696,4569,4622,4447,4513,4450,4613,
 4566,4912,4911,4508,4503,4538,3312,2885,3321,2941,3426,3427,
 3510,4477,4483,4480,4782,4480,4480,4480,4782,4786,4477,4483,
 4786,2829,2540,2829,3774,3693,3561,4502,4509,4622,4569,4911,
 4450,4447,4512,4537,4912,4613,4566,2829,2541,3579,3704,3603,
 4567,4914,4540,4510,4506,4916,4576,4617,4633,4449,4516,4452,
 2829,3595,3707,3588,4913,4567,4516,4449,4452,4576,4916,4616,
 4618,4510,4540,4507,3561,3677,3763,4508,4503,4613,4912,4566,
 4447,4450,4513,4538,4569,4622,4911,2515,2515,4990,4991,2842,
 2836,2854,4991,4991,4990,4991,2853,2835,2835,2515,4992,4993,
 2857,2837,2847,4993,4993,4992,4993,2835,2856,2843,4992,4993,
 2834,2855,2836,4993,4993,4992,4993,2834,2844,2858,2786,5158,
 5157,5158,2786,2786,2786,2786,5157,5158,5158,5159,5158,5159,
 2786,2786,2786,2786,5158,5159,5159,2786,2786,5159,5159,5158,
 5159,2786,2786,2786,2786,5158,5158,5157,5158,2786,2786,2786,
 5159,5159,5158,5159,2786,2786,2786,2786,2786,2786,5158,5159,
 5159,2786,2786,5158,5159,5159,2786,5157,5158,5158,5158,5159,
 5159,2786,2786,2786,116,116,116,116,123,142,116,116,116,117,
 116,117,132,132,151,194,116,116,117,116,151,116,117,116,117,
 117,142,123,151,175,175,1068,714,1124,1124,892,714,1068,714,
 714,892,1124,1124,116,116,116,131,132,116,116,116,117,116,
 117,123,142,151,178,116,116,117,116,151,116,117,116,117,117,
 123,142,151,170,191,1054,714,880,1063,715,714,1054,714,714,
 715,880,1063,116,116,121,121,116,116,116,117,116,118,118,121,
 168,168,116,116,117,116,151,116,117,116,117,121,118,118,151,
 168,168,1116,1116,1116,1116,892,1116,1116,892,892,892,1116,
 1116,116,117,148,116,116,116,117,116,132,117,132,170,191,116,
 116,117,116,151,116,117,116,117,119,138,119,151,151,178,1063,
 880,714,1054,714,880,1063,715,715,714,714,1054,117,46,31,116,
 31,32,116,39,117,50,175,175,116,116,117,116,151,116,117,116,
 31,31,31,31,151,151,194,1124,1124,714,1068,714,1124,1124,892,
 892,714,714,1068,161,117,118,117,151,117,152,117,164,216,225,
 117,117,151,118,200,117,151,117,152,166,169,185,199,315,228,
 1130,903,1431,1265,997,911,1111,893,892,997,1431,1265,35,121,
 50,58,132,71,164,62,221,300,121,121,164,121,204,142,161,132,
 35,35,50,43,208,208,258,1365,923,907,1170,907,918,1395,895,
 896,914,914,1171,116,31,35,116,35,117,35,168,168,116,116,
 117,116,151,116,117,116,31,31,31,31,168,151,168,1115,1115,
 892,1115,1115,1115,1115,892,892,1115,892,1115,116,118,116,117,
 121,121,151,168,116,116,117,116,151,116,117,116,121,117,118,
 118,162,162,168,1047,714,731,1044,731,714,1047,714,714,731,
 731,1044,39,116,32,117,46,151,194,116,116,117,116,151,116,
 117,116,31,31,31,31,175,151,175,1067,714,892,1124,1124,714,
 1067,714,714,1124,892,1124,132,62,152,71,216,225,118,117,152,
 117,200,117,151,117,33,32,32,32,315,199,228,1112,911,997,
 1265,1431,903,1130,892,893,1431,997,1265,117,117,148,151,178,
 116,116,117,116,151,116,117,116,119,117,119,138,170,151,191,
 1052,714,715,1063,880,714,1052,714,714,880,715,1063,151,58,
 315,228,117,118,151,117,199,117,152,117,32,33,32,32,216,200,
 225,1265,1431,892,1130,903,1431,1265,997,997,911,893,1111,161,
 200,240,117,117,151,118,200,117,151,117,166,152,185,169,205,
 312,213,1150,898,1426,1224,999,894,1155,894,898,999,1426,1224,
 208,258,121,121,161,121,208,131,163,142,35,35,43,50,221,204,
 300,1170,907,897,1365,923,914,1173,914,907,918,895,1395,270,
 151,162,199,151,265,151,205,151,200,306,201,205,277,277,290,
 1452,1073,1499,1542,1499,1073,1452,1280,1280,1499,1499,1542,
 168,168,228,168,270,191,213,176,219,210,323,249,290,290,277,
 1044,1194,1522,1493,1521,1194,1053,1194,1194,1523,1523,1511,
 116,121,116,168,116,118,116,121,117,118,118,168,151,168,1115,
 892,892,1116,1116,892,1115,1115,1116,1115,892,1115,118,116,
 162,116,121,116,117,121,118,118,151,151,168,1044,731,714,
 1048,714,731,1044,731,731,714,714,1048,118,315,132,117,123,
 166,152,185,169,216,200,225,1265,997,893,1112,911,997,1265,
 1431,1431,903,892,1130,168,116,118,116,117,117,118,118,151,
 168,167,1115,892,1115,1115,892,892,1115,1115,1115,892,1115,
 1115,170,312,175,216,205,219,232,277,277,290,1452,1280,1496,
 1538,1496,1280,1452,1073,1073,1493,1494,1536,123,116,117,117,
 142,123,151,151,178,1063,715,714,1052,714,715,1063,880,880,
 714,714,1052,132,152,166,169,185,200,200,240,1224,999,894,
 1156,894,999,1224,1426,1426,898,898,1151,117,117,123,141,151,
 151,194,1124,892,714,1067,714,892,1124,1124,1124,714,714,1067,
 31,31,31,306,205,210,1101,893,999,1207,1423,892,1119,903,911,
 1423,999,1207,31,31,200,216,219,1207,1423,911,1101,893,1423,
 1207,999,999,892,903,1119,31,205,232,250,1411,894,920,1175,
 893,893,1415,913,915,898,933,1145,201,218,324,1145,898,913,
 1415,893,893,1175,920,933,894,915,1411,265,270,1538,1496,1280,
 1452,1073,1494,1536,1493,1496,1073,1280,1452,270,1542,1499,
 1073,1452,1280,1499,1542,1499,1499,1280,1073,1452,1493,1522,
 1194,1044,1194,1523,1511,1523,1521,1194,1194,1053,1224,2344,
 2319,2340,1210,1066,1210,1224,2363,2363,2350,2319,2344,2322,
 714,1210,996,996,2330,2330,2363,1224,996,2330,2363,2330,2322,
 996,714,1210,1224,2363,2350,2363,2340,1210,1210,1066,2330,2363,
 2330,2319,714,996,1210,1224,996,996,2322,2319,2344,1224,1210,
 2340,2344,2319,714,2319,2322,2340,2330,2330,2363,996,1224,1224,
 116,116,116,141,123,116,116,116,117,116,117,141,122,151,178,
 116,116,117,116,151,116,117,116,117,117,131,131,151,191,170,
 1054,714,1063,880,715,714,1054,714,714,715,1063,880,116,116,
 141,123,116,116,116,117,116,123,142,117,175,175,116,116,117,
 116,151,116,117,116,117,132,131,117,151,194,151,1124,1124,
 1068,714,714,1124,1124,892,892,714,1068,714,116,122,141,116,
 116,116,117,116,131,131,117,170,191,116,116,117,116,151,116,
 117,116,117,122,141,117,151,178,151,1063,880,1054,714,714,
 880,1063,715,715,714,1054,714,118,118,116,116,116,117,116,
 118,121,118,168,168,116,116,117,116,151,116,117,116,117,118,
 121,118,151,168,167,1115,1115,1115,1116,892,1115,1116,892,892,
 892,1116,1115,31,118,138,31,31,118,169,50,169,232,251,31,
 118,32,31,205,119,31,118,32,185,43,185,201,324,219,1175,921,
 1415,913,893,933,1145,898,893,894,1410,915,118,119,31,31,118,
 185,43,185,219,325,31,118,32,31,201,138,31,118,32,169,50,
 169,205,250,232,1415,913,1175,920,893,915,1411,894,893,898,
 1143,933,116,116,121,116,121,121,117,168,168,116,116,117,116,
 151,116,117,116,118,118,121,117,168,168,151,1115,1116,1116,
 892,1115,1115,1116,892,892,1115,1115,892,116,119,116,117,148,
 117,151,178,116,116,117,116,151,116,117,116,132,117,131,117,
 170,191,151,1054,714,1063,715,880,714,1054,714,714,880,1063,
 715,31,116,117,46,117,151,194,31,116,32,31,151,116,31,116,
 39,117,49,117,175,175,151,1068,714,1124,892,1124,714,1068,
 714,714,1124,1124,892,121,166,35,166,216,219,31,117,32,31,
 200,117,31,117,33,152,35,152,306,210,205,1101,911,1207,999,
 1423,903,1119,892,893,1423,1207,999,117,121,121,151,168,116,
 116,117,116,151,116,117,116,118,117,121,118,162,168,162,1045,
 714,1044,731,731,714,1045,714,714,731,1044,731,160,151,315,
 228,117,118,151,117,199,117,152,117,152,117,164,151,216,225,
 200,1265,1431,1130,892,903,1431,1265,997,997,911,1111,893,161,
 208,262,35,121,58,50,208,132,35,121,71,164,62,164,221,300,
 204,1173,914,1365,897,923,906,1170,907,914,918,1395,895,200,
 240,117,117,151,117,200,117,152,118,152,151,163,117,205,213,
 312,1155,894,1224,1426,999,898,1150,898,894,999,1224,1426,270,
 151,162,199,151,265,151,205,151,200,312,204,200,277,290,277,
 1452,1073,1537,1493,1493,1073,1452,1280,1280,1496,1538,1496,
 168,168,228,175,270,191,210,168,225,213,304,225,290,283,290,
 1056,1194,1517,1529,1529,1194,1056,1194,1194,1529,1507,1529,
 116,35,31,168,116,31,116,35,117,35,117,168,168,151,1116,892,
 1116,892,1116,892,1115,1116,1116,1116,1116,892,118,116,162,
 116,121,116,117,121,121,117,151,168,151,1044,731,1048,714,
 714,731,1044,731,731,714,1048,714,39,315,132,33,118,62,152,
 71,152,216,225,200,1265,997,1112,893,911,997,1265,1431,1431,
 903,1130,892,175,116,31,116,32,117,46,117,151,194,151,1124,
 892,1067,714,714,892,1124,1124,1124,714,1067,714,170,306,168,
 216,205,221,216,277,290,277,1452,1280,1542,1499,1499,1280,
 1452,1073,1073,1499,1542,1499,119,116,117,117,148,117,151,178,
 151,1063,715,1052,714,714,715,1063,880,880,714,1052,714,121,
 32,166,35,166,200,219,216,1207,999,1119,903,892,999,1207,
 1423,1423,893,1103,911,117,117,121,121,151,168,168,1115,892,
 1116,1115,892,892,1116,1116,1116,892,1116,1116,151,58,151,315,
 228,199,1112,893,1265,997,1431,892,1130,903,911,1431,1265,997,
 161,151,200,240,200,1224,1426,1150,898,898,1426,1224,999,999,
 894,1155,894,160,208,258,208,1395,895,1170,906,906,897,1365,
 923,918,914,1173,914,199,228,315,1111,893,1265,1431,997,892,
 1130,903,911,997,1265,1431,270,265,1542,1499,1452,1280,1073,
 1499,1542,1499,1499,1073,1452,1280,270,1511,1523,1044,1194,
 1194,1522,1493,1521,1523,1194,1053,1194,1542,1499,1452,1073,
 1280,1499,1542,1499,1499,1280,1452,1073,1224,2350,2363,2363,
 1210,1066,1210,1224,2340,2327,2339,2363,2330,2330,714,1210,996,
 996,2322,2339,2322,1224,1224,2344,2319,2340,2363,1210,1066,
 1210,996,2321,2344,2322,2330,996,1210,714,2319,2344,2322,2330,
 714,1210,996,1224,996,996,2330,2363,2330,1224,1210,2363,2350,
 2363,714,2330,2363,2330,2320,2344,2321,1224,996,1224,116,116,
 148,117,116,116,116,117,116,119,138,119,178,151,116,116,117,
 116,151,116,117,116,117,132,117,131,151,191,170,714,1054,
 1063,880,715,1054,714,714,714,715,1063,880,116,121,121,116,
 116,116,117,116,121,118,118,162,162,116,116,117,116,151,116,
 117,116,117,118,118,121,151,162,162,593,593,593,593,575,593,
 593,575,575,575,593,593,135,117,116,116,116,117,116,119,119,
 138,178,151,116,116,117,116,151,116,117,116,117,123,117,141,
 151,170,191,714,1054,880,1063,715,1054,714,714,714,715,880,
 1063,161,121,142,121,161,132,171,127,157,237,212,121,121,155,
 142,212,121,161,132,163,189,164,166,202,321,247,729,813,1399,
 992,904,844,735,735,729,904,1398,991,117,117,118,151,117,166,
 169,185,205,311,117,117,152,117,199,118,151,117,151,152,117,
 164,200,219,238,1376,898,741,819,714,898,1376,892,892,715,
 769,856,116,116,121,116,121,118,118,168,151,116,116,117,116,
 151,116,117,116,118,118,117,121,168,162,162,714,1048,731,731,
 1044,1047,714,714,714,1044,731,731,116,123,4,117,142,123,151,
 151,116,116,117,116,151,116,117,116,132,117,117,132,4,4,4,
 575,575,31,31,31,575,575,575,575,31,31,31,118,116,117,118,
 118,151,168,116,116,117,116,151,116,117,116,118,117,118,121,
 168,162,162,1048,714,731,731,1044,714,1048,714,714,1044,731,
 731,132,166,169,185,216,200,118,117,152,117,200,117,151,117,
 117,152,151,164,308,209,226,715,757,900,926,1366,740,714,714,
 715,1366,900,926,117,123,142,151,151,116,116,117,116,151,116,
 117,116,123,117,117,142,4,4,4,575,575,31,31,31,575,575,575,
 575,31,31,31,152,152,302,205,117,118,151,117,199,117,152,
 117,152,117,152,155,216,214,214,898,1369,731,731,740,1369,
 898,892,892,757,757,757,151,206,235,118,118,152,138,206,118,
 153,119,185,162,185,157,215,332,245,823,731,1408,989,927,716,
 801,716,731,927,1408,989,206,235,118,118,152,119,206,118,162,
 138,169,153,169,127,215,245,332,801,716,989,1408,927,731,823,
 731,716,927,989,1408,265,151,162,199,151,265,151,205,151,200,
 311,199,212,277,289,289,1182,1020,1524,1524,1498,1021,1182,
 1182,1182,1498,1524,1524,151,151,205,151,265,162,199,151,200,
 199,311,212,277,289,289,1020,1182,1524,1524,1498,1182,1021,
 1182,1182,1498,1524,1524,116,121,116,168,116,118,116,121,117,
 117,121,168,162,162,714,714,731,731,1044,714,714,1048,1047,
 1044,731,731,118,116,162,116,121,116,117,121,117,121,151,162,
 162,575,593,593,593,575,593,575,593,593,575,593,593,119,302,
 121,117,119,166,152,166,171,216,214,214,898,892,757,757,757,
 892,898,1369,1369,740,731,731,178,116,123,116,117,117,117,
 135,151,191,170,714,714,1063,880,715,714,714,1054,1054,715,
 1063,880,162,311,178,216,205,205,237,277,289,289,1182,1182,
 1524,1524,1498,1182,1182,1021,1020,1498,1524,1524,118,116,117,
 117,121,121,151,162,162,593,575,593,593,575,575,593,593,593,
 575,593,593,132,152,166,152,189,200,219,238,892,898,741,819,
 714,898,892,1376,1376,715,769,856,117,117,117,148,151,170,
 191,714,714,880,1063,715,714,714,1054,1054,715,880,1063,151,
 151,161,307,226,209,715,715,926,900,1367,714,714,740,757,
 1366,926,900,151,161,200,238,219,892,1376,856,769,715,1376,
 892,898,898,714,819,741,161,200,238,219,1376,892,819,741,714,
 892,1376,898,898,715,856,769,202,247,321,735,735,992,1399,
 904,729,729,813,844,904,992,1399,4,4,1503,1503,32,32,34,
 1503,1503,1503,1503,34,32,32,4,1543,1543,49,38,33,1543,1543,
 1543,1543,33,49,38,1543,1543,38,49,33,1543,1543,1543,1543,33,
 38,49,892,2362,2362,2330,892,575,892,892,2330,2362,2362,2362,
 2362,2330,575,892,892,892,2330,2362,2362,31,31,2362,2362,2362,
 2362,31,31,31,31,2362,2362,2362,2362,31,31,31,2330,2330,2330,
 2330,31,31,31,892,892,892,2330,2362,2362,892,892,2330,2362,
 2362,575,2330,2362,2362,2330,2362,2362,31,31,31,116,132,132,
 116,116,116,117,116,142,123,117,191,170,116,116,117,116,151,
 116,117,116,117,142,123,117,151,178,151,880,1063,1054,714,
 714,1063,880,715,715,714,1054,714,46,117,116,116,116,117,116,
 31,31,31,194,151,116,116,31,31,151,116,32,31,117,50,117,39,
 151,175,175,714,1068,1124,1124,892,1068,714,714,714,892,1124,
 1124,161,132,142,121,161,121,43,50,35,262,208,121,132,35,50,
 208,121,58,35,164,68,164,71,204,304,221,907,1170,1365,923,
 897,1173,914,914,906,895,1395,918,117,117,118,151,117,185,
 169,166,228,315,117,117,152,117,199,118,151,117,151,164,117,
 152,200,225,216,1431,1265,1130,903,892,1265,1431,997,997,893,
 1112,911,116,116,132,116,142,123,117,194,151,116,116,117,116,
 151,116,117,116,123,142,117,117,175,175,151,714,1068,1124,
 892,1124,1068,714,714,714,1124,1124,892,116,123,116,123,142,
 117,178,151,116,116,117,116,151,116,117,116,132,132,117,117,
 170,191,151,714,1054,1063,715,880,1054,714,714,714,880,1063,
 715,118,116,118,118,117,168,168,116,116,117,116,151,116,117,
 116,118,121,118,117,168,168,151,1116,1116,1116,892,1116,1115,
 1116,892,892,1116,1116,892,121,185,169,166,240,200,118,117,
 152,117,200,117,151,117,117,164,151,152,312,213,205,898,1150,
 1224,999,1426,1155,894,894,898,1426,1224,999,118,118,121,168,
 151,116,116,117,116,151,116,117,116,118,121,117,118,162,168,
 162,714,1045,1044,731,731,1045,714,714,714,731,1044,731,31,
 31,325,219,118,138,31,31,201,118,32,31,169,50,169,32,232,
 251,205,915,1411,1175,893,921,1415,913,893,894,933,1145,898,
 31,251,232,118,119,31,31,205,118,32,31,185,43,185,32,219,
 325,201,933,1145,1415,893,913,1175,921,893,898,915,1411,894,
 219,216,117,117,31,31,200,117,32,31,152,35,152,33,205,210,
 306,903,1119,1207,1423,999,1101,911,893,892,999,1207,1423,270,
 168,191,210,175,270,168,228,168,225,304,213,225,290,277,290,
 1194,1056,1517,1529,1529,1056,1194,1194,1194,1529,1517,1529,
 151,151,205,151,265,162,199,151,200,204,312,200,277,290,277,
 1073,1452,1537,1493,1493,1452,1073,1280,1280,1496,1538,1496,
 116,121,116,168,116,118,116,121,121,117,117,168,168,151,892,
 1115,1116,892,1116,1116,892,1116,1116,1116,1116,892,119,116,
 170,116,132,116,117,148,117,117,151,178,151,715,1063,1054,
 714,714,1063,715,880,880,714,1054,714,31,306,121,33,31,166,
 35,166,32,216,219,200,999,1207,1101,893,911,1207,999,1423,
 1423,903,1119,892,175,116,39,31,117,46,117,32,151,194,151,
 892,1124,1068,714,714,1124,892,1124,1124,714,1068,714,162,315,
 168,216,221,205,216,277,290,277,1280,1452,1538,1496,1496,1452,
 1280,1073,1073,1493,1537,1493,118,116,117,121,121,117,151,168,
 151,731,1044,1045,714,714,1044,731,731,731,714,1045,714,35,
 152,71,152,62,200,225,216,997,1265,1130,903,892,1265,997,
 1431,1431,893,1111,911,117,35,117,35,151,168,168,892,1116,
 1116,1116,892,1115,892,1116,1116,892,1116,1115,161,151,151,
 315,228,199,893,1112,1265,997,1431,1130,892,903,911,1431,1265,
 997,161,58,208,262,208,895,1395,1173,914,914,1365,897,923,
 918,907,1170,906,151,200,240,200,1426,1224,1155,894,894,1224,
 1426,999,999,898,1150,898,199,228,315,893,1111,1265,1431,997,
 1130,892,903,911,997,1265,1431,270,265,1496,1538,1452,1280,
 1073,1537,1493,1493,1496,1073,1452,1280,270,1529,1517,1056,
 1194,1194,1517,1529,1529,1529,1194,1056,1194,1493,1537,1452,
 1073,1280,1538,1496,1496,1493,1280,1452,1073,1224,2344,2319,
 2321,1210,714,996,996,2330,2363,2330,2319,2344,2344,1066,1210,
 1210,1224,2363,2350,2363,1224,1224,2350,2363,2363,2344,1210,
 1066,1210,996,2363,2330,2330,2321,996,1210,714,2363,2330,2330,
 2319,714,1210,996,1224,1224,1210,2344,2319,2344,996,996,2321,
 2344,2319,714,2319,2344,2321,2330,2363,2330,1224,996,1224,117,
 135,116,116,116,117,116,142,117,123,191,170,116,116,117,116,
 151,116,117,116,117,138,119,119,151,151,178,880,1063,714,
 1054,714,1063,880,715,715,714,714,1054,160,117,118,117,151,
 117,163,117,152,238,218,117,117,151,118,200,117,151,117,152,
 185,169,166,199,311,205,741,819,1376,898,892,856,769,715,714,
 892,1376,898,132,121,142,161,121,182,163,189,247,321,121,131,
 163,121,202,141,160,121,155,156,127,171,212,212,237,1399,992,
 729,813,729,992,1399,904,904,735,735,844,116,116,132,116,148,
 117,117,191,170,116,116,117,116,151,116,117,116,119,138,119,
 117,178,151,151,880,1063,714,714,1054,1063,880,715,715,1054,
 714,714,116,118,116,121,121,117,162,162,116,116,117,116,151,
 116,117,116,121,118,118,117,162,162,151,593,593,593,575,593,
 593,593,575,575,593,593,575,123,116,135,117,117,170,191,116,
 116,117,116,151,116,117,116,119,119,138,117,178,151,151,1063,
 880,714,714,1054,880,1063,715,715,1054,714,714,121,189,152,
 166,238,219,118,117,152,117,200,117,151,117,117,162,153,152,
 311,199,205,769,856,892,898,1376,819,741,714,715,1376,892,
 898,121,117,121,162,162,116,116,117,116,151,116,117,116,118,
 118,118,118,162,151,162,593,593,575,593,593,593,593,575,575,
 593,575,593,160,160,321,247,121,142,161,121,202,132,164,121,
 171,127,156,155,237,212,212,992,1399,729,729,813,1399,992,
 904,904,844,734,734,151,219,238,117,117,151,118,200,117,151,
 117,166,169,185,152,205,311,199,856,769,1376,892,898,741,819,
 714,715,898,1376,892,219,238,117,117,151,117,200,117,152,118,
 152,153,162,117,205,199,311,819,741,892,1376,898,769,856,715,
 714,898,892,1376,4,162,4,209,162,4,4,226,162,214,332,245,
 214,289,289,289,38,49,1543,1543,1543,49,38,33,33,1543,1543,
 1543,162,4,226,162,4,4,209,162,214,245,332,214,289,289,289,
 49,38,1543,1543,1543,38,48,33,33,1543,1543,1543,116,121,116,
 168,116,118,116,121,118,118,117,168,151,151,731,731,714,714,
 1048,731,731,1044,1044,1047,714,714,123,116,4,4,132,116,117,
 142,123,117,151,151,151,31,31,575,575,575,31,31,31,31,575,
 575,575,118,307,132,117,118,166,169,185,152,216,200,200,926,
 900,715,715,757,900,926,1366,1366,740,714,714,168,116,118,
 116,117,118,118,117,151,168,151,731,731,1047,714,714,731,731,
 1044,1044,714,1047,714,4,308,168,216,215,215,216,277,277,277,
 32,32,1503,1503,1503,32,32,34,34,1503,1503,1503,123,116,117,
 123,142,117,151,151,151,31,31,575,575,575,31,31,31,31,575,
 575,575,121,152,185,169,166,200,200,216,900,926,714,740,714,
 926,900,1366,1366,715,715,757,117,118,118,121,151,151,168,
 731,731,714,1048,714,731,731,1044,1044,714,714,1048,152,152,
 151,303,205,199,757,757,898,892,1369,731,731,740,757,1369,
 898,892,151,152,206,235,206,989,1408,823,731,731,1408,989,
 927,927,716,801,716,152,206,235,206,1408,989,801,716,716,989,
 1408,927,927,731,823,731,199,205,302,757,757,898,1369,892,
 731,731,740,757,892,898,1369,265,265,1524,1524,1182,1182,1020,
 1524,1524,1498,1498,1021,1182,1182,265,1524,1524,1020,1182,
 1182,1524,1524,1498,1498,1182,1021,1182,1524,1524,1182,1020,
 1182,1524,1524,1498,1498,1182,1182,1021,31,2362,2362,2362,31,
 31,31,31,2362,2362,2362,2362,2362,2362,31,31,31,31,2362,2362,
 2362,892,892,2362,2362,2330,2330,892,575,892,892,2362,2362,
 2330,2330,892,892,575,2362,2362,2330,2330,575,892,892,31,31,
 31,2362,2362,2362,31,31,2362,2362,2362,31,2330,2330,2330,2330,
 2330,2330,892,892,892,151,117,118,117,151,117,32,33,32,242,
 200,117,117,32,33,200,117,54,32,152,70,152,70,199,309,230,
 894,1162,1430,1268,997,1152,898,898,894,997,1430,1268,32,117,
 33,54,117,70,152,70,230,309,117,117,152,117,199,118,151,117,
 32,32,33,32,200,200,242,1430,1268,894,1162,894,1268,1430,997,
 997,898,898,1153,116,31,46,116,50,117,39,194,151,116,116,
 117,116,151,116,117,116,31,31,31,31,175,151,175,714,1067,
 892,1124,1124,1067,714,714,714,1124,892,1124,116,118,116,118,
 121,118,168,151,116,116,117,116,151,116,117,116,121,118,117,
 118,162,162,168,714,1047,731,1044,731,1047,714,714,714,731,
 731,1044,33,116,33,117,33,168,168,116,116,117,116,151,116,
 117,116,31,31,31,31,168,151,168,1115,1116,892,1116,1115,1115,
 1116,892,892,1116,892,1116,135,70,152,70,242,200,118,117,152,
 117,200,117,151,117,33,32,32,32,309,199,230,898,1153,997,
 1268,1430,1161,894,894,898,1430,997,1268,123,117,142,178,151,
 116,116,117,116,151,116,117,116,119,119,117,138,170,151,191,
 714,1052,715,1063,880,1052,714,714,714,880,715,1063,31,4,324,
 219,118,138,31,31,201,118,32,31,33,4,33,4,232,205,251,913,
 1415,893,1175,921,1411,915,894,893,933,898,1145,31,219,216,
 117,117,31,31,200,117,32,31,166,33,166,33,205,306,210,911,
 1101,1423,1207,999,1119,903,892,893,999,1423,1207,250,232,118,
 119,31,31,205,118,32,31,33,4,33,4,219,201,325,921,1175,893,
 1415,913,1145,933,898,893,915,894,1411,270,168,191,210,168,
 270,168,230,176,219,323,210,249,290,290,283,1194,1044,1523,
 1511,1523,1053,1194,1194,1194,1521,1522,1493,151,151,205,151,
 265,162,199,151,200,201,306,205,277,277,290,1073,1452,1499,
 1542,1499,1452,1073,1280,1280,1499,1499,1542,116,121,116,168,
 116,118,116,121,118,117,118,168,151,168,892,1115,892,1115,
 1115,1115,892,1115,1116,1115,892,1116,119,116,170,116,135,116,
 117,142,117,123,151,151,178,715,1063,714,1054,714,1063,715,
 880,880,714,714,1054,31,306,121,33,31,166,33,166,33,216,200,
 219,999,1207,893,1101,911,1207,999,1423,1423,903,892,1119,168,
 116,33,31,117,33,117,33,151,168,168,892,1116,1116,1116,892,
 1115,892,1115,1115,892,1116,1115,162,309,176,216,219,205,232,
 277,277,290,1280,1452,1499,1542,1499,1452,1280,1073,1073,1499,
 1499,1542,118,116,117,118,121,118,151,151,168,731,1044,714,
 1045,714,1044,731,731,731,714,714,1045,46,152,70,152,70,200,
 200,242,997,1268,894,1163,894,1268,997,1430,1430,898,898,1152,
 117,39,117,50,151,151,194,892,1124,714,1068,714,1124,892,
 1124,1124,714,714,1068,31,31,31,306,205,210,893,1101,999,
 1207,1423,1119,892,903,911,1423,999,1207,31,4,205,232,251,
 894,1411,933,1145,898,1415,893,913,915,893,921,1175,31,200,
 216,219,1423,1207,903,1119,892,1207,1424,999,999,893,911,1101,
 201,219,325,898,1145,915,1411,894,1175,893,921,933,893,913,
 1415,265,270,1499,1542,1280,1452,1073,1542,1499,1499,1499,1073,
 1280,1452,270,1493,1537,1073,1452,1280,1538,1496,1496,1493,
 1280,1073,1452,1529,1517,1193,1056,1194,1507,1529,1529,1529,
 1194,1194,1056,1224,2330,2363,2330,1210,714,996,996,2322,2321,
 2344,2363,2350,2363,1066,1210,1210,1224,2340,2344,2319,1224,
 996,2339,2322,2322,2330,996,714,1210,1224,2327,2339,2340,2363,
 1210,1210,1066,2344,2321,2320,2330,714,996,1210,1224,1224,1210,
 2363,2363,2350,996,996,2330,2330,2363,714,2330,2330,2363,2322,
 2319,2344,996,1224,1224,151,152,31,31,151,217,39,217,284,341,
 31,151,32,31,266,152,31,151,32,217,39,217,266,340,284,1427,
 1024,1427,1024,996,1030,1422,997,996,997,1421,1030,123,117,
 161,117,164,117,152,240,200,117,117,151,118,200,117,151,117,
 169,185,152,166,213,312,205,894,1155,1426,999,1224,1150,898,
 898,894,1224,1426,999,119,151,123,169,126,169,235,206,119,
 118,153,138,206,118,152,118,157,185,162,185,245,332,215,716,
 801,1408,927,989,823,731,731,716,989,1408,927,31,117,152,33,
 152,216,219,31,117,32,31,200,117,31,117,33,166,33,166,210,
 306,205,1119,903,1423,999,1207,911,1101,893,892,1207,1423,999,
 161,217,39,217,291,267,31,151,32,31,267,151,31,151,39,217,
 32,217,342,342,275,893,956,1468,1077,1468,956,893,893,893,
 1468,1468,1077,152,117,163,216,200,117,117,151,118,200,117,
 151,117,169,166,152,185,209,307,226,714,740,1366,926,900,757,
 715,715,714,900,1366,926,39,32,346,278,152,162,32,33,268,
 152,54,32,217,69,217,62,280,343,276,1027,1436,1435,1009,1017,
 1438,1031,1009,1000,1025,1428,1022,39,224,224,33,117,4,4,200,
 117,4,33,69,69,69,69,211,335,212,983,986,1563,1042,1042,983,
 986,910,910,1042,1563,1042,285,288,152,152,32,33,271,152,54,
 32,217,62,217,69,272,350,347,919,912,1483,1477,1078,954,957,
 911,893,1078,1483,1477,295,216,238,273,232,295,216,284,216,
 288,349,281,292,299,359,313,1291,1113,1632,1608,1597,1104,
 1292,1292,1291,1590,1623,1606,200,200,271,205,294,214,266,200,
 271,274,344,279,296,365,298,1080,1283,1635,1589,1571,1285,
 1074,1282,1281,1574,1638,1596,117,35,31,219,117,31,117,35,
 166,32,166,210,306,205,892,903,1423,999,1207,911,893,1101,
 1119,1207,1423,999,153,123,219,117,161,117,152,189,152,166,
 199,311,205,714,819,1376,898,892,856,715,769,741,892,1376,
 898,4,336,155,4,32,62,62,62,62,273,337,271,999,1001,1419,
 1010,1010,1010,1010,1419,1425,1001,1425,999,251,119,4,39,32,
 70,32,70,201,323,219,893,921,1415,913,893,933,898,1145,1175,
 894,1411,915,214,341,225,286,287,276,292,296,365,298,1281,
 1283,1636,1588,1569,1285,1282,1074,1080,1572,1637,1595,152,117,
 152,166,171,166,199,301,205,731,740,1368,898,892,757,757,757,
 731,892,1368,898,58,32,79,32,79,266,339,284,996,1024,1427,
 1024,996,1030,997,1422,1427,997,1422,1030,152,62,152,71,199,
 315,228,892,903,1431,1265,997,911,893,1111,1130,997,1431,1265,
 217,54,217,350,347,272,899,951,1477,1078,1483,933,898,935,
 928,1483,1477,1078,217,79,274,349,287,1019,1434,1446,1036,
 1026,1446,1026,1036,1033,1019,1434,1033,217,268,346,278,1435,
 1017,1437,1027,1000,1025,1429,1022,1009,1009,1439,1031,269,353,
 353,916,966,1487,1487,1079,961,916,966,961,1079,1487,1487,357,
 294,1567,1581,1610,1416,1186,1577,1566,1564,1567,1186,1610,
 1416,356,1630,1616,1397,1451,1454,1614,1631,1631,1630,1455,
 1375,1453,1580,1602,1611,1203,1417,1605,1584,1585,1580,1417,
 1612,1203,1008,2423,2395,2383,1014,723,997,996,2383,2423,2395,
 2407,2402,2392,795,1011,1011,1008,2394,2410,2404,1460,1468,
 2411,2422,2422,2423,1467,1414,1458,1070,2401,2398,2398,2395,
 1070,1458,898,2384,2383,2383,2383,892,1467,1070,1022,1022,1014,
 2396,2414,2406,999,997,2382,2421,2393,723,2379,2421,2390,2383,
 2423,2395,1468,1070,1459,117,39,58,117,71,152,62,228,315,117,
 117,152,117,199,118,151,117,32,32,33,32,225,200,216,1431,
 1265,892,903,1130,1265,1431,997,997,1112,893,911,119,152,117,
 166,171,166,205,302,117,117,152,117,199,118,151,117,155,152,
 117,152,214,214,216,1369,898,731,740,731,898,1369,892,892,
 757,757,757,4,123,70,32,70,219,324,31,118,32,31,201,138,31,
 118,4,33,4,33,250,205,232,1411,915,893,921,1175,913,1415,
 893,894,1143,898,933,161,79,32,79,284,340,31,151,32,31,266,
 152,31,151,4,54,4,54,340,266,284,1422,1030,996,1024,1427,
 1024,1427,996,997,1421,997,1030,166,152,189,205,310,117,117,
 152,117,199,118,151,117,153,152,117,162,219,200,238,1373,898,
 714,819,741,898,1373,892,892,769,715,856,217,79,354,354,166,
 185,217,166,269,185,217,166,62,69,69,62,292,279,292,1489,
 1489,902,946,946,1489,1489,1079,1079,979,936,979,217,278,346,
 32,152,54,33,268,162,32,152,62,217,69,217,276,344,281,1438,
 1031,1435,1017,1009,1027,1436,1000,1009,1022,1429,1025,287,348,
 166,166,217,166,274,185,217,185,62,62,69,69,287,274,348,
 1432,1033,1019,1432,1033,1036,1442,1026,1019,1036,1026,1445,
 356,205,226,272,205,294,215,275,205,271,347,209,276,298,298,
 313,1612,1203,1580,1603,1578,1203,1611,1417,1417,1586,1584,
 1605,306,308,347,306,357,332,342,312,336,350,334,343,364,365,
 358,1365,1453,1630,1613,1626,1451,1397,1454,1455,1627,1631,
 1615,117,35,31,210,119,31,117,35,152,33,152,219,200,216,
 1423,999,892,903,1119,999,1423,1207,1207,1101,893,911,169,117,
 209,123,161,117,151,164,117,152,200,200,216,1366,926,714,740,
 714,926,1366,900,900,715,715,757,33,350,157,39,169,62,217,
 69,217,285,271,288,1477,1078,899,951,928,1078,1477,1483,1483,
 935,898,933,210,119,31,117,32,152,33,152,200,219,216,1423,
 999,1119,903,892,999,1423,1207,1207,893,1101,911,245,342,213,
 273,272,209,281,296,296,299,1610,1416,1567,1581,1565,1416,
 1610,1186,1186,1564,1568,1576,151,123,153,169,127,169,206,206,
 235,1408,927,715,791,715,927,1408,989,989,732,732,833,161,32,
 217,39,217,267,267,291,1468,1077,892,939,892,1077,1468,1468,
 1468,898,898,968,151,152,117,164,200,200,240,1426,999,894,
 1154,894,999,1426,1224,1224,898,898,1150,32,4,32,336,271,273,
 1419,1010,999,1001,1425,999,1425,1001,1010,1419,1010,1010,39,
 32,271,288,285,1483,1477,933,935,898,1477,1483,1078,1078,899,
 951,928,39,200,222,222,1414,900,753,753,714,900,1414,900,900,
 715,769,769,268,278,346,1429,1022,1027,1437,1000,1009,1435,
 1017,1025,1009,1031,1438,294,295,1636,1588,1281,1284,1081,1596,
 1638,1572,1571,1074,1282,1285,295,1638,1596,1081,1284,1281,
 1588,1636,1571,1572,1282,1074,1285,1622,1607,1291,1110,1291,
 1608,1632,1599,1591,1293,1293,1105,1460,2423,2407,2420,1457,
 1414,1467,1468,2422,2421,2415,2395,2402,2387,898,1457,1070,
 1070,2398,2393,2406,1008,996,2395,2423,2383,2383,997,716,1014,
 1008,2404,2408,2394,2391,1011,1011,793,2384,2419,2381,2382,716,
 997,1014,1460,1070,1070,2393,2398,2399,1468,1467,2421,2422,
 2411,892,2379,2383,2388,2383,2379,2396,999,1022,1022,116,142,
 116,132,132,117,178,151,116,116,117,116,151,116,117,116,142,
 123,117,117,191,170,151,714,1054,880,715,1063,1054,714,714,
 714,1063,880,715,50,116,46,117,32,175,175,116,116,117,116,
 151,116,117,116,31,31,31,31,194,151,151,1124,1124,714,714,
 1068,1124,1124,892,892,1068,714,714,148,62,164,71,258,208,
 142,132,164,121,208,121,161,121,50,43,35,35,304,203,221,914,
 1173,897,923,1365,1170,907,907,914,1395,895,918,132,117,132,
 178,151,116,116,117,116,151,116,117,116,138,119,117,119,191,
 151,170,714,1052,715,880,1063,1052,714,714,714,1063,715,880,
 161,58,300,221,132,142,160,121,203,121,164,121,42,50,35,35,
 262,208,208,918,1395,906,907,1170,1365,923,897,895,1173,914,
 914,151,225,216,117,117,151,118,200,117,151,117,185,169,166,
 152,228,315,199,911,1111,1431,997,1265,1130,903,892,893,1265,
 1431,997,225,216,117,117,151,117,200,117,152,118,32,32,32,
 33,228,199,315,903,1130,997,1431,1265,1112,911,893,892,1265,
 997,1431,270,176,191,213,168,270,168,228,168,250,324,210,219,
 283,290,290,1194,1053,1522,1521,1493,1044,1193,1193,1193,1511,
 1523,1523,151,151,205,151,265,162,199,151,205,201,305,200,
 290,277,277,1073,1452,1499,1499,1542,1452,1073,1280,1280,1542,
 1499,1499,116,132,116,175,116,123,116,141,123,117,117,194,
 151,151,892,1124,714,714,1068,1124,892,1124,1124,1068,714,714,
 123,116,170,116,132,116,123,141,117,117,178,151,151,715,1063,
 714,714,1054,1063,715,880,880,1054,714,714,118,312,121,117,
 118,185,169,166,152,240,200,200,999,1224,898,898,1150,1224,
 999,1426,1426,1155,894,894,168,116,118,116,118,118,117,117,
 167,168,151,892,1116,1116,892,1115,1116,892,1116,1116,1115,
 1115,892,162,315,168,232,219,205,216,290,277,277,1280,1452,
 1499,1499,1542,1452,1280,1073,1073,1542,1499,1499,118,116,118,
 118,121,117,167,151,151,731,1043,714,714,1045,1044,731,731,
 731,1045,714,714,121,169,185,152,166,225,200,216,997,1265,
 892,903,1130,1265,997,1431,1431,1111,893,911,118,118,117,121,
 168,151,168,892,1115,892,1115,1115,1115,892,1115,1115,1115,
 892,1116,31,31,31,325,219,201,898,1143,915,894,1411,1175,893,
 921,933,1415,913,893,31,31,251,232,205,894,1410,933,898,1145,
 1415,893,913,915,1175,921,893,31,219,216,200,1423,1207,903,
 892,1119,1207,1423,999,999,1101,911,893,210,205,306,893,1103,
 999,1423,1207,1119,892,903,911,1207,999,1423,270,270,1529,
 1507,1194,1194,1056,1517,1529,1529,1529,1056,1194,1194,265,
 1496,1538,1073,1280,1452,1537,1493,1493,1496,1452,1073,1280,
 1499,1542,1280,1073,1452,1542,1499,1499,1499,1452,1280,1073,
 1224,2330,2330,2363,1210,714,996,996,2340,2322,2320,2363,2363,
 2350,1066,1210,1210,1224,2327,2339,2344,996,1224,2344,2319,
 2321,2330,1210,714,996,1224,2340,2322,2322,2330,1210,996,714,
 2319,2344,2344,2363,1066,1210,1210,1224,1224,1210,2350,2363,
 2363,996,996,2363,2330,2330,714,2363,2330,2330,2339,2322,2321,
 1224,1224,996,138,116,117,135,117,151,178,116,116,117,116,
 151,116,117,116,142,117,123,117,191,170,151,1054,714,880,715,
 1063,714,1054,714,714,1063,880,715,141,185,157,185,235,206,
 138,118,162,119,206,118,152,118,127,169,153,169,332,245,215,
 731,823,989,927,1408,801,716,716,731,1408,989,927,117,132,
 131,151,151,116,116,117,116,151,116,117,116,142,117,117,123,
 4,4,4,575,575,31,31,31,575,575,575,575,31,31,31,161,151,
 311,205,117,118,151,117,199,117,152,117,164,117,152,151,238,
 219,200,898,1376,741,714,819,1376,898,892,892,856,769,715,
 160,212,237,131,121,161,142,212,121,155,121,182,163,189,164,
 247,321,202,844,735,1399,904,992,728,813,729,735,992,1399,
 904,200,216,117,117,151,117,200,117,152,118,163,151,152,117,
 226,209,307,740,714,900,1366,926,715,757,715,714,926,900,
 1366,265,151,162,199,151,265,151,205,151,212,311,199,200,289,
 289,277,1182,1021,1524,1498,1524,1020,1182,1182,1182,1524,1524,
 1498,151,151,205,151,265,162,199,151,212,199,311,200,289,289,
 277,1021,1182,1524,1498,1524,1182,1020,1182,1182,1524,1524,
 1498,116,132,116,178,116,119,116,148,117,117,117,191,170,151,
 714,714,880,715,1063,714,714,1054,1054,1063,880,715,118,116,
 162,116,121,116,121,121,117,117,162,162,151,575,593,593,575,
 593,593,575,593,593,593,593,575,123,311,121,117,118,189,152,
 166,152,238,219,200,898,892,769,715,856,892,898,1376,1376,
 819,741,714,178,116,119,116,135,117,117,117,170,191,151,714,
 714,1063,715,880,714,714,1054,1054,880,1063,715,162,302,168,
 237,205,205,216,289,289,277,1182,1182,1524,1498,1524,1182,
 1182,1020,1021,1524,1524,1498,118,116,121,117,121,117,162,162,
 151,593,575,593,575,593,575,593,593,593,593,593,575,121,171,
 166,152,166,214,214,216,892,898,731,740,731,898,892,1369,
 1369,757,757,757,121,117,117,121,162,162,168,714,714,731,
 1044,731,714,714,1048,1047,731,731,1044,161,161,161,321,247,
 202,735,734,992,904,1399,729,729,813,844,1399,992,904,151,
 151,219,238,200,892,1376,856,715,769,1376,892,898,898,741,
 819,714,151,219,238,200,1376,892,819,714,741,892,1376,898,
 898,769,856,715,209,226,308,715,715,926,1366,900,714,714,740,
 757,900,926,1366,4,4,1543,1543,38,33,49,1543,1543,1543,1543,
 49,38,33,4,1543,1543,49,33,38,1543,1543,1543,1543,38,49,33,
 1503,1503,32,34,32,1503,1503,1503,1503,32,32,34,892,2362,
 2330,2362,892,575,892,892,2362,2362,2330,2362,2330,2362,575,
 892,892,892,2362,2362,2330,31,31,2362,2362,2362,2362,31,31,
 31,31,2330,2330,2330,2330,31,31,31,2362,2362,2362,2362,31,31,
 31,892,892,892,2362,2362,2330,892,892,2362,2362,2330,575,2362,
 2362,2330,2362,2362,2330,31,31,31,142,70,32,70,232,250,31,
 118,32,31,205,119,31,118,4,33,4,33,324,201,219,1145,933,
 893,913,1415,921,1175,893,898,1410,894,915,117,117,135,151,
 178,116,116,117,116,151,116,117,116,138,117,119,119,191,151,
 170,1052,714,715,880,1063,714,1052,714,714,1063,715,880,151,
 54,309,230,117,118,151,117,199,117,152,117,32,33,32,32,242,
 200,200,1268,1430,894,894,1162,1430,1268,997,997,1152,898,898,
 151,200,242,32,117,54,33,200,117,32,117,70,152,70,152,230,
 309,199,1152,898,1430,997,1268,894,1162,894,898,1268,1430,997,
 200,242,117,117,151,117,200,117,152,118,32,32,32,33,230,199,
 309,1161,894,997,1430,1268,898,1153,898,894,1268,997,1430,270,
 151,162,199,151,265,151,205,151,205,306,201,200,290,277,277,
 1452,1073,1499,1499,1542,1073,1452,1280,1280,1542,1499,1499,
 176,168,230,168,270,191,210,168,250,210,324,219,283,290,290,
 1053,1194,1523,1523,1511,1194,1044,1194,1194,1510,1521,1522,
 116,46,31,175,116,31,116,50,117,39,117,194,151,151,1124,892,
 714,714,1067,892,1124,1124,1124,1067,714,714,118,116,162,116,
 121,116,118,121,118,117,168,151,151,1044,731,714,714,1048,
 731,1044,731,731,1048,714,714,33,309,135,33,118,70,152,70,
 152,242,200,200,1268,997,898,898,1153,997,1268,1430,1430,1161,
 894,894,168,116,31,116,33,117,33,117,168,168,151,1116,892,
 1115,892,1116,892,1115,1116,1116,1115,1116,892,170,306,168,
 232,205,219,216,290,277,277,1452,1280,1494,1493,1536,1280,
 1452,1073,1073,1538,1496,1496,119,116,123,117,142,117,178,151,
 151,1063,715,714,714,1052,715,1063,880,880,1052,714,714,121,
 33,166,33,166,219,200,216,1207,999,892,903,1119,999,1207,
 1423,1423,1103,893,911,118,117,118,121,168,151,168,1115,892,
 892,1116,1116,892,1116,1115,1115,1115,892,1115,31,4,31,324,
 218,201,1143,898,913,893,1415,893,1175,920,933,1411,915,894,
 31,31,219,216,200,1207,1423,911,893,1101,1423,1207,999,999,
 1119,903,892,31,250,232,205,1410,894,920,893,1175,893,1415,
 913,915,1145,933,898,210,205,305,1103,893,999,1423,1207,892,
 1119,903,911,1207,999,1423,270,270,1510,1521,1194,1194,1044,
 1523,1511,1523,1522,1053,1193,1193,265,1542,1499,1073,1280,
 1452,1499,1542,1499,1499,1452,1073,1280,1538,1496,1280,1073,
 1452,1494,1536,1493,1496,1452,1280,1073,1224,2339,2344,2327,
 1210,1066,1210,1224,2348,2363,2363,2322,2321,2339,714,1210,996,
 996,2363,2330,2330,996,1224,2330,2363,2330,2321,1210,714,996,
 1224,2330,2363,2330,2322,1210,996,714,2363,2350,2363,2344,1066,
 1210,1210,1224,996,996,2339,2322,2321,1224,1210,2327,2339,2344,
 714,2344,2321,2322,2363,2330,2330,1224,1224,996,189,163,182,
 237,212,141,121,163,121,212,121,160,131,126,171,154,156,321,
 202,247,742,846,904,992,1399,809,719,719,742,1398,904,991,
 217,79,348,287,185,185,217,166,274,166,217,166,69,69,62,62,
 351,274,287,1036,1442,1019,1033,1432,1432,1033,1019,1026,1442,
 1026,1036,217,288,285,32,152,54,33,271,152,32,152,69,217,62,
 217,347,350,272,954,957,1483,1078,1477,920,912,893,911,1477,
 1483,1078,292,292,185,166,217,166,279,166,217,185,69,62,62,
 69,355,269,355,966,961,1079,1488,1488,966,961,916,916,1488,
 1079,1488,295,232,238,281,216,295,216,284,216,222,346,273,
 286,360,299,313,1293,1107,1592,1606,1622,1110,1291,1291,1293,
 1632,1598,1609,205,200,276,200,294,214,266,200,200,268,336,
 271,364,296,298,1075,1285,1573,1596,1637,1283,1081,1281,1282,
 1633,1571,1588,123,43,31,250,119,31,123,50,169,32,169,323,
 201,219,898,933,893,913,1415,921,893,1175,1145,1411,894,915,
 169,117,219,117,161,117,117,163,151,152,311,199,205,715,856,
 892,898,1376,819,714,741,769,1376,892,898,33,344,171,39,169,
 69,217,62,217,345,268,278,1022,1025,1009,1031,1438,1017,1009,
 1435,1428,1436,1000,1027,219,117,31,117,33,152,32,152,306,
 210,205,893,911,1207,999,1423,903,892,1119,1101,1423,1207,999,
 214,340,225,222,278,271,288,363,296,298,1282,1285,1574,1594,
 1638,1284,1281,1081,1075,1636,1569,1589,152,117,117,152,155,
 152,301,199,205,757,757,892,898,1368,740,731,731,757,1368,
 892,898,161,39,217,32,217,339,266,284,997,1030,996,1024,1427,
 1024,996,1427,1422,1422,997,1030,117,152,151,164,315,199,228,
 893,911,997,1265,1431,903,892,1130,1112,1431,997,1265,39,4,
 39,334,209,209,715,769,900,900,1414,753,714,753,769,1414,900,
 900,32,32,344,281,276,1009,1439,1025,1022,1429,1437,1000,1027,
 1031,1435,1017,1009,32,336,273,271,1420,1010,1001,999,1425,
 1001,1425,999,1010,1420,1010,1010,350,272,347,911,954,1078,
 1477,1483,912,893,920,957,1483,1078,1477,357,356,1631,1617,
 1454,1451,1397,1619,1630,1630,1631,1375,1455,1453,294,1566,
 1577,1186,1416,1610,1581,1567,1567,1564,1610,1186,1416,1586,
 1600,1417,1203,1611,1603,1580,1580,1586,1612,1417,1203,1022,
 2383,2398,2422,1011,722,997,999,2421,2382,2389,2384,2403,2411,
 795,1014,1014,1022,2413,2396,2406,1070,1468,2392,2383,2383,
 2383,1467,892,1070,1460,2400,2395,2395,2398,1458,1070,898,2407,
 2423,2423,2422,1414,1467,1458,1008,1008,1011,2408,2394,2404,
 996,997,2423,2383,2395,723,2423,2383,2395,2421,2379,2393,1468,
 1459,1070,151,161,310,205,117,118,151,117,199,117,152,117,
 162,117,152,153,238,200,219,898,1373,714,741,819,1373,898,
 892,892,856,715,769,161,200,216,117,117,151,118,200,117,151,
 117,185,152,166,169,226,307,209,757,715,1366,900,926,714,740,
 714,715,926,1366,900,212,237,132,121,161,121,212,121,164,142,
 157,155,171,127,247,202,321,809,719,904,1399,992,742,846,742,
 719,992,904,1399,265,151,162,199,151,265,151,205,151,206,301,
 199,206,289,277,289,1182,1016,1495,1520,1520,1016,1182,1182,
 1182,1520,1495,1520,151,151,205,151,265,162,199,151,206,199,
 301,206,289,277,289,1016,1182,1495,1520,1520,1182,1016,1182,
 1182,1520,1495,1520,116,132,116,178,116,123,116,142,117,117,
 123,191,151,170,714,714,715,880,1063,714,714,1052,1052,1063,
 715,880,118,116,162,116,121,116,118,121,117,118,162,151,162,
 575,593,575,593,593,593,575,593,593,593,575,593,118,310,121,
 117,123,185,152,166,169,238,200,219,898,892,715,769,856,892,
 898,1373,1373,819,714,741,168,116,118,116,118,117,117,118,
 162,168,162,714,714,1044,731,731,714,714,1045,1046,731,1044,
 731,162,310,178,235,205,205,235,289,277,289,1182,1182,1495,
 1520,1520,1182,1182,1016,1016,1520,1495,1520,118,116,118,117,
 121,118,162,151,162,593,575,575,593,593,575,593,593,593,593,
 575,593,132,169,166,152,185,219,200,238,892,898,714,819,741,
 898,892,1373,1373,769,715,856,123,117,117,142,170,151,191,
 714,714,715,1063,880,714,714,1052,1052,880,715,1063,152,152,
 151,332,215,245,732,732,927,989,1408,715,715,791,833,1408,
 927,989,151,152,214,216,214,892,1368,757,757,757,1368,892,
 898,898,731,740,731,152,214,216,214,1368,892,740,731,731,892,
 1368,898,898,757,757,757,245,215,332,732,732,927,1408,989,
 715,715,791,833,989,927,1408,4,4,1535,1535,33,38,49,1535,
 1535,1535,1535,49,33,38,4,1497,1497,34,32,32,1497,1497,1497,
 1497,32,34,32,1535,1535,33,49,38,1535,1535,1535,1535,38,33,
 49,892,2322,2343,2343,892,575,892,892,2343,2322,2343,2322,
 2343,2343,575,892,892,892,2343,2322,2343,31,31,2322,2322,2322,
 2322,31,31,31,31,2343,2343,2343,2343,31,31,31,2343,2343,2343,
 2343,31,31,31,892,892,892,2343,2322,2343,892,892,2343,2322,
 2343,575,2343,2322,2343,2343,2322,2343,31,31,31,31,341,284,
 151,152,31,31,266,151,32,31,217,39,217,32,284,341,266,1030,
 1422,1427,996,1024,1427,1024,996,997,1030,1422,997,340,284,
 151,152,31,31,266,151,32,31,54,4,54,4,284,266,341,1024,
 1427,996,1427,1024,1422,1030,997,996,1030,997,1422,356,312,
 332,342,306,357,308,347,306,344,335,350,337,362,363,365,1451,
 1397,1630,1626,1613,1365,1453,1455,1454,1620,1627,1631,205,215,
 275,205,294,226,272,205,276,212,347,271,313,298,298,1203,
 1611,1580,1578,1603,1612,1203,1417,1417,1601,1586,1584,123,161,
 117,213,117,169,117,163,117,152,151,240,200,200,999,1426,894,
 894,1155,1426,999,1224,1224,1150,898,898,151,119,245,123,157,
 119,169,127,169,153,235,206,206,927,1408,716,716,801,1408,
 927,989,989,823,731,731,31,342,161,39,31,217,39,217,32,291,
 267,267,1077,1468,893,893,956,1468,1077,1468,1468,956,893,893,
 210,117,33,31,152,33,152,32,216,219,200,999,1423,1119,892,
 903,1423,999,1207,1207,911,1101,893,209,350,210,281,212,272,
 273,299,297,296,1416,1610,1567,1564,1582,1610,1416,1186,1186,
 1575,1568,1566,169,117,152,117,163,151,216,200,200,926,1366,
 714,714,740,1366,926,900,900,757,715,715,35,217,69,217,62,
 288,271,286,1078,1477,893,912,920,1477,1078,1483,1483,957,911,
 954,152,33,152,35,216,200,219,999,1423,892,1119,903,1423,999,
 1207,1207,911,893,1101,39,32,32,346,278,268,1022,1429,1027,
 1000,1436,1435,1009,1017,1025,1438,1031,1009,39,4,224,224,200,
 1042,1563,983,910,986,1563,1042,1042,1042,983,986,910,32,286,
 288,271,1477,1483,920,893,912,1483,1477,1078,1078,954,957,911,
 273,271,336,1010,1419,999,1425,1001,1425,999,1001,1010,1010,
 1010,1419,295,295,1607,1624,1291,1291,1113,1632,1608,1597,1592,
 1105,1293,1293,294,1595,1637,1080,1281,1284,1635,1589,1571,
 1572,1285,1074,1282,1587,1636,1281,1080,1284,1638,1596,1574,
 1570,1285,1282,1074,1460,2395,2384,2404,1457,898,1070,1070,
 2406,2390,2398,2423,2419,2408,1414,1457,1467,1468,2413,2421,
 2422,996,1008,2423,2395,2383,2383,1014,723,997,1008,2420,2387,
 2382,2380,1014,997,723,2407,2402,2392,2394,795,1011,1011,1460,
 1468,1467,2411,2422,2421,1070,1070,2401,2398,2393,892,2384,
 2383,2382,2396,2379,2383,1022,1022,999,267,291,151,151,31,31,
 267,151,32,31,217,32,217,39,275,342,342,956,893,1468,1468,
 1077,893,956,893,893,1077,1468,1468,295,200,214,266,205,294,
 200,271,200,279,343,274,271,298,363,296,1285,1074,1635,1571,
 1589,1080,1283,1281,1282,1595,1637,1572,216,216,284,232,295,
 238,273,216,292,281,351,288,313,362,299,1105,1293,1632,1597,
 1608,1291,1113,1291,1293,1607,1624,1592,117,58,39,225,117,32,
 117,71,152,62,152,228,315,199,911,893,1431,997,1265,892,903,
 1130,1111,1265,1431,997,152,119,214,117,155,117,166,171,166,
 152,205,302,199,757,757,1369,892,898,731,740,731,757,898,
 1369,892,4,341,161,4,31,79,32,79,32,284,340,266,1030,997,
 1422,997,1030,996,1024,1427,1422,1024,1427,996,251,123,4,31,
 70,32,70,32,219,324,201,933,898,1411,894,915,893,921,1175,
 1145,913,1415,893,219,336,219,292,276,287,285,298,365,296,
 1285,1282,1638,1574,1596,1281,1283,1080,1074,1587,1636,1570,
 153,117,166,152,189,152,205,310,199,856,715,1373,892,898,714,
 818,741,769,898,1373,892,35,62,62,62,62,271,337,273,1010,
 1010,1425,1001,999,999,1001,1425,1419,1010,1419,1010,166,32,
 166,35,205,306,210,911,893,1423,1207,999,892,903,1119,1101,
 999,1423,1207,217,79,217,354,354,269,979,936,1489,1079,1489,
 901,946,946,979,1489,1489,1079,217,54,278,346,268,1025,1428,
 1438,1009,1031,1435,1017,1009,1022,1027,1436,1000,217,287,348,
 274,1442,1026,1432,1019,1033,1019,1432,1033,1036,1036,1442,
 1026,272,347,350,957,911,1477,1483,1078,893,920,912,954,1078,
 1477,1483,356,294,1601,1586,1612,1417,1202,1580,1603,1578,1584,
 1202,1611,1417,357,1620,1627,1365,1455,1453,1630,1613,1626,
 1631,1451,1397,1454,1575,1568,1610,1186,1416,1567,1582,1564,
 1566,1416,1610,1186,1022,2411,2384,2401,1014,795,1014,1022,
 2406,2413,2396,2422,2383,2398,723,1011,997,999,2390,2421,2379,
 1468,1460,2423,2407,2420,2421,1457,1414,1467,1070,2383,2392,
 2382,2382,1070,1467,892,2395,2402,2387,2393,898,1457,1070,1008,
 996,997,2395,2423,2383,1008,1011,2404,2408,2394,723,2384,2419,
 2380,2398,2422,2383,1460,1070,1468,295,200,214,266,200,294,
 200,276,205,271,337,268,200,298,296,365,1284,1081,1573,1637,
 1596,1075,1285,1282,1281,1589,1570,1636,216,216,284,216,295,
 238,281,232,286,273,345,224,313,299,358,1110,1291,1592,1622,
 1606,1293,1107,1293,1291,1608,1599,1629,117,161,117,225,117,
 169,123,164,151,152,117,228,199,315,903,892,997,1431,1265,
 893,911,1112,1130,1265,997,1431,152,117,214,117,171,119,152,
 155,152,117,205,199,302,740,731,892,1369,898,757,757,757,731,
 898,892,1369,31,340,161,39,31,217,32,217,39,284,266,340,
 1024,996,997,1422,1030,997,1030,1422,1427,1024,996,1427,219,
 117,33,31,152,32,152,33,205,210,305,903,892,1207,1423,999,
 893,911,1101,1119,999,1207,1423,219,344,250,288,271,278,224,
 298,296,364,1283,1281,1570,1636,1589,1282,1285,1075,1081,1596,
 1573,1637,169,123,152,151,164,117,205,199,310,819,714,892,
 1373,898,715,856,769,741,898,892,1373,43,217,62,217,69,278,
 268,345,1017,1009,1000,1449,1027,1022,1025,1428,1435,1031,1009,
 1438,169,32,169,50,219,201,324,921,893,894,1411,915,898,933,
 1145,1175,913,893,1415,32,32,39,347,272,350,935,898,1078,
 1483,1477,899,928,951,933,1477,1078,1483,32,4,271,273,336,
 1001,1425,1010,1419,1010,1418,1010,1010,999,999,1001,1425,39,
 276,281,344,1436,1000,1017,1435,1009,1009,1438,1031,1027,1022,
 1025,1428,212,211,335,986,910,1042,1563,1042,910,983,987,984,
 1042,1042,1563,294,356,1602,1580,1417,1612,1203,1584,1605,1586,
 1579,1203,1417,1611,357,1582,1567,1186,1610,1416,1568,1575,
 1566,1564,1416,1186,1610,1613,1630,1455,1365,1453,1627,1620,
 1631,1626,1451,1454,1397,1008,2392,2407,2400,1011,795,1011,
 1008,2404,2394,2410,2383,2423,2395,723,1014,997,996,2395,2383,
 2423,1468,1070,2383,2384,2382,2382,1070,892,1467,1460,2422,
 2411,2421,2418,1457,1467,1414,2398,2403,2389,2387,898,1070,
 1457,1022,999,997,2393,2379,2421,1022,1014,2406,2396,2414,722,
 2398,2383,2422,2385,2379,2419,1070,1460,1468,265,4,294,265,4,
 4,294,265,294,357,357,294,338,338,338,56,56,1645,1645,1645,
 56,56,54,54,1645,1645,1645,170,203,151,270,151,219,151,207,
 315,199,200,290,277,277,1280,1073,1499,1499,1542,1073,1280,
 1452,1452,1542,1499,1499,245,170,4,4,247,170,219,321,209,219,
 289,289,289,33,49,1543,1543,1543,49,33,38,38,1543,1543,1543,
 201,357,202,212,201,274,350,269,268,299,296,296,1416,1186,
 1568,1566,1575,1186,1416,1610,1610,1582,1567,1564,270,151,219,
 151,200,309,199,200,277,290,277,1280,1073,1538,1496,1496,1073,
 1280,1452,1452,1493,1537,1493,4,356,270,295,356,294,295,338,
 338,338,54,57,1645,1645,1645,57,54,57,57,1645,1645,1645,215,
 151,200,307,202,200,277,277,277,32,34,1497,1497,1497,34,32,
 32,32,1497,1497,1497,221,278,353,272,287,298,298,313,1417,
 1203,1579,1604,1580,1203,1417,1611,1612,1584,1586,1601,200,315,
 199,208,277,277,290,1280,1073,1499,1542,1499,1073,1280,1452,
 1452,1499,1499,1542,340,266,267,365,298,296,1282,1074,1588,
 1571,1636,1081,1281,1283,1285,1638,1596,1572,342,339,365,359,
 365,1455,1375,1614,1631,1631,1397,1454,1451,1453,1630,1616,
 1630,266,296,299,296,1610,1186,1581,1567,1567,1186,1610,1416,
 1416,1566,1577,1564,296,298,365,1282,1076,1589,1634,1570,1082,
 1281,1283,1285,1574,1594,1637,338,338,1643,1534,1643,1643,1534,
 1515,1643,1643,1643,1534,1643,1643,338,1639,1532,1532,1639,
 1639,1532,1639,1639,1639,1639,1532,1639,1643,1515,1643,1534,
 1643,1534,1643,1643,1643,1643,1643,1534,42,2434,2434,2434,34,
 32,32,32,2432,2429,2432,2371,2352,2371,52,34,34,42,2342,2345,
 2319,1642,1642,2345,2430,2429,2434,1646,1561,1646,1640,2342,
 2432,2432,2434,1646,1646,1561,2319,2432,2432,2434,1561,1646,
 1646,42,42,34,2352,2371,2371,32,32,2434,2434,2434,32,2434,
 2434,2434,2432,2430,2432,1642,1640,1642,151,221,151,270,170,
 201,151,207,199,315,200,290,277,277,1073,1280,1494,1493,1536,
 1280,1073,1452,1452,1538,1496,1496,215,151,4,4,202,151,200,
 202,308,200,277,277,277,34,32,1503,1503,1503,32,34,32,32,
 1503,1503,1503,219,356,247,211,219,287,272,355,278,313,298,
 298,1203,1417,1584,1586,1605,1417,1203,1612,1611,1602,1580,
 1579,270,170,201,151,200,199,309,200,277,290,277,1073,1280,
 1542,1499,1499,1280,1073,1452,1452,1499,1542,1499,4,357,270,
 295,294,356,295,338,338,338,57,54,1644,1644,1644,54,57,57,
 57,1644,1644,1644,245,170,219,209,321,218,289,289,289,48,33,
 1535,1535,1535,33,49,38,38,1535,1535,1535,204,268,269,350,
 274,296,296,299,1186,1416,1564,1583,1567,1416,1186,1610,1610,
 1568,1564,1577,200,199,315,208,277,277,290,1073,1280,1496,
 1538,1496,1280,1073,1452,1452,1493,1494,1536,266,340,267,364,
 298,296,1074,1282,1596,1572,1638,1281,1081,1283,1285,1636,1588,
 1571,342,266,297,299,296,1186,1610,1577,1564,1566,1610,1186,
 1416,1416,1567,1581,1567,339,364,360,363,1375,1455,1619,1630,
 1630,1454,1397,1451,1453,1631,1617,1631,296,298,363,1076,1282,
 1594,1637,1574,1281,1082,1283,1285,1570,1589,1634,338,338,1533,
 1641,1641,1641,1505,1641,1505,1641,1641,1533,1641,1641,338,
 1534,1643,1515,1643,1643,1643,1534,1643,1643,1643,1534,1643,
 1493,1639,1639,1493,1639,1639,1532,1639,1639,1639,1639,1532,42,
 2345,2319,2342,34,52,34,42,2371,2371,2352,2430,2432,2432,32,
 34,32,32,2434,2434,2434,1642,1642,2434,2371,2434,2432,1646,
 1561,1646,1640,2434,2371,2434,2430,1646,1646,1561,2434,2352,
 2434,2429,1561,1646,1646,42,32,32,2430,2432,2428,42,34,2325,
 2341,2345,32,2432,2430,2432,2434,2434,2434,1642,1640,1642,142,
 116,191,116,142,116,132,132,117,117,178,151,151,715,880,714,
 714,1054,880,715,1063,1063,1054,714,714,50,300,148,50,142,62,
 163,71,164,258,208,208,918,895,914,914,1173,897,923,1365,
 1395,1170,906,907,194,116,31,116,46,117,32,117,175,175,151,
 714,714,1124,892,1124,714,714,1068,1068,1124,1124,892,191,324,
 194,258,228,228,240,277,290,290,1194,1193,1523,1523,1511,1194,
 1194,1044,1053,1493,1522,1521,138,116,132,117,131,117,178,151,
 151,880,715,714,714,1052,715,880,1063,1063,1052,714,714,142,
 43,185,32,185,249,205,232,894,915,893,921,1175,913,893,1415,
 1411,1145,898,933,132,117,117,132,175,151,175,714,714,892,
 1124,1124,714,714,1067,1067,1124,892,1124,160,58,160,300,221,
 204,914,914,918,895,1395,907,907,1170,1171,1365,923,897,151,
 151,225,216,200,997,1431,911,893,1111,1431,997,1265,1265,1130,
 903,892,151,225,216,200,1431,997,903,892,1130,997,1431,1265,
 1265,1112,911,893,213,205,312,898,898,999,1426,1224,894,894,
 1156,1151,1224,999,1426,270,270,1523,1523,1194,1194,1053,1522,
 1521,1493,1511,1044,1194,1194,265,1499,1499,1073,1280,1452,
 1499,1499,1542,1542,1452,1073,1280,1493,1494,1280,1073,1452,
 1496,1496,1538,1536,1452,1280,1073,996,2322,2319,2340,996,714,
 1210,1224,2363,2330,2330,2319,2322,2344,714,996,1210,1224,2363,
 2330,2330,996,1224,2330,2330,2363,2344,1210,714,996,1224,2330,
 2330,2363,2340,1210,996,714,2363,2363,2350,2319,1066,1210,1210,
 996,1224,1210,2344,2319,2322,1224,1210,2340,2322,2319,1066,
 2319,2344,2340,2350,2363,2363,1224,1224,996,138,332,142,127,
 138,185,157,185,162,235,206,206,927,989,731,731,823,989,927,
 1408,1408,801,716,716,191,116,142,116,117,135,117,117,151,
 178,151,715,880,1054,714,714,880,715,1063,1063,714,1054,714,
 4,321,191,238,247,226,238,289,289,289,33,38,1543,1543,1543,
 38,33,49,49,1543,1543,1543,142,116,117,132,132,117,151,151,
 151,31,31,575,575,575,31,31,31,31,575,575,575,148,164,166,
 163,189,212,212,237,904,992,729,813,729,992,904,1399,1399,
 735,734,844,117,131,117,131,151,151,178,715,880,714,1054,714,
 880,715,1063,1063,714,714,1054,160,151,151,311,205,199,715,
 769,898,892,1376,741,714,819,856,1376,898,892,160,160,212,
 237,212,904,1398,844,734,734,1399,904,992,991,728,813,728,
 151,200,216,200,1366,900,740,714,714,900,1366,926,926,715,
 757,715,199,205,311,715,769,898,1376,892,741,714,819,856,892,
 898,1376,265,265,1498,1524,1182,1182,1021,1524,1498,1524,1524,
 1020,1182,1182,265,1498,1524,1021,1182,1182,1524,1498,1524,
 1524,1182,1020,1182,1498,1524,1182,1021,1182,1524,1498,1524,
 1524,1182,1182,1020,31,2330,2330,2330,31,31,31,31,2330,2330,
 2330,2362,2362,2362,31,31,31,31,2362,2362,2362,892,892,2362,
 2330,2362,2362,892,575,892,892,2362,2330,2362,2362,892,892,
 575,2362,2330,2362,2362,575,892,892,31,31,31,2362,2362,2362,
 31,31,2330,2330,2330,31,2362,2362,2362,2362,2362,2362,892,892,
 892,325,142,4,31,70,32,70,32,232,250,205,915,894,1145,898,
 933,893,913,1415,1411,921,1175,893,321,335,324,348,347,355,
 345,358,365,364,1451,1454,1627,1631,1620,1455,1453,1365,1397,
 1613,1630,1626,127,142,189,163,182,164,237,212,212,992,904,
 742,742,846,904,992,1399,1399,809,719,719,50,69,69,69,69,
 224,200,224,1042,1042,910,987,983,1042,1042,1563,1563,986,910,
 984,185,32,185,43,232,205,250,913,893,898,1145,933,894,915,
 1411,1415,921,893,1175,217,79,217,348,287,274,1036,1026,1036,
 1026,1442,1019,1033,1432,1445,1432,1033,1019,217,54,288,286,
 271,1078,1483,954,911,957,1483,1078,1477,1477,920,912,893,217,
 292,292,279,1488,1079,966,917,961,1079,1488,1488,1488,966,961,
 916,281,276,344,1031,1009,1022,1428,1025,1000,1027,1449,1438,
 1017,1009,1435,295,295,1608,1599,1293,1293,1107,1592,1606,1622,
 1629,1110,1291,1291,294,1589,1570,1075,1282,1285,1573,1596,
 1637,1636,1283,1081,1281,1596,1573,1282,1075,1285,1570,1589,
 1636,1637,1283,1281,1081,1070,2393,2398,2406,1070,898,1457,
 1460,2404,2395,2385,2379,2383,2396,892,1070,1467,1468,2394,
 2383,2379,999,1022,2383,2398,2422,2421,1011,723,997,1022,2382,
 2389,2421,2422,1011,997,723,2384,2403,2411,2414,795,1014,1014,
 1070,1468,1467,2392,2383,2382,1460,1457,2400,2395,2387,1414,
 2407,2423,2418,2410,2423,2419,1008,1008,996,191,325,194,242,
 230,230,242,290,283,290,1193,1193,1507,1529,1529,1194,1194,
 1056,1056,1529,1517,1529,138,116,117,117,135,117,151,178,151,
 880,715,1052,714,714,715,880,1063,1063,714,1052,714,50,32,70,
 32,70,205,249,232,893,913,1175,920,893,915,894,1411,1415,898,
 1145,933,117,32,117,46,151,175,174,714,714,1124,1124,892,714,
 714,1068,1068,892,1124,1124,151,54,151,309,230,199,898,898,
 1268,997,1430,894,894,1162,1153,1430,1268,997,151,54,200,242,
 200,997,1430,1152,898,898,1430,997,1268,1268,894,1162,894,151,
 200,242,200,1430,997,1161,894,894,997,1430,1268,1268,898,1153,
 898,199,230,309,898,898,1268,1430,997,894,894,1163,1152,997,
 1268,1430,270,265,1499,1499,1452,1280,1073,1499,1499,1542,1542,
 1073,1452,1280,270,1521,1522,1053,1193,1193,1523,1523,1511,
 1493,1193,1043,1193,1499,1499,1452,1073,1280,1499,1499,1542,
 1542,1280,1452,1073,996,2363,2330,2330,996,714,1210,1224,2322,
 2340,2322,2363,2330,2330,714,996,1210,1224,2321,2344,2319,1224,
 1224,2339,2344,2327,2350,1210,1066,1210,996,2322,2320,2340,
 2363,996,1210,714,2322,2321,2339,2363,714,1210,996,996,1224,
 1210,2330,2363,2330,1224,1210,2330,2363,2330,1066,2363,2350,
 2363,2344,2319,2344,1224,996,1224,332,191,238,226,247,238,289,
 289,289,38,33,1535,1535,1535,33,37,48,48,1535,1535,1535,300,
 346,353,347,352,363,365,361,1455,1453,1626,1621,1630,1451,
 1454,1397,1365,1631,1627,1618,240,228,228,259,290,290,283,
 1194,1194,1521,1510,1522,1194,1193,1053,1044,1523,1523,1511,
 284,284,291,358,313,299,1293,1293,1608,1599,1632,1291,1291,
 1110,1105,1622,1607,1591,275,284,298,313,298,1417,1612,1605,
 1585,1584,1611,1417,1203,1203,1580,1602,1580,284,298,313,298,
 1612,1417,1603,1580,1580,1417,1611,1203,1203,1586,1600,1586,
 299,313,361,1293,1293,1609,1628,1597,1291,1291,1114,1106,1593,
 1606,1625,338,338,1639,1639,1639,1639,1532,1639,1639,1493,1532,
 1493,1639,1639,338,1643,1643,1534,1643,1643,1643,1643,1534,
 1534,1643,1515,1643,1641,1641,1641,1533,1641,1641,1641,1533,
 1505,1641,1641,1505,32,2430,2432,2432,32,32,34,42,2434,2434,
 2434,2432,2430,2428,32,32,34,42,2434,2434,2434,1642,1642,2434,
 2434,2371,2341,1646,1561,1646,1640,2434,2434,2371,2325,1646,
 1646,1561,2434,2434,2352,2345,1561,1646,1646,32,42,34,2432,
 2430,2432,42,34,2430,2432,2429,52,2319,2345,2342,2371,2371,
 2352,1642,1640,1642,142,162,185,157,185,206,206,235,989,927,
 715,791,715,927,989,1408,1408,732,732,833,117,117,131,132,
 151,151,178,880,715,714,1052,714,715,880,1063,1063,714,714,
 1052,151,161,151,310,205,199,769,715,898,892,1373,714,741,
 819,856,1373,898,892,160,151,200,216,200,900,1366,757,715,
 715,1366,900,926,926,714,740,714,161,212,237,212,1398,904,
 809,719,719,904,1399,992,991,742,846,742,199,205,310,769,715,
 898,1373,892,714,741,819,856,892,898,1373,265,265,1520,1495,
 1182,1182,1016,1495,1520,1520,1520,1016,1182,1182,265,1520,
 1495,1016,1182,1182,1495,1520,1520,1520,1182,1016,1182,1520,
 1495,1182,1016,1182,1495,1520,1520,1520,1182,1182,1016,31,2343,
 2343,2343,31,31,31,31,2343,2343,2343,2322,2322,2322,31,31,31,
 31,2322,2322,2322,892,892,2322,2343,2343,2343,892,575,892,892,
 2322,2343,2343,2343,892,892,575,2322,2343,2343,2343,575,892,
 892,31,31,31,2322,2322,2322,31,31,2343,2343,2343,31,2343,
 2343,2343,2343,2343,2343,892,892,892,163,71,164,68,208,208,
 259,896,923,906,1172,907,918,895,1395,1365,914,914,1174,217,
 54,217,343,276,281,1009,1031,1009,1017,1435,1027,1000,1437,
 1438,1429,1022,1025,217,79,279,292,292,1079,1487,961,966,916,
 1487,1079,1487,1487,916,966,961,217,271,286,288,1483,1078,912,
 920,893,1078,1483,1477,1477,911,954,957,274,287,352,1026,1036,
 1033,1448,1019,1033,1019,1448,1447,1026,1036,1447,294,295,1570,
 1589,1281,1284,1082,1594,1574,1637,1634,1076,1282,1285,295,
 1574,1594,1082,1283,1281,1589,1570,1634,1637,1282,1076,1285,
 1593,1606,1291,1114,1291,1609,1597,1628,1625,1293,1293,1106,
 1070,2381,2397,2383,1070,892,1467,1468,2382,2383,2386,2384,
 2405,2395,898,1070,1457,1460,2390,2398,2403,1008,996,2387,2382,
 2420,2419,997,723,1014,1007,2405,2397,2416,2417,1011,1011,795,
 2395,2383,2423,2423,723,997,1014,1070,1460,1457,2398,2393,2406,
 1468,1467,2383,2381,2396,1414,2422,2421,2412,2421,2422,2409,
 999,1022,1022,151,151,161,312,205,213,898,898,999,1224,1426,
 894,894,1154,1150,1426,999,1224,151,58,200,216,225,997,1431,
 911,1111,893,1431,997,1265,1265,892,903,1130,161,200,216,225,
 1431,997,903,1130,892,997,1431,1265,1265,893,911,1112,204,221,
 300,914,914,918,1395,895,907,906,1172,1174,897,923,1365,265,
 270,1493,1494,1280,1452,1073,1496,1496,1538,1536,1073,1280,
 1452,270,1499,1499,1073,1452,1280,1499,1499,1542,1542,1280,
 1073,1452,1523,1523,1194,1053,1194,1521,1522,1510,1511,1194,
 1193,1044,996,2321,2344,2322,996,714,1210,1224,2330,2330,2363,
 2322,2339,2321,714,996,1210,1224,2330,2330,2363,1224,996,2330,
 2330,2363,2339,996,714,1210,1224,2363,2363,2348,2327,1210,1210,
 1066,2330,2330,2363,2344,714,996,1210,996,1224,1210,2321,2322,
 2339,1224,1210,2322,2321,2344,1066,2344,2339,2327,2363,2363,
 2350,996,1224,1224,31,31,341,284,266,997,1421,1030,997,1422,
 1427,996,1024,1030,1427,1024,996,31,340,284,266,1421,997,1024,
 996,1427,996,1427,1024,1030,1422,1030,997,342,275,342,898,898,
 1077,1468,1468,892,892,939,968,1468,1077,1468,356,357,1627,
 1631,1451,1454,1397,1630,1626,1613,1615,1365,1453,1455,294,
 1586,1584,1203,1417,1611,1580,1578,1603,1605,1612,1203,1417,
 1564,1568,1416,1186,1610,1567,1565,1581,1576,1610,1416,1186,
 999,2393,2379,2421,997,716,1011,1022,2422,2398,2383,2398,2383,
 2422,716,997,1011,1022,2421,2393,2379,1070,1460,2395,2384,2404,
 2399,1457,898,1070,1468,2383,2381,2394,2388,1467,1070,892,2423,
 2419,2408,2411,1414,1456,1467,996,1008,1014,2423,2395,2383,
 1008,1014,2420,2387,2382,793,2407,2402,2391,2415,2406,2396,
 1460,1468,1070,31,267,291,267,1468,1468,956,893,893,1468,1468,
 1077,1077,893,956,893,266,284,341,997,1422,1030,1422,997,1427,
 996,1023,1030,996,1024,1427,295,294,1574,1638,1285,1282,1074,
 1635,1571,1589,1596,1080,1283,1281,295,1590,1623,1105,1293,
 1293,1632,1597,1608,1606,1291,1113,1291,1572,1637,1285,1074,
 1282,1636,1569,1588,1595,1281,1284,1080,1468,2396,2379,2382,
 1467,892,1070,1070,2383,2394,2383,2414,2421,2421,1414,1467,
 1458,1459,2423,2410,2423,1022,1022,2411,2384,2401,2406,1014,
 795,1014,999,2422,2383,2398,2390,997,1011,723,2422,2383,2398,
 2393,723,1011,997,1468,1460,1458,2423,2407,2423,1070,1070,2383,
 2392,2383,898,2395,2402,2395,2395,2404,2395,1008,996,1008,266,
 284,340,1422,997,1024,1427,996,996,1427,1023,1030,997,1030,
 1422,295,294,1633,1571,1284,1281,1081,1573,1637,1596,1588,1075,
 1285,1282,295,1632,1598,1110,1291,1291,1592,1622,1606,1609,
 1293,1107,1293,1636,1569,1284,1081,1281,1574,1638,1594,1589,
 1282,1285,1075,1468,2408,2423,2423,1467,1414,1458,1459,2421,
 2413,2421,2394,2383,2383,892,1467,1070,1070,2382,2396,2379,
 1008,1008,2392,2407,2400,2404,1011,795,1011,996,2383,2423,2395,
 2395,997,1014,723,2383,2423,2395,2395,723,1014,997,1468,1070,
 1070,2383,2384,2383,1460,1458,2422,2411,2422,898,2398,2403,
 2398,2389,2406,2393,1022,999,1022,294,357,1568,1564,1416,1610,
 1186,1564,1567,1583,1577,1186,1416,1610,356,1584,1586,1203,
 1611,1417,1579,1580,1604,1601,1417,1203,1612,1631,1627,1451,
 1397,1454,1626,1630,1621,1618,1455,1453,1365,999,2398,2422,
 2383,997,723,1011,1022,2382,2390,2421,2393,2421,2381,723,997,
 1011,1022,2383,2398,2422,1460,1070,2387,2395,2405,2406,1070,
 898,1457,1468,2420,2423,2416,2412,1467,1457,1414,2382,2383,
 2397,2396,892,1070,1467,996,1008,1014,2381,2384,2419,1008,1014,
 2383,2395,2423,795,2397,2405,2417,2386,2403,2409,1070,1468,
 1460,4,1645,1645,57,54,57,1645,1645,1645,1645,57,57,54,1644,
 1644,54,57,57,1644,1644,1644,1644,57,54,57,1642,2430,2432,
 2325,1646,1561,1646,1640,2371,2434,2434,2432,2430,2341,1561,
 1646,1646,1642,2371,2434,2434,32,42,2434,2434,2434,2428,34,32,
 32,42,2434,2434,2434,2432,34,32,32,2371,2352,2371,2345,52,34,
 34,1642,1642,1646,2345,2430,2432,1640,1646,2342,2432,2429,1561,
 2319,2432,2430,2352,2434,2434,42,42,32,1645,1645,57,57,54,
 1645,1645,1645,1645,54,57,57,1642,2352,2434,2434,1646,1561,
 1646,1640,2432,2342,2432,2371,2434,2434,1561,1646,1646,1642,
 2429,2345,2430,42,42,2345,2319,2342,2371,34,52,34,32,2429,
 2432,2432,2434,32,34,32,2430,2432,2432,2434,32,34,32,1642,
 1642,1646,2434,2371,2434,1640,1646,2434,2371,2434,1561,2434,
 2352,2434,2432,2319,2432,42,32,42,1642,2432,2319,2430,1646,
 1561,1646,1640,2434,2434,2371,2430,2345,2432,1561,1646,1646,
 1642,2434,2434,2371,41,32,2434,2434,2434,2432,32,32,34,42,
 2371,2352,2371,2342,34,34,52,2434,2434,2434,2429,32,32,34,
 1642,1642,1646,2430,2432,2341,1640,1646,2432,2428,2345,1561,
 2432,2430,2325,2434,2434,2352,32,42,42,2433,2433,2433,31,31,
 31,31,2433,2433,2433,2433,2433,2435,2426,2435,2431,2435,2426,
 2435,2431,2435,2426,2435,2431,2435,2435,2426,2435,2426,2435,
 2431,2426,2435,2435,31,31,31,2435,2435,2435,31,31,2426,2426,
 2426,31,2435,2435,2435,2431,2431,2431,2433,2431,2433,2433,2433,
 2426,2435,2435,2433,2435,2426,2435,2431,2426,2435,2435,2433,
 2435,2435,2426,2426,2435,2435,2433,2426,2435,2435,31,31,31,
 2426,2426,2426,31,31,2435,2435,2435,31,2435,2435,2435,2433,
 2433,2433,2433,2431,2433,31,2433,2433,2433,2433,31,31,31,2433,
 2433,2433,2433,31,31,31,2433,2433,2435,2435,2426,2435,2431,
 2435,2435,2426,2435,2426,2435,2426,2435,2435,2426,2435,31,31,
 31,2431,2431,2431,2431,31,31,31,2433,2433,2435,2435,2435,2426,
 2431,2435,2435,2435,2426,2426,2435,2435,2426,2435,2435,2426,31,
 31,31,2433,2433,2435,2426,2435,2435,2431,2435,2426,2435,2435,
 2426,2426,2435,2435,2426,2435,2435,31,31,31,31,31,2433,2433,
 2433,31,2433,2433,2433,2435,2435,2435,2433,2431,2433,31,2431,
 2431,2431,2435,2435,2435,2433,2431,2433,2426,2426,2426,2433,
 2431,2433,2433,2431,2433,31];

return List([1..52394],i->refinementseqlngsset[refinementseqlngspos[i]]);

#############################################################################
##
#E  refinementseqlngs.g . . . . . . . . . . . . . . . . . . . . . . ends here
