/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;

public class AWTUtil {
    private static boolean headlessMode;
    private static Method isOGLPipelineActive;
    private static Method isQueueFlusherThread;
    private static boolean j2dOk;
    private static boolean lockedToolkit;

    public static synchronized void lockToolkit() throws GLException {
        if (lockedToolkit) {
            throw new GLException("Toolkit already locked");
        }
        lockedToolkit = true;
        if (headlessMode) {
            return;
        }
        if (j2dOk) {
            try {
                if (!((Boolean)isOGLPipelineActive.invoke(null, (Object[])null)).booleanValue() || !((Boolean)isQueueFlusherThread.invoke(null, (Object[])null)).booleanValue()) {
                    NativeWindowFactory.getAWTToolkitLock().lock();
                }
            }
            catch (Exception exception) {
                j2dOk = false;
            }
        }
        if (!j2dOk) {
            NativeWindowFactory.getAWTToolkitLock().lock();
        }
    }

    public static synchronized void unlockToolkit() {
        if (lockedToolkit) {
            lockedToolkit = false;
            if (headlessMode) {
                return;
            }
            if (j2dOk) {
                try {
                    if (!((Boolean)isOGLPipelineActive.invoke(null, (Object[])null)).booleanValue() || !((Boolean)isQueueFlusherThread.invoke(null, (Object[])null)).booleanValue()) {
                        NativeWindowFactory.getAWTToolkitLock().unlock();
                    }
                }
                catch (Exception exception) {
                    j2dOk = false;
                }
            }
            if (!j2dOk) {
                NativeWindowFactory.getAWTToolkitLock().unlock();
            }
        }
    }

    static {
        isOGLPipelineActive = null;
        isQueueFlusherThread = null;
        j2dOk = false;
        lockedToolkit = false;
        headlessMode = GraphicsEnvironment.isHeadless();
        if (!headlessMode) {
            try {
                Class<?> clazz = Class.forName("jogamp.opengl.awt.Java2D");
                isOGLPipelineActive = clazz.getMethod("isOGLPipelineActive", null);
                isQueueFlusherThread = clazz.getMethod("isQueueFlusherThread", null);
                j2dOk = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

