/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLineHelper;
import jogamp.opengl.util.pngj.PngjExceptionInternal;

public class ImageLine {
    public final ImageInfo imgInfo;
    private int rown = 0;
    public final int[] scanline;
    public final byte[] scanlineb;
    protected FilterType filterUsed;
    final int channels;
    final int bitDepth;
    final int elementsPerRow;
    public final SampleType sampleType;
    public final boolean samplesUnpacked;

    public ImageLine(ImageInfo imageInfo) {
        this(imageInfo, SampleType.INT, false);
    }

    public ImageLine(ImageInfo imageInfo, SampleType sampleType, boolean bl) {
        this(imageInfo, sampleType, bl, null, null);
    }

    ImageLine(ImageInfo imageInfo, SampleType sampleType, boolean bl, int[] nArray, byte[] byArray) {
        this.imgInfo = imageInfo;
        this.channels = imageInfo.channels;
        this.bitDepth = imageInfo.bitDepth;
        this.filterUsed = FilterType.FILTER_UNKNOWN;
        this.sampleType = sampleType;
        this.samplesUnpacked = bl || !imageInfo.packed;
        int n = this.elementsPerRow = this.samplesUnpacked ? imageInfo.samplesPerRow : imageInfo.samplesPerRowPacked;
        if (sampleType == SampleType.INT) {
            this.scanline = nArray != null ? nArray : new int[this.elementsPerRow];
            this.scanlineb = null;
        } else if (sampleType == SampleType.BYTE) {
            this.scanlineb = byArray != null ? byArray : new byte[this.elementsPerRow];
            this.scanline = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
        this.rown = -1;
    }

    public int getRown() {
        return this.rown;
    }

    public void setRown(int n) {
        this.rown = n;
    }

    static void unpackInplaceInt(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl) {
        int n;
        int n2;
        int n3 = imageInfo.bitDepth;
        if (n3 >= 8) {
            return;
        }
        int n4 = ImageLineHelper.getMaskForPackedFormatsLs(n3);
        int n5 = 8 - n3;
        int n6 = 8 * imageInfo.samplesPerRowPacked - n3 * imageInfo.samplesPerRow;
        if (n6 != 8) {
            n2 = n4 << n6;
            n = n6;
        } else {
            n2 = n4;
            n = 0;
        }
        int n7 = imageInfo.samplesPerRowPacked - 1;
        for (int i = imageInfo.samplesPerRow - 1; i >= 0; --i) {
            int n8 = (nArray[n7] & n2) >> n;
            if (bl) {
                n8 <<= n5;
            }
            nArray2[i] = n8;
            n2 <<= n3;
            if ((n += n3) != 8) continue;
            n2 = n4;
            n = 0;
            --n7;
        }
    }

    static void packInplaceInt(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl) {
        int n = imageInfo.bitDepth;
        if (n >= 8) {
            return;
        }
        int n2 = ImageLineHelper.getMaskForPackedFormatsLs(n);
        int n3 = 8 - n;
        int n4 = 8 - n;
        int n5 = 8 - n;
        int n6 = nArray[0];
        nArray2[0] = 0;
        if (bl) {
            n6 >>= n3;
        }
        n6 = (n6 & n2) << n5;
        int n7 = 0;
        for (int i = 0; i < imageInfo.samplesPerRow; ++i) {
            int n8 = nArray[i];
            if (bl) {
                n8 >>= n3;
            }
            int n9 = n7++;
            nArray2[n9] = nArray2[n9] | (n8 & n2) << n5;
            if ((n5 -= n) >= 0) continue;
            n5 = n4;
            nArray2[n7] = 0;
        }
        nArray2[0] = nArray2[0] | n6;
    }

    static void unpackInplaceByte(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl) {
        int n;
        int n2;
        int n3 = imageInfo.bitDepth;
        if (n3 >= 8) {
            return;
        }
        int n4 = ImageLineHelper.getMaskForPackedFormatsLs(n3);
        int n5 = 8 - n3;
        int n6 = 8 * imageInfo.samplesPerRowPacked - n3 * imageInfo.samplesPerRow;
        if (n6 != 8) {
            n2 = n4 << n6;
            n = n6;
        } else {
            n2 = n4;
            n = 0;
        }
        int n7 = imageInfo.samplesPerRowPacked - 1;
        for (int i = imageInfo.samplesPerRow - 1; i >= 0; --i) {
            int n8 = (byArray[n7] & n2) >> n;
            if (bl) {
                n8 <<= n5;
            }
            byArray2[i] = (byte)n8;
            n2 <<= n3;
            if ((n += n3) != 8) continue;
            n2 = n4;
            n = 0;
            --n7;
        }
    }

    static void packInplaceByte(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl) {
        int n = imageInfo.bitDepth;
        if (n >= 8) {
            return;
        }
        int n2 = ImageLineHelper.getMaskForPackedFormatsLs(n);
        int n3 = 8 - n;
        int n4 = 8 - n;
        int n5 = 8 - n;
        int n6 = byArray[0];
        byArray2[0] = 0;
        if (bl) {
            n6 >>= n3;
        }
        n6 = (n6 & n2) << n5;
        int n7 = 0;
        for (int i = 0; i < imageInfo.samplesPerRow; ++i) {
            int n8 = byArray[i];
            if (bl) {
                n8 >>= n3;
            }
            int n9 = n7++;
            byArray2[n9] = (byte)(byArray2[n9] | (n8 & n2) << n5);
            if ((n5 -= n) >= 0) continue;
            n5 = n4;
            byArray2[n7] = 0;
        }
        byArray2[0] = (byte)(byArray2[0] | n6);
    }

    public ImageLine unpackToNewImageLine() {
        ImageLine imageLine = new ImageLine(this.imgInfo, this.sampleType, true);
        if (this.sampleType == SampleType.INT) {
            ImageLine.unpackInplaceInt(this.imgInfo, this.scanline, imageLine.scanline, false);
        } else {
            ImageLine.unpackInplaceByte(this.imgInfo, this.scanlineb, imageLine.scanlineb, false);
        }
        return imageLine;
    }

    public ImageLine packToNewImageLine() {
        ImageLine imageLine = new ImageLine(this.imgInfo, this.sampleType, false);
        if (this.sampleType == SampleType.INT) {
            ImageLine.packInplaceInt(this.imgInfo, this.scanline, imageLine.scanline, false);
        } else {
            ImageLine.packInplaceByte(this.imgInfo, this.scanlineb, imageLine.scanlineb, false);
        }
        return imageLine;
    }

    public FilterType getFilterUsed() {
        return this.filterUsed;
    }

    public void setFilterUsed(FilterType filterType) {
        this.filterUsed = filterType;
    }

    public int[] getScanlineInt() {
        return this.scanline;
    }

    public byte[] getScanlineByte() {
        return this.scanlineb;
    }

    public String toString() {
        return "row=" + this.rown + " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + this.scanline.length;
    }

    public static void showLineInfo(ImageLine imageLine) {
        System.out.println(imageLine);
        ImageLineHelper.ImageLineStats imageLineStats = new ImageLineHelper.ImageLineStats(imageLine);
        System.out.println(imageLineStats);
        System.out.println(ImageLineHelper.infoFirstLastPixels(imageLine));
    }

    public static enum SampleType {
        INT,
        BYTE;

    }
}

