/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import org.fibs.geotag.data.ImageInfo;

public enum Orientation {
    NORMAL(false),
    FLIP_LEFT_RIGHT(false),
    ROTATE_180(false),
    FLIP_UP_DOWN(false),
    ROTATE_90_CLOCKWISE_FLIP_LEFT_RIGHT(true),
    ROTATE_90_CLOCKWISE(true),
    FLIP_UP_DOWN_ROTATE_90_ANTICLOCK(true),
    ROTATE_90_ANTICLOCK(true);

    private boolean changesAspect;

    private Orientation(boolean changesAspect) {
        this.changesAspect = changesAspect;
    }

    static Orientation getOrientation(ImageInfo imageInfo) {
        int exifvalue = 1;
        if (imageInfo != null) {
            try {
                exifvalue = Integer.parseInt(imageInfo.getOrientation());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (exifvalue < 1 || exifvalue > Orientation.values().length) {
            return NORMAL;
        }
        return Orientation.values()[exifvalue - 1];
    }

    public boolean changesAspect() {
        return this.changesAspect;
    }
}

