/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortRBTreeSet;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnIterable;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.IndexStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.TableImpl;
import org.gephi.graph.impl.TableLock;
import org.gephi.graph.impl.TableObserverImpl;

public class ColumnStore<T extends Element>
implements ColumnIterable {
    protected static final int MAX_SIZE = 65534;
    protected static final int NULL_ID = -1;
    protected static final short NULL_SHORT = Short.MIN_VALUE;
    protected final GraphStore graphStore;
    protected final Configuration configuration;
    protected final Class<T> elementType;
    protected final Object2ShortMap<String> idMap;
    protected final ColumnImpl[] columns;
    protected final ShortSortedSet garbageQueue;
    protected final IndexStore<T> indexStore;
    protected final List<TableObserverImpl> observers;
    protected final TableLock lock;
    protected int length;

    public ColumnStore(Class<T> elementType, boolean indexed) {
        this(null, elementType, indexed);
    }

    public ColumnStore(GraphStore graphStore, Class<T> elementType, boolean indexed) {
        this.graphStore = graphStore;
        this.configuration = graphStore != null ? graphStore.configuration : new Configuration();
        this.lock = new TableLock();
        this.garbageQueue = new ShortRBTreeSet();
        this.idMap = new Object2ShortOpenHashMap(65534);
        this.columns = new ColumnImpl[65534];
        this.elementType = elementType;
        this.indexStore = indexed ? new IndexStore(this) : null;
        this.idMap.defaultReturnValue((short)Short.MIN_VALUE);
        this.observers = new ArrayList<TableObserverImpl>();
    }

    private void updateConfiguration(Column changedColumn) {
        String columnId = changedColumn.getId();
        if (Edge.class.equals(this.elementType)) {
            if (columnId.equals("weight")) {
                if (this.hasColumn(columnId)) {
                    Class edgeWeightColumnClass = this.getColumn(columnId).getTypeClass();
                    this.configuration.setEdgeWeightType(edgeWeightColumnClass);
                    this.configuration.setEdgeWeightColumn(true);
                } else {
                    this.configuration.setEdgeWeightColumn(false);
                }
            } else if (columnId.equals("id")) {
                this.configuration.setEdgeIdType(changedColumn.getTypeClass());
            }
        } else if (Node.class.equals(this.elementType) && columnId.equals("id")) {
            this.configuration.setNodeIdType(changedColumn.getTypeClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(Column column) {
        block8: {
            this.checkNonNullColumnObject(column);
            this.checkIndexStatus(column);
            this.lock();
            try {
                ColumnImpl columnImpl = (ColumnImpl)column;
                short id = this.idMap.getShort((Object)columnImpl.getId());
                if (id == Short.MIN_VALUE) {
                    if (!this.garbageQueue.isEmpty()) {
                        id = this.garbageQueue.firstShort();
                        this.garbageQueue.remove(id);
                    } else {
                        id = this.intToShort(this.length);
                        if (this.length >= 65534) {
                            throw new RuntimeException("Maximum number of columns reached at 65534");
                        }
                        ++this.length;
                    }
                    this.idMap.put((Object)column.getId(), id);
                    int intIndex = this.shortToInt(id);
                    columnImpl.setStoreId(intIndex);
                    this.columns[intIndex] = columnImpl;
                    if (this.indexStore != null) {
                        this.indexStore.addColumn(columnImpl);
                    }
                    this.updateConfiguration(column);
                    break block8;
                }
                throw new IllegalArgumentException("The column already exist");
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumn(Column column) {
        this.checkNonNullColumnObject(column);
        this.lock();
        this.graphWriteLock();
        try {
            short id;
            ColumnImpl columnImpl = (ColumnImpl)column;
            if (this.graphStore != null && columnImpl.table != null) {
                if (AttributeUtils.isNodeColumn(columnImpl)) {
                    for (Node n : this.graphStore.nodeStore) {
                        Object[] attributes = ((NodeImpl)n).attributes;
                        if (attributes.length <= columnImpl.getIndex()) continue;
                        attributes[columnImpl.getIndex()] = null;
                    }
                } else {
                    for (Edge e : this.graphStore.edgeStore) {
                        Object[] attributes = ((EdgeImpl)e).attributes;
                        if (attributes.length <= columnImpl.getIndex()) continue;
                        attributes[columnImpl.getIndex()] = null;
                    }
                }
            }
            if ((id = this.idMap.removeShort((Object)column.getId())) == Short.MIN_VALUE) {
                throw new IllegalArgumentException("The column doesnt exist");
            }
            this.garbageQueue.add(id);
            int intId = this.shortToInt(id);
            this.columns[intId] = null;
            if (this.indexStore != null) {
                this.indexStore.removeColumn((ColumnImpl)column);
            }
            columnImpl.setStoreId(-1);
            this.updateConfiguration(column);
        }
        finally {
            this.graphWriteUnlock();
            this.unlock();
        }
    }

    public void removeColumn(String key) {
        this.checkNonNullObject(key);
        this.lock();
        try {
            this.removeColumn(this.getColumn(key));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnIndex(String key) {
        this.checkNonNullObject(key);
        this.lock();
        try {
            short id = this.idMap.getShort((Object)key.toLowerCase());
            if (id == Short.MIN_VALUE) {
                throw new IllegalArgumentException("The column doesnt exist");
            }
            int n = this.shortToInt(id);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column getColumnByIndex(int index) {
        this.lock();
        try {
            if (index < 0 || index >= this.columns.length) {
                throw new IllegalArgumentException("The column doesnt exist");
            }
            ColumnImpl a = this.columns[index];
            if (a == null) {
                throw new IllegalArgumentException("The column doesnt exist");
            }
            ColumnImpl columnImpl = a;
            return columnImpl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column getColumn(String key) {
        this.checkNonNullObject(key);
        this.lock();
        try {
            short id = this.idMap.getShort((Object)key.toLowerCase());
            if (id == Short.MIN_VALUE) {
                Column column = null;
                return column;
            }
            ColumnImpl columnImpl = this.columns[this.shortToInt(id)];
            return columnImpl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean hasColumn(String key) {
        this.checkNonNullObject(key);
        this.lock();
        try {
            boolean bl = this.idMap.containsKey((Object)key.toLowerCase());
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Iterator<Column> iterator() {
        return new ColumnStoreIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnImpl[] toArray() {
        this.lock();
        try {
            ColumnImpl[] cols = new ColumnImpl[this.size()];
            int j = 0;
            for (int i = 0; i < this.length; ++i) {
                ColumnImpl c = this.columns[i];
                if (c == null) continue;
                cols[j++] = c;
            }
            ColumnImpl[] columnImplArray = cols;
            return columnImplArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Column> toList() {
        this.lock();
        try {
            ArrayList<Column> cols = new ArrayList<Column>(this.size());
            for (int i = 0; i < this.length; ++i) {
                ColumnImpl c = this.columns[i];
                if (c == null) continue;
                cols.add(c);
            }
            ArrayList<Column> arrayList = cols;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void doBreak() {
        this.unlock();
    }

    public Set<String> getColumnKeys() {
        this.lock();
        try {
            ObjectOpenHashSet objectOpenHashSet = new ObjectOpenHashSet((ObjectCollection)this.idMap.keySet());
            return objectOpenHashSet;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock();
        try {
            if (this.graphStore != null) {
                List<Column> cols = this.toList();
                int[] indices = new int[cols.size()];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = cols.get(i).getIndex();
                }
                if (this.graphStore.nodeTable.store == this) {
                    for (Node n : this.graphStore.nodeStore) {
                        Object[] atts = ((NodeImpl)n).attributes;
                        for (int i = 0; i < indices.length; ++i) {
                            atts[indices[i]] = null;
                        }
                    }
                } else {
                    for (Edge e : this.graphStore.edgeStore) {
                        Object[] atts = ((EdgeImpl)e).attributes;
                        for (int i = 0; i < indices.length; ++i) {
                            atts[indices[i]] = null;
                        }
                    }
                }
            }
            this.garbageQueue.clear();
            this.idMap.clear();
            this.length = 0;
            Arrays.fill(this.columns, null);
            if (this.indexStore != null) {
                this.indexStore.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    public int size() {
        return this.length - this.garbageQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableObserverImpl createTableObserver(TableImpl table, boolean withDiff) {
        if (this.observers != null) {
            this.lock();
            try {
                TableObserverImpl observer = new TableObserverImpl(table, withDiff);
                this.observers.add(observer);
                TableObserverImpl tableObserverImpl = observer;
                return tableObserverImpl;
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    protected void destroyTablesObserver(TableObserverImpl observer) {
        if (this.observers != null) {
            this.lock();
            try {
                this.observers.remove(observer);
                observer.destroyObserver();
            }
            finally {
                this.unlock();
            }
        }
    }

    short intToShort(int id) {
        return (short)(id + Short.MIN_VALUE + 1);
    }

    int shortToInt(short id) {
        return id - Short.MIN_VALUE - 1;
    }

    void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    void graphWriteLock() {
        if (this.graphStore != null) {
            this.graphStore.autoWriteLock();
        }
    }

    void graphWriteUnlock() {
        if (this.graphStore != null) {
            this.graphStore.autoWriteUnlock();
        }
    }

    void checkNonNullObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    void checkNonNullColumnObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof ColumnImpl)) {
            throw new ClassCastException("Must be ColumnImpl object");
        }
    }

    void checkIndexStatus(Column column) {
        if (this.indexStore == null && column.isIndexed()) {
            throw new IllegalArgumentException("Can't add an indexed column to a non indexed store");
        }
    }

    public boolean deepEquals(ColumnStore<T> obj) {
        if (obj == null) {
            return false;
        }
        if (!(this.elementType == obj.elementType || this.elementType != null && this.elementType.equals(obj.elementType))) {
            return false;
        }
        Iterator<Column> itr1 = this.iterator();
        Iterator<Column> itr2 = obj.iterator();
        while (itr1.hasNext()) {
            Column c2;
            if (!itr2.hasNext()) {
                return false;
            }
            Column c1 = itr1.next();
            if (c1.equals(c2 = itr2.next())) continue;
            return false;
        }
        return true;
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 11 * hash + (this.elementType != null ? this.elementType.hashCode() : 0);
        ColumnStoreIterator itr = new ColumnStoreIterator();
        while (itr.hasNext()) {
            hash = 11 * hash + itr.next().deepHashCode();
        }
        return hash;
    }

    private final class ColumnStoreIterator
    implements Iterator<Column> {
        private int index;
        private ColumnImpl pointer;

        public ColumnStoreIterator() {
            ColumnStore.this.lock();
        }

        @Override
        public boolean hasNext() {
            while (this.index < ColumnStore.this.length && (this.pointer = ColumnStore.this.columns[this.index++]) == null) {
            }
            if (this.pointer == null) {
                ColumnStore.this.unlock();
                return false;
            }
            return true;
        }

        @Override
        public ColumnImpl next() {
            ColumnImpl c = this.pointer;
            this.pointer = null;
            return c;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

