/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import javax.swing.JPanel;
import org.gephi.statistics.plugin.Hits;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.HitsPanel;
import org.openide.util.NbBundle;

public class HitsUI
implements StatisticsUI {
    private final StatSettings settings = new StatSettings();
    private HitsPanel panel;
    private Hits hits;

    public JPanel getSettingsPanel() {
        this.panel = new HitsPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.hits = (Hits)statistics;
        if (this.panel != null) {
            this.settings.load(this.hits);
            this.panel.setEpsilon(this.hits.getEpsilon());
            this.panel.setDirected(!this.hits.getUndirected());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.hits.setEpsilon(this.panel.getEpsilon());
            this.hits.setUndirected(!this.panel.isDirected());
            this.settings.save(this.hits);
        }
        this.panel = null;
        this.hits = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return Hits.class;
    }

    public String getValue() {
        return null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"HitsUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_NETWORK_OVERVIEW;
    }

    public int getPosition() {
        return 500;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"HitsUI.shortDescription");
    }

    private static class StatSettings {
        private double epsilon = 1.0E-4;

        private StatSettings() {
        }

        private void save(Hits stat) {
            this.epsilon = stat.getEpsilon();
        }

        private void load(Hits stat) {
            stat.setEpsilon(this.epsilon);
        }
    }
}

